//=============================================================================
/**
 * @file	comm_union.c
 * @brief	jI[䏈
 * @author	Akito Mori
 * @date    2005.12.10
 */
//=============================================================================

#include "common.h"
#include "communication/communication.h"
#include "communication/comm_state.h"
#include "fieldsys.h"
#include "field/field.h"
#include "../fielddata/script/connect_def.h"
#include "../fielddata/script/union_def.h"
#include "system/wordset.h"
#include "system/pms_data.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_trtype.h"
#include "msgdata/msg_union.h"

#include "comm_command_field.h"
#include "comm_union_def.h"
#include "script.h"
#include "comm_union_beacon.h"
#include "field/union_beacon_tool.h"

#include "../application/oekaki/comm_command_oekaki.h"


#define UNION_PRINT_ON

#ifdef UNION_PRINT_ON

#define PRINT( str ) 			OS_Printf( str )
#define PRINT2( str , param) 	OS_Printf( str , param )

#else

#define PRINT( str ) 
#define PRINT2( str , param) 


#endif

//==============================================================================
//	萔錾
//==============================================================================
#define TALK_OBJ_MAX			( 10 )
#define SUB_OBJ_MAX				( TALK_OBJ_MAX*4 )
#define _PARENT_WAIT_TIME 	 	( 40 ) ///eƂĂ̂т҂
#define _CHILD_P_SEARCH_TIME 	( 12 )
#define _FINALIZE_TIME 			(  2 )
#define _EXIT_SENDING_TIME 		(  5 )
#define _CONNECT_RETRY_NUM 		(  2 )
#define _CHILD_CONNECT_WAIT		( 3*60 )

#define PARENT_UNIONROOM_TGID	( 0x1234 )


enum{
	NO_OBJ=0,
	FALL_OBJ,
	TALKOK_OBJ,
	RISE_OBJ,
};

#define START_TIME ( 40 )
#define _TCB_UNIONSTATE_PRT   (10)    ///< tB[hʐM̊Ď[`PRI

enum{
	DS_CONNECT_START=1,
	MP_CONNECT_START,
};

//==============================================================================
//	^錾
//==============================================================================

// R[obN֐̏
typedef void (*PUnionRoomFunc)(COMM_UNIONROOM_WORK *cuw);


// bOBJ̍\
typedef struct{
	u16 arrow;
	u16 status;
}MAIN_OBJ_CONT;

// bOBJ̎ɂTuOBJ̍\
typedef struct{
	u16 arrow;
	u16 status;
}SUB_OBJ_CONT;

// jI[p[N\
struct COMM_UNIONROOM_WORK{
	FIELDSYS_WORK		*fsys;
	SAVEDATA			*savedata;
	MYSTATUS			*mystatus;
	
	TCB_PTR	           UnionStateTask;
	PUnionRoomFunc     state;
	int                timer;

	u32					CommConnectId;				// ڑɂOBJID
	u32					CommConnectResult;			// ڑʂԂ
	int 				CommConnectStartFlag;
	int 				CommConnectStartWait;
	int					CommConnectRetry;
	int					CommNextProcOn;
	u32					CommChildSelectEvent;
	u32					ScriptSelectWork;			// Iʂۑ
	u32					InviteWork;					// ʐMŒ񎦂ꂽeۑ
	u32					ScriptYesNoWork;			// ͂Ěʂۑ

	u32					UnionEventWork;				// seiJ[hE퓬EE`bgj
	u32					UnionEndConnectFlag;		// ʐMI
	
	MAIN_OBJ_CONT	   MainObjCont[TALK_OBJ_MAX];		// bPOl
	SUB_OBJ_CONT	   SubObjCont[SUB_OBJ_MAX];		// C̎ɂSliPOj
	WMBssDesc		   *UnionBeaconTbl[SCAN_PARENT_COUNT_MAX];

	MATHRandContext32  pRand;						// WEPL[
	int connectIndex;

	int objwork;
	int objwait;

	int busyflag;

	PMS_DATA			MyPmsData;					// X^[gj[́u`bgvŊȈՉbݒ肵ꍇ
	BOOL				MyPmsPutFlag;				// ̗̈ɍ쐬ȈՉbRs[

#ifdef PM_DEBUG
    u32					debugTimer;
#endif
};


/*** ֐vg^Cv ***/
static COMM_UNIONROOM_WORK* _commStateInitialize(FIELDSYS_WORK* fsys);
static void _UnionStart(COMM_UNIONROOM_WORK *cuw);
static void _UnionRestart( COMM_UNIONROOM_WORK *cuw );
static void _changeState(COMM_UNIONROOM_WORK *cuw, PUnionRoomFunc state, int time);
static void _stateConnectEnd(COMM_UNIONROOM_WORK *cuw);
static void _stateEnd(COMM_UNIONROOM_WORK *cuw);
static void CommStateFinalize(COMM_UNIONROOM_WORK *cuw);
static void _underChildConnecting(COMM_UNIONROOM_WORK *cuw);
static void _underParentInfoSend(COMM_UNIONROOM_WORK *cuw);
static void _underParentConnect(COMM_UNIONROOM_WORK *cuw);
static void  _underChildSelectWait(COMM_UNIONROOM_WORK *cuw);
static void _ConnectInfoClear( COMM_UNIONROOM_WORK *cuw );
static void CommUnion_EventFlagClear( COMM_UNIONROOM_WORK *cuw);
static int  MyStatusCheck( void );


static void UnionBeaconClear( UNION_BEACON_STATE *beacon );






//==============================================================================
/**
 * jI[ɂ͂̒ʐM
 * @param   pFSys FIELDSYS_WORK
 * @retval  none
 */
//==============================================================================
COMM_UNIONROOM_WORK *Comm_UnionRoomInit(FIELDSYS_WORK* fsys)
{

	COMM_UNIONROOM_WORK *cuw = NULL;

	GF_ASSERT(fsys!=NULL && "fsysNULL");

    if(fsys->union_work!=NULL){ // ȂĂꍇ͏O
        return NULL;
    }
    // ʐMq[v쐬
    if(sys_CreateHeap( HEAPID_BASE_APP, HEAPID_UNIONROOM, 0xa00 )){
		OS_Printf("HEAPID_UNION 쐬\n");
	}

	// jI[[Nm
    cuw = _commStateInitialize(fsys);
	if(cuw==NULL){
		cuw = fsys->union_work;
	}

	// tB[hpʐMR}hR[obNݒ
    CommCommandFieldInitialize((void*)fsys);


//  CommStateUnionBconCollection( SaveData_GetMyStatus(GameSystem_GetSaveData(fsys)) );

    // nXe[g̑Jڂ̂ߏ
	PRINT("Unionq@Jn\n");
    _changeState(cuw, _UnionStart, START_TIME);
	OS_Printf("sizeof(MYSTATUS)=%d \n",MyStatus_GetWorkSize());

	return cuw;
}
#ifdef PM_DEBUG

static COMM_UNIONROOM_WORK *debug_cuw;

#endif
//==============================================================================
/**
 * jI[oƂ
 *
 * @param   fsys		
 *
 * @retval  none		
 */
//==============================================================================
void Comm_UnionFinalize(FIELDSYS_WORK *fsys)
{
    if(fsys->union_work==NULL){  // łɏIĂ
       return;
    }
    _changeState(fsys->union_work, _stateConnectEnd, _EXIT_SENDING_TIME);
}


//------------------------------------------------------------------
/**
 * jI[V[PX
 *
 * @param   fsys		
 *
 * @retval  COMM_UNIONROOM_WORK*		
 */
//------------------------------------------------------------------
static COMM_UNIONROOM_WORK* _commStateInitialize(FIELDSYS_WORK* fsys)
{
    void* pWork;
	SAVEDATA *savedata;
	MYSTATUS *mystatus;
	COMM_UNIONROOM_WORK *cuw = NULL;

    if(fsys->union_work!=NULL){   // łɃjI쒆̏ꍇ͌̃mۏKvȂ
        return NULL;
    }
	savedata = GameSystem_GetSaveData(fsys);
	mystatus = SaveData_GetMyStatus(savedata);

    // UNION[BCONWJn
    CommStateUnionBconCollection( mystatus );


    // 
    cuw = (COMM_UNIONROOM_WORK*)sys_AllocMemory(HEAPID_UNIONROOM, sizeof(COMM_UNIONROOM_WORK));
	MI_CpuClear8(cuw, sizeof(COMM_UNIONROOM_WORK) );
    cuw->state = NULL;   // Ȃ
    cuw->timer = START_TIME;
    cuw->UnionStateTask = TCB_Add(_commCheckFunc, cuw, _TCB_UNIONSTATE_PRT);
    cuw->fsys     = fsys;
	cuw->savedata = savedata;
	cuw->mystatus = mystatus;

	CommUnion_EventFlagClear(cuw);

//    _debugTimerStart();
    CommRandSeedInitialize(&cuw->pRand);

#ifdef PM_DEBUG
	debug_cuw = cuw;
#endif
	return cuw;
}	


//==============================================================================
/**
 * jI[X^[gyjI^XNJځz
 * @param   none
 * @retval  none
 */
//==============================================================================

#define _FIRST_SEND	5

static void _UnionStart(COMM_UNIONROOM_WORK *cuw)
{
	// e@ڑꂽH
    if(CommStateIsUnionParentConnectSuccess()){
        OS_TPrintf("e@ڑ\n");
		_changeState(cuw, _underParentInfoSend, _FIRST_SEND);
        return;
    }

	// bn߂H
    if(cuw->CommConnectStartFlag!=0){
        cuw->CommConnectRetry = _CONNECT_RETRY_NUM;
        /// indexŐڑJn܂
		if(cuw->CommConnectStartFlag == DS_CONNECT_START){
	        CommStateUnionConnectStart(cuw->CommConnectId);   // q@ƂȂĐڑJn
		}else if(cuw->CommConnectStartFlag == MP_CONNECT_START){
            // ʐMR}hXgpɕύX
            CommCommandOekakiBoardInitialize( NULL );
			CommStateUnionPictureBoardChild(cuw->CommConnectId);
		}
		
        _changeState(cuw, _underChildConnecting, _CHILD_P_SEARCH_TIME);
		return;
	}
}


#if 0
//------------------------------------------------------------------
/**
 * $brief   ʐMIؒfVт߂ĂƂ̃V[PX
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _UnionRestart( COMM_UNIONROOM_WORK *cuw )
{
	// ʐMVXeOFF҂(̌㎩IɐeqɕAj
    if(CommIsInitialize()==FALSE){
		
	    // tB[hpʐMR}hR[obNɖ߂
    	//CommCommandFieldInitialize((void*)cuw->fsys);

        _changeState(cuw, _UnionStart, _FINALIZE_TIME);
		
	}
}

#endif

//------------------------------------------------------------------
/**
 * $brief   ݎq@lڑĂ邩H
 *
 * @param   none		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int MyStatusCheck( void )
{
	int i,result;
	MYSTATUS *status;

	result = 0;
	for(i=1;i<5;i++){
		status = CommInfoGetMyStatus(i);
		if(status!=NULL){
			result++;
		}
	}

	return (result>=1);
}


//==============================================================================
/**
 * e@ɂȂ byjI^XNJځz
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _underParentInfoSend(COMM_UNIONROOM_WORK *cuw)
{
    if(cuw->timer!=0){
        cuw->timer--;
        return;
    }

    if(CommIsChildsConnecting() && MyStatusCheck()==1){   // 
		// e̊{f[^M
        CommInfoSendPokeData();
		
		// q@Ȃ̂G[ɂ邩ǂSET
        CommMPSetNoChildError(TRUE);

		// fsysNULL̂ƂB
		// e@ƂĂ̐ڑCxgJn
		EventSet_Script( cuw->fsys, SCRID_CONNECT_UNION_RECEIVE_OBJ, NULL );

		// up[eB[ɂȂvr[Rɕς
		Union_BeaconChange( UNION_PARENT_MODE_PARTY );
		_changeState(cuw,_underParentConnect, _FIRST_SEND);
	}
}


//------------------------------------------------------------------
/**
 * $brief   e@ڑ(Ƃ̓R[obNɂ܂j
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _underParentConnect(COMM_UNIONROOM_WORK *cuw)
{
    if(CommIsChildsConnecting()){   // ȊOȂe@Œ
		
	}else{
	
	}

	// ؒf̂Ō̑ɖ߂
    if(0 == CommIsChildsConnecting()){
		// ڑŝŁAIČ̐eq؂ւ̗ɖ߂
    	CommCommandFieldInitialize((void*)cuw->fsys);
    	CommStateUnionBconCollectionRestart();
		CommUnion_EventFlagClear(cuw);
		Union_BeaconChange( UNION_PARENT_MODE_FREE );
	    _changeState(cuw,_UnionStart, _FINALIZE_TIME);
    }


}

//==============================================================================
/**
 * ʐMǗXe[g̕ύX
 * @param   state  ςXe[g̊֐
 * @param   time   Xe[gێ
 * @retval  none
 */
//==============================================================================

static void _changeState(COMM_UNIONROOM_WORK *cuw, PUnionRoomFunc state, int time)
{
	
    cuw->state = state;
    cuw->timer = time;
}

//==============================================================================
/**
 * ʐMǗXe[g̏
 * @param
 * @retval  none
 */
//==============================================================================

static WMBssDesc *debugBsstable[16];

void _commCheckFunc(TCB_PTR tcb, void* work)
{
	COMM_UNIONROOM_WORK *cuw = (COMM_UNIONROOM_WORK*)work;
#ifdef PM_DEBUG
    cuw->debugTimer++;
#endif

	if(sys.trg&PAD_BUTTON_START){
		UNION_BEACON_STATE state;
//		if(cuw->busyflag = UNION_PARENT_MODE_FREE){
//			cuw->busyflag = UNION_PARENT_MODE_BUSY;

//			MI_CpuClear8(&state, sizeof(UNION_BEACON_STATE) );
//			state.c_face[0] = 1;
//			state.mode      = UNION_PARENT_MODE_BUSY;

//		}else{
//			cuw->busyflag = UNION_PARENT_MODE_FREE;
//			state.mode = UNION_PARENT_MODE_FREE;
//		}
//		CommMPSetMyRegulation(&state);	// uZvɃr[R
//		CommMPFlashMyBss();
	}

    if(cuw==NULL){
        TCB_Delete(tcb);
    }
    else{
		int i;
		WMBssDesc *tmp;

		for(i=0;i<SCAN_PARENT_COUNT_MAX;i++){
			cuw->UnionBeaconTbl[i] = CommMPGetWMBssDesc(i);
			debugBsstable[i]       = cuw->UnionBeaconTbl[i]; 
		}


        if(cuw->state != NULL){
            cuw->state(cuw);
        }
    }
}


//==============================================================================
/**
 * @brief  IJn
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _stateConnectEnd(COMM_UNIONROOM_WORK *cuw)
{
    CommSendData(CS_EXIT, NULL, 0);
    if(cuw->timer != 0){
        cuw->timer--;
        return;
    }
    // ؒf
    CommStateExitUnion();
    _changeState(cuw,_stateEnd, 0);
}

//------------------------------------------------------------------
/**
 * ʐMIV[PX
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void _stateEnd(COMM_UNIONROOM_WORK *cuw)
{
    if(CommIsInitialize()){
        return;
    }
    CommStateFinalize(cuw);
}

//==============================================================================
/**
 * q@ƂȂĐڑyjI^XNJځz
 * @param   none
 * @retval  none
 */
//==============================================================================
static void _underChildConnecting(COMM_UNIONROOM_WORK *cuw)
{
    if(1 == CommStateIsUnionConnectSuccess()){
        
		PRINT("ڑIIII\n");
		cuw->CommConnectStartFlag = 0;
		cuw->CommConnectResult    = UNION_CONNECT_SUCCESS;

		// u͂v𑗐MĂ݂
//		CommSendFixSizeData(CU_TALK_YES,0);
        CommInfoSendPokeData();
		_changeState(cuw,_underChildSelectWait, 3);
        return;
    }else if(CommIsChildsConnecting()){   // tɐeƂČqB
		cuw->CommConnectStartFlag = 0;
		cuw->CommConnectResult    = UNION_CONNECT_PARENT;
		
        OS_TPrintf("e@ڑ\n");
        _changeState(cuw,_underParentInfoSend, 0);
	}
    if(0 == CommStateIsUnionConnectSuccess()){
        return;
    }

	// ڑŝŁAIČ̐eq؂ւ̗ɖ߂
    CommStateUnionBconCollectionRestart();
	CommUnion_EventFlagClear(cuw);
	Union_BeaconChange( UNION_PARENT_MODE_FREE );
    _changeState(cuw,_UnionStart, _FINALIZE_TIME);

	cuw->CommConnectStartWait = 0;
	cuw->CommConnectResult    = UNION_CONNECT_FAILED;
	cuw->CommConnectStartFlag = 0;
}


//------------------------------------------------------------------
/**
 * $brief   q@ƂĒʐMڑ̓R[obN֐
 *          邱Ƃ̂ŁAؒf͌n悤ɂyjI^XNJځz
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void  _underChildSelectWait(COMM_UNIONROOM_WORK *cuw)
{
//    if(cuw->timer==1){
//        CommInfoSendPokeData();
//    }

    if(0 == CommStateIsUnionConnectSuccess()){
    	CommCommandFieldInitialize((void*)cuw->fsys);
	    CommStateUnionBconCollectionRestart();
		CommUnion_EventFlagClear(cuw);
    	_changeState(cuw,_UnionStart, _FINALIZE_TIME);
		return ;
	}
    // ڑ^CAEg
//    if(cuw->timer!=0){
//        cuw->timer--;
//        return;
//    }
}

//------------------------------------------------------------------
/**
 * jIʐMp[N
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CommStateFinalize(COMM_UNIONROOM_WORK *cuw)
{
    void* pWork;

    if(cuw==NULL){  // łɏIĂ
        return;
    }
    TCB_Delete(cuw->UnionStateTask);
    sys_FreeMemoryEz(cuw);
    sys_DeleteHeap(HEAPID_UNIONROOM);
//    cuw = NULL;
}



//==============================================================================
/**
 * COMM_UNIONROOM_WORKĂFIELDSYS_WORK̃|C^Ԃ
 *
 * @param   cuw		
 *
 * @retval  FIELDSYS_WORK*		
 */
//==============================================================================
FIELDSYS_WORK* Union_FielsSysPtrGet(COMM_UNIONROOM_WORK *cuw)
{
	return cuw->fsys;
}

//==============================================================================
/**
 * ʐM擾r[R̃|C^Ԃ(comm_union_view.cp)
 *
 * @param   cuw		
 * @param   no		
 *
 * @retval  WMBssDesc*		
 */
//==============================================================================
WMBssDesc* Union_BeaconPtrGet(COMM_UNIONROOM_WORK *cuw, int no)
{
	return cuw->UnionBeaconTbl[no];
}

//==============================================================================
/**
 * ɂׂĂOBJB
 *
 * @param   fldobj		
 *
 * @retval  none		
 */
//==============================================================================
void Union_BeaconObjAllVanish(FIELD_OBJ_SYS_PTR fldobjsys)
{
	int r;
	FIELD_OBJ_PTR fldobj;
	
	
	fldobj = FieldOBJSys_OBJIDSearch(fldobjsys, 0);
	if(FieldOBJ_AcmdSetCheck(fldobj)==TRUE){
		for(r=1;r<51;r++){
			fldobj = FieldOBJSys_OBJIDSearch(fldobjsys, r);
			// \OFF
			FieldOBJ_StatusBitSet_Vanish(fldobj,TRUE);
			// 蔻OFF
			FieldOBJ_StatusBitSet_FellowHit(fldobj,FALSE);
			// bOFF
			FieldOBJ_StatusBitSet_TalkOFF( fldobj, TRUE );
		}
	}
}

static UNION_BEACON_STATE *debug_beacon;

//==============================================================================
/**
 * bOBJIDĐڑ̂߂ɏƂĎg
 *
 * @param   cuw			COMM_UNIONROOM_WORK
 * @param   no			OBJID(Ƃ-1j
 *
 * @retval  int			ʐMJnł邩HǂԂ
 *						UNION_PARENT_CONNECT_OK:b|ʐMł
 *						UNION_PARENT_OEKAKI_OK:GʐMł
 *						UNION_PARENT_CONNECT_NG:ʐMłȂ
 */
//==============================================================================
int Union_ConnectIdSet( COMM_UNIONROOM_WORK *cuw, int no )
{
	MYSTATUS *status;
	_GF_BSS_DATA_INFO *gfbssdata;
	UNION_BEACON_STATE *beaconState;
	// XNvǵ{Pł̂łP
	no--;
	
	status      = CommMPGetBconMyStatus( no );
	gfbssdata   = (_GF_BSS_DATA_INFO *)cuw->UnionBeaconTbl[no]->gameInfo.userGameInfo;
	beaconState = (UNION_BEACON_STATE *)gfbssdata->regulationBuff;
	debug_beacon = beaconState;

	OS_Printf("r[R%d \n",beaconState->mode);

	switch(beaconState->mode){
	case UNION_PARENT_MODE_FREE:	case UNION_PARENT_MODE_RECORD_FREE:	case UNION_PARENT_MODE_GURUGURU_FREE:
		return UNION_PARENT_CONNECT_OK;
		break;
	case UNION_PARENT_MODE_OEKAKI_FREE:
		return UNION_PARENT_OEKAKI_OK;
		break;
	case UNION_PARENT_MODE_BUSY:		case UNION_PARENT_MODE_CARDNOW:	case UNION_PARENT_MODE_BATTLENOW:
	case UNION_PARENT_MODE_TRADENOW:	case UNION_PARENT_MODE_OEKAKINOW:
		return UNION_PARENT_CONNECT_NG;
		break;
	}
	return UNION_PARENT_CONNECT_NG;
}


//==============================================================================
/**
 * $brief   ̃r[RԂmFŐڑɍs
 *
 * @param   cuw		
 * @param   no		OBJIDi{PĂ̂-1Ĉj
 *
 * @retval  none	
 */
//==============================================================================
int Union_ConnectStart( COMM_UNIONROOM_WORK *cuw, int no )
{
	MYSTATUS *status;
	_GF_BSS_DATA_INFO *gfbssdata;
	UNION_BEACON_STATE *beaconState;
	// XNvǵ{Pł̂łP
	no--;
	
	status      = CommMPGetBconMyStatus( no );
	gfbssdata   = (_GF_BSS_DATA_INFO *)cuw->UnionBeaconTbl[no]->gameInfo.userGameInfo;
	beaconState = (UNION_BEACON_STATE *)gfbssdata->regulationBuff;
	debug_beacon = beaconState;

	// ̒ʐMԂmFĐڑONNG𔻒f
	switch(beaconState->mode){
	// t[ER[hR[i[WE邮W̏ꍇ̓f[^VFAOʐM
	case UNION_PARENT_MODE_FREE:
	case UNION_PARENT_MODE_RECORD_FREE:
	case UNION_PARENT_MODE_GURUGURU_FREE:
		cuw->CommConnectId        = no;
		cuw->CommConnectStartFlag = DS_CONNECT_START;
		cuw->CommConnectStartWait = 0;
		cuw->CommConnectResult    = UNION_CONNECT_BUSY;
		return UNION_PARENT_CONNECT_OK;
		break;
	// W̏ꍇMPʐM
	case UNION_PARENT_MODE_OEKAKI_FREE:
		cuw->CommConnectId        = no;
		cuw->CommConnectStartFlag = MP_CONNECT_START;
		cuw->CommConnectStartWait = 0;
		cuw->CommConnectResult    = UNION_CONNECT_BUSY;
		return UNION_PARENT_CONNECT_OK;
		break;
	// ʐM̏ꍇ͎󂯓ԂɖƂ͐ڑȂ
	case UNION_PARENT_MODE_BUSY:		case UNION_PARENT_MODE_CARDNOW:	case UNION_PARENT_MODE_BATTLENOW:
	case UNION_PARENT_MODE_TRADENOW:	case UNION_PARENT_MODE_OEKAKINOW:
		return UNION_PARENT_CONNECT_NG;
		break;

	}
	GF_ASSERT("ɂĂ͂Ȃ");

	return 0;
}

//==============================================================================
/**
 * bŐڑĂ݂ʂԂ
 *
 * @param   cuw		COMM_UNIONROOM_WORK
 *
 * @retval  u32		0:r	1:	2:s	3:eɂȂ
 */
//==============================================================================
u32 Union_ConnectResultGet(COMM_UNIONROOM_WORK *cuw )
{
	return cuw->CommConnectResult;
}



//==============================================================================
/**
 * XNvgɃjI[seԂ
 *
 * @param   cuw		
 *
 * @retval  u32		
 */
//==============================================================================
u32 Union_ParentStartCommandSet( COMM_UNIONROOM_WORK *cuw )
{
//	u8 start;
//	if(cuw->CommNextProcOn){
//		cuw->CommNextProcOn = 0;
//		start = 1;
//		return cuw->UnionEventWork;
//	}

	// ʐMqĂԂ͐e@̃R}hԂAؒfꂽꍇ͂ɏIn
	if(CommGetCurrentID()==0){
		// e@ڑ̎̐ڑmF
		if(CommStateIsUnionParentConnectSuccess()==TRUE){
			return cuw->UnionEventWork;
		}
	}else{
		// q@ڑ̎̐ڑmF
		if(CommStateIsUnionConnectSuccess()==TRUE){
			return cuw->UnionEventWork;
		}
	}
	return UNION_CHILD_SELECT_CANCEL;
	
}


//==============================================================================
/**
 * q@̑IeXNvgɒʒm
 *
 * @param   cuw		
 *
 * @retval  u32		
 */
//==============================================================================
u32 Union_ChildSelectCommandSet( COMM_UNIONROOM_WORK *cuw )
{
	return cuw->CommChildSelectEvent;

}
//==============================================================================
/**
 * XNvgŏꂽǏʂ炤
 *
 * @param   cuw			COMM_UNIONROOM_WORK
 * @param   var			XNvgsI̎
 * @param   result		ʁiIɂĈႤj
 *
 * @retval  none		
 */
//==============================================================================
void Union_ScriptResultGet( COMM_UNIONROOM_WORK *cuw, int var, u32 result)
{
	u8 command = (u8)result;
	
	switch(var){
	case 0:
		PRINT2("Ie%d\n",result);
		cuw->ScriptSelectWork = command;
		CommSendData(CU_PLAYER_SELECT,&command,1);
		break;
	case 1:
		// ê͂Eɂ
		if(result==0){
			u8 start = cuw->CommChildSelectEvent;
			CommSendData_ServerSide(CU_START_NEXT, &start, 1);
			cuw->ScriptYesNoWork = result;
		}else{
			u8 start = UNION_CHILD_SELECT_CANCEL;					//e@͂I񂾂̂ŁuLZv𑗐M
			CommSendData_ServerSide(CU_START_NEXT, &start, 1);
			cuw->ScriptYesNoWork = result;
		}
		break;
	}
}


















//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// comm_command_field.cɓo^ĂʐMR[obN֐Q
//------------------------------------------------------------------------------


void CommUnionRecvStatus(int netID, int size, void* pBuff, void* pWork)
{
	PRINT("Xe[^XM\n");
}

void CommUnionRecvTalk(int netID, int size, void* pBuff, void* pWork)
{
	PRINT2("%d̉bM\n",netID);	
}


//==============================================================================
/**
 * $brief   eCGXi͂ĂȂj
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionRecvYes(int netID, int size, void* pBuff, void* pWork)
{
	PRINT2("%d  xdr\n",netID);	
	
}
//==============================================================================
/**
 * $brief   emnƌĂƂ̃R[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionRecvNo(int netID, int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;

	PRINT2("%d  mn\n",netID);
	// LẐŐؒfEr[RW֕A
	//	CommStateExitUnion();
   	_changeState(fsys->union_work, _UnionStart, _FINALIZE_TIME);
	CommUnion_EventFlagClear(fsys->union_work);

}

static int debug_union_select;

//==============================================================================
/**
 * q@̑IeM
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionRecvSelect(int netID, int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;
	u8 *no = (u8*)pBuff;

	fsys->union_work->CommChildSelectEvent = *no;
	debug_union_select = *no;


	PRINT("IM\n");
	

}

//==============================================================================
/**
 * X^[gf[^MR[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionStartNext(int netID ,int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;
	u8 *no = (u8*)pBuff;
	
	PRINT("CxgJnR}h\n");

	// CxgJntOĂie@ɃCxgJnR}h𔭍sj
	fsys->union_work->CommNextProcOn = 1;

	// e@JnCxg̎ނĂie@ɂ͂j
	fsys->union_work->UnionEventWork = *no;

	if(*no == UNION_CHILD_SELECT_OEKAKI){
		CommStateUnionPictureBoardChange();
//		_changeState(fsys->union_work, _UnionRestart, 0);
	}

}

//==============================================================================
/**
 * ʐMIf[^MR[obN
 *
 * @param   netID		
 * @param   size		
 * @param   pBuff		
 * @param   pWork		
 *
 * @retval  none		
 */
//==============================================================================
void CommUnionEndConnect(int netID ,int size, void* pBuff, void* pWork)
{
	FIELDSYS_WORK *fsys = (FIELDSYS_WORK *)pWork;

	// ʐMIR}h
	fsys->union_work->UnionEndConnectFlag = 1;
}














//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
// jI[pc[
//------------------------------------------------------------------------------


#define TALK_CARD_MAX		( 2 )
#define TALK_TRADE_MAX		( 2 )
#define TALK_BATTLE_MAX		( 4 )
#define TALK_OEKAKI_MAX		( 4 )
#define TALK_RECORD_MAX		( 4 )
#define TALK_GURUGURU_MAX	( 4 )

static const talk_table_card[TALK_CARD_MAX][2]={
	{	msg_union_talkboy_01_03,msg_union_talkgirl_01_03},
	{	msg_union_talkboy_01_04,msg_union_talkgirl_01_04},
};
static const talk_table_oekaki[TALK_OEKAKI_MAX][2]={
	{	msg_union_talkboy_02_09,msg_union_talkgirl_02_09},
	{	msg_union_talkboy_02_10,msg_union_talkgirl_02_10},
	{	msg_union_talkboy_02_11,msg_union_talkgirl_02_11},
	{	msg_union_talkboy_02_12,msg_union_talkgirl_02_12},
};
static const talk_table_battle[TALK_BATTLE_MAX][2]={
	{	msg_union_talkboy_03_05,msg_union_talkgirl_03_05},
	{	msg_union_talkboy_03_06,msg_union_talkgirl_03_06},
	{	msg_union_talkboy_03_07,msg_union_talkgirl_03_07},
	{	msg_union_talkboy_03_08,msg_union_talkgirl_03_08},
};
static const talk_table_trade[TALK_TRADE_MAX][2]={
	{	msg_union_talkboy_04_04,msg_union_talkgirl_04_04},
	{	msg_union_talkboy_04_05,msg_union_talkgirl_04_05},
};
static const talk_table_record[TALK_RECORD_MAX][2]={
	{	msg_union_talkboy_06_09,msg_union_talkgirl_06_09},
	{	msg_union_talkboy_06_10,msg_union_talkgirl_06_10},
	{	msg_union_talkboy_06_11,msg_union_talkgirl_06_11},
	{	msg_union_talkboy_06_12,msg_union_talkgirl_06_12},
};
static const talk_table_guruguru[TALK_GURUGURU_MAX][2]={
	{	msg_union_talkboy_07_10,msg_union_talkgirl_07_10},
	{	msg_union_talkboy_07_11,msg_union_talkgirl_07_11},
	{	msg_union_talkboy_07_12,msg_union_talkgirl_07_12},
	{	msg_union_talkboy_07_13,msg_union_talkgirl_07_13},
};

// SXYłOBJ̔zuȂ̂ŕ␳pe[u
static const u16 group_obj_table[]={
	15,23,11,27,19,31,35,39,47,43,
//	14,22,10,26,18,30,34,38,46,42,
//	4, 12, 0,16, 8,20,24,28,36,32,
//	1,  3, 0, 4, 2, 5, 6, 7, 9, 8,
};

static int ChildToParentNo(int no)
{
	int i,r,result;
	for(i=0;i<10;i++){
		if(group_obj_table[i]>=no && (group_obj_table[i]+4)>no){
			return i;
		}
	}
	return -1;
}

//==============================================================================
/**
 * $brief   b|ŒʐMڑłȂɏob̃CfbNXn
 *
 * @param   cuw		jI[N
 * @param   no		bΏۂOBJ̔ԍ
 *
 * @retval  int		bZ[WCfbNX
 */
//==============================================================================
int Union_GetTalkNumber( COMM_UNIONROOM_WORK *cuw, int no )
{
	int sex;
	MYSTATUS *status;
	_GF_BSS_DATA_INFO *gfbssdata;
	UNION_BEACON_STATE *beaconState;
	// XNvǵ{Pł̂łP
	no--;
	
	OS_Printf("OBJ");
	// 10ȏ͎q@Ȃ̂ŁAe@̉bɂԂ炳悤ɂ
	if(no>9){
		no = ChildToParentNo( no );
		GF_ASSERT( no!=-1 && "q@OBJID͐e@ЂȂ" );
	}
	
	// b擾Jn
	status      = CommMPGetBconMyStatus( no );
	gfbssdata   = (_GF_BSS_DATA_INFO *)cuw->UnionBeaconTbl[no]->gameInfo.userGameInfo;
	beaconState = (UNION_BEACON_STATE *)gfbssdata->regulationBuff;

	sex = MyStatus_GetMySex(status);
	switch(beaconState->mode){
	// Ƃ肱ݒ̂悤c
	case UNION_PARENT_MODE_BUSY:
		return msg_union_talkboy_00_05;
		break;

	case UNION_PARENT_MODE_CARDNOW:
		return talk_table_card[gf_rand()%TALK_CARD_MAX][sex];
		break;
	case UNION_PARENT_MODE_BATTLENOW:
		return talk_table_battle[gf_rand()%TALK_BATTLE_MAX][sex];
		break;
	case UNION_PARENT_MODE_TRADENOW: 

		return talk_table_trade[gf_rand()%TALK_TRADE_MAX][sex];
		break;
	case UNION_PARENT_MODE_OEKAKINOW:	case UNION_PARENT_MODE_OEKAKI_FREE:
		return talk_table_oekaki[gf_rand()%TALK_OEKAKI_MAX][sex];
		break;
	case UNION_PARENT_MODE_RECORDNOW:	case UNION_PARENT_MODE_RECORD_FREE:
		return talk_table_record[gf_rand()%TALK_RECORD_MAX][sex];
		break;
	case UNION_PARENT_MODE_GURUGURUNOW:	case UNION_PARENT_MODE_GURUGURU_FREE:
		return talk_table_guruguru[gf_rand()%TALK_GURUGURU_MAX][sex];
		break;
	}
	// e@̐ڑ[h
	return msg_union_talkboy_00_05;
}


//------------------------------------------------------------------
/**
 * $brief   ڑ̗FB̎pr[R쐬
 *
 * @param   state	
 * @param   num		ڑl
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void ConnectChildViewSet( UNION_BEACON_STATE  *state, int num )
{
	MYSTATUS *friendstatus;
	int i,count=0;

	// 2lڑłID1ȂȂ
	for(i=1;i<UNION_CONNECT_CHILD_MAX;i++){
		friendstatus = CommInfoGetMyStatus(i);
		
		if(friendstatus!=NULL){
			state->c_id[count]   = MyStatus_GetID( friendstatus );
			state->c_face[count] = MyStatus_GetTrainerView( friendstatus ) | (MyStatus_GetMySex( friendstatus )<<7);

			// ڑl̖Oi[I
			if(friendstatus!=NULL){
				count++;
				if(num==count){
					break;
				}
			}
		}
	}
}

//------------------------------------------------------------------
/**
 * $brief   u|Pvr[Rɏ
 *
 * @param   flag		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
void Union_BeaconChange( int flag )
{
	UNION_BEACON_STATE state;

	MI_CpuClear8( &state, sizeof(UNION_BEACON_STATE) );
	switch(flag){
	// b\
	case UNION_PARENT_MODE_FREE:
		break;
	// bɐA2lڑɂȂ
	case UNION_PARENT_MODE_PARTY:	
		ConnectChildViewSet( &state, 2 );
		break;
	// ݌ʂɂîłqȂj
	case UNION_PARENT_MODE_TRADENOW:
		ConnectChildViewSet( &state, 2 );
		break;

	// ݂{[hɂāAł5l܂ĂîłqȂj
	case UNION_PARENT_MODE_OEKAKINOW:
		ConnectChildViewSet( &state, 4 );
		break;
	// ݂G{[hɂĂ܂󂫂̂ŁAb
	case UNION_PARENT_MODE_OEKAKI_FREE:
		ConnectChildViewSet( &state, 4 );
		break;

	// ݃R[hR[i[ɂāAł5l܂ĂîłqȂj
	case UNION_PARENT_MODE_RECORDNOW:
		ConnectChildViewSet( &state, 4 );
		break;
	// ݃R[hR[i[ɂĂ܂󂫂̂ŁAb
	case UNION_PARENT_MODE_RECORD_FREE:
		ConnectChildViewSet( &state, 4 );
		break;

	// ݂邮ɂāAł5l܂ĂîłqȂj
	case UNION_PARENT_MODE_GURUGURUNOW:
		ConnectChildViewSet( &state, 4 );
		break;
	// ݂邮ɂĂ܂󂫂̂ŁAb
	case UNION_PARENT_MODE_GURUGURU_FREE:
		ConnectChildViewSet( &state, 4 );
		break;
	}
	state.mode      = flag;
	
	CommMPSetMyRegulation(&state);	// r[R
	CommMPFlashMyBss();
	
}

//------------------------------------------------------------------
/**
 * $brief   e@̎̎胁o[\r[RNA
 *
 * @param   beacon		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionBeaconClear( UNION_BEACON_STATE *beacon )
{
	int i;
	beacon->mode = 0;
	for(i=0;i<4;i++){
		beacon->c_id[i]     = 0;
		beacon->c_face[i]   = 0;
		beacon->c_rom[i]    = 0;
		beacon->c_region[i] = 0;
	}
}

//==============================================================================
/**
 * $brief   jI[ŃX^[gj[`bgǉꂽ̏
 *
 * @param   cuw		
 * @param   pms		u`bgvj[ō쐬ȈՉb
 *
 * @retval  none
 */
//==============================================================================
void Union_SetMyPmsData( COMM_UNIONROOM_WORK *cuw, PMS_DATA *pms )
{
	PMSDAT_Copy( &cuw->MyPmsData, pms  );
	cuw->MyPmsPutFlag = 1;
}

//==============================================================================
/**
 * $brief   ō쐬ȈՉbʂQƂ悤ɂ
 *
 * @param   cuw			
 *
 * @retval  PMS_DATA *	ō쐬ȈՉb
 */
//==============================================================================
PMS_DATA * Union_GetMyPmsData( COMM_UNIONROOM_WORK *cuw )
{
	if(cuw->MyPmsPutFlag==0){
		return NULL;
	}
	cuw->MyPmsPutFlag = 0;
	return &cuw->MyPmsData;
}


//==============================================================================
/**
 * $brief   jI[ŎgpbpɃg[i[Zbg
 *          ̖OZbg
 *
 * @param   wordset		WORDSETւ̃|C^
 * @param   type		UNION_TRAINER_REGIST_CHILD:ubpv	1:ubpv
 * @param   no			ubpv̎Ɏw肵ĂOBJ炤߂ɕKv
 *
 * @retval  none		
 */
//==============================================================================
void Union_TrainerNameRegist( WORDSET *wordset, int type, int no, MYSTATUS *mystatus )
{
	MYSTATUS *status;
	OS_Printf("NameRegist type=%d objid=%d\n",type, no);
	no--;		// XNvǵ{Pł̂łP
	
	// b̓r[RMYSTATUS擾
	if(type==UNION_TALK_CHILD){
		status      = CommMPGetBconMyStatus( no );
	}else{
	// b͐ڑς݂Ȃ̂ConnectID^1MYSTATUS擾
		status = CommInfoGetMyStatus(CommGetCurrentID()^1);

	}


	GF_ASSERT(status!=NULL && "擾MYSTATUSNULL");

	// g[i[o^
	WORDSET_RegisterPlayerName( wordset, 0, status );		// ̖Oo^
	WORDSET_RegisterPlayerName( wordset, 1, mystatus );		// ̖Oo^
}

//==============================================================================
/**
 * $brief   jI[ŊȈՉbibOKȂƎv̂łPŁj
 *
 * @param   pms		
 *
 * @retval  none		
 */
//==============================================================================
void Union_PMSReWrite( PMS_DATA *pms )
{
	UNION_BEACON_STATE state;

	UnionBeaconClear( &state );
	state.mode = UNION_PARENT_MODE_FREE;
	

	CommMPSetMyPMS( pms );
	CommMPSetMyRegulation(&state);	// r[R
	CommMPFlashMyBss();
	
}

//==============================================================================
/**
 * $brief   E񂩂߂ĂpɃ[NĂ
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//==============================================================================
void Union_CommWorkClear( COMM_UNIONROOM_WORK *cuw)
{
	cuw->CommChildSelectEvent = 0;
	cuw->UnionEventWork       = 0;
}
//------------------------------------------------------------------
/**
 * $brief   jI[ʐMJnp̃[NNA
 *
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void CommUnion_EventFlagClear( COMM_UNIONROOM_WORK *cuw)
{
	cuw->CommConnectStartFlag = 0;
	cuw->CommConnectStartWait = 0;
	cuw->CommNextProcOn       = 0;
	cuw->CommChildSelectEvent = 0;
	cuw->UnionEventWork       = 0;
	cuw->busyflag			  = 0;
	cuw->MyPmsPutFlag         = 0;
}