//=============================================================================
/**
 * @file	comm_union.h
 * @brief	jI[䏈
 * @author	Akito Mori
 * @date    2005.12.10
 */
//=============================================================================

#ifndef	__COMM_UNION_H__
#define	__COMM_UNION_H__

#include "system\wordset.h"

typedef struct COMM_UNIONROOM_WORK COMM_UNIONROOM_WORK;

extern COMM_UNIONROOM_WORK *Comm_UnionRoomInit(FIELDSYS_WORK* fSys);
extern void Comm_UnionFinalize(FIELDSYS_WORK *fsys);
extern void _commCheckFunc(TCB_PTR tcb, void* work);

extern FIELDSYS_WORK* Union_FielsSysPtrGet(COMM_UNIONROOM_WORK *cuw);
extern WMBssDesc* Union_BeaconPtrGet(COMM_UNIONROOM_WORK *cuw, int no);
extern int  Union_ConnectIdSet(COMM_UNIONROOM_WORK *cuw, int no);
extern int  Union_ConnectStart( COMM_UNIONROOM_WORK *cuw, int no );

extern u32  Union_ConnectResultGet(COMM_UNIONROOM_WORK *cuw);
extern int  Union_GetTalkNumber( COMM_UNIONROOM_WORK *cuw, int no );
extern void Union_SetMyPmsData( COMM_UNIONROOM_WORK *cuw, PMS_DATA *pms );
extern PMS_DATA * Union_GetMyPmsData( COMM_UNIONROOM_WORK *cuw );
extern void Union_CommWorkClear( COMM_UNIONROOM_WORK *cuw);
extern void Union_TrainerNameRegist( WORDSET *wordset, int type, int no, MYSTATUS *mystatus );


// őq@ڑl
#define UNION_CONNECT_CHILD_MAX	( 4 )

// őڑl
#define UNION_CONNECT_MAX		( UNION_CONNECT_CHILD_MAX+1 )

//--------------------------------------------------------------
// XNvgp
//--------------------------------------------------------------

// ObjSĉBi킯ł͂Ȃj
extern void Union_BeaconObjAllVanish(FIELD_OBJ_SYS_PTR fldobjsys);

// XNvgŎsIʂႤ
extern void Union_ScriptResultGet( COMM_UNIONROOM_WORK *cuw, int var, u32 result);

// e@̃X^[g҂
extern u32 Union_ParentStartCommandSet( COMM_UNIONROOM_WORK *cuw );

// q@eXNvgɕԂ
extern u32 Union_ChildSelectCommandSet(COMM_UNIONROOM_WORK *cuw);



//--------------------------------------------------------------
// ʐMR[obNp
//--------------------------------------------------------------
extern void CommUnionRecvStatus(int netID, int size, void* pBuff, void* pWork);
extern void CommUnionRecvSelect(int netID, int size, void* pBuff, void* pWork);
extern void CommUnionRecvTalk(int netID, int size, void* pBuff, void* pWork);
extern void CommUnionRecvYes(int netID, int size, void* pBuff, void* pWork);
extern void CommUnionRecvNo(int netID, int size, void* pBuff, void* pWork);
extern void CommUnionStartNext(int netID ,int size, void* pBuff, void* pWork);
extern void CommUnionEndConnect(int netID ,int size, void* pBuff, void* pWork);


#endif  //__COMM_UNION_H__