//=============================================================================
/**
 * @file	comm_union_view.c
 * @brief	jI[䏈
 * @author	Akito Mori
 * @date    2005.12.15
 */
//=============================================================================

// WMBssDec̓communiocation.hɂ

#include "common.h"
#include "communication/communication.h"
#include "system/pms_data.h"
#include "fieldsys.h"
#include "field/field.h"
#include "fieldobj.h"
#include "field_effect.h"
#include "savedata/savedata.h"
#include "savedata/friendlist.h"


#include "comm_command_field.h"
#include "comm_union.h"
#include "comm_union_view.h"
#include "comm_union_view_def.h"
#include "comm_union_beacon.h"

#define _TCB_UNIONVIEW_PRT	( 11 )


/*** ֐vg^Cv ***/
static void commUnionViewTask( TCB_PTR tcb, void* work);
static void UnionObjView_Control( COMM_UNIONROOM_VIEW *view, COMM_UNIONROOM_WORK *cuw, FIELD_OBJ_SYS_PTR fldobjsys, FRIEND_LIST *friendlist );
static void UnionObjView_ChildControl( COMM_UNIONROOM_VIEW *view, int no, WMBssDesc *beacon,  FRIEND_LIST *friendlist);
static void UnionObjView_Draw( COMM_UNIONROOM_VIEW *view, FIELD_OBJ_SYS_PTR  fldobjsys );
static void UnionViewObjWorkClear( COMM_UNIONROOM_VIEW *view);
static void Delete_Effect( OBJ_VIEW_WORK *objwork );
static void EffectControl( OBJ_VIEW_WORK *objwork);
static void UnionObjFall_Req( OBJ_VIEW_WORK *objview, FIELD_OBJ_PTR fldobj );
static void UnionObjRise_Req( OBJ_VIEW_WORK *objview, FIELD_OBJ_PTR fldobj );
static void UnionObj_EffectCheck(OBJ_VIEW_WORK *objwork, FIELD_OBJ_PTR fldobj);



//static void DebugObjFall( FIELD_OBJ_SYS_PTR fldobjsys );



// ̐eƎ̎q̏ԂĂȂ̂ŁA␳pe[u
static const u16 group_obj_table[]={
	15,23,11,27,19,31,35,39,47,43,
};

COMM_UNIONROOM_VIEW *debug_view;
//==============================================================================
/**
 * OBJ䏈
 *
 * @param   cuw		
 *
 * @retval  COMM_UNIONROOM_VIEW *		
 */
//==============================================================================
COMM_UNIONROOM_VIEW *Comm_UnionRoomViewInit(COMM_UNIONROOM_WORK *cuw)
{
	COMM_UNIONROOM_VIEW *view;
    view = (COMM_UNIONROOM_VIEW*)sys_AllocMemory(HEAPID_UNIONROOM, sizeof(COMM_UNIONROOM_VIEW));
	view->cuw           = cuw;
	view->nowobj        = 1;
	view->viewTask      = TCB_Add(commUnionViewTask, view, _TCB_UNIONVIEW_PRT);
	view->vanishflag    = 0;

	UnionRoomView_ObjInit( view );

	debug_view = view;
	return view;
}

//==============================================================================
/**
 * $brief   \OBJNA
 *
 * @param   view		
 *
 * @retval  none		
 */
//==============================================================================
void UnionRoomView_ObjInit( COMM_UNIONROOM_VIEW *view )
{
	int i;
	for(i=0;i<UNION_BEACON_OBJ_MAX;i++){
		view->objwork[i].appear         = OBJ_NO_APPEAR;
		view->objwork[i].effect_onflag  = 0;
		view->objwork[i].effect         = 0;
		view->objwork[i].wait			= 0;
	}

}

//==============================================================================
/**
 * jI[`揈[N
 *
 * @param   view		
 *
 * @retval  none		
 */
//==============================================================================
void Comm_UnionRoomViewEnd(COMM_UNIONROOM_VIEW *view)
{
	TCB_Delete(view->viewTask);
	
	sys_FreeMemoryEz(view);
}


static const arrowtbl[]={AC_WARP_UP, AC_WARP_DOWN};


//------------------------------------------------------------------
/**
 * r[ROBJoAȂȂ鏈
 *
 * @param   tcb		
 * @param   work		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void commUnionViewTask(TCB_PTR tcb, void* work)
{
	COMM_UNIONROOM_VIEW *view = (COMM_UNIONROOM_VIEW*)work;
	COMM_UNIONROOM_WORK *cuw  = view->cuw;
	FIELDSYS_WORK *fsys       = Union_FielsSysPtrGet(cuw);
	FRIEND_LIST	  *friendlist = SaveData_Get(fsys->savedata, GMDATA_ID_FRIEND);

	FIELD_OBJ_PTR fldobj;
	int i;
	
	// CxgłȂƂmF
	if(!FieldEvent_Check(fsys)){

		// ͂Ƒs鏊ɈړB
		if(view->vanishflag==0){		// 񂾂ĂőS
			// eoȂ
			FieldOBJSys_ShadowJoinSet( fsys->fldobjsys, FALSE );
			view->vanishflag=1;
		}

//		DebugObjFall(fsys->fldobjsys);

		// r[RmFoNGXgs
		UnionObjView_Control( view, cuw, fsys->fldobjsys, friendlist );
		
		// OBJ`EbON
		UnionObjView_Draw( view, fsys->fldobjsys );
		
	}
//	}else{	// Cxg̓[NNA
//		UnionRoomView_ObjInit( work );
//	}

}


//------------------------------------------------------------------
/**
 * $brief   q@Rg[EOBJRg[
 *
 * @param   view		
 * @param   no		
 * @param   beacon		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionObjView_ChildControl( COMM_UNIONROOM_VIEW *view, int no, WMBssDesc *beacon,  FRIEND_LIST *friendlist)
{
	int i,r;
	_GF_BSS_DATA_INFO *gfbssdata;
	UNION_BEACON_STATE *beaconState;
	FIELD_OBJ_PTR fldobj;
	
	// r[RȂĂAq@͑SĈグ
	if(beacon==NULL){
		for(i=0;i<4;i++){
			r = group_obj_table[no]+i;
			view->objwork[r].appear = OBJ_REQ_RISE;
		}
		return;
	}
	
	gfbssdata   = (_GF_BSS_DATA_INFO *)beacon->gameInfo.userGameInfo;
	beaconState = (UNION_BEACON_STATE*)gfbssdata->regulationBuff;

	// er[RɎq@݂̑߂ł\
	for(i=0;i<4;i++){
		int r = group_obj_table[no]+i;
		switch(view->objwork[r].appear){

		// łĂȂ
		case OBJ_NO_APPEAR:
			if(beaconState->c_face[i]!=0){
				view->objwork[r].request = OBJ_REQ_FALL;
				view->objwork[r].view    = (beaconState->c_face[i] & 0x7f);	// ŏʃrbg͐ʂȂ̂Ń}XN
				view->objwork[r].friend  = FriendList_IdFullCheck( friendlist, beaconState->c_id[i] );
				OS_Printf("q@ %dԃNGXg \n",i);
			}
			break;

		// o
		case OBJ_OK:
			// r[R̎q@񂪂ȂȂĂ
			if(beaconState->c_face[i]==0){
				view->objwork[r].request = OBJ_REQ_RISE;
			}
			break;

		// o肫
		case OBJ_RISED:
			view->objwork[r].request = OBJ_REQ_NO;
			break;
		}
	}

}

//------------------------------------------------------------------
/**
 * $brief   jIe@EOBJRg[
 *
 * @param   view		
 * @param   cuw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionObjView_Control( COMM_UNIONROOM_VIEW *view, COMM_UNIONROOM_WORK *cuw, FIELD_OBJ_SYS_PTR fldobjsys, FRIEND_LIST *friendlist )
{
	WMBssDesc     		*beacon;
	int  		  		i;
	_GF_BSS_DATA_INFO 	*gfbssdata;
	MYSTATUS 			*status;
	
	for(i=0;i<10;i++){
		beacon    = Union_BeaconPtrGet(cuw,i);
		gfbssdata = (_GF_BSS_DATA_INFO *)beacon->gameInfo.userGameInfo;
		status    = (MYSTATUS*)gfbssdata->myStatusBuff;

		switch(view->objwork[i].appear){
		// OBJȂꏊ̃r[R󂯎o
		case OBJ_NO_APPEAR:
			if(beacon!=NULL){
				view->objwork[i].request = OBJ_REQ_FALL;
				view->objwork[i].view    = MyStatus_GetTrainerView( status );
				view->objwork[i].friend  = FriendList_IdFullCheck( friendlist, MyStatus_GetID( status ) );
				UnionObjView_ChildControl( view, i, beacon, friendlist );
				OS_TPrintf("e@%d NGXg\n", i);
			}
			break;
		// 
		case OBJ_OK:
			if(beacon==NULL){
				view->objwork[i].request = OBJ_REQ_RISE;
			}
			UnionObjView_ChildControl( view, i, beacon, friendlist );
			break;
		case OBJ_RISED:
				view->objwork[i].request = OBJ_REQ_NO;
			break;
		}
	}



}
//------------------------------------------------------------------
/**
 * $brief   jI[bOBJ\
 *
 * @param   view		
 * @param   fldobj		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionObjView_Draw( COMM_UNIONROOM_VIEW *view, FIELD_OBJ_SYS_PTR  fldobjsys )
{
	FIELD_OBJ_PTR fldobj;
	int i;
	
		// 50lS邮
		for(i=0;i<50;i++){
			fldobj = FieldOBJSys_OBJIDSearch( fldobjsys, i+1);
			switch(view->objwork[i].appear){
			// OBJȂꏊ̃r[R󂯎o
			case OBJ_NO_APPEAR:
				if(FieldOBJ_AcmdSetCheck(fldobj)==TRUE){
					if(view->objwork[i].request==OBJ_REQ_FALL){
						UnionObjFall_Req( &view->objwork[i], fldobj );
					}
				}
				break;
			// Ă
			case OBJ_FALL_WAIT:
				if(FieldOBJ_AcmdSetCheck(fldobj)==TRUE){			// 
					FieldOBJ_AcmdEnd(fldobj);
					view->objwork[i].appear  = OBJ_OK;
					view->objwork[i].request = OBJ_REQ_NO;
					FieldOBJ_StatusBitSet_TalkOFF( fldobj, FALSE );	// b悤ɃtOύX
				}
				break;
			// b
			case OBJ_OK:
				if(FieldOBJ_AcmdSetCheck(fldobj)==TRUE){
//					if(sys.trg&PAD_BUTTON_A){
					// TuʂŃ`bg^b`ꂽԘgo
					UnionObj_EffectCheck(&view->objwork[i], fldobj);
					
					// Ȃ烊NGXg
					if(view->objwork[i].request==OBJ_REQ_RISE){
						UnionObjRise_Req( &view->objwork[i], fldobj );
					}
					// GtFNgǗ
					EffectControl( &view->objwork[i] );
				}
				break;
			// oĂ
			case OBJ_RISE_WAIT:
				if(FieldOBJ_AcmdSetCheck(fldobj)==TRUE){			// o肫
					FieldOBJ_AcmdEnd(fldobj);
					view->objwork[i].appear  = OBJ_RISED;
					view->objwork[i].request = OBJ_REQ_NO;
					FieldOBJ_StatusBitSet_Vanish(fldobj,TRUE);		// B
					FieldOBJ_StatusBitSet_FellowHit(fldobj,FALSE);	// 蔻Ȃ
				}
				break;
			// o肫
			case OBJ_RISED:
				view->objwork[i].appear = OBJ_NO_APPEAR;
				break;

			}
		}

}

//------------------------------------------------------------------
/**
 * $brief   OBJ\Ǘ[NNA
 *
 * @param   view		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionViewObjWorkClear( COMM_UNIONROOM_VIEW *view)
{
	int i;
	
	for(i=0;i<UNION_BEACON_OBJ_MAX;i++){
		view->objwork[i].appear = OBJ_NO_APPEAR;
	}
}
//------------------------------------------------------------------
/**
 * $brief   l̎ɂĂGtFNg
 *
 * @param   effect_ptr		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void Delete_Effect( OBJ_VIEW_WORK *objwork )
{
	if( objwork->effect_ptr != NULL){
		EOA_Delete( objwork->effect_ptr );
		objwork->effect_ptr = NULL;
	}
	if( objwork->shadow_ptr != NULL){
		EOA_Delete( objwork->shadow_ptr );
		objwork->shadow_ptr = NULL;
	}
}

//------------------------------------------------------------------
/**
 * $brief   GtFNg̊Ǘ
 *
 * @param   objwork		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void EffectControl( OBJ_VIEW_WORK *objwork)
{
	// GtFNgттĂꍇ
	if(objwork->effect_onflag){
		objwork->wait--;		// EFCg
		if(objwork->wait==0){	
			// IɃGtFNg
			Delete_Effect( objwork );
			objwork->effect_onflag=0;
			
		}
	}
}



//------------------------------------------------------------------
/**
 * $brief   OBJ𗎂Ƃ
 *
 * @param   view		
 * @param   fldobjsys		
 * @param   no		
 * @param   gfbssdata		
 * @param   status		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionObjFall_Req( OBJ_VIEW_WORK *objview, FIELD_OBJ_PTR fldobj )
{
	FieldOBJ_DrawReset( fldobj, objview->view );
	
	FieldOBJ_DirDispSetForce( fldobj, DIR_DOWN     );
	FieldOBJ_AcmdSet(         fldobj, AC_WARP_DOWN );
	FieldOBJ_StatusBitSet_Vanish(    fldobj, FALSE );
	FieldOBJ_StatusBitSet_FellowHit( fldobj, TRUE  );
	objview->appear = OBJ_FALL_WAIT;

	// m荇ȂԂeAm荇̒m荇Ȃe
	if(objview->friend!=0){
		// SHADOW_REDESHADOW_BLUEfldeff_shadow.hQ
		switch(objview->friend){
		case DIRECT_FRIEND:	
			objview->shadow_ptr = FE_FldOBJShadowSet( fldobj, SHADOW_RED );
			break;
		case INDIRECT_FRIEND:
			objview->shadow_ptr = FE_FldOBJShadowSet( fldobj, SHADOW_BLUE );
			break;
		}
		objview->friend     = 0;
	}

}


//------------------------------------------------------------------
/**
 * $brief   OBJo点鏈
 *
 * @param   view		
 * @param   fldobjsys		
 * @param   no		
 * @param   gfbssdata		
 * @param   status		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionObjRise_Req( OBJ_VIEW_WORK *objview, FIELD_OBJ_PTR fldobj )
{

	FieldOBJ_AcmdSet(              fldobj, AC_WARP_UP );
	FieldOBJ_StatusBitSet_TalkOFF( fldobj, TRUE       );
	objview->appear = OBJ_RISE_WAIT;

}

//------------------------------------------------------------------
/**
 * $brief   
 *
 * @param   objwork		
 * @param   fldobj		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionObj_EffectCheck(OBJ_VIEW_WORK *objwork, FIELD_OBJ_PTR fldobj)
{
	if(objwork->effect==1){
		if(objwork->effect_onflag==0){
			objwork->effect_ptr   = FE_FldOBJRedFrame_Add( fldobj );
//			objwork->effect_ptr   = FE_FldOBJShadowSet( fldobj, SHADOW_RED );
//			FieldOBJ_AcmdSet(fldobj, AC_MARK_GYOE);
			objwork->wait          = 30;
			objwork->effect        = 0;
			objwork->effect_onflag = 1;
		}
	}


}

#if 0
static debug_obj_count=1;

static void DebugObjFall( FIELD_OBJ_SYS_PTR fldobjsys )
{
	FIELD_OBJ_PTR fldobj = FieldOBJSys_OBJIDSearch(fldobjsys, debug_obj_count );
	if(sys.trg&PAD_BUTTON_Y){
		FieldOBJ_DirDispSetForce( fldobj, DIR_DOWN );
		FieldOBJ_AcmdSet(fldobj, AC_WARP_DOWN);
		FieldOBJ_StatusBitSet_Vanish(fldobj,FALSE);
		FieldOBJ_StatusBitSet_FellowHit(fldobj,TRUE);
		debug_obj_count++;
	}
}
#endif