//==============================================================================
/**
 * @file	d_goto.c
 * @brief	㓡pfobOpt@C
 * @author	goto
 * @date	2005.06.20()
 */
//==============================================================================
#include "common.h"
#include "system/pm_overlay.h"
#include "system/test_overlay.h"

#include "system/bmp_list.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "system/fontproc.h"
///

///< 폜
void DebugGotoMenuInit(FIELDSYS_WORK* fsys)
{
}
#if 0
//==============================================================================
//	\̐錾
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   fobOp\
 */
//--------------------------------------------------------------
typedef struct{
	FIELDSYS_WORK *fsys;
	BMPLIST_WORK *lw;
	GF_BGL_BMPWIN bmpwin;
	s16 wait;
	u8 main_seq;
}TDG_WORK;

//==============================================================================
//	^錾
//==============================================================================
typedef void (*pDMFunc)(TDG_WORK *);

//==============================================================================
//	vg^Cv錾
//==============================================================================
static void DM_MenuMain(TCB_PTR tcb, void *work);
static void DM_MenuExit(TDG_WORK *dm);
static void TestOverlaySet(TDG_WORK *dm);
static void TestSet(TDG_WORK *dm);

//==============================================================================
//	fobOj[Xgpf[^
//==============================================================================
///fobOj[̍ڃbZ[W
static const u16 menu_lbl01[] = { B__,a__,t__,t__,l__,e__,EOM_ };
static const u16 menu_msg01[] = { C__,l__,a__,c__,t__,T__,o__,o__,l__,EOM_};

static void ClactTool(void);

///fobOj[̍
static const BMPLIST_DATA DebugMenuList[] = {
	{ menu_lbl01,	BMPLIST_RABEL	},
	{ menu_msg01,	(u32)ClactTool	},
};

///fobOj[̃Xg
///	XgVXẽR[obNs\
static void	InfoCallBack(BMPLIST_WORK* lw,u32 param,u8 y)
{
	if(param == BMPLIST_RABEL){
		BmpListTmpColorChange(lw,FBMP_COL_RED_SDW,FBMP_COL_BLACK,FBMP_COL_RED);
	}else{
		BmpListTmpColorChange(lw,FBMP_COL_WHITE,FBMP_COL_BLACK,FBMP_COL_BLK_SDW);
	}
}
static const BMPLIST_HEADER DebugMenuListHeader = {
	DebugMenuList,			// \f[^|C^
	NULL,					// J[\ړƂ̃R[obN֐
	InfoCallBack,			// \Ƃ̃R[obN֐
	NULL,
	NELEMS(DebugMenuList),	// Xgڐ
	7,						// \ő區ڐ
	4,						// x\wW
	12,						// ڕ\wW
	4,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			// F
	FBMP_COL_BLACK,			// wiF
	FBMP_COL_BLK_SDW,		// eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	POKE_8x16,				// w
	0,						// afJ[\(allow)\tO(0:ON,1:OFF)
};



//--------------------------------------------------------------
/**
 * @brief   㓡pfobOAĂяo
 */
//--------------------------------------------------------------
void DebugGotoMenuInit(FIELDSYS_WORK* fsys)
{
	TDG_WORK *dm;
	BMPLIST_HEADER list_h;
	
	dm = sys_AllocMemory(HEAPID_BASE_DEBUG, sizeof(TDG_WORK));
	memset(dm, 0, sizeof(TDG_WORK));
	
	//BMPEBhE
	GF_BGL_BmpWinAdd(fsys->bgl, &dm->bmpwin, FLD_MBGFRM_FONT, 1, 1, 20, 12, 15, 1);
	dm->fsys = fsys;
	
	list_h = DebugMenuListHeader;
	list_h.win = &dm->bmpwin;
	dm->lw = BmpListSet(&list_h, 0, 1, HEAPID_BASE_DEBUG);
	
	GF_BGL_BmpWinOn(&dm->bmpwin);
	
	TCB_Add(DM_MenuMain, dm, 10);
}

//--------------------------------------------------------------
/**
 * @brief   㓡pfobOj[XgI
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		fobOp㓡p[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DM_MenuMain(TCB_PTR tcb, void *work)
{
	TDG_WORK *dm = work;
	u32	ret;

	ret = BmpListMain(dm->lw);
	switch(dm->main_seq){
	case 0:
		dm->main_seq++;
		break;
	case 1:
		switch(ret){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			DM_MenuExit(dm);
			TCB_Delete(tcb);
			sys_FreeMemoryEz(dm);
			FieldSystemProc_SeqHoldEnd();
			return;
		default:
			{
				pDMFunc func = (pDMFunc)ret;

				DM_MenuExit(dm);
				TCB_Delete(tcb);
				func(dm);
				return;
			}
			break;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   㓡pfobOj[Xg
 * @param   dm		fobOp㓡p[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DM_MenuExit(TDG_WORK *dm)
{
	BmpListExit(dm->lw, NULL, NULL);

	GF_BGL_BmpWinOff(&dm->bmpwin);
	GF_BGL_BmpWinDel(&dm->bmpwin);
}



///< ClactTool Sample
#include "system/clact_tool.h"
#include "system/arc_tool.dat"
typedef struct {
	
	int seq;
	
	CATS_SYS_PTR	csp;
	CATS_RES_PTR	crp;
	CATS_RES_PTR	crp2;
	
	CATS_ACT_PTR	cap;
	CATS_ACT_PTR	cap2;
	CATS_ACT_PTR	cap3;
	CATS_ACT_PTR	cap4;
	
	int act_no;
	CLACT_WORK_PTR act[10];
	
} CTWK;

///< clacttool TCB
static void ClactToolTCB(TCB_PTR tcb, void* work)
{
#if 0
	CTWK* wk = (CTWK*)work;
	
	switch(wk->seq){
	case 0:
		///< VXe
		{
			TCATS_OAM_INIT coi = {
				0,128,
				0,32,
				0,128,
				0,32,				
			};
			TCATS_CHAR_MANAGER_MAKE ccmm = {
				10,
				0x10000,
				0x10000,
			};
			CATS_SystemInit(wk->csp, &coi, &ccmm, 32);
		}
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
		wk->seq++;
		break;
	
	case 1:
		///< ZAN^[Zbg̍쐬
		{
			CATS_ClactSetInit(wk->csp, wk->crp, 10);
//			CATS_ClactSetInit(wk->csp, wk->crp2, 10);
		}
		wk->seq++;
		break;
		
	case 2:
		///< \[Xǂݍ
		{
			const TCATS_RESOURCE_NUM_LIST crnl = {
				10,10,10,10,0,0,
			};
			CATS_ResourceManagerInit(wk->csp, wk->crp, &crnl);
			
			CATS_LoadResourceCharArc(wk->csp, wk->crp,	ARC_WER_CHAR, 0, 0, 1000);
			CATS_LoadResourcePltt(wk->csp, wk->crp,		"data/ug_boygirl.NCLR", 1, 1000);
			CATS_LoadResourceCell(wk->csp, wk->crp,		"data/ug_hero.NCER", 1000);
			CATS_LoadResourceCellAnm(wk->csp, wk->crp,	"data/ug_hero.NANR", 1000);
			
#if 0
			///< ψǂݍ
			CATS_ResourceLoad_FileName(wk->csp, wk->crp,
									   "data/dt_test_res_char.txt",		///< LN^
									   "data/dt_test_res_pltt.txt",		///< pbg
									   "data/dt_test_res_cell.txt",		///< Z
									   "data/dt_test_res_cellanm.txt",	///< ZAj
									// "data/dt_test_res_multi.txt",	///< }`Z
									// "data/dt_test_res_multianm.txt",	///< }`ZAj
									   "data/dt_test_celact.txt");		///< wb_[
			#if 0
			CATS_ResourceLoad_FileName(wk->csp, wk->crp2,
									   "data/dt_test_res_char.txt",		///< LN^
									   "data/dt_test_res_pltt.txt",		///< pbg
									   "data/dt_test_res_cell.txt",		///< Z
									   "data/dt_test_res_cellanm.txt",	///< ZAj
									// "data/dt_test_res_multi.txt",	///< }`Z
									// "data/dt_test_res_multianm.txt",	///< }`ZAj
									   "data/dt_test_celact2.txt");		///< wb_[
			#endif
#endif
#if 0
			///< \̈ǂݍ
			TCATS_RESOURCE_FILE_LIST res_list = {
				"data/dt_test_res_char.txt",	///< LN^
				"data/dt_test_res_pltt.txt",	///< pbg
				"data/dt_test_res_cell.txt",	///< Z
				"data/dt_test_res_cellanm.txt",	///< ZAj
				"data/dt_test_res_multi.txt",	///< }`Z
				"data/dt_test_res_multianm.txt",///< }`ZAj
				"data/dt_test_celact.txt",		///< wb_[
			};
			CATS_ResourceLoad(wk->csp, wk->crp, &res_list);
#endif
#if 0
			///< e[uIDwǂݍ
			CATS_ResourceLoad_ListNo(wk->csp, wk->crp, 0);
#endif
		}
		wk->seq++;
		break;
		
	case 3:
		///< OBJo^
		{
			const TCATS_OBJECT_ADD_PARAM coap1 = {
				0,128,128,0,
				0,0,0,0,
				0,0,0,0,
			};
			const TCATS_OBJECT_ADD_PARAM coap2 = {
				0,256,256,0,
				0,0,0,0,
				0,0,0,0,
			};
			const TCATS_OBJECT_ADD_PARAM_S coap3 = {
				128,128, 0,
				0, 0, 0, 0,
				
				{ 1000, 1000, 1000, 1000, 0, 0 },
				
				1,
				0,
			};
			const TCATS_OBJECT_ADD_PARAM_S coap4 = {
				128,198, 0,
				0, 0, 0, 0,
				
				{ 1000, 1000, 1000, 1000, 0, 0 },
				
				1,
				0,
			};

			wk->cap  = CATS_ObjectAdd_S(wk->csp, wk->crp, &coap3);
			wk->cap2 = CATS_ObjectAdd_S(wk->csp, wk->crp, &coap4);
			
			CATS_FreeResourceChar(wk->crp, 1001);
			
//			wk->act[wk->act_no++] = CATS_ObjectAdd(wk->csp, wk->crp, &coap1);
//			wk->act[wk->act_no++] = CATS_ObjectAdd(wk->csp, wk->crp2, &coap2);
		}
		wk->seq++;
		break;
		
	case 4:
		///< \
		{
			CATS_ObjectUpdate(wk->cap->act);
			CATS_ObjectRotationAdd(wk->cap->act, 5000);	
			CATS_ObjectUpdate(wk->cap2->act);
			CATS_ObjectRotationAdd(wk->cap2->act, -5000);
			CATS_Draw(wk->crp);
			
//			CATS_Draw(wk->crp2);
//			CATS_Draw(wk->crp2);
#if 0
			CATS_ObjectUpdate(wk->act[0]);
			CATS_ObjectRotationAdd(wk->act[0], 5000);	
			CATS_Draw(wk->crp);
#endif
#if 0
			CATS_ObjectUpdate(wk->act[1]);
			CATS_ObjectScaleAdd(wk->act[1], 0.01f, 0.01f);
			CATS_ObjectPosMove(wk->act[1], -1, -1);
			CATS_Draw(wk->crp2);
#endif	
			CATS_UpdateTransfer();
			CATS_RenderOamTrans();
		}
		if (sys.trg & PAD_BUTTON_B){
			wk->seq = 0xff;
		}
		break;
		
	default:
		///< j
#if 0
		CATS_ObjectDel(wk->act[0]);
		CATS_ResourceDestructor(wk->csp, wk->crp);
//		CATS_ObjectDel(wk->act[1]);
//		CATS_ResourceDestructor(wk->csp, wk->crp2);
#endif
		CATS_ActorPointerDelete_S(wk->cap);
		CATS_ActorPointerDelete_S(wk->cap2);
//		CATS_ActorPointerDelete_S(wk->cap3);
//		CATS_ActorPointerDelete_S(wk->cap4);
		CATS_ResourceDestructor_S(wk->csp, wk->crp);
//		CATS_ResourceDestructor_S(wk->csp, wk->crp2);
		CATS_FreeMemory(wk->csp);
		sys_FreeMemoryEz(wk);
		TCB_Delete(tcb);
		break;
	};
#endif
}

static void ClactTool(void)
{
	CTWK* wk;
	
	wk = sys_AllocMemory(HEAPID_BASE_DEBUG, sizeof(CTWK));
	
	if (wk == NULL){ return; }
	
	wk->csp = CATS_AllocMemory(HEAPID_BASE_DEBUG);
	
	if (wk->csp == NULL){
		sys_FreeMemoryEz(wk);
		return;
	}
	
	wk->crp = CATS_ResourceCreate(wk->csp);
//	wk->crp2 = CATS_ResourceCreate(wk->csp);
	
	CATS_RenderUseSet(wk->csp,	CATS_RENDER_USE_OFF); 
	
	if (wk->crp == NULL){
		sys_FreeMemoryEz(wk);
		sys_FreeMemoryEz(wk->csp);
		return;
	}
	
	wk->seq		= 0;
	wk->act_no	= 0;
	
	TCB_Add(ClactToolTCB, wk, 0);
}
#endif

