/**
 *	@file	d_iwa.c
 *	@brief	VfobOp\[X
 *	@author	Miyuki Iwasawa
 *	@date	04.12.04
 * */

#ifdef PM_DEBUG

#include "common.h"
#include "fld_bmp.h"
#include "fntsys.h"
#include "talk_msg.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/brightness.h"
#include "system/fontproc.h"
#include "system/wipe.h"
#include "gflib/strbuf.h"
#include "gflib/strbuf_family.h"
#include "field/fieldsys.h"
#include "field/field.h"
#include "field/ev_mapchange.h"
#include "field/fieldmap.h"
#include "field/zonedata.h"
#include "field/field_event.h"
#include "field/field_matrix.h"
#include "field/fld_mailbox.h"
#include "fielddata/maptable/zone_id.h"
#include "application/worldmap/townmap.h"
#include "application/mailtool.h"
#include "application/poru_tool.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_debug_miyuki.h"

extern void FieldBitMapWinCgxSet( GF_BGL_INI * ini );

#define DIWA_HEAP_PRINT(no) {\
 OS_Printf( "\nINFO : d_iwa.c NO.%d\n",no );	\
 OS_Printf( "DEBUG_IWASAWA_HEAP_SIZE : 0x%x\n", sys_GetHeapFreeSize( HEAPID_BASE_DEBUG ) ); \
}

// OS_Printf( "\nINFO : fld_menu.c\n" );	\
//extern void FieldTMap_SetProc(FIELDSYS_WORK*,u8,void*);
//=============================
///	fobOVXep\
//=============================
typedef struct _DebugWork{
	u8	ct;
	u8	work;
	u8	page;
	u8	task_id;
	int		wipe_f;
	void	*UserFunc;
	void	*RetFunc;
	void*	subWork;
	FIELDSYS_WORK	*fsys;

	u8		seq;
	u8		func_mode;
	u16		List;
	u16		Cursor;
	int		ret_x;
	int		ret_z;
	int		ret_zone;
	int		ret_val;
	BMPLIST_HEADER	bmplist_h;
	BMPLIST_WORK* blistWk; 
	BMPLIST_DATA* menulist; 

	GF_BGL_INI* pBglIni;
	GF_BGL_BMPWIN bmpwin;
}_DebugWork;

#define DW0_CGX	(1)
#define DW0_SX	(12)
#define DW0_SY	(14)
#define DW0_CGXNUM	(DW0_SX*DW0_SY)
#define DW0_PAL	(FLD_SYSFONT_PAL)

static const BMPWIN_DAT d_miyuki_BmpDat[] = {
 {GF_BGL_FRAME3_M,  1,  1, DW0_SX, DW0_SY, DW0_PAL, DW0_CGX },
 { 0xFF, 0, 0, 0, 0, 0, 0 },
};

static void DebugMenuExit(TCB_PTR tcb,void* work);
//tmap
static void DebugSub_TMapNormalInit(void* work);
static void DebugSub_TMapJumpInit(void* work);

//mail system
static void DebugSubMenu_MailBoxCall(TCB_PTR tcb,void* work);
static void DebugSub_MailCreateInit(void* work);
static void DebugSub_MailViewInit(void* work);

//poruto
static void DebugSub_PoruCaseInit(void* work);
static void DebugSub_PorutoDataMake(void* work,int mode);

//------------------------------------------------------------------
///	j[Xgf[^
//------------------------------------------------------------------
typedef struct{
	u32	str_id;
	u32	param;
}MENU_PARAM;

static const MENU_PARAM MiyukiMenuList[] = {
	{ msg_label_tmap,	 BMPLIST_RABEL},			//x01
	{ msg_dtmapN, (u32)DebugSub_TMapNormalInit},	//00:[h}bv
	{ msg_dtmapJ, (u32)DebugSub_TMapJumpInit},		//00:[h}bv
	{ msg_label_mail,	 BMPLIST_RABEL},			//x02
	{ msg_dmailV, 2},		//00:[
	{ msg_dmailC, 3},		//00:[쐬
	{ msg_label_poruto,	 BMPLIST_RABEL},			//x02
	{ msg_porucase,4},		//00:|gP[X
	{ msg_poru_allmake,5},	//00:|g
	{ msg_poru_alldel,6},		//00:|gP[X
	{ msg_exit,		 0x00000001},		//00:
	{ msg_label_end,	 BMPLIST_RABEL},			//x02
};

#define BLIST_NUM	NELEMS(MiyukiMenuList)

///	XgVXẽR[obNs\
static void	InfoCallBack(BMPLIST_WORK* lw,u32 param,u8 y)
{
	if(param == BMPLIST_RABEL){
		BmpListTmpColorChange(lw,FBMP_COL_BLU_SDW,FBMP_COL_BLACK,FBMP_COL_BLUE);
	}else{
		BmpListTmpColorChange(lw,FBMP_COL_WHITE,FBMP_COL_BLACK,FBMP_COL_BLK_SDW);
	}
}

//------------------------------------------------------------------
///	ڃXgf[^
//------------------------------------------------------------------
static const BMPLIST_HEADER DebugListHeader = {
	NULL,			//\f[^|C^
	NULL,				//J[\ړƂ̃R[obN֐
	InfoCallBack,		//PsƂ̃R[obN֐
	NULL,				//GF_BGL_BMPWIN\̃f[^ւ̃|C^
	BLIST_NUM,			//Xgڐ
	6,					//\ő區ڐ
	2,					//x\wW
	12,					//ڕ\wW
	1,					//J[\\wW
	2,					//\xW
	FBMP_COL_WHITE,		//F
	FBMP_COL_BLACK,		//wiF
	FBMP_COL_BLK_SDW,	//eF
	0,					//Ԋuw
	1,					//Ԋux
	BMPLIST_LRKEY_SKIP,	//y[WXLbv^Cv
	FONT_SYSTEM,		//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	NULL,				//[N|C^
};

//vg^Cv
void DebugMiyukiInit(void* fsys);
void DIWA_Return3DMap(void);
/**
 *	fobOVXe
 *
 *	u8	DebugMiyukiInit(void* fsys)
 *
 *	@param	void* FLD_DEB_DATւ̃|C^
 *	@return none
 */
static void DebugMiyukiMain(TCB_PTR tcb,void* work);
static void DebugMiyukiEnd(TCB_PTR tcb,void* work);
static void DebugMiyukiViewInit(_DebugWork* wp,void* fsys,u8 list,u8 cursor,
				const MENU_PARAM* menuParam,u32 size);
static void DebugMiyukiViewEnd(_DebugWork* wp);
static void DebugMiyukiFuncCall(TCB_PTR tcb,void* work);


enum{
	DMSEQ_FADEOUT = 0,
	DMSEQ_FADEOUTWAIT,
	DMSEQ_FUNC,
	DMSEQ_FADEIN,
	DMSEQ_FADEINWAIT,
	DMSEQ_JUMPIN,
	DMSEQ_JUMPWAIT,
};
static void DebugMiyukiViewInit(_DebugWork* wp,void* fsys,u8 list,u8 cursor,const MENU_PARAM* menuParam,u32 size)
{
	int i;
	
	wp->fsys =fsys;
	
	//BMPEBhE(FieldSys̏f[^擾)
	wp->pBglIni = FieldBglIniGet(fsys);
	
	//EBhELN^Zbg
	FieldBitMapWinCgxSet(wp->pBglIni);

	GF_BGL_ScrFill(wp->pBglIni,GF_BGL_FRAME3_M,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
	GF_BGL_LoadScreenV_Req(wp->pBglIni,GF_BGL_FRAME3_M);

	//NA
	memset(&(wp->bmpwin),0,sizeof(GF_BGL_BMPWIN));
	wp->List = list;

	//BMPMAPj[ǉ
	wp->menulist = BMP_MENULIST_Create(size,HEAPID_BASE_DEBUG);
	GF_BGL_BmpWinAddEx(wp->pBglIni,&(wp->bmpwin),d_miyuki_BmpDat);

	if(menuParam != NULL){
		MSGDATA_MANAGER* msgman;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL,ARC_MSG,
					NARC_msg_debug_miyuki_dat,HEAPID_BASE_DEBUG);

		for(i = 0;i < size;i++){
			BMP_MENULIST_AddArchiveString(wp->menulist,
				msgman, menuParam[i].str_id, menuParam[i].param );
		}
		MSGMAN_Delete(msgman);
	}else{
		STRCODE	tmpbuf[128];
		STRBUF	*mstr = STRBUF_Create(128,HEAPID_BASE_DEBUG);
		for(i = 0;i < size;i++){
			PM_strclear(tmpbuf,EOM_,128);
			STRBUF_Clear(mstr);
			
			//][擾
			if(ASCIIcode2DSuni(0,(u8*)ZoneData_GetZoneName(i+2),tmpbuf)){
				tmpbuf[0] = EOM_;
			}
			STRBUF_SetStringCode(mstr,tmpbuf);
			BMP_MENULIST_AddString(wp->menulist,mstr,i+2);
		}
		STRBUF_Delete(mstr);
	}
	
	//BMPXgݒ
	memcpy(&(wp->bmplist_h),&DebugListHeader,sizeof(BMPLIST_HEADER));
	wp->Cursor = cursor;
	wp->bmplist_h.win = &(wp->bmpwin);
	wp->bmplist_h.list = wp->menulist;
	wp->bmplist_h.work = (void*)wp->blistWk;
	wp->bmplist_h.count = size;
	wp->blistWk = BmpListSet(&(wp->bmplist_h),wp->List,wp->Cursor,HEAPID_BASE_DEBUG);
}

static void DebugMiyukiViewEnd(_DebugWork* wp)
{
	//BMPWINj
	GF_BGL_BmpWinOff(&(wp->bmpwin));	//WindowOFF
	//BMPXg̊J
	BmpListExit(wp->blistWk,&(wp->List),&(wp->Cursor));	//Xgj
	BMP_MENULIST_Delete(wp->menulist);	//j[j
	GF_BGL_BmpWinDel(&(wp->bmpwin));	//BMPWindowDel
}

void DebugMiyukiInit(void* fsys)
{
	TCB_PTR	pTcb = NULL;
	_DebugWork *wp = NULL;
	GF_BGL_INI *ini = NULL;

	//fobOVXem
	wp = sys_AllocMemory(HEAPID_BASE_DEBUG,sizeof(_DebugWork));

	if(wp == NULL){
		//[NmۂłȂΉȂ
		OS_Printf("iwasawa debug menu create field\n");
		return;
	}
	memset(wp,0,sizeof(_DebugWork));

	DebugMiyukiViewInit(wp,fsys,0,1,MiyukiMenuList,NELEMS(MiyukiMenuList));
	wp->seq = DMSEQ_FADEOUT;

	pTcb = TCB_Add(DebugMiyukiMain,wp,0);
}

//=============================================================================
/**
 *	fobOVXeL[擾(C^XN)
 *	void DebugMiyukiMain(u8 id);
 *
 *	@param	tcb	TCB_PTR	^XNubN|C^	
 *	@param	work	^XN[N|C^	
 *	@return	none
 */
//=============================================================================
static void DebugMiyukiMain(TCB_PTR tcb,void* work)
{
	s32	ret_code;
	TCB_FUNC	func;
	_DebugWork	*wp;

	wp = (_DebugWork*)work;

	ret_code = BmpListMain(wp->blistWk);

	//L[씻
	if(sys.trg & PAD_BUTTON_DECIDE){
		switch(ret_code){
		case BMPMENU_NULL:
		case BMPMENU_CANCEL:
			DebugMiyukiEnd(tcb,work);
			return;
		default:
			switch(ret_code){
			case 0:
				return;
			case 1:	//j[I
				DebugMiyukiEnd(tcb,work);
				return;
			case 2:	//[
			case 3:
				wp->ret_val = ret_code-2;
				DebugSubMenu_MailBoxCall(tcb,work);
				return;
			case 4:	//|gP[X
				wp->UserFunc = DebugSub_PoruCaseInit;
				TCB_ChangeFunc(tcb,DebugMiyukiFuncCall);
				wp->func_mode = 2;
				return;
			case 5:	//|g^
				DebugSub_PorutoDataMake(wp,0);
				DebugMiyukiEnd(tcb,work);
				return;
			case 6:	//|g
				DebugSub_PorutoDataMake(wp,1);
				DebugMiyukiEnd(tcb,work);
				return;
			default:
				//֐|C^ۑ
				wp->UserFunc = (void*)ret_code;
				TCB_ChangeFunc(tcb,DebugMiyukiFuncCall);

				if(	ret_code == (u32)DebugSub_TMapNormalInit ||
					ret_code == (u32)DebugSub_TMapJumpInit){
					wp->func_mode = 1;
				}
			}
			return;
		}
		return;
	}
	//j[LZ
	if(sys.trg & PAD_BUTTON_B){
		DebugMiyukiEnd(tcb,work);
		return;
	}
}

/**
 *	@brief	fobOj[̏I
 *
 *	fobOj[p[NƃXg̔js
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
static void DebugMiyukiEnd(TCB_PTR tcb,void* work)
{
	_DebugWork	*wp = (_DebugWork*)work;

	DebugMiyukiViewEnd(wp);

	//fobO[NJ
	sys_FreeMemoryEz(work);
	TCB_Delete(tcb);

	//OBJ̓~
	FieldSystemProc_SeqHoldEnd();
	return;
}

static void DebugMiyukiSubMenuWait(TCB_PTR tcb,void* work)
{
	_DebugWork	*wp = (_DebugWork*)work;
	
	if(!wp->ret_val){
		return;
	}
	wp->ret_val = 0;
	//fobOj[A
	DebugMiyukiViewInit(wp,wp->fsys,wp->List,wp->Cursor,MiyukiMenuList,NELEMS(MiyukiMenuList));
	TCB_ChangeFunc(tcb,DebugMiyukiMain);
}

static void DebugMiyukiFuncCall(TCB_PTR tcb,void* work)
{
	_DebugWork	*wp = (_DebugWork*)work;
	TOWNMAP_PARAM	*twork;

	switch(wp->seq){
	case DMSEQ_FADEOUT:
		wp->wipe_f = 0;
		WIPE_Start(WIPE_PATTERN_WMS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,0x0000,COMM_BRIGHTNESS_SYNC,1,HEAPID_BASE_DEBUG,&(wp->wipe_f)
				);

		wp->seq = DMSEQ_FADEOUTWAIT;
		break;
	case DMSEQ_FADEOUTWAIT:
		if(!wp->wipe_f){
			break;
		}
		DebugMiyukiViewEnd(wp);
		//t@NVsAvZXo^
		{
			void (*dproc_call)(void*);
			dproc_call = wp->UserFunc;
			(*dproc_call)(wp);
			FieldSystemProc_SeqHoldEnd();
		}
		wp->seq = DMSEQ_FUNC;
		break;
	case DMSEQ_FUNC:
		//vZXI҂
		if(FieldEvent_Cmd_WaitSubProcEnd(wp->fsys)){
			break;
		}
		//mۂĂΉ
		if(wp->subWork != NULL){
			switch(wp->func_mode){
			case 1:
				twork = (TOWNMAP_PARAM*)wp->subWork;
				if(twork->retval){
					wp->ret_x = twork->ret_x;
					wp->ret_z = twork->ret_z;
					wp->ret_zone = twork->ret_zone;
					wp->ret_val = twork->retval;
					wp->seq = DMSEQ_JUMPIN;
				}else{
					wp->ret_x = 0;
					wp->ret_z = 0;
					wp->seq = DMSEQ_FADEIN;
				}
				sys_FreeMemoryEz(wp->subWork);
				break;
			case 2:
				wp->seq = DMSEQ_FADEIN;
				PorutoSys_ReleaseCallWork(wp->subWork);
				break;
			default:
				wp->seq = DMSEQ_FADEIN;
				sys_FreeMemoryEz(wp->subWork);
				break;
			}
			wp->subWork = NULL;
		}else{
			wp->seq = DMSEQ_FADEIN;
		}
		//tB[h}bvvZXA
		FieldEvent_Cmd_SetMapProc(wp->fsys);
		break;
	case DMSEQ_FADEIN:
		//tB[hvZXJnI҂
		if(FieldEvent_Cmd_WaitMapProcStart(wp->fsys)){
			//fobOj[A
			DebugMiyukiViewInit(wp,wp->fsys,wp->List,wp->Cursor,MiyukiMenuList,NELEMS(MiyukiMenuList));
			//ubNCNGXg
			wp->wipe_f = 0;
			WIPE_Start(WIPE_PATTERN_WMS,
				WIPE_TYPE_FADEIN,
				WIPE_TYPE_FADEIN,0x0000,COMM_BRIGHTNESS_SYNC,1,HEAPID_BASE_DEBUG,&(wp->wipe_f)
				);
			wp->seq = DMSEQ_FADEINWAIT;
			break;
		}
		break;
	case DMSEQ_FADEINWAIT:
		if(!wp->wipe_f){
			break;
		}
		FieldSystemProc_SeqHold();
		TCB_ChangeFunc(tcb,DebugMiyukiMain);
		wp->seq = DMSEQ_FADEOUT;
		break;
	case DMSEQ_JUMPIN:
		//tB[hvZXJnI҂
		if(FieldEvent_Cmd_WaitMapProcStart(wp->fsys)){
			wp->wipe_f = 0;
			WIPE_Start(WIPE_PATTERN_WMS,
				WIPE_TYPE_FADEIN,
				WIPE_TYPE_FADEIN,0x0000,COMM_BRIGHTNESS_SYNC,1,HEAPID_BASE_DEBUG,&(wp->wipe_f)
				);
			GF_BGL_ScrFill(wp->pBglIni,GF_BGL_FRAME3_M,0x0000,0,0,32,32,GF_BGL_SCRWRT_PALIN);
			GF_BGL_LoadScreenV_Req(wp->pBglIni,GF_BGL_FRAME3_M);
			wp->seq = DMSEQ_JUMPWAIT;
			break;
		}
		break;
	case DMSEQ_JUMPWAIT:
		if(!wp->wipe_f){
			break;
		}
		EventSet_MapChange(wp->fsys,
			wp->ret_zone,DOOR_ID_JUMP_CODE,
			wp->ret_x*32+16,wp->ret_z*32+16, DIR_DOWN);
		
		//fobO[NJ
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);

		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
		break;
	}
}

/**
 *	@brief	fobOj[
 */
static void DebugMenuExit(TCB_PTR tcb,void* work)
{
	DebugMiyukiEnd(tcb,work);	
}

/**
 *	@brief	fobOj[@^E}bvĂяo
 */
//extern void FieldTMap_CallDataSet(FIELDSYS_WORK* fsys,TOWNMAP_PARAM *tp,int mode);

static void* DebugTMapCall(FIELDSYS_WORK* fsys,u8 mode)
{
	TOWNMAP_PARAM * tp;
	tp = sys_AllocMemoryLo(HEAPID_BASE_DEBUG, sizeof(TOWNMAP_PARAM));

	FieldTMap_CallDataSet(fsys,tp,mode);
	FieldTMap_SetProc( fsys, tp );
	return tp;
}
/**
 *	@brief	fobOj[@^E}bvĂяoV[PX
 */
static void DebugSub_TMapNormalInit(void* work)
{
	_DebugWork	*wp = (_DebugWork*)work;

	wp->subWork = DebugTMapCall(wp->fsys,TMAP_MNORMAL);
}
/**
 *	@brief	fobOj[@^E}bvĂяoV[PX
 */
static void DebugSub_TMapJumpInit(void* work)
{
	_DebugWork	*wp = (_DebugWork*)work;

	wp->subWork = DebugTMapCall(wp->fsys,TMAP_MJUMP);
}

static void DebugSubMenu_MailBoxCall(TCB_PTR tcb,void* work)
{
	_DebugWork *wp  =(_DebugWork*)work;
	
	//fobOj[EBhEj
	DebugMiyukiViewEnd(wp);

	//[{bNX^XNo^
	MailBox_Call(wp->fsys,&(wp->ret_val));
	TCB_ChangeFunc(tcb,DebugMiyukiSubMenuWait);
}

/**
 *	@brief	fobOj[@[쐬Ăяo
 */
static void DebugSub_MailCreateInit(void* work)
{
	_DebugWork *wp  =(_DebugWork*)work;

	wp->subWork =  FieldMailCreate_InitCall( wp->fsys ,
		MAILBLOCK_TEMOTI,0,0,HEAPID_BASE_DEBUG);
}

/**
 *	@brief	fobOj[@[`Ăяo
 */
static void DebugSub_MailViewInit(void* work)
{
	_DebugWork *wp  = (_DebugWork*)work;

	wp->subWork =  FieldMailView_InitCall(wp->fsys,
		MAILBLOCK_TEMOTI,0,HEAPID_BASE_DEBUG);
}

/**
 *	@brief	fobOj[@|gP[XĂяo
 */
static void DebugSub_PoruCaseInit(void* work)
{
	_DebugWork *wp  = (_DebugWork*)work;
	wp->subWork = FieldPorutoCase_InitCall(wp->fsys,HEAPID_BASE_DEBUG);
}

/**
 *	@brief	fobOj[@|gf[^쐬
 */
static void DebugSub_PorutoDataMake(void* work,int mode)
{
	_DebugWork *wp  = (_DebugWork*)work;
	PORUTO_BLOCK* block = NULL;

	block = SaveData_GetPorutoBlock(GameSystem_GetSaveData(wp->fsys));

	if(mode == 0){
		PorutoDebug_AddRndData(block,10);
	}else{
		PorutoDebug_AllDataDelete(block);
	}
}
#endif	//PM_DEBUG
