//******************************************************************************
/**
 * 
 * @file	d_kaga.c
 * @brief	tB[hfobOj[@
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
//----
#ifdef PM_DEBUG
//----
#include "common.h"
#include "fieldsys.h"
#include "fieldmap.h"
#include "field_effect.h"
#include "fieldobj.h"
#include "player.h"

#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/pm_str.h"

//==============================================================================
//	define
//==============================================================================
#define HEAPID_D_KAGA (HEAPID_FIELD)

#define MENU_X_CHAR_SIZE (10)
#define MENU_Y_CHAR_SIZE (20)	//1 2

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
//	j[Ăяo֐
//--------------------------------------------------------------
typedef void (*MENU_PROC)(void*);

//--------------------------------------------------------------
//	fobO[N
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	MENU_PROC select_func;
	FIELDSYS_WORK *fsys;
	GF_BGL_BMPWIN bmpwin;
	BMPLIST_WORK *bmplist;
}D_KAGA_WORK;

//==============================================================================
//	vg^Cv
//==============================================================================
void DebugKagayaMenuInit( FIELDSYS_WORK *fsys );
static void D_KagaMenuMain( TCB_PTR tcb, void *wk );
static void D_KagaMenuEnd( D_KAGA_WORK *work, TCB_PTR tcb );

static void * D_KagaAllocMemory( int size );
static void D_KagaFreeMemory( void *mem );

static const BMPLIST_HEADER DATA_MenuListHeader;

//==============================================================================
//	fobOj[
//==============================================================================
//--------------------------------------------------------------
///	j[
//--------------------------------------------------------------
void DebugKagayaMenuInit( FIELDSYS_WORK *fsys )
{
	BMPLIST_HEADER	list_h;
	GF_BGL_INI *bgl = FieldBglIniGet( fsys );
	D_KAGA_WORK *work = D_KagaAllocMemory( sizeof(D_KAGA_WORK) );
	
	memset( work, 0, sizeof(D_KAGA_WORK) );
	
	work->fsys = fsys;
	GF_BGL_BmpWinAdd( bgl, &work->bmpwin, FLD_MBGFRM_FONT,
			1, 1, MENU_X_CHAR_SIZE, MENU_Y_CHAR_SIZE, 13, 1 );
	
	list_h = DATA_MenuListHeader;
	list_h.win = &work->bmpwin;
	work->bmplist = BmpListSet( &list_h, 0, 0, HEAPID_D_KAGA );
	GF_BGL_BmpWinOn( &work->bmpwin );
	
	TCB_Add( D_KagaMenuMain, work, 0 );
}

//--------------------------------------------------------------
//	C
//--------------------------------------------------------------
static void D_KagaMenuMain( TCB_PTR tcb, void *wk )
{
	u32 ret;
	D_KAGA_WORK *work = wk;
	
	switch( work->seq_no ){
	case 0:
		ret = BmpListMain( work->bmplist );
		
		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			D_KagaMenuEnd( work, tcb );
			FieldSystemProc_SeqHoldEnd();
			break;
		default:
			work->select_func = (MENU_PROC)ret;
			work->seq_no++;
		}
		
		break;
	case 1:
		work->select_func( work );
		D_KagaMenuEnd( work, tcb );
		FieldSystemProc_SeqHoldEnd();
		break;
	}
}

//--------------------------------------------------------------
//	j[I
//--------------------------------------------------------------
static void D_KagaMenuEnd( D_KAGA_WORK *work, TCB_PTR tcb )
{
	BmpListExit( work->bmplist, NULL, NULL );
	
	GF_BGL_BmpWinOff( &work->bmpwin );
	GF_BGL_BmpWinDel( &work->bmpwin );
	
	D_KagaFreeMemory( work );
	TCB_Delete( tcb );
}

//==============================================================================
//	p[c
//==============================================================================
//--------------------------------------------------------------
//	m
//--------------------------------------------------------------
static void * D_KagaAllocMemory( int size )
{
	void *mem = sys_AllocMemory( HEAPID_D_KAGA, size );
	memset( mem, 0, size );
	return( mem );
}

//--------------------------------------------------------------
//	J
//--------------------------------------------------------------
static void D_KagaFreeMemory( void *mem )
{
	sys_FreeMemory( HEAPID_D_KAGA, mem );
}

//==============================================================================
//	AjR}heXg
//==============================================================================
//--------------------------------------------------------------
///	R}heXg@[N
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	TCB_PTR tcb;
	FIELDSYS_WORK *fsys;
}D_ACMD_TEST_WORK;

//--------------------------------------------------------------
//	R[he[u
//--------------------------------------------------------------
static const FIELD_OBJ_ACMD_LIST DATA_DEBUG_AcmdList[] =
{
	{AC_JUMPHI_L_1G_16F,1},
	{AC_JUMPHI_R_1G_16F,1},
	{AC_JUMPHI_L_3G_32F,1},
	{AC_JUMPHI_R_3G_32F,1},
	{ACMD_END,0},
//	{AC_MARK_GYOE,1},{ACMD_END,0},
//	{AC_WARP_UP,1},{AC_WAIT_1F,16},{AC_WARP_DOWN,1},{ACMD_END,0},
	
	{AC_STAY_JUMP_U_16F,1},
//	{AC_DIR_PAUSE_ON,1},{AC_ANM_PAUSE_ON,1},
	{AC_STAY_JUMP_D_16F,1},{AC_STAY_JUMP_L_16F,1},{AC_STAY_JUMP_R_16F,1},
	{AC_STAY_JUMP_U_8F,1},{AC_STAY_JUMP_D_8F,1},{AC_STAY_JUMP_L_8F,1},{AC_STAY_JUMP_R_8F,1},
	{AC_JUMP_U_1G_8F,1},{AC_JUMP_D_1G_8F,2},{AC_JUMP_U_1G_8F,1},
	{AC_JUMP_L_1G_8F,1},{AC_JUMP_R_1G_8F,2},{AC_JUMP_L_1G_8F,1},
	{AC_JUMP_U_2G_16F,1},{AC_JUMP_D_2G_16F,2},{AC_JUMP_U_2G_16F,1},
	{AC_JUMP_L_2G_16F,1},{AC_JUMP_R_2G_16F,2},{AC_JUMP_L_2G_16F,1},
	{AC_STAY_JUMP_D_8F,1},{ACMD_END,0},
	
	{ACMD_END,0},
};

//--------------------------------------------------------------
//	R}heXgCxg
//--------------------------------------------------------------
static BOOL D_KagaEvent_AcmdTest( GMEVENT_CONTROL *ev )
{
	D_ACMD_TEST_WORK *work = FieldEvent_GetSpecialWork( ev );
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( work->fsys->player );
	
	switch( work->seq_no ){
	case 0:
		if( FieldOBJ_AcmdListEndCheck(work->tcb) == FALSE ){
			break;
		}
		
		FieldOBJ_AcmdListEnd( work->tcb );
		D_KagaFreeMemory( work );
		OS_Printf( "R}heXgI\n" );
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
//	R}heXg
//--------------------------------------------------------------
static void D_KagaAcmdTestInit( D_KAGA_WORK *kaga )
{
	FIELD_OBJ_PTR fldobj;
	D_ACMD_TEST_WORK *work = D_KagaAllocMemory( sizeof(D_ACMD_TEST_WORK) );
	
	work->fsys = kaga->fsys;
	fldobj = Player_FieldOBJGet( work->fsys->player );
	
	if( FieldOBJ_AcmdSetCheck(fldobj) == FALSE ){
		D_KagaFreeMemory( work );
		OS_Printf( "R}heXgo܂\n" );
		return;
	}
	
	work->tcb = FieldOBJ_AcmdListSet( fldobj, DATA_DEBUG_AcmdList );
	FieldEvent_Set( work->fsys, D_KagaEvent_AcmdTest, work );
	OS_Printf( "R}heXgJn\n" );
}

//==============================================================================
//	肱ݕ\
//==============================================================================
//--------------------------------------------------------------
//	f荞ݏ
//--------------------------------------------------------------
static void D_KagaReflectInit( D_KAGA_WORK *kaga )
{
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( kaga->fsys->player );
	FE_FldOBJReflect_Add( fldobj );
	OS_Printf( "f荞݂Zbg\n" );
}

//==============================================================================
//	@Rړ
//==============================================================================
//--------------------------------------------------------------
///	Rړ@[N
//--------------------------------------------------------------
typedef struct
{
	int seq_no;
	FIELDSYS_WORK *fsys;
	PLAYER_STATE_PTR jiki;
}D_JIKI_FREE_MOVE_WORK;

#define D_JIKI_FREE_MOVE_WORK_SIZE (sizeof(D_JIKI_FREE_MOVE_WORK))

#define FREE_X_SPEED (FX32_ONE * 2)
#define FREE_Z_SPEED (FX32_ONE * 2)
#define FREE_Y_SPEED (FX32_ONE * 2)
#define FREE_SPEED_UP (4)

//--------------------------------------------------------------
//	RړCxg
//--------------------------------------------------------------
static BOOL D_KagaEvent_FreeMove( GMEVENT_CONTROL *ev )
{
	D_JIKI_FREE_MOVE_WORK *work = FieldEvent_GetSpecialWork( ev );
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( work->jiki );
	u16 trg = sys.trg;
	u16 prs = sys.cont;
	int speed = 1;
	VecFx32 vec;
	
	if( FieldOBJ_AcmdSetCheck(fldobj) == FALSE ){
		return( FALSE );
	}
	
	FieldOBJ_VecPosGet( fldobj, &vec );
	
	if( (trg & PAD_BUTTON_B) ){
//		int gx,gy,gz;
//		FieldOBJTool_VectorGridPosGet( &gx, &gy, &gz, &vec );
//		FieldOBJ_GPosDirInit( fldobj, gz, gy, gz, FieldOBJ_DirDispGet(fldobj) );
		Player_HeightGet_ON_OFF( work->jiki, TRUE );
		D_KagaFreeMemory( work );
		OS_Printf( "RړI\n" );
		return( TRUE );
	}
	
	if( (prs & PAD_BUTTON_R) ){
		speed = FREE_SPEED_UP;
	}
	
	if( (prs & PAD_BUTTON_Y) ){
		if( (prs & PAD_KEY_UP) ){
			vec.y -= FREE_Y_SPEED * speed;
		}else if( (prs & PAD_KEY_DOWN) ){
			vec.y += FREE_Y_SPEED * speed;
		}
		
		FieldOBJ_VecPosSet( fldobj, &vec );
	}else{
		int ac = ACMD_NOT;
		
		if( (prs & PAD_KEY_UP) ){
			if( speed == FREE_SPEED_UP ){ ac = AC_WALK_U_2F; }
			else{ ac = AC_WALK_U_8F; }
		}else if( (prs & PAD_KEY_DOWN) ){
			if( speed == FREE_SPEED_UP ){ ac = AC_WALK_D_2F; }
			else{ ac = AC_WALK_D_8F; }
		}else if( (prs & PAD_KEY_LEFT) ){
			if( speed == FREE_SPEED_UP ){ ac = AC_WALK_L_2F; }
			else{ ac = AC_WALK_L_8F; }
		}else if( (prs & PAD_KEY_RIGHT) ){
			if( speed == FREE_SPEED_UP ){ ac = AC_WALK_R_2F; }
			else{ ac = AC_WALK_R_8F; }
		}
		
		if( ac != ACMD_NOT ){
			FieldOBJ_AcmdSet( fldobj, ac );
		}
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
//	Rړ
//--------------------------------------------------------------
static void D_KagaJikiFreeMoveInit( D_KAGA_WORK *kaga )
{
	D_JIKI_FREE_MOVE_WORK *work = D_KagaAllocMemory( sizeof(D_ACMD_TEST_WORK) );
	
	work->fsys = kaga->fsys;
	work->jiki = kaga->fsys->player;
	
	Player_HeightGet_ON_OFF( work->jiki, FALSE );
	FieldEvent_Set( work->fsys, D_KagaEvent_FreeMove, work );
	OS_Printf( "RړJn\n" );
}

//==============================================================================
//	Ȃ݂̂
//==============================================================================
//--------------------------------------------------------------
//	Ȃ݂̂
//--------------------------------------------------------------
static void D_KagaNaminoriInit( D_KAGA_WORK *kaga )
{
	int dir = Player_DirGet( kaga->fsys->player );

#if 1
	Player_EventNaminoriStart( dir, kaga->fsys, kaga->fsys->player );
#else
	{
		PLAYER_STATE_PTR jiki = kaga->fsys->player;
		int gx = Player_NowGPosXGet( jiki );
		int gz = Player_NowGPosZGet( jiki );
		FE_FldOBJNamiPokeSet( Player_FieldOBJGet(jiki), gx, gz, dir, FALSE );
	}
#endif
	
	OS_Printf( "Ȃ݂̂Jn\n" );
}

/*
#ifndef DEBUG_NAMIPOKE_ROT
	if( (prs & DEBUG_WALK_PAD) == 0 ){
		return( FALSE );
	}
	
	if( (trg & PAD_BUTTON_SELECT) == 0 ){
		return( FALSE );
	}
	
	EOA_Delete( DEBUG_namipoke );
	DEBUG_namipoke = NULL;
	OS_Printf( "g|P폜\n" );
	return( FALSE );
#endif
	
#ifdef DEBUG_NAMIPOKE_ROT
	{
		int x=0,y=0,z=0;
		
		if( (prs & DEBUG_WALK_PAD) == 0 ){
			return( FALSE );
		}
		
		if( (prs & PAD_KEY_LEFT) ){ x = -4; }
		if( (prs & PAD_KEY_RIGHT) ){ x = 4; }
		if( (prs & PAD_KEY_UP) ){ y = -4; }
		if( (prs & PAD_KEY_DOWN) ){ y = 4; }
		if( (prs & PAD_BUTTON_B) ){ z = -4; }
		if( (prs & PAD_BUTTON_A) ){ z = 4; }
		
		DEBUG_NamiPoke_Rot( DEBUG_namipoke, x, y, z );
		return( TRUE );
	}
#endif	
*/

//==============================================================================
//	d
//==============================================================================
//--------------------------------------------------------------
//	deXg
//--------------------------------------------------------------
static void D_KagaELightInit( D_KAGA_WORK *kaga )
{
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( kaga->fsys->player );
	FE_FldOBJELight_Add( fldobj );
	OS_Printf( "d\\n" );
}

//==============================================================================
//	䂫
//==============================================================================
//--------------------------------------------------------------
///	
//--------------------------------------------------------------
static void D_KagaSnowBallInit( D_KAGA_WORK *kaga )
{
	PLAYER_STATE_PTR jiki = kaga->fsys->player;
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
	int dir = Player_DirGet( jiki );
	int gx = Player_NowGPosXGet( jiki ) + FieldOBJ_DirAddValueGX( dir );
	int gz = Player_NowGPosZGet( jiki ) + FieldOBJ_DirAddValueGZ( dir );
	CONST_FIELD_OBJ_SYS_PTR fos = FieldOBJ_FieldOBJSysGet( fldobj );
	FIELD_OBJ_PTR front_obj = FieldOBJ_SearchGPos( fos, gx, gz );
		
	if( front_obj == NULL ){
		FieldOBJ_AddHMake( fos, gx, gz, dir, SNOWBALL, MV_DMY, 0 );
		OS_Printf( "ʂ𖄂߂܂\n" );
	}else{
		OS_Printf( "OBJאʔzus\n" );
	}
}

//==============================================================================
//	Ă񂵂
//==============================================================================
//--------------------------------------------------------------
///	]
//--------------------------------------------------------------
static void D_KagaJikiCycleInit( D_KAGA_WORK *kaga )
{
	PLAYER_STATE_PTR jiki = kaga->fsys->player;
	
	if( Player_FormGet(jiki) == HERO_FORM_CYCLE ){
		Player_RequestSet( jiki, HERO_REQBIT_NORMAL );
	}else{
		Player_RequestSet( jiki, HERO_REQBIT_CYCLE );
	}
}

//==============================================================================
//	ׂ̂ڂ
//==============================================================================
//--------------------------------------------------------------
///	ׂ̂ڂ
//--------------------------------------------------------------
static void D_KagaKabeNoboriInit( D_KAGA_WORK *kaga )
{
	int dir = Player_DirGet( kaga->fsys->player );
#if 1
	Player_EventKabeNoboriStart( dir, kaga->fsys, kaga->fsys->player );
	OS_Printf( "ǏJn\n" );
#else
	{
		PLAYER_STATE_PTR jiki = kaga->fsys->player;
		FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
		int gx = Player_NowGPosXGet( jiki );
		int gz = Player_NowGPosZGet( jiki );
		int dir = Player_DirGet( jiki );
		EOA_PTR eoa = FE_FldOBJRockRidePoke_Add( fldobj, gx, gz, dir, FALSE );
	}
#endif
}

//==============================================================================
//	ꂠ邫
//==============================================================================
//--------------------------------------------------------------
///	A
//--------------------------------------------------------------
static void D_KagaTureInit( D_KAGA_WORK *kaga )
{
	PLAYER_STATE_PTR jiki = kaga->fsys->player;
	int gx = Player_NowGPosXGet( jiki );
//	int gz = Player_NowGPosZGet( jiki ) + GRID_ONE;
	int gz = Player_NowGPosZGet( jiki );
	int dir = DIR_DOWN;
	FIELD_OBJ_PTR fldobj = FieldOBJ_AddHMake(
		kaga->fsys->fldobjsys, gx, gz, dir, BABYBOY1, MV_PAIR, 0 );
}

//==============================================================================
//	݂
//==============================================================================
//--------------------------------------------------------------
///	݂
//--------------------------------------------------------------
static void D_KagaWaterInit( D_KAGA_WORK *kaga )
{
	u32 code;
	PLAYER_STATE_PTR jiki = kaga->fsys->player;
	FIELD_OBJ_PTR fldobj = Player_FieldOBJGet( jiki );
	
	code = FieldOBJ_OBJCodeGet( fldobj );
	
	if( code == WATERHERO || code == WATERHEROINE ){
		Player_RequestSet( jiki, HERO_REQBIT_NORMAL );
	}else{
		Player_RequestSet( jiki, HERO_REQBIT_WATER );
	}
	
	Player_Request( jiki );
}

//==============================================================================
//	data
//==============================================================================
//--------------------------------------------------------------
//	j[
//--------------------------------------------------------------
static const STRCODE msg0[] = { a_,ni_,me_,te_,su_,to_,EOM_ };
static const STRCODE msg1[] = { u_,tu_,ri_,ko_,mi_,EOM_ };
static const STRCODE msg2[] = { zi_,yu_,u_,i_,do_,u_,EOM_ };
static const STRCODE msg3[] = { na_,mi_,no_,ri_,EOM_};
static const STRCODE msg4[] = { de_,n_,to_,u_,EOM_};
static const STRCODE msg5[] = { yu_,ki_,da_,ma_,EOM_};
static const STRCODE msg6[] = { zi_,te_,n_,si_,yya_,EOM_};
static const STRCODE msg7[] = { ka_,be_,no_,bo_,ri_,EOM_};
static const STRCODE msg8[] = { tu_,re_,a_,ru_,ki_,EOM_};
static const STRCODE msg9[] = { mi_,zu_,ya_,ri_,EOM_};

static const BMPLIST_DATA DATA_MenuList[] =
{
	{ msg0, (u32)D_KagaAcmdTestInit },
	{ msg1, (u32)D_KagaReflectInit },
	{ msg2, (u32)D_KagaJikiFreeMoveInit },
	{ msg3, (u32)D_KagaNaminoriInit },
	{ msg4, (u32)D_KagaELightInit },
	{ msg5, (u32)D_KagaSnowBallInit },
	{ msg6, (u32)D_KagaJikiCycleInit },
	{ msg7, (u32)D_KagaKabeNoboriInit },
	{ msg8, (u32)D_KagaTureInit },
	{ msg9, (u32)D_KagaWaterInit },
};

static const BMPLIST_HEADER DATA_MenuListHeader =
{
	DATA_MenuList,			// \f[^|C^
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,
	NELEMS(DATA_MenuList),	// Xgڐ
	NELEMS(DATA_MenuList),	// \ő區ڐ
	0,						// x\wW
	12,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};

//----
#endif	//PM_DEBUG
//----
