//==============================================================================
/**
 * @file	d_matsu.c
 * @brief	cfobOpt@C
 * @author	matsuda
 * @date	2005.06.20()
 */
//==============================================================================
#include "common.h"
#include "system/pm_overlay.h"
#include "system/test_overlay.h"

#include "system/bmp_list.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "system/fontproc.h"
#include "contest/contest.h"

#include "script.h"
#include "..\fielddata\script\connect_def.h"

#include "system/particle.h"
#include "particledata/particledata.h"
#include "particledata/particledata.naix"

#include "system/fontproc.h"
#include "system/msgdata.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_debug_matsu.h"


//==============================================================================
//	I[o[CIDextern錾
//==============================================================================
/* overlay id in *.lcf */
FS_EXTERN_OVERLAY(test_first);
FS_EXTERN_OVERLAY(test_second);
FS_EXTERN_OVERLAY(test_itcm);
FS_EXTERN_OVERLAY(test_second_abc);


//==============================================================================
//	\̐錾
//==============================================================================
//--------------------------------------------------------------
/**
 * @brief   cfobOp\
 */
//--------------------------------------------------------------
typedef struct{
	FIELDSYS_WORK *fsys;
	BMPLIST_WORK *lw;
	BMP_MENULIST_DATA *listmenu;
	GF_BGL_BMPWIN bmpwin;
	s16 wait;
	u8 main_seq;
}DMATSU_WORK;

//--------------------------------------------------------------
/**
 * @brief   cfobOp\(O[oϐ)
 */
//--------------------------------------------------------------
typedef struct{
	u8 dance_rotation_off;		///<1:_X̃[e[VȂ
}DMATSU_GLOBAL_WORK;

//==============================================================================
//	O[oϐ錾
//==============================================================================
///1:[e[VȂB@0:[e[V
u8 DmatsuWork_DanceRotationOff = 0;

//==============================================================================
//	^錾
//==============================================================================
typedef void (*pDMFunc)(DMATSU_WORK *);

//==============================================================================
//	vg^Cv錾
//==============================================================================
static void DM_MenuMain(TCB_PTR tcb, void *work);
static void DM_MenuExit(DMATSU_WORK *dm);
static void DM_ActingStart(DMATSU_WORK *dm);
static void DM_VisualStart(DMATSU_WORK *dm);
static void DM_DanceStart(DMATSU_WORK *dm);
static void DM_DanceRotatinOn(DMATSU_WORK *dm);
static void DM_DanceRotationOff(DMATSU_WORK *dm);
static void DM_ContestSioStart(DMATSU_WORK *dm);
static void DM_ResultStart(DMATSU_WORK *dm);
static void TestOverlaySet(DMATSU_WORK *dm);
static void TestSet(DMATSU_WORK *dm);
static void FieldParticleTest(DMATSU_WORK *dm);

//==============================================================================
//	fobOj[Xgpf[^
//==============================================================================
///fobOj[̍ڃbZ[W
static const STRCODE menu_msg01[] = { O_,bou_,BA_,bou_,RE_,I_,TE_,SU_,TO_,EOM_};
static const STRCODE menu_msg02[] = { TE_,SU_,TO_,EOM_,};
static const STRCODE menu_msg03[] = { e_,n_,gi_,EOM_,};
static const STRCODE menu_msg04[] = { BI_,ZI_,YYU_,A_,RU_,EOM_};
static const STRCODE menu_msg05[] = { DA_,N_,SU_,EOM_};
static const STRCODE menu_msg06[] = { tu_,u_,si_,n_,EOM_};
static const STRCODE menu_msg07[] = { PA_,bou_,TE_,II_,KU_,RU_,EOM_};

///fobOj[̍
static const struct {
	u32  str_id;
	u32  param;
}DebugMenuParamList[] = {
	{ DMMSG_ACTIN, (u32)DM_ActingStart },
	{ DMMSG_VISUAL, (u32)DM_VisualStart},
	{ DMMSG_DANCE, (u32)DM_DanceStart},
	{ DMMSG_ROTE_ON, (u32)DM_DanceRotatinOn},
	{ DMMSG_ROTE_OFF, (u32)DM_DanceRotationOff},
	{ DMMSG_TUUSHIN, (u32)DM_ContestSioStart},
	{ DMMSG_RESULT, (u32)DM_ResultStart},
	{ DMMSG_PARTICLE, (u32)FieldParticleTest },
	{ DMMSG_OVERLAY, (u32)TestOverlaySet },
	{ DMMSG_TEST, (u32)TestSet },
};


#define LIST_MENU_MAX		(NELEMS(DebugMenuParamList))

///fobOj[̃Xg
static const BMPLIST_HEADER DebugMenuListHeader = {
	NULL,			// \f[^|C^
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,
	LIST_MENU_MAX,	// Xgڐ
	LIST_MENU_MAX,						// \ő區ڐ
	0,						// x\wW
	8,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			// F
	FBMP_COL_BLACK,			// wiF
	FBMP_COL_BLK_SDW,		// eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,				// w
	0,						// afJ[\(allow)\tO(0:ON,1:OFF)
};




//--------------------------------------------------------------
/**
 * @brief   I[o[CeXg
 *
 * @param   tcb		
 * @param   work		
 */
//--------------------------------------------------------------
static void TestOverlayStart(TCB_PTR tcb, void *work)
{
	DMATSU_WORK *dm = work;
	
	if(dm->wait == 0){
		dm->wait++;
		/* address of function is specified in main.lsf */
		OS_Printf("func_1() : addr = 0x%08X.\n", test_overlay_func_1);
		OS_Printf("func_2() : addr = 0x%08X.\n", test_overlay_func_2);
		OS_Printf("func_3() : addr = 0x%08X.\n", test_overlay_itcm);
		return;
	}
	
	//OS_PrintServer();

	//e\L[ɂăI[o[Cǂݏo
	if(sys.trg & PAD_KEY_RIGHT){
		//܂ԂgpĂI[o[CSăA[h
		Overlay_UnloadSameArea(FS_OVERLAY_ID(test_first));
		//gI[o[Cs
		Overlay_Load(FS_OVERLAY_ID(test_first), OVERLAY_LOAD_NOT_SYNCHRONIZE);
	}
	else if(sys.trg & PAD_KEY_DOWN){
		Overlay_UnloadSameArea(FS_OVERLAY_ID(test_second));
		Overlay_Load(FS_OVERLAY_ID(test_second), OVERLAY_LOAD_SYNCHRONIZE_2);
		Overlay_Load(FS_OVERLAY_ID(test_second_abc), OVERLAY_LOAD_SYNCHRONIZE_2);
	}
	else if(sys.trg & PAD_KEY_LEFT){
		Overlay_UnloadSameArea(FS_OVERLAY_ID(test_itcm));
		Overlay_Load(FS_OVERLAY_ID(test_itcm), OVERLAY_LOAD_SYNCHRONIZE);
	}
	else if(sys.trg & PAD_KEY_UP){
		Overlay_UnloadSameArea(FS_OVERLAY_ID(test_second_abc));
		Overlay_Load(FS_OVERLAY_ID(test_second_abc), OVERLAY_LOAD_SYNCHRONIZE_2);
	}

	//e{^ɂăI[o[CĂt@C̊֐Ăяo
	if (sys.trg & PAD_BUTTON_A){
		test_overlay_func_1();
	}
	else if (sys.trg & PAD_BUTTON_B){
		test_overlay_func_2();
	}
	else if(sys.trg & PAD_BUTTON_Y){
		test_overlay_itcm();
	}
	else if(sys.trg & PAD_BUTTON_X){
		test_overlay_func_3();
	}
	
	if(sys.trg & PAD_BUTTON_START){
		sys_FreeMemory(HEAPID_BASE_DEBUG, dm);
		TCB_Delete(tcb);
		FieldSystemProc_SeqHoldEnd();
		return;
	}
}


//--------------------------------------------------------------
/**
 * @brief   cfobOAĂяo
 */
//--------------------------------------------------------------
void DebugMatsudaInit(FIELDSYS_WORK *fsys)
{
	DMATSU_WORK *dm;
	BMPLIST_HEADER list_h;
	
	dm = sys_AllocMemory(HEAPID_BASE_DEBUG, sizeof(DMATSU_WORK));
	memset(dm, 0, sizeof(DMATSU_WORK));
	
	//BMPEBhE
	GF_BGL_BmpWinAdd(fsys->bgl, &dm->bmpwin, 
		FLD_MBGFRM_FONT, 1, 1, 15, 20, 13, 1);
	dm->fsys = fsys;
	
	dm->listmenu = BMP_MENULIST_Create(LIST_MENU_MAX, HEAPID_BASE_DEBUG);

	//񃊃Xg쐬
	{
		MSGDATA_MANAGER *man;
		STRBUF * str_buf;
		int i;
		
		man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, 
			NARC_msg_debug_matsu_dat, HEAPID_BASE_DEBUG);
		
		for(i = 0; i < LIST_MENU_MAX; i++){
			BMP_MENULIST_AddArchiveString(dm->listmenu, man, DebugMenuParamList[i].str_id, 
				DebugMenuParamList[i].param);
		}
		
		MSGMAN_Delete(man);
	}
	
	list_h = DebugMenuListHeader;
	list_h.win = &dm->bmpwin;
    list_h.list = dm->listmenu;
	dm->lw = BmpListSet(&list_h, 0, 0, HEAPID_BASE_DEBUG);
	
	GF_BGL_BmpWinOn(&dm->bmpwin);
	
	TCB_Add(DM_MenuMain, dm, 10);
}

//--------------------------------------------------------------
/**
 * @brief   cpfobOj[XgI
 *
 * @param   tcb			TCBւ̃|C^
 * @param   work		fobOpc[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DM_MenuMain(TCB_PTR tcb, void *work)
{
	DMATSU_WORK *dm = work;
	u32	ret;

	ret = BmpListMain(dm->lw);
	switch(dm->main_seq){
	case 0:
		dm->main_seq++;
		break;
	case 1:
		switch(ret){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			DM_MenuExit(dm);
			TCB_Delete(tcb);
			sys_FreeMemoryEz(dm);
			FieldSystemProc_SeqHoldEnd();
			return;
		default:
			{
				pDMFunc func = (pDMFunc)ret;

				DM_MenuExit(dm);
				TCB_Delete(tcb);
				func(dm);
				return;
			}
			break;
		}
		break;
	}
}

//--------------------------------------------------------------
/**
 * @brief   cpfobOj[Xg
 * @param   dm		fobOpc[Nւ̃|C^
 */
//--------------------------------------------------------------
static void DM_MenuExit(DMATSU_WORK *dm)
{
	BMP_MENULIST_Delete(dm->listmenu);
	BmpListExit(dm->lw, NULL, NULL);

	GF_BGL_BmpWinOff(&dm->bmpwin);
	GF_BGL_BmpWinDel(&dm->bmpwin);
}

static void TestOverlaySet(DMATSU_WORK *dm)
{
	TCB_Add(TestOverlayStart, dm, 20);
}

extern void BattleSystemProc(void);
static void TestSet(DMATSU_WORK *dm)
{
#if 0
	sys.mainSys_sequence = 5;//SEQ_EXIT;
	sys.pReturnProc = BattleSystemProc;
	//FieldSysWork.general_seqno = 0;
#else
//	if(sys.trg & START_BUTTON){
		sys_FreeMemory(HEAPID_BASE_DEBUG, dm);
//		TCB_Delete(tcb);
		FieldSystemProc_SeqHoldEnd();
		return;
//	}
#endif
}

//--------------------------------------------------------------
/**
 * @brief   ReXgFZ͕Jn
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void DM_ActingStart(DMATSU_WORK *dm)
{
	ContestActin_FieldConnectStart(dm->fsys);
}

//--------------------------------------------------------------
/**
 * @brief   ReXgFrWAJn
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void DM_VisualStart(DMATSU_WORK *dm)
{
	ContestVisual_FieldConnectStart(dm->fsys);
}

//--------------------------------------------------------------
/**
 * @brief   ReXgF_XJn
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void DM_DanceStart(DMATSU_WORK *dm)
{
	ContestDance_FieldConnectStart(dm->fsys);
}

//--------------------------------------------------------------
/**
 * @brief   ReXgF_XJn([e[V)
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void DM_DanceRotatinOn(DMATSU_WORK *dm)
{
	ContestDance_FieldConnectStart(dm->fsys);
}

//--------------------------------------------------------------
/**
 * @brief   ReXgF_XJn([e[VȂ)
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void DM_DanceRotationOff(DMATSU_WORK *dm)
{
	DmatsuWork_DanceRotationOff = 1;
	ContestDance_FieldConnectStart(dm->fsys);
}

//--------------------------------------------------------------
/**
 * @brief   ReXgF_XJn
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void DM_ContestSioStart(DMATSU_WORK *dm)
{
	EventSet_Script(dm->fsys, SCRID_CONNECT_CONTEST, NULL );
}

//--------------------------------------------------------------
/**
 * @brief   ReXgFʔ\Jn
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void DM_ResultStart(DMATSU_WORK *dm)
{
	ContestResult_FieldConnectStart(dm->fsys);
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNeXg
 *
 * @param   dm		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
static void FieldParticleTest(DMATSU_WORK *dm);
static void TestTCB_Particle(TCB_PTR tcb, void *work);
static int TestParticle_Main(void);
static u32 sAllocTex(u32 size, BOOL is4x4comp);
static u32 sAllocTexPalette(u32 size, BOOL is4pltt);

typedef struct{
	PTC_PTR ptc;
	u8 seq;
	
}TEST_PARTICLE_WORK;

///퓬p[eBÑJjAݒ
#define BP_NEAR			(FX32_ONE)
///퓬p[eBÑJt@[ݒ
#define BP_FAR			(FX32_ONE * 900)

static void FieldParticleTest(DMATSU_WORK *dm)
{
	sys_FreeMemory(HEAPID_BASE_DEBUG, dm);
	FieldSystemProc_SeqHoldEnd();
	
	{
		TEST_PARTICLE_WORK *tpw;
		
		tpw = sys_AllocMemory(HEAPID_BASE_DEBUG, sizeof(TEST_PARTICLE_WORK));
		MI_CpuClear8(tpw, sizeof(TEST_PARTICLE_WORK));
		TCB_Add(TestTCB_Particle, tpw, 20);
	}
}

static void TestTCB_Particle(TCB_PTR tcb, void *work)
{
	TEST_PARTICLE_WORK *tpw = work;
	int heap_id = HEAPID_BASE_DEBUG;
	void *heap;
	GF_CAMERA_PTR camera_ptr;
	void *resource;
	
	switch(tpw->seq){
	case 0:		//
		Particle_SystemWorkInit();	//p[eBNVXe
		tpw->seq++;
		break;
	case 1:		//p[eBNVXe쐬
		heap = sys_AllocMemory(heap_id, PARTICLE_LIB_HEAP_SIZE);
		tpw->ptc = Particle_SystemCreate(sAllocTex, sAllocTexPalette, heap, 
			PARTICLE_LIB_HEAP_SIZE, TRUE, heap_id);
		camera_ptr = Particle_GetCameraPtr(tpw->ptc);
		GFC_SetCameraClip(BP_NEAR, BP_FAR, camera_ptr);

		tpw->seq++;
		break;
	case 2:		//\[Xǂݍ݁o^
		resource = Particle_ArcResourceLoad(
			ARC_PARTICLE_DATA, NARC_particledata_w_001_spa, heap_id);
		Particle_ResourceSet(tpw->ptc, resource, PTC_AUTOTEX_LNK | PTC_AUTOPLTT_LNK);
		
		tpw->seq++;
		break;
	case 3:		//p[eBN
		Particle_CreateEmitterCallback(tpw->ptc, 0, NULL, NULL);
		break;
	case 4:		//p[eBNs
		if(TestParticle_Main() == FALSE){
			tpw->seq++;
		}
		break;
	case 5:		//p[eBNVXej
		heap = Particle_HeapPtrGet(tpw->ptc);
		Particle_SystemExit(tpw->ptc);
		sys_FreeMemoryEz(heap);
		
		tpw->seq++;
		break;
	default:
		sys_FreeMemoryEz(tpw);
		TCB_Delete(tcb);
		return;
	}
}

//--------------------------------------------------------------
/**
 * @brief   퓬pp[eBNVXeEC֐(vZE`揈Ȃǂs)
 *
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static int TestParticle_Main(void)
{
	int draw_num;
	const MtxFx43 *camera_ptr;
	
	GF_G3X_Reset();


	if(Particle_GetActionNum() == 0){
		return FALSE;
	}
	

	draw_num = Particle_DrawAll();	//p[eBN`

	if(draw_num > 0){
		//p[eBN̕`悪ÎŁAĂу\tgEFAXvCgpJɐݒ
		GF_G3X_Reset();
	}

	Particle_CalcAll();	//p[eBNvZ

	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   eNX`VRAMAhXԂ߂̃R[obN֐
 *
 * @param   size		eNX`TCY
 * @param   is4x4comp	4x4keNX`ł邩ǂ̃tO(TRUE=keNX`)
 *
 * @retval  ǂݍ݂JnVRAM̃AhX
 */
//--------------------------------------------------------------
static u32 sAllocTex(u32 size, BOOL is4x4comp)
{
	u32 address;
	NNSGfdTexKey key;
	
	key = NNS_GfdAllocTexVram(size, is4x4comp, 0);
	GF_ASSERT(key != NNS_GFD_ALLOC_ERROR_TEXKEY);
	
	address = NNS_GfdGetTexKeyAddr(key);
	OS_TPrintf("vram=%d\n", address);
	return address;
}

//--------------------------------------------------------------
/**
 * @brief	eNX`pbgVRAMAhXԂ߂̃R[obN֐
 *
 * @param	size		eNX`TCY
 * @param	is4pltt		4Fpbgł邩ǂ̃tO
 *
 * @retval	ǂݍ݂JnVRAM̃AhX
 *
 * direct`̃eNX`̏ꍇASPL_LoadTexPlttByCallbackFunction
 * R[obN֐Ăяo܂B
 */
//--------------------------------------------------------------
static u32 sAllocTexPalette(u32 size, BOOL is4pltt)
{
	NNSGfdPlttKey key;
	u32 address;
	
	key = NNS_GfdAllocPlttVram(size, is4pltt, NNS_GFD_ALLOC_FROM_LOW);
	if(key == NNS_GFD_ALLOC_ERROR_PLTTKEY){
		GF_ASSERT(0 && "p[eBNŃpbg̊mۂo܂I\n");
	}
	address = NNS_GfdGetPlttKeyAddr(key);
	OS_TPrintf("vram=%d\n", address);
	return address;
}









//==============================================================================
//
//	
//
//==============================================================================
#if 0

///BombThrowUnit_Update֐̃V[PXe[u
static int (* const ContestMainSeqTbl[])(CONTEST_SYSTEM *) = {
	ConSeq_Init,
	ConSeq_Main,
};

//--------------------------------------------------------------
/**
 * @brief   
 *
 * @param   none		
 *
 * @retval  
 *
 *
 */
//--------------------------------------------------------------
void BattleSystemProc(void)
{
	enum{
		SEQ_INIT,
		SEQ_MAIN,
		SEQ_END,
	};
	
	switch(sys.mainSys_sequence){
	case SEQ_INIT:
		Contest_Init();
		sys.mainSys_sequence = SEQ_MAIN;
		break;
	case SEQ_MAIN:
		break;
	case SEQ_END:
	default:
		break;
	}
}

void Contest_Init(void)
{
	CONTEST_SYSTEM *consys;
	
	consys = sys_AllocMemory(HEAPID_BASE_DEBUG, sizeof(CONTEST_SYSTEM));
	TCB_Add(Contest_Main, consys, CONTEST_MAIN_SEQPRI);
}

static void Contest_Main(TCB_PTR tcb, void *work)
{
	CONTEST_SYSTEM *consys = work;
	int ret;
	
	ret = ContestMainSeqTbl[consys->main_seq])(consys);
	switch(ret){
	case CONSEQ_
	if(ret == CONSEQ_INIT
	switch(ret){
	case 
}

		vram_bank_set();
		initVramTransferManagerHeap( 40, HEAPID_BATTLE );

		BattleMainProc( APP_INIT_REQ, NULL, &BattleSysWork );
		BattleMenuProc( APP_INIT_REQ, NULL, &BattleSysWork );	
		sys.mainSys_sequence = SEQ_MAIN;
		break;

	case SEQ_MAIN:
		BattleMainProc( APP_ON_REQ, NULL, &BattleSysWork );
		BattleMenuProc( APP_ON_REQ, NULL, &BattleSysWork );

		if( BattleSysWork.end_flg == 1 ){
			sys.mainSys_sequence = SEQ_EXIT;
			break;
		}

		if( BattleSysWork.menu_wk.func != NULL ){
//			BattleMainProc( APP_END_REQ, NULL, &BattleSysWork );
			BattleMenuProc( APP_END_REQ, NULL, &BattleSysWork );
			sys.mainSys_sequence = SEQ_MENU_FULL;
			break;
		}

		break;

	case SEQ_PAUSE:
		break;

	case SEQ_MENU_FULL:
		BattleSysWork.menu_wk.func( APP_ON_REQ, NULL, &BattleSysWork.menu_wk );

		if( BattleSysWork.menu_wk.func == NULL ){
//			BattleMainProc( APP_INIT_REQ, NULL, &BattleSysWork );
			BattleMenuProc( APP_INIT_REQ, NULL, &BattleSysWork );	
			sys.mainSys_sequence = SEQ_MAIN;
		}
		break;

	case SEQ_EXIT:
		BattleMainProc( APP_END_REQ, NULL, &BattleSysWork );
		BattleMenuProc( APP_END_REQ, NULL, &BattleSysWork );

		DellVramTransferManager();

		sys_MainProcChange( sys.pReturnProc );
		break;
	}
}

//===========================================================================
/**
 * 
 * uq`loNݒ
 *
 */
//===========================================================================
static void vram_bank_set(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_A,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_128_C,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_NONE,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_NONE,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_NONE			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

#endif

