//============================================================================================
/**
 * @file	d_mori.c
 * @bfief	X fobOj[
 * @author	mori GAME FREAK inc.
 */
//============================================================================================
#include "common.h"
#include "gflib/strbuf.h"
#include "gflib/strbuf_family.h"
#include "system/lib_pack.h"
#include "system/bmp_list.h"
#include "fieldmap.h"
#include "worldmap.h"
#include "fieldsys.h"
#include "field_event.h"
#include "system/fontproc.h"
#include "system/arc_util.h"
#include "system/window.h"
#include "fld_bmp.h"
#include "system/pm_str.h"
#include "fld_debug.h"
#include "talk_msg.h"
#include "encount_effect.h"
#include "poketool/poke_tool.h"
#include "msgdata/msg.naix"
#include "system/snd_play.h"
#include "system/snd_tool.h"


#include "msgdata/msg_debug_mori.h"
#include "application/namein.h"
#include "application/tradelist.h"
#include "communication/communication.h"

#include "communication/wpb.h"
#include "communication/wpbpokemon.h"
#include "communication/wpbutil.h"
#include  "communication/wm_icon.h"

//---------------------------------------------------------------------------------------------
// `
//---------------------------------------------------------------------------------------------
#define	DEBUG_WK_SIZE		( 4*16 )

enum {
	WK_SEQ = 0,
	WK_WIN_INDEX,
	WK_LIST_ID,
	WK_LIST_RET,
	WK_GF_BGL_INI,
	WK_MIC_PARAM,
	WK_FIELDSYS,
	WK_TALK_INDEX,
	WK_MES_SEQ,
	WK_MES_INDEX,
	WK_MES_WAIT,
	WK_WM_ICON,
};

typedef struct{
	u32 work[DEBUG_WK_SIZE];

	MSGDATA_MANAGER		*man;
	BMP_MENULIST_DATA 	*ld;
}DEBUG_MORI_WORK;

//---------------------------------------------------------------------------------------------
// ֐vg^Cv
//---------------------------------------------------------------------------------------------
static void DebugMenuCallConnectList(GF_BGL_INI *ini, FIELDSYS_WORK *fsys);
static void DebugMenuExit(GF_BGL_INI *ini);
static void DebugMenuExitSub( TCB_PTR _tcb );
static void DebugMoriMenuMain( TCB_PTR _tcb, void * work );
static void MainBmpListCB1( BMPLIST_WORK * work, u32 param, u8 mode );
static void MainBmpListCB2( BMPLIST_WORK * work, u32 param, u8 y );
void DebugMoriMenuInit(GF_BGL_INI * ini, FIELDSYS_WORK *fsys);

static int SamplingDataFab( s8 *adr, int size, int divid );





void DebugMicFuncInit(GF_BGL_INI *ini, FIELDSYS_WORK *fsys);
void DebugMicFuncMain(TCB_PTR tcb, void *work);

void TestNameIn_Call( TCB_PTR tcb, void* work );
void DebugNameInFuncInit(GF_BGL_INI * ini, FIELDSYS_WORK *fsys);
void DebugTradeListFuncInit(GF_BGL_INI * ini, FIELDSYS_WORK *fsys);



//--------------------------------------------------------------------------------------------
// fobOj[p`
//--------------------------------------------------------------------------------------------

static const BMPLIST_HEADER d_menu_list_h = {
//	d_menu_list,			// \f[^|C^
	NULL,
	MainBmpListCB1,			// J[\ړƂ̃R[obN֐
	MainBmpListCB2,			// \Ƃ̃R[obN֐
	NULL,
//	NELEMS(d_menu_list),	// Xgڐ
	6,
	6,						// \ő區ڐ
	0,						// x\wW
	8,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_BLACK,			//F
	FBMP_COL_WHITE,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	POKE_SYSTEM,				// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};



typedef void (*bglFunc)(GF_BGL_INI *ini, FIELDSYS_WORK* fsys);	// ֐|C^^

//==============================================================================
/**
 * fobOj[֐ifld_debug.cĂ΂܂)
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void DebugMoriMenuInit(GF_BGL_INI * ini, FIELDSYS_WORK *fsys)
{
	BMPLIST_HEADER	list_h;

	// ^XNo^[N|C^擾
	u32 * wk             = (u32 *)TCB_GetWork( PMDS_taskAdd( DebugMoriMenuMain, sizeof(DEBUG_MORI_WORK), 0, HEAPID_BASE_DEBUG ) );
	DEBUG_MORI_WORK *dmw = (DEBUG_MORI_WORK*)wk;

	// BMP_WIN\̊m
	GF_BGL_BMPWIN *win = GF_BGL_BmpWinAllocGet( HEAPID_BASE_DEBUG, 1 );



	// f[^ǂݍݏ
	dmw->man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_debug_mori_dat, HEAPID_BASE_DEBUG );


	// BMP_WINo^
	GF_BGL_BmpWinAdd( ini, win, FLD_MBGFRM_FONT, 1, 1, 10, 12, FLD_SYSFONT_PAL, 1 );

	// BMP_WIN\̂̃|C^^XN[Nɕۑ
	wk[ WK_WIN_INDEX ] = (u32)win;


	dmw->ld = BMP_MENULIST_Create( 6, HEAPID_WORLD );
	BMP_MENULIST_AddArchiveString( dmw->ld, dmw->man, menu_msg00, (u32)DebugMenuCallConnectList );
	BMP_MENULIST_AddArchiveString( dmw->ld, dmw->man, menu_msg01, (u32)DebugMenuExit );
	BMP_MENULIST_AddArchiveString( dmw->ld, dmw->man, menu_msg02, (u32)DebugMenuExit );
	BMP_MENULIST_AddArchiveString( dmw->ld, dmw->man, menu_msg03, (u32)DebugMicFuncInit );
	BMP_MENULIST_AddArchiveString( dmw->ld, dmw->man, menu_msg04, (u32)DebugNameInFuncInit );
	BMP_MENULIST_AddArchiveString( dmw->ld, dmw->man, menu_msg05, (u32)DebugTradeListFuncInit );


	// BMP_LIST\̂Zbg
	list_h      = d_menu_list_h;
	list_h.win  = win;
	list_h.list = dmw->ld;


	wk[ WK_LIST_ID ]    = (u32)BmpListSet( &list_h, 0, 0 ,HEAPID_BASE_DEBUG);
	wk[ WK_GF_BGL_INI ] = (u32)ini;			// fieldsys->bgl̕ۑ
	wk[ WK_FIELDSYS ]   = (u32)fsys;		// fieldsys̕ۑ

	// BMP\Jn
	GF_BGL_BmpWinOn( win );

	
	MSGMAN_Delete( dmw->man );

	// ^XNV[PXpϐ̏
	wk[ WK_SEQ ] = 0;

}

static void MainBmpListCB1( BMPLIST_WORK * work, u32 param, u8 mode )
{
}
static void MainBmpListCB2( BMPLIST_WORK * work, u32 param, u8 y )
{
}

//------------------------------------------------------------------
/**
 * fobOj[BmpList
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugMoriBmpMenuExit( u32 * wk )
{
	BMPLIST_WORK    *list = (BMPLIST_WORK*)wk[WK_LIST_ID];
	DEBUG_MORI_WORK *dmw  = (DEBUG_MORI_WORK*)wk;

	// BMP_LIST
	BmpListExit( list, NULL, NULL );
	BMP_MENULIST_Delete( dmw->ld );

	// BMP_WIN\OFF
	GF_BGL_BmpWinOff( (GF_BGL_BMPWIN*)wk[WK_WIN_INDEX] );

	// BMP_WIN̈폜
	GF_BGL_BmpWinDel( (GF_BGL_BMPWIN*)wk[WK_WIN_INDEX] );
}


static u16 *ChildList;

//------------------------------------------------------------------
/**
 * fobOj[
 *
 * @param   tcb		
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void DebugMenuExitSub( TCB_PTR tcb )
{
	u32 *wk = (u32*)TCB_GetWork(tcb);
	u16 result;
	int different=0,i;
	
	ChildList = sys_LoadFile( HEAPID_BASE_DEBUG, "poketool/personal/pms.narc");

	for(i=0;i<401+1;i++){
		result = PokeSearchChild(i);
		if(result!=ChildList[i]){
			different++;
		}
	}

	OS_Printf("ƍ   = %d\n",different);

//	OS_Printf("ChildList[3]   = %d\n",ChildList[3]);
//	OS_Printf("SearchChild(3) = %d\n",result);

	// BMPLIST/WIN
	DebugMoriBmpMenuExit( wk );

	// ^XN
	PMDS_taskDel( tcb );

	// tB[h|[YԂ畜A
	FieldSystemProc_SeqHoldEnd();
}




//------------------------------------------------------------------
/**
 * Ăяo
 *
 * @param   none		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugMenuExit( GF_BGL_INI *ini )
{
//	EncountEffectStart(1,NULL,NULL);
	FieldSystemProc_SeqHoldEnd();

}



//------------------------------------------------------------------
/**
 * fobOj[C
 *
 * @param   _tcb		
 * @param   work		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugMoriMenuMain( TCB_PTR _tcb, void * work )
{
	u32 * wk = (u32 *)work;
	u32	ret;

	switch( wk[ WK_SEQ ] ){
	case 0:
		ret = BmpListMain( (BMPLIST_WORK*)wk[WK_LIST_ID] );

		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
//			NNS_GfdDumpLnkTexVramManager();
//			NNS_GfdDumpLnkPlttVramManager();
			OS_Printf("wbppokemon size = %d\n",sizeof(WPBPokemonInfo));
			DebugMenuExitSub( _tcb );
			break;
		default:
			wk[WK_LIST_RET] = ret;
			wk[WK_SEQ]++;
		}
		break;
	case 1:
		{
			bglFunc func = (bglFunc)wk[WK_LIST_RET];

			DebugMoriBmpMenuExit( wk );
			PMDS_taskDel( _tcb );
			func((GF_BGL_INI*)wk[WK_GF_BGL_INI], (FIELDSYS_WORK*)wk[WK_FIELDSYS]);
		}
	}
}




//---------------------------------------------------------------------------------------
// ڑXgeXg
//---------------------------------------------------------------------------------------


typedef struct{
	u8  name[10+1];
	u32 id;
	u8  sex;
	u16 time;
}CONNECT_MEMBER_ONE;


typedef struct{
	u32 wk[16];
	CONNECT_MEMBER_ONE recv[32];
	CONNECT_MEMBER_ONE put[32];

	u8 				*sWmBuffer;
	u8				*wpbBuf;
//	WPBBuf  		wpbBuf;
	WPBPokemonInfo	SendWPBInfo;
	WPBPokemonInfo	RecvWPBInfo;
	WPBPokemonInfo	StockWPBInfo[8];
	int				StockNum;
	int				OldStockNum;
	u16				*UTF16Table;
	u16				surechigai_str[32];
	STRBUF			*recv_msg;

}CONNECT_MEMBER_WORK;

//static u8 			sWmBuffer[WM_SYSTEM_BUF_SIZE] 	ATTRIBUTE_ALIGN(32);
//static WPBBuf  		wpbBuf  						ATTRIBUTE_ALIGN(32);

static CONNECT_MEMBER_WORK *pcmw = NULL;



//---------------------------------------------------------------------------------------------
// ֐vg^Cv
//---------------------------------------------------------------------------------------------
void ConnectListMain(TCB_PTR tcb, void *work);
void ConnectListLineCB(BMPLIST_WORK * work,u32 param,u8 y);

//--------------------------------------------------------------------------------------------
// fobOj[p`
//--------------------------------------------------------------------------------------------



static const BMPLIST_HEADER connect_list_h = {
	NULL,			// \f[^|C^
	MainBmpListCB1,			// J[\ړƂ̃R[obN֐
	ConnectListLineCB,		// \Ƃ̃R[obN֐
	NULL,
	10,	// Xgڐ
	7,						// \ő區ڐ
	0,						// x\wW
	8,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_BLACK,			//F
	FBMP_COL_WHITE,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	POKE_SYSTEM,				// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};


//==============================================================================
/**
 * ڑeXgʏ
 *
 * @param   ini		
 *
 * @retval  none		
 */
//==============================================================================
static void DebugMenuCallConnectList(GF_BGL_INI *ini, FIELDSYS_WORK *fsys)
{
	BMPLIST_HEADER	list_h;

	// ^XNo^[N|C^擾
	u32 * wk = (u32 *)TCB_GetWork( PMDS_taskAdd( ConnectListMain, sizeof(CONNECT_MEMBER_WORK), 0, HEAPID_BASE_DEBUG ) );
	CONNECT_MEMBER_WORK *cmw = (CONNECT_MEMBER_WORK *)wk;

	// BMP_WIN\̊m
//	GF_BGL_BMPWIN *win =  GF_BGL_BmpWinAllocGet( HEAPID_BASE_DEBUG, 1 );
	// BMP_WIN\̊m
	GF_BGL_BMPWIN *talkwin =  GF_BGL_BmpWinAllocGet( HEAPID_BASE_DEBUG, 2 );

	// ^XNV[PX
	wk[ WK_SEQ ]        = 0;

	// BMP_WINo^
//	GF_BGL_BmpWinAdd( ini , win,FLD_MBGFRM_FONT, 1, 1, 20, 10, FLD_SYSFONT_PAL, 1 );
//	wk[ WK_WIN_INDEX ]  = (u32)win;

	// BMP_LISTo^
//	list_h              = connect_list_h;
//	list_h.win          = win;
//	wk[ WK_LIST_ID ]    = (u32)BmpListSet( &list_h, 0, 0,HEAPID_BASE_DEBUG );
//	wk[ WK_GF_BGL_INI ] = (u32)ini;					//FieldSys->bgl̕ۑ


	// BMP_WIN\̂̃|C^^XN[Nɕۑ
	GF_BGL_BmpWinAdd( ini, talkwin, FLD_MBGFRM_FONT, 
				FLD_MSG_WIN_PX, FLD_MSG_WIN_PY, FLD_MSG_WIN_SX, FLD_MSG_WIN_SY, FLD_SYSFONT_PAL, FLD_MSG_WIN_CGX );
	wk[ WK_TALK_INDEX ] = (u32)talkwin;
	FieldMsgPrintInit(PALTYPE_SUB_BG, MSG_PRINT_NO_INIT);				// TuVRAMɃtHgƃpbg]
	FldTalkWinPut( talkwin );			// TuʃbZ[WEChE\Jn

	// BMP_WIN\ON
//	GF_BGL_BmpWinOn( win );

	cmw->UTF16Table = sys_LoadFile(HEAPID_BASE_DEBUG, "data/UTF16.dat");
	cmw->StockNum    = 0;
	cmw->OldStockNum = 0;

}


static const char *errcode[]={
	"WPB_STATECODE_START",        /* Ⴂҋ@Jn */
	"WPB_STATECODE_PARENT_FOUND", /* e@𔭌 */
	"WPB_STATECODE_CONNECTED",    /* ڑ */
	"WPB_STATECODE_EXCHANGED",    /* f[^ */
	"WPB_STATECODE_DISCONNECTED", /* ؒfʒm */
	"WPB_STATECODE_END",          /* Ⴂҋ@I */

};

static u16 gameinfo[2]={0,0};
static u16 testnickname[]={GE_,bou_,HU_,RI_,EOM_};
static u16 surechigairesult[]={to_,spc_,su_,re_,ti_,ga_,ttu_,ta_,EOM_};
#define TEST_GGID	0x135

// Q[ԋʏ

static const WPBPokemonInfo TestWPBPokeInfo = {
	4,
	-1,
	-1,
	-1,
	-1,
	{0x0070, 0x006F, 0x006B, 0x0065, 0x006D, 0x006F, 0x006E, 0x0044, 0x0050,  0x0000,},	// pokemonDP
	{0,},
	{0,},
	{0,},
	1,
	0,
	0,
	{0xFF71, 0xFF77, 0xFF84, 0x0000,}, //ALg
	4,
	{0x305F, 0x3044, 0x3078, 0x3093, 0x3060, 0x3088, 0x306D, 0x306D, 0x306D,0x0000,}, // ς
	9,
};
#if 0
typedef struct WPBPokemonInfo {
	u32 version;        // |PDS\tgƂĂIDԍ
	u32 tryTime;        // 񂷂Ⴄ܂łɂ (b) (s -1)
	u32 tryCount;       // ݂܂ł̂Ⴂs (s -1)
	u32 successCount;   // ݂܂ł̂Ⴂ (s -1)
	u32 totalTime;      // ݂܂ł̑Ⴂs (b) (s -1)
	u16 gameName[128];  // Q[ (UTF-16LE)
	u8  image[32*32/2]; // ACRf[^
	u8  pltt[16*2];     // ACRpbg
	u8  macAddress[WM_SIZE_BSSID]; // macAddress
	u8  present;        // v[g
	u8  favoriteColor;  // Cɓ̐F ( 0 ` 15 )
	u16 sex_birth;      // ʁAaAN
	u16 nickName[ 10 ]; // jbNl[ (UTF16)
	u16 nickNameLength; // jbNl[( 0 ` 10 )
	u16 comment[ 39 ];  // Rg (UTF16)
	u16 commentLength;  // Rg( 0 ` 39 )
} WPBPokemonInfo;

#endif

static void WpbSetUp(CONNECT_MEMBER_WORK *cmw);
static void WpbInit(CONNECT_MEMBER_WORK *cmw);
static int  ReleaseWpbWork(CONNECT_MEMBER_WORK *cmw);

void WpbCallBack(WPBCallback *arg);

//------------------------------------------------------------------
/**
 * sys_AllocMemoryl32oCgACg̃AhXɕ␳
 *
 * @param   adr		AllocŎ擾AhXiۂ̃TCY32oCgmۂĂ)
 *
 * @retval  u8*		32oCgACgɏCAhX
 */
//------------------------------------------------------------------
static u8* GetAlignment32Adr(u8 *adr)
{
	u32 work = (u32)adr;
	if((work&0x0000003f)==0){
		return (u8*)work;
	}

	return (u8*)work + 32-(work%32);

}

static void WpbSetUp(CONNECT_MEMBER_WORK *cmw)
{
	cmw->sWmBuffer = sys_AllocMemory( HEAPID_BASE_DEBUG, WM_SYSTEM_BUF_SIZE+64 );
	if(cmw->sWmBuffer==NULL){
		OS_Printf("cmw->sWmBuffermۂłĂȂ\n");
	}
	// CNj[]
	CommVRAMDInitialize();

	pcmw = cmw;
}
#define UTF16_TABLE_MAX	( 249 )

static void SetPokeWord2UTF16(u16 *des, const u16 *src, const u16 *UTF16)
{
	int i=0;
	while(src[i]!=EOM_){
		des[i] = UTF16[src[i]];
		i++;
	}
}

static void SetUTF162PokeWord(u16 *des, const u16 *src, const u16 *UTF16)
{
	int i=0,r;
	while(src[i]!=EOM_){
		for(r=0;r<UTF16_TABLE_MAX;r++){
			if(UTF16[r]==src[i]){
				des[i] = r;
				break;
			}
		}
		i++;
	}
}


static void WpbInit(CONNECT_MEMBER_WORK *cmw)
{
	int code;
	u8 *sWmBuffer_a,*wpbBuf_a;

	// ʐM
	sWmBuffer_a = GetAlignment32Adr(cmw->sWmBuffer);
	code = WM_Init( sWmBuffer_a, 2 );

	OS_Printf("errcode = %d\n",code);

	cmw->wpbBuf = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof(WPBBuf)+64 );
	if(cmw->wpbBuf==NULL){
		OS_Printf("cmw->wpbBufmۂłĂȂ\n");
	}
	wpbBuf_a = GetAlignment32Adr(cmw->wpbBuf);
	WPB_SetBuffer((WPBBuf*)wpbBuf_a);

	WPB_SetCallback(WpbCallBack);

	cmw->SendWPBInfo = TestWPBPokeInfo;
	OS_GetMacAddress(cmw->SendWPBInfo.macAddress);
	SetPokeWord2UTF16(cmw->SendWPBInfo.nickName,testnickname,cmw->UTF16Table);
	
	WPB_SetGameInfo(gameinfo, sizeof(gameinfo), TEST_GGID);


	if(WPB_Start()==WM_ERRCODE_INVALID_PARAM){
		OS_Printf("֐ɓnp[^s\n");
	}
}
void WVRCallBack(  void *arg , WVRResult result  )
{

}

static int ReleaseWpbWork(CONNECT_MEMBER_WORK *cmw)
{
//	if(WPB_Finished()){
	if(WPB_End()==WM_ERRCODE_SUCCESS){
		sys_FreeMemory(HEAPID_BASE_DEBUG, cmw->wpbBuf);
		sys_FreeMemory(HEAPID_BASE_DEBUG, cmw->sWmBuffer);

	}else{
		return 0;
	}
//	}else{
//		return 0;
//	}

//	WM_Finish();

	return 1;
}


static void WpbCallBack(WPBCallback *arg)
{
	switch(arg->state){
	case WPB_STATECODE_PARENT_FOUND:

		arg->send_ptr  = &pcmw->SendWPBInfo;
		arg->send_size = sizeof(WPBPokemonInfo);
		arg->recv_ptr  = &pcmw->RecvWPBInfo;
		arg->recv_size = sizeof(WPBPokemonInfo);
		arg->bssDesc   = WPB_TestParent(arg->bssDesc, arg->bssDescCount, TEST_GGID);
		break;
	case WPB_STATECODE_CONNECTED:
		break;
	case WPB_STATECODE_EXCHANGED:
		pcmw->StockWPBInfo[pcmw->StockNum] = pcmw->RecvWPBInfo;
		if(++pcmw->StockNum==5){
			pcmw->StockNum = 0;
		}
		break;
	}

	OS_Printf("----------ꂿstate = %s\n",errcode[arg->state]);
}


static const u16 teststr[]={TE_,SU_,TO_,de_,su_,EOM_};


//==============================================================================
/**
 * ڑʃeXgC
 *
 * @param   tcb		
 * @param   work		
 *
 * @retval  none		
 */
//==============================================================================
void ConnectListMain(TCB_PTR tcb, void *work)
{
	u32	ret;
	CONNECT_MEMBER_WORK *cmw = (CONNECT_MEMBER_WORK *)work;


	switch( cmw->wk[ WK_SEQ ] ){
	case 0:		// ʐM
		WpbSetUp(cmw);
		cmw->wk[WK_SEQ]++;
		break;
	case 1:
		if(CommIsVRAMDInitialize()){
			WpbInit(cmw);
			cmw->wk[WK_SEQ]++;
		}
		break;
	
	case 2:
		if((sys.trg & PAD_BUTTON_B) || (sys.trg & PAD_BUTTON_A)){
			cmw->wk[WK_SEQ]++;
		}
#if 0
		ret = BmpListMain( (BMPLIST_WORK*)cmw->wk[WK_LIST_ID] );

		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
//			ReleaseWpbWork(cmw);
//			DebugMenuExitSub( tcb );
			cmw->wk[WK_SEQ]++;
			break;
		default:
			cmw->wk[WK_LIST_RET] = ret;
			cmw->wk[WK_SEQ]++;
		}
#endif
		break;
	case 3:
		if(ReleaseWpbWork(cmw)){
			cmw->wk[WK_SEQ]++;
		}
			
		break;
	case 4:
		if(FldTalkMsgEndCheck( cmw->wk[WK_MES_INDEX] )){
			BmpTalkWinClear(  (GF_BGL_BMPWIN*)cmw->wk[ WK_TALK_INDEX ], WINDOW_TRANS_OFF );
			GF_BGL_BmpWinOff( (GF_BGL_BMPWIN*)cmw->wk[ WK_TALK_INDEX ] );
			GF_BGL_BmpWinDel( (GF_BGL_BMPWIN*)cmw->wk[ WK_TALK_INDEX ] );
			cmw->wk[WK_SEQ]++;
		}
		break;
		
	case 5:
		WVR_TerminateAsync( NULL , NULL);
		sys_FreeMemoryEz( cmw->UTF16Table );
//		DebugMenuExitSub( tcb );
		// ^XN
		PMDS_taskDel( tcb );
		// tB[h|[YԂ畜A
		FieldSystemProc_SeqHoldEnd();
		break;
	}
	
	if(cmw->wk[ WK_SEQ ]!=2){
		return;
	}
	
	// ႢʐMŃf[^MEChEɕ񂪕\
	switch(cmw->wk[WK_MES_SEQ]){
	case 0:
		if(cmw->StockNum!=cmw->OldStockNum){
			GF_BGL_BmpWinFill( (GF_BGL_BMPWIN*)pcmw->wk[WK_TALK_INDEX], 0x0f0f, 0, 0, FLD_MSG_WIN_SX*8, FLD_MSG_WIN_SY*8 );
			SetUTF162PokeWord(cmw->surechigai_str,cmw->StockWPBInfo[pcmw->StockNum].nickName,cmw->UTF16Table);
			PM_strcat(cmw->surechigai_str,surechigairesult);
			if(++pcmw->OldStockNum==5){
				pcmw->OldStockNum = 0;
			}
			cmw->wk[WK_MES_SEQ]++;
		}
		break;
	case 1:
		cmw->recv_msg         = STRBUF_Create(20,HEAPID_WORLD);
		STRBUF_SetStringCode( cmw->recv_msg, teststr );
		cmw->wk[WK_MES_INDEX] = FldTalkMsgStart( (GF_BGL_BMPWIN*)cmw->wk[WK_TALK_INDEX], cmw->recv_msg, 0 );
		cmw->wk[WK_MES_SEQ]++;
		break;
	case 2:
		if(FldTalkMsgEndCheck( cmw->wk[WK_MES_INDEX] )){
			STRBUF_Delete(cmw->recv_msg);
			cmw->wk[WK_MES_SEQ]++;
		}
		break;
	case 3:
		if(++cmw->wk[WK_MES_WAIT]>30){
			GF_BGL_BmpWinFill( (GF_BGL_BMPWIN*)pcmw->wk[WK_TALK_INDEX], 0x0f0f, 0, 0, FLD_MSG_WIN_SX*8, FLD_MSG_WIN_SY*8 );
			cmw->wk[WK_MES_WAIT] = 0;
			cmw->wk[WK_MES_SEQ]  = 0;
		}
		break;
	}
}

void ConnectListLineCB(BMPLIST_WORK * work,u32 param,u8 y)
{
	
}



//--------------------------------------------------------------------------------------------
// fobOj[p`
//--------------------------------------------------------------------------------------------

static const BMPLIST_HEADER micfunc_list_h = {
	NULL,			// \f[^|C^
	MainBmpListCB1,			// J[\ړƂ̃R[obN֐
	ConnectListLineCB,		// \Ƃ̃R[obN֐
	NULL,
	10,	// Xgڐ
	10,						// \ő區ڐ
	0,						// x\wW
	8,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_BLACK,			//F
	FBMP_COL_WHITE,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	POKE_SYSTEM,				// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};

static const VOamAnm WM_IconAnim0[]={
	{512-16,   20},
	{512-16+4, 20},
	{512-16+8, 20},
	{512-16+12,20},
	{0xffff,0}
};

static const VOamAnm WM_IconAnim1[]={
	{512-16,   20},
	{0xffff,0}
};
static const VOamAnm WM_IconAnim2[]={
	{512-16+4,   20},
	{0xffff,0}
};
static const VOamAnm WM_IconAnim3[]={
	{512-16+8,   20},
	{0xffff,0}
};
static const VOamAnm WM_IconAnim4[]={
	{512-16+12,   20},
	{0xffff,0}
};

static const VOamAnm * WM_IconAnimTbl[]={
	WM_IconAnim0,
	WM_IconAnim1,
	WM_IconAnim2,
	WM_IconAnim3,
	WM_IconAnim4,
};


//==============================================================================
/**
 * }CNeXgp̏
 *
 * @param   ini		GF_BGL_INĨ|C^
 *
 * @retval  none		
 */
//==============================================================================
void DebugMicFuncInit(GF_BGL_INI *ini, FIELDSYS_WORK *fsys)
{
	BMPLIST_HEADER	  list_h;
	MSGDATA_MANAGER   *man;

	// ^XNo^[N|C^擾
	u32 *wk               = (u32 *)TCB_GetWork( PMDS_taskAdd( DebugMicFuncMain, sizeof(CONNECT_MEMBER_WORK), 0, HEAPID_BASE_DEBUG ) );
	DEBUG_MORI_WORK *dmw  = (DEBUG_MORI_WORK *)wk;

	// BMP_WIN\̊m
	GF_BGL_BMPWIN *win =  GF_BGL_BmpWinAllocGet( HEAPID_BASE_DEBUG, 1 );

	// ^XNV[PX
	wk[ WK_SEQ ]        = 0;

	// BMP_WINo^
	GF_BGL_BmpWinAdd( ini ,win,FLD_MBGFRM_FONT, 1, 1, 10, 20, FLD_SYSFONT_PAL, 1 );

	// BMP_WIN\̂̃|C^^XN[N̕ۑ
	wk[ WK_WIN_INDEX ]  = (u32)win;

	// f[^ǂݍݏ
	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_debug_mori_dat, HEAPID_BASE_DEBUG );

	dmw->ld = BMP_MENULIST_Create( 10, HEAPID_BASE_DEBUG );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg06, (u32)1 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg07, (u32)2 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg08, (u32)3 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg09, (u32)4 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg10, (u32)5 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg11, (u32)6 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg12, (u32)7 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg13, (u32)8 );
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg14, (u32)10);
	BMP_MENULIST_AddArchiveString( dmw->ld, man, menu_msg15, (u32)11);

	MSGMAN_Delete(man);
	
	// BMP_LISTo^
	list_h              = micfunc_list_h;
	list_h.win          = win;
	list_h.list			= dmw->ld;
	wk[ WK_LIST_ID ]    = (u32)BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG);
	wk[ WK_GF_BGL_INI ] = (u32)ini;					//FieldSys->bgl̕ۑ
	wk[ WK_MIC_PARAM  ] = MIC_SAMPLING_RATE_8K;


	// BMP_WIN\nm
	GF_BGL_BmpWinOn( win );

	// g`Đp`lmۂ
	Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );

	wk[ WK_WM_ICON ] = (u32)AddWirelessIconOAM(0,HEAPID_BASE_DEBUG,240,0,WM_IconAnimTbl);

	Snd_Stop();
}

#define MIC_PLAY_TIME	(2)	// 2b

//------------------------------------------------------------------
/**
 * }CNݒƘ^Jn
 *
 * @param   rate	TvO[g(8KhzȂ8000)
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SamplingStart(int rate)
{
	MICAutoParam		mic_param;
	mic_param.type   = MIC_SAMPLING_TYPE_SIGNED_8BIT;	// TvO
    mic_param.buffer = Snd_GetDebugWaveBufAdrs();       // ʊi[obt@ւ̃|C^ 
    mic_param.size   = rate*MIC_PLAY_TIME;      					// obt@TCY
	if((mic_param.size&0x1f)!=0){
		mic_param.size &= 0xffffffe0;
	}
    mic_param.rate   = HW_CPU_CLOCK_ARM7 /rate;         // TvO( ARM7̃NbN )
    mic_param.loop_enable = FALSE;                  	// obt@t̃[v
    mic_param.full_callback = NULL;     			    // obt@t̃R[obN
    mic_param.full_arg      = NULL;                     // LR[obNɎw肷

	Snd_MicStartAutoSampling(&mic_param);

}

static int SamplingDataFab( s8 *adr, int size, int divid )
{
	int i,r=0;
	for(i=0;i<size;i++){
		adr[i] = (adr[i]/divid);
		r     += adr[i];
		adr[i] = adr[i]*divid;
	}
	return r;
}


//==============================================================================
/**
 * }CNBMP_LISTC
 *
 * @param   tcb		^XN
 * @param   work	[N|C^
 *
 * @retval  none	
 */
//==============================================================================
void DebugMicFuncMain(TCB_PTR tcb, void *work)
{
	u32	ret;
	CONNECT_MEMBER_WORK *cmw = (CONNECT_MEMBER_WORK *)work;
	

	switch( cmw->wk[ WK_SEQ ] ){
	case 0:
		// BMPLISTC
		ret = BmpListMain( (BMPLIST_WORK*)cmw->wk[WK_LIST_ID] );
	switch( ret ){
		case 1:		// ^ 8Khz
			cmw->wk[WK_MIC_PARAM] = 8000;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;
		case 2:		// ^ 4Khz
			cmw->wk[WK_MIC_PARAM] = 4000;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;
		case 3:		// ^ 2Khz
			cmw->wk[WK_MIC_PARAM] = 2000;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;

		case 4:		// ^ 1.75Khz
			cmw->wk[WK_MIC_PARAM] = 1750;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;
		case 5:		// ^ 1.5Khz
			cmw->wk[WK_MIC_PARAM] = 1500;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;
		case 6:		// ^ 1.25Khz
			cmw->wk[WK_MIC_PARAM] = 1250;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;


		case 7:		// ^ 1Khz
			cmw->wk[WK_MIC_PARAM] = 1000;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;
		case 8:		// ^ 500hz
			cmw->wk[WK_MIC_PARAM] = 512;
			SamplingStart(cmw->wk[WK_MIC_PARAM]);
			break;
		case 10:		// Đ
			{
				WAVEOUT_WORK waveout_wk;
				waveout_wk.handle			= Snd_WaveOutHandleGet(WAVEOUT_CH_NORMAL);	//g`Đnh
				waveout_wk.format			= NNS_SND_WAVE_FORMAT_PCM8;	//g`f[^tH[}bg
				waveout_wk.dataaddr			= Snd_GetDebugWaveBufAdrs();//g`f[^̐擪AhX
				waveout_wk.loopFlag			= FALSE;					//[vtO
				waveout_wk.loopStartSample	= 0;						//[vJnTvʒu
				waveout_wk.samples			= cmw->wk[WK_MIC_PARAM]*MIC_PLAY_TIME;	//g`f[^̃Tv
				if((waveout_wk.samples&0x1f)!=0){
					waveout_wk.samples &= 0xffffffe0;
				}
				if(sys.cont&PAD_BUTTON_R){
					SamplingDataFab((s8*)waveout_wk.dataaddr, waveout_wk.samples,16);
				}
				if(sys.cont&PAD_BUTTON_L){
					SamplingDataFab((s8*)waveout_wk.dataaddr, waveout_wk.samples,64);
				}
				waveout_wk.sampleRate		= cmw->wk[WK_MIC_PARAM];	//g`f[^̃TvO[g
				waveout_wk.volume			= 127;						//
				waveout_wk.speed			= 32768;					//ĐXs[h
				waveout_wk.pan				= 64;						//p(0-127)
				Snd_WaveOutStart( &waveout_wk );
			}
			break;
		case 11:		// ĐIăEChEN[Y
			Snd_WaveOutStop(WAVEOUT_CH_NORMAL);
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			WirelessIconEnd((VINTR_WIRELESS_ICON*)cmw->wk[ WK_WM_ICON ]);
			DebugMenuExitSub( tcb );

			// g`Đp`lJ
			Snd_WaveOutFreeChannel(WAVEOUT_CH_NORMAL);
			break;
		default:
			cmw->wk[WK_LIST_RET] = ret;
			cmw->wk[WK_SEQ]++;
		}
		break;
	case 1:
		{
			WirelessIconEnd((VINTR_WIRELESS_ICON*)cmw->wk[ WK_WM_ICON ]);
			FieldSystemProc_SeqHoldEnd();
			DebugMoriBmpMenuExit( work );
			PMDS_taskDel( tcb );

			// g`Đp`lJ
			Snd_WaveOutFreeChannel(WAVEOUT_CH_NORMAL);
		}
	}
	
}

typedef struct{
	int 			seq;
	int 			sub;
	GF_BGL_INI    	*bgl;
	FIELDSYS_WORK 	*fsys;
	NAMEIN_PARAM   *NameInParam;
}TEST_PROC_WORK;


//----------------------------------------------------------------------------
/**
 *
 *	@brief O͌ĂяoeXg
 *
 *	@param	TCB_PTR tcb
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
void TestNameIn_Call( TCB_PTR tcb, void* work ) 
{
	TEST_PROC_WORK* wk = work;
	
	switch( wk->seq ){
	case 0:		// tF[hAEg
		FieldSystemProc_SeqHoldEnd();		
		wk->seq++;
		break;

	case 1:		// tB[hj
		if(wk->sub == 0){
			wk->sub++;

			// O͗p[N쐬
			wk->NameInParam = NameIn_ParamAllocMake(HEAPID_WORLD, NAMEIN_POKEMON, 2, 5);
//			wk->NameInParam = NameIn_ParamAllocMake(HEAPID_WORLD, NAMEIN_MYNAME, PM_MALE, 5);
//			PM_strcpy(wk->NameInParam->str,test_name);
			wk->NameInParam->info = 1;
			// OPROC쐬
			NameInput_SetProc( wk->fsys, wk->NameInParam );

			GameSystem_FinishFieldProc( wk->fsys );

		}else{

			// I`FbN
			if( FieldEvent_Cmd_WaitMapProcStart( wk->fsys ) == FALSE ){
				wk->sub = 0;
				wk->seq++;
			}
		}
		break;

	case 2:		// O͏
		wk->seq++;
		break;
	case 3:		// O͏I҂
		if( GameSystem_CheckSubProcExists( wk->fsys ) == FALSE ){
			{
				int i;
				OS_Printf("O ");
				for(i=0;i<5;i++){
					OS_Printf("%x",wk->NameInParam->str[i]);
				}
				OS_Printf("\n");
				OS_Printf("LZH = %d\n",wk->NameInParam->cancel);
			}
//			sys_FreeMemory( HEAPID_WORLD, wk->NameInParam );
			NameIn_ParamDelete( wk->NameInParam );
			// tB[hA
			GameSystem_CreateFieldProc( wk->fsys );

			// ^XNI
			TCB_Delete( tcb );
			sys_FreeMemoryEz( work );
		}
		return;
	}
}


void DebugNameInFuncInit(GF_BGL_INI * ini, FIELDSYS_WORK *fsys)
{
	TEST_PROC_WORK *namein_test = NULL;

	// ^XN
	namein_test = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof( TEST_PROC_WORK ) );
	// ZAN^[o^
	TCB_Add(TestNameIn_Call, namein_test, 8);

	namein_test->seq  = 0;
	namein_test->sub  = 0;
	namein_test->bgl  = ini;
	namein_test->fsys = fsys;
	



	
//	FieldSystemProc_SeqHoldEnd();
//	DebugMoriBmpMenuExit( work );
//	PMDS_taskDel( tcb );
	
}

//------------------------------------------------------------------
/**
 * XgĂяoeXg
 *
 * @param   tcb		
 * @param   work		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TestTradeList_Call( TCB_PTR tcb, void* work ) 
{
	TEST_PROC_WORK* wk = work;
	
	switch( wk->seq ){
	case 0:		// tF[hAEg
		FieldSystemProc_SeqHoldEnd();		
		wk->seq++;
		break;

	case 1:		// tB[hj
		if(wk->sub == 0){
			wk->sub++;

			// XgPROC쐬
//			TradeList_SetProc( wk->fsys );
			OekakiBoard_SetProc( wk->fsys );

			GameSystem_FinishFieldProc( wk->fsys );

		}else{

			// I`FbN
			if( FieldEvent_Cmd_WaitMapProcStart( wk->fsys ) == FALSE ){
				wk->sub = 0;
				wk->seq++;
			}
		}
		break;
	case 2:		// O͏I҂
		if( GameSystem_CheckSubProcExists( wk->fsys ) == FALSE ){
			// tB[hA
			GameSystem_CreateFieldProc( wk->fsys );

			// ^XNI
			TCB_Delete( tcb );
			sys_FreeMemoryEz( work );
		}
		return;
	}
}


//==============================================================================
/**
 * XgĂяoeXg^XN
 *
 * @param   ini		
 * @param   fsys		
 *
 * @retval  none		
 */
//==============================================================================
void DebugTradeListFuncInit(GF_BGL_INI * ini, FIELDSYS_WORK *fsys)
{
	TEST_PROC_WORK *tradelist_proc = NULL;

	// ^XN
	tradelist_proc = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof( TEST_PROC_WORK ) );
	// ZAN^[o^
	TCB_Add(TestTradeList_Call, tradelist_proc, 8);

	tradelist_proc->seq  = 0;
	tradelist_proc->sub  = 0;
	tradelist_proc->bgl  = ini;
	tradelist_proc->fsys = fsys;
}