//============================================================================================
/**
 *	fobOj[uȂނv̏
 */
//============================================================================================
#include "common.h"
#include "system/gamedata.h"
#include "system/lib_pack.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/snd_tool.h"
#include "system/palanm.h"
#include "system/window.h"
#include "system/wordset.h"
#include "system/bmp_cursor.h"
#include "system/msg_ds_icon.h"
#include "itemtool/itemsym.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "field/field.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "fld_bmp.h"
#include "battle/battle_common.h"
#include "battle/wazano_def.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "poketool/waza_tool.h"
#include "poketool/monsno.h"
#include "poketool/boxdata.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_debug_nakahiro.h"
#include "msgdata/msg_icontest.h"
#include "fld_bmp.h"
#include "vm.h"
#include "script.h"
#include "scrcmd.h"
#include "sxytype.h"
#include "fd_shop.h"
#include "talk_msg.h"


//============================================================================================
//	C
//============================================================================================
#define	TCB_WK_SIZE		( 4*16 )

enum {
	WK_SEQ = 0,
//	WK_WIN_INDEX,
//	WK_LIST_ID,
	WK_LIST_RET,

	WK_MAX
};

typedef struct {
	void * fsys;
	GF_BGL_BMPWIN	win;

	BMPLIST_WORK * lw;
	BMP_MENULIST_DATA * ld;	// BMPXgf[^

	MSGDATA_MANAGER * mman;	// bZ[Wf[^}l[W

	u32	work[WK_MAX];
}D_NAKAHIRO_PARAM;

typedef void (*pHNfunc)(void *);

// J[e[u
/*
enum {
	COL_W_BLACK = 0,	// iwij
	COL_W_BLUE,			// iwij
	COL_W_RED,			// ԁiwij
	COL_W_PINK,			// sNiwij
	COL_W_GREEN,		// ΁iwij
};
*/

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static void MainBmpListCB1( u32 param, u8 mode );
static void MainBmpListCB2( u8 index, u32 param, u8 y );
static void DN_MenuMain( TCB_PTR _tcb, void * work );
static void DN_MenuExit( D_NAKAHIRO_PARAM * wk );

static void DebugSleepSet(void);
static void DebugShopCall( void * fsys );
static void DebugTownMapCall( void * fsys );
static void DebugTownMapEnd( void * fsys );
static void DebugDispCheckCall( void * fsys );
static void DebugNutsMax( void * fsys );
static void DebugWazaMachineMax( void * fsys );


//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
#define	MAIN_BMPLIST_MAX	( 4 )

static const u32 d_menu_list[][2] =
{
	{ msg_menu_10, (u32)DebugNutsMax },
	{ msg_menu_11, (u32)DebugWazaMachineMax },
	{ msg_menu_05, (u32)DebugDispCheckCall },
//	{ msg_menu_07, (u32)DebugTownMapCall },
//	{ msg_menu_08, (u32)DebugTownMapEnd },
	{ msg_menu_09, (u32)DebugShopCall },
};

static const BMPLIST_HEADER d_menu_list_h = {
	NULL,				// \f[^|C^
	NULL,				// J[\ړƂ̃R[obN֐
	NULL,				// \Ƃ̃R[obN֐
	NULL,
	MAIN_BMPLIST_MAX,	// Xgڐ
	11,						// \ő區ڐ
	0,						// x\wW
	12,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};

// tHgJ[e[u
static const u8 ColorTbl[][3] =
{
	{ 15, 1, 2 },	// iwij
	{ 15, 3, 4 },	// iwij
	{ 15, 5, 6 },	// ԁiwij
	{ 15, 7, 8 },	// sNiwij
	{ 15, 9, 10 },	// ΁iwij
};

#define	COL_W_BLACK	( GF_PRINTCOLOR_MAKE( 1, 2, 15 ) )	// tHgJ[F
#define	COL_W_BLUE	( GF_PRINTCOLOR_MAKE( 3, 4, 15 ) )	// tHgJ[F
#define	COL_W_RED	( GF_PRINTCOLOR_MAKE( 5, 6, 15 ) )	// tHgJ[F
#define	COL_W_PINK	( GF_PRINTCOLOR_MAKE( 7, 8, 15 ) )	// tHgJ[F
#define	COL_W_GREEN	( GF_PRINTCOLOR_MAKE( 9, 10, 15 ) )	// tHgJ[F

void DebugNakamuraInit( void * fsys )
{
	D_NAKAHIRO_PARAM * wk;
	GF_BGL_INI * bgl;
	BMPLIST_HEADER	list_h;
	u32	i;


	OS_Printf( "HEAPID_WORLD : %d\n", sys_GetHeapFreeSize( HEAPID_WORLD ) );

	bgl = FieldBglIniGet( fsys );

	wk = (D_NAKAHIRO_PARAM *)TCB_GetWork(
					PMDS_taskAdd( DN_MenuMain, sizeof(D_NAKAHIRO_PARAM), 0, HEAPID_BASE_DEBUG ) );

	wk->fsys = fsys;
	wk->work[ WK_SEQ ] = 0;
	GF_BGL_BmpWinAdd( bgl, &wk->win, FLD_MBGFRM_FONT, 1, 1, 12, 12, 13, 1 );

	wk->mman = MSGMAN_Create(
				MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_debug_nakahiro_dat, HEAPID_BASE_DEBUG );

	wk->ld = BMP_MENULIST_Create( MAIN_BMPLIST_MAX, HEAPID_BASE_DEBUG );
	for( i=0; i<MAIN_BMPLIST_MAX; i++ ){
		BMP_MENULIST_AddArchiveString( wk->ld, wk->mman, d_menu_list[i][0], d_menu_list[i][1] );
	}

	list_h = d_menu_list_h;
	list_h.list = wk->ld;
	list_h.win  = &wk->win;
	wk->lw = BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinOn( &wk->win );
}

static void DN_MenuMain( TCB_PTR _tcb, void * work )
{
	D_NAKAHIRO_PARAM * wk = (D_NAKAHIRO_PARAM *)work;
	GF_BGL_INI * bgl;
	u32	ret;

	switch( wk->work[ WK_SEQ ] ){
	case 0:
		ret = BmpListMain( wk->lw );

		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			DN_MenuExit( wk );
			PMDS_taskDel( _tcb );
			FieldSystemProc_SeqHoldEnd();
			break;
		default:
			wk->work[WK_LIST_RET] = ret;
			wk->work[WK_SEQ]++;
		}
		break;
	case 1:
		{
			pHNfunc func = (pHNfunc)wk->work[WK_LIST_RET];
			void * fsys = wk->fsys;

			DN_MenuExit( wk );
			PMDS_taskDel( _tcb );
			func( fsys );
		}
	}
}

static void DN_MenuExit( D_NAKAHIRO_PARAM * wk )
{
	BmpListExit( wk->lw, NULL, NULL );
	BMP_MENULIST_Delete( wk->ld );

	MSGMAN_Delete( wk->mman );

	GF_BGL_BmpWinOff( &wk->win );
	GF_BGL_BmpWinDel( &wk->win );
}












typedef struct {
	void * fsys;
	GF_BGL_BMPWIN win;
	STRBUF * msg;
	void * dsi_task;
	u16	seq;
	u8	cnt;
	u8	midx;
}DEBUG_DISPCHECK;

static void DebugDispCheckMain( TCB_PTR _tcb, void * work );


static void DebugDispCheckCall( void * fsys )
{
	DEBUG_DISPCHECK * wk;

	wk = (DEBUG_DISPCHECK *)TCB_GetWork(
				PMDS_taskAdd( DebugDispCheckMain,
				sizeof(DEBUG_DISPCHECK), 8, HEAPID_BASE_DEBUG ) );
	wk->seq = 0;
	wk->cnt = 0;
	wk->fsys = fsys;
	FldTalkBmpAdd( FieldBglIniGet(fsys), &wk->win, FLD_MBGFRM_FONT );

	wk->dsi_task = MSG_DsIconFlashAdd( NULL, MSG_DSI_MAINDISP, FLD_MSG_WIN_PAL, HEAPID_BASE_DEBUG );
}

static void DebugDispCheckMain( TCB_PTR _tcb, void * work )
{
	DEBUG_DISPCHECK * wk = (DEBUG_DISPCHECK * )work;
	GF_BGL_INI * bgl = FieldBglIniGet( wk->fsys );

	switch( wk->seq ){
	case 0:		// init
		FldTalkWinPut( &wk->win );
		{
			MSGDATA_MANAGER * man = MSGMAN_Create(
				MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_icontest_dat, HEAPID_BASE_DEBUG );
//			WORDSET * wset = WORDSET_Create( HEAPID_BASE_DEBUG );
//			STRBUF * exp = STRBUF_Create( 64, HEAPID_BASE_DEBUG );
			wk->msg = MSGMAN_AllocString( man, msg_icontest_0001+wk->cnt );
//			WORDSET_ExpandStr( wset, exp, wk->msg );
			MSGMAN_Delete( man );
//			WORDSET_Delete( wset );
//			GF_STR_PrintSimple( &wk->win, FONT_TALK, exp, 0, 0, MSG_ALLPUT, NULL );
		}
		wk->midx = FldTalkMsgStart( &wk->win, wk->msg, 1 );
		wk->seq++;
		break;
	case 1:		// main
		if( FldTalkMsgEndCheck( wk->midx ) == 0 ){
			return;
		}
		STRBUF_Delete( wk->msg );
		wk->seq = 2;
		break;
	case 2:
		if( sys.trg & (PAD_BUTTON_DECIDE|PAD_BUTTON_CANCEL) ){
			if( wk->cnt == 3 ){
				wk->seq = 3;
			}else{
				wk->seq = 0;
			}
			wk->cnt++;
		}
		break;
	case 3:		// end
		BmpTalkWinClear( &wk->win, WINDOW_TRANS_ON );
		GF_BGL_BmpWinDel( &wk->win );

		MSG_DsIconFlashReq( wk->dsi_task, MSG_DSI_REQ_FREE );

		PMDS_taskDel( _tcb );
		FieldSystemProc_SeqHoldEnd();
		break;
	}
}

/*
u8 FldTalkMsgStart( GF_BGL_BMPWIN * win, STRBUF * msg, u8 skip )
{
	MsgPrintSkipFlagSet( skip );

	return GF_STR_PrintSimple( win, FONT_TALK, msg, 0, 0, MsgSpeedGet(), NULL );
}

u8 FldTalkMsgEndCheck( u8 msg_index )
*/









//============================================================================================
//	ACeMAX
//============================================================================================
static void DebugItemAdd( MYITEM * myitem, u32 id )
{
	u16	num;

	num = MyItem_GetItemNum( myitem, id, HEAPID_BASE_DEBUG );
	if( num == 999 ){ return; }
	MyItem_AddItem( myitem, id, 999-num, HEAPID_BASE_DEBUG );
}

//--------------------------------------------------------------------------------------------
//	؂̎MAX
//--------------------------------------------------------------------------------------------
static void DebugNutsMax( void * fsys )
{
	MYITEM * myitem;
	u32	i;

	myitem = SaveData_GetMyItem( ((FIELDSYS_WORK *)fsys)->savedata );

	for( i=0; i<ITEM_NUTS_MAX; i++ ){
		DebugItemAdd( myitem, ITEM_KURABONOMI+i );
	}
	FieldSystemProc_SeqHoldEnd();
}

//--------------------------------------------------------------------------------------------
//	Z}VMAX
//--------------------------------------------------------------------------------------------
static void DebugWazaMachineMax( void * fsys )
{
	MYITEM * myitem;
	u32	i;

	myitem = SaveData_GetMyItem( ((FIELDSYS_WORK *)fsys)->savedata );

	for( i=0; i<80; i++ ){
		DebugItemAdd( myitem, ITEM_WAZAMASIN01+i );
	}
	for( i=0; i<8; i++ ){
		DebugItemAdd( myitem, ITEM_HIDENMASIN01+i );
	}
	FieldSystemProc_SeqHoldEnd();
}








//============================================================================================
//	X[v[h
//============================================================================================
static void B_SleepCallBack( void * arg )
{
	OS_Printf( "INFO : B_SleepCallBack\n" );
}
static void A_SleepCallBack( void * arg )
{
	OS_Printf( "INFO : A_SleepCallBack\n" );
}

static void DebugSleepSet(void)
{
//	GF_SleepSystemInit();
/*
	{
		PMSleepCallbackInfo	b_info = { B_SleepCallBack, NULL, NULL };
		PMSleepCallbackInfo	a_info = { A_SleepCallBack, NULL, NULL };

		GF_SleepSystemSet(
			&b_info, &a_info, PM_TRIGGER_KEY,
			PM_PAD_LOGIC_AND, PAD_BUTTON_A | PAD_BUTTON_START, 0 );

		GF_SleepSystemDelete();
	}
*/
//	GF_SleepCoverCloseAdd();

	FieldSystemProc_SeqHoldEnd();
}

//============================================================================================
//	Vbv
//============================================================================================
#define	DEBUG_SHOP_MAX	( 10 )

static void DebugShopCall( void * fsys )
{
	u16 * item;
	u16	i;

	item = sys_AllocMemory( HEAPID_BASE_DEBUG, (DEBUG_SHOP_MAX+1)*2 );
	for( i=0; i<DEBUG_SHOP_MAX; i++ ){
		item[i] = i+1;
	}
	item[i] = 0xffff;

	FieldSystemProc_SeqHoldEnd();
	ShopInit( fsys, item );
	sys_FreeMemoryEz( item );
}


//============================================================================================
//	BMP OBJ TEST
//============================================================================================
void GF_BmpPrintObj(
			void * src, u16 src_x, u16 src_y, u16 src_dx, u16 src_dy,
			void * buf, u16 buf_sx, u16 buf_sy, u16 win_x, u16 win_y, u16 win_dx, u16 win_dy )
{
/*
	BMPPRT_HEADER	src_data;
	BMPPRT_HEADER	dst_data;

	src_data.adrs	= (u8 *)src;
	src_data.size_x = src_dx;
	src_data.size_y = src_dy;

	dst_data.adrs	= (u8 *)buf;
	dst_data.size_x = buf_sx;
	dst_data.size_y = buf_sy;

	GF_BMP_PrintMain( &src_data, &dst_data, src_x, src_y, win_x, win_y, win_dx, win_dy, 0 );
*/
}


//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//============================================================================================
//	ʃ}bv
//============================================================================================
typedef struct {
	void * fsys;
	u8	seq;
	u8	pos_cnt;
	u16	screen[32*32];
}DEBUG_TOWNMAP;

static u8 debug_townmap_end;

static void DebugTownMapMain( TCB_PTR _tcb, void * work );

static void DebugTownMapCall( void * fsys )
{
	DEBUG_TOWNMAP * wk;

	wk = (DEBUG_TOWNMAP *)TCB_GetWork(
				PMDS_taskAdd( DebugTownMapMain, sizeof(DEBUG_TOWNMAP), 8, HEAPID_BASE_DEBUG ) );
	wk->seq = 0;
	wk->fsys = fsys;
	debug_townmap_end = 1;
	FieldSystemProc_SeqHoldEnd();
}

static void DebugTownMapBgSet2( GF_BGL_INI * ini )
{
	{	// SUB DISPij[j
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x7800, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, GF_BGL_FRAME3_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
	}
}

static void DebugTownMapGraphicSet2( DEBUG_TOWNMAP * wk )
{
	void * pal;
	u16 * buf;
	u32	size;
	u32	i;
	GF_BGL_INI * bgl = FieldBglIniGet( wk->fsys );

	GF_BGL_LoadCharacterFile( bgl, GF_BGL_FRAME3_S, "/data/map_p2_sch.dat", 0 );
	GF_BGL_LoadScreenFile( bgl, GF_BGL_FRAME3_S, "/data/map_p2_ssc.dat", 0 );

/*
	GF_BGL_ScrFill( FLD_SBGFRM_EFFECT1, MAP_POS_CHAR, 0, 0, 1, 1, GF_BGL_SCRWRT_PALIN );
	GF_BGL_LoadScreenReq( FLD_SBGFRM_EFFECT1 );
*/

	pal = sys_LoadFileEx( HEAPID_BASE_DEBUG, "/data/map_p2_scl.dat", &size );
	DC_FlushRange( (void *)pal, size );
	GXS_LoadBGPltt( (const void *)pal, 16*3*2, 16*2*8 );

	buf = (u16 *)GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME3_S );
	for( i=0; i<32*32; i++ ){
		buf[i] += 0x3000;
		wk->screen[i] = buf[i];
	}
	GF_BGL_LoadScreenReq( bgl, GF_BGL_FRAME3_S );


	sys_FreeMemory( HEAPID_BASE_DEBUG, pal );
}

static void DebugTownMapControl2( DEBUG_TOWNMAP * wk )
{
	FIELDSYS_WORK * fsys = wk->fsys;
	int	gx, gz;
	int	my, py;
	GF_BGL_INI * bgl = FieldBglIniGet( fsys );

	gx = Player_NowGPosXGet( fsys->player ) / 32;
	gz = Player_NowGPosZGet( fsys->player ) / 32;

	my = gz - 11;
	if( my < 0 ){
		my = 0;
	}else if( my > 8 ){
		my = 8;
	}
	py = gz - my;

	GF_BGL_ScrollSet( bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, (my*8) );
/*
	GF_BGL_ScrollSet( bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_X_SET, -(gx*8+8) );
	GF_BGL_ScrollSet( bgl, GF_BGL_FRAME3_S, GF_BGL_SCROLL_Y_SET, -(py*8+8) );
*/

	if( ( wk->pos_cnt & 3 ) == 0 ){
		u16 * buf = (u16 *)GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME3_S );
		memcpy( buf, wk->screen, 32*32*2 );
		if( ( wk->pos_cnt & 4 ) == 0 ){
//			GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
			buf[(gz+1)*32+gx+1] = ( buf[(gz+1)*32+gx+1] & 0xfff ) + 0xa000;
		}else{
//			GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
			buf[(gz+1)*32+gx+1] = wk->screen[(gz+1)*32+gx+1];
		}
		GF_BGL_LoadScreenReq( bgl, GF_BGL_FRAME3_S );
	}
	wk->pos_cnt = ( wk->pos_cnt + 1 ) & 0xff;
}


static void DebugTownMapMain( TCB_PTR _tcb, void * work )
{
	DEBUG_TOWNMAP * wk = (DEBUG_TOWNMAP * )work;
	GF_BGL_INI * bgl = FieldBglIniGet( wk->fsys );

	switch( wk->seq ){
	case 0:		// init
		DebugTownMapBgSet2( bgl );
		DebugTownMapGraphicSet2( wk );
		GF_Disp_GXS_VisibleControl(
			GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 |
			GX_PLANEMASK_BG2 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
		debug_townmap_end = 0;
		wk->seq++;
		break;
	case 1:		// main
		if( debug_townmap_end == 1 ){
			wk->seq++;
		}else{
			DebugTownMapControl2( wk );
		}
		break;
	case 2:		// end
		GF_BGL_BGControlExit( bgl, GF_BGL_FRAME3_S );
		PMDS_taskDel( _tcb );
		break;
	}
}

void DebugTownMapEndReq( FIELDSYS_WORK * fsys )
{
	GF_BGL_INI * bgl = FieldBglIniGet( fsys );

	debug_townmap_end = 1;
//	GF_BGL_BGControlExit( bgl, GF_BGL_FRAME3_S );
}

static void DebugTownMapEnd( void * fsys )
{
/*
	GF_BGL_INI * bgl = FieldBglIniGet( fsys );

	debug_townmap_end = 1;
	GF_Disp_GXS_VisibleControlInit();
	GF_Disp_GXS_VisibleControl(
			GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 |
			GX_PLANEMASK_BG2 | GX_PLANEMASK_OBJ, VISIBLE_ON );
	GF_BGL_BGControlExit( bgl, GF_BGL_FRAME3_S );
*/
	FieldSystemProc_SeqHoldEnd();
}




//============================================================================================
//============================================================================================
//	ǂ
//============================================================================================
//============================================================================================
typedef struct {
	FIELDSYS_WORK * fsys;
	GF_BGL_BMPWIN	win;
	MINEITEM	item;
	u32	seq;
}D_ITEMMAKE;

static void D_ItemMakeMain( TCB_PTR _tcb, void * work );
static void D_ItemMakeBmpExit( D_ITEMMAKE * wk );
static void D_ItemStrPut( D_ITEMMAKE * wk );
static u8 D_ItemIDSel( D_ITEMMAKE * wk );
static u8 D_ItemNumSel( D_ITEMMAKE * wk );


// 
void DebugItemMakeInit( void * fsys )
{
	D_ITEMMAKE * wk;
	GF_BGL_INI * bgl;

	bgl = FieldBglIniGet( fsys );

	wk = (D_ITEMMAKE *)TCB_GetWork(
				PMDS_taskAdd( D_ItemMakeMain, sizeof(D_ITEMMAKE), 0, HEAPID_BASE_DEBUG ) );

	wk->fsys = fsys;
	wk->seq  = 0;
	wk->item.id = 1;
	wk->item.no = 1;
	GF_BGL_BmpWinAdd( bgl, &wk->win, FLD_MBGFRM_FONT, 1, 19, 30, 4, 13, 1 );

	MenuWinGraphicSet(
		bgl, FLD_MBGFRM_FONT, MENU_WIN_CGX_NUM, MENU_WIN_PAL, 0, HEAPID_BASE_DEBUG );
	BmpMenuWinWrite( &wk->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );

	D_ItemStrPut( wk );
}

// \
static void D_ItemStrPut( D_ITEMMAKE * wk )
{
	GF_BGL_BMPWIN * win;
	MSGDATA_MANAGER * mman;
	WORDSET * wset;
	STRBUF * expb;
	STRBUF * strb;

	win = &wk->win;
	GF_BGL_BmpWinDataFill( win, 15 );

	mman = MSGMAN_Create(
				MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_debug_nakahiro_dat, HEAPID_BASE_DEBUG );
	wset = WORDSET_Create( HEAPID_BASE_DEBUG );
	expb = STRBUF_Create( 64, HEAPID_BASE_DEBUG );

	strb = MSGMAN_AllocString( mman, msg_itemmake_02 );
	WORDSET_RegisterNumber( wset, 0, wk->item.id, 3, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wset, expb, strb );
	if( wk->seq == 0 ){
		GF_STR_PrintColor( win, FONT_SYSTEM, expb, 32, 8, MSG_NO_PUT, COL_W_RED, NULL );
	}else{
		GF_STR_PrintColor( win, FONT_SYSTEM, expb, 32, 8, MSG_NO_PUT, COL_W_BLACK, NULL );
	}
	STRBUF_Delete( strb );

	strb = MSGMAN_AllocString( mman, msg_itemmake_01 );
	WORDSET_RegisterItemName( wset, 0, wk->item.id );
	WORDSET_ExpandStr( wset, expb, strb );
	if( wk->seq == 0 ){
		GF_STR_PrintColor( win, FONT_SYSTEM, expb, 64, 8, MSG_NO_PUT, COL_W_RED, NULL );
	}else{
		GF_STR_PrintColor( win, FONT_SYSTEM, expb, 64, 8, MSG_NO_PUT, COL_W_BLACK, NULL );
	}
	STRBUF_Delete( strb );

	strb = MSGMAN_AllocString( mman, msg_itemmake_00 );
	GF_STR_PrintColor( win, FONT_SYSTEM, strb, 176, 8, MSG_NO_PUT, COL_W_BLACK, NULL );
	STRBUF_Delete( strb );
	strb = MSGMAN_AllocString( mman, msg_itemmake_02 );
	WORDSET_RegisterNumber( wset, 0, wk->item.no, 3, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wset, expb, strb );
	if( wk->seq == 1 ){
		GF_STR_PrintColor( win, FONT_SYSTEM, expb, 188, 8, MSG_ALLPUT, COL_W_RED, NULL );
	}else{
		GF_STR_PrintColor( win, FONT_SYSTEM, expb, 188, 8, MSG_ALLPUT, COL_W_BLACK, NULL );
	}
	STRBUF_Delete( strb );

	STRBUF_Delete( expb );
	MSGMAN_Delete( mman );
	WORDSET_Delete( wset );
}

// C
static void D_ItemMakeMain( TCB_PTR _tcb, void * work )
{
	D_ITEMMAKE * wk = (D_ITEMMAKE *)work;

	switch( wk->seq ){
	case 0:		// ACeI
		if( D_ItemIDSel( wk ) == TRUE ){
			D_ItemMakeBmpExit( wk );
			PMDS_taskDel( _tcb );
			FieldSystemProc_SeqHoldEnd();
		}
		break;
	case 1:
		if( D_ItemNumSel( wk ) == TRUE ){
			wk->seq = 0;
		}
		break;
	}
}

// IDύX
static void D_ItemIDSet( D_ITEMMAKE * wk, s8 plus )
{
	s16	id = wk->item.id;

	id += plus;

	if( id <= 0 ){
		wk->item.id = ITEM_DATA_MAX;
	}else if( id > ITEM_DATA_MAX ){
		wk->item.id = 1;
	}else{
		wk->item.id = id;
	}
}

// IDύX
static u8 D_ItemIDSel( D_ITEMMAKE * wk )
{
	if( sys.repeat & PAD_KEY_UP ){
		D_ItemIDSet( wk, 1 );
		D_ItemStrPut( wk );
		return FALSE;
	}
	if( sys.repeat & PAD_KEY_DOWN ){
		D_ItemIDSet( wk, -1 );
		D_ItemStrPut( wk );
		return FALSE;
	}
	if( sys.repeat & PAD_KEY_LEFT ){
		D_ItemIDSet( wk, -10 );
		D_ItemStrPut( wk );
		return FALSE;
	}
	if( sys.repeat & PAD_KEY_RIGHT ){
		D_ItemIDSet( wk, 10 );
		D_ItemStrPut( wk );
		return FALSE;
	}

	if( sys.trg & PAD_BUTTON_A ){
		wk->seq = 1;
		D_ItemStrPut( wk );
		return FALSE;
	}

	if( sys.trg & PAD_BUTTON_B ){
		return TRUE;
	}

	return FALSE;
}

// ύX
static void D_ItemNumSet( D_ITEMMAKE * wk, s8 plus )
{
	s16	num = wk->item.no;

	num += plus;

	if( num <= 0 ){
		wk->item.no = 999;
	}else if( num >= 1000 ){
		wk->item.no = 1;
	}else{
		wk->item.no = num;
	}
}

// ύX
static u8 D_ItemNumSel( D_ITEMMAKE * wk )
{
	if( sys.repeat & PAD_KEY_UP ){
		D_ItemNumSet( wk, 1 );
		D_ItemStrPut( wk );
		return FALSE;
	}
	if( sys.repeat & PAD_KEY_DOWN ){
		D_ItemNumSet( wk, -1 );
		D_ItemStrPut( wk );
		return FALSE;
	}
	if( sys.repeat & PAD_KEY_LEFT ){
		D_ItemNumSet( wk, -10 );
		D_ItemStrPut( wk );
		return FALSE;
	}
	if( sys.repeat & PAD_KEY_RIGHT ){
		D_ItemNumSet( wk, 10 );
		D_ItemStrPut( wk );
		return FALSE;
	}

	if( sys.trg & PAD_BUTTON_A ){
		wk->seq = 0;
		MyItem_AddItem(
			SaveData_GetMyItem( wk->fsys->savedata ),
			wk->item.id, wk->item.no, HEAPID_BASE_DEBUG );
		D_ItemStrPut( wk );
		return FALSE;
	}

	if( sys.trg & PAD_BUTTON_B ){
		wk->seq = 0;
		D_ItemStrPut( wk );
		return TRUE;
	}

	return FALSE;
}

static void D_ItemMakeBmpExit( D_ITEMMAKE * wk )
{
	BmpMenuWinClear( &wk->win, WINDOW_TRANS_ON );

	GF_BGL_BmpWinOff( &wk->win );
	GF_BGL_BmpWinDel( &wk->win );
}



//============================================================================================
//============================================================================================
//	|P
//============================================================================================
//============================================================================================
typedef struct {
	POKEMON_PARAM * PokeMakeData;
	u32	PMD[64];
	u32	data_bak;

	u16	str[0x100];

	u8	page_p;
	u8	cursor_p;
	u8	value_p;
}PokeMakeWork;

typedef struct {
	u32	min;
	u32	max;
	u8	mode;
	u8	count;
}PmakeCont;

typedef struct {
	u32 label;
	const PmakeCont * cont;
}PmakeParamData;

typedef struct {
	const u8 * page;
	u8	listcount;
}PmakePageTable;


#define	PMC_INCDEC		(0)
#define	PMC_INIT		(0)
#define	PMC_INC			(1)
#define	PMC_DEC			(2)


typedef struct {
	FIELDSYS_WORK * fsys;
	GF_BGL_BMPWIN	win;
	GF_BGL_BMPWIN	win_title;
	MSGDATA_MANAGER * mman;	// bZ[Wf[^}l[W
	WORDSET * wset;			// PZbg
	BMPCURSOR * cursor;
	PokeMakeWork	pmw;
	u32	seq;
}D_POKEMONMAKE;


#define	PMAKE_NAME			( 0 )	//|Pio[i16bitj
#define	PMAKE_LEVEL			( 1 )	//xi8bitj
#define	PMAKE_EXP			( 2 )	//oli32bitj
#define	PMAKE_ID			( 3 )	//hci32bitj
#define	PMAKE_PERRND		( 4 )	//̗i32bitj
#define	PMAKE_SEX			( 5 )	//ʁi8bitj
#define	PMAKE_PERSONAL		( 6 )	//ii8bitj
#define	PMAKE_WAZA1			( 7 )	//ĂZPi8bitj
#define	PMAKE_WAZA2			( 8 )	//ĂZQi8bitj
#define	PMAKE_WAZA3			( 9 )	//ĂZRi8bitj
#define	PMAKE_WAZA4			( 10 )	//ĂZSi8bitj
#define	PMAKE_ITEM			( 11 )	//ACei8bitj
#define	PMAKE_SPABI			( 12 )	//\́i1bitj
#define	PMAKE_HP_RND		( 13 )	//goi5bitj
#define	PMAKE_HP_EXP		( 14 )	//gooli8bitj
#define	PMAKE_POW_RND		( 15 )	//i5bitj
#define	PMAKE_POW_EXP		( 16 )	//oli8bitj
#define	PMAKE_DEF_RND		( 17 )	//ڂ嗐i5bitj
#define	PMAKE_DEF_EXP		( 18 )	//ڂoli8bitj
#define	PMAKE_AGI_RND		( 19 )	//΂₳i5bitj
#define	PMAKE_AGI_EXP		( 20 )	//΂₳oli8bitj
#define	PMAKE_EXPOW_RND		( 21 )	//ꂱi5bitj
#define	PMAKE_EXPOW_EXP		( 22 )	//ꂱoli8bitj
#define	PMAKE_EXDEF_RND		( 23 )	//ڂ嗐i5bitj
#define	PMAKE_EXDEF_EXP		( 24 )	//ڂoli8bitj
#define	PMAKE_STYLE			( 25 )	//悳i8bitj
#define	PMAKE_BEAUTIFUL		( 26 )	//i8bitj
#define	PMAKE_CUTE			( 27 )	//킢i8bitj
#define	PMAKE_CLEVER		( 28 )	//i8bitj
#define	PMAKE_STRONG		( 29 )	//܂i8bitj
#define	PMAKE_FUR			( 30 )	//щi8bitj
#define	PMAKE_FRIEND		( 31 )	//Ȃxi8bitj
#define	PMAKE_POKERUS		( 32 )	//|PXi8bitj
#define	PMAKE_TAMAGO		( 33 )	//^}SԃtOi1bitj
#define	PMAKE_CONDITION		( 34 )	//炾̏ԁi32bitj
#define	PMAKE_HP			( 35 )	//go
#define	PMAKE_POW			( 36 )	//
#define	PMAKE_DEF			( 37 )	//ڂ
#define	PMAKE_AGI			( 38 )	//΂₳
#define	PMAKE_EXPOW			( 39 )	//ꂱ
#define	PMAKE_EXDEF			( 40 )	//ڂ
#define	PMAKE_EVGET			( 41 )	//Cxgzzrbgi1bitj
#define	PMAKE_GETPLACE		( 42 )	//ߊlꏊi8bitj
#define	PMAKE_GETLEVEL		( 43 )	//ߊlxi7bitj
#define	PMAKE_GETCASSETTE	( 44 )	//ߊlJZbgi4bitj
#define	PMAKE_GETBALL		( 45 )	//ߊl{[i4bitj

#define PMAKE_BATTLEPARAM1	( 0xfe )
#define PMAKE_BATTLEPARAM2	( 0xfd )

static const PmakeCont	cont00		= {1,MONSNO_TAMAGO-1,PMC_INCDEC,3};
static const PmakeCont	cont01		= {1,100,PMC_INCDEC,3};
static const PmakeCont	cont02		= {1,2000000,PMC_INCDEC,7};
static const PmakeCont	cont03		= {0,0xffffffff,PMC_INCDEC,10};
static const PmakeCont	cont04		= {0,0xffffffff,PMC_INCDEC,10};
static const PmakeCont	cont05		= {0,2,PMC_INCDEC,0xff};
static const PmakeCont	cont06		= {0,24,PMC_INCDEC,0xff};
static const PmakeCont	cont07		= {0,WAZANO_MAX,PMC_INCDEC,3};
static const PmakeCont	cont08		= {0,WAZANO_MAX,PMC_INCDEC,3};
static const PmakeCont	cont09		= {0,WAZANO_MAX,PMC_INCDEC,3};
static const PmakeCont	cont10		= {0,WAZANO_MAX,PMC_INCDEC,3};
static const PmakeCont	cont11		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont12		= {0,1,PMC_INCDEC,0xff};
static const PmakeCont	cont13		= {0,0x1f,PMC_INCDEC,2};
static const PmakeCont	cont14		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont15		= {0,0x1f,PMC_INCDEC,2};
static const PmakeCont	cont16		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont17		= {0,0x1f,PMC_INCDEC,2};
static const PmakeCont	cont18		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont19		= {0,0x1f,PMC_INCDEC,2};
static const PmakeCont	cont20		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont21		= {0,0x1f,PMC_INCDEC,2};
static const PmakeCont	cont22		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont23		= {0,0x1f,PMC_INCDEC,2};
static const PmakeCont	cont24		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont25		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont26		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont27		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont28		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont29		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont30		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont31		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont32		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont33		= {0,1,PMC_INCDEC,0xff};
static const PmakeCont	cont34		= {0,6,PMC_INCDEC,0xff};
static const PmakeCont	cont41		= {0,1,PMC_INCDEC,0xff};
static const PmakeCont	cont42		= {0,255,PMC_INCDEC,3};
static const PmakeCont	cont43		= {0,100,PMC_INCDEC,3};
static const PmakeCont	cont44		= {1,15,PMC_INCDEC,2};
static const PmakeCont	cont45		= {0,15,PMC_INCDEC,2};

static const PmakeParamData	PMakelabelTable[] =
{
	{msg_pmlabel_00,&cont00}, {msg_pmlabel_01,&cont01}, {msg_pmlabel_02,&cont02}, {msg_pmlabel_03,&cont03},
	{msg_pmlabel_04,&cont04}, {msg_pmlabel_05,&cont05}, {msg_pmlabel_06,&cont06}, {msg_pmlabel_07,&cont07},
	{msg_pmlabel_08,&cont08}, {msg_pmlabel_09,&cont09}, {msg_pmlabel_10,&cont10}, {msg_pmlabel_11,&cont11},
	{msg_pmlabel_12,&cont12}, {msg_pmlabel_13,&cont13}, {msg_pmlabel_14,&cont14}, {msg_pmlabel_15,&cont15},
	{msg_pmlabel_16,&cont16}, {msg_pmlabel_17,&cont17}, {msg_pmlabel_18,&cont18}, {msg_pmlabel_19,&cont19},
	{msg_pmlabel_20,&cont20}, {msg_pmlabel_21,&cont21}, {msg_pmlabel_22,&cont22}, {msg_pmlabel_23,&cont23},
	{msg_pmlabel_24,&cont24}, {msg_pmlabel_25,&cont25}, {msg_pmlabel_26,&cont26}, {msg_pmlabel_27,&cont27},
	{msg_pmlabel_28,&cont28}, {msg_pmlabel_29,&cont29}, {msg_pmlabel_30,&cont30}, {msg_pmlabel_31,&cont31},
	{msg_pmlabel_32,&cont32}, {msg_pmlabel_33,&cont33}, {msg_pmlabel_34,&cont34}, {msg_pmlabel_35,&cont00},
	{msg_pmlabel_36,&cont00}, {msg_pmlabel_37,&cont00}, {msg_pmlabel_38,&cont00}, {msg_pmlabel_39,&cont00},
	{msg_pmlabel_40,&cont00}, {msg_pmlabel_41,&cont41}, {msg_pmlabel_42,&cont42}, {msg_pmlabel_43,&cont43},
	{msg_pmlabel_44,&cont44}, {msg_pmlabel_45,&cont45},
};

static const u32 CondTable[][2] =
{
	{ msg_pmcnname_01, 0x00000000 },	// ʏ
	{ msg_pmcnname_02, 0x00000001 },	// 		( 0x00000007 )
	{ msg_pmcnname_03, 0x00000008 },	// 		( 0x00000008 )
	{ msg_pmcnname_04, 0x00000010 },	// ₯	( 0x00000010 )
	{ msg_pmcnname_05, 0x00000020 },	// 	( 0x00000020 )
	{ msg_pmcnname_06, 0x00000040 },	// ܂		( 0x00000040 )
	{ msg_pmcnname_07, 0x00000080 },	// ǂǂ	( 0x00000080 )
};


static const u8 Page1[] = {
	PMAKE_NAME, PMAKE_LEVEL, PMAKE_EXP, PMAKE_ID,
	PMAKE_PERRND, PMAKE_SEX, PMAKE_PERSONAL, 0xff
};
static const u8 Page2[] = {
	PMAKE_CONDITION, PMAKE_FRIEND, PMAKE_POKERUS,
	PMAKE_TAMAGO, PMAKE_EVGET, 0xff
};
static const u8 Page3[] = {
	PMAKE_WAZA1, PMAKE_WAZA2, PMAKE_WAZA3,
	PMAKE_WAZA4, PMAKE_ITEM, PMAKE_SPABI, 0xff
};
static const u8 Page4[] = {
	PMAKE_HP_RND, PMAKE_HP_EXP, PMAKE_POW_RND, PMAKE_POW_EXP,
	PMAKE_DEF_RND, PMAKE_DEF_EXP, PMAKE_BATTLEPARAM1, 0xff
};
static const u8 Page5[] = {
	PMAKE_AGI_RND, PMAKE_AGI_EXP, PMAKE_EXPOW_RND, PMAKE_EXPOW_EXP,
	PMAKE_EXDEF_RND, PMAKE_EXDEF_EXP, PMAKE_BATTLEPARAM2, 0xff
};
static const u8 Page6[] = {
	PMAKE_STYLE, PMAKE_BEAUTIFUL, PMAKE_CUTE,
	PMAKE_CLEVER, PMAKE_STRONG, PMAKE_FUR, 0xff
};
static const u8 Page7[] = {
	PMAKE_GETPLACE, PMAKE_GETLEVEL, PMAKE_GETCASSETTE, PMAKE_GETBALL, 0xff
};

#define	PMAKE_PAGE_MAX	(7)
static const PmakePageTable PageTable[] =
{
	{ Page1,5}, {Page2,5},
	{ Page3,6}, {Page4,6},
	{ Page5,6}, {Page6,6},
	{ Page7,4}
};




static void D_PokemonMakeMain( TCB_PTR _tcb, void * work );
static void PokeMakeSeq_PagePut( D_POKEMONMAKE * wk );
static void	PokeMakeSeq_ParamSelect( D_POKEMONMAKE * wk );
static void	PokeMakeSeq_ParamChange( D_POKEMONMAKE * wk );
static void	PokeMakeSeq_ButtonWait( D_POKEMONMAKE * wk );

static void PmakeExitTaskSeq( D_POKEMONMAKE * wk );
static void D_PokemonMakeStrPut( D_POKEMONMAKE * wk );

static void PokeMakeInit( D_POKEMONMAKE * wk );
static u8 PokeMakeCopy( D_POKEMONMAKE * wk );
static void PokeMakeWorkInit( PokeMakeWork * dpw );
static void PokeMakePokeParaCalcInit( PokeMakeWork * dpw );
static void PokeMakePokeParaCalcGetExp( PokeMakeWork * dpw );
static void PokeMakePokeParaCalcGetBattleParam( PokeMakeWork * dpw );
static void PokeMakePokeParaCalcEnd( D_POKEMONMAKE * wk, PokeMakeWork * dpw );
static void D_PokeWazaSetPos( POKEMON_PARAM * pp, u16 waza, u16 pos );
static void ValueControl( PokeMakeWork * dpw, u8 mode );
static void CursorPut( D_POKEMONMAKE * wk, u8 mode );
static void PagePut( D_POKEMONMAKE * wk );
static void PageValuePut( D_POKEMONMAKE * wk );
static void NumPutBuffer( PokeMakeWork * dpw, u16 * buf, u32 num, u8 cnt, u8 pal );
static void WazaNameGet( u16 * buf, u16 waza );
static void SeikakuStrGet( u16 * buf, u16 num );
static void TokuseiStrGet( u16 * buf, u16 mons, u16 num );
static void PokeMake_StrPrint(
			GF_BGL_BMPWIN * win, MSGDATA_MANAGER * man, u32 id, u32 x, u32 y, u32 wait, u32 col );
static void PokeMake_StrPrintExp(
			GF_BGL_BMPWIN * win, MSGDATA_MANAGER * man, WORDSET * wset,
			u32 id, u32 x, u32 y, u32 wait, u32 col );
static void PokeMake_NumPrint(
			GF_BGL_BMPWIN * win, MSGDATA_MANAGER * man, WORDSET * wset,
			PokeMakeWork * dpw, u32 num, u32 keta, u32 x, u32 y, u32 wait, u32 col );
static void PokeMake_MonsNamePut( GF_BGL_BMPWIN * win, u32 mons, u32 x, u32 y, u32 wait, u32 col );



// 
void DebugPokemonMakeInit( void * fsys )
{
	D_POKEMONMAKE * wk;
	GF_BGL_INI * bgl;

	bgl = FieldBglIniGet( fsys );

	wk = (D_POKEMONMAKE *)TCB_GetWork(
				PMDS_taskAdd( D_PokemonMakeMain, sizeof(D_POKEMONMAKE), 0, HEAPID_BASE_DEBUG ) );

	wk->fsys = fsys;
	wk->seq  = 0;

	wk->mman = MSGMAN_Create(
				MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_nakahiro_dat, HEAPID_BASE_DEBUG );
	wk->wset = WORDSET_Create( HEAPID_BASE_DEBUG );
	wk->cursor = BMPCURSOR_Create( HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinAdd( bgl, &wk->win_title, FLD_MBGFRM_FONT, 1, 1, 30, 4, 13, 1 );
	GF_BGL_BmpWinAdd( bgl, &wk->win, FLD_MBGFRM_FONT, 1, 7, 30, 16, 13, 1+30*4 );

	MenuWinGraphicSet(
		bgl, FLD_MBGFRM_FONT, 1+30*4+30*16, MENU_WIN_PAL, 0, HEAPID_BASE_DEBUG );
	BmpMenuWinWrite( &wk->win_title, WINDOW_TRANS_OFF, 1+30*4+30*16, MENU_WIN_PAL );
	BmpMenuWinWrite( &wk->win, WINDOW_TRANS_OFF, 1+30*4+30*16, MENU_WIN_PAL );

	PokeMakeInit( wk );

//	GF_BGL_BmpWinOn( &wk->win_title );
//	GF_BGL_BmpWinOn( &wk->win );
}





/********************************************************************/
/*				|PI									*/
/********************************************************************/
// C
static void D_PokemonMakeMain( TCB_PTR _tcb, void * work )
{
	D_POKEMONMAKE * wk = (D_POKEMONMAKE *)work;

	switch( wk->seq ){
	case 0:	// y[W\
		PokeMakeSeq_PagePut( wk );
		break;
	case 1:	// ڑI
		PokeMakeSeq_ParamSelect( wk );
		break;
	case 2:	// ڕύX
		PokeMakeSeq_ParamChange( wk );
		break;
	case 3:	// {^͑҂
		PokeMakeSeq_ButtonWait( wk );
		break;
	case 4:	// I
		PmakeExitTaskSeq( wk );
		PMDS_taskDel( _tcb );
		FieldSystemProc_SeqHoldEnd();
		break;
	}
}

// XN[`
static void PokeMakeSeq_PagePut( D_POKEMONMAKE * wk )
{
	PagePut( wk );
	CursorPut( wk, PMC_INIT );
	wk->seq = 1;
}

// ڑI
static void	PokeMakeSeq_ParamSelect( D_POKEMONMAKE * wk )
{
	u8	ret;

	if( sys.trg & PAD_BUTTON_A ){
		//ύX
		wk->pmw.data_bak = wk->pmw.PMD[ PageTable[wk->pmw.page_p].page[wk->pmw.cursor_p] ];
		wk->pmw.value_p = 0;
		PageValuePut( wk );
		wk->seq = 2;
		return;
	}

	if( sys.trg & PAD_BUTTON_B ){
		wk->seq = 4;
		return;
	}

	if( sys.trg & PAD_BUTTON_START ){
//		SePlay(SE_SELECT);
		PokeMakePokeParaCalcEnd( wk, &wk->pmw );
		ret = PokeMakeCopy( wk );
		GF_BGL_BmpWinFill( &wk->win, 15, 24, 64, 30*8-24, 32 );
		if( ret == TRUE ){
			PokeMake_StrPrint( &wk->win, wk->mman, msg_pminfo_01, 32, 72, MSG_ALLPUT, COL_W_BLACK );
		}else{
			PokeMake_StrPrint( &wk->win, wk->mman, msg_pminfo_00, 32, 72, MSG_ALLPUT, COL_W_BLACK );
		}
		wk->seq = 3;
		return;
	}

	if( sys.trg & PAD_KEY_UP ){
		CursorPut( wk, PMC_DEC );
		return;
	}

	if( sys.trg & PAD_KEY_DOWN ){
		CursorPut( wk, PMC_INC );
		return;
	}

	if( ( sys.trg & PAD_BUTTON_L ) && wk->pmw.page_p > 0 ){
		wk->pmw.page_p--;
		wk->pmw.cursor_p = 0;
		wk->seq = 0;
		return;
	}

	if( ( sys.trg & PAD_BUTTON_R ) && wk->pmw.page_p < PMAKE_PAGE_MAX-1 ){
		wk->pmw.page_p++;
		wk->pmw.cursor_p = 0;
		wk->seq = 0;
		return;
	}
}


// ڕύX
static void	PokeMakeSeq_ParamChange( D_POKEMONMAKE * wk )
{
	u8	data_id;

	data_id = PageTable[wk->pmw.page_p].page[wk->pmw.cursor_p];

	if( sys.trg & PAD_BUTTON_A ){
		wk->seq = 0;
		return;
	}

	if( sys.trg & PAD_BUTTON_B ){
		wk->pmw.PMD[data_id] = wk->pmw.data_bak;
		wk->seq = 0;
		return;
	}

	if( sys.repeat & PAD_KEY_UP ){
		ValueControl( &wk->pmw, PMC_INC );
		PageValuePut( wk );
		return;
	}
	if( sys.repeat & PAD_KEY_DOWN ){
		ValueControl( &wk->pmw, PMC_DEC );
		PageValuePut( wk );
		return;
	}

	if( PMakelabelTable[data_id].cont->count != 0xff ){
		if( ( sys.trg & PAD_KEY_LEFT ) &&
			wk->pmw.value_p < PMakelabelTable[data_id].cont->count-1 ){

			wk->pmw.value_p++;
			PageValuePut( wk );
			return;
		}
		if( ( sys.trg & PAD_KEY_RIGHT ) && wk->pmw.value_p > 0 ){
			wk->pmw.value_p--;
			PageValuePut( wk );
			return;
		}
	}
}

// {^͑҂
static void	PokeMakeSeq_ButtonWait( D_POKEMONMAKE * wk )
{
	if( sys.trg & PAD_BUTTON_A ){
		wk->seq = 0;
	}
}

// I
static void PmakeExitTaskSeq( D_POKEMONMAKE * wk )
{
	sys_FreeMemoryEz( wk->pmw.PokeMakeData );

	BmpMenuWinClear( &wk->win_title, WINDOW_TRANS_OFF );
	BmpMenuWinClear( &wk->win, WINDOW_TRANS_ON );

	GF_BGL_BmpWinOff( &wk->win_title );
	GF_BGL_BmpWinOff( &wk->win );
	GF_BGL_BmpWinDel( &wk->win_title );
	GF_BGL_BmpWinDel( &wk->win );

	MSGMAN_Delete( wk->mman );
	WORDSET_Delete( wk->wset );
	BMPCURSOR_Delete( wk->cursor );
}


/********************************************************************/
/*																*/
/********************************************************************/

static void PokeMakeInit( D_POKEMONMAKE * wk )
{
	GF_BGL_BmpWinDataFill( &wk->win_title, 15 );
	PokeMake_StrPrint( &wk->win_title, wk->mman, msg_pminfo_02, 0, 0, MSG_ALLPUT, COL_W_BLACK );

	wk->pmw.PokeMakeData = PokemonParam_AllocWork( HEAPID_BASE_DEBUG );
	PokeMakeWorkInit( &wk->pmw );
	wk->pmw.page_p   = 0;
	wk->pmw.cursor_p = 0;
}

/********************************************************************/
/*				莝|PZbg								*/
/********************************************************************/
static u8 PokeMakeCopy( D_POKEMONMAKE * wk )
{
	POKEPARTY * party;

//	ZukanCheck(dpw->PMD[PMAKE_NAME],Z_SEE_SET);
//	ZukanCheck(dpw->PMD[PMAKE_NAME],Z_GET_SET);

	party = SaveData_Get( wk->fsys->savedata, GMDATA_ID_TEMOTI_POKE );

	if( PokeParty_Add( party, wk->pmw.PokeMakeData ) == TRUE ){
		return 0;
	}


	//莝ςȂ̂ŁA{bNX]
	BOXDAT_PutPokemon(
		SaveData_GetBoxData(wk->fsys->savedata), PPPPointerGet(wk->pmw.PokeMakeData) );

/*
	//{bNXɓ]ꂽꃁbZ[W\邩`FbN
	//fobNȂ̂œꃁbZ[W͕\ȂA
	//ꃁbZ[W\tOȂ̂Œǉ
	ChkBoxExMsg();
*/

	return 1;
}

/********************************************************************/
/*				쐬f[^									*/
/********************************************************************/
static void PokeMakeWorkInit( PokeMakeWork * dpw )
{
	u16	i;

	for( i=0; i<64; i++ ){
		dpw->PMD[i]	= 0;
	}
	// |Pio[i쐬͑S}Ӄio[j
	dpw->PMD[ PMAKE_NAME ] = 1;	
	//hc
//	dpw->PMD[PMAKE_ID] = (myd->ID[0]<<0)|(myd->ID[1]<<8)|(myd->ID[2]<<16)|(myd->ID[3]<<24);
	dpw->PMD[ PMAKE_ID ] = 0;

	//̗
	dpw->PMD[ PMAKE_PERRND ] = (gf_rand()<<16) | (gf_rand());
	//olx
	dpw->PMD[ PMAKE_LEVEL ]       = 1;	
	dpw->PMD[ PMAKE_EXP ]         = 1;	
	dpw->PMD[ PMAKE_GETPLACE ]    = 0;
	dpw->PMD[ PMAKE_GETLEVEL ]    = 1;
//	dpw->PMD[ PMAKE_GETCASSETTE ] = CasetteVersion;
	dpw->PMD[ PMAKE_GETCASSETTE ] = 1;
	dpw->PMD[ PMAKE_GETBALL ]     = 0;
	//ĂZ
	//ReXgpp[^
	//퓬pp[^
	//̑
	PokeMakePokeParaCalcInit( dpw );
}

/********************************************************************/
/*				f[^vZ											*/
/********************************************************************/
static void PokeMakePokeParaCalcInit( PokeMakeWork * dpw )
{
	u32	pow_rnd;

	pow_rnd = ( (dpw->PMD[PMAKE_HP_RND]&0x0000001f) << 0 )
			| ( (dpw->PMD[PMAKE_POW_RND]&0x0000001f) << 5 )
			| ( (dpw->PMD[PMAKE_DEF_RND]&0x0000001f) << 10 )
			| ( (dpw->PMD[PMAKE_AGI_RND]&0x0000001f) << 15 )
			| ( (dpw->PMD[PMAKE_EXPOW_RND]&0x0000001f) << 20 )
			| ( (dpw->PMD[PMAKE_EXDEF_RND]&0x0000001f) << 25 );

	PokeParaSet(
		dpw->PokeMakeData,
		dpw->PMD[PMAKE_NAME],
		dpw->PMD[PMAKE_LEVEL],
		pow_rnd,
		1, dpw->PMD[PMAKE_PERRND],
		1, dpw->PMD[PMAKE_ID] );

	dpw->PMD[ PMAKE_SEX ]      = PokeSexGet( dpw->PokeMakeData );
	dpw->PMD[ PMAKE_PERSONAL ] = PokeSeikakuGet( dpw->PokeMakeData );
	dpw->PMD[ PMAKE_WAZA1 ]    = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza1, NULL );
	dpw->PMD[ PMAKE_WAZA2 ]    = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza2, NULL );
	dpw->PMD[ PMAKE_WAZA3 ]    = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza3, NULL );
	dpw->PMD[ PMAKE_WAZA4 ]    = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza4, NULL );
	dpw->PMD[ PMAKE_EXP ]      = PokeParaGet( dpw->PokeMakeData, ID_PARA_exp, NULL );

	dpw->PMD[ PMAKE_HP ]       = PokeParaGet( dpw->PokeMakeData,ID_PARA_hpmax, NULL );
	dpw->PMD[ PMAKE_POW ]      = PokeParaGet( dpw->PokeMakeData,ID_PARA_pow, NULL );
	dpw->PMD[ PMAKE_DEF ]      = PokeParaGet( dpw->PokeMakeData,ID_PARA_def, NULL );
	dpw->PMD[ PMAKE_AGI ]      = PokeParaGet( dpw->PokeMakeData,ID_PARA_agi, NULL );
	dpw->PMD[ PMAKE_EXPOW ]    = PokeParaGet( dpw->PokeMakeData,ID_PARA_spepow, NULL );
	dpw->PMD[ PMAKE_EXDEF ]    = PokeParaGet( dpw->PokeMakeData,ID_PARA_spedef, NULL );
}

static void PokeMakePokeParaCalcGetExp( PokeMakeWork * dpw )
{
	u32	nulldata;

	nulldata = 0;

	PokeParaPut( dpw->PokeMakeData, ID_PARA_exp, &dpw->PMD[PMAKE_EXP] );
	//ZNA
	PokeParaPut( dpw->PokeMakeData, ID_PARA_waza1, &nulldata );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_waza2, &nulldata );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_waza3, &nulldata );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_waza4, &nulldata );

	PokeParaCalc( dpw->PokeMakeData );
	PokeWazaOboe( dpw->PokeMakeData );

	dpw->PMD[ PMAKE_LEVEL ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_level, NULL );
	dpw->PMD[ PMAKE_WAZA1 ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza1, NULL );
	dpw->PMD[ PMAKE_WAZA2 ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza2, NULL );
	dpw->PMD[ PMAKE_WAZA3 ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza3, NULL );
	dpw->PMD[ PMAKE_WAZA4 ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_waza4, NULL );

	dpw->PMD[ PMAKE_HP ]    = PokeParaGet( dpw->PokeMakeData, ID_PARA_hpmax, NULL );
	dpw->PMD[ PMAKE_POW ]   = PokeParaGet( dpw->PokeMakeData, ID_PARA_pow, NULL );
	dpw->PMD[ PMAKE_DEF ]   = PokeParaGet( dpw->PokeMakeData, ID_PARA_def, NULL );
	dpw->PMD[ PMAKE_AGI ]   = PokeParaGet( dpw->PokeMakeData, ID_PARA_agi, NULL );
	dpw->PMD[ PMAKE_EXPOW ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_spepow, NULL );
	dpw->PMD[ PMAKE_EXDEF ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_spedef, NULL );
}

static void PokeMakePokeParaCalcGetBattleParam( PokeMakeWork * dpw )
{
	PokeParaPut( dpw->PokeMakeData, ID_PARA_hp_rnd, &dpw->PMD[PMAKE_HP_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_hp_exp, &dpw->PMD[PMAKE_HP_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_pow_rnd, &dpw->PMD[PMAKE_POW_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_pow_exp, &dpw->PMD[PMAKE_POW_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_def_rnd, &dpw->PMD[PMAKE_DEF_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_def_exp, &dpw->PMD[PMAKE_DEF_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_agi_rnd, &dpw->PMD[PMAKE_AGI_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_agi_exp, &dpw->PMD[PMAKE_AGI_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spepow_rnd, &dpw->PMD[PMAKE_EXPOW_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spepow_exp, &dpw->PMD[PMAKE_EXPOW_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spedef_rnd, &dpw->PMD[PMAKE_EXDEF_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spedef_exp, &dpw->PMD[PMAKE_EXDEF_EXP] );

	PokeParaCalc( dpw->PokeMakeData );

	dpw->PMD[ PMAKE_HP ]    = PokeParaGet( dpw->PokeMakeData, ID_PARA_hpmax, NULL );
	dpw->PMD[ PMAKE_POW ]   = PokeParaGet( dpw->PokeMakeData, ID_PARA_pow, NULL );
	dpw->PMD[ PMAKE_DEF ]   = PokeParaGet( dpw->PokeMakeData, ID_PARA_def, NULL );
	dpw->PMD[ PMAKE_AGI ]   = PokeParaGet( dpw->PokeMakeData, ID_PARA_agi, NULL );
	dpw->PMD[ PMAKE_EXPOW ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_spepow, NULL );
	dpw->PMD[ PMAKE_EXDEF ] = PokeParaGet( dpw->PokeMakeData, ID_PARA_spedef, NULL );
}

static void PokeMakePokeParaCalcEnd( D_POKEMONMAKE * wk, PokeMakeWork * dpw )
{
	u32	pow_rnd;
	u32	tmp;

	pow_rnd = ( (dpw->PMD[PMAKE_HP_RND]&0x0000001f) << 0 )
			| ( (dpw->PMD[PMAKE_POW_RND]&0x0000001f) << 5 )
			| ( (dpw->PMD[PMAKE_DEF_RND]&0x0000001f) << 10 )
			| ( (dpw->PMD[PMAKE_AGI_RND]&0x0000001f) << 15 )
			| ( (dpw->PMD[PMAKE_EXPOW_RND]&0x0000001f) << 20 )
			| ( (dpw->PMD[PMAKE_EXDEF_RND]&0x0000001f) << 25 );
	
	PokeParaSet(
		dpw->PokeMakeData,
		dpw->PMD[PMAKE_NAME],
		dpw->PMD[PMAKE_LEVEL],
		pow_rnd,
		1, dpw->PMD[PMAKE_PERRND],
		1, dpw->PMD[PMAKE_ID] );

	if( dpw->PMD[PMAKE_WAZA1] ){
//		PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA1], 0 );
		D_PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA1], 0 );

	}
	if( dpw->PMD[PMAKE_WAZA2] ){
//		PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA2], 1 );
		D_PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA2], 1 );
	}
	if( dpw->PMD[PMAKE_WAZA3] ){
//		PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA3], 2 );
		D_PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA3], 2 );
	}
	if( dpw->PMD[PMAKE_WAZA4] ){
//		PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA4], 3 );
		D_PokeWazaSetPos( dpw->PokeMakeData, dpw->PMD[PMAKE_WAZA4], 3 );
	}
	PokeParaPut( dpw->PokeMakeData, ID_PARA_exp, &dpw->PMD[PMAKE_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_hp_rnd, &dpw->PMD[PMAKE_HP_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_hp_exp, &dpw->PMD[PMAKE_HP_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_pow_rnd, &dpw->PMD[PMAKE_POW_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_pow_exp, &dpw->PMD[PMAKE_POW_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_def_rnd, &dpw->PMD[PMAKE_DEF_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_def_exp, &dpw->PMD[PMAKE_DEF_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_agi_rnd, &dpw->PMD[PMAKE_AGI_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_agi_exp, &dpw->PMD[PMAKE_AGI_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spepow_rnd, &dpw->PMD[PMAKE_EXPOW_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spepow_exp, &dpw->PMD[PMAKE_EXPOW_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spedef_rnd, &dpw->PMD[PMAKE_EXDEF_RND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_spedef_exp, &dpw->PMD[PMAKE_EXDEF_EXP] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_style, &dpw->PMD[PMAKE_STYLE] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_beautiful, &dpw->PMD[PMAKE_BEAUTIFUL] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_cute, &dpw->PMD[PMAKE_CUTE] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_clever, &dpw->PMD[PMAKE_CLEVER] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_strong, &dpw->PMD[PMAKE_STRONG] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_fur, &dpw->PMD[PMAKE_FUR] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_friend, &dpw->PMD[PMAKE_FRIEND] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_pokerus, &dpw->PMD[PMAKE_POKERUS] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_item, &dpw->PMD[PMAKE_ITEM] );

//	PokeParaPut( dpw->PokeMakeData, ID_PARA_speabino, &dpw->PMD[PMAKE_SPABI] );
	tmp = PokePersonalParaGet( dpw->PMD[PMAKE_NAME], ID_PER_speabi1+dpw->PMD[PMAKE_SPABI] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_speabino, &tmp );

	PokeParaPut( dpw->PokeMakeData, ID_PARA_event_get_flag, &dpw->PMD[PMAKE_EVGET] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_get_place, &dpw->PMD[PMAKE_GETPLACE] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_get_level, &dpw->PMD[PMAKE_GETLEVEL] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_get_cassette, &dpw->PMD[PMAKE_GETCASSETTE] );
	PokeParaPut( dpw->PokeMakeData, ID_PARA_get_ball, &dpw->PMD[PMAKE_GETBALL] );
	PokeParaPut(
//		dpw->PokeMakeData, ID_PARA_condition, &CondTable[ dpw->PMD[PMAKE_CONDITION] ].setbit );
		dpw->PokeMakeData, ID_PARA_condition, &CondTable[ dpw->PMD[PMAKE_CONDITION] ][1] );

	PokeParaPut( dpw->PokeMakeData, ID_PARA_tamago_flag, &dpw->PMD[PMAKE_TAMAGO] );
	{
		STRBUF * strb;

		// OɁu^}SvZbg
		if( dpw->PMD[PMAKE_TAMAGO] ){
//			PokeParaPut( dpw->PokeMakeData, ID_PARA_nickname, tamago_name );
			strb = MSGMAN_AllocString( wk->mman, msg_pmtname );
			PokeParaPut( dpw->PokeMakeData, ID_PARA_nickname_buf, strb );
			STRBUF_Delete( strb );
		}
		// eɁufobO|PPvZbg
//		PokeParaPut( dpw->PokeMakeData, ID_PARA_oyaname, debug_name );
		strb = MSGMAN_AllocString( wk->mman, msg_pmdname );
		PokeParaPut( dpw->PokeMakeData, ID_PARA_oyaname_buf, strb );
		STRBUF_Delete( strb );
	}

	PokeParaCalc( dpw->PokeMakeData );
}

static void D_PokeWazaSetPos( POKEMON_PARAM * pokeparam, u16 waza, u16 pos )
{
	u8	pp;

	pp = WT_WazaDataParaGet( waza, ID_WTD_pp );
	PokeParaPut( pokeparam, ID_PARA_waza1+pos, &waza );
	PokeParaPut( pokeparam, ID_PARA_pp1+pos, &pp );
}

/********************************************************************/
/*				eڕ\										*/
/*				eڐݒ萧										*/
/********************************************************************/
//\f[^쐬
//static u8 putproc(u8* buf,u8 id,u8 pal)
static u8 putproc( D_POKEMONMAKE * wk, u8 id, u32 pal, u8 y )
{
	PokeMakeWork * dpw;
	u16	i;
	u8	vp,vpl;

	dpw = &wk->pmw;

	if( id == PMAKE_BATTLEPARAM1 ){
		PokeMake_StrPrint( &wk->win, wk->mman, msg_pmlabel_35, 12, y, MSG_NO_PUT, COL_W_GREEN );
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw,
			dpw->PMD[PMAKE_HP], 3, 12+24, y+16, MSG_NO_PUT, COL_W_BLACK );

		PokeMake_StrPrint( &wk->win, wk->mman, msg_pmlabel_36, 12+72, y, MSG_NO_PUT, COL_W_GREEN );
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw,
			dpw->PMD[PMAKE_POW], 3, 12+72+24, y+16, MSG_NO_PUT, COL_W_BLACK );

		PokeMake_StrPrint( &wk->win, wk->mman, msg_pmlabel_37, 12+72+72, y, MSG_NO_PUT, COL_W_GREEN );
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw,
			dpw->PMD[PMAKE_DEF], 3, 12+72+72+24, y+16, MSG_NO_PUT, COL_W_BLACK );
		return 0;
	}
	if(id == PMAKE_BATTLEPARAM2){
		PokeMake_StrPrint( &wk->win, wk->mman, msg_pmlabel_38, 12, y, MSG_NO_PUT, COL_W_GREEN );
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw,
			dpw->PMD[PMAKE_AGI], 3, 12+24, y+16, MSG_NO_PUT, COL_W_BLACK );

		PokeMake_StrPrint( &wk->win, wk->mman, msg_pmlabel_39, 12+72, y, MSG_NO_PUT, COL_W_GREEN );
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw,
			dpw->PMD[PMAKE_EXPOW], 3, 12+72+24, y+16, MSG_NO_PUT, COL_W_BLACK );

		PokeMake_StrPrint( &wk->win, wk->mman, msg_pmlabel_40, 12+72+72, y, MSG_NO_PUT, COL_W_GREEN );
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw,
			dpw->PMD[PMAKE_EXDEF], 3, 12+72+72+24, y+16, MSG_NO_PUT, COL_W_BLACK );
		return 0;
	}

	PokeMake_StrPrint( &wk->win, wk->mman, PMakelabelTable[id].label, 12, y, MSG_NO_PUT, pal );

	vp	= PMakelabelTable[id].cont->count;
	vpl = vp*4;

	switch( id ){
	case PMAKE_NAME:
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw, dpw->PMD[id], vp, 12+72+24, y, MSG_NO_PUT, pal );
		PokeMake_MonsNamePut( &wk->win, dpw->PMD[id], 12+72+24+32, y, MSG_NO_PUT, COL_W_BLACK );
		break;

	case PMAKE_SEX:
		switch(dpw->PMD[id]){
		case 0:	// IX
			PokeMake_StrPrint(
				&wk->win, wk->mman, msg_pmstr_01, 12+72+24, y, MSG_NO_PUT, COL_W_BLACK );
			break;
		case 1:	// X
			PokeMake_StrPrint(
				&wk->win, wk->mman, msg_pmstr_02, 12+72+24, y, MSG_NO_PUT, COL_W_BLACK );
			break;
		case 2:	// Ȃ
			PokeMake_StrPrint(
				&wk->win, wk->mman, msg_pmstr_00, 12+72+24, y, MSG_NO_PUT, COL_W_BLACK );
			break;
		}
		break;

	case PMAKE_WAZA1:
	case PMAKE_WAZA2:
	case PMAKE_WAZA3:
	case PMAKE_WAZA4:
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw, dpw->PMD[id], vp, 12+72+24, y, MSG_NO_PUT, pal );
		WORDSET_RegisterWazaName( wk->wset, 0, dpw->PMD[id] );
		PokeMake_StrPrintExp(
			&wk->win, wk->mman, wk->wset, msg_pmstr_08, 12+72+24+32, y, MSG_NO_PUT, pal );
		break;

	case PMAKE_ITEM:
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw, dpw->PMD[id], vp, 12+72+24, y, MSG_NO_PUT, pal );
		WORDSET_RegisterItemName( wk->wset, 0, dpw->PMD[id] );
		PokeMake_StrPrintExp(
			&wk->win, wk->mman, wk->wset, msg_pmstr_09, 12+72+24+32, y, MSG_NO_PUT, pal );
		break;

	case PMAKE_SPABI:
		WORDSET_RegisterTokuseiName(
			wk->wset, 0, PokePersonalParaGet(dpw->PMD[PMAKE_NAME],ID_PER_speabi1+dpw->PMD[id]) );
		PokeMake_StrPrintExp(
			&wk->win, wk->mman, wk->wset, msg_pmstr_10, 12+72+24, y, MSG_NO_PUT, pal );
		break;

	case PMAKE_CONDITION:
		PokeMake_StrPrint(
			&wk->win, wk->mman, CondTable[dpw->PMD[id]][0], 12+72+24, y, MSG_NO_PUT, COL_W_BLACK );
		break;

	case PMAKE_ID:
	case PMAKE_PERRND:
	case PMAKE_HP_RND:
	case PMAKE_POW_RND:
	case PMAKE_DEF_RND:
	case PMAKE_AGI_RND:
	case PMAKE_EXPOW_RND:
	case PMAKE_EXDEF_RND:
	case PMAKE_LEVEL:
	case PMAKE_HP_EXP:
	case PMAKE_POW_EXP:
	case PMAKE_DEF_EXP:
	case PMAKE_AGI_EXP:
	case PMAKE_EXPOW_EXP:
	case PMAKE_EXDEF_EXP:
	case PMAKE_STYLE:
	case PMAKE_BEAUTIFUL:
	case PMAKE_CUTE:
	case PMAKE_CLEVER:
	case PMAKE_STRONG:
	case PMAKE_FUR:
	case PMAKE_FRIEND:
	case PMAKE_POKERUS:
	case PMAKE_EXP:

	case PMAKE_GETPLACE:
	case PMAKE_GETLEVEL:
	case PMAKE_GETCASSETTE:
	case PMAKE_GETBALL:
		PokeMake_NumPrint(
			&wk->win, wk->mman, wk->wset, dpw, dpw->PMD[id], vp, 12+72+24, y, MSG_NO_PUT, pal );
		break;

	case PMAKE_TAMAGO:
	case PMAKE_EVGET:
		if( dpw->PMD[id] ){
			PokeMake_StrPrint(
				&wk->win, wk->mman, msg_pmstr_04, 12+72+24, y, MSG_NO_PUT, COL_W_BLACK );
		}else{
			PokeMake_StrPrint(
				&wk->win, wk->mman, msg_pmstr_05, 12+72+24, y, MSG_NO_PUT, COL_W_BLACK );
		}
		break;

	case PMAKE_PERSONAL:
		WORDSET_RegisterSeikaku( wk->wset, 0, dpw->PMD[id] );
		PokeMake_StrPrintExp(
			&wk->win, wk->mman, wk->wset, msg_pmstr_11, 12+72+24, y, MSG_NO_PUT, pal );
		break;

	default:
		break;
	}

	return	0;
}

//f[^擾
static u32 getproc( PokeMakeWork * dpw, u8 id )
{
	u32	dat;

	switch( id ){
	default:
		dat	= dpw->PMD[id];
		break;
	}
	return dat;
}

//f[^Zbg
static void setproc( PokeMakeWork * dpw, u32 dat, u8 id )
{
	switch( id ){
	case PMAKE_NAME:
	case PMAKE_PERRND:
	case PMAKE_ID:
		dpw->PMD[id] = dat;
		PokeMakePokeParaCalcInit( dpw );
		break;

	case PMAKE_LEVEL:
		dpw->PMD[id] = dat;
		dpw->PMD[PMAKE_EXP] = PokeLevelExpGet( dpw->PMD[PMAKE_NAME], dat );
		PokeMakePokeParaCalcInit( dpw );
		break;

	case PMAKE_EXP:
		dpw->PMD[id] = dat;
		PokeMakePokeParaCalcGetExp( dpw );
		break;

	case PMAKE_HP_RND:
	case PMAKE_POW_RND:
	case PMAKE_DEF_RND:
	case PMAKE_AGI_RND:
	case PMAKE_EXPOW_RND:
	case PMAKE_EXDEF_RND:
	case PMAKE_HP_EXP:
	case PMAKE_POW_EXP:
	case PMAKE_DEF_EXP:
	case PMAKE_AGI_EXP:
	case PMAKE_EXPOW_EXP:
	case PMAKE_EXDEF_EXP:
		dpw->PMD[id] = dat;
		PokeMakePokeParaCalcGetBattleParam( dpw );
		break;

	default:
		dpw->PMD[id] = dat;
		break;
	}
}


/********************************************************************/
/*				Tu												*/
/********************************************************************/
static const u32 PmakeValueTable[] = {
	1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000
};

static void ValueControl( PokeMakeWork * dpw, u8 mode )
{
	u32	data, datamin, datamax, value;

	data    = getproc( dpw, PageTable[dpw->page_p].page[dpw->cursor_p] );
	datamin = PMakelabelTable[ PageTable[dpw->page_p].page[dpw->cursor_p] ].cont->min;
	datamax = PMakelabelTable[ PageTable[dpw->page_p].page[dpw->cursor_p] ].cont->max;
	value   = PmakeValueTable[ dpw->value_p ];

	switch( PMakelabelTable[ PageTable[dpw->page_p].page[dpw->cursor_p] ].cont->mode ){
	case PMC_INCDEC:
		switch( mode ){
		case PMC_INC:
			if( data < datamax-value ){
				data += value;
			}else{
				if( data < datamax ){
					data = datamax;
				}else{
					data = datamin;
				}
			}
			break;

		case PMC_DEC:
			if( data > datamin+value ){
				data-=value;
			}else{
				if( data > datamin ){
					data = datamin;
				}else{
					data = datamax;
				}
			}
			break;
		}
		break;
	}
	setproc( dpw, data, PageTable[dpw->page_p].page[dpw->cursor_p] );
}

/********************************************************************/
static void CursorPut( D_POKEMONMAKE * wk, u8 mode )
{
	PokeMakeWork * dpw = &wk->pmw;

	switch( mode ){
	case PMC_INIT:
		BMPCURSOR_Print( wk->cursor, &wk->win, 0, dpw->cursor_p*16 );
		GF_BGL_BmpWinOn( &wk->win );
		break;
	case PMC_INC:
		if( dpw->cursor_p < PageTable[dpw->page_p].listcount-1 ){
			GF_BGL_BmpWinFill( &wk->win, 15, 0, dpw->cursor_p*16, 12, 16 );
			dpw->cursor_p++;
			BMPCURSOR_Print( wk->cursor, &wk->win, 0, dpw->cursor_p*16 );
			GF_BGL_BmpWinOn( &wk->win );
		}
		break;
	case PMC_DEC:
		if( dpw->cursor_p > 0 ){
			GF_BGL_BmpWinFill( &wk->win, 15, 0, dpw->cursor_p*16, 12, 16 );
			dpw->cursor_p--;
			BMPCURSOR_Print( wk->cursor, &wk->win, 0, dpw->cursor_p*16 );
			GF_BGL_BmpWinOn( &wk->win );
		}
		break;
	}
}

/********************************************************************/
static void PagePut( D_POKEMONMAKE * wk )
{
	PokeMakeWork * dpw = &wk->pmw;
	u16	i;

	GF_BGL_BmpWinDataFill( &wk->win, 15 );
	i = 0;
	while( PageTable[dpw->page_p].page[i] != 0xff ){
		putproc( wk, PageTable[dpw->page_p].page[i], COL_W_BLACK, i*16 );
		i++;
	}
	GF_BGL_BmpWinCgxOn( &wk->win );
}

/********************************************************************/
static void PageValuePut( D_POKEMONMAKE * wk )
{
	PokeMakeWork * dpw = &wk->pmw;
	u16	i;

	GF_BGL_BmpWinDataFill( &wk->win, 15 );
	i = 0;
	while( PageTable[dpw->page_p].page[i] != 0xff ){
		if(i==dpw->cursor_p){
			putproc( wk, PageTable[dpw->page_p].page[i], COL_W_RED, i*16 );
		}else{
			putproc( wk, PageTable[dpw->page_p].page[i], COL_W_BLACK, i*16 );
		}
		i++;
	}
	GF_BGL_BmpWinCgxOn( &wk->win );
}

/********************************************************************/
static void NumPutBufferSet( PokeMakeWork * dpw, u16 * buf, u8 num, u8 pal, u8 cp )
{
	*buf = C_DCOL_;
	buf++;
	if( pal == COL_W_RED ){
		if( cp == dpw->value_p ){
			*buf = DCOL_BLUE_;
		}else{
			*buf = DCOL_RED_;
		}
	}else{
		*buf = DCOL_BLACK_;
	}
	buf++;
	*buf = n0_ + num;
}
//io[f[^쐬
static void NumPutBuffer( PokeMakeWork * dpw, u16 * buf, u32 num, u8 cnt, u8 pal )
{
	u8	i;

	i = 0;

	switch(cnt){
	default:
	case 10:
		NumPutBufferSet( dpw, &buf[i], num/1000000000, pal, 9 );
		num = num%1000000000;
		i += 3;
	case 9:
		NumPutBufferSet( dpw, &buf[i], num/100000000, pal, 8 );
		num = num%100000000;
		i += 3;
	case 8:
		NumPutBufferSet( dpw, &buf[i], num/10000000, pal, 7 );
		num = num%10000000;
		i += 3;
	case 7:
		NumPutBufferSet( dpw, &buf[i], num/1000000, pal, 6 );
		num = num%1000000;
		i += 3;
	case 6:
		NumPutBufferSet( dpw, &buf[i], num/100000, pal, 5 );
		num = num%100000;
		i += 3;
	case 5:
		NumPutBufferSet( dpw, &buf[i], num/10000, pal, 4 );
		num = num%10000;
		i += 3;
	case 4:
		NumPutBufferSet( dpw, &buf[i], num/1000, pal, 3 );
		num = num%1000;
		i += 3;
	case 3:
		NumPutBufferSet( dpw, &buf[i], num/100, pal, 2 );
		num = num%100;
		i += 3;
	case 2:
		NumPutBufferSet( dpw, &buf[i], num/10, pal, 1 );
		num = num%10;
		i += 3;
	case 1:
		NumPutBufferSet( dpw, &buf[i], num, pal, 0 );
		i += 3;
		buf[i] = EOM_;
	}
}

/********************************************************************/
static void PokeMake_StrPrint(
			GF_BGL_BMPWIN * win, MSGDATA_MANAGER * man, u32 id, u32 x, u32 y, u32 wait, u32 col )
{
	STRBUF * strb;

	strb = MSGMAN_AllocString( man, id );
	GF_STR_PrintColor( win, FONT_SYSTEM, strb, x, y, wait, col, NULL );
	STRBUF_Delete( strb );
}

static void PokeMake_StrPrintExp(
			GF_BGL_BMPWIN * win, MSGDATA_MANAGER * man, WORDSET * wset,
			u32 id, u32 x, u32 y, u32 wait, u32 col )
{
	STRBUF * expb;
	STRBUF * strb;

	expb = STRBUF_Create( 128, HEAPID_BASE_DEBUG );
	strb = MSGMAN_AllocString( man, id );

	WORDSET_ExpandStr( wset, expb, strb );

	GF_STR_PrintColor( win, FONT_SYSTEM, expb, x, y, wait, col, NULL );
	STRBUF_Delete( strb );
	STRBUF_Delete( expb );
}

static void PokeMake_MonsNamePut( GF_BGL_BMPWIN * win, u32 mons, u32 x, u32 y, u32 wait, u32 col )
{
	MSGDATA_MANAGER* man;
	STRBUF * strb;

	man = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_monsname_dat, HEAPID_BASE_DEBUG );

	strb = MSGMAN_AllocString( man, mons );
	GF_STR_PrintColor( win, FONT_SYSTEM, strb, x, y, wait, col, NULL );
	STRBUF_Delete( strb );
	MSGMAN_Delete( man );
}

static u32 NumPutColorGet( PokeMakeWork * dpw, u8 cp, u32 col )
{
	if( col == COL_W_RED ){
		if( cp == dpw->value_p ){
			return COL_W_BLUE;
		}else{
			return COL_W_RED;
		}
	}
	return COL_W_BLACK;
}

//io[f[^쐬
static void PokeMake_NumPrint(
			GF_BGL_BMPWIN * win, MSGDATA_MANAGER * man, WORDSET * wset,
			PokeMakeWork * dpw, u32 num, u32 keta, u32 x, u32 y, u32 wait, u32 col )
{
	STRBUF * expb;
	STRBUF * strb;
	u32	i, tmp, siz;

	expb = STRBUF_Create( 32, HEAPID_BASE_DEBUG );
	strb = MSGMAN_AllocString( man, msg_pmstr_06 );

	tmp = 1;
	for( i=0; i<keta-1; i++ ){
		tmp *= 10;
	}

	siz = 0;
	for( i=keta; i>=1; i-- ){
		WORDSET_RegisterNumber( wset, 0, num/tmp, 1, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
		WORDSET_ExpandStr( wset, expb, strb );
		GF_STR_PrintColor(
			win, FONT_SYSTEM, expb, x+siz, y, MSG_NO_PUT, NumPutColorGet(dpw,i-1,col), NULL );
		num %= tmp;
		tmp /= 10;
		siz += FontProc_GetPrintStrWidth( FONT_SYSTEM, expb, 0 );
	}

	if( wait == MSG_ALLPUT ){
		GF_BGL_BmpWinOn( win );
	}

	STRBUF_Delete( strb );
	STRBUF_Delete( expb );
}
