//==============================================================================================
/**
 * @file	d_nohara.c
 * @brief	fobN\[X
 * @author	Satoshi Nohara
 * @date	2005.07.26
 */
//==============================================================================================
#include "common.h"
#include "system/lib_pack.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/pm_str.h"
#include "system/get_text.h"
#include "system/gamedata.h"				//POKE_NUM_MAX
#include "system/snd_tool.h"

#include "system/savedata.h"
#include "savedata/mystatus.h"
#include "savedata/zukanwork.h"

#include "fld_bgm.h"
#include "poketool/monsno.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "fld_bmp.h"
#include "mapdefine.h"						//ZONE_ID_C01
#include "script.h"							//EventSet_Script
#include "guinness_win.h"					//
#include "ev_mapchange.h"					//

#include "field/sysflag.h"
#include "field/syswork.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_debug_nohara.h"

#include "..\fielddata\script\common_scr_def.h"		//SCRID_TRAINER_MOVE_SCRIPT
#include "..\fielddata\script\connect_def.h"		//SCRID_CONNECT_COLOSSEUM
#include "..\fielddata\script\trainer_def.h"		//SCRID_TANPAN_01
#include "..\fielddata\script\r201_def.h"			//SCRID_R201_FLAG_CHANGE
#include "..\fielddata\script\hiden_def.h"			//SCRID_R201_FLAG_CHANGE
#include "..\fielddata\script\con_reception_def.h"	//


//==============================================================================================
//
//	`
//
//==============================================================================================
#define D_NOHARA_BMPWIN_MAX	(1)				//BMPEBhEf[^ő吔

typedef void (*voidFunc)(void* func);		//֐|C^^


//==============================================================================================
//
//	ϐ
//
//==============================================================================================
static NNSSndCaptureOutputEffectType stereo_mono = NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL;

//static s16 d_buf[ 32*100 ] ATTRIBUTE_ALIGN(32);	//g`i[obt@(̊H)


//==============================================================================================
//
//	vg^Cv錾
//
//==============================================================================================
void DebugNoharaMenuInit( FIELDSYS_WORK* fsys );

static void DebugNoharaMenuMain( TCB_PTR tcb, void * work );
static void TcbBmpDel( TCB_PTR tcb, void * work );
static void BmpDel( TCB_PTR tcb );
static void NumMsgSet( GF_BGL_BMPWIN* win, int num, u8 x, u8 y );

static void D_Nohara_01( TCB_PTR tcb, void * work );
static void D_Nohara_02( TCB_PTR tcb, void * work );
static void D_Nohara_03( TCB_PTR tcb, void * work );
static void D_Nohara_04( TCB_PTR tcb, void * work );
static void D_Nohara_05( TCB_PTR tcb, void * work );
static void D_Nohara_06( TCB_PTR tcb, void * work );
static void D_Nohara_07( TCB_PTR tcb, void * work );
static void D_Nohara_08( TCB_PTR tcb, void * work );
static void D_Nohara_09( TCB_PTR tcb, void * work );
static void D_Nohara_10( TCB_PTR tcb, void * work );
static void D_Nohara_11( TCB_PTR tcb, void * work );
static void D_Nohara_12( TCB_PTR tcb, void * work );
static void D_Nohara_13( TCB_PTR tcb, void * work );
static void D_Nohara_14( TCB_PTR tcb, void * work );
static void D_Nohara_15( TCB_PTR tcb, void * work );
static void D_Nohara_16( TCB_PTR tcb, void * work );
static void D_Nohara_17( TCB_PTR tcb, void * work );
static void D_Nohara_18( TCB_PTR tcb, void * work );
static void D_Nohara_19( TCB_PTR tcb, void * work );
static void D_Nohara_20( TCB_PTR tcb, void * work );
static void D_Nohara_21( TCB_PTR tcb, void * work );
static void D_Nohara_22( TCB_PTR tcb, void * work );
static void D_Nohara_23( TCB_PTR tcb, void * work );


//==============================================================================================
//
//	Xgf[^
//
//==============================================================================================
static const struct{
	u32  str_id;
	u32  param;
}DebugMenuList[] = {
	{ msg_debug_nohara_01, (u32)D_Nohara_01 },
	{ msg_debug_nohara_02, (u32)D_Nohara_02 },
	//{ msg_debug_nohara_03, (u32)D_Nohara_03 },
	{ msg_debug_nohara_04, (u32)D_Nohara_04 },
	{ msg_debug_nohara_05, (u32)D_Nohara_05 },
	{ msg_debug_nohara_06, (u32)D_Nohara_06 },
	{ msg_debug_nohara_07, (u32)D_Nohara_07 },
	{ msg_debug_nohara_08, (u32)D_Nohara_08 },
	//{ msg_debug_nohara_09, (u32)D_Nohara_09 },
	//{ msg_debug_nohara_10, (u32)D_Nohara_10 },
	{ msg_debug_nohara_11, (u32)D_Nohara_11 },
	//{ msg_debug_nohara_12, (u32)D_Nohara_12 },
	//{ msg_debug_nohara_13, (u32)D_Nohara_13 },
	{ msg_debug_nohara_14, (u32)D_Nohara_14 },
	{ msg_debug_nohara_15, (u32)D_Nohara_15 },		//g`eXg
	//{ msg_debug_nohara_16, (u32)D_Nohara_16 },	//CViIis
	{ msg_debug_nohara_17, (u32)D_Nohara_17 },		//obWtOZbg
	{ msg_debug_nohara_17, (u32)D_Nohara_18 },		//BACeXg
	{ msg_debug_nohara_17, (u32)D_Nohara_19 },		//Lv``FbN
	{ msg_debug_nohara_17, (u32)D_Nohara_20 },		//MlXEBhE
	{ msg_debug_nohara_17, (u32)D_Nohara_21 },		//fobNWv
	{ msg_debug_nohara_17, (u32)D_Nohara_22 },		//|Pb`g`eXg
	{ msg_debug_nohara_02, (u32)D_Nohara_23 },		//}ӁAobOVXetOZbg
};

static const BMPLIST_HEADER DebugListH = {
	NULL,					//\f[^|C^

	NULL,					//J[\ړƂ̃R[obN֐
	NULL,					//\Ƃ̃R[obN֐

	NULL,					//GF_BGL_BMPWIÑ|C^

	NELEMS(DebugMenuList),	//Xgڐ
	9,						//\ő區ڐ

	0,						//x\wW
	8,						//ڕ\wW
	0,						//J[\\wW
	0,						//\xW
/*
	FBMP_COL_BLACK,			//F
	FBMP_COL_WHITE,			//wiF
	FBMP_COL_BLK_SDW,		//eF
*/
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						//Ԋuw
	16,						//Ԋux
	BMPLIST_LRKEY_SKIP,		//y[WXLbv^Cv
	FONT_SYSTEM,			//w({ u8 ǁAȂɍȂƎv̂)
	0						//afJ[\(allow)\tO(0:ON,1:OFF)
};


//==============================================================================================
//
//	BMPEBhE
//
//==============================================================================================
enum{
	D_NOHARA_BMPWIN_FRAME	= GF_BGL_FRAME3_M,
	D_NOHARA_BMPWIN_PX1		= 1,
	D_NOHARA_BMPWIN_PY1		= 1,
	D_NOHARA_BMPWIN_SX		= 16,
	D_NOHARA_BMPWIN_SY		= 20,
	D_NOHARA_BMPWIN_PL		= FLD_SYSFONT_PAL,
	D_NOHARA_BMPWIN_CH		= 1,
};

static const BMPWIN_DAT	DebugNoharaWinData = {
	D_NOHARA_BMPWIN_FRAME,					//EChEgpt[
	D_NOHARA_BMPWIN_PX1,D_NOHARA_BMPWIN_PY1,//EChË̍X,YWiLPʂŎwj
	D_NOHARA_BMPWIN_SX,	D_NOHARA_BMPWIN_SY,	//EChËX,YTCYiLPʂŎwj
	D_NOHARA_BMPWIN_PL,						//EChË̃pbgio[	
	D_NOHARA_BMPWIN_CH						//EChEL̈̊JnLN^io[
};


//==============================================================================================
//
//	fobN\
//
//==============================================================================================
typedef struct{
	u8	seq;										//io[
	u8	wave_buf_flag:1;							//g`i[obt@mۂtO
	u8	waveout_flag:1;								//ĐtO
	u8	play_flag:6;								//ĐtO
	s16 work;										//ėp[N

	u16 list_bak;									//XgʒuobNAbv
	u16 cursor_bak;									//J[\ʒuobNAbv

	u32 sel;
	u32 count;										//JE^[
	u32 count2;										//JE^[

	FIELDSYS_WORK* fsys;							//

	GF_BGL_BMPWIN bmpwin[D_NOHARA_BMPWIN_MAX];		//BMPEBhEf[^
	BMPLIST_WORK* lw;								//BMPXgf[^

	BMPLIST_DATA* menulist;							//

//	s16* wave_buf;									//g`i[obt@̃|C^

}D_NOHARA_WORK;


//==============================================================================================
//
//	vO
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	fobNj[Ăяo(fld_debug.c)
 *
 * @param	fsys	FIELDSYS_WORK^̃|C^
 *
 * @retval	none
 */
//--------------------------------------------------------------
void DebugNoharaMenuInit( FIELDSYS_WORK* fsys )
{
	BMPLIST_HEADER list_h;
	D_NOHARA_WORK* wk;

	wk = (D_NOHARA_WORK*)TCB_GetWork( PMDS_taskAdd(DebugNoharaMenuMain, sizeof(D_NOHARA_WORK), 0, HEAPID_BASE_DEBUG) );

	wk->seq				= 0;
	wk->sel				= 0;
	wk->work			= 0;
	wk->wave_buf_flag	= 0;								//g`i[obt@mۂtOOFF
	wk->waveout_flag	= 0;								//ĐtOOFF
	wk->fsys			= fsys;

	GF_BGL_BmpWinAddEx( wk->fsys->bgl, &wk->bmpwin[0], &DebugNoharaWinData );	//rbg}bvǉ

	wk->menulist = BMP_MENULIST_Create( NELEMS(DebugMenuList), HEAPID_BASE_DEBUG );

	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, 
								NARC_msg_debug_nohara_dat, HEAPID_BASE_DEBUG);

		for( i=0; i < NELEMS(DebugMenuList); i++ ){
			BMP_MENULIST_AddArchiveString( wk->menulist, msgman, 
											DebugMenuList[i].str_id, DebugMenuList[i].param );
		}

		MSGMAN_Delete(msgman);
	}

	list_h			= DebugListH;
	list_h.list		= wk->menulist;
	list_h.win		= &wk->bmpwin[0];
	wk->lw			= BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinOn( &wk->bmpwin[0] );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	fobNj[C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void DebugNoharaMenuMain( TCB_PTR tcb, void * work )
{
	u32	ret;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	switch( wk->seq ){
	case 0:
		ret = BmpListMain( wk->lw );

		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			TcbBmpDel( tcb, work );				//TCBBMPJ

			//g`Đp`lJ
			Snd_DebugNormalChannelFree();

			break;
		default:
			wk->sel = ret;
			wk->seq++;
			break;
		};

		//BMPXg̃XgʒuAJ[\ʒu擾
		BmpListPosGet( wk->lw, &wk->list_bak, &wk->cursor_bak );
		break;

	case 1:
		{
			voidFunc func = (voidFunc)wk->sel;
			TCB_ChangeFunc( tcb, (void*)func );	//TCB̓֐؂ւ
		}
		break;

	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	TCB,BMPJ
 *
 * @param	tcb		TCB_PTR^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void TcbBmpDel( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

#if 0
	//g`i[obt@mۂtOON
	if( wk->wave_buf_flag == 1 ){
		sys_FreeMemoryEz( wk->wave_buf );	//obt@J
	}
#endif

	BmpDel( tcb );						//BMPJ
	PMDS_taskDel( tcb );				//TCBJ
	FieldSystemProc_SeqHoldEnd();
	return;
}

//--------------------------------------------------------------
/**
 * @brief	BMPJ
 *
 * @param	tcb		TCB_PTR^
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void BmpDel( TCB_PTR tcb )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)TCB_GetWork(tcb);

	//BMP
	BMP_MENULIST_Delete( wk->menulist );
	BmpListExit( wk->lw, &wk->list_bak, &wk->cursor_bak );
	GF_BGL_BmpWinOff( &wk->bmpwin[0] );
	GF_BGL_BmpWinDel( &wk->bmpwin[0] );
	return;
}

//--------------------------------------------------------------
/**
 * @brief	bZ[W\
 *
 * @param	win_index	rbg}bvINDEX
 * @param	num			l
 * @param	x			\ʒuX
 * @param	y			\ʒuY
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void NumMsgSet( GF_BGL_BMPWIN* win, int num, u8 x, u8 y )
{
	u16 * buf = (u16 *)sys_AllocMemory( HEAPID_BASE_DEBUG, 6 );

	PM_NumMsgSet( buf, num, NUM_MODE_SPACE, 4 );
	GF_MSG_Print( win, FONT_SYSTEM, buf, x, y, MSG_NO_PUT, NULL );
	sys_FreeMemoryEz( buf );
	return;
}


//==============================================================================================
//
//	01	tĐ֘A
//
//==============================================================================================
static void D_Nohara_01_Main( TCB_PTR tcb, void * work );

//extern BOOL Snd_ArcStrmStart( u16 no );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_01( TCB_PTR tcb, void * work )
{
	int i;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= MONSNO_HUSIGIDANE;

	//BGM~߂
	Snd_Stop();

#if 0
	//Xg[Đ
	//Snd_ArcStrmStart( STRM_PV001 );
	Snd_ArcStrmStart( STRM_PV009 );
	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
#endif

#if 0
	//tO`FbN
	OS_Printf( "===============\n " );
	OS_Printf( "===============\n " );
	for( i=0; i < 10 ;i++ ){
		OS_Printf( "flag %d = %d\n ", i ,CheckEventFlag( wk->fsys, i) );
	}
	TcbBmpDel( tcb, work );		//TCBBMPJ
#else
	TCB_ChangeFunc( tcb, D_Nohara_01_Main );	//TCB̓֐؂ւ
#endif
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_01_Main( TCB_PTR tcb, void * work )
{
	int ret,flag;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	flag = 0;	//tO

	if( wk->waveout_flag == 0 ){					//ĐtOOFF

		//Đ
		if( sys.trg == PAD_BUTTON_A ){
			wk->waveout_flag = 1;					//ĐtOON
			return;		//ӁI
		}

		if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
			flag = 1;
			wk->work++;
			if( wk->work >= POKE_NUM_MAX ){
				wk->work = 1;
			}
		}

		if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
			flag = 1;
			wk->work--;
			if( wk->work <= 0 ){
				wk->work = (POKE_NUM_MAX - 1);
			}
		}

		//tOĂ
		if( flag == 1 ){
			//w͈͂hԂ
			GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*11, 0, 8*6, 8*2 );
	
			//|Pio[\
			NumMsgSet( &wk->bmpwin[0], wk->work, 8*11, 2 );
			GF_BGL_BmpWinOn( &wk->bmpwin[0] );
		}

		//I
		if( sys.cont == PAD_BUTTON_B ){
			TcbBmpDel( tcb, work );				//TCBBMPJ
		}

		return;	//ӁI
	}


	switch( wk->seq ){
	case 0:
		ret = Snd_PMVoicePlay( wk->work );		//ʏĐ
		//OS_Printf( "normal play = %d\n", ret );
		wk->seq++;
		break;
	case 1:
		if( Snd_PMVoicePlayCheck() == 0 ){
			wk->count = 0;
			wk->seq++;
		}
		break;
	case 2:
		wk->count++;
		if( wk->count >= 15 ){							//Ԃ
			Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );//g`Đp`lmۂ
			ret = Snd_WaveOutStartReverse( wk->work, 60, 64, WAVEOUT_CH_NORMAL, 
											HEAPID_BASE_DEBUG );//tĐ
			//OS_Printf( "reverse play = %d\n", ret );
			wk->count = 0;
			wk->seq++;
		}
		break;
	case 3:
		//g`Đ`FbN
		if( Snd_WaveOutIsPlaying( WAVEOUT_CH_NORMAL ) == FALSE ){
			Snd_WaveOutStopReverse( WAVEOUT_CH_NORMAL );//tĐ~bufJ
			Snd_WaveOutFreeChannel( WAVEOUT_CH_NORMAL );//g`Đp`lJ
			wk->seq = 0;
			wk->count = 0;
			wk->waveout_flag = 0;				//ĐtOOFF
		}
		break;
	};

	return;
}


//==============================================================================================
//
//	02	o[u֘A
//
//==============================================================================================
static void D_Nohara_02_Main( TCB_PTR tcb, void * work );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_02( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= 0;
	TCB_ChangeFunc( tcb, D_Nohara_02_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_02_Main( TCB_PTR tcb, void * work )
{
	int flag;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	flag = 0;	//tO

	if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
		flag = 1;
		wk->work++;
		if( wk->work >= 64 ){
			wk->work = 0;
		}
	}

	if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
		flag = 1;
		wk->work--;
		if( wk->work < 0 ){
			wk->work = 63;
		}
	}

	//tOĂ
	if( flag == 1 ){
		if( Snd_CaptureStartReverb( wk->work ) == FALSE ){
			OS_Printf( "o[usI\n" );
		}
	
		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*7, 8*2, 
								8*8, 8*2 );
	
		//o[ul\
		NumMsgSet( &wk->bmpwin[0], wk->work, 8*7, 8*2 );
		GF_BGL_BmpWinOn( &wk->bmpwin[0] );
	}

	//I
	if( sys.cont == PAD_BUTTON_B ){
		TcbBmpDel( tcb, work );		//TCBBMPJ
	}

	return;
}


//==============================================================================================
//
//	03	gbNtF[h֘A
//
//==============================================================================================
static void D_Nohara_03_Main( TCB_PTR tcb, void * work );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_03( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= 0;
	TCB_ChangeFunc( tcb, D_Nohara_03_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_03_Main( TCB_PTR tcb, void * work )
{
	int ret;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	switch( wk->seq ){
	case 0:
		ret = Snd_TrackFadeCall(wk->fsys, Snd_FieldBgmNoGet(wk->fsys,wk->fsys->location->zone_id));	
		//OS_Printf( "track fade moon = %d\n", ret );
		wk->count	= 0;
		wk->seq++;
		break;
	case 1:
		wk->count++;
		if( wk->count >= 300 ){
			wk->count = 0;
			wk->seq++;
		}
		break;
	case 2:
		ret = Snd_TrackFadeCall(wk->fsys, Snd_FieldBgmNoGet(wk->fsys,wk->fsys->location->zone_id));
		//OS_Printf( "track fade night = %d\n", ret );
		wk->count	= 0;
		wk->seq++;
		break;
	case 3:
		wk->count++;
		if( wk->count >= 200 ){
			TcbBmpDel( tcb, work );		//TCBBMPJ
		}
		break;
	};

	return;
}


//==============================================================================================
//
//	04	FIELD BGM ʊ֘A
//
//==============================================================================================
static void D_Nohara_04_Main( TCB_PTR tcb, void * work );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_04( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= 0;
	TCB_ChangeFunc( tcb, D_Nohara_04_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_04_Main( TCB_PTR tcb, void * work )
{
	int flag;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	flag = 0;	//tO

	if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
		flag = 1;
		wk->work++;
		if( wk->work >= 128 ){
			wk->work = 0;
		}
	}

	if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
		flag = 1;
		wk->work--;
		if( wk->work < 0 ){
			wk->work = 127;
		}
	}

	//tOĂ
	if( flag == 1 ){
		Snd_PlayerSetInitialVolume( SND_HANDLE_FIELD, wk->work );
	
		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*11, 8*6, 8*8, 8*2 );
	
		//ʕ\
		NumMsgSet( &wk->bmpwin[0], wk->work, 8*11, 8*6 );
		GF_BGL_BmpWinOn( &wk->bmpwin[0] );
	}

	//I
	if( sys.cont == PAD_BUTTON_B ){
		TcbBmpDel( tcb, work );		//TCBBMPJ
	}

	return;
}


//==============================================================================================
//
//	05	p^[֘A
//
//==============================================================================================
static void D_Nohara_05_Main( TCB_PTR tcb, void * work );

static const struct{
	u32  str_id;
	u32  param;
}DebugMenuList05[] = {
	{ msg_debug_nohara_05_01, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_02, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_03, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_04, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_05, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_06, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_07, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_08, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_09, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_10, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_11, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_12, (u32)D_Nohara_05_Main },
	{ msg_debug_nohara_05_13, (u32)D_Nohara_05_Main },
};

static const BMPLIST_HEADER ListH05 = {
	NULL,					//\f[^|C^
	NULL,					//J[\ړƂ̃R[obN֐
	NULL,					//\Ƃ̃R[obN֐

	NULL,					//GF_BGL_BMPWIÑ|C^

	NELEMS(DebugMenuList05),//Xgڐ
	9,						//\ő區ڐ

	0,						//x\wW
	8,						//ڕ\wW
	0,						//J[\\wW
	0,						//\xW
/*
	FBMP_COL_BLACK,			//F
	FBMP_COL_WHITE,			//wiF
	FBMP_COL_BLK_SDW,		//eF
*/
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						//Ԋuw
	16,						//Ԋux
	BMPLIST_LRKEY_SKIP,		//y[WXLbv^Cv
	FONT_SYSTEM,			//w({ u8 ǁAȂɍȂƎv̂)
	0						//afJ[\(allow)\tO(0:ON,1:OFF)
};

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_05( TCB_PTR tcb, void * work )
{
	BMPLIST_HEADER list_h;
	GF_BGL_BMPWIN* win;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	BmpDel( tcb );								//BMPJ

	wk->seq		= 0;
	wk->sel		= 0;
	wk->count	= 0;

	GF_BGL_BmpWinAddEx( wk->fsys->bgl, &wk->bmpwin[0], &DebugNoharaWinData );	//rbg}bvǉ

	wk->menulist = BMP_MENULIST_Create( NELEMS(DebugMenuList05), HEAPID_BASE_DEBUG );

	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, 
								NARC_msg_debug_nohara_dat, HEAPID_BASE_DEBUG);

		for( i=0; i < NELEMS(DebugMenuList05); i++ ){
			BMP_MENULIST_AddArchiveString( wk->menulist, msgman, 
											DebugMenuList05[i].str_id, DebugMenuList05[i].param );
		}

		MSGMAN_Delete(msgman);
	}

	list_h			= ListH05;
	list_h.list		= wk->menulist;
	list_h.win		= &wk->bmpwin[0];
	wk->lw			= BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinOn( &wk->bmpwin[0] );

	//TCB_ChangeFunc( tcb, D_Nohara_05_Main );	//TCB̓֐؂ւ
	TCB_ChangeFunc( tcb, DebugNoharaMenuMain );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_05_Main( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	//|Pp^[Zbg
	//monsno,pan,vol,ptn
	Snd_PMVoicePlayEx( (wk->cursor_bak+wk->list_bak),
						//MONSNO_HUSIGIDANE, 64, 127, 
						MONSNO_HUSIGIDANE, (gf_rand() % 127), 127, 
						HEAPID_BASE_DEBUG ); 

	wk->seq = 0;
	TCB_ChangeFunc( tcb, DebugNoharaMenuMain );		//TCB̓֐؂ւ
	return;
}


//==============================================================================================
//
//	06	o̓GtFNg֘A
//
//==============================================================================================
static void D_Nohara_06_Main( TCB_PTR tcb, void * work );

static const struct{
	u32  str_id;
	u32  param;
}DebugMenuList06[] = {
	{ msg_debug_nohara_06_01, (u32)D_Nohara_06_Main },
	{ msg_debug_nohara_06_02, (u32)D_Nohara_06_Main },
	{ msg_debug_nohara_06_03, (u32)D_Nohara_06_Main },
	{ msg_debug_nohara_06_04, (u32)D_Nohara_06_Main },
};

static const BMPLIST_HEADER ListH06 = {
	NULL,					//\f[^|C^
	NULL,					//J[\ړƂ̃R[obN֐
	NULL,					//\Ƃ̃R[obN֐

	NULL,					//GF_BGL_BMPWIÑ|C^

	NELEMS(DebugMenuList06),//Xgڐ
	5,						//\ő區ڐ

	0,						//x\wW
	8,						//ڕ\wW
	0,						//J[\\wW
	0,						//\xW
/*
	FBMP_COL_BLACK,			//F
	FBMP_COL_WHITE,			//wiF
	FBMP_COL_BLK_SDW,		//eF
*/
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						//Ԋuw
	16,						//Ԋux
	BMPLIST_LRKEY_SKIP,		//y[WXLbv^Cv
	FONT_SYSTEM,			//w({ u8 ǁAȂɍȂƎv̂)
	0						//afJ[\(allow)\tO(0:ON,1:OFF)
};

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_06( TCB_PTR tcb, void * work )
{
	BMPLIST_HEADER list_h;
	GF_BGL_BMPWIN* win;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	BmpDel( tcb );								//BMPJ

	//Snd_CaptureCreateThread();

	wk->seq		= 0;
	wk->sel		= 0;
	wk->count	= 0;

	GF_BGL_BmpWinAddEx( wk->fsys->bgl, &wk->bmpwin[0], &DebugNoharaWinData );	//rbg}bvǉ

	wk->menulist = BMP_MENULIST_Create( NELEMS(DebugMenuList06), HEAPID_BASE_DEBUG );

	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, 
								NARC_msg_debug_nohara_dat, HEAPID_BASE_DEBUG);

		for( i=0; i < NELEMS(DebugMenuList06); i++ ){
			BMP_MENULIST_AddArchiveString( wk->menulist, msgman, 
											DebugMenuList06[i].str_id, DebugMenuList06[i].param );
		}

		MSGMAN_Delete(msgman);
	}

	list_h			= ListH06;
	list_h.list		= wk->menulist;
	list_h.win		= &wk->bmpwin[0];
	wk->lw			= BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinOn( &wk->bmpwin[0] );

	//TCB_ChangeFunc( tcb, D_Nohara_06_Main );	//TCB̓֐؂ւ
	TCB_ChangeFunc( tcb, DebugNoharaMenuMain );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_06_Main( TCB_PTR tcb, void * work )
{
	NNSSndCaptureOutputEffectType stereo_mono;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	switch( wk->cursor_bak ){
	case 1:
		stereo_mono = NNS_SND_CAPTURE_OUTPUT_EFFECT_MONO;
		break;
	case 2:
		stereo_mono = NNS_SND_CAPTURE_OUTPUT_EFFECT_SURROUND;
		break;
	case 3:
		stereo_mono = NNS_SND_CAPTURE_OUTPUT_EFFECT_HEADPHONE;
		break;
	default:
		stereo_mono = NNS_SND_CAPTURE_OUTPUT_EFFECT_NORMAL;
		break;
	}

	Snd_CaptureStartOutputEffect( stereo_mono );
	//Snd_CaptureChangeOutputEffect( stereo_mono );

	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}


//==============================================================================================
//
//	07	}CN֘A
//
//==============================================================================================
static void D_Nohara_07_Main( TCB_PTR tcb, void * work );

static const struct{
	u32  str_id;
	u32  param;
}DebugMenuList07[] = {
	{ msg_debug_nohara_07_01, (u32)D_Nohara_07_Main },
	{ msg_debug_nohara_07_02, (u32)D_Nohara_07_Main },
	{ msg_debug_nohara_07_03, (u32)D_Nohara_07_Main },
	{ msg_debug_nohara_07_04, (u32)D_Nohara_07_Main },
};

static const BMPLIST_HEADER ListH07 = {
	NULL,					//\f[^|C^
	NULL,					//J[\ړƂ̃R[obN֐
	NULL,					//\Ƃ̃R[obN֐

	NULL,					//GF_BGL_BMPWIÑ|C^

	NELEMS(DebugMenuList07),//Xgڐ
	5,						//\ő區ڐ

	0,						//x\wW
	8,						//ڕ\wW
	0,						//J[\\wW
	0,						//\xW
/*
	FBMP_COL_BLACK,			//F
	FBMP_COL_WHITE,			//wiF
	FBMP_COL_BLK_SDW,		//eF
*/
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						//Ԋuw
	16,						//Ԋux
	BMPLIST_LRKEY_SKIP,		//y[WXLbv^Cv
	FONT_SYSTEM,			//w({ u8 ǁAȂɍȂƎv̂)
	0						//afJ[\(allow)\tO(0:ON,1:OFF)
};

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_07( TCB_PTR tcb, void * work )
{
	BMPLIST_HEADER list_h;
	GF_BGL_BMPWIN* win;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	BmpDel( tcb );								//BMPJ

#if 0
	//obt@m
	wk->wave_buf = sys_AllocMemory( HEAPID_BASE_DEBUG, WAVE_SAMPLE );
	if( wk->wave_buf == NULL ){
		GF_ASSERT( (0) && "mۂɎs܂I" );
	}
	memset( wk->wave_buf, 0, WAVE_SAMPLE );
#endif

	//g`Đp`lmۂ
	Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );

	wk->seq				= 0;
	wk->sel				= 0;
	wk->count			= 0;
	wk->wave_buf_flag	= 1;					//g`i[obt@mۂtOON

	GF_BGL_BmpWinAddEx( wk->fsys->bgl, &wk->bmpwin[0], &DebugNoharaWinData );	//rbg}bvǉ

	wk->menulist = BMP_MENULIST_Create( NELEMS(DebugMenuList07), HEAPID_BASE_DEBUG );

	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, 
								NARC_msg_debug_nohara_dat, HEAPID_BASE_DEBUG);

		for( i=0; i < NELEMS(DebugMenuList07); i++ ){
			BMP_MENULIST_AddArchiveString( wk->menulist, msgman, 
											DebugMenuList07[i].str_id, DebugMenuList07[i].param );
		}

		MSGMAN_Delete(msgman);
	}

	list_h			= ListH07;
	list_h.list		= wk->menulist;
	list_h.win		= &wk->bmpwin[0];
	wk->lw			= BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinOn( &wk->bmpwin[0] );

	//TCB_ChangeFunc( tcb, D_Nohara_07_Main );	//TCB̓֐؂ւ
	TCB_ChangeFunc( tcb, DebugNoharaMenuMain );	//TCB̓֐؂ւ
	return;
}
 

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_07_Main( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	switch( wk->cursor_bak ){
	case 0:
		{
			MICAutoParam mic;	//}CNp[^

			mic.type			= MIC_SAMPLING_TYPE_SIGNED_12BIT;
#if 0
			//mic.buffer		= wk->wave_buf;
			//mic.size			= sizeof( wk->wave_buf );
			//mic.buffer		= wk->d_buf;
			//mic.size			= sizeof( wk->d_buf );
			//mic.buffer		= d_buf;
			//mic.size			= sizeof( d_buf );
#else
			//obt@32oCgACꂽAhXłȂƃ_I
			mic.buffer			= Snd_GetDebugWaveBufAdrs();
			mic.size			= (WAVE_SAMPLE);
#endif

			//32̔{ɂȂ悤ɃTCY𒲐
			if( (mic.size&0x1f) != 0 ){
				mic.size &= 0xffffffe0;
			}

			//\IȃTvO[gARM7̃^C}[ɊZl̒`
			mic.rate			= MIC_SAMPLING_RATE_16K;

			//ATvOɃobt@[vtO
			mic.loop_enable		= FALSE;

			//obt@OaۂɌĂяoR[obN֐ւ̃|C^
			mic.full_callback	= NULL;

			//obt@OaۂɌĂяoR[obN֐֓n
			mic.full_arg		= NULL;

			Snd_MicStartAutoSampling( &mic );				//^Jn
		}
		break;

	case 1:
		Snd_MicStopAutoSampling();					//^~
		break;

	case 2:
		{
			WAVEOUT_WORK waveout_wk;

			waveout_wk.handle			= Snd_WaveOutHandleGet(WAVEOUT_CH_NORMAL);//g`Đnh
			waveout_wk.format			= NNS_SND_WAVE_FORMAT_PCM16;//g`f[^tH[}bg
			//waveout_wk.dataaddr		= wk->wave_buf;				//g`f[^̐擪AhX
			waveout_wk.dataaddr			= Snd_GetDebugWaveBufAdrs();//g`f[^̐擪AhX
			waveout_wk.loopFlag			= FALSE;					//[vtO
			waveout_wk.loopStartSample	= 0;						//[vJnTvʒu
			waveout_wk.samples			= WAVE_SAMPLE;				//g`f[^̃Tv
			waveout_wk.sampleRate		= 16000;					//g`f[^̃TvO[g
			waveout_wk.volume			= 127;						//
			waveout_wk.speed			= 32768;					//ĐXs[h
			waveout_wk.pan				= 64;						//p(0-127)

			Snd_WaveOutStart( &waveout_wk );		//g`Đ
		}
		break;

	default:
		Snd_WaveOutStop( WAVEOUT_CH_NORMAL );		//g`~
		break;
	};

	wk->seq = 0;
	TCB_ChangeFunc( tcb, DebugNoharaMenuMain );		//TCB̓֐؂ւ
	return;
}


//==============================================================================================
//
//	08	FIELD TEMPO ʊ֘A
//
//==============================================================================================
static void D_Nohara_08_Main( TCB_PTR tcb, void * work );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_08( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= 256;
	TCB_ChangeFunc( tcb, D_Nohara_08_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_08_Main( TCB_PTR tcb, void * work )
{
	int flag;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	flag = 0;	//tO

	if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
		flag = 1;
		wk->work++;
		if( wk->work >= 512 ){
			wk->work = 64;
		}
	}

	if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
		flag = 1;
		wk->work--;
		if( wk->work < 64 ){
			wk->work = 512;
		}
	}

	//tOĂ
	if( flag == 1 ){
		Snd_PlayerSetTempoRatio( SND_HANDLE_FIELD, wk->work );
	
		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*11, 8*14, 8*8, 8*2 );
	
		//e|\
		NumMsgSet( &wk->bmpwin[0], wk->work, 8*11, 8*14 );
		GF_BGL_BmpWinOn( &wk->bmpwin[0] );
	}

	//I
	if( sys.cont == PAD_BUTTON_B ){
		TcbBmpDel( tcb, work );		//TCBBMPJ
	}

	return;
}


//==============================================================================================
//
//	09	XNvg֘A
//
//==============================================================================================
static void D_Nohara_09_Main( TCB_PTR tcb, void * work );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_09( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	EventSet_Script( wk->fsys, SCRID_TRAINER_MOVE_SCRIPT, NULL );

	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}


//==============================================================================================
//
//	10	gbNtF[htO
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_10( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	//؂ւ
	//debug_track_fade_flag = 1;

	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}


//==============================================================================================
//
//	11	ʐMogXNvgĂяo
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_11( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	//bΏOBJ̃|C^"NULL"Ȃ̂ŒӁI
	//EventSet_Script( wk->fsys, SCRID_CONNECT_COLOSSEUM, NULL );

	//EventSet_Script( wk->fsys, SCRID_PC_ON, NULL );
	//EventSet_Script( wk->fsys, SCRID_HIDEN_NAMINORI, NULL );
	//EventSet_Script( wk->fsys, SCRID_HIDEN_KABENOBORI, NULL );

	//Q[JnXNvg
	//GameStartScriptInit( wk->fsys );
	
	//ReXg
	EventSet_Script( wk->fsys, SCRID_CON_RECEPTION_FRONT01, NULL );
	
	//EventSet_Script( wk->fsys, SCRID_CONNECT_UNION, NULL );
	//EventSet_Script( wk->fsys, SCRID_CONNECT_RECORD, NULL );

	//EventSet_Script( wk->fsys, SCRID_REPORT, NULL );
#if 0	//060216 error̈ז(Ƃj
	EventSet_Script( wk->fsys, SCRID_UNION_CHARACTER_SELECT, NULL );
#endif	
	//EventSet_Script( wk->fsys, SCRID_TEST_OP, NULL );
	
	//EventSet_Script( wk->fsys, SCRID_TANPAN_01, NULL );
	
	//SpScriptStart( wk->fsys, SCRID_R201_FLAG_CHANGE );
	
	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}


//==============================================================================================
//
//	12	
//
//==============================================================================================
static void D_Nohara_12_Main( TCB_PTR tcb, void * work );

#define D_NOHARA_12_PITCH_MAX	(128)					//64ŔAS128
#define D_NOHARA_12_PTN_MAX		(5)						//p^[
#define D_NOHARA_12_SEQ_NO		(SEQ_SE_DP_BADGE_C)		//V[PXio[
#define D_NOHARA_12_WAIT		(30)					//EFCg

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_12( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->count2	= 0;
	wk->work	= 0;

	Snd_BgmFadeOut( BGM_VOL_ZUKAN, BGM_FADE_ZUKAN_TIME );

	TCB_ChangeFunc( tcb, D_Nohara_12_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_12_Main( TCB_PTR tcb, void * work )
{
#if 0
	int ret,flag,pitch,i;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	//tF[hI҂
	if( Snd_FadeCheck() != 0 ){
		return; //Ȃ
	}

	flag = 0;	//tO

	if( wk->play_flag == 0 ){						//ĐtOOFF

		//Đ
		if( sys.trg == PAD_BUTTON_A ){
			wk->play_flag = 1;					//ĐtOON
			return;		//ӁI
		}

		if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
			flag = 1;
			wk->work++;
			if( wk->work >= D_NOHARA_12_PITCH_MAX ){
				wk->work = 0;
			}
		}

		if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
			flag = 1;
			if( wk->work <= 0 ){
				wk->work = D_NOHARA_12_PITCH_MAX;
			}
			wk->work--;
		}

		//tOĂ
		if( flag == 1 ){
			//w͈͂hԂ
			GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*11, 0, 8*6, 8*2 );
	
			//|Pio[\
			NumMsgSet( &wk->bmpwin[0], wk->work, 8*11, 2 );
			GF_BGL_BmpWinOn( &wk->bmpwin[0] );
		}

		//I
		if( sys.cont == PAD_BUTTON_B ){
			Snd_BgmFadeIn( BGM_VOL_MAX, 0, BGM_FADEIN_START_VOL_NOW );
			TcbBmpDel( tcb, work );				//TCBBMPJ
		}

		return;	//ӁI
	}

	switch( wk->seq ){
	case 0:
		Snd_SePlay( D_NOHARA_12_SEQ_NO );

		//Ō̉́A𗐂Ȃ
		if( wk->count < 4 ){
			//wk->work							= ωől
			//wk->work / D_NOHARA_12_PTN_MAX	= ω1̒l
			//D_NOHARA_12_PTN_MAX - wk->count	= p^[ڂ(DEBUG_PTN_MAXɋ߂قǗĂ)
			pitch = ( (wk->work/D_NOHARA_12_PTN_MAX) * (D_NOHARA_12_PTN_MAX-wk->count) );

			//vC[܂ĂȂ̂ŁASSEvC[ɑ΂đ삷
			for( i=0; i < SE_HANDLE_MAX ;i++ ){
				Snd_PlayerSetTrackPitch( SND_HANDLE_SE_1+i, 0xffff, pitch );
			}
		}

		wk->count2 = 0;							//EFCgJE^[NA
		wk->seq++;
		break;
	case 1:
		if( Snd_SePlayCheck( D_NOHARA_12_SEQ_NO ) == 0 ){

			//EFCg`FbN
			wk->count2++;
			if( wk->count2 < D_NOHARA_12_WAIT ){
				return;
			}

			wk->count++;						//p^[CNg
			wk->seq = 0;						//V[PX߂

			if( wk->count >= D_NOHARA_12_PTN_MAX ){
				wk->seq = 0;
				wk->count = 0;
				wk->play_flag = 0;				//ĐtOOFF
			}
		}
		break;
	};
#endif

	return;
}


//==============================================================================================
//
//	13	2
//
//==============================================================================================
static void D_Nohara_13_Main( TCB_PTR tcb, void * work );

#define D_NOHARA_13_SEQ_NO		(SEQ_SE_DP_BADGE_C)		//V[PXio[
#define D_NOHARA_13_WAIT		(1)//(5)//(10)//(30)					//EFCg

//̒iK
enum{
	P_0 = 0,			//̂Ȃ
	P_1 = 16,			//
	P_2 = 32,			//
	P_3 = 64,			//
	P_4 = 96,			//
};

//{
enum{
	P_C = 0,			//C
	P_D = (64*2),		//D
	P_E = (64*4),		//E
	P_F = (64*5),		//F
	P_G = (64*7),		//G
	P_A = (64*9),		//A
	P_B = (64*11),		//B
	PCC = (64*12),		//C
};

//e[u
static const u16 pitch_tbl[][8] = {
	{ P_C, P_D,	P_E, P_F, P_G, P_A, P_B, PCC },							//Ȃ
	{ P_C+P_3, P_D, P_E+P_2, P_F, P_G+P_3, P_A+P_2, P_B+P_4, PCC },		//傫
	{ P_C+P_1, P_D, P_E+P_1, P_F, P_G+P_1, P_A+P_1, P_B+P_1, PCC+P_1 },	//
};
#define D_NOHARA_13_PITCH_TBL_MAX	( NELEMS(pitch_tbl) )

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_13( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->count2	= 0;
	wk->work	= 0;

	Snd_BgmFadeOut( BGM_VOL_ZUKAN, BGM_FADE_ZUKAN_TIME );

	TCB_ChangeFunc( tcb, D_Nohara_13_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_13_Main( TCB_PTR tcb, void * work )
{
#if 0
	int ret,flag,pitch,i;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	//tF[hI҂
	if( Snd_FadeCheck() != 0 ){
		return; //Ȃ
	}

	flag = 0;	//tO

	if( wk->play_flag == 0 ){						//ĐtOOFF

		//Đ
		if( sys.trg == PAD_BUTTON_A ){
			wk->play_flag = 1;					//ĐtOON
			return;		//ӁI
		}

		if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
			flag = 1;
			wk->work++;
			if( wk->work >= D_NOHARA_13_PITCH_TBL_MAX ){
				wk->work = 0;
			}
		}

		if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
			flag = 1;
			if( wk->work <= 0 ){
				wk->work = D_NOHARA_13_PITCH_TBL_MAX;
			}
			wk->work--;
		}

		//tOĂ
		if( flag == 1 ){
			//w͈͂hԂ
			GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*11, 0, 8*6, 8*2 );
	
			//|Pio[\
			NumMsgSet( &wk->bmpwin[0], wk->work, 8*11, 2 );
			GF_BGL_BmpWinOn( &wk->bmpwin[0] );
		}

		//I
		if( sys.cont == PAD_BUTTON_B ){
			Snd_BgmFadeIn( BGM_VOL_MAX, 0, BGM_FADEIN_START_VOL_NOW );
			TcbBmpDel( tcb, work );				//TCBBMPJ
		}

		return;	//ӁI
	}

	switch( wk->seq ){
	case 0:
		//if( Snd_SePlayCheck( D_NOHARA_13_SEQ_NO ) == 0 ){

			//ȍĐI
			//ĐnhAvC[𑀍삵ĂI
			//Snd_SePlay( D_NOHARA_13_SEQ_NO );
			Snd_ArcPlayerStartSeqEx( SND_HANDLE_SE_1+(wk->count&0x3), 
										PLAYER_SE_1+(wk->count&0x3), D_NOHARA_13_SEQ_NO );

			//vC[܂ĂȂ̂ŁASSEvC[ɑ΂đ삷
			for( i=0; i < SE_HANDLE_MAX ;i++ ){
				Snd_PlayerSetTrackPitch( SND_HANDLE_SE_1+i, 0xffff,pitch_tbl[wk->work][wk->count] );
			}

			wk->count2 = 0;								//EFCgJE^[NA
			wk->count++;
			wk->seq++;

			if( wk->count >= 8 ){
				wk->seq = 0;
				wk->count = 0;
				wk->play_flag = 0;						//ĐtOOFF
				return;
			}
		//}
		break;
	case 1:
		//EFCg`FbN
		wk->count2++;
		if( wk->count2 < D_NOHARA_13_WAIT ){
			return;
		}

		wk->count2 = 0;									//EFCgJE^[NA
		wk->seq = 0;									//V[PX߂
		break;
	};

#endif
	return;
}


//==============================================================================================
//
//	14	TEhGtFNg
//
//==============================================================================================
static void D_Nohara_14_Main( TCB_PTR tcb, void * work );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_14( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->count2	= 0;
	wk->work	= 0;
	Snd_CaptureStartEffect();
	TCB_ChangeFunc( tcb, D_Nohara_14_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_14_Main( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	int flag = 0;

	wk = (D_NOHARA_WORK*)work;

	//Đ
	//if( sys.trg == PAD_BUTTON_A ){
	//	Snd_CaptureStartEffect();
	//	return;
	//}
	
	if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
		flag = 1;
		wk->work++;
		if( wk->work > 8 ){
			wk->work = 8;
		}
	}

	if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
		flag = 1;
		wk->work--;
		if( wk->work < 0 ){
			wk->work = 0;
		}
	}

	//tOĂ
	if( flag == 1 ){
		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*11, 0, 8*6, 8*2 );

		//|Pio[\
		NumMsgSet( &wk->bmpwin[0], wk->work, 8*11, 2 );
		GF_BGL_BmpWinOn( &wk->bmpwin[0] );

		//GtFNgxZbg
		Snd_CaptureEffectLevel( wk->work );
	}

	//~AI
	if( sys.cont == PAD_BUTTON_B ){
		Snd_CaptureStopEffect();
		TcbBmpDel( tcb, work );				//TCBBMPJ
		return;
	}

	return;
}


//==============================================================================================
//
//	15	g`֘A
//
//==============================================================================================
static void D_Nohara_15_Main( TCB_PTR tcb, void * work );

u32 now_tick;									//݂̃eBbN

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_15( TCB_PTR tcb, void * work )
{
	int i;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= MONSNO_HUSIGIDANE;
	TCB_ChangeFunc( tcb, D_Nohara_15_Main );	//TCB̓֐؂ւ
	return;
}

u8 test_buf[9];	//
const SNDWaveData* pw_data;
//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_15_Main( TCB_PTR tcb, void * work )
{
	int ret,flag,i;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	flag = 0;	//tO

	if( wk->waveout_flag == 0 ){					//ĐtOOFF

		//Đ
		if( sys.trg == PAD_BUTTON_A ){
			wk->waveout_flag = 1;					//ĐtOON
			return;		//ӁI
		}

		if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
			flag = 1;
			wk->work++;
			if( wk->work >= POKE_NUM_MAX ){
				wk->work = 1;
			}
		}

		if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
			flag = 1;
			wk->work--;
			if( wk->work <= 0 ){
				wk->work = (POKE_NUM_MAX - 1);
			}
		}

		//tOĂ
		if( flag == 1 ){
			//w͈͂hԂ
			GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*11, 0, 8*6, 8*2 );
	
			//|Pio[\
			NumMsgSet( &wk->bmpwin[0], wk->work, 8*11, 2 );
			GF_BGL_BmpWinOn( &wk->bmpwin[0] );
		}

		//I
		if( sys.cont == PAD_BUTTON_B ){
			TcbBmpDel( tcb, work );				//TCBBMPJ
		}

		return;	//ӁI
	}

	switch( wk->seq ){
	case 0:
#if 1
		now_tick = 0;
		//Snd_ZukanWaveDataSet( wk->work );							//g`f[^̃AhX擾
		pw_data = Snd_ZukanWaveDataSet( wk->work );					//g`f[^̃AhX擾
		OS_Printf( "pw_data size = %d\n", Snd_WaveDataSampleSizeGet( pw_data ) );
		//Snd_DebugWaveDataPut( 0, 1000 );							//g`f[^\
		
		for( i=0; i < 9 ;i++ ){
			test_buf[i] = 0;
		}

		ret = Snd_PMVoicePlay( wk->work );							//ʏĐ

		//
		if( sys.cont & PAD_BUTTON_L ){
			//Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, -64 * 12 );
			Snd_PlayerSetTrackPitch( SND_HANDLE_PMVOICE, 0xffff, 64 * 12 );
		}
#endif

		//pw_data = Snd_ZukanWaveDataSet( wk->work );					//g`f[^̃AhX擾
		//Snd_PMVoicePlayPtn_ZukanChorus( 1, 0 );
		//Snd_PMVoicePlayPtn_ZukanChorus( 1, 80 );

		wk->seq++;
		break;
	case 1:
		if( Snd_PMVoicePlayCheck() == 0 ){
			wk->count = 0;
			wk->seq++;
		}else{
			{
				u32 tmp,old_tick;

#if 0
				old_tick = now_tick;								//ޔ
				//now_tick = Snd_ZukanPlayerGetTick();				//eBbN擾
				now_tick = Snd_PlayerGetSampleTick( SND_HANDLE_PMVOICE, pw_data );	//eBbN擾

				//240() - 180(O) = 60()
				//60 / 2 = 30
				//240 - 30 = 210()
				tmp = (now_tick - ((now_tick-old_tick) / 2));
				Snd_DebugWaveDataPut( pw_data, tmp, tmp+1 );					//OƂ̒Ԉʒu

				Snd_DebugWaveDataPut( pw_data, now_tick, now_tick+1 );		//݂̈ʒu
				Snd_DebugWaveLevelGet( now_tick );					//x
#endif

				//x擾
				Snd_ZukanWaveLevelSet_New( pw_data, test_buf, 9, 0 );
			}
		}
		break;
	case 2:
		wk->seq = 0;
		wk->count = 0;
		wk->waveout_flag = 0;				//ĐtOOFF
		break;
	};

	return;
}


//==============================================================================================
//
//	16	CViI֘A
//
//	݂̃][̃XNvgƃbZ[Wǂݍނ悤ɂĂ̂ŁA
//	fobNŃXNvgIDw肷邾ł͏oȂI
//
//	܂XNvg쐬ĂȂ̂́Acommon_scr.evɒǉĎBBB
//	ƂvAbZ[WȂ̂ŁABBB
//
//==============================================================================================
static void D_Nohara_16_Main( TCB_PTR tcb, void * work );

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_16( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= 0;
	TCB_ChangeFunc( tcb, D_Nohara_16_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_16_Main( TCB_PTR tcb, void * work )
{
	//I
	if( sys.cont == PAD_BUTTON_B ){
		TcbBmpDel( tcb, work );		//TCBBMPJ
	}

	return;
}


//==============================================================================================
//
//	17	obWtOZbg
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_17( TCB_PTR tcb, void * work )
{
	int i;
	D_NOHARA_WORK* wk = (D_NOHARA_WORK*)work;
	MYSTATUS* my = SaveData_GetMyStatus( wk->fsys->savedata );

	for( i=0; i < 8; i++ ){
		MyStatus_SetBadgeFlag( my, i );
	}

	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}


//==============================================================================================
//
//	18	BACe
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_18( TCB_PTR tcb, void * work )
{
	int i,count;
	D_NOHARA_WORK* wk = (D_NOHARA_WORK*)work;
	MYSTATUS* my = SaveData_GetMyStatus( wk->fsys->savedata );
	HIDE_ITEM_LIST* p = HideItem_CreateList( wk->fsys, HEAPID_BASE_DEBUG );

	count = 0;

	while( 1 ){
		if( p[count].response == HIDE_LIST_RESPONSE_NONE ){
			if( count == 0 ){
				OS_Printf( "BACe͌܂łI\n" );
			}
			break;
		}

		OS_Printf( "\nresponse = %d\n", p[count].response );
		OS_Printf( "gx = %d\n", p[count].gx );
		OS_Printf( "gz = %d\n", p[count].gz );
		count++;
	};

	sys_FreeMemoryEz( p );

	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}


//==============================================================================================
//
//	19	BACe
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_19( TCB_PTR tcb, void * work )
{
	int type,ret;
	D_NOHARA_WORK* wk = (D_NOHARA_WORK*)work;

	ret = Snd_CaptureIsActive();
	OS_Printf( "Lv`LH = %d\n", ret );

	//LALv`^Cv\
	if( ret == TRUE ){

		type = Snd_CaptureGetCaptureType();

		if( type == NNS_SND_CAPTURE_TYPE_REVERB ){
			OS_Printf( "݂̃Lv`́ANNS_SND_CAPTURE_TYPE_REVERB\n" );
		}else if( type == NNS_SND_CAPTURE_TYPE_EFFECT ){
			OS_Printf( "݂̃Lv`́ANNS_SND_CAPTURE_TYPE_EFFECT\n" );
		}else if( type == NNS_SND_CAPTURE_TYPE_SAMPLING ){
			OS_Printf( "݂̃Lv`́ANNS_SND_CAPTURE_TYPE_SAMPLING\n" );
		}
	}

	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}


//==============================================================================================
//
//	20	MlXEBhE
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_20( TCB_PTR tcb, void * work )
{
	int type,ret;
	D_NOHARA_WORK* wk = (D_NOHARA_WORK*)work;

	EventSet_Script( wk->fsys, SCRID_GUINNESS_WIN, NULL );
	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}

//==============================================================================================
//
//	21	fobNWv
//
//==============================================================================================
static void D_Nohara_21_Main( TCB_PTR tcb, void * work );

typedef struct{
	u32 zone_id;
	u32 num;
	u32 x;
	u32 z;
}DEBUG_JUMP_WORK;

static const DEBUG_JUMP_WORK debug_jump_work[] = {
	{ ZONE_ID_T02,		2,		160,	846 },			//}TS^E
	{ ZONE_ID_T03,		3,		176,	624 },			//\mI^E
	{ ZONE_ID_R201,		201,	110,	856 },			//
	{ ZONE_ID_R205A,	2051,	208,	592 },			//
	{ ZONE_ID_R205B,	2052,	272,	528 },			//
	{ ZONE_ID_C05R1101,	511,	5,		5 },			//ReXgt
	{ ZONE_ID_D27R0101, 2701,	46,		53 },			//
};
#define DEBUG_JUMP_WORK_MAX	( NELEMS(debug_jump_work) )

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_21( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= 0;
	TCB_ChangeFunc( tcb, D_Nohara_21_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_21_Main( TCB_PTR tcb, void * work )
{
	int flag;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	flag = 0;	//tO

	if( (sys.repeat == PAD_KEY_UP) || (sys.cont == PAD_KEY_RIGHT) ){
		flag = 1;
		wk->work++;
		if( wk->work >= DEBUG_JUMP_WORK_MAX ){
			wk->work = 0;
		}
	}

	if( (sys.repeat == PAD_KEY_DOWN) || (sys.cont == PAD_KEY_LEFT) ){
		flag = 1;
		wk->work--;
		if( wk->work < 0 ){
			wk->work = (DEBUG_JUMP_WORK_MAX - 1);
		}
	}

	//tOĂ
	if( flag == 1 ){
		//w͈͂hԂ
		GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_BLACK, 8*7, 8*2, 
								8*8, 8*2 );
	
		//l\
		NumMsgSet( &wk->bmpwin[0], debug_jump_work[wk->work].num, 8*7, 8*2 );
		GF_BGL_BmpWinOn( &wk->bmpwin[0] );
	}

	//Wv
	if( sys.trg == PAD_BUTTON_A ){

		EventSet_MapChange( wk->fsys, debug_jump_work[wk->work].zone_id, DOOR_ID_JUMP_CODE, 
							debug_jump_work[wk->work].x , debug_jump_work[wk->work].z, DIR_DOWN );

		TcbBmpDel( tcb, work );		//TCBBMPJ
		return;
	}

	//I
	if( sys.cont == PAD_BUTTON_B ){
		TcbBmpDel( tcb, work );		//TCBBMPJ
		return;
	}

	return;
}


//==============================================================================================
//
//	22	|Pb`g`eXg
//
//==============================================================================================
static void D_Nohara_22_Main( TCB_PTR tcb, void * work );
static void Snd_DebugWaveBufWrite( u32 no );

static s8 d_sWaveBuffer[ 64 ] ATTRIBUTE_ALIGN(32);	//g`i[obt@

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_22( TCB_PTR tcb, void * work )
{
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;
	wk->seq		= 0;
	wk->count	= 0;
	wk->work	= 0;

	//g`Đp`lmۂ
	Snd_WaveOutAllocChannel( WAVEOUT_CH_NORMAL );

	TCB_ChangeFunc( tcb, D_Nohara_22_Main );	//TCB̓֐؂ւ
	return;
}

//--------------------------------------------------------------
/**
 * @brief	C
 *
 * @param	tcb		TCB_PTR^
 * @param	work	[N
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_22_Main( TCB_PTR tcb, void * work )
{
	int flag;
	D_NOHARA_WORK* wk;
	wk = (D_NOHARA_WORK*)work;

	flag = 0;	//tO


	switch( wk->seq ){
	case 0:
		//Ăяop^[؂ւ
		if( sys.trg & PAD_KEY_UP ){
			Snd_DebugWaveBufWrite( 0 );
			wk->seq++;
		}else if( sys.trg & PAD_KEY_DOWN ){
			Snd_DebugWaveBufWrite( 1 );
			wk->seq++;
		}else if( sys.trg & PAD_KEY_RIGHT ){
			Snd_DebugWaveBufWrite( 2 );
			wk->seq++;
		}else if( sys.trg & PAD_KEY_LEFT ){
			Snd_DebugWaveBufWrite( 3 );
			wk->seq++;
		}

		//I
		if( sys.cont == PAD_BUTTON_B ){
			//g`Đp`lJ
			Snd_DebugNormalChannelFree();

			TcbBmpDel( tcb, work );		//TCBBMPJ
			return;
		}

		break;

	case 1:
		//g`Đ
		{
			WAVEOUT_WORK waveout_wk;

			waveout_wk.handle			= Snd_WaveOutHandleGet(WAVEOUT_CH_NORMAL);//g`Đnh
			waveout_wk.format			= NNS_SND_WAVE_FORMAT_PCM8;//g`f[^tH[}bg
			waveout_wk.dataaddr			= &d_sWaveBuffer[0];//g`f[^̐擪AhX
			waveout_wk.loopFlag			= TRUE;					//[vtO
			waveout_wk.loopStartSample	= 0;						//[vJnTvʒu
			waveout_wk.samples			= 64;				//g`f[^̃Tv
			//waveout_wk.samples		= WAVE_SAMPLE;				//g`f[^̃Tv
			waveout_wk.sampleRate		= 16000;					//g`f[^̃TvO[g
			waveout_wk.volume			= 127;						//
			waveout_wk.speed			= 32768;					//ĐXs[h
			//waveout_wk.speed			= 32768*3;					//ĐXs[h
			//waveout_wk.speed			= 32768/3;					//ĐXs[h
			waveout_wk.pan				= 64;						//p(0-127)

			Snd_WaveOutStart( &waveout_wk );		//g`Đ
		}
		wk->count = 0;
		wk->seq++;
		break;

	case 2:
		wk->count++;

		if( wk->count == 16 ){					//t[Ȃ̂ŒӁI
			Snd_WaveOutSetSpeed( WAVEOUT_CH_NORMAL, (32768 * 2) );
		}

		if( wk->count == 24 ){					//t[Ȃ̂ŒӁI
			Snd_WaveOutSetSpeed( WAVEOUT_CH_NORMAL, (32768 / 2) );
		}

		if( wk->count >= 32 ){					//t[Ȃ̂ŒӁI
			Snd_WaveOutStop( WAVEOUT_CH_NORMAL );	//g`~
			wk->seq = 0;
		}
		break;
	};

	return;
}

//--------------------------------------------------------------
/**
 * @brief	KȔg`
 *
 * @param	no		p^[
 *
 * @retval	none
 */
//--------------------------------------------------------------
#define TEST_START	(0)
#define TEST_ADD	(64)
//#define TEST_LOOP	(40)
#define TEST_LOOP	(1)

static void Snd_DebugWaveBufWrite( u32 no )
{
	u8 add;
	int i,j;

	switch( no ){

	case 0:

		//uv
		
		for( j=0; j < TEST_LOOP ;j++ ){

			add = TEST_ADD * j;

			for( i=0+add; i < 32+add ;i++ ){
				d_sWaveBuffer[i] = 120;
			}
			for( i=32+add; i < 64+add ;i++ ){
				d_sWaveBuffer[i] = -120;
			}
		}
		break;

	case 1:

		//uv
		
		for( j=0; j < TEST_LOOP ;j++ ){

			add = TEST_ADD * j;

			for( i=0+add; i < 10+add ;i++ ){
				d_sWaveBuffer[i] = 0;
			}
			for( i=10+add; i < 20+add ;i++ ){
				d_sWaveBuffer[i] = 120;
			}
			for( i=20+add; i < 30+add ;i++ ){
				d_sWaveBuffer[i] = 0;
			}
			for( i=30+add; i < 40+add ;i++ ){
				d_sWaveBuffer[i] = -120;
				}
			for( i=40+add; i < 50+add ;i++ ){
				d_sWaveBuffer[i] = 0;
			}
			for( i=50+add; i < 64+add ;i++ ){
				d_sWaveBuffer[i] = 120;
			}
		}

	case 2:

		//uv
		//}CiXȂ
		
		for( j=0; j < TEST_LOOP ;j++ ){

			add = TEST_ADD * j;

			d_sWaveBuffer[0+add] = 0;
			d_sWaveBuffer[1+add] = 4;
			d_sWaveBuffer[2+add] = 8;
			d_sWaveBuffer[3+add] = 12;
			d_sWaveBuffer[4+add] = 16;
			d_sWaveBuffer[5+add] = 20;
			d_sWaveBuffer[6+add] = 24;
			d_sWaveBuffer[7+add] = 28;
			d_sWaveBuffer[8+add] = 32;
			d_sWaveBuffer[9+add] = 36;
			d_sWaveBuffer[10+add] = 40;
			d_sWaveBuffer[11+add] = 44;
			d_sWaveBuffer[12+add] = 48;
			d_sWaveBuffer[13+add] = 52;
			d_sWaveBuffer[14+add] = 56;
			d_sWaveBuffer[15+add] = 60;
			d_sWaveBuffer[16+add] = 64;
			d_sWaveBuffer[17+add] = 68;
			d_sWaveBuffer[18+add] = 72;
			d_sWaveBuffer[19+add] = 76;
			d_sWaveBuffer[20+add] = 80;
			d_sWaveBuffer[21+add] = 84;
			d_sWaveBuffer[22+add] = 88;
			d_sWaveBuffer[23+add] = 92;
			d_sWaveBuffer[24+add] = 96;
			d_sWaveBuffer[25+add] = 100;
			d_sWaveBuffer[26+add] = 104;
			d_sWaveBuffer[27+add] = 108;
			d_sWaveBuffer[28+add] = 112;
			d_sWaveBuffer[29+add] = 116;
			d_sWaveBuffer[30+add] = 120;
			d_sWaveBuffer[31+add] = 124;
			d_sWaveBuffer[32+add] = 128;
			d_sWaveBuffer[33+add] = 124;
			d_sWaveBuffer[34+add] = 120;
			d_sWaveBuffer[35+add] = 116;
			d_sWaveBuffer[36+add] = 112;
			d_sWaveBuffer[37+add] = 108;
			d_sWaveBuffer[38+add] = 104;
			d_sWaveBuffer[39+add] = 100;
			d_sWaveBuffer[40+add] = 96;
			d_sWaveBuffer[41+add] = 92;
			d_sWaveBuffer[42+add] = 88;
			d_sWaveBuffer[43+add] = 84;
			d_sWaveBuffer[44+add] = 80;
			d_sWaveBuffer[45+add] = 76;
			d_sWaveBuffer[46+add] = 72;
			d_sWaveBuffer[47+add] = 68;
			d_sWaveBuffer[48+add] = 64;
			d_sWaveBuffer[49+add] = 60;
			d_sWaveBuffer[50+add] = 56;
			d_sWaveBuffer[51+add] = 52;
			d_sWaveBuffer[52+add] = 48;
			d_sWaveBuffer[53+add] = 44;
			d_sWaveBuffer[54+add] = 40;
			d_sWaveBuffer[55+add] = 36;
			d_sWaveBuffer[56+add] = 32;
			d_sWaveBuffer[57+add] = 28;
			d_sWaveBuffer[58+add] = 24;
			d_sWaveBuffer[59+add] = 20;
			d_sWaveBuffer[60+add] = 16;
			d_sWaveBuffer[61+add] = 12;
			d_sWaveBuffer[62+add] = 8;
			d_sWaveBuffer[63+add] = 4;
		};

		break;

	case 3:

		//uv
		//}CiX
		
		for( j=0; j < TEST_LOOP ;j++ ){

			add = TEST_ADD * j;

			d_sWaveBuffer[0+add] = -127;
			d_sWaveBuffer[1+add] = -119;
			d_sWaveBuffer[2+add] = -111;
			d_sWaveBuffer[3+add] = -103;
			d_sWaveBuffer[4+add] = -95;
			d_sWaveBuffer[5+add] = -87;
			d_sWaveBuffer[6+add] = -79;
			d_sWaveBuffer[7+add] = -71;
			d_sWaveBuffer[8+add] = -63;
			d_sWaveBuffer[9+add] = -55;
			d_sWaveBuffer[10+add] = -47;
			d_sWaveBuffer[11+add] = -39;
			d_sWaveBuffer[12+add] = -31;
			d_sWaveBuffer[13+add] = -23;
			d_sWaveBuffer[14+add] = -15;
			d_sWaveBuffer[15+add] = -7;
			d_sWaveBuffer[16+add] = 1;
			d_sWaveBuffer[17+add] = 9;
			d_sWaveBuffer[18+add] = 17;
			d_sWaveBuffer[19+add] = 25;
			d_sWaveBuffer[20+add] = 33;
			d_sWaveBuffer[21+add] = 41;
			d_sWaveBuffer[22+add] = 49;
			d_sWaveBuffer[23+add] = 57;
			d_sWaveBuffer[24+add] = 65;
			d_sWaveBuffer[25+add] = 73;
			d_sWaveBuffer[26+add] = 81;
			d_sWaveBuffer[27+add] = 89;
			d_sWaveBuffer[28+add] = 97;
			d_sWaveBuffer[29+add] = 105;
			d_sWaveBuffer[30+add] = 113;
			d_sWaveBuffer[31+add] = 121;
			d_sWaveBuffer[32+add] = 127;
			d_sWaveBuffer[33+add] = 121;
			d_sWaveBuffer[34+add] = 113;
			d_sWaveBuffer[35+add] = 105;
			d_sWaveBuffer[36+add] = 97;
			d_sWaveBuffer[37+add] = 89;
			d_sWaveBuffer[38+add] = 81;
			d_sWaveBuffer[39+add] = 73;
			d_sWaveBuffer[40+add] = 65;
			d_sWaveBuffer[41+add] = 57;
			d_sWaveBuffer[42+add] = 49;
			d_sWaveBuffer[43+add] = 41;
			d_sWaveBuffer[44+add] = 33;
			d_sWaveBuffer[45+add] = 25;
			d_sWaveBuffer[46+add] = 17;
			d_sWaveBuffer[47+add] = 9;
			d_sWaveBuffer[48+add] = 1;
			d_sWaveBuffer[49+add] = -7;
			d_sWaveBuffer[50+add] = -15;
			d_sWaveBuffer[51+add] = -23;
			d_sWaveBuffer[52+add] = -31;
			d_sWaveBuffer[53+add] = -39;
			d_sWaveBuffer[54+add] = -47;
			d_sWaveBuffer[55+add] = -55;
			d_sWaveBuffer[56+add] = -63;
			d_sWaveBuffer[57+add] = -71;
			d_sWaveBuffer[58+add] = -79;
			d_sWaveBuffer[59+add] = -87;
			d_sWaveBuffer[60+add] = -95;
			d_sWaveBuffer[61+add] = -103;
			d_sWaveBuffer[62+add] = -111;
			d_sWaveBuffer[63+add] = -119;
		};

		break;

	default:
		break;
	};

	//eXg\
	for( j=0; j < 64*10 ;j++ ){
		OS_Printf( "d_sWaveBuffer[%d] = %d\n", j, d_sWaveBuffer[j] );
	}

	return;
}


//==============================================================================================
//
//	23	}ӁAobOVXetOZbg
//
//==============================================================================================

//--------------------------------------------------------------
/**
 * @brief	
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_23( TCB_PTR tcb, void * work )
{
	int type,ret;
	D_NOHARA_WORK* wk = (D_NOHARA_WORK*)work;

	{
		//j[u}Ӂv
		ZUKAN_WORK* zw = SaveData_GetZukanWork( wk->fsys->savedata );
		ZukanWork_SetZukanGetFlag( zw );

		//j[uobOv
		SysFlag_BagSet( wk->fsys );

		//j[u|Pv
		SysWork_FirstPokeNoSet( wk->fsys, MONSNO_HUSIGIDANE );
	}

	TcbBmpDel( tcb, work );		//TCBBMPJ
	return;
}









#if 0
	typedef void (*fsysFunc)(FIELDSYS_WORK* fsys);		//֐|C^^

	//w͈͂hԂ
	GF_BGL_BmpWinFill( &wk->bmpwin[0], FBMP_COL_WHITE, 0, 0, 
							8*D_NOHARA_BMPWIN_SX, 8*D_NOHARA_BMPWIN_SY );
	
	GF_MSG_Print( &wk->bmpwin[0], FONT_SYSTEM, msg, 0, 0, MSG_NO_PUT, NULL );
#endif


//--------------------------------------------------------------
/**
 * @brief	oCibZ[Wt@Cǂݍ݁A\eXg
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_89(void)
{
#if 1
	return;
#else
	static u16 * pMsg = NULL;

	//debug_msg.datcvsɓo^ĂȂ̂ŒӁI
	pMsg = (u16 *)sys_LoadFile( HEAPID_BASE_DEBUG, "/data/script/debug_msg.dat" );
	FieldTalkWinPut();
	msg_no_print( pMsg );
	FieldTalkMsgStart( pMsg, 1 );					//2=skip
	sys_FreeMemoryEz( pMsg );

	return;
#endif
}

//--------------------------------------------------------------
/**
 * @brief	gbN~[geXg
 *
 * @param	none
 *
 * @retval	none
 */
//--------------------------------------------------------------
static void D_Nohara_72(void)
{
	Snd_PlayerSetTrackMute( SND_HANDLE_FIELD, ( (1 << 0) | (2 << 0) ), TRUE );
	return;
}


