//=============================================================================
/**
 * @file	d_ohno.c
 * @bfief	pfobO[`
 * @author	katsumi ohno
 * @date	05/07/08
 */
//=============================================================================


#include "common.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/bmp_menu.h"
#include "system/window.h"
#include "system/pm_str.h"
#include "field/fieldsys.h"

#include "communication/communication.h"
#include "underground/ug_manager.h"
#include "comm_field_state.h"
#include "comm_command_field.h"

#include "comm_player.h"
#include "comm_direct_counter.h"
#include "fieldmap.h"
#include "fld_bmp.h"
#include "ev_mapchange.h"

#include "system/wordset.h"
#include "msgdata/msg_underworld.h"

#include "script.h"							//StartFieldScript

#include "..\fielddata\script\common_scr_def.h"		//SCRID_TRAINER_MOVE_SCRIPT
#include "..\fielddata\script\connect_def.h"		//SCRID_CONNECT_COLOSSEUM

#include "msgdata/msg.naix"
#include "msgdata/msg_debug_ohno.h"


//==============================================================================
// extern錾
//==============================================================================

#include "d_ohno.h"

//==============================================================================
// `
//==============================================================================

//#define COMM_DEBUG (1)   // ʐM̃fobOꍇ`

// j[^XNɓo^Ăۂ̃vCIeB[
// d˂邲Ƃɂ悤ɂ邽ߒ`Ă
enum menuTaskPri_e {
    _MENU_ROLE_PRI = 0,
    _MENU_TALK_PRI = _MENU_ROLE_PRI,
    _MENU_SELECT_PARENT_PRI = 0,
    _MENU_WAIT_PRI = 0,
    _MENU_CHILD_LIST_PRI = 0,
    _MENU_UG_PRI = 10000,
};


#define _TCB_COMMCHECK_PRT   (10)    ///< tB[hʐM̊Ď[`PRI
#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY


// lbg[N󋵍\
typedef struct{
    FIELDSYS_WORK* pFSys;
    GF_BGL_BMPWIN win;		// BMPEBhE[N
    BMPLIST_WORK* lw;		// BMPj[[N
    MSGDATA_MANAGER* msgman;
    BMPMENU_WORK* pYesNoWork;
	BMPLIST_DATA*   menulist;
    WORDSET* pWordSetMain;  //[hZbg\
	STRBUF* pStrBuf[2]; // bZ[Wďo͂ꍇ̊i[ꏊ
    pEndFunc func;
    u32 list_id;
    u16 connectIndex;  // Ȃe@INDEX
    s16 packetByte;   // fobOőMpPbgoCg
    //	u8 mode;
    u8 waitMode;
    u8 endState;
    u8 work;
} _NET_INFO_WORK;

static _NET_INFO_WORK* _pNet = NULL;

#define _LOCAL_WIN_PX (2)   // GF_BGL_BmpAddŎgp EChEPXl
#define _LOCAL_WIN_PY (18)   // GF_BGL_BmpAddŎgp EChEPYl
#define _LOCAL_WIN_SX (28)   // GF_BGL_BmpAddŎgp EChESXl
#define _LOCAL_WIN_SY (4)   // GF_BGL_BmpAddŎgp EChESYl


//==============================================================================
//	^錾
//==============================================================================
typedef void (*pNetFunc)(_NET_INFO_WORK *);

//==============================================================================
// static錾
//==============================================================================

static void _listCreate(_NET_INFO_WORK* pNet,u8 x,u8 y,u8 width,u8 height,u16 chrofs, int length);
// e@@q@I
static void _roleMenuFunc(TCB_PTR tcb, void* work);
static void _roleMenuEnd(TCB_PTR tcb,_NET_INFO_WORK* pNet);
static void _commScriptBattle(_NET_INFO_WORK* pNet);
static void _commScriptContest(_NET_INFO_WORK* pNet);
static void _commBattleChild( _NET_INFO_WORK* pNet );
static void _battleChildMenuFunc(TCB_PTR tcb, void* work);
static void _commBattleChildConnect( _NET_INFO_WORK* pNet );
static void _commBattleParent( _NET_INFO_WORK* pNet );
static void _battleParentMenuFunc(TCB_PTR tcb, void* work);
static void _commBattleParentConnect( _NET_INFO_WORK* pNet );

static void _commContestChildConnect( _NET_INFO_WORK* pNet );
static void _commContestParentConnect( _NET_INFO_WORK* pNet );

   // tB[h𓮂ʐM̒ʐM̊Ď
static void _commCheckFunc(TCB_PTR tcb, void* work);

//ʐMʂύXfobO@@ʐM
static void _commSendQuantity(_NET_INFO_WORK* pNetOld);
static void _commSendQuantityLineCallBack(void);
static void _commSendQuantityFunc(TCB_PTR tcb, void* work);

static void _commAutoMove(_NET_INFO_WORK* pNet);
static void _commUnder(_NET_INFO_WORK* pNet);

//==============================================================================
// [N
//==============================================================================

//==============================================================================
//	eqIj[Xgpf[^
//==============================================================================
static const struct {
	u32  str_id;
	u32  param;
}DebugMenuList[] = {
	{ DebugOhno_ScriptBattle, (u32)_commScriptBattle },
	{ DebugOhno_ScriptContest, (u32)_commScriptContest },
    { DebugOhno_EasyBattle_Child, (u32)_commBattleChild },
    { DebugOhno_EasyBattle_Parent, (u32)_commBattleParent },
    { DebugOhno_EasyContest_Child, (u32)_commContestChildConnect },
    { DebugOhno_EasyContest_Parent, (u32)_commContestParentConnect },
    { DebugOhno_CommQuantity, (u32)_commSendQuantity },
    { DebugOhno_AutoMove,  (u32)_commAutoMove },
    { DebugOhno_Down,  (u32)_commUnder },
    
};

///eqIj[̃Xg
static const BMPLIST_HEADER DebugMenuListHeader = {
    NULL,			// \f[^|C^
    NULL,					// J[\ړƂ̃R[obN֐
    NULL,					// \Ƃ̃R[obN֐
    NULL,                   // 
    NELEMS(DebugMenuList),	// Xgڐ
    NELEMS(DebugMenuList),	// \ő區ڐ
    0,						// x\wW
    8,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,				// w
    0,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL                    // work
};

//==============================================================================
// ֐
//==============================================================================

//--------------------------------------------------------------
/**
 * @brief   ėpXg̍쐬
 * @param   header Xgwb_[
 * @param   x,y   JnW
 * @param   width,height  
 * @param   chrofs  LN^[ItZbg
 * @retval  none
 */
//--------------------------------------------------------------
static void _listCreate(_NET_INFO_WORK* pNet, u8 x,u8 y,u8 width,u8 height,u16 chrofs,int length)
{
    BMPLIST_HEADER list_h;
    //BMPEBhE
    GF_BGL_BmpWinAdd(pNet->pFSys->bgl,&pNet->win,
                     GF_BGL_FRAME3_M, x, y, width, height, FLD_SYSFONT_PAL, chrofs);
    BmpMenuWinWrite(&pNet->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
    list_h = DebugMenuListHeader;
	list_h.list = pNet->menulist;
    list_h.win = &pNet->win;
    list_h.count = length;
    list_h.line = length;
    pNet->lw = BmpListSet(&list_h, 0, 0, HEAPID_BASE_DEBUG);
    GF_BGL_BmpWinOn(&pNet->win);
}

//==============================================================================
/**
 * ʐM̃fobŐNs
 * @param   none
 * @retval  none
 */
//==============================================================================

void DebugCommMenuInit(void* pFieldSys)
{
    _NET_INFO_WORK* pNet;
    FIELDSYS_WORK* pFSys = pFieldSys;

    pNet = sys_AllocMemory(HEAPID_FIELD, sizeof(_NET_INFO_WORK));
    MI_CpuFill8(pNet, 0, sizeof(_NET_INFO_WORK));
    pNet->pFSys = (FIELDSYS_WORK*)pFieldSys;


	pNet->menulist = BMP_MENULIST_Create( NELEMS(DebugMenuList), HEAPID_BASE_DEBUG );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_ohno_dat, HEAPID_BASE_DEBUG);
		for(i=0; i<NELEMS(DebugMenuList); i++)
		{
			BMP_MENULIST_AddArchiveString( pNet->menulist, msgman, DebugMenuList[i].str_id, DebugMenuList[i].param );
		}
		MSGMAN_Delete(msgman);
	}

    _listCreate(pNet,1,1,14,NELEMS(DebugMenuList)*2,
                FLD_MENU_WIN_CGX - NELEMS(DebugMenuList)*2, NELEMS(DebugMenuList));

    TCB_Add(_roleMenuFunc, pNet, _MENU_ROLE_PRI);
}

//--------------------------------------------------------------
/**
 * @brief   eq߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _roleMenuFunc(TCB_PTR tcb, void* work)
{
    _NET_INFO_WORK* pNet = work;
    u32	ret;

    ret = BmpListMain(pNet->lw);
    switch(ret){
    case BMPLIST_NULL:
        break;
    case BMPLIST_CANCEL:
        _roleMenuEnd(tcb, pNet);
        sys_FreeMemoryEz(pNet);
        FieldSystemProc_SeqHoldEnd();
        break;
    default:
        _roleMenuEnd(tcb, pNet);
        {
            pNetFunc func = (pNetFunc)ret;
            func(pNet);  // ֐Wv
        }
        sys_FreeMemoryEz(pNet);
        break;
    }
}

//--------------------------------------------------------------
/**
 * @brief   eqIj[Xg
 * @param   tcb			TCBւ̃|C^
 * @param   pNet		lbg[N󋵍\̂̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _roleMenuEnd(TCB_PTR tcb,_NET_INFO_WORK* pNet)
{
	BmpMenuWinClear(&pNet->win, WINDOW_TRANS_ON );
    BMP_MENULIST_Delete( pNet->menulist );
    BmpListExit(pNet->lw, NULL, NULL);
    GF_BGL_BmpWinOff(&pNet->win);
    GF_BGL_BmpWinDel(&pNet->win);
    TCB_Delete(tcb);
}

//--------------------------------------------------------------
/**
 * @brief   ʐM_CNgڑJE^[̃j[N
 * @param   pNet		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _commScriptBattle(_NET_INFO_WORK* pNet)
{
    FieldSystemProc_SeqHoldEnd();
	//bΏOBJ̃|C^"NULL"Ȃ̂ŒӁI
	EventSet_Script( pNet->pFSys, SCRID_CONNECT_COLOSSEUM, NULL );
	//EventSet_Script( pNet->pFSys, SCRID_CONNECT_UNION, NULL );
	//EventSet_Script( pNet->pFSys, SCRID_CONNECT_RECORD, NULL );
}

//--------------------------------------------------------------
/**
 * @brief   ʐM_CNgڑJE^[̃j[N
 * @param   pNet		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _commScriptContest(_NET_INFO_WORK* pNet)
{
    FieldSystemProc_SeqHoldEnd();
	//bΏOBJ̃|C^"NULL"Ȃ̂ŒӁI
    EventSet_Script( pNet->pFSys, SCRID_CONNECT_CONTEST, NULL );
}

//==============================================================================
//	eqIj[Xgpf[^
//==============================================================================
///eqIj[̍ڃbZ[W
static const struct {
	u32  str_id;
	u32  param;
}DebugBattleChildMenuList[] = {
	{ DebugOhno_EasyBattle_Child0001, (u32)_commBattleChildConnect },
	{ DebugOhno_EasyBattle_Child0002, (u32)_commBattleChildConnect },
    { DebugOhno_EasyBattle_Child0003, (u32)_commBattleChildConnect },
    { DebugOhno_EasyBattle_Child0004, (u32)_commBattleChildConnect },
    { DebugOhno_EasyBattle_Child0005, (u32)_commBattleChildConnect },
};

//--------------------------------------------------------------
/**
 * @brief   og̊ȈՐڑs
 * @param   pNet		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _commBattleChild(_NET_INFO_WORK* pNetOld)
{
    _NET_INFO_WORK* pNet;

    pNet = sys_AllocMemory(HEAPID_FIELD, sizeof(_NET_INFO_WORK));
    MI_CpuFill8(pNet, 0, sizeof(_NET_INFO_WORK));
    pNet->pFSys = pNetOld->pFSys;

	pNet->menulist = BMP_MENULIST_Create( NELEMS(DebugBattleChildMenuList), HEAPID_BASE_DEBUG );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_ohno_dat, HEAPID_BASE_DEBUG);
		for(i=0; i<NELEMS(DebugBattleChildMenuList); i++)
		{
			BMP_MENULIST_AddArchiveString( pNet->menulist, msgman, DebugBattleChildMenuList[i].str_id, DebugBattleChildMenuList[i].param );
		}
		MSGMAN_Delete(msgman);
	}

    _listCreate(pNet,1,1,14,
                NELEMS(DebugBattleChildMenuList)*2,
                FLD_MENU_WIN_CGX - NELEMS(DebugBattleChildMenuList)*2, NELEMS(DebugBattleChildMenuList));
    TCB_Add(_battleChildMenuFunc, pNet, _MENU_ROLE_PRI);
}

//--------------------------------------------------------------
/**
 * @brief   eq߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _battleChildMenuFunc(TCB_PTR tcb, void* work)
{
    _NET_INFO_WORK* pNet = work;
    u32	ret;

    ret = BmpListMain(pNet->lw);
    switch(ret){
    case BMPLIST_NULL:
        break;
    case BMPLIST_CANCEL:
        _roleMenuEnd(tcb, pNet);
        sys_FreeMemoryEz(pNet);
        FieldSystemProc_SeqHoldEnd();
        break;
    default:
        _roleMenuEnd(tcb, pNet);
        {
            pNetFunc func = (pNetFunc)ret;
            func(pNet);  // ֐Wv
        }
        sys_FreeMemoryEz(pNet);
        break;
    }
}

static void _commBattleChildConnect( _NET_INFO_WORK* pNet )
{
    u16 cur;

    FieldSystemProc_SeqHoldEnd();
    BmpListDirectPosGet(pNet->lw, &cur);

//    CommSelectParentWindowOpen(pNet->pFSys,cur+1,0,0);
//    CommStateConnectBattleChild_Debug(pNet->pFSys, cur+1, 0);

    CommDirectConnectSetParam_Debug(pNet->pFSys, cur+COMM_MODE_BATTLE_SINGLE, 0, 0);
    EventSet_Script( pNet->pFSys, SCRID_CONNECT_COLOSSEUM_DEBUG_KO, NULL );
/*  SCRID_CONNECT_COLOSSEUM_DEBUG_OYA
  SCRID_CONNECT_COLOSSEUM_DEBUG_KO
  SCRID_CONNECT_CONTEST_DEBUG_OYA
  SCRID_CONNECT_CONTEST_DEBUG_KO*/

    
}

//==============================================================================
//	eqIj[Xgpf[^
//==============================================================================
///eqIj[̍
static const struct {
	u32  str_id;
	u32  param;
}DebugBattleMenuList[] = {
	{ DebugOhno_EasyBattle_Parent0001, (u32)_commBattleParentConnect },
	{ DebugOhno_EasyBattle_Parent0002, (u32)_commBattleParentConnect },
    { DebugOhno_EasyBattle_Parent0003, (u32)_commBattleParentConnect },
    { DebugOhno_EasyBattle_Parent0004, (u32)_commBattleParentConnect },
    { DebugOhno_EasyBattle_Parent0005, (u32)_commBattleParentConnect },
};

//--------------------------------------------------------------
/**
 * @brief   og̊ȈՐڑs
 * @param   pNet		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _commBattleParent(_NET_INFO_WORK* pNetOld)
{
    _NET_INFO_WORK* pNet;

    pNet = sys_AllocMemory(HEAPID_FIELD, sizeof(_NET_INFO_WORK));
    MI_CpuFill8(pNet, 0, sizeof(_NET_INFO_WORK));
    pNet->pFSys = pNetOld->pFSys;
	pNet->menulist = BMP_MENULIST_Create( NELEMS(DebugBattleMenuList), HEAPID_BASE_DEBUG );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_ohno_dat, HEAPID_BASE_DEBUG);
		for(i=0; i<NELEMS(DebugBattleMenuList); i++)
		{
			BMP_MENULIST_AddArchiveString( pNet->menulist, msgman, DebugBattleMenuList[i].str_id, DebugBattleMenuList[i].param );
		}
		MSGMAN_Delete(msgman);
	}
    _listCreate(pNet,1,1,14,
                NELEMS(DebugBattleMenuList)*2,
                FLD_MENU_WIN_CGX - NELEMS(DebugMenuList)*2,NELEMS(DebugBattleMenuList));
    TCB_Add(_battleParentMenuFunc, pNet, _MENU_ROLE_PRI);
}

//--------------------------------------------------------------
/**
 * @brief   eq߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _battleParentMenuFunc(TCB_PTR tcb, void* work)
{
    _NET_INFO_WORK* pNet = work;
    u32	ret;

    ret = BmpListMain(pNet->lw);
    switch(ret){
    case BMPLIST_NULL:
        break;
    case BMPLIST_CANCEL:
        _roleMenuEnd(tcb, pNet);
        sys_FreeMemoryEz(pNet);
        FieldSystemProc_SeqHoldEnd();
        break;
    default:
        _roleMenuEnd(tcb, pNet);
        {
            pNetFunc func = (pNetFunc)ret;
            func(pNet);  // ֐Wv
        }
        sys_FreeMemoryEz(pNet);
        break;
    }
}

static void _commBattleParentConnect( _NET_INFO_WORK* pNet )
{
    u16 cur;

    FieldSystemProc_SeqHoldEnd();
    BmpListDirectPosGet(pNet->lw, &cur);
    //CommChildWindowOpen(pNet->pFSys,cur+1,0,0);
//    CommStateEnterBattleParent_Debug(pNet->pFSys,cur+1);
    CommDirectConnectSetParam_Debug(pNet->pFSys, cur+COMM_MODE_BATTLE_SINGLE, 0, 0);
    EventSet_Script( pNet->pFSys, SCRID_CONNECT_COLOSSEUM_DEBUG_OYA, NULL );
/*  SCRID_CONNECT_COLOSSEUM_DEBUG_OYA
  SCRID_CONNECT_COLOSSEUM_DEBUG_KO
  SCRID_CONNECT_CONTEST_DEBUG_OYA
  SCRID_CONNECT_CONTEST_DEBUG_KO*/
}


//--------------------------------------------------------------
/**
 * @brief   ReXgڑeXg
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _commContestChildConnect( _NET_INFO_WORK* pNet )
{
    u16 cur;

    FieldSystemProc_SeqHoldEnd();
    BmpListDirectPosGet(pNet->lw, &cur);

    CommDirectConnectSetParam_Debug(pNet->pFSys, COMM_MODE_CONTEST, 0, 0);
    EventSet_Script( pNet->pFSys, SCRID_CONNECT_CONTEST_DEBUG_KO, NULL );
}

static void _commContestParentConnect( _NET_INFO_WORK* pNet )
{
    u16 cur;

    FieldSystemProc_SeqHoldEnd();
    BmpListDirectPosGet(pNet->lw, &cur);

    CommDirectConnectSetParam_Debug(pNet->pFSys, COMM_MODE_CONTEST, 0, 0);
    EventSet_Script( pNet->pFSys, SCRID_CONNECT_CONTEST_DEBUG_OYA, NULL );
}



//==============================================================================
//	ʐMʕύXj[Xgpf[^
//==============================================================================
///ʐMʕύXj[̍ڃbZ[W
static const struct {
	u32  str_id;
	u32  param;
}DebugSendQuantityMenuList[] = {
	{ DebugOhno_ID, (u32)0 },
};


#define _DEBUG_QUANTITY_MAX (250)   /// eXgM 250ɐݒ  

//--------------------------------------------------------------
/**
 * @brief   ʐMʂύXfobOEChEJ
 * @param   pNet		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _commSendQuantity(_NET_INFO_WORK* pNetOld)
{
    _NET_INFO_WORK* pNet;
    int i;
    const int length = NELEMS(DebugSendQuantityMenuList);

    pNet = sys_AllocMemory(HEAPID_FIELD, sizeof(_NET_INFO_WORK));
    MI_CpuFill8(pNet, 0, sizeof(_NET_INFO_WORK));
    _pNet = pNet;
    pNet->pFSys = pNetOld->pFSys;
	pNet->menulist = BMP_MENULIST_Create( length, HEAPID_BASE_DEBUG );
    pNet->pWordSetMain = WORDSET_Create(HEAPID_BASE_DEBUG);
    pNet->packetByte = 0;
    for(i = 0;i < 2; i++){
        pNet->pStrBuf[i] = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_BASE_DEBUG);
    }
    pNet->msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_ohno_dat, HEAPID_BASE_DEBUG);
    {
		int i;
        for(i=0; i< length; i++){
			BMP_MENULIST_AddArchiveString( pNet->menulist,
                                           pNet->msgman,
                                           DebugSendQuantityMenuList[i].str_id,
                                           DebugSendQuantityMenuList[i].param );
		}
	}
    _listCreate(pNet, 1, 1, 24,
                length*2, FLD_MENU_WIN_CGX - length*2,NELEMS(DebugSendQuantityMenuList));
    TCB_Add(_commSendQuantityFunc, pNet, _MENU_ROLE_PRI);

#if 0
    CommCommandThrowOut();
#endif
}

//--------------------------------------------------------------
/**
 * @brief   ꃉCR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _commSendQuantityLineCallBack(void)
{
    u16 idx=0;

    if(_pNet->lw){
        BmpListPosGet(_pNet->lw, &idx, NULL);
    }
    
    WORDSET_RegisterNumber(_pNet->pWordSetMain, 0,
                           _pNet->packetByte, 3,
                           NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT);
    MSGMAN_GetString( _pNet->msgman, DebugOhno_CommQuantity01,
                      _pNet->pStrBuf[1] );
    WORDSET_ExpandStr(_pNet->pWordSetMain, _pNet->pStrBuf[0], _pNet->pStrBuf[1] );
    GF_STR_PrintSimple(&_pNet->win, FONT_SYSTEM, _pNet->pStrBuf[0], 14, 1, 0, NULL);
}

//--------------------------------------------------------------
/**
 * @brief   ʐMʂύXfobOj[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------
static void _commSendQuantityFunc(TCB_PTR tcb, void* work)
{
    _NET_INFO_WORK* pNet = work;
    u32	ret;
    int i;
    char dummyBuff[_DEBUG_QUANTITY_MAX];   // 

#if 0
    if(CommCommandIsThrowOuted()){
        OHNO_PRINT("R}ĥĂ܂\n");
    }
#endif

    
    _commSendQuantityLineCallBack();
    if(pNet->packetByte != 0){
        if( CommIsConnect( CommGetCurrentID() ) ){
            CommSendData_ServerSide(CS_DEBUG_VARIABLE, &dummyBuff, pNet->packetByte);
        }
    }
    if(sys.trg & PAD_KEY_LEFT){
        pNet->packetByte -= 1;
    }
    if(sys.trg & PAD_KEY_RIGHT){
        pNet->packetByte += 1;
    }
    if(sys.trg & PAD_BUTTON_L){
        pNet->packetByte -= 10;
    }
    if(sys.trg & PAD_BUTTON_R){
        pNet->packetByte += 10;
    }
    if(pNet->packetByte < 0){
        pNet->packetByte = 0;
    }
    if(pNet->packetByte > _DEBUG_QUANTITY_MAX){
        pNet->packetByte = _DEBUG_QUANTITY_MAX;
    }




    
    ret = BmpListMain(pNet->lw);
    switch(ret){
    case BMPLIST_NULL:
        break;
    case BMPLIST_CANCEL:
    default:
        CommCommandThrowOut();
        
        _roleMenuEnd(tcb, pNet);
        if(pNet->pWordSetMain){
            WORDSET_Delete(pNet->pWordSetMain);
            pNet->pWordSetMain = NULL;
        }
        for(i = 0;i < 2; i++){
            sys_FreeMemoryEz(pNet->pStrBuf[i]);
        }
		MSGMAN_Delete(pNet->msgman);
        sys_FreeMemoryEz(pNet);
        FieldSystemProc_SeqHoldEnd();
        break;
    }
}

extern void CommSwitchAutoMove_Debug(void);

static void _commAutoMove(_NET_INFO_WORK* pNet)
{
    CommSwitchAutoMove_Debug();
    FieldSystemProc_SeqHoldEnd();
}

static void _commUnder(_NET_INFO_WORK* pNet)
{
    // fobOpɎẅʒuɉĂ̂Ɏgp
    Debug_ChangeUnderGroundDirect(pNet->pFSys, 47, 384);
}
