//============================================================================================
/**
 * @file	d_taya.c
 * @bfief	cJ fobOj[
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#ifdef PM_DEBUG

#include "common.h"
#include "system/lib_pack.h"
#include "system/bmp_list.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "system/fontproc.h"
#include "fld_bmp.h"
#include "system/pm_str.h"
#include "system/pm_overlay.h"
#include "field\field.h"
#include "field_event.h"
#include "system\palanm.h"
#include "application\pms_input.h"

#include "msgdata/msg.naix"
#include "msgdata/msg_debug_taya.h"



#include "d_taya.h"





//---------------------------------------------------------------------------------------------
// `
//---------------------------------------------------------------------------------------------
enum {
	WK_SEQ = 0,
	WK_WIN_INDEX,
	WK_LIST_ID,
	WK_LIST_RET
};

typedef struct {
	u16 seq;
	u16 list_ret;

	FIELDSYS_WORK*  fsys;
	BMPLIST_WORK*   list_work;
	GF_BGL_BMPWIN   win;
	BMPLIST_DATA*   menulist;
	GF_BGL_INI*     bgl;

}WORK;

//-----------------------------------------------------------------
/**
 * ɃtF[hAEgĉʉʂ̏ĂԂ
 */
//-----------------------------------------------------------------
typedef void (*ScheneChangeCallback)(FIELDSYS_WORK*, void* wk);




//==============================================================
// Prototype
//==============================================================
static void DebugTayaBmpMenuExit( WORK* wk );
static void DebugMenuExitSub( TCB_PTR tcb );
static void DebugMenuExit( void );
static void DebugTayaMenuMain( TCB_PTR _tcb, void * work );
static void PoketchStartDebug(FIELDSYS_WORK* fsys);
static void BoxStartDebug(FIELDSYS_WORK* fsys);
static void BoxStartCallBack( FIELDSYS_WORK* fsys, void* wk );
static void BoxEndCallBack( FIELDSYS_WORK* fsys, void* wk );
static void PmsStartSingle( FIELDSYS_WORK* fsys );
static void PmsStartDouble( FIELDSYS_WORK* fsys );
static void PmsStartSentence( FIELDSYS_WORK* fsys );
static void PmsCallbackStart(FIELDSYS_WORK* fsys, void* wk);
static void PmsCallbackEnd(FIELDSYS_WORK* fsys, void* wk);
static BOOL GMEVENT_ChangeScheneDebug(GMEVENT_CONTROL * event);
static void Debug_ChangeScheneReq( FIELDSYS_WORK* fsys, ScheneChangeCallback start_func, ScheneChangeCallback end_func, void* gen_wk );



//--------------------------------------------------------------------------------------------
// fobOj[p`
//--------------------------------------------------------------------------------------------
static const struct {
	u32  str_id;
	u32  param;
}MenuParamList[] = {
	{ menu_msg00, (u32)BoxStartDebug },
	{ menu_msg01, (u32)PoketchStartDebug },
	{ menu_msg02, (u32)PmsStartSingle },
	{ menu_msg03, (u32)PmsStartDouble },
	{ menu_msg04, (u32)PmsStartSentence },
};



static const BMPLIST_HEADER d_menu_list_h = {
	NULL,					// \f[^|C^
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,					// BitmapWindow
	NELEMS(MenuParamList),	// Xgڐ
	5,						// \ő區ڐ
	0,						// x\wW
	8,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_BLACK,			// F
	FBMP_COL_WHITE,			// wiF
	FBMP_COL_BLK_SDW,		// eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};


typedef void (*pDebugMenu)(FIELDSYS_WORK*);

//==============================================================================
/**
 * fobOj[֐ifld_debug.cĂ΂܂)
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void DebugTayaMenuInit( void* fsys )
{
	WORK* wk;
	GF_BGL_INI * bgl;
	BMPLIST_HEADER	list_h;

	bgl = FieldBglIniGet( fsys );

	wk = (WORK*)TCB_GetWork( PMDS_taskAdd( DebugTayaMenuMain, sizeof(WORK), 0, HEAPID_BASE_DEBUG ) );
	wk->seq = 0;
	wk->bgl = bgl;
	wk->fsys = fsys;
	wk->menulist = BMP_MENULIST_Create( NELEMS(MenuParamList), HEAPID_BASE_DEBUG );
	GF_BGL_BmpWinAdd( bgl, &(wk->win), FLD_MBGFRM_FONT, 1, 1, 10, 12, FLD_SYSFONT_PAL, 1 );

	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_taya_dat, HEAPID_BASE_DEBUG);
		for(i=0; i<NELEMS(MenuParamList); i++)
		{
			BMP_MENULIST_AddArchiveString( wk->menulist, msgman, MenuParamList[i].str_id, MenuParamList[i].param );
		}
		MSGMAN_Delete(msgman);
	}

	list_h = d_menu_list_h;
	list_h.list = wk->menulist;
	list_h.win = &(wk->win);
	wk->list_work = BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinOn( &wk->win );

}
//------------------------------------------------------------------
/**
 * fobOj[BmpList
 *
 * @param   wk		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugTayaBmpMenuExit( WORK* wk )
{
	BMP_MENULIST_Delete( wk->menulist );
	BmpListExit( wk->list_work, NULL, NULL );

	GF_BGL_BmpWinOff( &wk->win );
	GF_BGL_BmpWinDel( &wk->win );
}


//------------------------------------------------------------------
/**
 * fobOj[
 *
 * @param   tcb		
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void DebugMenuExitSub( TCB_PTR tcb )
{
	WORK* wk = (WORK*)TCB_GetWork(tcb);

	DebugTayaBmpMenuExit( wk );
	PMDS_taskDel( tcb );
	FieldSystemProc_SeqHoldEnd();
}

//------------------------------------------------------------------
/**
 * Ăяo
 *
 * @param   none		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void DebugMenuExit( void )
{

	FieldSystemProc_SeqHoldEnd();

}


//------------------------------------------------------------------
/**
 * 
 *
 * @param   _tcb		
 * @param   work		
 *
 */
//------------------------------------------------------------------
static void DebugTayaMenuMain( TCB_PTR _tcb, void * work )
{
	WORK* wk = (WORK*)work;
	u32	ret;

	switch( wk->seq ){
	case 0:
		ret = BmpListMain( wk->list_work );

		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			DebugMenuExitSub( _tcb );
			break;
		default:
			{
				pDebugMenu func = (pDebugMenu)ret;
				FIELDSYS_WORK* fsys = wk->fsys;
				DebugMenuExitSub( _tcb );
				func( fsys );
			}
			break;
		}
	}
}



/*====================================================================================================*/
/*  |Pb`֘A                                                                                      */
/*====================================================================================================*/
#include "field\poketch.h"
#include "field\poketch_data.h"
///I[o[CW[extern錾łB
FS_EXTERN_OVERLAY(ol_poketch);

extern struct _POKETCH_WORK* GetPoketchMainWorkPtr(void);

//------------------------------------------------------------------
/**
 * |Pb`Jn
 */
//------------------------------------------------------------------
static void PoketchStartDebug(FIELDSYS_WORK* fsys)
{
	extern void EventCmd_DebugGetPoketch(FIELDSYS_WORK* fsys);
	POKETCH_DATA* pd = SaveData_GetPoketchData( SaveData_GetPointer() );

	PoketchData_AddAllApplication( pd );
	EventCmd_DebugGetPoketch( fsys );
}


/*====================================================================================================*/
/*  {bNX֘A                                                                                      */
/*====================================================================================================*/
#include "application\box.h"
#include "field\field_subproc.h"

typedef struct {
	u32					seq;
	ScheneChangeCallback	start_func;
	ScheneChangeCallback	end_func;
	BOOL				fadeFlag;
	void*				gen_wk;
}DEBUG_CHANGESCHENE_WORK;

static void BoxStartDebug(FIELDSYS_WORK* fsys)
{
	// _~[̃|Pf[^ZbgĂc
	#ifdef PM_DEBUG
	#include "poketool\monsno.h"
	#include "poketool\boxdata.h"
	{
		static BOOL flg = TRUE;
		BOX_DATA*  boxData = SaveData_GetBoxData( fsys->savedata );

		if(flg == FALSE)
		{
			POKEMON_PASO_PARAM* ppp = sys_AllocMemory(HEAPID_BASE_DEBUG, PokemonPasoParamSizeGet() );
			if( ppp )
			{
				static const struct {
					u16  monsno;
					u8   box;
					u8   pos;
				}init_param[] = {
					{ MONSNO_HUSIGIDANE,	0,  0 },
					{ MONSNO_HUSIGISOU,	 	0,  1 },
					{ MONSNO_HUSIGIBANA,	0,  2 },
					{ MONSNO_RUNPAPPA,		0,  3 },
					{ MONSNO_HITOKAGE,		0,  4 },
					{ MONSNO_RIZAADO,		0,  5 },
					{ MONSNO_RIZAADON,		0,  6 },
					{ MONSNO_ZENIGAME,		0,  7 },
					{ MONSNO_KAMEERU,		0,  8 },
					{ MONSNO_KAMEKKUSU,		0,  9 },
					{ MONSNO_KYATAPII,		0, 10 },
					{ MONSNO_TORANSERU,		0, 11 },
					{ MONSNO_BATAHURII,		0, 12 },
					{ MONSNO_BIIDORU,		0, 13 },
					{ MONSNO_KOKUUN,		0, 14 },
					{ MONSNO_SUPIAA,		0, 15 },
					{ MONSNO_POPPO,			0, 16 },
					{ MONSNO_PIZYON,		0, 17 },
					{ MONSNO_PIZYOTTO,		0, 18 },
					{ MONSNO_KORATTA,		0, 19 },
					{ MONSNO_RATTA,			0, 20 },
					{ MONSNO_ONISUZUME,		0, 21 },
					{ MONSNO_ONIDORIRU,		0, 22 },
					{ MONSNO_AABO,			0, 23 },
					{ MONSNO_AABOKKU,		0, 24 },
					{ MONSNO_PIKATYUU,		0, 25 },
					{ MONSNO_RAITYUU,		0, 26 },
					{ MONSNO_SANDO,			0, 27 },
					{ MONSNO_SANDOPAN,		0, 28 },
					{ MONSNO_NIDORAN_F,		0, 29 },
					{ MONSNO_ONISUZUME,		1, 0 },
					{ MONSNO_ONIDORIRU,		1, 1 },
					{ MONSNO_AABO,			1, 2 },
				};
				int i;
				for(i = 0; i < NELEMS(init_param); i++)
				{
					PokePasoParaSet(ppp, init_param[i].monsno, gf_rand()%100, POW_RND, RND_NO_SET, 0, ID_NO_SET, 0);
					BOXDAT_PutPokemonPos( boxData, init_param[i].box, init_param[i].pos, ppp );
				}
				sys_FreeMemoryEz( ppp );
				flg = TRUE;
			}
		}
	}
	#endif

	{
		BOX_PROC_PARAM* param = sys_AllocMemory(HEAPID_BASE_DEBUG, sizeof(BOX_PROC_PARAM));
		param->mode = BOX_MODE_SEIRI;
		param->savedata = fsys->savedata;
		Debug_ChangeScheneReq( fsys, BoxStartCallBack, BoxEndCallBack, param );
	}
}

static void BoxStartCallBack( FIELDSYS_WORK* fsys, void* wk )
{
	FieldBox_SetProc(fsys, wk);
}
static void BoxEndCallBack( FIELDSYS_WORK* fsys, void* wk )
{
	sys_FreeMemoryEz(wk);
}



/*====================================================================================================*/
/*  ȈՉb͉ʊ֘A                                                                              */
/*====================================================================================================*/
#include "application\pms_input.h"

static void PmsStartSingle( FIELDSYS_WORK* fsys )
{
	PMSI_PARAM*  param = PMSI_PARAM_Create( PMSI_MODE_SINGLE, PMSI_GUIDANCE_DEFAULT, SaveData_GetPointer(), HEAPID_BASE_DEBUG );
	Debug_ChangeScheneReq( fsys, PmsCallbackStart, PmsCallbackEnd, param );

}
static void PmsStartDouble( FIELDSYS_WORK* fsys )
{
	PMSI_PARAM*  param = PMSI_PARAM_Create( PMSI_MODE_DOUBLE, PMSI_GUIDANCE_DEFAULT, SaveData_GetPointer(), HEAPID_BASE_DEBUG );
	Debug_ChangeScheneReq( fsys, PmsCallbackStart, PmsCallbackEnd, param );
}
static void PmsStartSentence( FIELDSYS_WORK* fsys )
{
	PMSI_PARAM*  param = PMSI_PARAM_Create( PMSI_MODE_SENTENCE, PMSI_GUIDANCE_DEFAULT, SaveData_GetPointer(), HEAPID_BASE_DEBUG );
	Debug_ChangeScheneReq( fsys, PmsCallbackStart, PmsCallbackEnd, param );
}

static void PmsCallbackStart(FIELDSYS_WORK* fsys, void* wk)
{
	FieldProc_SetPmsInput(fsys, wk);
}

static void PmsCallbackEnd(FIELDSYS_WORK* fsys, void* wk)
{
	sys_FreeMemoryEz(wk);
}

//===================================================================================================
//===================================================================================================
static BOOL GMEVENT_ChangeScheneDebug(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK* fld_wk;
	DEBUG_CHANGESCHENE_WORK* wk;

//	if( PaletteFadeCheck() != 0 ){
//		return FALSE;
//	}

	fld_wk = FieldEvent_GetFieldSysWork(event);
	wk = FieldEvent_GetSpecialWork(event);

	switch( wk->seq ){
	case 0:
		FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );
		wk->seq++;
		/* fallthru */
	case 1:
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) )
		{
			wk->start_func( fld_wk, wk->gen_wk );
			wk->seq++;
		}
		break;
	case 2:
		if (FieldEvent_Cmd_WaitSubProcEnd(fld_wk) == FALSE) {
			FieldEvent_Cmd_SetMapProc(fld_wk);
			wk->seq++;
		}
		break;
	case 3:
		if (FieldEvent_Cmd_WaitMapProcStart(fld_wk) == FALSE) {
			FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
			wk->seq++;
		}
		break;
	case 4:
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) )
		{
			if( wk->end_func )
			{
				wk->end_func( fld_wk, wk->gen_wk );
			}
			sys_FreeMemoryEz(wk);
			return TRUE;
		}
		break;
	}
	return FALSE;
}


static void Debug_ChangeScheneReq( FIELDSYS_WORK* fsys, ScheneChangeCallback start_func, ScheneChangeCallback end_func, void* gen_wk )
{
	DEBUG_CHANGESCHENE_WORK* wk = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof(DEBUG_CHANGESCHENE_WORK) );
	if( wk != NULL )
	{
		wk->seq = 0;
		wk->start_func = start_func;
		wk->end_func = end_func;
		wk->gen_wk = gen_wk;
		FieldEvent_Set(fsys, GMEVENT_ChangeScheneDebug, wk);
	}
}


#endif
