//============================================================================================
/**
 *	fobOj[n
 */
//============================================================================================
#include "common.h"
#include "system/lib_pack.h"
#include "system/bmp_list.h"
#include "field/field.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "system/fontproc.h"
#include "fld_bmp.h"
#include "system/pm_str.h"
#include "vm.h"
#include "script.h"
#include "scrcmd.h"
#include "sxytype.h"
#include "system/snd_tool.h"
#include "system/palanm.h"

//============================================================================================
//	C
//============================================================================================
#define	TCB_WK_SIZE		( 4*16 )
#define	DEBUG_WK_SIZE	( 32 )

enum {
	WK_SEQ = 0,
//	WK_WIN_INDEX,
//	WK_LIST_ID,
	WK_LIST_RET,

	WK_MAX
};

typedef struct {
	void * fsys;
	GF_BGL_BMPWIN	win;
	BMPLIST_WORK * lw;
	u32	bmp_work[WK_MAX];
	u32	work[DEBUG_WK_SIZE];
}D_WATANABE_PARAM;

typedef void (*pHNfunc)(void *);

//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
void DebugWatanabeMenuInit( void * fsys );
static void DS_MenuMain( TCB_PTR _tcb, void * work );
static void DS_MenuExit( D_WATANABE_PARAM * wk );

static void Debug_Watanabe_Test1_Set( D_WATANABE_PARAM * wk );
static void Debug_Watanabe_Test2_Set( D_WATANABE_PARAM * wk );
//--------------------------------------------------------------------------------------------
//--------------------------------------------------------------------------------------------
static const STRCODE menu_msg01[] = { te_,su_,to_,n1_,EOM_ };
static const STRCODE menu_msg02[] = { te_,su_,to_,n2_,EOM_ };
static const STRCODE menu_msg03[] = { te_,su_,to_,n3_,EOM_ };
static const STRCODE menu_msg04[] = { te_,su_,to_,n4_,EOM_ };
static const STRCODE menu_msg05[] = { te_,su_,to_,n5_,EOM_ };

static const BMPLIST_DATA d_menu_list[] =
{
	{ (const void *)menu_msg01, (u32)Debug_Watanabe_Test1_Set },
	{ (const void *)menu_msg02, (u32)Debug_Watanabe_Test2_Set },
	{ (const void *)menu_msg03, (u32)NULL },
	{ (const void *)menu_msg04, (u32)NULL },
	{ (const void *)menu_msg05, (u32)NULL },
};

static const BMPLIST_HEADER d_menu_list_h = {
	d_menu_list,			// \f[^|C^
	NULL,					// J[\ړƂ̃R[obN֐
	NULL,					// \Ƃ̃R[obN֐
	NULL,
	NELEMS(d_menu_list),	// Xgڐ
	5,						// \ő區ڐ
	0,						// x\wW
	12,						// ڕ\wW
	0,						// J[\\wW
	0,						// \xW
	FBMP_COL_WHITE,			//F
	FBMP_COL_BLACK,			//wiF
	FBMP_COL_BLK_SDW,		//eF
	0,						// Ԋuw
	16,						// Ԋux
	BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
	FONT_SYSTEM,			// w({ u8 ǁAȂɍȂƎv̂)
	0						// afJ[\(allow)\tO(0:ON,1:OFF)
};



void DebugWatanabeMenuInit( void * fsys )
{
	D_WATANABE_PARAM * wk;
	GF_BGL_INI * bgl;
	BMPLIST_HEADER	list_h;

	bgl = FieldBglIniGet( fsys );

	wk = (D_WATANABE_PARAM *)TCB_GetWork(
				PMDS_taskAdd( DS_MenuMain, sizeof(D_WATANABE_PARAM), 0, HEAPID_BASE_DEBUG ) );

	wk->fsys = fsys;
	wk->bmp_work[ WK_SEQ ] = 0;
	GF_BGL_BmpWinAdd( bgl, &wk->win, FLD_MBGFRM_FONT, 1, 1, 10, 12, 13, 1 );

	list_h = d_menu_list_h;
	list_h.win = &wk->win;
	wk->lw = BmpListSet( &list_h, 0, 0, HEAPID_BASE_DEBUG );

	GF_BGL_BmpWinOn( &wk->win );
}

static void DS_MenuMain( TCB_PTR _tcb, void * work )
{
	D_WATANABE_PARAM * wk = (D_WATANABE_PARAM *)work;
	GF_BGL_INI * bgl;
	u32	ret;

	switch( wk->bmp_work[ WK_SEQ ] ){
	case 0:
		ret = BmpListMain( wk->lw );

		switch( ret ){
		case BMPLIST_NULL:
			break;
		case BMPLIST_CANCEL:
			DS_MenuExit( wk );
			PMDS_taskDel( _tcb );
			FieldSystemProc_SeqHoldEnd();
			break;
		default:
			wk->bmp_work[WK_LIST_RET] = ret;
			wk->bmp_work[WK_SEQ]++;
		}
		break;
	case 1:
		{
			pHNfunc func = (pHNfunc)wk->bmp_work[WK_LIST_RET];
			void * fsys = wk->fsys;

			func( wk );
			DS_MenuExit( wk );
			PMDS_taskDel( _tcb );
		}
	}
}

static void DS_MenuExit( D_WATANABE_PARAM * wk )
{
	BmpListExit( wk->lw, NULL, NULL );

	GF_BGL_BmpWinOff( &wk->win );
	GF_BGL_BmpWinDel( &wk->win );
}




//============================================================================================
//	TuvZXݒ
//============================================================================================
//----------------------------------
// ^CgS
//----------------------------------
extern const PROC_DATA Title_Logo_Demo_proc_data;

static void Debug_Watanabe_Test1_Set( D_WATANABE_PARAM * wk )
{
	GameSystem_StartSubProc(wk->fsys, &Title_Logo_Demo_proc_data,NULL);
}

//----------------------------------
// ^CgS
//----------------------------------
extern const PROC_DATA Earth_Logo_Demo_proc_data;

static void Debug_Watanabe_Test2_Set( D_WATANABE_PARAM * wk )
{
	GameSystem_StartSubProc(wk->fsys, &Earth_Logo_Demo_proc_data,NULL);
}



#if 0
//================================================================
typedef struct EARTH_DEMO_WORK_tag
{
	GF_BGL_INI * bgl;						// BGLf[^
	int work[16];

	NNSG3dRenderObj			renderobj;
	NNSG3dResMdl*			resmodel;
	NNSG3dResFileHeader* 	resfileheader;

	VecFx32 trans;	//W
	VecFx32 scale;	//XP[
	VecFx32	rotate;	//]	

	GF_CAMERA_PTR camera_p;

	u16	rotate_speed;
	u16	end_flg;
}EARTH_DEMO_WORK;

enum{
	EARTHDEMO_SEQ_MODELLOAD,//ff[^[h
	EARTHDEMO_SEQ_DISPON,	//`nm
	EARTHDEMO_SEQ_MOVE_IN,	//C
	EARTHDEMO_SEQ_MOVE_SET,	//
	EARTHDEMO_SEQ_FLUSH1,	//tbV
	EARTHDEMO_SEQ_FLUSH2,	//
	EARTHDEMO_SEQ_END,		//I
};

static void EarthLogo_VramBankSet(void);
static void EarthLogo_BGSet(void);
static PROC_RESULT Earth_Logo_Demo_Init(PROC * proc, int * seq);
static PROC_RESULT Earth_Logo_Demo_Main(PROC * proc, int * seq);
static PROC_RESULT Earth_Logo_Demo_Exit(PROC * proc, int * seq);
static void EarthLogo_ModelLoad( EARTH_DEMO_WORK * wk );
static void EarthLogo_ModelRelease( EARTH_DEMO_WORK * wk );
static void EarthLogo3D_Draw( EARTH_DEMO_WORK * wk );

	// vZX`f[^
const PROC_DATA Earth_Logo_Demo_proc_data = {
	Earth_Logo_Demo_Init,
	Earth_Logo_Demo_Main,
	Earth_Logo_Demo_Exit,
	NO_OVERLAY_ID,
};

extern void		Main_SetNextProc(FSOverlayID ov_id, const PROC_DATA * proc_data);

#define HEAPID_EARTH_DEMO (HEAPID_TITLE_DEMO)
//================================================================
static PROC_RESULT Earth_Logo_Demo_Init(PROC * proc, int * seq)
{
	EARTH_DEMO_WORK * wk;

	sys_VBlankFuncChange( NULL, NULL );	// VBlankZbg
	sys_HBlankIntrSet( NULL,NULL );		// HBlankZbg

	EarthLogo_VramBankSet();

	GF_Disp_GX_VisibleControlInit();
	GF_Disp_GXS_VisibleControlInit();
	GX_SetVisiblePlane( 0 );
	GXS_SetVisiblePlane( 0 );
	EarthLogo_BGSet();
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_OFF );

	sys_KeyRepeatSpeedSet( 4, 8 );
	sys_CreateHeap( HEAPID_BASE_APP, HEAPID_EARTH_DEMO, 0x100000 );

	wk = PROC_AllocWork( proc, sizeof(EARTH_DEMO_WORK), HEAPID_EARTH_DEMO );
	memset( wk, 0, sizeof(EARTH_DEMO_WORK) );
	wk->bgl = GF_BGL_BglIniAlloc( HEAPID_EARTH_DEMO );

	simple_3DBGInit( HEAPID_EARTH_DEMO );
	wk->camera_p = GFC_AllocCamera( HEAPID_EARTH_DEMO );

	GF_Disp_DispOn();

	return	PROC_RES_FINISH;
}

//----------------------------------
static PROC_RESULT Earth_Logo_Demo_Main(PROC * proc, int * seq)
{
	EARTH_DEMO_WORK * wk  = PROC_GetWork( proc );

	switch(*seq){

	case EARTHDEMO_SEQ_MODELLOAD://ff[^[h

		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_OFF );//[hJnFRcʂnee
		EarthLogo_ModelLoad(wk);//f[hC
		{
			//ff[^p[^
			VecFx32 init_trans	= {0,0,0};
			VecFx32 init_scale	= {FX32_ONE, FX32_ONE, FX32_ONE};
			VecFx32 init_rotate = {0, 0, 0};

			wk->trans	= init_trans;
			wk->scale	= init_scale;
			wk->rotate  = init_rotate;
		}
		{
			//Jݒ
			VecFx32	target_pos	= {0,0,0};
			VecFx32	camera_pos	= {0,0,0x128000};
			CAMERA_ANGLE angle	= {0,0,0};
			fx32	distance	= 0x128000;
			u16		perspway	= 0x05c1;

			//InitCameraTDA(&target_pos,distance,&angle,perspway,GF_CAMERA_PERSPECTIV,wk->camera_p);
			GFC_InitCameraCDA(&camera_pos,distance,&angle,perspway,GF_CAMERA_PERSPECTIV,wk->camera_p);
			GFC_SetCameraClip(0,FX32_ONE*100,wk->camera_p);	//Nbvݒ(near-far)
			GFC_SetCameraView(GF_CAMERA_PERSPECTIV,wk->camera_p);
			GFC_AttachCamera(wk->camera_p);
		}
		{
			//Cgݒ
			NNS_G3dGlbLightVector(0, FX32_ONE/2, 0, FX32_ONE);
		}
		EarthLogo3D_Draw(wk);//Rc`GW
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0 , VISIBLE_ON );//[hIFRcʂnm

		//PxύXZbgihmj
		ChangeBrightnessRequest (2,	//EFCg
								BRIGHTNESS_NORMAL,	// BPx
								BRIGHTNESS_BLACK,	// JnPx
								PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);//Ώۖ

		*seq = EARTHDEMO_SEQ_DISPON;

		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_DISPON:	//`nm

		EarthLogo3D_Draw(wk);//Rc`GW

		wk->end_flg = 0;
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			*seq = EARTHDEMO_SEQ_MOVE_IN;
		}
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_MOVE_IN:	//C
#if 0
		if((sys.trg & PAD_BUTTON_A)||(sys.trg & PAD_BUTTON_START)){
			*seq = EARTHDEMO_SEQ_FLUSH2;
			break;
		}
		EarthLogo3D_Draw(wk);//Rc`GW
		{
			//]
			wk->rotate_speed = 0x200;
			wk->rotate.x += wk->rotate_speed;
			wk->rotate.y += wk->rotate_speed;
			wk->rotate.z += wk->rotate_speed;
		}
		if(wk->trans.z == (-FX32_ONE*64)){
			*seq = EARTHDEMO_SEQ_MOVE_SET;
			break;
		}
		{
			//ړ
			if(wk->trans.z != (-FX32_ONE*64)){
				wk->trans.z -= (FX32_ONE*4);
			}
		}
#else
		wk->rotate_speed = 0x200;
		if(sys.trg & PAD_BUTTON_A){
			break;
		}
		if(sys.cont & PAD_KEY_LEFT){
			CAMERA_ANGLE angle	= {0,FX32_ONE/8,0};
			GFC_AddCameraAngleRev(&angle,wk->camera_p);
		}
		if(sys.cont & PAD_KEY_RIGHT){
			CAMERA_ANGLE angle	= {0,-FX32_ONE/8,0};
			GFC_AddCameraAngleRev(&angle,wk->camera_p);
		}
		if(sys.cont & PAD_KEY_UP){
			CAMERA_ANGLE angle	= {FX32_ONE/8,0,0};
			GFC_AddCameraAngleRev(&angle,wk->camera_p);
		}
		if(sys.cont & PAD_KEY_DOWN){
			CAMERA_ANGLE angle	= {-FX32_ONE/8,0,0};
			GFC_AddCameraAngleRev(&angle,wk->camera_p);
		}
		EarthLogo3D_Draw(wk);//Rc`GW
#endif
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_MOVE_SET:	//C

		if((sys.trg & PAD_BUTTON_A)||(sys.trg & PAD_BUTTON_START)){
			*seq = EARTHDEMO_SEQ_FLUSH2;
			break;
		}
		EarthLogo3D_Draw(wk);//Rc`GW

		if(wk->end_flg == 1){
			//PxύXZbgitbVj
			ChangeBrightnessRequest (2,	//EFCg
									BRIGHTNESS_WHITE,	// BPx
									BRIGHTNESS_NORMAL,	// JnPx
									PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);	//Ώۖ
			*seq = EARTHDEMO_SEQ_FLUSH1;
			break;
		}
		{
			//]
			wk->rotate_speed = 0x100;
			wk->rotate.x += wk->rotate_speed;
			wk->rotate.y += wk->rotate_speed;
			wk->rotate.z += wk->rotate_speed;

			if(((wk->rotate.y & 0xffff) == 0) && (wk->trans.z == 0)){
				wk->end_flg++;
			}
		}
		{
			//ړ
			if(wk->trans.z){
				wk->trans.z += (FX32_ONE*2);
			}
		}
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_FLUSH1:	//tbV(seq 3-4)

		EarthLogo3D_Draw(wk);//Rc`GW
		
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			ChangeBrightnessRequest (2,	//EFCg
									BRIGHTNESS_NORMAL,	// BPx
									BRIGHTNESS_WHITE,	// JnPx
									PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);	//Ώۖ
			*seq = EARTHDEMO_SEQ_FLUSH2;
		}
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_FLUSH2:	//tbV

		EarthLogo3D_Draw(wk);//Rc`GW
		
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			//PxύXZbgintsj
			ChangeBrightnessRequest (8,	//EFCg
									BRIGHTNESS_WHITE,	// BPx
									BRIGHTNESS_NORMAL,	// JnPx
									PLANEMASK_ALL,MASK_DOUBLE_DISPLAY);	//Ώۖ
			*seq = EARTHDEMO_SEQ_END;
		}
		return	PROC_RES_CONTINUE;

	case EARTHDEMO_SEQ_END:	//I

		EarthLogo3D_Draw(wk);//Rc`GW
		
		if(IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) == TRUE){	//PxύX҂
			EarthLogo_ModelRelease( wk );
			(*seq) = 0;
			//return	PROC_RES_FINISH;
			return	PROC_RES_CONTINUE;
		}
		return	PROC_RES_CONTINUE;
	}
	return	PROC_RES_CONTINUE;
}

//----------------------------------
static PROC_RESULT Earth_Logo_Demo_Exit(PROC * proc, int * seq)
	
{
	EARTH_DEMO_WORK * wk  = PROC_GetWork( proc );

	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 |
		GX_PLANEMASK_BG3 | GX_PLANEMASK_OBJ, VISIBLE_OFF );
	GF_Disp_GXS_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_OBJ, VISIBLE_OFF );

	GFC_FreeCamera(wk->camera_p);
	simple_3DBGExit();
	sys_FreeMemoryEz(wk->bgl);

	PROC_FreeWork( proc );				// [NJ

	sys_VBlankFuncChange( NULL, NULL );		// VBlankZbg
	sys_DeleteHeap( HEAPID_EARTH_DEMO );

	//Main_SetNextProc(NO_OVERLAY_ID, &TitleProcData);
	return	PROC_RES_FINISH;
}

//----------------------------------
//uq`lݒ
//----------------------------------
static void EarthLogo_VramBankSet(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//----------------------------------
//afݒ
//----------------------------------
static void EarthLogo_BGSet(void)
{
	{//BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_0,GX_BGMODE_0,GX_BG0_AS_3D
		};	
		GF_BGL_InitBG(&BGsys_data);
	}
}

//----------------------------------
//Rcf[^[h֐
//----------------------------------
static void EarthLogo_ModelLoad( EARTH_DEMO_WORK * wk )
{
	simple_3DModelSet(	HEAPID_EARTH_DEMO,
						"data/wifi_earth.nsbmd",
						&wk->renderobj,
						&wk->resmodel,
						&wk->resfileheader);
}

static void EarthLogo_ModelRelease( EARTH_DEMO_WORK * wk )
{
	sys_FreeMemoryEz(wk->resfileheader);
}

//----------------------------------
//Rc`֐
//----------------------------------
static void EarthLogo3D_Draw( EARTH_DEMO_WORK * wk )
{
	MtxFx33 rotate_tmp = {FX32_ONE,0,0,0,FX32_ONE,0,0,0,FX32_ONE};

	GF_G3X_Reset();
	GFC_CameraLookAt();
#if 0
	//GbW}[LOeXg
	NNS_G3dGlbPolygonAttr(
				TMAP_MLIGHT_FLAG,			// Cg   
				GX_POLYGONMODE_MODULATE,	// ʏ̃|S[h
				GX_CULL_BACK,				// JobNs
				20,							//|SID
				8,							// At@l
				GX_POLYGON_ATTR_MISC_NONE/*GX_POLYGON_ATTR_MISC_XLU_DEPTH_UPDATE*/);
#endif
	{
		VecFx32_to_MtxFx33(	&rotate_tmp,&wk->rotate);

		simple_3DModelDraw(	&wk->renderobj,
							&wk->trans,
							&rotate_tmp,
							&wk->scale);
	}

	GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO,GX_BUFFERMODE_W);
}

//----------------------------------
//TuvZXݒ
//----------------------------------
static void Debug_Watanabe_Test2_Set( D_WATANABE_PARAM * wk )
{
	// vZX`f[^
	static const PROC_DATA proc_data = {
		Earth_Logo_Demo_Init,
		Earth_Logo_Demo_Main,
		Earth_Logo_Demo_Exit,
		NO_OVERLAY_ID,
	};
	GameSystem_StartSubProc(wk->fsys, &proc_data,NULL);
}

#endif






