//=============================================================================
/**
 * @file	d_tomo.c	
 * @bfief	c(q)pfobO[`
 * @author	tomo
 * @date	05/01/26
 */
//=============================================================================
#include <nitro.h>
#include <nnsys.h>
#include "common.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "fld_bmp.h"
#include "system/lib_pack.h"
#include "fntsys.h"
#include "system/fontproc.h"
#include "talk_msg.h"
#include "fieldsys.h"
extern void AGB_MapExit(void);
extern void FieldBitMapWinCgxSet(void);

//=============================================================================
// ֘A
//=============================================================================
static const u16 ALIGN4 str_tmenu_end[] = { to_,zi_,ru_,EOM_ };

//=============================================================================
//=============================================================================
static void DebugTomoMenuEnd(TCB_PTR tcb,void* work);

void DebugTomoInit(void);
static void DebugTomoMain(TCB_PTR tcb,void* work);
static void DebugTomoEnd(TCB_PTR tcb,void* work);

//=============================================================================
//=============================================================================
//------------------------------------------------------------------
///	j[Xgf[^
//------------------------------------------------------------------
static const BMPLIST_DATA DebugListTomo[] =
{
	{ str_tmenu_end, (u32)DebugTomoMenuEnd}			//01:
};

//------------------------------------------------------------------
//------------------------------------------------------------------
#define D_TOMO_LIST_NUM	NELEMS(DebugListTomo)

//------------------------------------------------------------------
///	fobOVXep\
//------------------------------------------------------------------
typedef struct _DebugWork{
	u8	ct;
	u8	work;
	u8	page;
	u8	task_id;
	u8	win_id;

	pFunc	Userfunc;
	u8		UserWindow;
	u8		blistID;
	u16		List;
	u16		Cursor;
//	BMPLIST_HEADER	bmplist_h;
}_DebugWork;

//------------------------------------------------------------------
//------------------------------------------------------------------
#define DW0_CGX	(1)
#define DW0_SX	(10)
//#define DW0_SY	(14)
#define DW0_SY	(7)
#define DW0_CGXNUM	(DW0_SX*DW0_SY)
#define DW0_PAL	(15)

static const BMPWIN_DAT d_tomo_BmpDat[] = {
 {GF_BGL_FRAME3_M,  1,  1, DW0_SX, DW0_SY, DW0_PAL, DW0_CGX },
 { 0xFF, 0, 0, 0, 0, 0, 0 },
};

//------------------------------------------------------------------
///	ڃXgf[^
//------------------------------------------------------------------
#if 0
static const BMPLIST_HEADER DebugListHeader = {
	DebugListTomo,			//\f[^|C^
	NULL,				//J[\ړƂ̃R[obN֐
	NULL,		//PsƂ̃R[obN֐
	D_TOMO_LIST_NUM,	//Xgڐ
	D_TOMO_LIST_NUM,	//\ő區ڐ
	0,					//gprbg}bvhmcdw(Őݒ)
	2,					//x\wW
	12,					//ڕ\wW
	1,					//J[\\wW
	2,					//\xW
	FBMP_COL_WHITE,		//F
	FBMP_COL_BLACK,		//wiF
	FBMP_COL_BLK_SDW,	//eF
	0,					//Ԋuw
	1,					//Ԋux
	BMPLIST_LRKEY_SKIP,	//y[WXLbv^Cv
	POKE_SYSTEM,		//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
};
#endif

//-----------------------------------------------------------------
//------------------------------------------------------------------

//=============================================================================
/**
 *	fobOVXe
 *
 *	u8	DebugTomoInit(void)
 *
 *	@param	none
 *	@return none
 */
//=============================================================================
void DebugTomoInit(void)
{
	TCB_PTR	pTcb = NULL;
	_DebugWork *wp = NULL;

	//fobOVXem
	wp = sys_AllocMemory(HEAPID_BASE_DEBUG,sizeof(_DebugWork));
	if(wp == NULL){
		//[NmۂłȂΉȂ
		return;
	}
	memset(wp,0,sizeof(_DebugWork));

	//EBhELN^Zbg
	FieldBitMapWinCgxSet();

#if 0	//Makeʂ点邽߂O
	//BMPMAPj[ǉ
	wp->win_id = (u8)GF_BGL_BmpAdd2(d_tomo_BmpDat);
#endif

	//BMPXgݒ
//	memcpy(&(wp->bmplist_h),&DebugListHeader,sizeof(BMPLIST_HEADER));
//	wp->bmplist_h.index = wp->win_id;
//	wp->Cursor = 1;
	wp->Cursor = 0;
#if 0	//Makeʂ点邽߂O
	wp->blistID = BmpListSet(&wp->bmplist_h,wp->List,wp->Cursor);
#endif

	//C^XNǉ
	pTcb = TCB_Add(DebugTomoMain,wp,0);
	
	//OBJ̓~
//	sys.mainSys_sequence = SEQ_APTASK_HOLD;
}

//=============================================================================
/**
 *	fobOVXeL[擾(C^XN)
 *	void DebugTomoMain(u8 id);
 *
 *	@param	tcb	TCB_PTR	^XNubN|C^	
 *	@param	work	^XN[N|C^	
 *	@return	none
 */
//=============================================================================
static void DebugTomoMain(TCB_PTR tcb,void* work)
{
	s32	ret_code;
	TCB_FUNC	func;
	_DebugWork	*wp;
	
	wp = (_DebugWork*)work;

#if 0	//Makeʂ点邽߂O
	ret_code = BmpListMain(wp->blistID);
#endif

	//L[씻
	if(sys.trg & PAD_BUTTON_A){
		if(ret_code){
			func = (TCB_FUNC)ret_code;
			func(tcb,work);
		}
		return;
	}
	//j[LZ
	if(sys.trg & PAD_BUTTON_B){
		DebugTomoEnd(tcb,work);
		return;
	}
}

//=============================================================================
/**
 *	fobOj[̏I
 *
 *	fobOj[p[NƃXg̔js
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 */
//=============================================================================
static void DebugTomoEnd(TCB_PTR tcb,void* work)
{
	_DebugWork	*wp = NULL;

	wp = (_DebugWork*)work;

#if 0	//Makeʂ点邽߂O
	//BMPWINj
	GF_BGL_BmpOff(wp->win_id);	//WindowOFF
	//BMPXg̊J
	BmpListExit(wp->blistID,&(wp->List),&(wp->Cursor));	//Xgj
	GF_BGL_BmpDel(wp->win_id);	//BMPWindowDel
#endif

	//^XN
	PMDS_taskDel( tcb );
//	sys_FreeMemory(HEAPID_BASE_DEBUG,work);
//	TCB_Delete(tcb);
	FieldSystemProc_SeqHoldEnd();

	//OBJ̓~
//	sys.mainSys_sequence = SEQ_MAIN;
	return;
}

//=============================================================================
/**
 *	fobOj[
 *
 *	@param	tcb		TCB_PTR:Ăяo^XNubNւ̃|C^
 *	@param	work	void*:Ăяo^XNubN[Nւ̃|C^
 *	@return	none
 */
//=============================================================================
static void DebugTomoMenuEnd(TCB_PTR tcb,void* work)
{
	DebugTomoEnd(tcb,work);	
}


//=============================================================================
//=============================================================================
