#include "common.h"

#include "system/lib_pack.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "fld_bmp.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "fieldmap_work.h"
#include "system/fontproc.h"

#include "d_tomoya.h"
#include "system/touchpanel_draw.h"
#include "field_light.h"
#include "fog_sys.h"
#include "weather_sys.h"
#include "field_glb_state.h"

#include "encount_effect.h"
#include "effect_uground.h"

#include "system/clact_util.h"
#include "system/render_oam.h"
#include "field_event.h"
#include "system/wipe.h"


#include "msgdata/msg.naix"
#include "msgdata/msg_debug_tomoya.h"

#include "include/application/imageClip/imc_playsys.h"
#include "include/application/imageClip/imc_sys.h"
#include "include/savedata/imageclip_data.h"

#include "poketool/poke_tool.h"
#include "include/application/zukanlist/zkn_sys.h"

#include "src/field/ev_time.h"


static FIELDSYS_WORK* D_TomoyaFldSys;


static GF_BGL_BMPWIN* initBmpWin(int num);
static void delBmpWin(GF_BGL_BMPWIN* data);
static void PrintString( GF_BGL_BMPWIN* win, u32 fontID, MSGDATA_MANAGER* man, u32 strid, u32 xofs, u32 yofs, u32 wait, pStrPrintCallBack call_back );


//-----------------------------------------------------------------------------
/**
 *		}ӃvbNJn
 */
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
/**
 *
 * ŃGtFNg
 *
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	[N	
//	
//=====================================
typedef struct {
	int		next_count;
	int		count;
	int		num;
	int		seq;
	GF_CAMERA_PTR	camera;
} D_TOMOYA_POISON;
static void StartPoison( TCB_PTR tcb,void* work );		//	
static void MainPoison( TCB_PTR tcb,void* work );		//	



//-----------------------------------------------------------------------------
/**
 *
 *		C[WNbvvC[\`FbN
 * 
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	[N
//	
//=====================================
typedef struct {
	IMC_PLAYERSYS_PTR	p_player;

	TCB_PTR	v_tcb;		// VuN֐̃^XN
} D_TOMOYA_IMC_PLAY;
static void StartImcPlay( TCB_PTR tcb,void* work );		//	C[WNbvvC[
static void MainImcPlay( TCB_PTR tcb,void* work );		//	C[WNbvvC[
static void VblankImcPlay( TCB_PTR tcb,void* work );		//	C[WNbvvC[



//-----------------------------------------------------------------------------
/**
*		eNX`f[^]`FbNVXe
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	]f[^
//	
//=====================================
typedef struct {
	
	void* tex_buff;				// eNX`obt@
	NNSG3dResTex*	tex_res;	// eNX`\[X
	int		trans_num;			// ]
	int		trans_size;			// ]TCY
	int		vram;
} D_TM_TEX_TRANS;
static void StartTexTrans( TCB_PTR tcb,void* work );		// eNX`f[^]`FbN
static void MainTexTrans( TCB_PTR tcb,void* work );			// eNX`f[^]`FbN



//-----------------------------------------------------------------------------
/**
*		Cv`FbN
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	Cv`FbN^XN\
//	
//=====================================
typedef struct{
	int no;		// Cvio[
	int seq;
	BOOL end_flg;
}D_TMY_WIPE;

//-----------------------------------------------------------------------------
//			vg^Cv
//=============================================================================
static void StartWipe( TCB_PTR tcb,void* work );		// ʐ؂ւJn
static void MainWipe( TCB_PTR tcb,void* work );			// ʐ؂ւC




//-----------------------------------------------------------------------------
//			\
//=============================================================================
//-------------------------------------
//	
//	XvCg\邽߂ɕKvȕ
//	
//=====================================
typedef struct {
	int seq;
	int sub;
	int tmp_seq;
	void* p_pearent;
} DT_SPRITE_CHECK;


//-----------------------------------------------------------------------------
//			vg^Cv
//=============================================================================
//@C[WNbvJn
static void StartSprite_Check( TCB_PTR tcb,void* work );	// XvCgAN^[Jn
static void MainSprite_Check( TCB_PTR tcb, void* work );
;
// }ӊJn
static void StartZukan_Check( TCB_PTR tcb, void* work );
static void MainZukan_Check( TCB_PTR tcb, void* work );

// Jn|PI
static void StartEvPokeSelect_Check( TCB_PTR tcb, void* work );
static void MainEvPokeSelect_Check( TCB_PTR tcb, void* work );


//============================================================================
//
//		ZAN^[`FbNp
//					JnVXe
//
//
//=============================================================================
//-----------------------------------------------------------------------------
//			\
//=============================================================================
//-------------------------------------
//	
//	Z\邽߂ɕKvȕ
//	
//=====================================
typedef struct {
	CLACT_SET_PTR		clactSet;		// ZAN^[Zbg
	CLACT_HEADER_TBL_PTR	clactHeader;	// wb_[
	CLACT_U_RES_MANAGER_PTR	resMan[6];		// \[X}l[W
	CLACT_U_RES_HEADER_PTR	resHeader;		// \[Xwb_
	CLACT_U_RES_OBJ_TBL*	resObjTbl[2];	// \[XIuWFe[u
	int						resObjNum[6];	// ꂼ̃\[XIuWF
	CLACT_U_EASYRENDER_DATA		renddata;	// ȈՃ_[f[^

	NNSG2dCellTransferState*	cellTransArray;	// ZVram]}l[W[̈

	CLACT_WORK_PTR	clact_w[10];
	int add_num;	// o^
	TCB_PTR tcb;	// tcb
} DT_CLACT;

static DT_CLACT* DT_clact = NULL;

//-----------------------------------------------------------------------------
//			vg^Cv
//=============================================================================
static void StartCLACT_Check( TCB_PTR tcb,void* work );		// ZAN^[Jn
static void MainCLACT_Check( TCB_PTR tcb,void* work );		// ZAN^[C
static void EndCLACT_Check( TCB_PTR tcb,void* work );		// ZAN^[I
;

//============================================================================
//		GJEgGtFNg
//			JnVXe
//
//
//=============================================================================
//-----------------------------------------------------------------------------
//			\
//=============================================================================
typedef struct{
	int	no;
	int	flag;
}D_TMY_ENC;
//-----------------------------------------------------------------------------
//			vg^Cv
//=============================================================================
static void StartEncount( TCB_PTR tcb,void* work );		// GJEgJn
static void MainEncount( TCB_PTR tcb,void* work );		// GJEgC




//============================================================================
//		}eA
//
//			}eÅ֐f[^
//
//
//=============================================================================

//-----------------------------------------------------------------------------
//			\
//=============================================================================
//-------------------------------------
//	Cgf[^\
typedef struct{
	u32			lightEnd;	// CgɕύX
	
	u8			lightFlag;		// Cg`tO
	GXRgb		lightColor[4];	// Cg̐F
	VecFx16		lightVec[4];	// Cg̕
	
	GXRgb		diffuse;		// fBt[YF	î̐Fj
    GXRgb		ambient;		// ArGgF	ij
	GXRgb		specular;		// XyL[F	iƂ̐Fj
	GXRgb		emission;		// ːF
}LIGHT_CONT_DATA;

LIGHT_CONT_DATA* DebugMaterial;

//-------------------------------------
//	
//	P\Zbg	
//	
//=====================================
typedef struct _LIGHT_CONT_SET{
	u32		DataNum;				// f[^
	LIGHT_CONT_DATA* pDataTbl;		// f[^e[u
	int Light_Num;					// LIGHTio[
	GLST_DATA_PTR	Glb;			// O[oXe[g̏ԕۑ̈
} LIGHT_CONT_SET;



enum{
	DEB_MATE_LIGHT_END=0,
	DEB_MATE_LIGHT_FLAG,
	DEB_MATE_LIGHT_COLOR_0,
	DEB_MATE_LIGHT_COLOR_1,
	DEB_MATE_LIGHT_COLOR_2,
	DEB_MATE_LIGHT_COLOR_3,
	DEB_MATE_LIGHT_VEC_0,
	DEB_MATE_LIGHT_VEC_1,
	DEB_MATE_LIGHT_VEC_2,
	DEB_MATE_LIGHT_VEC_3,
	DEB_MATE_DIFFUSE,
	DEB_MATE_AMBIENT,
	DEB_MATE_SPECULAR,
	DEB_MATE_EMISSION,
	DEB_WIN,					// fobNEBhEɃL[̑
	DEB_MATE_NUM
};

#define D_M_MENU_X		(8)
#define D_M_MENU_Y		(8)

#define D_M_MENU_SPACE_Y	(8)
#define D_M_MENU_SPACE_X	(16)

#define D_M_NUM_X		(64)
#define D_M_KEY_X		(128)

#define	D_M_0		(28)
#define	D_M_1		(48)
#define	D_M_2		(68)
#define	D_M_3		(88)
#define D_M_SELECT	(108)

#define	MT_INPUT_MAX	(12)
#define MT_INPUT_MIN	(0)
#define MT_INPUT_SUB	(4)

#define MT_ROTA_DEF		(90*182)
#define MT_ROT_GET(x)		((0xffff/360)*(x))
//-----------------------------------------------------------------------------
//			vg^Cv
//=============================================================================

static void StartMaterialWindow( TCB_PTR tcb,void* work );	// }eÃfobNEBhEJn
static void MainMaterialWindow( TCB_PTR tcb,void* work );	// }eÃfobNEBhEC
static void EndMaterialWindow( TCB_PTR tcb,void* work );	// }eÃfobNEBhEI

static void DrawMenu( u32 num );				// MenuƏ`
static void DrawNum( s32 num, u32 x, u32 y, GF_BGL_BMPWIN* win );// ̕`
static u8 NumInput(u32* num, u32 add, u32 limit);		// ̓
static u8 ColorInput( s16* num );				// F̓
static u8 VecInput(u16* rotaY, u16* rotaXZ);	// xNg
static void DrawRGB( GXRgb num );				// F̕`

static void SetVecRota( u16* rotaY, u16* rotaXZ, fx32 X, fx32 Y, fx32 Z );
static void SetVecsRotas( u16* rotaY, u16* rotaXZ, LIGHT_CONT_DATA* light );


//-----------------------------------------------------------------------------
//			ϐ
//=============================================================================
static int	MaterialDataNo = 0;

static u8	MaterialWinFlag=0;
static TCB_PTR	materialTCBData;
static int MaterialCount;			// JE^
static u16 MaterialrotaY[ 4 ];					// ]pY
static u16 MaterialrotaXZ[ 4 ];					// ]pXZ

static int MT_InputCount;			// ̓JE^
static int MT_InputNow;				// ̓͑҂
static GF_BGL_BMPWIN* D_M_win;		// EBhE


// ^CgS
static const u16 pD_M_str[] = {
	D_M_str14,
	D_M_str00,
	D_M_str01,
	D_M_str02,
	D_M_str03,
	D_M_str04,
	D_M_str05,
	D_M_str06,
	D_M_str07,
	D_M_str08,
	D_M_str09,
	D_M_str10,
	D_M_str11,
	D_M_str12,
	D_M_str13
};


//============================================================================
//		tHO
//
//			tHO̐ݒAI
//
//
//=============================================================================
//-----------------------------------------------------------------------------
//			\
//=============================================================================
//-----------------------------------------------------------------------------
//			vg^Cv
//=============================================================================
static void StartFog( TCB_PTR tcb,void* work );	// tHOݒ
static void MainFog( TCB_PTR tcb,void* work);	// tHOC
static void EndFog( TCB_PTR tcb,void* work );	// tHOI

static void InputFog( int num );
static void DrawFog( int num );

//-----------------------------------------------------------------------------
//			ϐ
//=============================================================================
u8	FogFlag=0;
static TCB_PTR	FogTCBData;
static u8	Fog_DrawFlag = 0;

NNSG3dResMdl* groundMdl;

static int FOG_Count = 0;			// 삵Ă邱
static int FOG_InputCount;			// ̓JE^
static int FOG_InputNow;			// ̓͑҂
static GF_BGL_BMPWIN* FOG_win;		// EBhE
static int FOG_TBL_Count=0;			// tHOe[u삵ĂƂ

// S

static const u16	fog_title[]={
	fog_title00,
	fog_title01,
	fog_title02,
	D_M_str13
};

enum{
	FOG_NORMAL_SET,
	FOG_COLOR_SET,
	FOG_TBL_SET,
	FOG_D_W,
	FOG_TITLE_NUM
};
#define		FOG_OFS_ADD	(0x20)

//#define		FOG_BG_ON
#ifdef FOG_BG_ON

static void BG2Move(TCB_PTR tcb,void* work);	// BG2𓮂^XN
#define		FOG_BG_SCROLL_COUNT	(1)
#define		FOG_BG_SCROLL_PAR	(4)
static TCB_PTR	FOG_BG_TASK = NULL;
static u32	Fog_BG_Count =0;		// BGʃXN[JE^

static int bg2_flag = 0;
#define		SCREEN_SIZE (32 * 32)
static u16 sScrnBuf[SCREEN_SIZE];

/*---------------------- Pallet Data  ---------------------------*/
const unsigned int d_64_256_bg_sclDT[8 * 3] = {
    0x628a7ffe, 0x6f0d6acb, 0x6aec6f2f, 0x77757352,        // 0000h
    0x51e6460d, 0x66f05a27, 0x41845a8f, 0x49c53943,
    0x41c73567, 0x4e2c5668, 0x62ad41cb, 0x566c2924,        // 0010h
    0x5eb1524f, 0x45e93566, 0x1ca16f55, 0x24e26b13,
    0x31442d02, 0x10607798, 0x7bba39aa, 0x7bdc779b,        // 0020h
    0x66c90820, 0x628a7ffe, 0x628a7ffe, 0x628a7ffe, 
};


/*---------------------- Character Data  -------------------------*/
const unsigned int d_64_256_bg_schDT[16 * 128] = {
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b2bh
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b01h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x0f2b2b2b,
    0x2b2b2b2b, 0x090d2b2b, 0x2b2b2b2b, 0x0f0f0d0f,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b02h
    0x2b2b2b2b, 0x01012b2b, 0x092b2b2b, 0x0201010a,
    0x0f0e0d2b, 0x0101010a, 0x090f0f0f, 0x1101010a,
    0x0a090f09, 0x11010101, 0x010a090f, 0x11010109,
    0x2b2b2b2b, 0x2b2b2b2b, 0x02012b2b, 0x04030302,        // 2b03h
    0x05020201, 0x04040403, 0x03050101, 0x06040404,
    0x04121110, 0x06060604, 0x17111016, 0x0b070603,
    0x1b111a1a, 0x0815171b, 0x17131b1b, 0x08080817,
    0x2b2b2b2b, 0x2b2b2b2b, 0x04030304, 0x2b2b0304,        // 2b04h
    0x06070706, 0x06070706, 0x07060b04, 0x07070707,
    0x06151413, 0x06070b06, 0x0c080808, 0x18181318,
    0x0c180808, 0x18180c18, 0x0c18080c, 0x0c0c0c18,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b05h
    0x2b2b0808, 0x2b2b2b2b, 0x0b0c0b06, 0x2b2b2b06,
    0x0707060b, 0x2b080b07, 0x07060c18, 0x13190b07,
    0x07060c18, 0x180b1c07, 0x0b0c1919, 0x1c060707,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b06h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b0c, 0x2b2b2b2b,
    0x2b2b0b06, 0x2b2b2b2b, 0x0b0b0707, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b07h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b2bh
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b01h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x0f2b2b2b,
    0x2b2b2b2b, 0x090d2b2b, 0x2b2b2b2b, 0x0f0f0d0f,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b02h
    0x2b2b2b2b, 0x01012b2b, 0x092b2b2b, 0x0201010a,
    0x0f0e0d2b, 0x0101010a, 0x090f0f0f, 0x1101010a,
    0x0a090f09, 0x11010101, 0x010a090f, 0x11010109,
    0x2b2b2b2b, 0x2b2b2b2b, 0x02012b2b, 0x04030302,        // 2b03h
    0x05020201, 0x04040403, 0x03050101, 0x06040404,
    0x04121110, 0x06060604, 0x17111016, 0x0b070603,
    0x1b111a1a, 0x0815171b, 0x17131b1b, 0x08080817,
    0x2b2b2b2b, 0x2b2b2b2b, 0x04030304, 0x2b2b0304,        // 2b04h
    0x06070706, 0x06070706, 0x07060b04, 0x07070707,
    0x06151413, 0x06070b06, 0x0c080808, 0x18181318,
    0x0c180808, 0x18180c18, 0x0c18080c, 0x0c0c0c18,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b05h
    0x2b2b0808, 0x2b2b2b2b, 0x0b0c0b06, 0x2b2b2b06,
    0x0707060b, 0x2b080b07, 0x07060c18, 0x13190b07,
    0x07060c18, 0x180b1c07, 0x0b0c1919, 0x1c060707,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b06h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b0c, 0x2b2b2b2b,
    0x2b2b0b06, 0x2b2b2b2b, 0x0b0b0707, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b07h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b10h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x0d2b2b2b, 0x2b2b2b2b, 0x232b2b2b,
    0x2b2b2b2b, 0x1d0e2b2b, 0x2b2b2b2b, 0x0e0e0e2b,
    0x1d2b2b2b, 0x0f090d0d, 0x0f0f2b2b, 0x0a0a0f0d,        // 2b11h
    0x1f0e0f2b, 0x0a0a0d1d, 0x201d0e0f, 0x21090f0d,
    0x0f1d0e0f, 0x1622bf0f, 0x0f0e0e20, 0x201f160d,
    0x0f090f0e, 0x161f2016, 0x0d0f090d, 0x1f1f0e1f,
    0x01010a0d, 0x1b020201, 0x0101010a, 0x03030502,        // 2b12h
    0x0201010a, 0x04030201, 0x01010a21, 0x04040111,
    0x11112121, 0x1317021b, 0x1a1a2121, 0x1b241b16,
    0x16090a09, 0x1b101b10, 0x1a020201, 0x151b1b1b,
    0x0604171b, 0x0c180c06, 0x0606171b, 0x180b0b06,        // 2b13h
    0x06041313, 0x0b0c180b, 0x0c0c130b, 0x0b0c0c0c,
    0x08150b17, 0x180c1813, 0x13041314, 0x19181308,
    0x0c0c141b, 0x19181813, 0x17141b15, 0x0c181808,
    0x180c0b0b, 0x190c0c0c, 0x0c0c070b, 0x070c0c0c,        // 2b14h
    0x0c181e07, 0x0707190c, 0x0c0c0b1e, 0x0722071e,
    0x19180c18, 0x1c220707, 0x1e190c0b, 0x1c1c0707,
    0x1c070707, 0x25071c07, 0x07070707, 0x1c1c0722,
    0x190c0c1e, 0x07070706, 0x1919191e, 0x19191e1e,        // 2b15h
    0x1e19191e, 0x1919191e, 0x1c1e1e1c, 0x1e19191e,
    0x221e1e1e, 0x1e1e1e22, 0x221c1c1c, 0x1c220722,
    0x221c1c25, 0x22222225, 0x22262525, 0x25252525,
    0x0707071c, 0x2b2b2b0b, 0x071c190c, 0x2b2b0b06,        // 2b16h
    0x07061919, 0x2b0b061c, 0x1e1e1e1e, 0x0b0b0707,
    0x071e1e1e, 0x06060707, 0x07071e1c, 0x1c07071c,
    0x1e070722, 0x1c071e19, 0x1e1c2222, 0x0707070b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b17h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b0c, 0x2b2b2b2b, 0x2b2b2b06, 0x2b2b2b2b,
    0x2b2b0c0b, 0x2b2b2b2b, 0x2b0c0b06, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b10h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x0d2b2b2b, 0x2b2b2b2b, 0x232b2b2b,
    0x2b2b2b2b, 0x1d0e2b2b, 0x2b2b2b2b, 0x0e0e0e2b,
    0x1d2b2b2b, 0x0f090d0d, 0x0f0f2b2b, 0x0a0a0f0d,        // 2b11h
    0x1f0e0f2b, 0x0a0a0d1d, 0x201d0e0f, 0x21090f0d,
    0x0f1d0e0f, 0x1622bf0f, 0x0f0e0e20, 0x201f160d,
    0x0f090f0e, 0x161f2016, 0x0d0f090d, 0x1f1f0e1f,
    0x01010a0d, 0x1b020201, 0x0101010a, 0x03030502,        // 2b12h
    0x0201010a, 0x04030201, 0x01010a21, 0x04040111,
    0x11112121, 0x1317021b, 0x1a1a2121, 0x1b241b16,
    0x16090a09, 0x1b101b10, 0x1a020201, 0x151b1b1b,
    0x0604171b, 0x0c180c06, 0x0606171b, 0x180b0b06,        // 2b13h
    0x06041313, 0x0b0c180b, 0x0c0c130b, 0x0b0c0c0c,
    0x08150b17, 0x180c1813, 0x13041314, 0x19181308,
    0x0c0c141b, 0x19181813, 0x17141b15, 0x0c181808,
    0x180c0b0b, 0x190c0c0c, 0x0c0c070b, 0x070c0c0c,        // 2b14h
    0x0c181e07, 0x0707190c, 0x0c0c0b1e, 0x0722071e,
    0x19180c18, 0x1c220707, 0x1e190c0b, 0x1c1c0707,
    0x1c070707, 0x25071c07, 0x07070707, 0x1c1c0722,
    0x190c0c1e, 0x07070706, 0x1919191e, 0x19191e1e,        // 2b15h
    0x1e19191e, 0x1919191e, 0x1c1e1e1c, 0x1e19191e,
    0x221e1e1e, 0x1e1e1e22, 0x221c1c1c, 0x1c220722,
    0x221c1c25, 0x22222225, 0x22262525, 0x25252525,
    0x0707071c, 0x2b2b2b0b, 0x071c190c, 0x2b2b0b06,        // 2b16h
    0x07061919, 0x2b0b061c, 0x1e1e1e1e, 0x0b0b0707,
    0x071e1e1e, 0x06060707, 0x07071e1c, 0x1c07071c,
    0x1e070722, 0x1c071e19, 0x1e1c2222, 0x0707070b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b17h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b0c, 0x2b2b2b2b, 0x2b2b2b06, 0x2b2b2b2b,
    0x2b2b0c0b, 0x2b2b2b2b, 0x2b0c0b06, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2022be2b, 0x2b2b2b2b, 0x22be0e1d,        // 2b20h
    0x2b2b2b2b, 0x0d0e201d, 0x0e2b2b2b, 0x0e201f20,
    0x22b2b2b0, 0x0d0e0e0d, 0x22b2b2b0, 0x0f0f0d0e,
    0x1f22b2b0, 0x0d0f0f20, 0x22be2b2b, 0x22bd0e1d,
    0x1f0d090d, 0x0921211f, 0x22b9090d, 0x0a211621,        // 2b21h
    0x0d09090f, 0x0a201f21, 0x0909090f, 0x090d0d0f,
    0x0f090f0f, 0x1f1a090f, 0x0a0f0f09, 0x110a0909,
    0x0a0d0d09, 0x01110a01, 0x0a210f0f, 0x0a090102,
    0x1a020502, 0x0b1b101b, 0x1a120505, 0x04131010,        // 2b22h
    0x11161103, 0x0404131a, 0x1111110a, 0x04060b1a,
    0x1a1b0a21, 0x0c03151b, 0x101b020a, 0x24111a10,
    0x1b120105, 0x0b171313, 0x1b110102, 0x0b131b15,
    0x0c141506, 0x19181819, 0x0c140b06, 0x07190c0b,        // 2b23h
    0x14140b06, 0x071c1e06, 0x08081904, 0x07070618,
    0x13142414, 0x07071813, 0x130c1414, 0x1c1e1918,
    0x0c040604, 0x0c180808, 0x14080b0b, 0x0c181808,
    0x221e1e1c, 0x221c1c1c, 0x221e191e, 0x25221c22,        // 2b24h
    0x221e191e, 0x25252225, 0x221e1919, 0x25221c22,
    0x1c1e1e07, 0x25221c07, 0x1e1e1c07, 0x221c1c1e,
    0x2207071e, 0x221c1c22, 0x1e19190c, 0x22221e1e,
    0x25252525, 0x25252626, 0x27272525, 0x22262627,        // 2b25h
    0x27272725, 0x22262727, 0x27272725, 0x22262727,
    0x27272725, 0x25252727, 0x27272525, 0x25252527,
    0x25252525, 0x25252525, 0x25252522, 0x25252525,
    0x07222222, 0x07070707, 0x22222222, 0x07070722,        // 2b26h
    0x22221c1c, 0x07071e07, 0x22071c1c, 0x190c0c19,
    0x1c071c22, 0x180c191e, 0x07222222, 0x180c1e1e,
    0x07070722, 0x18191c1e, 0x071c1c22, 0x191e1c07,
    0x2b0c0c1e, 0x2b2b2b2b, 0x13131819, 0x2b2b2b2b,        // 2b27h
    0x17180c06, 0x2b2b2b2b, 0x14180b1e, 0x2b2b2b14,
    0x08130b0b, 0x2b2b2b14, 0x130c0b0b, 0x2b2b2b08,
    0x080c0b19, 0x2b2b1308, 0x080c060b, 0x2b2b1408,
    0x2b2b2b2b, 0x2022be2b, 0x2b2b2b2b, 0x22be0e1d,        // 2b20h
    0x2b2b2b2b, 0x0d0e201d, 0x0e2b2b2b, 0x0e201f20,
    0x22b2b2b0, 0x0d0e0e0d, 0x22b2b2b0, 0x0f0f0d0e,
    0x1f22b2b0, 0x0d0f0f20, 0x22be2b2b, 0x22bd0e1d,
    0x1f0d090d, 0x0921211f, 0x22b9090d, 0x0a211621,        // 2b21h
    0x0d09090f, 0x0a201f21, 0x0909090f, 0x090d0d0f,
    0x0f090f0f, 0x1f1a090f, 0x0a0f0f09, 0x110a0909,
    0x0a0d0d09, 0x01110a01, 0x0a210f0f, 0x0a090102,
    0x1a020502, 0x0b1b101b, 0x1a120505, 0x04131010,        // 2b22h
    0x11161103, 0x0404131a, 0x1111110a, 0x04060b1a,
    0x1a1b0a21, 0x0c03151b, 0x101b020a, 0x24111a10,
    0x1b120105, 0x0b171313, 0x1b110102, 0x0b131b15,
    0x0c141506, 0x19181819, 0x0c140b06, 0x07190c0b,        // 2b23h
    0x14140b06, 0x071c1e06, 0x08081904, 0x07070618,
    0x13142414, 0x07071813, 0x130c1414, 0x1c1e1918,
    0x0c040604, 0x0c180808, 0x14080b0b, 0x0c181808,
    0x221e1e1c, 0x221c1c1c, 0x221e191e, 0x25221c22,        // 2b24h
    0x221e191e, 0x25252225, 0x221e1919, 0x25221c22,
    0x1c1e1e07, 0x25221c07, 0x1e1e1c07, 0x221c1c1e,
    0x2207071e, 0x221c1c22, 0x1e19190c, 0x22221e1e,
    0x25252525, 0x25252626, 0x27272525, 0x22262627,        // 2b25h
    0x27272725, 0x22262727, 0x27272725, 0x22262727,
    0x27272725, 0x25252727, 0x27272525, 0x25252527,
    0x25252525, 0x25252525, 0x25252522, 0x25252525,
    0x07222222, 0x07070707, 0x22222222, 0x07070722,        // 2b26h
    0x22221c1c, 0x07071e07, 0x22071c1c, 0x190c0c19,
    0x1c071c22, 0x180c191e, 0x07222222, 0x180c1e1e,
    0x07070722, 0x18191c1e, 0x071c1c22, 0x191e1c07,
    0x2b0c0c1e, 0x2b2b2b2b, 0x13131819, 0x2b2b2b2b,        // 2b27h
    0x17180c06, 0x2b2b2b2b, 0x14180b1e, 0x2b2b2b14,
    0x08130b0b, 0x2b2b2b14, 0x130c0b0b, 0x2b2b2b08,
    0x080c0b19, 0x2b2b1308, 0x080c060b, 0x2b2b1408,
    0x201d2b2b, 0x090f0e23, 0x201f2b2b, 0x090f0f20,        // 2b30h
    0x0d0d22b0, 0x090f0f0d, 0x0d0d0e2b, 0x090f0f0f,
    0x0d0d22b0, 0x0f090f0d, 0x0d0e1d2b, 0x0e090f0f,
    0x0e1d1d2b, 0x22bf0f0f, 0x1d1f22b0, 0x0d0e0f0f,
    0x0f22bd09, 0x02020202, 0x0f0e0d0a, 0x0201010a,        // 2b31h
    0x090f090a, 0x020a010a, 0x0d210d0f, 0x0502010a,
    0x1f1f231d, 0x0a0a0a20, 0x20201d23, 0x1f20161d,
    0x1f201d1d, 0x201f1d1d, 0x1f1f0e0e, 0x211d1f1f,
    0x1b111102, 0x1311241b, 0x11112112, 0x1b1b1110,        // 2b32h
    0x1a111b02, 0x141b1116, 0x10111103, 0x13150b13,
    0x15101a11, 0x04040404, 0x1b1a1a1f, 0x06040415,
    0x101a1a1a, 0x04040413, 0x1b112111, 0x24241b1b,
    0x14141b14, 0x190c0c13, 0x08131414, 0x18180c08,        // 2b33h
    0x08142414, 0x180c0b0c, 0x08131713, 0x0c0b070b,
    0x17131315, 0x0b06070b, 0x15241404, 0x080c0406,
    0x13141b0b, 0x0814130c, 0x1414241b, 0x13081314,
    0x1919190c, 0x25071e19, 0x190c1818, 0x22221e19,        // 2b34h
    0x19191813, 0x22221c19, 0x0c190c0c, 0x07220719,
    0x0b18180c, 0x07070706, 0x07190c18, 0x07070707,
    0x1e181813, 0x07070707, 0x180c1813, 0x07070618,
    0x25222222, 0x22252525, 0x22072222, 0x07222222,        // 2b35h
    0x22072222, 0x1e071e1c, 0x1c070707, 0x1e071c1e,
    0x07070707, 0x07070707, 0x07070707, 0x071e061e,
    0x07070707, 0x1c1e0b1e, 0x07070707, 0x1c1e0707,
    0x07071c07, 0x06061c07, 0x071e1e07, 0x06061c1c,        // 2b36h
    0x0719191e, 0x06061c06, 0x1e1e0619, 0x1c1c060b,
    0x180c0707, 0x06071c19, 0x18181e22, 0x06061c0c,
    0x18190707, 0x0606060c, 0x06060707, 0x06060604,
    0x0b06060b, 0x2b2b1717, 0x0b0c0b0c, 0x2b2b0403,        // 2b37h
    0x1914180b, 0x2b130b04, 0x15170606, 0x2b130c0c,
    0x0b0b0606, 0x2b131b14, 0x06060606, 0x2b041413,
    0x030b0606, 0x2b0b1413, 0x24241706, 0x2b0b1414,
    0x201d2b2b, 0x090f0e23, 0x201f2b2b, 0x090f0f20,        // 2b30h
    0x0d0d22b0, 0x090f0f0d, 0x0d0d0e2b, 0x090f0f0f,
    0x0d0d22b0, 0x0f090f0d, 0x0d0e1d2b, 0x0e090f0f,
    0x0e1d1d2b, 0x22bf0f0f, 0x1d1f22b0, 0x0d0e0f0f,
    0x0f22bd09, 0x02020202, 0x0f0e0d0a, 0x0201010a,        // 2b31h
    0x090f090a, 0x020a010a, 0x0d210d0f, 0x0502010a,
    0x1f1f231d, 0x0a0a0a20, 0x20201d23, 0x1f20161d,
    0x1f201d1d, 0x201f1d1d, 0x1f1f0e0e, 0x211d1f1f,
    0x1b111102, 0x1311241b, 0x11112112, 0x1b1b1110,        // 2b32h
    0x1a111b02, 0x141b1116, 0x10111103, 0x13150b13,
    0x15101a11, 0x04040404, 0x1b1a1a1f, 0x06040415,
    0x101a1a1a, 0x04040413, 0x1b112111, 0x24241b1b,
    0x14141b14, 0x190c0c13, 0x08131414, 0x18180c08,        // 2b33h
    0x08142414, 0x180c0b0c, 0x08131713, 0x0c0b070b,
    0x17131315, 0x0b06070b, 0x15241404, 0x080c0406,
    0x13141b0b, 0x0814130c, 0x1414241b, 0x13081314,
    0x1919190c, 0x25071e19, 0x190c1818, 0x22221e19,        // 2b34h
    0x19191813, 0x22221c19, 0x0c190c0c, 0x07220719,
    0x0b18180c, 0x07070706, 0x07190c18, 0x07070707,
    0x1e181813, 0x07070707, 0x180c1813, 0x07070618,
    0x25222222, 0x22252525, 0x22072222, 0x07222222,        // 2b35h
    0x22072222, 0x1e071e1c, 0x1c070707, 0x1e071c1e,
    0x07070707, 0x07070707, 0x07070707, 0x071e061e,
    0x07070707, 0x1c1e0b1e, 0x07070707, 0x1c1e0707,
    0x07071c07, 0x06061c07, 0x071e1e07, 0x06061c1c,        // 2b36h
    0x0719191e, 0x06061c06, 0x1e1e0619, 0x1c1c060b,
    0x180c0707, 0x06071c19, 0x18181e22, 0x06061c0c,
    0x18190707, 0x0606060c, 0x06060707, 0x06060604,
    0x0b06060b, 0x2b2b1717, 0x0b0c0b0c, 0x2b2b0403,        // 2b37h
    0x1914180b, 0x2b130b04, 0x15170606, 0x2b130c0c,
    0x0b0b0606, 0x2b131b14, 0x06060606, 0x2b041413,
    0x030b0606, 0x2b0b1413, 0x24241706, 0x2b0b1414,
    0x2022be2b, 0x0f0d090f, 0x0e1d22b0, 0x2021210f,        // 2b40h
    0x0d201d2b, 0x1f0f0f0f, 0x0d0e22b0, 0x0f090d0d,
    0x0d0d0e2b, 0x090f0d0d, 0x0d0d0e2b, 0x0f090f0f,
    0x0f0e2b2b, 0x1f0f0f0f, 0x20232b2b, 0x230e0f0f,
    0x1d0e0909, 0x11211f1d, 0x0d09090d, 0x090d22bd,        // 2b41h
    0x0a0a0d1f, 0x020a090a, 0x0a09201f, 0x0201010a,
    0x09090d0e, 0x01020a0f, 0x0909090d, 0x020a0d0f,
    0x0a090f1d, 0x0922be0a, 0x090f0920, 0x161f210f,
    0x1b1b1a1a, 0x1b111010, 0x05151201, 0x17030117,        // 2b42h
    0x05030502, 0x04041701, 0x02010502, 0x04041717,
    0x05010101, 0x03151112, 0x02010102, 0x151b1112,
    0x17120a0a, 0x1b161202, 0x11111a1f, 0x12161112,
    0x1314141b, 0x08131313, 0x1314141b, 0x13140813,        // 2b43h
    0x24241013, 0x17241b1b, 0x13131504, 0x17241414,
    0x13130404, 0x04132413, 0x04040404, 0x04031703,
    0x04060404, 0x04040404, 0x04040604, 0x03030b04,
    0x0b060c08, 0x07070b0b, 0x0604060b, 0x0604060c,        // 2b44h
    0x0b040606, 0x0b0b0617, 0x0b040606, 0x0b040404,
    0x0b0b0406, 0x0b0b190b, 0x15030304, 0x0b15130b,
    0x03030304, 0x1b0b0b0b, 0x03030b0b, 0x240b0b03,
    0x071c061c, 0x06060707, 0x06060606, 0x06060606,        // 2b45h
    0x0606040b, 0x0c0b0404, 0x06060b0c, 0x170c0406,
    0x06040b03, 0x0404040b, 0x0b041513, 0x040b150b,
    0x0b040b1b, 0x15151503, 0x030b0414, 0x03170303,
    0x0606071c, 0x0b0b0b0b, 0x0604040b, 0x04030b0b,        // 2b46h
    0x0b040b15, 0x1504040b, 0x0b150b0b, 0x0b040603,
    0x0b17150b, 0x04040b04, 0x0b150b03, 0x04151503,
    0x15040404, 0x04030303, 0x15040404, 0x03121215,
    0x13241413, 0x2b051b1b, 0x04131b17, 0x2b151503,        // 2b47h
    0x040b1b17, 0x2b171704, 0x13150b17, 0x2b010117,
    0x10111504, 0x2b010512, 0x10111504, 0x2b01051b,
    0x11130504, 0x2b2b0312, 0x13111703, 0x2b2b0104,
    0x2022be2b, 0x0f0d090f, 0x0e1d22b0, 0x2021210f,        // 2b40h
    0x0d201d2b, 0x1f0f0f0f, 0x0d0e22b0, 0x0f090d0d,
    0x0d0d0e2b, 0x090f0d0d, 0x0d0d0e2b, 0x0f090f0f,
    0x0f0e2b2b, 0x1f0f0f0f, 0x20232b2b, 0x230e0f0f,
    0x1d0e0909, 0x11211f1d, 0x0d09090d, 0x090d22bd,        // 2b41h
    0x0a0a0d1f, 0x020a090a, 0x0a09201f, 0x0201010a,
    0x09090d0e, 0x01020a0f, 0x0909090d, 0x020a0d0f,
    0x0a090f1d, 0x0922be0a, 0x090f0920, 0x161f210f,
    0x1b1b1a1a, 0x1b111010, 0x05151201, 0x17030117,        // 2b42h
    0x05030502, 0x04041701, 0x02010502, 0x04041717,
    0x05010101, 0x03151112, 0x02010102, 0x151b1112,
    0x17120a0a, 0x1b161202, 0x11111a1f, 0x12161112,
    0x1314141b, 0x08131313, 0x1314141b, 0x13140813,        // 2b43h
    0x24241013, 0x17241b1b, 0x13131504, 0x17241414,
    0x13130404, 0x04132413, 0x04040404, 0x04031703,
    0x04060404, 0x04040404, 0x04040604, 0x03030b04,
    0x0b060c08, 0x07070b0b, 0x0604060b, 0x0604060c,        // 2b44h
    0x0b040606, 0x0b0b0617, 0x0b040606, 0x0b040404,
    0x0b0b0406, 0x0b0b190b, 0x15030304, 0x0b15130b,
    0x03030304, 0x1b0b0b0b, 0x03030b0b, 0x240b0b03,
    0x071c061c, 0x06060707, 0x06060606, 0x06060606,        // 2b45h
    0x0606040b, 0x0c0b0404, 0x06060b0c, 0x170c0406,
    0x06040b03, 0x0404040b, 0x0b041513, 0x040b150b,
    0x0b040b1b, 0x15151503, 0x030b0414, 0x03170303,
    0x0606071c, 0x0b0b0b0b, 0x0604040b, 0x04030b0b,        // 2b46h
    0x0b040b15, 0x1504040b, 0x0b150b0b, 0x0b040603,
    0x0b17150b, 0x04040b04, 0x0b150b03, 0x04151503,
    0x15040404, 0x04030303, 0x15040404, 0x03121215,
    0x13241413, 0x2b051b1b, 0x04131b17, 0x2b151503,        // 2b47h
    0x040b1b17, 0x2b171704, 0x13150b17, 0x2b010117,
    0x10111504, 0x2b010512, 0x10111504, 0x2b01051b,
    0x11130504, 0x2b2b0312, 0x13111703, 0x2b2b0104,
    0x1d282b2b, 0x1d231d1d, 0x23282b2b, 0x0e231d1d,        // 2b50h
    0x22b2b2b0, 0x0f1d1d0e, 0x22b2b2b0, 0x090d0d0e,
    0x0e2b2b2b, 0x090f0e0d, 0x2b2b2b2b, 0x0f0d22be,
    0x2b2b2b2b, 0x0e0d0d0e, 0x2b2b2b2b, 0x2322be2b,
    0x22bf0a0f, 0x0d201d1d, 0x0d0a0909, 0x011f1f20,        // 2b51h
    0x0a2122ba, 0x0f0d0d0f, 0x0a1f0e09, 0x0f210f01,
    0x0a0a0e0d, 0x2022b90a, 0x1d0d0d0d, 0x211d22be,
    0x231d1d1d, 0x0a1d231d, 0x23282323, 0x011f1f0f,
    0x1a1a1209, 0x03131111, 0x16120305, 0x121b101a,        // 2b52h
    0x21111209, 0x12161111, 0x1221090a, 0x1b160911,
    0x0101120f, 0x11161a01, 0x0212090a, 0x121a1101,
    0x1e180102, 0x120a1212, 0x14150202, 0x12091b16,
    0x03050303, 0x03031703, 0x0403171b, 0x15151504,        // 2b53h
    0x04030505, 0x17150304, 0x04030505, 0x03030304,
    0x03030502, 0x02020404, 0x03051201, 0x17050403,
    0x03051201, 0x05050303, 0x05021212, 0x02050305,
    0x15031515, 0x17171515, 0x03151b1b, 0x04040b15,        // 2b54h
    0x12101b17, 0x04040315, 0x1b130504, 0x03040312,
    0x03040101, 0x03030305, 0x0305171b, 0x05030303,
    0x03050502, 0x05030303, 0x03051212, 0x01050303,
    0x15050415, 0x04150517, 0x15151504, 0x04151512,        // 2b55h
    0x01050304, 0x04041513, 0x05150303, 0x04040305,
    0x05050503, 0x03040217, 0x05050502, 0x03030117,
    0x03011b02, 0x05030303, 0x03051112, 0x01050503,
    0x03040404, 0x17101715, 0x03040404, 0x121b1205,        // 2b56h
    0x05030304, 0x12020215, 0x05040403, 0x01121705,
    0x05030303, 0x01010205, 0x01050505, 0x1b05111a,
    0x1b030505, 0x12011111, 0x01121212, 0x01111205,
    0x031b1203, 0x2b2b1205, 0x05111705, 0x2b2b2111,        // 2b57h
    0x1b1b0205, 0x2b2b2b16, 0x11010502, 0x2b2b2b16,
    0x02011212, 0x2b2b2b12, 0x2912011b, 0x2b2b2b2b,
    0x12120111, 0x2b2b2b2b, 0x2b091112, 0x2b2b2b2b,
    0x1d282b2b, 0x1d231d1d, 0x23282b2b, 0x0e231d1d,        // 2b50h
    0x22b2b2b0, 0x0f1d1d0e, 0x22b2b2b0, 0x090d0d0e,
    0x0e2b2b2b, 0x090f0e0d, 0x2b2b2b2b, 0x0f0d22be,
    0x2b2b2b2b, 0x0e0d0d0e, 0x2b2b2b2b, 0x2322be2b,
    0x22bf0a0f, 0x0d201d1d, 0x0d0a0909, 0x011f1f20,        // 2b51h
    0x0a2122ba, 0x0f0d0d0f, 0x0a1f0e09, 0x0f210f01,
    0x0a0a0e0d, 0x2022b90a, 0x1d0d0d0d, 0x211d22be,
    0x231d1d1d, 0x0a1d231d, 0x23282323, 0x011f1f0f,
    0x1a1a1209, 0x03131111, 0x16120305, 0x121b101a,        // 2b52h
    0x21111209, 0x12161111, 0x1221090a, 0x1b160911,
    0x0101120f, 0x11161a01, 0x0212090a, 0x121a1101,
    0x1e180102, 0x120a1212, 0x14150202, 0x12091b16,
    0x03050303, 0x03031703, 0x0403171b, 0x15151504,        // 2b53h
    0x04030505, 0x17150304, 0x04030505, 0x03030304,
    0x03030502, 0x02020404, 0x03051201, 0x17050403,
    0x03051201, 0x05050303, 0x05021212, 0x02050305,
    0x15031515, 0x17171515, 0x03151b1b, 0x04040b15,        // 2b54h
    0x12101b17, 0x04040315, 0x1b130504, 0x03040312,
    0x03040101, 0x03030305, 0x0305171b, 0x05030303,
    0x03050502, 0x05030303, 0x03051212, 0x01050303,
    0x15050415, 0x04150517, 0x15151504, 0x04151512,        // 2b55h
    0x01050304, 0x04041513, 0x05150303, 0x04040305,
    0x05050503, 0x03040217, 0x05050502, 0x03030117,
    0x03011b02, 0x05030303, 0x03051112, 0x01050503,
    0x03040404, 0x17101715, 0x03040404, 0x121b1205,        // 2b56h
    0x05030304, 0x12020215, 0x05040403, 0x01121705,
    0x05030303, 0x01010205, 0x01050505, 0x1b05111a,
    0x1b030505, 0x12011111, 0x01121212, 0x01111205,
    0x031b1203, 0x2b2b1205, 0x05111705, 0x2b2b2111,        // 2b57h
    0x1b1b0205, 0x2b2b2b16, 0x11010502, 0x2b2b2b16,
    0x02011212, 0x2b2b2b12, 0x2912011b, 0x2b2b2b2b,
    0x12120111, 0x2b2b2b2b, 0x2b091112, 0x2b2b2b2b,
    0x2b2b2b2b, 0x23281d2b, 0x2b2b2b2b, 0x23282b2b,        // 2b60h
    0x2b2b2b2b, 0x232b2b2b, 0x2b2b2b2b, 0x232b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x1f231d23, 0x091d0f0e, 0x1f1d1d1d, 0x201d201f,        // 2b61h
    0x1d1d1d23, 0x20231d1d, 0x1d1d2323, 0x0e201f23,
    0x1f1d201d, 0x22bf1d23, 0x1f1f232b, 0x1d0d1623,
    0x1f232b2b, 0x1d1d1f23, 0x1d2b2b2b, 0x1f1d1f1d,
    0x1f160a02, 0x1a16211d, 0x1f22be0a, 0x1f23231f,        // 2b62h
    0x1d0e0e0e, 0x1d1d1d1d, 0x1d1f1d1d, 0x1f1f1d1d,
    0x1d201d1d, 0x0d0f201f, 0x201d1d1d, 0x2902201d,
    0x1d0e2323, 0x090a0d23, 0x231d1d1f, 0x0f0a0a1d,
    0x031b1611, 0x05020503, 0x0112161f, 0x05052902,        // 2b63h
    0x12291a1f, 0x09010212, 0x09291220, 0x1f0d0a12,
    0x09290512, 0x0d1f110a, 0x29292929, 0x29090a01,
    0x29120a0a, 0x01292929, 0x2929090f, 0x01091229,
    0x05111f12, 0x12011205, 0x111f1105, 0x11011201,        // 2b64h
    0x1f1f1a09, 0x0a120511, 0x16211f1f, 0x01122911,
    0x09090a11, 0x0a290202, 0x29292929, 0x1f12091b,
    0x0d120229, 0x0d090916, 0x1d0d0a29, 0x120a0d1f,
    0x05030212, 0x01020205, 0x05030212, 0x05020205,        // 2b65h
    0x03050501, 0x03291b12, 0x02050505, 0x03011111,
    0x05050501, 0x29122929, 0x05022921, 0x01120105,
    0x02022909, 0x09090205, 0x02020229, 0x09120205,
    0x01091f21, 0x161f0d09, 0x12161601, 0x1f16111b,        // 2b66h
    0x12110504, 0x21160d01, 0x29010102, 0x12160f01,
    0x01020201, 0x021b1202, 0x12021229, 0x2b05020a,
    0x12121201, 0x2b2b2912, 0x2909110a, 0x2b2b2b29,
    0x2b201101, 0x2b2b2b2b, 0x2b2b2912, 0x2b2b2b2b,        // 2b67h
    0x2b2b2b01, 0x2b2b2b2b, 0x2b2b2b29, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x23281d2b, 0x2b2b2b2b, 0x23282b2b,        // 2b60h
    0x2b2b2b2b, 0x232b2b2b, 0x2b2b2b2b, 0x232b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x1f231d23, 0x091d0f0e, 0x1f1d1d1d, 0x201d201f,        // 2b61h
    0x1d1d1d23, 0x20231d1d, 0x1d1d2323, 0x0e201f23,
    0x1f1d201d, 0x22bf1d23, 0x1f1f232b, 0x1d0d1623,
    0x1f232b2b, 0x1d1d1f23, 0x1d2b2b2b, 0x1f1d1f1d,
    0x1f160a02, 0x1a16211d, 0x1f22be0a, 0x1f23231f,        // 2b62h
    0x1d0e0e0e, 0x1d1d1d1d, 0x1d1f1d1d, 0x1f1f1d1d,
    0x1d201d1d, 0x0d0f201f, 0x201d1d1d, 0x2902201d,
    0x1d0e2323, 0x090a0d23, 0x231d1d1f, 0x0f0a0a1d,
    0x031b1611, 0x05020503, 0x0112161f, 0x05052902,        // 2b63h
    0x12291a1f, 0x09010212, 0x09291220, 0x1f0d0a12,
    0x09290512, 0x0d1f110a, 0x29292929, 0x29090a01,
    0x29120a0a, 0x01292929, 0x2929090f, 0x01091229,
    0x05111f12, 0x12011205, 0x111f1105, 0x11011201,        // 2b64h
    0x1f1f1a09, 0x0a120511, 0x16211f1f, 0x01122911,
    0x09090a11, 0x0a290202, 0x29292929, 0x1f12091b,
    0x0d120229, 0x0d090916, 0x1d0d0a29, 0x120a0d1f,
    0x05030212, 0x01020205, 0x05030212, 0x05020205,        // 2b65h
    0x03050501, 0x03291b12, 0x02050505, 0x03011111,
    0x05050501, 0x29122929, 0x05022921, 0x01120105,
    0x02022909, 0x09090205, 0x02020229, 0x09120205,
    0x01091f21, 0x161f0d09, 0x12161601, 0x1f16111b,        // 2b66h
    0x12110504, 0x21160d01, 0x29010102, 0x12160f01,
    0x01020201, 0x021b1202, 0x12021229, 0x2b05020a,
    0x12121201, 0x2b2b2912, 0x2909110a, 0x2b2b2b29,
    0x2b201101, 0x2b2b2b2b, 0x2b2b2912, 0x2b2b2b2b,        // 2b67h
    0x2b2b2b01, 0x2b2b2b2b, 0x2b2b2b29, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b70h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x22bd2123, 0x2b2b2b2b, 0x0d0f2b2b,        // 2b71h
    0x2b2b2b2b, 0x0d2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x1d231d1d, 0x0d0d0f1f, 0x20201f20, 0x1d1f0a0d,        // 2b72h
    0x0909090d, 0x0e090a0a, 0x2022bd2b, 0x0a0a0a0e,
    0x232b2b2b, 0x0a091d23, 0x2b2b2b2b, 0x09092b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x090a090d, 0x12090d0d, 0x0e0e22bf, 0x01010e20,        // 2b73h
    0x290d1d0d, 0x0d110d0a, 0x010e231d, 0x230d0502,
    0x1d1d22be, 0x23210a0e, 0x22be090a, 0x1d231f1d,
    0x090a2b2b, 0x1d1f2020, 0x2b2b2b2b, 0x2b2b2b2b,
    0x1f1d0d29, 0x22bd201d, 0x211f2112, 0x20112120,        // 2b74h
    0x1621201f, 0x09161d0d, 0x1d21201f, 0x1d1d1d23,
    0x0d202121, 0x201f210d, 0x0f0d22bd, 0x1f1d22bf,
    0x0d201d1d, 0x2b2b1d1d, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2912090f, 0x0a292929, 0x121d2021, 0x090a0912,        // 2b75h
    0x091d210a, 0x09091112, 0x0f1d1111, 0x2b090a0f,
    0x091d1d1d, 0x2b2b2b09, 0x2b2b1d1d, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x0912120a, 0x2b2b2b2b, 0x2b2b1201, 0x2b2b2b2b,        // 2b76h
    0x2b2b2b0a, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b77h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b70h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x22bd2123, 0x2b2b2b2b, 0x0d0f2b2b,        // 2b71h
    0x2b2b2b2b, 0x0d2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x1d231d1d, 0x0d0d0f1f, 0x20201f20, 0x1d1f0a0d,        // 2b72h
    0x0909090d, 0x0e090a0a, 0x2022bd2b, 0x0a0a0a0e,
    0x232b2b2b, 0x0a091d23, 0x2b2b2b2b, 0x09092b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x090a090d, 0x12090d0d, 0x0e0e22bf, 0x01010e20,        // 2b73h
    0x290d1d0d, 0x0d110d0a, 0x010e231d, 0x230d0502,
    0x1d1d22be, 0x23210a0e, 0x22be090a, 0x1d231f1d,
    0x090a2b2b, 0x1d1f2020, 0x2b2b2b2b, 0x2b2b2b2b,
    0x1f1d0d29, 0x22bd201d, 0x211f2112, 0x20112120,        // 2b74h
    0x1621201f, 0x09161d0d, 0x1d21201f, 0x1d1d1d23,
    0x0d202121, 0x201f210d, 0x0f0d22bd, 0x1f1d22bf,
    0x0d201d1d, 0x2b2b1d1d, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2912090f, 0x0a292929, 0x121d2021, 0x090a0912,        // 2b75h
    0x091d210a, 0x09091112, 0x0f1d1111, 0x2b090a0f,
    0x091d1d1d, 0x2b2b2b09, 0x2b2b1d1d, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x0912120a, 0x2b2b2b2b, 0x2b2b1201, 0x2b2b2b2b,        // 2b76h
    0x2b2b2b0a, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,        // 2b77h
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b,
    0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b, 0x2b2b2b2b
};
#endif

#if 0
//=============================================================================
//
//		^[e[u	
//
//=============================================================================
//-----------------------------------------------------------------------------
//			萔
//=============================================================================
#define D_SAMPLING_RATE (16000)		// [g
#define D_SAMPLING_TIME     (10)	// TvO(b)

#define D_CHANNEL_NO (7)			// TEh`l

#define D_WAVE_SAMPLE ( D_SAMPLING_RATE * D_SAMPLING_TIME )	// obt@TCY

#define	D_DJ_SPEED	(32768/2)	// tpWPiނƂ̃Xs[h
//-----------------------------------------------------------------------------
//			\
//=============================================================================


//-----------------------------------------------------------------------------
//			vg^Cv錾
//=============================================================================
static void D_MicCallback( MICResult /**/, void* /**/ );
static void StartWaveMic( TCB_PTR tcb,void* work );	// EF[u}CNݒ
static void MainWaveMic( TCB_PTR tcb,void* work);	// EF[u}CNC
static void EndWaveMic( TCB_PTR tcb,void* work );	// EF[u}CNI

static void WaveInput(u32 num);		// 
static void WaveStartOutPut(u32 Speed);
static void WaveDataReturn(s16* pWaveData, u32 LoopStart);

//-----------------------------------------------------------------------------
//			ϐ
//=============================================================================
static s16 D_WaveBuffer[ D_WAVE_SAMPLE ] ATTRIBUTE_ALIGN(32);
static MICAutoParam D_MicParam;	// I[gTvOp[^
static NNSSndWaveOutHandle D_WaveOutHandle;	// TEhnh

static u8	WaveMicFlag=0;		// WaveMics:1
static TCB_PTR	WaveMicTCBData;	// ^XNf[^
static s32	WaveNum=0;			// s̏
static u32	WaveSpeed = 32768;	// Xs[h
static u32	WavePan = 64;		// p(Xs[J[̍Ẽ{[)
static s32	WaveNo=0;			// ̎s̔zʒu
static TPData	WaveTP;			// ^b`plۑp
static u8	WaveSndFlag=0;		// Đ:1	tĐ:0

static u8	WaveMicDataFlag=0;	// ep̃tO

// S
static const u16	wave_title00[] = {ro_,ku_,o_,n_,EOM_,};
static const u16	wave_title01[] = {sa_,i_,se_,i_,EOM_,};

static const u16	wave_00_comment00[] = {A__,BO_,TA_,N_,spc_,SA_,N_,PU_,RI_,N_,GU_,ka_,i_,si_,EOM_,};
static const u16	wave_01_comment00[] = {Y__,BO_,TA_,N_,spc_,sa_,i_,se_,i_,EOM_,};
static const u16	wave_01_comment01[] = {A__,BO_,TA_,N_,spc_,o_,to_,wo_,da_,su_,EOM_,};
static const u16	wave_01_comment02[] = {TA_,TTU_,TI_,PA_,NE_,RU_,spc_,SU_,KU_,RA_,TTU_,TI_,EOM_,};

static const u16*	wave_title[]={
	wave_title00,
	wave_title01,
	D_M_str13
};

enum{
	WAVE_ROKUON,
	WAVE_SAISEI,
	WAVE_D_W,
	WAVE_TITLE_NUM
};
#endif
//=============================================================================
//
//		VCVXe	
//
//=============================================================================
//-----------------------------------------------------------------------------
//			萔
//=============================================================================
#define MAP_TYPE_LIST_COUNT_SUB_OTENKI_00	(9)
#define MAP_TYPE_LIST_COUNT_SUB_OTENKI_01	(8)

//-----------------------------------------------------------------------------
//			\
//=============================================================================

//-----------------------------------------------------------------------------
//			vg^Cv錾
//=============================================================================
static void StartWeather00( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather01( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather02( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather03( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather04( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather05( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather06( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather07( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather08( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather09( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather10( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather11( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather12( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather13( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather14( TCB_PTR tcb,void* work );	// VCݒ
static void StartWeather15( TCB_PTR tcb,void* work );	// VCݒ
static void StopWeather( TCB_PTR tcb,void* work );		// VCI
static void EndWeather( TCB_PTR tcb,void* work );	// VCj	 
//-----------------------------------------------------------------------------
//			ϐ
//=============================================================================



//============================================================================
//		jump
//		
//		ftHg
//
//			fobNEBhE̊֐f[^
//
//
//=============================================================================
#define MAP_TYPE_LIST_COUNT_MAIN	(9)
#define MAP_TYPE_LIST_COUNT_NO_SUB	(5)		// Tuj[ȂVXe
#define MAP_TYPE_LIST_COUNT_SUB		(2)

#define MAP_TYPE_LIST_COUNT_LIGHT_SUB		(3)
		
//-----------------------------------------------------------------------------
//			\
//=============================================================================
typedef struct _DEBUG_WINDOW_DATA{
	u8	work;
	GF_BGL_BMPWIN*	bmplistID;
	BMPLIST_WORK*	bmplistContID;
	BMPLIST_DATA*	bmplist;


	u16 debug_list;
	u16 debug_cursor;
}DEBUG_WINDOW_DATA;

//-----------------------------------------------------------------------------
//			vg^Cv
//=============================================================================
static void InitDebugWindow(DEBUG_WINDOW_DATA *wp);
static void DebugListFree(TCB_PTR tcb,void* work);
static void DebugWindowExit(TCB_PTR tcb,void* work);
static void DebugListControlTask(TCB_PTR tcb,void* work);
static void EndDebugWind( TCB_PTR tcb,void* work );		// fobNEBhEイ傤

// Tup
static void StartApplication(TCB_PTR tcb,void* work);
static void ApplicationControlTask(TCB_PTR tcb,void* work);
//-----------------------------------------------------------------------------
//			ϐ
//=============================================================================
//----------------------------------------------------------------------------
//	Xgږ
//----------------------------------------------------------------------------

//--------------------------------------------------------------------------
//	EBhEf[^
//--------------------------------------------------------------------------
DEBUG_WINDOW_DATA* MainWp = NULL;

//--------------------------------------------------------------------------
//	ڂƎs֐̃Xg
//--------------------------------------------------------------------------
//Cp
static const BMPLIST_DATA MainDebugList[] = {
	{(void*)Msg01_03,(u32)StartWipe},
	{(void*)Msg01_02,(u32)StartSprite_Check},
	{(void*)Msg01_14,(u32)StartZukan_Check},
//	{(void*)Msg01_10,(u32)StartEncount},
	{(void*)Msg01_12,(u32)StartTexTrans},
	
	{(void*)Msg01_13,(u32)StartEvPokeSelect_Check},	// eXg
//	{(void*)Msg01_13,(u32)StartImcPlay},
//	{(void*)Msg01_13,(u32)StartPoison},
//	
	{(void*)Msg01_04,(u32)StartApplication},	
	{(void*)Msg01_05,(u32)StartApplication},
//	{(void*)Msg01_01,(u32)StartApplication},	
	{(void*)Msg01_07,(u32)StartApplication},
	{(void*)Msg01_07,(u32)StartApplication},
	{(void*)Msg01_11,(u32)EndDebugWind},
};


#define BMPLIST_ENDCODE	(const void*)(0xffffffff)

// Tup
static const BMPLIST_DATA SubDebugList[][15] = {
	{	// }eA
		{(void*)Msg02_01,(u32)StartMaterialWindow},
		{(void*)Msg02_02,(u32)EndMaterialWindow},
		{BMPLIST_ENDCODE, 0},
	},
	{	// tHO
		{(void*)Msg02_01,(u32)StartFog},
		{(void*)Msg02_02,(u32)EndFog},
		{BMPLIST_ENDCODE, 0},
	},
	{	// VC
		{(void*)Msg07_01,(u32)StartWeather00},	// J
		{(void*)Msg07_02,(u32)StartWeather01},	// 
		{(void*)Msg07_03,(u32)StartWeather02},	// 
		{(void*)Msg07_04,(u32)StartWeather03},	// 
		{(void*)Msg07_05,(u32)StartWeather04},	// 
		{(void*)Msg07_06,(u32)StartWeather05},	// 
		{(void*)Msg07_07,(u32)StartWeather06},	// 
		{(void*)Msg07_08,(u32)StartWeather07},	// 
		{(void*)Msg07_09,(u32)StartWeather08},	// BGgp
		{BMPLIST_ENDCODE, 0},
	},
	{	// VCQ
		{(void*)Msg07_10,(u32)StartWeather09},	// Ґ
		{(void*)Msg07_11,(u32)StartWeather10},	// Xm[_Xg
		{(void*)Msg07_12,(u32)StartWeather11},	// J
		{(void*)Msg07_13,(u32)StartWeather12},	// ΎRD
		{(void*)Msg07_14,(u32)StartWeather13},	// 
		{(void*)Msg07_15,(u32)StartWeather14},	// C
		{(void*)Msg07_16,(u32)StartWeather15},	// _
		{(void*)Msg07_18,(u32)EndWeather},
		{BMPLIST_ENDCODE, 0},
	},
/*	{	// ZAN^[`FbN
		{(void*)Msg02_01,(u32)StartCLACT_Check},
		{(void*)Msg02_02,(u32)EndCLACT_Check},
		{BMPLIST_ENDCODE, 0},
	},//*/
};

//---------------------------------------------------------------------------
//  EBhEݒ
//---------------------------------------------------------------------------
//CEBhE
static const BMPWIN_DAT	MainDebugListWindowData = {
	FLD_MBGFRM_FONT,
	0,0,
	10,24,
	FLD_SYSFONT_PAL,
	8
};

//TuEBhE
static const BMPWIN_DAT	SubDebugListWindowData = {
	FLD_MBGFRM_FONT,
	0,0,
	8,24,
	FLD_SYSFONT_PAL,
	8
};

//------------------------------------------------------------------
//	ڃXgf[^
//------------------------------------------------------------------
//Cp
static const BMPLIST_HEADER MainDebugListHeader = {
	MainDebugList,		//\f[^|C^
	NULL,				//J[\ړƂ̃R[obN֐
	NULL,				//PsƂ̃R[obN֐
	NULL,				// EBhE
	MAP_TYPE_LIST_COUNT_MAIN,//Xgڐ
	MAP_TYPE_LIST_COUNT_MAIN,//\ő區ڐ
	2,					//x\wW
	12,					//ڕ\wW
	1,					//J[\\wW
	8,					//\xW
	FBMP_COL_WHITE,		//F
	FBMP_COL_BLACK,		//wiF
	FBMP_COL_BLK_SDW,	//eF
	0,					//Ԋuw
	1,					//Ԋux
	BMPLIST_NO_SKIP,	//y[WXLbv^Cv
	FONT_SYSTEM,			//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
};

//Tup
static const BMPLIST_HEADER SubDebugListHeader[] = {
	{
		SubDebugList[0],	//\f[^|C^	
		NULL,		//J[\ړƂ̃R[obN֐
		NULL,		//PsƂ̃R[obN֐
		NULL,		//EBhE
		MAP_TYPE_LIST_COUNT_SUB,//Xgڐ
		MAP_TYPE_LIST_COUNT_SUB,//\ő區ڐ
		2,					//x\wW
		12,					//ڕ\wW
		1,					//J[\\wW
		8,					//\xW
		FBMP_COL_WHITE,		//F
		FBMP_COL_BLACK,		//wiF
		FBMP_COL_BLK_SDW,	//eF
		0,					//Ԋuw
		1,					//Ԋux
		BMPLIST_NO_SKIP,	//y[WXLbv^Cv
		FONT_SYSTEM,			//w
		0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	},
/*	{
		SubDebugList[4],	//\f[^|C^	
		NULL,		//J[\ړƂ̃R[obN֐
		NULL,		//PsƂ̃R[obN֐
		NULL,		//EBhE
		MAP_TYPE_LIST_COUNT_SUB,//Xgڐ
		MAP_TYPE_LIST_COUNT_SUB,//\ő區ڐ
		2,					//x\wW
		12,					//ڕ\wW
		1,					//J[\\wW
		8,					//\xW
		FBMP_COL_WHITE,		//F
		FBMP_COL_BLACK,		//wiF
		FBMP_COL_BLK_SDW,	//eF
		0,					//Ԋuw
		1,					//Ԋux
		BMPLIST_NO_SKIP,	//y[WXLbv^Cv
		FONT_SYSTEM,			//w
		0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	},//*/
	{
		SubDebugList[1],	//\f[^|C^	
		NULL,		//J[\ړƂ̃R[obN֐
		NULL,		//PsƂ̃R[obN֐
		NULL,		//EBhE
		MAP_TYPE_LIST_COUNT_SUB,//Xgڐ
		MAP_TYPE_LIST_COUNT_SUB,//\ő區ڐ
		2,					//x\wW
		12,					//ڕ\wW
		1,					//J[\\wW
		8,					//\xW
		FBMP_COL_WHITE,		//F
		FBMP_COL_BLACK,		//wiF
		FBMP_COL_BLK_SDW,	//eF
		0,					//Ԋuw
		1,					//Ԋux
		BMPLIST_NO_SKIP,	//y[WXLbv^Cv
		FONT_SYSTEM,			//w
		0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	},
	{
		SubDebugList[2],	//\f[^|C^	
		NULL,		//J[\ړƂ̃R[obN֐
		NULL,		//PsƂ̃R[obN֐
		NULL,		//EBhE
		MAP_TYPE_LIST_COUNT_SUB_OTENKI_01,//Xgڐ
		MAP_TYPE_LIST_COUNT_SUB_OTENKI_01,//\ő區ڐ
		2,					//x\wW
		12,					//ڕ\wW
		1,					//J[\\wW
		8,					//\xW
		FBMP_COL_WHITE,		//F
		FBMP_COL_BLACK,		//wiF
		FBMP_COL_BLK_SDW,	//eF
		0,					//Ԋuw
		1,					//Ԋux
		BMPLIST_NO_SKIP,	//y[WXLbv^Cv
		FONT_SYSTEM,			//w
		0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	},
	{
		SubDebugList[3],	//\f[^|C^	
		NULL,		//J[\ړƂ̃R[obN֐
		NULL,		//PsƂ̃R[obN֐
		NULL,		//EBhE
		MAP_TYPE_LIST_COUNT_SUB_OTENKI_01,//Xgڐ
		MAP_TYPE_LIST_COUNT_SUB_OTENKI_01,//\ő區ڐ
		2,					//x\wW
		12,					//ڕ\wW
		1,					//J[\\wW
		0,					//\xW
		FBMP_COL_WHITE,		//F
		FBMP_COL_BLACK,		//wiF
		FBMP_COL_BLK_SDW,	//eF
		0,					//Ԋuw
		1,					//Ԋux
		BMPLIST_NO_SKIP,	//y[WXLbv^Cv
		FONT_SYSTEM,			//w
		0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	},
};


//-------------------------------------
//	L[̓͂LZtO
static u8	KeyNoTouchFlag = 0;

//----------------------------------------------------------------------------
/**
 *
 *@brief	BmpEBhE쐬
 *
 *@param	num		EBhĚ
 *
 *@return	쐬f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static GF_BGL_BMPWIN* initBmpWin(int num)
{
	return GF_BGL_BmpWinAllocGet(HEAPID_FIELD, num);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	BMPEBhEj
 *
 *@param	data	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delBmpWin(GF_BGL_BMPWIN* data)
{
	GF_BGL_BmpWinDel(data);
	sys_FreeMemoryEz(data);
}

//===============================================================================
//	EBhE
//===============================================================================
//
static void InitDebugWindow(DEBUG_WINDOW_DATA *wp)
{
	wp->debug_list = 0;
	wp->debug_cursor = 0;
	wp->bmplist = NULL;
}
//Xg̊J
static void DebugListFree(TCB_PTR tcb,void* work)
{
	DEBUG_WINDOW_DATA	*wp;

	wp = (DEBUG_WINDOW_DATA*)work;

	//BMPEBhEOFF
	GF_BGL_BmpWinOff(wp->bmplistID);

	//BMPXgj
	if(wp->bmplist != NULL)
	{
		BMP_MENULIST_Delete(wp->bmplist);
		wp->bmplist = NULL;
	}
	BmpListExit(wp->bmplistContID,&wp->debug_list,&wp->debug_cursor);

	//BMPWindow
	delBmpWin(wp->bmplistID);
	wp->bmplistID = NULL;

	return;
}
//fobOEBhE
static void FreeDebugWindow(TCB_PTR tcb,void* work)
{
	//Xg̊J
	DebugListFree(tcb,work);
	//[NJ
	sys_FreeMemory(HEAPID_FIELD,work);
}
//fobOEBhEI
static void DebugWindowExit(TCB_PTR tcb,void* work)
{
	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	//OBJ̓~
	FieldSystemProc_SeqHoldEnd();
	return;
}

static BMPLIST_DATA* BmpListMake(const BMPLIST_DATA* list, u32 max)
{
	u32 i;
	BMPLIST_DATA* ret = BMP_MENULIST_Create(max, HEAPID_BASE_DEBUG);
	MSGDATA_MANAGER* man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_tomoya_dat, HEAPID_BASE_DEBUG);

	for(i=0; i<max; i++)
	{
		BMP_MENULIST_AddArchiveString( ret, man, (u32)(list->str), list->param );
		list++;
	}

	MSGMAN_Delete(man);
	return ret;
}


static void mainlistStart(void)
{
	BMPLIST_HEADER bmplist_h;
	TCB_PTR	pTcb = NULL;
	
	//fobOj[pϐ
	InitDebugWindow(MainWp);
	
	//C^XNǉ
	pTcb = TCB_Add(DebugListControlTask,MainWp,0);

	//BITMAPj[ǉ
	MainWp->bmplistID = initBmpWin(1);
	GF_BGL_BmpWinAddEx(D_TomoyaFldSys->bgl, MainWp->bmplistID, &MainDebugListWindowData);

	//BMPXgݒ
	MainWp->bmplist = BmpListMake(MainDebugList, NELEMS(MainDebugList));
	bmplist_h = MainDebugListHeader;
	bmplist_h.win = MainWp->bmplistID;
	bmplist_h.list = MainWp->bmplist;

	MainWp->bmplistContID = BmpListSet(&bmplist_h,MainWp->debug_list,MainWp->debug_cursor, HEAPID_FIELD);	
}

//XgRg[
static void DebugListControlTask(TCB_PTR tcb,void* work)
{
	s32	ret_code;
	TCB_FUNC	func;
	DEBUG_WINDOW_DATA	*wp;
	
	wp = (DEBUG_WINDOW_DATA*)work;

	// ̓LZ
	if(KeyNoTouchFlag == 0){
		ret_code = BmpListMain(wp->bmplistContID);

		//L[씻
		if(sys.trg & PAD_BUTTON_A){
			if(ret_code){
				func = (TCB_FUNC)ret_code;
				func(tcb,work);
			}
			return;
		}

		// B{^EBhE
		if(sys.trg & PAD_BUTTON_B){
			EndDebugWind(tcb, work);
			return;
		}
	}
}

// TuʃXgRg[
static void ApplicationControlTask(TCB_PTR tcb,void* work)
{
	s32	ret_code;
	TCB_FUNC	func;
	DEBUG_WINDOW_DATA	*wp;
	
	wp = (DEBUG_WINDOW_DATA*)work;

	ret_code = BmpListMain(wp->bmplistContID);

	//L[씻
	if(sys.trg & PAD_BUTTON_A){
		if(ret_code){
			func = (TCB_FUNC)ret_code;
			func(tcb,work);
		}
	return;
	}

	// B{^EBhE
	if(sys.trg & PAD_BUTTON_B){
		//EBhE
		FreeDebugWindow(tcb,work);
		//^XN
		TCB_Delete(tcb);

		// CXgX^[g
		mainlistStart();
		return;
	}
}

static u32 GetListMax(const BMPLIST_DATA* list )
{
	u32 cnt = 0;

	while(list[cnt].str != BMPLIST_ENDCODE)
	{
		cnt++;
	}

	return cnt;
}

// ApplicationJn֐
static void StartApplication(TCB_PTR tcb,void* work)
{
	DEBUG_WINDOW_DATA*	sub_wp;
	TCB_PTR	pTcb = NULL;
	DEBUG_WINDOW_DATA	*wp;
	u16					num;
	BMPLIST_HEADER bmplist_h;
	
	DT_clact = NULL;
	//-----------------------------------------------------
	//	CEBhEj
	//	Tuʂ̃EBhȄs
	//	TuʃRg[^XN쐬
	//-----------------------------------------------------
	// CEBhERg[f[^擾
	wp = (DEBUG_WINDOW_DATA*)work;
	
	// ̃J[\ʒu擾
	BmpListDirectPosGet(wp->bmplistContID, &num);

	//EBhE
	//Xg̊J
	DebugListFree(tcb,work);
	//^XN
	TCB_Delete(tcb);
	

	// TuEBhERg[̈m
	sub_wp = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WINDOW_DATA));
	if(sub_wp == NULL){
		//[NGA擾łȂΉȂ
		OS_Printf("map_num debug menu crate failed\n");
		return;
	}
	memset(sub_wp,0,sizeof(DEBUG_WINDOW_DATA));

	//fobOj[pϐ
	InitDebugWindow(sub_wp);

	// Applicationf[^wb_ɃZbg
	bmplist_h = SubDebugListHeader[num - MAP_TYPE_LIST_COUNT_NO_SUB];
	sub_wp->bmplist = BmpListMake( bmplist_h.list, GetListMax(bmplist_h.list) );
	bmplist_h.list = sub_wp->bmplist;


	//Tu^XNǉ
	pTcb = TCB_Add(ApplicationControlTask,sub_wp,0);

	//BITMAPj[ǉ
	sub_wp->bmplistID = GF_BGL_BmpWinAllocGet(HEAPID_FIELD, 1);
	GF_BGL_BmpWinAddEx(D_TomoyaFldSys->bgl, sub_wp->bmplistID, &SubDebugListWindowData);

	//BMPXgݒ
	bmplist_h.win = sub_wp->bmplistID;
	sub_wp->bmplistContID = BmpListSet(&bmplist_h,sub_wp->debug_list,sub_wp->debug_cursor, HEAPID_FIELD);
}

extern void InitDebugTouchpanel( void );
extern void D_TouchPanelSet( void );

//-----------------------------------------------------------------------------
//	ANZX֐
//-----------------------------------------------------------------------------
//fobOCEBhE\z֐
void DebugListSetOfTomoya(FIELDSYS_WORK* data)
{
	TCB_PTR	pTcb = NULL;

	D_TomoyaFldSys = data;

	MainWp = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WINDOW_DATA));
	if(MainWp == NULL){
		//[NGA擾łȂΉȂ
		OS_Printf("map_num debug menu crate failed\n");
		return;
	}
	memset(MainWp,0,sizeof(DEBUG_WINDOW_DATA));

	// CXgZbg
	mainlistStart();

	//CxgtbN
	FieldSystemProc_SeqHold();


	return;
}


// GJEgX^[g
static void StartEncount( TCB_PTR tcb,void* work ){
	TCB_PTR tcb_ptr;
	D_TMY_ENC* data;
	
	tcb_ptr = PMDS_taskAdd(MainEncount, sizeof(D_TMY_ENC), 6, HEAPID_FIELD);
	data = TCB_GetWork(tcb_ptr);
	data->no = 0;
	data->flag = 1;
	
//	FieldPoketch_QuitReq( D_TomoyaFldSys );	
	
//*/
/*
	EncountEffectStart(0, D_TomoyaFldSys, NULL);

//*/
	EndDebugWind(tcb, work);
}

// GJEgC
static void MainEncount( TCB_PTR tcb,void* work )
{
/*
	D_TMY_ENC* data = (D_TMY_ENC*)work;

	if(FieldPoketch_QuitWait( D_TomoyaFldSys ) == TRUE){
	
		if(data->flag){
			data->flag = 0;
			data->no++;
		}
		
		if(data->no == 4){
			// I
			PMDS_taskDel(tcb);
		}
	}
//*/
	D_TMY_ENC* data = (D_TMY_ENC*)work;

//	if(FieldPoketch_QuitWait( D_TomoyaFldSys ) == TRUE){
	
		if(data->flag){
			// ǂݍ݊Jnʒu
			CharLoadStartAll();
			PlttLoadStartAll();
			
			data->flag = 0;
			StartUnderGroundEffect( D_TomoyaFldSys , data->no, &data->flag);	
			data->no++;
		}
		
		if(data->no == 4){
			// I
			PMDS_taskDel(tcb);
		}
//	}
}


static void EndDebugWind( TCB_PTR tcb,void* work )
{
	DebugWindowExit(tcb,work);


	
	// }eȀI`FbN
	if(MaterialWinFlag == 1){
		MaterialWinFlag = 0;
		TCB_Delete(materialTCBData);		// ^XNj
		materialTCBData = NULL;

		
		// `
		delBmpWin(D_M_win);
		D_M_win = NULL;
		
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
		GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1 );
	}

	if(FogFlag == 1){
		FogFlag = 0;
		TCB_Delete(FogTCBData);		// ^XNj
		FogTCBData = NULL;
		
		// `
		delBmpWin(FOG_win);
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
		GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1 );

	}

	
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	ŃGtFNg
 *
 *	@param	tcb		TCB[N
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void StartPoison( TCB_PTR tcb,void* work )
{
	TCB_PTR tcb_ptr;
	D_TOMOYA_POISON* data;
	
	tcb_ptr = PMDS_taskAdd(MainPoison, sizeof(D_TOMOYA_POISON), 6, HEAPID_FIELD);
	data = TCB_GetWork(tcb_ptr);
	memset( data, 0, sizeof(D_TOMOYA_POISON) );
	data->camera = D_TomoyaFldSys->camera_ptr;
	
	EndDebugWind(tcb, work);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C
 *
 *	@param	tcb
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
#define D_TOMO_POISON_COUNT		( 4 )
#define D_TOMO_POISON_NEXT		( 64 )
#define D_TOMO_POISON_NUM		( 142 )
static void MainPoison( TCB_PTR tcb,void* work )
{
	D_TOMOYA_POISON* data;
	
	data = work;

	switch( data->seq ){
	case 0:		// 
		data->count = D_TOMO_POISON_COUNT;
		data->num	= D_TOMO_POISON_NUM;
		data->seq++;
		break;

	case 1:		// Z
		GFC_AddCameraPerspWay( -data->num, data->camera );
		data->count --;
		if( data->count <= 0 ){
			data->count = D_TOMO_POISON_COUNT;
			data->seq++;
		}
		break;

	case 2:		// Z
		GFC_AddCameraPerspWay( data->num, data->camera );
		data->count --;
		if( data->count <= 0 ){
			data->count = D_TOMO_POISON_COUNT;
			data->seq++;
		}
		break;

	case 3:
		data->next_count = D_TOMO_POISON_NEXT;
		data->seq ++;
		break;

	case 4:
		data->next_count--;
		if( data->next_count <= 0 ){
			data->seq = 0;
		}
		break;
		
	case 5:
		PMDS_taskDel( tcb );
		break;
	}
}


//-----------------------------------------------------------------------------
/**
 *
 *		C[WNbvvC[\
 * 
 */
//-----------------------------------------------------------------------------
static void StartImcPlay( TCB_PTR tcb,void* work )
{
	TCB_PTR tcb_ptr;
	D_TOMOYA_IMC_PLAY* data;
	IMC_PLAYERSYS_INIT init;
	IMC_SAVEDATA * save_data;
	
	tcb_ptr = PMDS_taskAdd(MainImcPlay, sizeof(D_TOMOYA_IMC_PLAY), 6, HEAPID_FIELD);
	data = TCB_GetWork(tcb_ptr);

	save_data	= SaveData_GetImcSaveData( D_TomoyaFldSys->savedata );

	init.save_data = ImcSaveData_GetOneSaveData( save_data, 0 );
	init.p_bg_ini	= D_TomoyaFldSys->bgl;
	init.heap_id	= HEAPID_FIELD;
	data->p_player	= IMC_PlayerInit( &init );

	// VBlank
	data->v_tcb = VWaitTCB_Add( VblankImcPlay, data, 8 );
	
	EndDebugWind(tcb, work);
}
static void MainImcPlay( TCB_PTR tcb,void* work )
{
	D_TOMOYA_IMC_PLAY* data = work;

	IMC_PlayerMain( data->p_player );


	// B Ŕj
	if( sys.trg & PAD_BUTTON_B ){
		IMC_PlayerEnd( data->p_player );

		TCB_Delete( data->v_tcb );
		PMDS_taskDel( tcb );
	}
}
static void VblankImcPlay( TCB_PTR tcb,void* work )
{
	D_TOMOYA_IMC_PLAY* data = work;

	IMC_PlayerVblank( data->p_player );
}


//-----------------------------------------------------------------------------
/**
 *		3DeNX`]
 */
//-----------------------------------------------------------------------------

static void StartTexTrans( TCB_PTR tcb,void* work )
{
	TCB_PTR tcb_ptr;
	D_TM_TEX_TRANS* data;
	
	tcb_ptr = PMDS_taskAdd(MainTexTrans, sizeof(D_TM_TEX_TRANS), 6, HEAPID_FIELD);
	data = TCB_GetWork(tcb_ptr);
	
//	data->tex_buff	 = sys_LoadFile( HEAPID_FIELD, "data/babyboy1.nsbtx" );
	data->tex_buff	 = sys_LoadFile( HEAPID_FIELD, "data/billboad.nsbmd" );
	data->tex_res	 = NNS_G3dGetTex( data->tex_buff );
	data->trans_num	 = 0;
	data->trans_size = data->tex_res->texInfo.sizeTex << 3;
	data->vram		 = 1;
	
	EndDebugWind(tcb, work);
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`\[Xf[^pVramkey擾
 *
 *	@param	res		eNX`\[X
 *	@param	tex		eNX`L[
 *	@param	tex4x4	4x4keNX`
 *	@param	pltt	pbgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void getVramkey( NNSG3dResTex* res, NNSGfdTexKey* tex, NNSGfdTexKey* tex4x4, NNSGfdPlttKey* pltt )
{
	u32 tex_size;
	u32 tex_4x4_size;
	u32 pltt_size;

	tex_size = NNS_G3dTexGetRequiredSize( res );
	tex_4x4_size = NNS_G3dTex4x4GetRequiredSize(res);
	tex_size = NNS_G3dTexGetRequiredSize( res );
	pltt_size = NNS_G3dPlttGetRequiredSize( res );


	if(tex_size != 0){
		*tex = NNS_GfdAllocTexVram( tex_size, FALSE, 0 );
	}
	if(tex_4x4_size != 0){
		*tex = NNS_GfdAllocTexVram( tex_size, TRUE, 0 );
	}
	if(pltt_size != 0){
		*pltt = NNS_GfdAllocPlttVram( pltt_size, 
			res->tex4x4Info.flag & NNS_G3D_RESPLTT_USEPLTT4, 0 );
	}
}


static void MainTexTrans( TCB_PTR tcb,void* work )
{
	D_TM_TEX_TRANS* data = work;
	int i;
	NNSGfdTexKey tex;
	NNSGfdTexKey tex4x4;
	NNSGfdPlttKey pltt;
	
	for( i=0; i<data->trans_num; i++ ){

		if( data->vram ){
			AddVramTransferManager( 
					NNS_GFD_DST_3D_TEX_VRAM,
					0,
					(u8*)data->tex_res + data->tex_res->texInfo.ofsTex,
					data->trans_size );
		}else{
			getVramkey( data->tex_res, &tex, &tex4x4, &pltt );

			NNS_G3dTexSetTexKey(data->tex_res, tex, tex4x4);
			NNS_G3dPlttSetPlttKey(data->tex_res, pltt);

			// VRAMւ̃[h
			NNS_G3dTexLoad(data->tex_res, TRUE);
			NNS_G3dPlttLoad(data->tex_res, TRUE);

			// eNX`L[Ƃ͔j
			NNS_GfdFreeTexVram( tex );
			// pbgL[j
			NNS_GfdFreePlttVram( pltt );
		
			/*
			GX_LoadTex( 
					(u8*)data->tex_res + data->tex_res->texInfo.ofsTex,
					0,
					data->trans_size);//*/
		}
	}

	if( sys.cont & PAD_BUTTON_A ) {

		if( sys.trg & PAD_KEY_UP ){
			data->trans_num ++;
			OS_Printf( "trans_data num[%d] tex_size[0x%x]\n", data->trans_num, data->trans_size );
		}else{
			if( sys.trg & PAD_KEY_DOWN ){
				data->trans_num --;
				OS_Printf( "trans_data num[%d] tex_size[0x%x]\n", data->trans_num, data->trans_size );
			}
		}
		
	}

	if( sys.trg & PAD_BUTTON_Y ){

		data->vram = (data->vram + 1) & 0x1;
		OS_Printf( "1:vram 0:now [%d]\n", data->vram );
	}

	// B{^	I
	if( sys.trg & PAD_BUTTON_B ){

		sys_FreeMemoryEz( data->tex_buff );
		PMDS_taskDel( tcb );
	}
}


static void StartWipe( TCB_PTR tcb,void* work )// ʐ؂ւJn
{
	TCB_PTR tcb_ptr;
	D_TMY_WIPE* data;
	
	tcb_ptr = PMDS_taskAdd(MainWipe, sizeof(D_TMY_WIPE), 6, HEAPID_FIELD);
	data = TCB_GetWork(tcb_ptr);
	data->seq = 0;	
	data->end_flg = FALSE;
	data->no	= 0;
	
	EndDebugWind(tcb, work);
}

static void MainWipe( TCB_PTR tcb,void* work )// ʐ؂ւC
{
	D_TMY_WIPE* data = (D_TMY_WIPE*)work;
	
	switch(data->seq){
	case 0:
		// Ԕj
		WIPE_Start(WIPE_PATTERN_FSAM,
			data->no, data->no,
			WIPE_FADE_WHITE,
			8,2, HEAPID_FIELD, &data->end_flg);

		if( data->no == WIPE_TYPE_SHUTTEROUT_DOWN ){
			WIPE_ResetBrightness( WIPE_DISP_MAIN );
			WIPE_ResetBrightness( WIPE_DISP_SUB );
		}
		data->seq++;
		break;

	case 1:
		if (data->end_flg == TRUE) {
			data->end_flg = FALSE;
			data->seq = 0;

			data->no += 1;

			if( data->no >= WIPE_TYPE_MAX ){
				WIPE_Reset( WIPE_DISP_MAIN );
				WIPE_Reset( WIPE_DISP_SUB );
				PMDS_taskDel( tcb );
			}else{

				if( sys.cont & PAD_BUTTON_B ){

					PMDS_taskDel( tcb );
				}
			}
		}
		break;
	}
}



// Jn|PI
//----------------------------------------------------------------------------
/**
 *	@brief	Jn|PI
 *
 *	@param	TCB_PTR tcb
 *	@param	work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void StartEvPokeSelect_Check( TCB_PTR tcb, void* work )
{
	DT_SPRITE_CHECK* DT_sprite = NULL;
	EV_POKESELECT_PEARENT_DATA* p_pearent;

	// ^XN
	DT_sprite = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof( DT_SPRITE_CHECK ) );
	// ZAN^[o^
	TCB_Add(MainEvPokeSelect_Check, DT_sprite, 8);

	DT_sprite->seq = 0;
	DT_sprite->sub = 0;

	// yAgf[^쐬
	p_pearent = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof(EV_POKESELECT_PEARENT_DATA) );
	DT_sprite->p_pearent = p_pearent;
	
	EndDebugWind(tcb, work);
}

//----------------------------------------------------------------------------
/**
 *	@brief	Jn|PI
 *
 *	@param	tcb
 *	@param	work 
 *
 *	@return
 */
//-----------------------------------------------------------------------------
static void MainEvPokeSelect_Check( TCB_PTR tcb, void* work )
{
	DT_SPRITE_CHECK* data = work;
	
	switch( data->seq ){
	case 0:		// tF[hAEg
		WIPE_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,
				0,
				8,2,
				HEAPID_FIELD,
				&data->sub);
		data->tmp_seq = 2;
		data->seq++;
		break;

	case 1:	// tF[h҂	
		if( data->sub ){

			data->sub = 0;
			data->seq = data->tmp_seq;
		}
		break;

	case 2:		// I
		Field_EVPokeSelect_SetProc( D_TomoyaFldSys, data->p_pearent );
		data->seq++;	
		break;

	case 3:		// II҂
		if( GameSystem_CheckSubProcExists( D_TomoyaFldSys ) == FALSE ){

			// 擾ް\
			{
				EV_POKESELECT_PEARENT_DATA* p_pearent;

				p_pearent = data->p_pearent;

#if 0
				switch( p_pearent->select_monsno ){
				case MONSNO_NAEGAME:
					OS_Printf( "Ȃ\n" );
					break;
				case MONSNO_HINOKOZARU:
					OS_Printf( "Ђ̂\n" );
					break;
				case MONSNO_UMIOUZI:
					OS_Printf( "݂\n" );
					break;

				default:
					OS_Printf( "\n" );
					break; 
				}
#endif
			}
			
			// tB[hA
			GameSystem_CreateFieldProc( D_TomoyaFldSys );
			data->seq++;
		}
		break;

	case 4:
		// tB[hA`FbN
		if( GameSystem_CheckFieldProcExists(D_TomoyaFldSys) ){
/*		tB[h͎ŃtF[hC邽
 *		RgAEg */
			WIPE_Start( 
					WIPE_PATTERN_FSAM,
					WIPE_TYPE_FADEIN,
					WIPE_TYPE_FADEIN,
					0,
					8,2,
					HEAPID_FIELD,
					&data->sub);
			// tF[hC
			data->seq = 1;
			data->tmp_seq = 5;//*/
/*			WIPE_Start( 
					WIPE_PATTERN_S,
					WIPE_TYPE_FADEIN,
					WIPE_TYPE_FADEIN,
					0,
					8,2,
					HEAPID_FIELD,
					&data->sub);
			// tF[hC
			data->seq = 1;
			data->tmp_seq = 5;//*/
		}
		break;

	case 5:		// I
		sys_FreeMemoryEz( data->p_pearent );
		// ^XNI
		TCB_Delete( tcb );
		sys_FreeMemoryEz( work );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}Ӄ`FbN
 *
 *	@param	TCB_PTR tcb
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void StartZukan_Check( TCB_PTR tcb,void* work )
{
	DT_SPRITE_CHECK* DT_sprite = NULL;
	ZKN_PEARENT_DATA* p_pearent;
	ZUKAN_WORK* p_zukan;
	MYSTATUS* p_hero;
	static BOOL init_flg = 0;

	// ^XN
	DT_sprite = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof( DT_SPRITE_CHECK ) );
	// ZAN^[o^
	TCB_Add(MainZukan_Check, DT_sprite, 8);

	DT_sprite->seq = 0;
	DT_sprite->sub = 0;

	// yAgf[^쐬
	p_pearent = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof(ZKN_PEARENT_DATA) );
	p_zukan = SaveData_GetZukanWork( D_TomoyaFldSys->savedata );
	p_hero = SaveData_GetMyStatus(D_TomoyaFldSys->savedata);
	p_pearent->cp_zukansave_data = p_zukan;
	p_pearent->cp_hero_data = p_hero;
	p_pearent->time_zone = EVTIME_GetTimeZone( D_TomoyaFldSys );
	
	if( init_flg == FALSE ){
		init_flg = TRUE;

/*		// ɂȂ
		MyStatus_SetMySex(p_hero, 1);//*/

		
		// S}ӂƂɂ
		ZukanWork_SetZenkokuZukanFlag( p_zukan );
		

		// |Pf[^Ƒ₷
		Debug_ZukanWork_Make( p_zukan, 0 );
	}
	
	DT_sprite->p_pearent = p_pearent;
	
	EndDebugWind(tcb, work);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	}ӎs
 *
 *	@param	TCB_PTR tcb
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void MainZukan_Check( TCB_PTR tcb, void* work ) 
{
	DT_SPRITE_CHECK* data = work;
	
	switch( data->seq ){
	case 0:		// tF[hAEg
		WIPE_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,
				0,
				8,2,
				HEAPID_FIELD,
				&data->sub);
		data->tmp_seq = 2;
		data->seq++;
		break;

	case 1:	// tF[h҂	
		if( data->sub ){

			data->sub = 0;
			data->seq = data->tmp_seq;
		}
		break;

	case 2:		// }ӏ
		FieldZukan_SetProc( D_TomoyaFldSys, data->p_pearent );
		data->seq++;	
		break;

	case 3:		// }ӏI҂
		if( GameSystem_CheckSubProcExists( D_TomoyaFldSys ) == FALSE ){

			// tB[hA
			GameSystem_CreateFieldProc( D_TomoyaFldSys );
			data->seq++;
		}
		break;

	case 4:
		// tB[hA`FbN
		if( GameSystem_CheckFieldProcExists(D_TomoyaFldSys) ){
/*		tB[h͎ŃtF[hC邽
 *		RgAEg */
			WIPE_Start( 
					WIPE_PATTERN_FSAM,
					WIPE_TYPE_FADEIN,
					WIPE_TYPE_FADEIN,
					0,
					8,2,
					HEAPID_FIELD,
					&data->sub);
			// tF[hC
			data->seq = 1;
			data->tmp_seq = 5;//*/
/*			WIPE_Start( 
					WIPE_PATTERN_S,
					WIPE_TYPE_FADEIN,
					WIPE_TYPE_FADEIN,
					0,
					8,2,
					HEAPID_FIELD,
					&data->sub);
			// tF[hC
			data->seq = 1;
			data->tmp_seq = 5;//*/
		}
		break;

	case 5:		// I
		sys_FreeMemoryEz( data->p_pearent );
		// ^XNI
		TCB_Delete( tcb );
		sys_FreeMemoryEz( work );
		break;
	}
}




//----------------------------------------------------------------------------
/**
 *
 *	@brief
 *
 *	@param	TCB_PTR tcb
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void StartSprite_Check( TCB_PTR tcb,void* work )
{
	DT_SPRITE_CHECK* DT_sprite = NULL;
	IMC_PROC_WORK* imc_w;
	POKEMON_PARAM* poke;
	RTCTime time;
	int poke_no;
	IMC_SAVEDATA* p_save;
	IMC_ONE_SAVEDATA* p_save_one;

	// ^XN
	DT_sprite = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof( DT_SPRITE_CHECK ) );
	// ZAN^[o^
	TCB_Add(MainSprite_Check, DT_sprite, 8);

	DT_sprite->seq = 0;
	DT_sprite->sub = 0;

	// C[WNbvɓnf[^쐬
	imc_w = sys_AllocMemory( HEAPID_BASE_DEBUG, sizeof( IMC_PROC_WORK ) );
	memset( imc_w, 0, sizeof( IMC_PROC_WORK ) );
	// |Pp		͓KɎԂɂĕҏW|PI
	RTC_GetTime( &time );
	poke_no = time.second;
	poke_no += time.hour * 20;
	poke_no =  1 + (poke_no % MONSNO_END);
	poke = PokemonParam_AllocWork( HEAPID_BASE_DEBUG );
	PokeParaSet( poke, poke_no, 5, POW_RND, RND_NO_SET, 0, ID_NO_RARE, 0 );
	imc_w->p_poke_para = poke;
	// Z[uf[^
	p_save = SaveData_GetImcSaveData( D_TomoyaFldSys->savedata );
	ImcSaveData_ClaenOneSaveData( p_save, 0 );		// ҏW郏[N
	p_save_one = ImcSaveData_GetOneSaveData( p_save, 0 );
	imc_w->p_imc_one_data = p_save_one;
	
	// ʂ̃f[^ݒ
	DT_sprite->p_pearent = imc_w;
	
	EndDebugWind(tcb, work);
}

static inline void debug_savedata_print( IMC_ONE_SAVEDATA* p_save_one )
{
	int i;
	
	OS_Printf( "X^[io[%d\n", ImcSaveData_GetPokeMonsNo( p_save_one ) );
	OS_Printf( "X^[D揇%d\n", ImcSaveData_GetPokePri( p_save_one ) );
	OS_Printf( "X^[Wx[%d] y[%d]\n", ImcSaveData_GetPokeX( p_save_one ), ImcSaveData_GetPokeY( p_save_one ) );

	for( i=0; i<IMC_RBOX_OBJ_MAX; i++ ){
	
		if( ImcSaveData_CheckAcceDataSet( p_save_one, i ) ){
			OS_Printf( "ANZTio[%d\n", ImcSaveData_GetAcceNo( p_save_one, i ) );
			OS_Printf( "ANZTx[%d] y[%d]\n", ImcSaveData_GetAcceMatX( p_save_one, i ), ImcSaveData_GetAcceMatY( p_save_one, i ) );
			OS_Printf( "ANZTD揇%d\n", ImcSaveData_GetAccePri( p_save_one, i ) );
		}
	}

	OS_Printf( "BG %d\n", ImcSaveData_GetBgId( p_save_one ) );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief
 *
 *	@param	TCB_PTR tcb
 *	@param	work 
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void MainSprite_Check( TCB_PTR tcb, void* work ) 
{
	DT_SPRITE_CHECK* data = work;
	
	switch( data->seq ){
	case 0:		// tF[hAEg
		WIPE_Start( 
				WIPE_PATTERN_FMAS,
				WIPE_TYPE_FADEOUT,
				WIPE_TYPE_FADEOUT,
				0,
				8,2,
				HEAPID_FIELD,
				&data->sub);
		data->tmp_seq = 2;
		data->seq++;
		break;

	case 1:	// tF[h҂	
		if( data->sub ){

			data->sub = 0;
			data->seq = data->tmp_seq;
		}
		break;

	case 2:		// C[WNbv
		FieldImageClip_SetProc( D_TomoyaFldSys, data->p_pearent );
		data->seq++;	
		break;

	case 3:		// C[WNbvI҂
		if( GameSystem_CheckSubProcExists( D_TomoyaFldSys ) == FALSE ){


			// vbNf[^j
			{
				IMC_PROC_WORK* imc_w = data->p_pearent;

				// Z[uf[^\
				debug_savedata_print( imc_w->p_imc_one_data );

				sys_FreeMemoryEz( imc_w->p_poke_para );
				sys_FreeMemoryEz( imc_w );
			}


			// tB[hA
			GameSystem_CreateFieldProc( D_TomoyaFldSys );
			data->seq++;
		}
		break;

	case 4:
		// tB[hA`FbN
		if( GameSystem_CheckFieldProcExists(D_TomoyaFldSys) ){
/*		tB[h͎ŃtF[hC邽
 *		RgAEg */
			WIPE_Start( 
					WIPE_PATTERN_FSAM,
					WIPE_TYPE_FADEIN,
					WIPE_TYPE_FADEIN,
					0,
					8,2,
					HEAPID_FIELD,
					&data->sub);
			// tF[hC
			data->seq = 1;
			data->tmp_seq = 5;//*/
/*			WIPE_Start( 
					WIPE_PATTERN_S,
					WIPE_TYPE_FADEIN,
					WIPE_TYPE_FADEIN,
					0,
					8,2,
					HEAPID_FIELD,
					&data->sub);
			// tF[hC
			data->seq = 1;
			data->tmp_seq = 5;//*/
		}
		break;

	case 5:		// I
		// ^XNI
		TCB_Delete( tcb );
		sys_FreeMemoryEz( work );
		break;
	}
}

/*[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
 *
 *
 *	ZAN^[`FbNp
 *					JnVXe
 * 
 *				
 [[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[*/
//----------------------------------------------------------------------------
/**
 *
 *@brief	Jn
 *
 *@param	tcb
 *@param	work 
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void StartCLACT_Check( TCB_PTR tcb,void* work )
{
	NNSG2dViewRect rect;
	int i;
	int size;
	CLACT_U_RES_HEADER_PTR res_head;
	void* buff;
	
	if(DT_clact == NULL){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );

		// m
		DT_clact = sys_AllocMemory(HEAPID_FIELD, sizeof(DT_CLACT));
		memset(DT_clact, 0, sizeof(DT_CLACT));

		// LN^}l[W
		{
			CHAR_MANAGER_MAKE init = {
				32, 0x2000, 0x2000, HEAPID_FIELD
			};

			DeleteCharManager();
			InitCharManager(&init);
		}

		// pbg}l[W
		DeletePlttManager();
		InitPlttManager(32, HEAPID_FIELD);

		
		// OAM}l[W[̏
		NNS_G2dInitOamManagerModule();
		

		// ZVram]}l[W쐬
		DT_clact->cellTransArray = InitCellTransfer(32, HEAPID_FIELD);


/*		// AN^[Zbg쐬
		{
			CLACT_SETDATA	set;
			set.WorkNum = 32;
			set.pRender	= &DT_clact->rend;
			set.heap	= HEAPID_FIELD;
			
			DT_clact->clactSet = CLACT_InitSet( &set );
		}//*/

		// ȈՓo^
		{
			// _pOAM}l[W쐬
			// ō쐬OAM}l[W݂ȂŋL
/*			REND_OAMInit( 
					0, 16,		// COAMǗ̈
					0, 4,		// CʃAtBǗ̈
					0, 16,		// TuOAMǗ̈
					0, 4,		// TuʃAtBǗ̈
					HEAPID_FIELD);//*/	// LOAMfieldmap.cō쐬ς

			// ȈՃZAN^[Zbg쐬
			// ō쐬LOAM}l[Wgpă_[쐬A
			// ZAN^[Zbg̍쐬s
			DT_clact->clactSet = CLACT_U_SetEasyInit( 10, &DT_clact->renddata, HEAPID_FIELD );
		}

		// \[X}l[W쐬
		for(i=0; i<=CLACT_U_MULTIANM_RES;i++){
			DT_clact->resMan[i] = CLACT_U_ResManagerInit(16, i, HEAPID_FIELD);
		}

		// \[X}l[Wpwb_̈쐬
		size = CLACT_U_ResManagerGetHeaderSize();
		DT_clact->resHeader = sys_AllocMemory(HEAPID_FIELD, size * 6);
		
		// \[X}l[Wpwb_ǂݍ
		// char
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 0);
		buff = sys_LoadFile( HEAPID_FIELD, "data/uground_char.resdat" );
		
		CLACT_U_ResManagerHeaderLoadBinary(
				buff,	// LN^
				res_head, HEAPID_FIELD);
		sys_FreeMemoryEz( buff );

		// pltt
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 1);
		buff = sys_LoadFile( HEAPID_FIELD, "data/uground_pltt.resdat" );
		CLACT_U_ResManagerHeaderLoadBinary(
				buff,	// pbg
				res_head, HEAPID_FIELD);
		sys_FreeMemoryEz( buff );
		
		// cell
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 2);
		buff = sys_LoadFile( HEAPID_FIELD, "data/uground_cell.resdat" );
		CLACT_U_ResManagerHeaderLoadBinary(
				buff,	// Z
				res_head, HEAPID_FIELD);
		sys_FreeMemoryEz( buff );
		
		// cellanm
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 3);
		buff = sys_LoadFile( HEAPID_FIELD, "data/uground_cellanm.resdat" );
		CLACT_U_ResManagerHeaderLoadBinary(
				buff,	// ZAj
				res_head, HEAPID_FIELD);
		sys_FreeMemoryEz( buff );
		
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 4);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_multi.txt",	// }`Z
				res_head, HEAPID_FIELD);
		
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 5);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_multianm.txt",// }`ZAj
				res_head, HEAPID_FIELD);//*/

		/*
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 0);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_char.txt",	// LN^
				res_head, HEAPID_FIELD);

		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 1);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_pltt.txt",	// pbg
				res_head, HEAPID_FIELD);
		
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 2);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_cell.txt",	// Z
				res_head, HEAPID_FIELD);
		
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 3);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_cellanm.txt",	// ZAj
				res_head, HEAPID_FIELD);
		
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 4);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_multi.txt",	// }`Z
				res_head, HEAPID_FIELD);
		
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 5);
		CLACT_U_ResManagerHeaderLoad("data/dt_test_res_multianm.txt",// }`ZAj
				res_head, HEAPID_FIELD);//*/
		

		// \[X}l[Wɓo^f[^ǂݍ
		//
		// \[XIuWFe[u쐬
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 0);
		size = CLACT_U_ResManagerHeaderSetDataNum(res_head);
		DT_clact->resObjTbl[0] = CLACT_U_ResManagerResObjTblMake(size, HEAPID_FIELD);
		
		// LN^f[^ǂݍ
		DT_clact->resObjNum[0] = CLACT_U_ResManagerResAddsHd(
				DT_clact->resMan[0],
				res_head,
				DT_clact->resObjTbl[0],
				HEAPID_FIELD);
		
		// \[XIuWFe[u쐬
		res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, 1);
		size = CLACT_U_ResManagerHeaderSetDataNum(res_head);
		DT_clact->resObjTbl[1] = CLACT_U_ResManagerResObjTblMake(size, HEAPID_FIELD);
		
		// pbgf[^ǂݍ
		DT_clact->resObjNum[1] = CLACT_U_ResManagerResAddsHd(
				DT_clact->resMan[1],
				res_head,
				DT_clact->resObjTbl[1],
				HEAPID_FIELD);

		// ̑\[XIuWFe[u쐬ȂĂǂ\[Xǂݍ
		// iID̎擾A\[X擾ȂǂɃ\[XIuWF͕KvłBj
		for(i=CLACT_U_CELL_RES;i<=CLACT_U_MULTIANM_RES;i++){
			res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, i);
			DT_clact->resObjNum[i] = CLACT_U_ResManagerResAddsHd(
					DT_clact->resMan[i],
					res_head,
					NULL,
					HEAPID_FIELD);
		}

		
		// LN^ǂݍ݊JnItZbgݒ
		CharLoadStartAll();

		// pbgǂݍ݊JnItZbgݒ
		PlttLoadStartAll();

//		GX_SetOBJVRamModeChar( GX_OBJVRAMMODE_CHAR_2D );
//		GXS_SetOBJVRamModeChar( GX_OBJVRAMMODE_CHAR_2D );
		GX_SetOBJVRamModeChar( GX_OBJVRAMMODE_CHAR_1D_32K );
		GXS_SetOBJVRamModeChar( GX_OBJVRAMMODE_CHAR_1D_32K );
		
		{
			int i;
			for(i=0; i< 5; i++){
				// LN^}l[Wɓo^
				// Vramɔzu܂B
				CLACT_U_CharManagerSetsCharModeAdjustAreaCont(DT_clact->resObjTbl[0]);

				CLACT_U_CharManagerDeletes(DT_clact->resObjTbl[0]);
			}
		}
		CLACT_U_CharManagerSetsCharModeAdjustAreaCont(DT_clact->resObjTbl[0]);

		// pbg}l[Wɓo^
		// Vramɔzu܂B
		{
			int i;
			for(i=0;i<10;i++){
				CLACT_U_PlttManagerSetsCleanArea(DT_clact->resObjTbl[1]);
				CLACT_U_PlttManagerDeletes(DT_clact->resObjTbl[1]);
			}
			CLACT_U_PlttManagerSetsCleanArea(DT_clact->resObjTbl[1]);
		}

		// ZAN^[wb_ǂݍ
		buff = sys_LoadFile( HEAPID_FIELD, "data/uground_clact.cldat" );
		DT_clact->clactHeader = CLACT_U_MakeHeaderBinary(
				buff,HEAPID_FIELD,
				DT_clact->resMan[0], DT_clact->resMan[1], DT_clact->resMan[2],
				DT_clact->resMan[3], DT_clact->resMan[4], DT_clact->resMan[5]);
		sys_FreeMemoryEz( buff );

		// ZAN^[o^
		DT_clact->tcb = TCB_Add(MainCLACT_Check, DT_clact, 8);
	
		//EBhE
		FreeDebugWindow(tcb,work);
		//^XN
		TCB_Delete(tcb);

		// CXgZbg
		mainlistStart();//*/

	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C֐io^jj
 *
 *@param	tcb
 *@param	work 
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void MainCLACT_Check( TCB_PTR tcb,void* work )
{
	static count;
	DT_CLACT* data = (DT_CLACT*)work;
	CLACT_ADD add;
	CLACT_HEADER_PTR head;
	int i;

	// Aœo^
	if(sys.trg & PAD_BUTTON_A){
		if(data->add_num < 10){
			
			add.ClActSet	= data->clactSet;
			add.ClActHeader	= &data->clactHeader->tbl[0];
			
			// Vram]̎ImageProxyĎ擾
		/*	if(data->clactHeader->tbl[1].flag == 1){
				head = &data->clactHeader->tbl[2];
				head->pImageProxy = GetCharVramTransProxyCopy(head->pImageProxy, head->pCellBank->pVramTransferData->szByteMax);
			}//*/
			
			add.mat.x		= FX32_CONST(32) * (count + 1);
			add.mat.y		= FX32_CONST(96) + SUB_SURFACE_Y;
			add.mat.z		= 0;
			add.sca.x		= FX32_ONE;
			add.sca.y		= FX32_ONE;
			add.sca.z		= FX32_ONE;
			add.rot			= 0;
			add.pri			= 0;
			add.DrawArea	= 2;
			add.heap		= HEAPID_FIELD;
			data->clact_w[data->add_num] = CLACT_Add(&add);
			CLACT_SetAffineParam( data->clact_w[ data->add_num ], CLACT_AFFINE_NORMAL );
			data->add_num++;
			count = (count + 1) % 3;
		}
	}//*/

	// IuWFAj
	for(i=0;i<data->add_num;i++){
		static count = 0;
		CLACT_SetRotation(data->clact_w[i], count);
		count = (count + 182) % (360*182);
	}

	if(sys.trg & PAD_BUTTON_L){
		CLACT_SetFlip(data->clact_w[ 0 ], CLACT_FLIP_HV);
	}
	if(sys.trg & PAD_BUTTON_Y){
		CLACT_SetAffineParam(data->clact_w[ 0 ], CLACT_AFFINE_NORMAL);
	}
	if(sys.trg & PAD_BUTTON_B){
		CLACT_SetFlip( data->clact_w[ 0 ], CLACT_FLIP_NONE );
		CLACT_SetAffineParam( data->clact_w[ 0 ], CLACT_AFFINE_NONE );
	}
	
	// BŔj
/*	if(sys.trg & PAD_BUTTON_B){
		if(data->add_num > 0){
			data->add_num--;
			CLACT_Delete(data->clact_w[data->add_num]);
		}
	}//*/


	// `
	CLACT_Draw(data->clactSet);

	// Vram]^XNݒ
	UpdateCellTransfer();

	// VBlank֐i{VuNԒj
	// _[LOAM}l[WOAM]
//	REND_OAMTrans();		LOAM}l[Wf[^̓]fieldmap.cŎsς
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	I
 *
 *@param	tcb
 *@param	work 
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static void EndCLACT_Check( TCB_PTR tcb,void* work )
{
	int i;
	CLACT_U_RES_HEADER_PTR res_head;
	
	if(DT_clact != NULL){
		// OAM`~
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_OFF );
		
		// AN^[Zbgj
		CLACT_DestSet(DT_clact->clactSet);

		// ZAN^[wb_[j
		CLACT_U_CLACT_HeaderTblDelete(DT_clact->clactHeader);

		// \[Xwb_[j
		for(i=0;i<= CLACT_U_MULTIANM_RES;i++){
			res_head = CLACT_U_ResManagerGetHeaderNoData(DT_clact->resHeader, i);
			CLACT_U_ResManagerHeaderFree(res_head);
		}
		sys_FreeMemoryEz(DT_clact->resHeader);

		// LN^f[^j
		CLACT_U_CharManagerDeletes( DT_clact->resObjTbl[0] );
		
		// pbgf[^j
		CLACT_U_PlttManagerDeletes( DT_clact->resObjTbl[1] );
	
		// LN^ƃpbg̃\[XIuWFe[uj
		for(i=0;i<2;i++){
			CLACT_U_ResManagerResObjTblDelete(DT_clact->resObjTbl[i]);
		}
		
		// \[X}l[Wj
		for(i=0;i<=CLACT_U_MULTIANM_RES;i++){
			CLACT_U_ResManagerDelete(DT_clact->resMan[i]);
		}

		// ZVram]}l[Wj
		DeleteCellTransfer(DT_clact->cellTransArray);


		// LN^}l[Wj
		DeleteCharManager();

		// pbg}l[Wj
		DeletePlttManager();
		
		// _[LOAM}l[Wj
//		REND_OAM_Delete();		 LOAM̔jfieldmap.cs܂B

		// tcbj
		TCB_Delete(DT_clact->tcb);
		sys_FreeMemoryEz(DT_clact);
		DT_clact = NULL;

		//EBhE
		FreeDebugWindow(tcb,work);
		//^XN
		TCB_Delete(tcb);

		// CXgZbg
		mainlistStart();//*/
	}
}


/*[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
 *				}eA
 [[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[*/

//----------------------------------------------------------------------------
/**
 *
 *@brief	}eÃfobNEBhEX^[g
 *
 *@param	^XNp
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void StartMaterialWindow( TCB_PTR tcb,void* work )
{
	int i;		// [vp

	// ^XNZbg
	if(MaterialWinFlag == 0){
		MaterialWinFlag = 1;
		if(D_TomoyaFldSys->light_cont_data->DataNum > 0){
		
			DebugMaterial = &D_TomoyaFldSys->light_cont_data->pDataTbl[0];	// 삷e[uZbg

			SetVecsRotas( MaterialrotaY, MaterialrotaXZ, DebugMaterial );
		
			materialTCBData =  TCB_Add(MainMaterialWindow,NULL,8);

			// ͂^C~O
			MT_InputNow = MT_INPUT_MAX;
			MT_InputCount = 0;

		
			GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1 );
			// `ʂ쐬
			{	// SUB DISP BG1
				GF_BGL_BGCNT_HEADER SBg1_Data = {
					0, 0, 0x800, 0,
					GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
					GX_BG_SCRBASE_0x4000, GX_BG_CHARBASE_0x00000,
					GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
				};
				GF_BGL_BGControlSet( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1, &SBg1_Data, GF_BGL_MODE_TEXT );
			}//*/

			D_M_win = initBmpWin(1);
			GF_BGL_BmpWinAdd(D_TomoyaFldSys->bgl, D_M_win, FLD_SBGFRM_EFFECT1, 0, 0, 24, 20, 0, 1 );

			GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
			GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );

			DrawMenu(MaterialCount);
		}
		//EBhE
		FreeDebugWindow(tcb,work);
		//^XN
		TCB_Delete(tcb);
	
		// CXgZbg
		mainlistStart();
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	}eÃfobNEBhEI
 *
 *@param	^XNp
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void EndMaterialWindow( TCB_PTR tcb,void* work )
{
	int i;

	
	if(MaterialWinFlag == 1){
		MaterialWinFlag = 0;
		TCB_Delete(materialTCBData);		// ^XNj
		materialTCBData = NULL;
			
		// `
		delBmpWin(D_M_win);
		D_M_win = NULL;

		GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1 );
		
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
		//GF_BGL_BGControlExit( FLD_SBGFRM_EFFECT1 );
		//EBhE
		FreeDebugWindow(tcb,work);
		//^XN
		TCB_Delete(tcb);
	
		// CXgZbg
		mainlistStart();
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	}eÃfobNEBhEC
 *
 *@param	^XNp
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void MainMaterialWindow( TCB_PTR tcb,void* work )
{
	int i;			// [vp
	s16 data;		// Ɨp
	u8	draw_flag = 0;	// `揑tO

	KeyNoTouchFlag = 1;// L[bN
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );	// \It

	
	if(sys.trg & PAD_KEY_LEFT){
		MaterialCount--;
		if(MaterialCount < 0){
			MaterialCount += DEB_MATE_NUM;
		}
		draw_flag = 1;
		
	}

	if(sys.trg & PAD_KEY_RIGHT){
		MaterialCount = (MaterialCount + 1) % DEB_MATE_NUM;
		draw_flag = 1;
	}

	// オĂĂق̃{^ĂȂƂ͍Ō̉ʂɔ
	if( (sys.cont == PAD_KEY_UP) ){
		MaterialCount = DEB_WIN;
	}


	// L,RŃf[^ύX
	if(sys.trg & PAD_BUTTON_L){
		MaterialDataNo--;
		if(MaterialDataNo < 0){
			MaterialDataNo += D_TomoyaFldSys->light_cont_data->DataNum;
		}
		DebugMaterial = &D_TomoyaFldSys->light_cont_data->pDataTbl[MaterialDataNo];
		
		SetVecsRotas( MaterialrotaY, MaterialrotaXZ, DebugMaterial );
		draw_flag = 1;
	}
	if(sys.trg & PAD_BUTTON_R){
		MaterialDataNo = (MaterialDataNo + 1) % D_TomoyaFldSys->light_cont_data->DataNum;
		DebugMaterial = &D_TomoyaFldSys->light_cont_data->pDataTbl[MaterialDataNo];

		SetVecsRotas( MaterialrotaY, MaterialrotaXZ, DebugMaterial );
		draw_flag = 1;
	}

	// ̓JEg
	if(MT_InputCount > 0){
		MT_InputCount--;
	}
	// UPDOWN̓͂ȂMT_InputNow̒lőɂ
	if(!((sys.cont & PAD_KEY_UP) ||
	   (sys.cont & PAD_KEY_DOWN))){
		MT_InputNow = MT_INPUT_MAX;
		MT_InputCount = 0;
	}

	i = 0;
	
	// e}eA̒lύX
	switch(MaterialCount){
	case DEB_MATE_LIGHT_END:		// CgIt[
		if(sys.cont & PAD_BUTTON_B){
			draw_flag |= NumInput(&(DebugMaterial->lightEnd), 1, 0xffffffff);
		}
		if(sys.cont & PAD_BUTTON_A){
			draw_flag |= NumInput(&(DebugMaterial->lightEnd), 10, 0xffffffff);
		}
		if(sys.cont & PAD_BUTTON_X){
			draw_flag |= NumInput(&(DebugMaterial->lightEnd), 100, 0xffffffff);
		}
		if(sys.cont & PAD_BUTTON_Y){
			draw_flag |= NumInput(&(DebugMaterial->lightEnd), 1000, 0xffffffff);
		}
		
		break;
		
	case DEB_MATE_LIGHT_FLAG:		// ǂ̃Cggp邩
		if(sys.trg & PAD_BUTTON_Y){	// 0
			DebugMaterial->lightFlag ^= 0x01;
			draw_flag = 1;
		}
		if(sys.trg & PAD_BUTTON_X){	//1
			DebugMaterial->lightFlag ^= 0x02;
			draw_flag = 1;
		}
		if(sys.trg & PAD_BUTTON_A){	//2
			DebugMaterial->lightFlag ^= 0x04;
			draw_flag = 1;
		}
		if(sys.trg & PAD_BUTTON_B){	//3
			DebugMaterial->lightFlag ^=0x08;
			draw_flag = 1;
		}
		break;
		
		
	case DEB_MATE_LIGHT_COLOR_3:
		i++;
	case DEB_MATE_LIGHT_COLOR_2:
		i++;
	case DEB_MATE_LIGHT_COLOR_1:	
		i++;
	case DEB_MATE_LIGHT_COLOR_0:	// Cg̃J[
		if(MT_InputCount == 0){
			if(sys.cont & PAD_BUTTON_Y){	// 
				data = DebugMaterial->lightColor[i];
				data &= 0x001f;
				draw_flag |= ColorInput(&data);				// 
				DebugMaterial->lightColor[i] &= 0xffe0;		// 0NA
				DebugMaterial->lightColor[i] |= data;
			}

			if(sys.cont & PAD_BUTTON_X){
				data = DebugMaterial->lightColor[i] >> 5;
				data &= 0x001f;
				draw_flag |= ColorInput(&data);				// 
				DebugMaterial->lightColor[i] &= 0xfc1f;		// 0NA
				DebugMaterial->lightColor[i] |= data << 5;
			}

			if(sys.cont & PAD_BUTTON_A){
				data = DebugMaterial->lightColor[i] >> 10;
				draw_flag |= ColorInput(&data);				// 
				DebugMaterial->lightColor[i] &= 0x03ff;		// 0NA
				DebugMaterial->lightColor[i] |= data << 10;
			}
		}
		break;

	case DEB_MATE_LIGHT_VEC_3:
		i++;
	case DEB_MATE_LIGHT_VEC_2:
		i++;
	case DEB_MATE_LIGHT_VEC_1:	
		i++;
	case DEB_MATE_LIGHT_VEC_0:	// Cg̃xNg
		
		draw_flag |= VecInput(&MaterialrotaY[i], &MaterialrotaXZ[i]);

		// ̉]pxNgZo
		if(draw_flag == 1){
			DebugMaterial->lightVec[i].x = FX_Mul(FX_SinIdx(MaterialrotaXZ[i]), FX_CosIdx(MaterialrotaY[i]));
			DebugMaterial->lightVec[i].z = FX_Mul(FX_CosIdx(MaterialrotaXZ[i]), FX_CosIdx(MaterialrotaY[i]));
			DebugMaterial->lightVec[i].y = FX_SinIdx(MaterialrotaY[i]);
		}
		/*if(sys.cont & PAD_BUTTON_Y){	// X
			draw_flag |= VecInput(&DebugMaterial->lightVec[i].x);
		}

		if(sys.cont & PAD_BUTTON_X){	// Y
			draw_flag |= VecInput(&DebugMaterial->lightVec[i].y);
		}

		if(sys.cont & PAD_BUTTON_A){	// Z
			draw_flag |= VecInput(&DebugMaterial->lightVec[i].z);
		}*/
		break;

	case DEB_MATE_DIFFUSE:	// fBt[Y
		if(sys.cont & PAD_BUTTON_Y){	// 
			data = DebugMaterial->diffuse;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->diffuse &= 0xffe0;		// 0NA
			DebugMaterial->diffuse |= data;
		}

		if(sys.cont & PAD_BUTTON_X){
			data = DebugMaterial->diffuse >> 5;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->diffuse &= 0xfc1f;		// 0NA
			DebugMaterial->diffuse |= data << 5;
		}

		if(sys.cont & PAD_BUTTON_A){
			data = DebugMaterial->diffuse >> 10;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->diffuse &= 0x03ff;		// 0NA
			DebugMaterial->diffuse |= data << 10;
		}
		break;

	case DEB_MATE_AMBIENT:	// ArGg
		if(sys.cont & PAD_BUTTON_Y){	// 
			data = DebugMaterial->ambient;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->ambient &= 0xffe0;		// 0NA
			DebugMaterial->ambient |= data;
		}

		if(sys.cont & PAD_BUTTON_X){
			data = DebugMaterial->ambient >> 5;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->ambient &= 0xfc1f;		// 0NA
			DebugMaterial->ambient |= data << 5;
		}

		if(sys.cont & PAD_BUTTON_A){
			data = DebugMaterial->ambient >> 10;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->ambient &= 0x03ff;		// 0NA
			DebugMaterial->ambient |= data << 10;
		}
		break;

	case DEB_MATE_SPECULAR:	// XyL[
		if(sys.cont & PAD_BUTTON_Y){	// 
			data = DebugMaterial->specular;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->specular &= 0xffe0;		// 0NA
			DebugMaterial->specular |= data;
		}

		if(sys.cont & PAD_BUTTON_X){
			data = DebugMaterial->specular >> 5;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->specular &= 0xfc1f;		// 0NA
			DebugMaterial->specular |= data << 5;
		}

		if(sys.cont & PAD_BUTTON_A){
			data = DebugMaterial->specular >> 10;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->specular &= 0x03ff;		// 0NA
			DebugMaterial->specular |= data << 10;
		}
		break;

	case DEB_MATE_EMISSION:	// ːF
		if(sys.cont & PAD_BUTTON_Y){	// 
			data = DebugMaterial->emission;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->emission &= 0xffe0;		// 0NA
			DebugMaterial->emission |= data;
		}

		if(sys.cont & PAD_BUTTON_X){
			data = DebugMaterial->emission >> 5;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->emission &= 0xfc1f;		// 0NA
			DebugMaterial->emission |= data << 5;
		}

		if(sys.cont & PAD_BUTTON_A){
			data = DebugMaterial->emission >> 10;
			data &= 0x001f;
			draw_flag |= ColorInput(&data);			// 
			DebugMaterial->emission &= 0x03ff;		// 0NA
			DebugMaterial->emission |= data << 10;
		}
		break;

	case DEB_WIN:	// fobNEBhEɓn
		KeyNoTouchFlag = 0;
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_ON );	// \It
		break;

	default:
		break;
	}
	
	// `
	if(draw_flag == 1){
		DrawMenu(MaterialCount);
	}
	
	// Cgݒ
	for(i=0;i<4;i++){
		if((DebugMaterial->lightFlag & (1<<i)) != 0){
			GLST_LightVector(D_TomoyaFldSys->light_cont_data->Glb, i, DebugMaterial->lightVec[i].x, DebugMaterial->lightVec[i].y, DebugMaterial->lightVec[i].z);
			GLST_LightColor(D_TomoyaFldSys->light_cont_data->Glb, i,DebugMaterial->lightColor[i]);
		}else{
			GLST_LightVector(D_TomoyaFldSys->light_cont_data->Glb, i, 0,0,0);
			GLST_LightColor(D_TomoyaFldSys->light_cont_data->Glb, i,0);
		}
	}
	// fBt[YAArGgAXyL[Aˌ
	GLST_MaterialDiff(D_TomoyaFldSys->light_cont_data->Glb, DebugMaterial->diffuse,FALSE,FALSE);
	GLST_MaterialAmb(D_TomoyaFldSys->light_cont_data->Glb, DebugMaterial->ambient,TRUE);
	GLST_MaterialSpec(D_TomoyaFldSys->light_cont_data->Glb, DebugMaterial->specular,FALSE,FALSE);
	GLST_MaterialEmi(D_TomoyaFldSys->light_cont_data->Glb, DebugMaterial->emission,TRUE);
	// CgtO
	GLST_MdlLightFlag(D_TomoyaFldSys->light_cont_data->Glb, DebugMaterial->lightFlag, TRUE, TRUE);
}

static void PrintString( GF_BGL_BMPWIN* win, u32 fontID, MSGDATA_MANAGER* man, u32 strid, u32 xofs, u32 yofs, u32 wait, pStrPrintCallBack call_back )
{
	STRBUF* str = MSGMAN_AllocString(man, strid);
	GF_STR_PrintSimple( win, fontID, str, xofs, yofs, wait, call_back );
	STRBUF_Delete(str);
}

// io[̃f[^`
static void DrawMenu( u32 num )
{
	MSGDATA_MANAGER* man;
	int i;			// [vp
	int work;		// Ɨp

	man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_tomoya_dat, HEAPID_BASE_DEBUG);

	// NA
	GF_BGL_BmpWinDataFill(D_M_win, 1 );

	// Menu`
	PrintString(D_M_win, FONT_SYSTEM, man, pD_M_str[num], D_M_MENU_X, D_M_MENU_Y, 0, NULL );

	// L,R`
	PrintString(D_M_win, FONT_SYSTEM, man, D_M_TMP_CH, D_M_MENU_X, D_M_SELECT, 0, NULL );

	i=0;
	// f[^`
	switch(num){
	case DEB_MATE_LIGHT_END:		// CgIt[
		DrawNum(DebugMaterial->lightEnd, D_M_NUM_X, D_M_0, D_M_win);
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_FRAME0, D_M_KEY_X, D_M_0, 0, NULL );			// key
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_FRAME1, D_M_KEY_X, D_M_1, 0, NULL );			// key
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_FRAME2, D_M_KEY_X, D_M_2, 0, NULL );			// key
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_FRAME3, D_M_KEY_X, D_M_3, 0, NULL );			// key
		break;

	case DEB_MATE_LIGHT_FLAG:		// on off
		// CgP
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_LIGHT1, D_M_MENU_X, D_M_0, 0, NULL );
		if(DebugMaterial->lightFlag & 1){		// on/off
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_on, D_M_NUM_X, D_M_0, 0, NULL );
		}else{
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_off, D_M_NUM_X, D_M_0, 0, NULL );	
		}
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_Y, D_M_KEY_X, D_M_0, 0, NULL );			// key
		// CgQ
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_LIGHT2, D_M_MENU_X, D_M_1, 0, NULL );
		if(DebugMaterial->lightFlag & 2){		// on/off
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_on, D_M_NUM_X, D_M_1, 0, NULL );
		}else{
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_off, D_M_NUM_X, D_M_1, 0, NULL );	
		}
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_X, D_M_KEY_X, D_M_1, 0, NULL );			// key
		// CgR
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_LIGHT3, D_M_MENU_X, D_M_2, 0, NULL );
		if(DebugMaterial->lightFlag & 4){		// on/off
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_on, D_M_NUM_X, D_M_2, 0, NULL );
		}else{
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_off, D_M_NUM_X, D_M_2, 0, NULL );	
		}
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_A, D_M_KEY_X, D_M_2, 0, NULL );			// key
		// CgS
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_LIGHT4, D_M_MENU_X, D_M_3, 0, NULL );
		if(DebugMaterial->lightFlag & 8){		// on/off
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_on, D_M_NUM_X, D_M_3, 0, NULL );
		}else{
			PrintString(D_M_win, FONT_SYSTEM, man, D_M_off, D_M_NUM_X, D_M_3, 0, NULL );	
		}
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_B, D_M_KEY_X, D_M_3, 0, NULL );			// key
		break;

	case DEB_MATE_LIGHT_COLOR_3:
		i++;
	case DEB_MATE_LIGHT_COLOR_2:
		i++;
	case DEB_MATE_LIGHT_COLOR_1:	
		i++;
	case DEB_MATE_LIGHT_COLOR_0:	// Cg̐F
		DrawRGB(DebugMaterial->lightColor[i]);	
		break;
		

	case DEB_MATE_LIGHT_VEC_3:
		i++;
	case DEB_MATE_LIGHT_VEC_2:
		i++;
	case DEB_MATE_LIGHT_VEC_1:	
		i++;
	case DEB_MATE_LIGHT_VEC_0:	// Cg̃xNg
		// XW
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_X, D_M_MENU_X, D_M_0, 0, NULL );
		work = FX_FX16_TO_F32(DebugMaterial->lightVec[i].x)*10;
		DrawNum(DebugMaterial->lightVec[i].x, D_M_NUM_X, D_M_0, D_M_win);
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_Xb, D_M_KEY_X, D_M_0, 0, NULL );			// key
		// YW
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_Y, D_M_MENU_X, D_M_1, 0, NULL );
		work = FX_FX16_TO_F32(DebugMaterial->lightVec[i].y)*10;
		DrawNum(DebugMaterial->lightVec[i].y, D_M_NUM_X, D_M_1, D_M_win);
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_Bb, D_M_KEY_X, D_M_1, 0, NULL );			// key
		// ZW
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_Z, D_M_MENU_X, D_M_2, 0, NULL );
		work = FX_FX16_TO_F32(DebugMaterial->lightVec[i].z)*10;
		DrawNum(DebugMaterial->lightVec[i].z, D_M_NUM_X, D_M_2, D_M_win);
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_Yb, D_M_KEY_X, D_M_2, 0, NULL );			// key
		PrintString(D_M_win, FONT_SYSTEM, man, D_M_Ab, D_M_KEY_X, D_M_3, 0, NULL );			// key
		break;

	case DEB_MATE_DIFFUSE:		// fBt[YF
		DrawRGB(DebugMaterial->diffuse);	
		break;
	
	case DEB_MATE_AMBIENT:		// ArGgF
		DrawRGB(DebugMaterial->ambient);	
		break;

	case DEB_MATE_SPECULAR:		// XyL[F
		DrawRGB(DebugMaterial->specular);
		break;

	case DEB_MATE_EMISSION:		// ːF
		DrawRGB(DebugMaterial->emission);
		break;

	default:
		break;
	}

	GF_BGL_BmpWinOn(D_M_win );
	MSGMAN_Delete(man);
}

static void DrawNum( s32 num, u32 x, u32 y, GF_BGL_BMPWIN* win )
{
	STRBUF* str = STRBUF_Create(12, HEAPID_BASE_DEBUG);
	STRBUF_SetNumber( str, num, 10, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
	GF_STR_PrintSimple(win, FONT_SYSTEM, str, x, y, 0, NULL );
	STRBUF_Delete(str);
}

static u8 NumInput(u32* num, u32 add, u32 limit)
{
	u8 draw_flag = 0;
	
	if(MT_InputCount == 0){
		if(sys.cont & PAD_KEY_UP){
			*num = (*num + add) % limit;
			draw_flag = 1;
		}
		if(sys.cont & PAD_KEY_DOWN){
			(*num)-=add;
			if(*num < 0){
				*num += limit;
			}
			draw_flag = 1;
		}
	}

	if(draw_flag == 1){
		if((MT_InputNow - MT_INPUT_SUB) > MT_INPUT_MIN){
			MT_InputNow-= MT_INPUT_SUB;
		}
		MT_InputCount = MT_InputNow;
	}

	return draw_flag;
}

static u8 ColorInput( s16* num )				// F̓
{
	u8 draw_flag = 0;
	
	if(MT_InputCount == 0){
		if(sys.cont & PAD_KEY_UP){
			*num = (*num + 1) % 32;
			draw_flag = 1;
		}
		if(sys.cont & PAD_KEY_DOWN){
			(*num)--;
			if(*num < 0){
				*num += 32;
			}
			draw_flag = 1;
		}
	}

	if(draw_flag == 1){
		if((MT_InputNow - MT_INPUT_SUB) > MT_INPUT_MIN){
			MT_InputNow-= MT_INPUT_SUB;
		}
		MT_InputCount = MT_InputNow;
	}

	return draw_flag;
}

static u8 VecInput( u16* rotaY, u16* rotaXZ )				// xNg
{
	u8 draw_flag = 0;
	
	if(MT_InputCount == 0){
		if(sys.cont & PAD_BUTTON_X){		// X]Abv
			*rotaY += MT_ROT_GET(2);
			draw_flag = 1;
		}
		if(sys.cont & PAD_BUTTON_B){	// X]_E
			*rotaY -= MT_ROT_GET(2);
			draw_flag = 1;
		}
		if(sys.cont & PAD_BUTTON_A){	// Y]
			*rotaXZ += MT_ROT_GET(2);
			draw_flag = 1;
		}
		if(sys.cont & PAD_BUTTON_Y){	// Y]E
			*rotaXZ -= MT_ROT_GET(2);
			draw_flag = 1;
		}
	}

	if(draw_flag == 1){
		if((MT_InputNow - MT_INPUT_SUB) > MT_INPUT_MIN){
			MT_InputNow-= MT_INPUT_SUB;
		}
		MT_InputCount = MT_InputNow;
	}

	return draw_flag;
}

static void DrawRGB( GXRgb num )
{
	MSGDATA_MANAGER* man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_tomoya_dat, HEAPID_BASE_DEBUG);
	int work;

	// 
	PrintString(D_M_win, FONT_SYSTEM, man, D_M_CR, D_M_MENU_X, D_M_0, 0, NULL );
	work = num;
	work &= 0x001f;
	DrawNum(work, D_M_NUM_X, D_M_0, D_M_win);
	PrintString(D_M_win, FONT_SYSTEM, man, D_M_Ya, D_M_KEY_X, D_M_0, 0, NULL );			// key
	// 
	PrintString(D_M_win, FONT_SYSTEM, man, D_M_CG, D_M_MENU_X, D_M_1, 0, NULL );
	work = num >> 5;
	work &= 0x001f;
	DrawNum(work, D_M_NUM_X, D_M_1, D_M_win);
	PrintString(D_M_win, FONT_SYSTEM, man, D_M_Xa, D_M_KEY_X, D_M_1, 0, NULL );			// key
	// 
	PrintString(D_M_win, FONT_SYSTEM, man, D_M_CB, D_M_MENU_X, D_M_2, 0, NULL );
	work = num >> 10;
	work &= 0x001f;
	DrawNum(work, D_M_NUM_X, D_M_2, D_M_win);		
	PrintString(D_M_win, FONT_SYSTEM, man, D_M_Aa, D_M_KEY_X, D_M_2, 0, NULL );			// key

	MSGMAN_Delete(man);
}


static void SetVecRota( u16* rotaY, u16* rotaXZ, fx32 X, fx32 Y, fx32 Z )
{
	fx32 xz_dis;		// ʂ̃xNg
	
	// ]p擾
	xz_dis = FX_Mul(X, X);
	xz_dis += FX_Mul(Z,Z);
	xz_dis = FX_Sqrt(xz_dis);
	
	*rotaY = FX_Atan2Idx(Y, xz_dis);
	*rotaXZ = FX_Atan2Idx(X, Z);
}


static void SetVecsRotas( u16* rotaY, u16* rotaXZ, LIGHT_CONT_DATA* light )
{
	int i;		// [vp

	for( i=0; i<4; i++ ){
		SetVecRota( rotaY + i, rotaXZ + i,
				light->lightVec[ i ].x,
				light->lightVec[ i ].y,
				light->lightVec[ i ].z );
	}
}





//-----------------------------------------------------------------------------
//
//			Fog֌W
//
//=============================================================================
static void StartFog( TCB_PTR tcb,void* work )
{
    int i;
	
	if(FogFlag == 0){
		// ͂^C~O
		FOG_InputNow = MT_INPUT_MAX;
		FOG_InputCount = 0;


#ifdef FOG_BG_ON
		/*--------------------------------------------------------
		 *	BG2ɉ`悷鏀
		 =======================================================*/
		// At@ufBOݒ
		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG0,
						GX_BLEND_PLANEMASK_BG2,
						0, 0);

		
		GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_MBGFRM_EFFECT2 );
		{	// Cʂ̂afQݒ
			GF_BGL_BGCNT_HEADER BgData = {
				0,								// \wݒ
				0,								// \xݒ
				0x800,							// XN[obt@TCY
				0,								// XN[obt@ItZbg
				GF_BGL_SCRSIZ_256x256,			// XN[TCY 256x256
				GX_BG_COLORMODE_256,			// J[[h 256F
				GX_BG_SCRBASE_0xf000,
				GX_BG_CHARBASE_0x08000,
				GX_BG_EXTPLTT_23,				// gpbgXbg
				2,								// \vCIeB
				0,								// GAI[o[tO
				0,								// _~[
				FALSE							// UCNݒ
			};

			GF_BGL_BGControlSet(D_TomoyaFldSys->bgl,  FLD_MBGFRM_EFFECT2, &BgData, GF_BGL_MODE_TEXT );
		}
		
	    GX_LoadBGPltt(d_64_256_bg_sclDT, 0, sizeof(d_64_256_bg_sclDT));
	
		{
			int i, j;
			for (i = 0; i < 32; i++)
			{
				for (j = 0; j < 32; j++)
				{
					sScrnBuf[(i * 32) + j] = (u16) (((i%7) * 0x10) + j);
				}
			}
		}
		GF_BGL_LoadScreen(D_TomoyaFldSys->bgl, FLD_MBGFRM_EFFECT2, sScrnBuf, sizeof(sScrnBuf), 0 );
		GF_BGL_ScreenBufSet(D_TomoyaFldSys->bgl, FLD_MBGFRM_EFFECT2, sScrnBuf, sizeof(sScrnBuf) );

		// LN^[f[^ǂݍ
		GF_BGL_LoadCharacter(D_TomoyaFldSys->bgl,  FLD_MBGFRM_EFFECT2, d_64_256_bg_schDT, sizeof(d_64_256_bg_schDT), 0 );

		if(bg2_flag == 0){
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );	
		}
#endif
			
	
		// `ʂ쐬
		GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1 );
		{	// SUB DISP BG1
			GF_BGL_BGCNT_HEADER SBg1_Data = {
				0, 0, 0x800, 0,
				GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0x4000, GX_BG_CHARBASE_0x00000,
				GX_BG_EXTPLTT_01, 0, 0, 0, FALSE
			};
			GF_BGL_BGControlSet( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1, &SBg1_Data, GF_BGL_MODE_TEXT );
		}//*/
		FOG_win = initBmpWin(1);
		GF_BGL_BmpWinAdd(D_TomoyaFldSys->bgl, FOG_win, FLD_SBGFRM_EFFECT1, 0, 0, 24, 21, 0, 0 );

		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
	
		
		// C^XNZbg
		FogTCBData =  TCB_Add(MainFog,NULL,8);
		FogFlag = 1;

#ifdef FOG_BG_ON
		// BG𓮂^XNZbg
		if(FOG_BG_TASK == NULL){
			FOG_BG_TASK = TCB_Add(BG2Move,NULL,8);
		}
#endif

		DrawFog(FOG_Count);
		//EBhE
		FreeDebugWindow(tcb,work);
		//^XN
		TCB_Delete(tcb);
	
		// CXgZbg
		mainlistStart();

	}
}

static void EndFog( TCB_PTR tcb,void* work )
{
	int i;
	
	if(FogFlag == 1){
		FogFlag = 0;
		TCB_Delete(FogTCBData);		// ^XNj
		FogTCBData = NULL;

		SetFogData(D_TomoyaFldSys->fog_data, FOG_SYS_FLAG, TRUE, 0,0,0);		// on/offtOݒ

#ifdef FOG_BG_ON
		TCB_Delete(FOG_BG_TASK);
		FOG_BG_TASK = NULL;

		G2_BlendNone();
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_MBGFRM_EFFECT2 );
		{	// MAIN DISPiGtFNgQj
			GF_BGL_BGCNT_HEADER TextBgCntDat = {
				0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
				GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_23,
				3, 0, 0, FALSE
			};
			GF_BGL_BGControlSet(D_TomoyaFldSys->bgl,  FLD_MBGFRM_EFFECT2, &TextBgCntDat, GF_BGL_MODE_TEXT );
			GF_BGL_ScrClear(D_TomoyaFldSys->bgl, FLD_MBGFRM_EFFECT2 );
		}
#endif

		// `
		delBmpWin(FOG_win);
		GF_BGL_BGControlExit( D_TomoyaFldSys->bgl, FLD_SBGFRM_EFFECT1 );
		
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
		//GF_BGL_BGControlExit( FLD_SBGFRM_EFFECT1 );
	
		//EBhE
		FreeDebugWindow(tcb,work);
		//^XN
		TCB_Delete(tcb);
	
		// CXgZbg
		mainlistStart();
	}
}

// BG2ʂ𓮂
static void BG2Move(TCB_PTR tcb,void* work)
{
#ifdef FOG_BG_ON
	// BGʂSCROLL
	if(bg2_flag == 1){
		
		Fog_BG_Count = (Fog_BG_Count + FOG_BG_SCROLL_COUNT) % (256*FOG_BG_SCROLL_PAR);		// BGʃXN[JE^
		G2_SetBG2Offset((Fog_BG_Count / FOG_BG_SCROLL_PAR),0);
	}
#endif
}

static void MainFog( TCB_PTR tcb,void* work )
{
	int i;
	
	KeyNoTouchFlag = 1;// L[bN

	if(sys.trg & PAD_BUTTON_SELECT){
#ifdef FOG_BG_ON
		bg2_flag = (bg2_flag + 1)%2;

		if(bg2_flag){
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
		}else{
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		}
#endif
	}

	// ͏
	if(sys.trg & PAD_KEY_LEFT){
		FOG_Count--;
		Fog_DrawFlag = 1;
		if(FOG_Count < 0){
			FOG_Count += FOG_TITLE_NUM;
		}
	}
	if(sys.trg & PAD_KEY_RIGHT){
		FOG_Count = (FOG_Count + 1) % FOG_TITLE_NUM;
		Fog_DrawFlag = 1;
	}

	// ̓JEg
	if(FOG_InputCount > 0){
		FOG_InputCount--;
	}
	// UPDOWN̓͂ȂMT_InputNow̒lőɂ
	if(!((sys.cont & PAD_KEY_UP) ||
	   (sys.cont & PAD_KEY_DOWN))){
		FOG_InputNow = MT_INPUT_MAX;
		FOG_InputCount = 0;
	}
	
	InputFog(FOG_Count);


	// `
	if(Fog_DrawFlag == 1){
		DrawFog(FOG_Count);
		Fog_DrawFlag = 0;
	}
	
}

static void FogColorGet( FIELDSYS_WORK* D_TomoyaFldSys,int* r, int* g, int* b )
{
	*r = (GetFogColor(D_TomoyaFldSys->fog_data) >> 0) & 0x1f;
	*g = (GetFogColor(D_TomoyaFldSys->fog_data) >> 5) & 0x1f;
	*b = (GetFogColor(D_TomoyaFldSys->fog_data) >> 10) & 0x1f;
}

// 
static void InputFog( int num )
{
	int	fog_flag = GetFogFlag(D_TomoyaFldSys->fog_data);
	int	fog_mode = GetFogMode(D_TomoyaFldSys->fog_data);
	int	fog_slope = GetFogSlope(D_TomoyaFldSys->fog_data);
	int fog_offset = GetFogOffset(D_TomoyaFldSys->fog_data);
	int r;
	int g;
	int b;
	int alpha = GetFogAlpha(D_TomoyaFldSys->fog_data);
	char fog_tbl[32];
	const char* p_get = GetFogTbl(D_TomoyaFldSys->fog_data);
	int i;


	FogColorGet(D_TomoyaFldSys, &r, &g, &b);
	
	for(i=0;i<32;i++){
		fog_tbl[i] = p_get[i];
	}	

	switch(num){
	case FOG_NORMAL_SET:
		
		
		if(sys.trg & PAD_BUTTON_Y){		// on/off
			fog_flag = (fog_flag + 1) % 2;
			Fog_DrawFlag = 1;
		}
		if(sys.trg & PAD_BUTTON_X){		// fog mode
			fog_mode = (fog_mode + 1) % 2;
			Fog_DrawFlag = 1;
		}
		if(sys.cont & PAD_BUTTON_A){	// W
			if(sys.trg & PAD_KEY_UP){
				fog_slope = (fog_slope + 1) % 11;
				Fog_DrawFlag = 1;
			}
			if(sys.trg & PAD_KEY_DOWN){
				fog_slope--;
				Fog_DrawFlag = 1;
				if(fog_slope < 0){
					fog_slope += 11;
				}
			}
		}

		if(FOG_InputCount == 0){
			if(sys.cont & PAD_BUTTON_B){	// ǂ̈ʒu炩邩
				if(sys.cont & PAD_KEY_UP){
					fog_offset += FOG_OFS_ADD;
					Fog_DrawFlag = 1;
				}
				if(sys.cont & PAD_KEY_DOWN){
					fog_offset -= FOG_OFS_ADD;
					Fog_DrawFlag = 1;
				}
			}
		}

		SetFogData(D_TomoyaFldSys->fog_data, FOG_SYS_ALL, fog_flag, fog_mode, fog_slope, fog_offset);
		break;

	case FOG_COLOR_SET:
		if(FOG_InputCount == 0){
			if(sys.cont & PAD_BUTTON_Y){
				if(sys.cont & PAD_KEY_UP){
					r = (r + 1) % 32;
					Fog_DrawFlag = 1;
				}
				if(sys.cont & PAD_KEY_DOWN){
					r--;
					Fog_DrawFlag = 1;
					if(r < 0){
						r += 32;
					}
				}
			}
			if(sys.cont & PAD_BUTTON_X){
				if(sys.cont & PAD_KEY_UP){
					g = (g + 1) % 32;
					Fog_DrawFlag = 1;
				}
				if(sys.cont & PAD_KEY_DOWN){
					g--;
					Fog_DrawFlag = 1;
					if(g < 0){
						g += 32;
					}
				}
			}
			if(sys.cont & PAD_BUTTON_A){
				if(sys.cont & PAD_KEY_UP){
					b = (b + 1) % 32;
					Fog_DrawFlag = 1;
				}
				if(sys.cont & PAD_KEY_DOWN){
					b--;
					Fog_DrawFlag = 1;
					if(b < 0){
						b += 32;
					}
				}
			}
			if(sys.cont & PAD_BUTTON_B){
				if(sys.cont & PAD_KEY_UP){
					alpha = (alpha + 1) % 32;
					Fog_DrawFlag = 1;
				}
				if(sys.cont & PAD_KEY_DOWN){
					alpha--;
					Fog_DrawFlag = 1;
					if(alpha < 0){
						alpha += 32;
					}
				}
			}
		}
		SetFogColor(D_TomoyaFldSys->fog_data, FOG_SYS_ALL, GX_RGB(r,g,b), alpha);
		break;
	
	case FOG_TBL_SET:
		
		
		if(sys.trg & PAD_BUTTON_X){
			FOG_TBL_Count = (FOG_TBL_Count + 1) % 32;
			Fog_DrawFlag = 1;
		}
		if(sys.trg & PAD_BUTTON_B){
			FOG_TBL_Count--;
			Fog_DrawFlag = 1;
			if(FOG_TBL_Count < 0){
				FOG_TBL_Count += 32;
			}
		}

		if(FOG_InputCount == 0){
			if(sys.cont & PAD_KEY_UP){
				fog_tbl[FOG_TBL_Count] = (fog_tbl[FOG_TBL_Count] + 1) % 128;
				Fog_DrawFlag = 1;
			}
			if(sys.cont & PAD_KEY_DOWN){
				fog_tbl[FOG_TBL_Count]--;
				Fog_DrawFlag = 1;
				if(fog_tbl[FOG_TBL_Count] < 0){
					fog_tbl[FOG_TBL_Count] += 128;
				}
			}
		}
		SetFogTbl(D_TomoyaFldSys->fog_data, fog_tbl);
		break;

	default:
		KeyNoTouchFlag = 0;
		break;
	}

	if(Fog_DrawFlag == 1){
		if((FOG_InputNow - MT_INPUT_SUB) > MT_INPUT_MIN){
			FOG_InputNow-= MT_INPUT_SUB;
		}
		FOG_InputCount = FOG_InputNow;
	}
}

// `
static void DrawFog( int num )
{
	int	fog_flag = GetFogFlag(D_TomoyaFldSys->fog_data);
	int	fog_mode = GetFogMode(D_TomoyaFldSys->fog_data);
	int	fog_slope = GetFogSlope(D_TomoyaFldSys->fog_data);
	int fog_offset = GetFogOffset(D_TomoyaFldSys->fog_data);
	int r;
	int g;
	int b;
	int alpha = GetFogAlpha(D_TomoyaFldSys->fog_data);
	char fog_tbl[32];
	const char* p_get = GetFogTbl(D_TomoyaFldSys->fog_data);
	int i,j;		// [vp
	int work;		// Ɨp
	MSGDATA_MANAGER* man = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_tomoya_dat, HEAPID_BASE_DEBUG);

	FogColorGet(D_TomoyaFldSys, &r, &g, &b);
	
	for(i=0;i<32;i++){
		fog_tbl[i] = p_get[i];
	}
	
	GF_ASSERT( FOG_win );
	
	// NA
	GF_BGL_BmpWinDataFill(FOG_win, 1 );

	// Menu`
	PrintString(FOG_win, FONT_SYSTEM, man, fog_title[num], D_M_MENU_X, D_M_MENU_Y, 0, NULL );

	// BGʕ\
	if(num != FOG_TBL_SET){
		PrintString(FOG_win, FONT_SYSTEM, man, fog_tbl_bg, D_M_MENU_X, D_M_SELECT, 0, NULL );
	}
	

	// `
	switch(num){
	case FOG_NORMAL_SET:
		// on/off
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_ON_OFF, D_M_MENU_X, D_M_0, 0, NULL );
		if(fog_flag){
			PrintString(FOG_win, FONT_SYSTEM, man, D_M_on, D_M_NUM_X, D_M_0, 0, NULL );
		}else{
			PrintString(FOG_win, FONT_SYSTEM, man, D_M_off, D_M_NUM_X, D_M_0, 0, NULL );
		}
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_Y, D_M_KEY_X, D_M_0, 0, NULL );
		
		// mode
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_MODE, D_M_MENU_X, D_M_1, 0, NULL );
		DrawNum(fog_mode, D_M_NUM_X, D_M_1, FOG_win);	
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_X, D_M_KEY_X, D_M_1, 0, NULL );
		
		// 肮
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_KAKARI, D_M_MENU_X, D_M_2, 0, NULL );
		DrawNum(fog_slope, D_M_NUM_X, D_M_2, FOG_win);
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_Aa, D_M_KEY_X, D_M_2, 0, NULL );

		// ItZbg
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_OFS, D_M_MENU_X, D_M_3, 0, NULL );
		DrawNum(fog_offset, D_M_NUM_X, D_M_3, FOG_win);
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_Ba, D_M_KEY_X, D_M_3, 0, NULL );
		break;

	case FOG_COLOR_SET:
		// 
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_CR, D_M_MENU_X, D_M_0, 0, NULL );
		DrawNum(r, D_M_NUM_X, D_M_0, FOG_win);	
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_Ya, D_M_KEY_X, D_M_0, 0, NULL );
		// 
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_CG, D_M_MENU_X, D_M_1, 0, NULL );
		DrawNum(g, D_M_NUM_X, D_M_1, FOG_win);	
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_Xa, D_M_KEY_X, D_M_1, 0, NULL );
		// 
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_CB, D_M_MENU_X, D_M_2, 0, NULL );
		DrawNum(b, D_M_NUM_X, D_M_2, FOG_win);	
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_Aa, D_M_KEY_X, D_M_2, 0, NULL );
		// At@
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_CA, D_M_MENU_X, D_M_3, 0, NULL );
		DrawNum(alpha, D_M_NUM_X, D_M_3, FOG_win);	
		PrintString(FOG_win, FONT_SYSTEM, man, D_M_Ba, D_M_KEY_X, D_M_3, 0, NULL );
		break;

	case FOG_TBL_SET:
		PrintString(FOG_win, FONT_SYSTEM, man, fog_tbl_tugi, D_M_MENU_X, D_M_0, 0, NULL );
		PrintString(FOG_win, FONT_SYSTEM, man, fog_tbl_mae, D_M_NUM_X + 16, D_M_0, 0, NULL );
		PrintString(FOG_win, FONT_SYSTEM, man, fog_tbl_data, D_M_NUM_X + 8, D_M_MENU_Y, 0, NULL );
		DrawNum(fog_tbl[FOG_TBL_Count], D_M_KEY_X - 24, D_M_MENU_Y, FOG_win);

		// e[u̒g\
		for(i=0;i<7;i++){
			for(j=0;j<5;j++){
				if(((i*5)+j) >= 32){
					break;
				}
				DrawNum(fog_tbl[(i*5)+j], D_M_MENU_X+(j*30), D_M_1 + (i*18), FOG_win );
			}
		}
		break;

	default:
		break;
	}

	MSGMAN_Delete(man);
}



//-----------------------------------------------------------------------------
//
//		VCVXe
//	
//=============================================================================
// J
static void StartWeather00( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_RAIN );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);

	// CXgZbg
	mainlistStart();
}

// 
static void StartWeather01( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SNOW );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// 
static void StartWeather02( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SNOW_STORM );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	// CXgZbg
	mainlistStart();
}

// 
static void StartWeather03( TCB_PTR tcb,void* work )
{
	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_RAINBOW );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// P
static void StartWeather04( TCB_PTR tcb,void* work )
{
	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_FOGS );
	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// Q
static void StartWeather05( TCB_PTR tcb,void* work )
{
	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_FOGM );
	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// R
static void StartWeather06( TCB_PTR tcb,void* work )
{
	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_FOGL );
	
	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// 
static void StartWeather07( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_STORM );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// BG
static void StartWeather08( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_STORM_BG );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// kC
static void StartWeather09( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SNOW_SML );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// Xm[_Xg
static void StartWeather10( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SNOW_D );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// J
static void StartWeather11( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_STRAIN );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// ΎRD
static void StartWeather12( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_VOLCANO );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// 
static void StartWeather13( TCB_PTR tcb,void* work )
{
	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SPARK );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// C
static void StartWeather14( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SPIRIT );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// _
static void StartWeather15( TCB_PTR tcb,void* work )
{

	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_MYSTIC );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// S~
static void StopWeather( TCB_PTR tcb,void* work )
{
	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SUNNY );

	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();
}

// j
static void EndWeather( TCB_PTR tcb,void* work )
{
	WEATHER_ChengeReq( D_TomoyaFldSys->fldmap->weather_data, WEATHER_SYS_SUNNY );
	
	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	
	// CXgZbg
	mainlistStart();	
}
