//===========================================================================
/**
 * @file	debug_init.c
 * @brief	fobOpݒ
 * @author	tamada GAME FREAK Inc.
 * @date	2005.10.13
 */
//===========================================================================
#include "common.h"

#include "fieldsys.h"
#include "system/savedata.h"
#include "field/field.h"
#include "ev_mapchange.h"

#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "system/mystatus.h"
#include "system/zukanwork.h"
#include "field/situation.h"
#include "situation_local.h"

#include "itemtool/myitem.h"

#include "mapdefine.h"

#include "msgdata/msg_debugname.h"
#include "msgdata/msg.naix"
#include "system/msgdata.h"

#include "poketool/monsno.h"

#include "ev_pokemon.h"

#include "itemtool/itemsym.h"
#include "field/ug_itemtype.h"
#include "savedata/undergrounddata.h"

#include "field/union_beacon_tool.h"

#include "field/eventflag.h"
#include "field/evwkdef.h"
#include "field/sysflag.h"
#include "field/syswork.h"

#include "battle/wazano_def.h"

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//	Q[Jnʒu̒`
//------------------------------------------------------------------
enum {
	//GAME_START_ZONE = ZONE_ID_T01R0102,
	GAME_START_ZONE = ZONE_ID_T01R0202,		//06.03.07ύX
	GAME_START_X = 6,
	GAME_START_Z = 7,
};




//===========================================================================
//===========================================================================
static void Debug_MakeStartData(SAVEDATA * sv);
static int MakeMyStatus(MYSTATUS * my);
static void AddItemList(MYITEM * myitem, int heapID);


//===========================================================================
//
//		Q[JñZ[uf[^
//
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	Q[f[^FVKQ[ifobOj
 * @param	savedata	Z[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
void GameData_SetDebugNewGame(SAVEDATA * savedata)
{
	//Ƃ肠fobOf[^ĂяoĂ
	Debug_MakeStartData(savedata);
}

//------------------------------------------------------------------
/**
 * @brief	Q[f[^FReBj[
 * @param	savedata	Z[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
void GameData_SetContinueData(SAVEDATA * savedata)
{
	if (!SaveData_Load(savedata)) {
		OS_Printf("Z[uf[^܂\n");
		OS_ResetSystem(0);
	}
}

//------------------------------------------------------------------
/**
 * @brief	Q[f[^FVKQ[
 * @param	savedata	Z[uf[^ւ̃|C^
 */
//------------------------------------------------------------------
void GameData_SetNewGame(SAVEDATA * savedata)
{
	POKEPARTY * temoti;
	MYITEM * bag;
	MYSTATUS * my;
	ZUKAN_WORK * zw;
	SITUATION * sit;
	int i;

	SaveData_ClearData(savedata);

	//莝|PZbg
	temoti = SaveData_GetTemotiPokemon(savedata);
#if 0
	EvPoke_Add(HEAPID_BASE_DEBUG, temoti, MONSNO_RIZUMHI, 10, 0);
	EvPoke_Add(HEAPID_BASE_DEBUG, temoti, MONSNO_TAMANTA, 10, 0);
#endif

	//莝ACeZbg
	bag = SaveData_GetMyItem(savedata);
	AddItemList(bag, HEAPID_BASE_DEBUG);

	//KɎԃf[^
	my = SaveData_GetMyStatus(savedata);
	//MakeMyStatus(my);
	MyStatus_SetID(my, gf_mtRand() & 0xffff);
	MyStatus_SetGold(my, 3000);
	// jI[ł̌ڂID琶
	MyStatus_SetTrainerView(my, UnionView_GetTrainerType( MyStatus_GetID(my), 0, 0 ));	

	//莝̕tOZbg
	zw = SaveData_GetZukanWork(savedata);
	for (i = 0; i < PokeParty_GetPokeCount(temoti); i++) {
		ZukanWork_SetPokeGet(zw, PokeParty_GetMemberPointer(temoti, i));
	}
	//fobOpX^[gʒuݒ
	sit = SaveData_GetSituation(savedata);
	Debug_SetStartLocation(Situation_GetNowLocation(sit));
	//TMFootMark_Init_Debug(Situation_GetTMFootMark(sit));

}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------



//===========================================================================
//===========================================================================

//------------------------------------------------------------------
/**
 * @brief	fobOpFZ[uf[^ݒ
 */
//------------------------------------------------------------------
void Debug_MakeStartData(SAVEDATA * savedata)
{
	int usr_id;
	POKEPARTY * temoti;
	MYITEM * bag;
	MYSTATUS * my;
	ZUKAN_WORK * zw;
	SITUATION * sit;
	int i;

	SaveData_ClearData(savedata);

	//KɎԃf[^
	my = SaveData_GetMyStatus(savedata);
	usr_id = MakeMyStatus(my);

	//莝|PKɐ
	temoti = SaveData_GetTemotiPokemon(savedata);
	if (usr_id == DEBUG_NAME_TAMADA) {
		Debug_PokeParty_MakeParty(temoti);
		EvPoke_ChangeWaza(temoti, 0, 0, WAZANO_IAIGIRI);
		EvPoke_ChangeWaza(temoti, 0, 1, WAZANO_IWAKUDAKI);
		EvPoke_ChangeWaza(temoti, 0, 2, WAZANO_NAMINORI);
		EvPoke_ChangeWaza(temoti, 0, 3, WAZANO_ROKKUKURAIMU);
		EvPoke_ChangeWaza(temoti, 1, 0, WAZANO_KAIRIKI);
		EvPoke_ChangeWaza(temoti, 1, 1, WAZANO_SORAWOTOBU);
		EvPoke_ChangeWaza(temoti, 1, 2, WAZANO_KIRIBARAI);
		EvPoke_ChangeWaza(temoti, 1, 3, WAZANO_TAKINOBORI);
	}else if (
		usr_id == DEBUG_NAME_NOHARA ||
		usr_id == DEBUG_NAME_TADASHI) {
		EvPoke_Add(HEAPID_BASE_DEBUG, temoti, MONSNO_KORATTA, 2, ITEM_KURABONOMI);
	}else{
		Debug_PokeParty_MakeParty(temoti);
	}

	//莝ACeKɐ
	bag = SaveData_GetMyItem(savedata);
	Debug_MyItem_MakeBag(bag, HEAPID_BASE_DEBUG);

	//莝̕tOZbg
	zw = SaveData_GetZukanWork(savedata);
	//Debug_ZukanWork_Make(zw, 0);
	for (i = 0; i < PokeParty_GetPokeCount(temoti); i++) {
		ZukanWork_SetPokeGet(zw, PokeParty_GetMemberPointer(temoti, i));
	}

	//fobOpX^[gʒuݒ
	sit = SaveData_GetSituation(savedata);
	Debug_SetStartLocation(Situation_GetNowLocation(sit));
	//TMFootMark_Init_Debug(Situation_GetTMFootMark(sit));

#if 1  // fobO閧nzuf[^
    {
        UNDERGROUNDDATA* pU = SaveData_GetUnderGroundData(savedata);
        SECRETBASEDATA* pS = SaveData_GetSecretBaseData(savedata);

        UnderGroundAddGoodsPCItem(pU, 12);  // Xgɒǉ
        UnderGroundAddGoodsPCItem(pU, 35);
        UnderGroundAddGoodsPCItem(pU, 33);
        UnderGroundAddGoodsPCItem(pU, 15);
        UnderGroundAddGoodsPCItem(pU, 66);
        UnderGroundEntryGoodsPCItem(pU, 0, 1); // o^
        UnderGroundEntryGoodsPCItem(pU, 1, 3);
        Debug_SecretBaseData_AddGoods(pS,GOODS_BIG_ROCK,19,12);
        Debug_SecretBaseData_AddGoods(pS,12,12,15);  // fobOo^
        Debug_SecretBaseData_AddGoods(pS,33,12,17);
        
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_DRILL);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_HOLE);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_HOLE);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BIG_HOLE);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BIG_HOLE);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_REVERSE);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_GIDDY);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BIGDIR_UP);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BIGDIR_DOWN);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BIGDIR_LEFT);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BIGDIR_RIGHT);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BIG_SMOG);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BUBBLE);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_BUBBLE);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_DIRTY_BLOSSOMS);
        UnderGroundAddTrapBagItem(pU, UG_TRAPTYPE_DIRTY_BLOSSOMS);

        UnderGroundAddStoneBagItem(pU, STONE_TYPE_DIAMOND, 77);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_PEARL, 20);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_DIAMOND, 1);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_PEARL, 1);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_RED, 88);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_RED, 1);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_BLUE, 33);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_BLUE, 3);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_GREEN, 88);
        UnderGroundAddStoneBagItem(pU, STONE_TYPE_GREEN, 8);

        UnderGroundAddTreasureBagItem(pU, DIG_PARTS_KAMINARI);
        UnderGroundAddTreasureBagItem(pU, DIG_PARTS_KAMINARI);
        UnderGroundAddTreasureBagItem(pU, DIG_PARTS_KOHAKU);

        UnderGroundAddGoodsBagItem(pU, 12);
        UnderGroundAddGoodsBagItem(pU, 13);
        UnderGroundAddGoodsBagItem(pU, 14);
        UnderGroundAddGoodsBagItem(pU, 15);
        UnderGroundAddGoodsBagItem(pU, 16);

        // mF
#if 0
        OS_TPrintf("num %d\n",UnderGroundGetNumGoodsPCItem(pU));

        for(i = 0; i < 10;i++){
            OS_TPrintf("Goods %d  %d\n", UnderGroundGetGoodsPCItem(pU, i),
                       UnderGroundIsEntryGoodsPCItem(pU, i));
        }
#endif
    }
#endif
#if 1  // fobOp܃f[^
    {
        UNDERGROUNDDATA* pU = SaveData_GetUnderGroundData(savedata);
        Debug_UnderGroundData_AddTreasure(pU,DIG_PARTS_KAMINARI);
        Debug_UnderGroundData_AddTreasure(pU,DIG_PARTS_KOURA);
        Debug_UnderGroundData_AddTreasure(pU,DIG_PARTS_GOLD);
#if 0  // ǂ̎
        OS_TPrintf("ACe擾 %d\n",UnderGroundGetTreasureBagItem(pU,TRUE));
        OS_TPrintf("ACe擾 %d\n",UnderGroundGetTreasureBagItem(pU,TRUE));
        OS_TPrintf("ACe擾 %d\n",UnderGroundGetTreasureBagItem(pU,TRUE));
        OS_TPrintf("ACe擾 %d\n",UnderGroundGetTreasureBagItem(pU,TRUE));
#endif
    }
#endif

#if 1
	//VXetOZbg
	{
		u16* wk;

		//j[u}Ӂv
		ZUKAN_WORK* zw = SaveData_GetZukanWork( savedata );
		ZukanWork_SetZukanGetFlag( zw );

		//j[uobOv
		//SysFlag_BagSet( core->fsys );
		EventWork_SetEventFlag( SaveData_GetEventWork(savedata), SYS_FLAG_BAG_GET );

		//j[u|Pv
		wk = EventWork_GetEventWorkAdrs( SaveData_GetEventWork(savedata), SYS_WORK_FIRST_POKE_NO );
		*wk = MONSNO_HUSIGIDANE;	//ӁI@ŏ̃|PtVM_lŒɂĂI
	}
#endif

}

//------------------------------------------------------------------
/**
 * @brief	fobOpFX^[gʒuݒ
 */
//------------------------------------------------------------------
void Debug_SetStartLocation(LOCATION_WORK * location)
{
	static const LOCATION_WORK StartLocation = {
		GAME_START_ZONE,
		DOOR_ID_JUMP_CODE,
		GAME_START_X,
		GAME_START_Z,
		DIR_DOWN
	};
	*location = StartLocation;
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------
typedef struct {
	u16 sex;
	u16 name_id;
}DEBUG_PERSON;


static const DEBUG_PERSON DebugPerson[] = {
	{ PM_MALE,	DEBUG_NAME_MASUDA },
	{ PM_MALE,	DEBUG_NAME_SUGIMORI },
	{ PM_MALE,	DEBUG_NAME_MORIMOTO },
	{ PM_MALE,	DEBUG_NAME_WATANABE },
	{ PM_MALE,	DEBUG_NAME_OHMORI },
	{ PM_MALE,	DEBUG_NAME_UNNO },
	{ PM_MALE,	DEBUG_NAME_ICHINOSE },
	{ PM_MALE,	DEBUG_NAME_MATSUSHIMA },
	{ PM_MALE,	DEBUG_NAME_SOGABE },
	{ PM_MALE,	DEBUG_NAME_FUJIWARA },
	{ PM_MALE,	DEBUG_NAME_TAMADA },
	{ PM_MALE,	DEBUG_NAME_MORI },
	{ PM_MALE,	DEBUG_NAME_HIRONOBU },
	{ PM_MALE,	DEBUG_NAME_OOTA },
	{ PM_FEMALE,	DEBUG_NAME_EO },
	{ PM_MALE,	DEBUG_NAME_FUCHINO },
	{ PM_MALE,	DEBUG_NAME_TOYAMA },
	{ PM_FEMALE,	DEBUG_NAME_EMI },
	{ PM_MALE,	DEBUG_NAME_YAGI },
	{ PM_MALE,	DEBUG_NAME_OOMURA },
	{ PM_MALE,	DEBUG_NAME_TOMOMICHI },
	{ PM_MALE,	DEBUG_NAME_MATSUDA },
	{ PM_MALE,	DEBUG_NAME_KAGAYA },
	{ PM_MALE,	DEBUG_NAME_NOHARA },
	{ PM_MALE,	DEBUG_NAME_TAYA },
	{ PM_MALE,	DEBUG_NAME_NAHI },
	{ PM_FEMALE,	DEBUG_NAME_IWASAWA },
	{ PM_MALE,	DEBUG_NAME_GOTO },
	{ PM_MALE,	DEBUG_NAME_SAITO },
	{ PM_MALE,	DEBUG_NAME_TOMOYA },
	{ PM_MALE,	DEBUG_NAME_OHNO },
	{ PM_MALE,	DEBUG_NAME_NISHINO },
	{ PM_MALE,	DEBUG_NAME_TETSUJI },
	{ PM_MALE,	DEBUG_NAME_SIMOYAMADA },
	{ PM_MALE,	DEBUG_NAME_TOMISAWA },
	{ PM_MALE,	DEBUG_NAME_KAWACHIMARU },
	{ PM_FEMALE,	DEBUG_NAME_SATO },
	{ PM_MALE,	DEBUG_NAME_TADASHI },
	{ PM_MALE,	DEBUG_NAME_NAKATSUI },
	{ PM_MALE,	DEBUG_NAME_HIROKI },
	{ PM_MALE,	DEBUG_NAME_MATSUMIYA },
	{ PM_MALE,	DEBUG_NAME_DIAMOND },
	{ PM_FEMALE,	DEBUG_NAME_PEARL },
};
static int DebugPersonMax = NELEMS(DebugPerson);

//------------------------------------------------------------------
//------------------------------------------------------------------
static int GetDebugUserID(void)
{
#ifdef	DEBUG_ONLY_FOR_masuda
	return DEBUG_NAME_MASUDA;
#elif	defined(DEBUG_ONLY_FOR_sugimori)
	return DEBUG_NAME_SUGIMORI;
#elif	defined(DEBUG_ONLY_FOR_morimoto)
	return DEBUG_NAME_MORIMOTO;
#elif	defined(DEBUG_ONLY_FOR_watanabe)
	return DEBUG_NAME_WATANABE;
#elif	defined(DEBUG_ONLY_FOR_ohmori)
	return DEBUG_NAME_OHMORI;
#elif	defined(DEBUG_ONLY_FOR_unno)
	return DEBUG_NAME_UNNO;
#elif	defined(DEBUG_ONLY_FOR_ichinose)
	return DEBUG_NAME_ICHINOSE;
#elif	defined(DEBUG_ONLY_FOR_matsushimA)
	return DEBUG_NAME_MATSUSHIMA;
#elif	defined(DEBUG_ONLY_FOR_sogabe)
	return DEBUG_NAME_SOGABE;
#elif	defined(DEBUG_ONLY_FOR_fujiwara)
	return DEBUG_NAME_FUJIWARA;
#elif	defined(DEBUG_ONLY_FOR_tamada)
	return DEBUG_NAME_TAMADA;
#elif	defined(DEBUG_ONLY_FOR_mori)
	return DEBUG_NAME_MORI;
#elif	defined(DEBUG_ONLY_FOR_yoshida)
	return DEBUG_NAME_HIRONOBU;
#elif	defined(DEBUG_ONLY_FOR_oota)
	return DEBUG_NAME_OOTA;
#elif	defined(DEBUG_ONLY_FOR_eo)
	return DEBUG_NAME_EO;
#elif	defined(DEBUG_ONLY_FOR_fuchino)
	return DEBUG_NAME_FUCHINO;
#elif	defined(DEBUG_ONLY_FOR_toyama)
	return DEBUG_NAME_TOYAMA;
#elif	defined(DEBUG_ONLY_FOR_emi_yoshida)
	return DEBUG_NAME_EMI;
#elif	defined(DEBUG_ONLY_FOR_hiroyuki_yagi)
	return DEBUG_NAME_YAGI;
#elif	defined(DEBUG_ONLY_FOR_yusuke_ohmura)
	return DEBUG_NAME_OOMURA;
#elif	defined(DEBUG_ONLY_FOR_tomo_ohta)
	return DEBUG_NAME_TOMOMICHI;
#elif	defined(DEBUG_ONLY_FOR_matsuda)
	return DEBUG_NAME_MATSUDA;
#elif	defined(DEBUG_ONLY_FOR_kagaya)
	return DEBUG_NAME_KAGAYA;
#elif	defined(DEBUG_ONLY_FOR_nohara)
	return DEBUG_NAME_NOHARA;
#elif	defined(DEBUG_ONLY_FOR_taya)
	return DEBUG_NAME_TAYA;
#elif	defined(DEBUG_ONLY_FOR_nakamura)
	return DEBUG_NAME_NAHI;
#elif	defined(DEBUG_ONLY_FOR_iwasawa)
	return DEBUG_NAME_IWASAWA;
#elif	defined(DEBUG_ONLY_FOR_gotou)
	return DEBUG_NAME_GOTO;
#elif	defined(DEBUG_ONLY_FOR_saitou)
	return DEBUG_NAME_SAITO;
#elif	defined(DEBUG_ONLY_FOR_tomoya_takahashi)
	return DEBUG_NAME_TOMOYA;
#elif	defined(DEBUG_ONLY_FOR_ohno)
	return DEBUG_NAME_OHNO;
#elif	defined(DEBUG_ONLY_FOR_nishino)
	return DEBUG_NAME_NISHINO;
#elif	defined(DEBUG_ONLY_FOR_tetsuji_ohta)
	return DEBUG_NAME_TETSUJI;
#elif	defined(DEBUG_ONLY_FOR_simoyamada)
	return DEBUG_NAME_SIMOYAMADA;
#elif	defined(DEBUG_ONLY_FOR_tomisawa)
	return DEBUG_NAME_TOMISAWA;
#elif	defined(DEBUG_ONLY_FOR_kawachimaru)
	return DEBUG_NAME_KAWACHIMARU;
#elif	defined(DEBUG_ONLY_FOR_satou)
	return DEBUG_NAME_SATO;
#elif	defined(DEBUG_ONLY_FOR_takahashi)
	return DEBUG_NAME_TADASHI;
#elif	defined(DEBUG_ONLY_FOR_nakatsui)
	return DEBUG_NAME_NAKATSUI;
#elif	defined(DEBUG_ONLY_FOR_fuchino)
	return DEBUG_NAME_HIROKI;
#elif	defined(DEBUG_ONLY_FOR_matsumiya)
	return DEBUG_NAME_MATSUMIYA;
#endif
	return DEBUG_NAME_DIAMOND;
}

//------------------------------------------------------------------
//------------------------------------------------------------------
static int MakeMyStatus(MYSTATUS * my)
{
	STRCODE namebuf[PERSON_NAME_SIZE + EOM_SIZE + 8];
	MSGDATA_MANAGER * msgman;
	int usr_id;
	int i;

	usr_id = GetDebugUserID();

	msgman = MSGMAN_Create(	MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_debugname_dat, HEAPID_BASE_DEBUG);
	MSGMAN_GetStr(msgman, usr_id, namebuf);
	MSGMAN_Delete( msgman);

	Debug_MyStatus_Make(my, namebuf, DebugPerson[usr_id].sex);
	MyStatus_SetID(my, gf_mtRand() & 0xffff);
	MyStatus_SetPlayTime(my, 765,43,21);
	MyStatus_SetGold(my, 123456);

	// jI[ł̌ڂID琶
	MyStatus_SetTrainerView(my, UnionView_GetTrainerType( MyStatus_GetID(my), 0, 0 ));	

	/*	//폜06.02.17
	for (i = 0; i < 8; i++) {
		MyStatus_SetBadgeFlag(my, i);
	}
	*/
	return usr_id;
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
static const struct { u16 itemno; u16 itemcount; } Items[] = {
//	{ITEM_ZITENSYA, 1},
	{ITEM_TAUNMAPPU, 1},
	{ITEM_MONSUTAABOORU, 99},
	{ITEM_KIZUGUSURI, 99},
};

//------------------------------------------------------------------
//------------------------------------------------------------------
static void AddItemList(MYITEM * myitem, int heapID)
{
	int i; 
	for (i = 0; i < NELEMS(Items); i++) {
		MyItem_AddItem(myitem, Items[i].itemno, Items[i].itemcount, heapID);
	}
}



