#include "common.h"
#include "system/pm_str.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/arc_util.h"
#include "system/bmp_cursor.h"
#include "fld_bmp.h"
#include "fieldmap.h"
#include "field_common.h"
#include "system/fontproc.h"

#include "debug_saito.h"

#include "system/brightness.h"

#include "camera_move_test.h"

#include "fieldsys.h"

#include "field_event.h"
#include "mapdefine.h"
#include "worldmap.h"
//#include "effect_uground.h"
#include "player.h"
#include "zonedata.h"

//#include "under_tp.h"
#include "comm_field_state.h"  // nʐMp

#include "ev_mapchange.h"
#include "eventdata.h"		//][̃Cxgf[^QƂ̂

//|P֘A
#include "system/buflen.h"

#include "system/msgdata_util.h"

#include "location.h"		//ꂪȂsituation_local.hŃG[ɂȂ
#include "situation_local.h"

#include "sway_grass_enc.h"

#include "msgdata/msg_debug_saito.h"
#include "msgdata/msg.naix"
#define	FDBG_DEBUG_PL		(FLD_SYSFONT_PAL)	//pbgio[
//----------------------------------------------------------------------------
//	\̒`
//----------------------------------------------------------------------------
typedef struct _DEBUG_WINDOW_DATA{
//	u8	work;
	
	u16 debug_list;
	u16 debug_cursor;

	GF_BGL_BMPWIN	win;
	BMPLIST_WORK* lw;		// BMPj[[N
	struct _FIELDSYS_WORK * fsys;
	BMP_MENULIST_DATA 	*ld;
}DEBUG_WINDOW_DATA;

typedef struct _DEBUG_WORK_DATA{
	struct _FIELDSYS_WORK * fsys;
	GF_CAMERA_PTR camera;
	u8 camera_tbl_no;
	
	GF_BGL_BMPWIN	win;
}DEBUG_WORK_DATA;

typedef struct {
	int seq;
	int subseq;
	int next_zone_id;
	int next_door_id;
	int next_x;
	int next_z;
	BOOL brightness;
}EVENT_UGCHG_WORK;

static const GF_CAMERA_PARAM TestOrgCamera[] =
{
	{
		/*0x30aec1*/0x29aec1,
		{
			-0x29fe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x05c1,
		0	//dummy
	},
	{								// 
		0x189647,
		{
			-0x2ffe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x09c1,
		0	//dummy
	},
	{
		0x23e93f,
		{
			-0x2cfe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x06c1,
		0	//dummy
	},
	{
		0x1b8152,
		{
			-0x29fe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x08c1,
		0	//dummy
	},
	{
		0x3346fe,
		{
			-0x29fe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x04c1,
		0	//dummy
	},
	{
		0x298ec1,
		{
			-0x29fe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x05c1,
		0	//dummy
	},
	{
		0x14aec0,
		{
			-0x29fe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x0B01,
		0	//dummy
	},
};

//------------------------------------------------------------------------------
//	global
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//	extern
//------------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	static ϐ
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
//	static ֐
//---------------------------------------------------------------------------
static void InitDebugWindow(DEBUG_WINDOW_DATA *wp);
static void DebugListFree(TCB_PTR tcb,void* work);
static void DebugWindowExit(TCB_PTR tcb,void* work);
static void DebugListControlTask(TCB_PTR tcb,void* work);

static void ChangeStressFlg(TCB_PTR tcb,void *work);

///static void TestMapChangeNum(TCB_PTR tcb,void *work);
static void DispSwayGrassRec(TCB_PTR tcb,void *work);
///static void ChangeBrightess(TCB_PTR tcb,void *work);

///static void SwitchUnderPanel(TCB_PTR tcb,void *work);

static void MBMapSetExit(TCB_PTR tcb,void* work);


static void SetCameraDebugWindow(TCB_PTR tcb,void *work);
static void SetupCameraInfoWindow(TCB_PTR tcb,void *work);
static void SetupCameraListWindow(TCB_PTR tcb,void *work);

static void SetCamera(TCB_PTR tcb,void *work);
void SetSwayGrass(TCB_PTR tcb,void *work);

//ύX
static void SetPlayerHeightChangeTask(TCB_PTR tcb,void *work);
//n؂ւ
///static void ChangeUnderGround(TCB_PTR tcb,void *work);

//fobO
static void DebugCheckHeightGrid(TCB_PTR tcb,void *work);
static void DebugCheckHeightBlock(TCB_PTR tcb,void *work);
//----------------------------------------------------------------------------
//	Xgږ
//----------------------------------------------------------------------------
/**
//Cp
///static const u16 Msg01_01[] = { hu_,ka_,TI_,EE_,TTU_,KU_,EOM_ };
static const u16 Msg01_02[] = { KA_,ME_,RA_,SE_,TTU_,TO_,EOM_ };
///static const u16 Msg01_03[] = { ti_,ka_,PA_,NE_,RU_,SU_,I_,TTU_,TI_,EOM_ };
static const u16 Msg01_04[] = { yu_,re_,ku_,sa_,RE_,KO_,bou_,DO_,EOM_ };
static const u16 Msg01_05[] = { ta_,ka_,sa_,TI_,EE_,TTU_,KU_,B__,EOM_ };
static const u16 Msg01_06[] = { ta_,ka_,sa_,TI_,EE_,TTU_,KU_,G__,EOM_ };
static const u16 Msg01_07[] = { KA_,ME_,RA_,EOM_ };
static const u16 Msg01_08[] = { ta_,ka_,sa_,he_,n_,ko_,u_,EOM_ };
///static const u16 Msg01_09[] = { ti_,ka_,EOM_ };
//uCglXp
///static const u16 brtMsg01_01[] = { BU_,RA_,TTU_,KU_,A_,U_,TO_,EOM_ };
///static const u16 brtMsg01_02[] = { HO_,WA_,I_,TO_,A_,U_,TO_,EOM_ };
///static const u16 brtMsg01_03[] = { mo_,do_,su_,EOM_ };
//Jp
static const u16 CamMsg01_01[] = { KA_,ME_,RA_,zi_,yyo_,u_,ho_,u_,EOM_ };
static const u16 CamMsg01_02[] = { KA_,ME_,RA_,RI_,SU_,TO_,EOM_ };
*/
//--------------------------------------------------------------------------
//	ڂƎs֐̃Xg
//--------------------------------------------------------------------------
typedef struct ID_PARAM_tag
{
	u32  str_id;
	u32  param;
}ID_PARAM;
/**
//Cp
static const BMPLIST_DATA MainDebugList[] = {
///	{(void*)Msg01_01,(u32)TestMapChangeNum},
	{(void*)Msg01_02,(u32)SetCamera},
///	{(void*)Msg01_03,(u32)SwitchUnderPanel},
	{(void*)Msg01_04,(u32)DispSwayGrassRec},
	{(void*)Msg01_05,(u32)DebugCheckHeightBlock},
	{(void*)Msg01_06,(u32)DebugCheckHeightGrid},
	{(void*)Msg01_07,(u32)SetCameraDebugWindow},
	{(void*)Msg01_08,(u32)SetPlayerHeightChangeTask},
///	{(void*)Msg01_09,(u32)ChangeUnderGround},
};
*/
/**
//uCglXp
static const BMPLIST_DATA BrightnessDebugList[] = {
	{(void*)brtMsg01_01,(u32)ChangeBrightess},
	{(void*)brtMsg01_02,(u32)ChangeBrightess},
	{(void*)brtMsg01_03,(u32)ChangeBrightess},
};
*/
/**
//Jp
static const BMPLIST_DATA CameraDebugList[] = {
	{(void*)CamMsg01_01,(u32)SetupCameraInfoWindow},
	{(void*)CamMsg01_02,(u32)SetupCameraListWindow},
};
*/
static const ID_PARAM DebugMenuMainList[] = {
	{ D_SAITO_MSG01, (u32)SetCamera },
	{ D_SAITO_MSG02, (u32)DispSwayGrassRec },
    { D_SAITO_MSG03, (u32)DebugCheckHeightBlock },
    { D_SAITO_MSG04, (u32)DebugCheckHeightGrid },
    { D_SAITO_MSG05, (u32)SetCameraDebugWindow },
    { D_SAITO_MSG06, (u32)SetPlayerHeightChangeTask },
	{ D_SAITO_MSG09, (u32)SetSwayGrass },

};

static const ID_PARAM DebugCameraMenuList[] = {
	{ D_SAITO_MSG07, (u32)SetupCameraInfoWindow },
	{ D_SAITO_MSG08, (u32)SetupCameraListWindow },
};

//---------------------------------------------------------------------------
//  EBhEݒ
//---------------------------------------------------------------------------
//CEBhE
static const BMPWIN_DAT	MainDebugListWindowData = {
	GF_BGL_FRAME3_M,
	0,1,
	14,21,
	FDBG_DEBUG_PL,8
};
/**
//uCglXEBhE
static const BMPWIN_DAT	BrightnessDebugListWindowData = {
	GF_BGL_FRAME3_M,
	0,1,
	12,7,
	FDBG_DEBUG_PL,8
};
*/
//JEBhE
static const BMPWIN_DAT	CameraDebugListWindowData = {
	GF_BGL_FRAME3_M,
	0,1,
	14,5,
	FDBG_DEBUG_PL,8
};
//------------------------------------------------------------------
//	ڃXgf[^
//------------------------------------------------------------------

/////////////////////////////////////////////////////////////////////////////////////////
//Cp
static const BMPLIST_HEADER MainDebugListHeader = {
	//MainDebugList,		//\f[^|C^
	NULL,				//\f[^|C^
	NULL,				//J[\ړƂ̃R[obN֐
	NULL,		//PsƂ̃R[obN֐
	NULL,		//GF_BGL_BMPWIN * 
	NELEMS(DebugMenuMainList),//Xgڐ
	NELEMS(DebugMenuMainList),//\ő區ڐ
	2,					//x\wW
	12,					//ڕ\wW
	1,					//J[\\wW
	8,					//\xW
	FBMP_COL_WHITE,		//F
	FBMP_COL_BLACK,		//wiF
	FBMP_COL_BLK_SDW,	//eF
	0,					//Ԋuw
	1,					//Ԋux
	BMPLIST_NO_SKIP,	//y[WXLbv^Cv
	FONT_SYSTEM,			//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	NULL,				//*work
};
//Jp
static const BMPLIST_HEADER CameraDebugListHeader = {
	//CameraDebugList,		//\f[^|C^
	NULL,		//\f[^|C^
	NULL,				//J[\ړƂ̃R[obN֐
	NULL,		//PsƂ̃R[obN֐
	NULL,		//GF_BGL_BMPWIN *
	NELEMS(DebugCameraMenuList),//Xgڐ
	NELEMS(DebugCameraMenuList),//\ő區ڐ
	2,					//x\wW
	12,					//ڕ\wW
	1,					//J[\\wW
	8,					//\xW
	FBMP_COL_WHITE,		//F
	FBMP_COL_BLACK,		//wiF
	FBMP_COL_BLK_SDW,	//eF
	0,					//Ԋuw
	1,					//Ԋux
	BMPLIST_NO_SKIP,	//y[WXLbv^Cv
	FONT_SYSTEM,			//w
	0,					//afJ[\(allow)\tO(0:ON,1:OFF)
	NULL,				//*work
};

//===============================================================================
//	EBhE
//===============================================================================
//
static void InitDebugWindow(DEBUG_WINDOW_DATA *wp)
{
	wp->debug_list = 0;
	wp->debug_cursor = 0;
}
//Xg̊J
static void DebugListFree(TCB_PTR tcb,void* work)
{
	DEBUG_WINDOW_DATA	*wp;

	wp = (DEBUG_WINDOW_DATA*)work;

	//BMPEBhEOFF
	GF_BGL_BmpWinOff(&wp->win);

	//BMPXgj
	BmpListExit( wp->lw,&wp->debug_list,&wp->debug_cursor );
	//BMPWindow
	GF_BGL_BmpWinDel( &wp->win );
	return;
}
//fobOEBhE
static void FreeDebugWindow(TCB_PTR tcb,void* work)
{
	//Xg̊J
	DebugListFree(tcb,work);
	//[NJ
	sys_FreeMemoryEz(work);
}
//fobOEBhEI
static void DebugWindowExit(TCB_PTR tcb,void* work)
{
	//EBhE
	FreeDebugWindow(tcb,work);
	//^XN
	TCB_Delete(tcb);
	//OBJ̓~
	FieldSystemProc_SeqHoldEnd();
	return;
}
//XgRg[
static void DebugListControlTask(TCB_PTR tcb,void* work)
{
	s32	ret_code;
	TCB_FUNC	func;
	DEBUG_WINDOW_DATA	*wp;
	
	wp = (DEBUG_WINDOW_DATA*)work;

	ret_code = BmpListMain(wp->lw);
	//L[씻
	if(sys.trg & PAD_BUTTON_A){
		if(ret_code){
			BMP_MENULIST_Delete( wp->ld );	//Ƃ肠
			func = (TCB_FUNC)ret_code;
			func(tcb,work);
		}
		return;
	}
	//j[LZ
	if(sys.trg & PAD_BUTTON_B){
		BMP_MENULIST_Delete( wp->ld );	//Ƃ肠
		DebugWindowExit(tcb,work);
		return;
	}
}
/**
//PxύXiubNAEgj
static void ChangeBrightess(TCB_PTR tcb,void *work)
{
	DebugWindowExit(tcb,work);
}
*/
//================================================================================
//	J
//================================================================================
static const u16 camera_info_msg1[] = { ki_,yyo_,ri_,EOM_ };
static const u16 camera_info_msg2[] = { A_,N_,GU_,RU_,X__,EOM_ };
static const u16 camera_info_msg3[] = { A_,N_,GU_,RU_,Y__,EOM_ };
static const u16 camera_info_msg4[] = { A_,N_,GU_,RU_,Z__,EOM_ };
static const u16 camera_info_msg5[] = { PA_,bou_,SU_,EOM_ };
static const u16 camera_info_msg6[] = { TA_,I_,PU_,EOM_ };

static const u16 camera_info_msg4_1[] = { P__,E__,R__,EOM_ };
static const u16 camera_info_msg4_2[] = { O__,R__,T__,EOM_ };

static const u16 camera_cont_msg1[] = { L__,Plus__,B__,Plus__,zi_ ,yyu_,u_  ,zi_ ,KI_ ,bou_,spc_,A_  ,N_  ,GU_ ,RU_,he_,n_ ,ko_,u_ ,EOM_ };
static const u16 camera_cont_msg2[] = { L__,Plus__,u_ ,e_    ,si_ ,ta_ ,spc_,spc_,spc_,spc_,spc_,spc_,ki_ ,yyo_,ri_,he_,n_ ,ko_,u_ ,EOM_ };
static const u16 camera_cont_msg3[] = { L__,Plus__,A__,Plus__,u_  ,e_  ,si_ ,ta_ ,spc_,spc_,spc_,PA_ ,bou_,SU_ ,he_,n_ ,ko_,u_ ,n1_,EOM_ };
static const u16 camera_cont_msg4[] = { L__,Plus__,A__,Plus__,mi_ ,gi_ ,hi_ ,da_ ,ri_ ,spc_,spc_,PA_ ,bou_,SU_ ,he_,n_ ,ko_,u_ ,n2_,EOM_ };
static const u16 camera_cont_msg5[] = { L__,Plus__,X__,Plus__,zi_ ,yyu_,u_  ,zi_ ,KI_ ,bou_,spc_,spc_,spc_,KA_ ,ME_,RA_,i_ ,do_,u_ ,EOM_ };
static const u16 camera_cont_msg6[] = { L__,Plus__,Y__,Plus__,zi_ ,yyu_,u_  ,zi_ ,KI_ ,bou_,spc_,spc_,KA_ ,ME_ ,RA_,ku_,bi_,hu_,ri_,EOM_ };
static const u16 camera_cont_msg7[] = { B__,Plus__,X__,spc_  ,spc_,spc_,spc_,spc_,spc_,spc_,spc_,spc_,KA_ ,ME_ ,RA_,wo_,mo_,do_,su_,EOM_ };

static void DrawCameraInfo(GF_CAMERA_PTR camera_ptr,GF_BGL_BMPWIN	*win)
{	
	u16 buff[10];
	CAMERA_ANGLE angle;
	u16 angle_x;
	
	GF_BGL_BmpWinDataFill( win, 0x0f );
	
	GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg1, 1*8, 0, MSG_ALLPUT, NULL );
	GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg2, 1*8, 1*16, MSG_ALLPUT, NULL );
	GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg3, 1*8, 2*16, MSG_ALLPUT, NULL );
	GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg4, 1*8, 3*16, MSG_ALLPUT, NULL );
	GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg5, 1*8, 4*16, MSG_ALLPUT, NULL );
	GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg6, 1*8, 5*16, MSG_ALLPUT, NULL );
	
	PM_HexNumMsgSet(buff, GFC_GetCameraDistance(camera_ptr), NUM_MODE_LEFT, 8);
	GF_MSG_Print( win, FONT_SYSTEM, buff, 7*8, 0, MSG_ALLPUT, NULL );
	
	angle = GFC_GetCameraAngle(camera_ptr);
	//p˒nʂ̌Xɕϊ
	angle_x = -angle.x;
	PM_HexNumMsgSet(buff, angle_x, NUM_MODE_LEFT, 8);	
	GF_MSG_Print( win, FONT_SYSTEM, buff, 8*8, 1*16, MSG_ALLPUT, NULL );
	PM_HexNumMsgSet(buff, angle.y, NUM_MODE_LEFT, 8);	
	GF_MSG_Print( win, FONT_SYSTEM, buff, 8*8, 2*16, MSG_ALLPUT, NULL );
	PM_HexNumMsgSet(buff, angle.z, NUM_MODE_LEFT, 8);	
	GF_MSG_Print( win, FONT_SYSTEM, buff, 8*8, 3*16, MSG_ALLPUT, NULL );
	
	PM_HexNumMsgSet(buff, GFC_GetCameraPerspWay(camera_ptr), NUM_MODE_LEFT, 8);
	GF_MSG_Print( win, FONT_SYSTEM, buff, 8*8, 4*16, MSG_ALLPUT, NULL );
	
	if (GFC_GetCameraView(camera_ptr) == GF_CAMERA_PERSPECTIV){
		GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg4_1, 8*8, 5*16, MSG_ALLPUT, NULL );
	}else{
		GF_MSG_Print( win, FONT_SYSTEM, camera_info_msg4_2, 8*8, 5*16, MSG_ALLPUT, NULL );
	}
	
	GF_BGL_BmpWinOn( win );
	
}

//JpEBhE\z
static void SetCameraDebugList(struct _FIELDSYS_WORK * fsys)
{
	BMPLIST_HEADER bmplist_h;
	TCB_PTR	pTcb = NULL;
	DEBUG_WINDOW_DATA *wp = NULL;

	wp = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WINDOW_DATA));
	if(wp == NULL){
		//[NGA擾łȂΉȂ
		OS_Printf("map_num debug menu crate failed\n");
		return;
	}
	memset(wp,0,sizeof(DEBUG_WINDOW_DATA));

	//fobOj[pϐ
	InitDebugWindow(wp);

	wp->fsys = fsys;

	//C^XNǉ
	pTcb = TCB_Add(DebugListControlTask,wp,0);
	
	wp->ld = BMP_MENULIST_Create( NELEMS(DebugCameraMenuList), HEAPID_FIELD );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_saito_dat, HEAPID_FIELD);
		for(i=0; i<NELEMS(DebugCameraMenuList); i++)
		{
			BMP_MENULIST_AddArchiveString( wp->ld, msgman,
					DebugCameraMenuList[i].str_id, DebugCameraMenuList[i].param );
		}
		MSGMAN_Delete(msgman);
	}

	//BITMAPj[ǉ
	GF_BGL_BmpWinAddEx(fsys->bgl,&wp->win,&CameraDebugListWindowData);
	
	//BMPXgݒ
	bmplist_h = CameraDebugListHeader;
	bmplist_h.list = wp->ld;
	bmplist_h.win = &wp->win;
	wp->lw = BmpListSet(&bmplist_h,wp->debug_list,wp->debug_cursor,HEAPID_FIELD);

	return;
}
//JpEBhEZbg
static void SetCameraDebugWindow(TCB_PTR tcb,void *work)
{
	struct _FIELDSYS_WORK * fsys;
	DEBUG_WINDOW_DATA *wp;
	wp = (DEBUG_WINDOW_DATA *)work;
	fsys = wp->fsys;
	
	//CEBhE
	FreeDebugWindow(tcb,work);
	//CEBhE^XN
	TCB_Delete(tcb);
	//CxgtbN
	FieldSystemProc_SeqHold();
	//JEBhE\z
	SetCameraDebugList(fsys);
	
}
//JXgEBhE\^XN
static void CameraListDispTask(TCB_PTR tcb,void* work)
{
	BOOL flg;
	DEBUG_WORK_DATA *d_work = (DEBUG_WORK_DATA *)work;

	flg = FALSE;
	if ( sys.trg & PAD_KEY_RIGHT ){
		flg = TRUE;
		if (d_work->camera_tbl_no == NELEMS(TestOrgCamera)-1){
			d_work->camera_tbl_no=0;
		}else{
			d_work->camera_tbl_no++;
		}
	}else if (sys.trg & PAD_KEY_LEFT){
		flg = TRUE;
		if (d_work->camera_tbl_no == 0){
			d_work->camera_tbl_no = NELEMS(TestOrgCamera)-1;
		}else{
			d_work->camera_tbl_no--;
		}
	}
	
	if (flg == TRUE){
		//Jp[^ύX
		//JZbg
		{
			GFC_InitCameraTDA(
				Player_VecPosPtrGet(d_work->fsys->player),
				TestOrgCamera[d_work->camera_tbl_no].Distance,		// 
				&TestOrgCamera[d_work->camera_tbl_no].Angle,		//
				TestOrgCamera[d_work->camera_tbl_no].PerspWay,		// ˉh̊px
				TestOrgCamera[d_work->camera_tbl_no].View,
				TRUE,
				d_work->camera);
			GFC_CopyCameraTracePtr(d_work->fsys->camera_ptr, d_work->camera);
		}
		//J\
		DrawCameraInfo(d_work->camera,&d_work->win);
	}

	if (sys.trg & PAD_BUTTON_B){
		//Jf
		GFC_CopyCamera(d_work->camera,d_work->fsys->camera_ptr);
		//J폜
		GFC_FreeCamera(d_work->camera);
		//JA^b`
		GFC_AttachCamera(d_work->fsys->camera_ptr);
		
		GF_BGL_BmpWinOff( &d_work->win );
		GF_BGL_BmpWinDel( &d_work->win );

		sys_FreeMemoryEz((void *)work);
		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
	}
}

//JEBhE\^XN
static void CameraInfoDispTask(TCB_PTR tcb,void* work)
{
	DEBUG_WORK_DATA *d_work = (DEBUG_WORK_DATA *)work;

	if (sys.trg & PAD_BUTTON_B){
		
		//J폜
		GFC_FreeCamera(d_work->camera);
		//JA^b`
		GFC_AttachCamera(d_work->fsys->camera_ptr);
		
		GF_BGL_BmpWinOff( &d_work->win );
		GF_BGL_BmpWinDel( &d_work->win );

		sys_FreeMemoryEz((void *)work);
		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
	}
}

//JpEBhE\z
static void SetCameraInfoWindow(struct _FIELDSYS_WORK * fsys)
{
	
	DEBUG_WORK_DATA *d_work = NULL;
	TCB_PTR	pTcb = NULL;
	d_work = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WORK_DATA));
	d_work->camera_tbl_no = 0;
	
	d_work->fsys = fsys;
	//J
	d_work->camera = GFC_AllocCamera(HEAPID_FIELD);
	GFC_CopyCamera(d_work->fsys->camera_ptr, d_work->camera);
	GFC_AttachCamera(d_work->camera);
	//C^XNǉ
	pTcb = TCB_Add(CameraInfoDispTask,d_work,0);

	GF_BGL_BmpWinAdd( d_work->fsys->bgl,&d_work->win,GF_BGL_FRAME3_M, 0, 0, 14, 12, 1, 1 );
	
	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 16<<1, HEAPID_FIELD );
	//J\
	DrawCameraInfo(d_work->camera,&d_work->win);

	//CxgtbN
	FieldSystemProc_SeqHold();
	return;
}

//JXgpEBhE\z
static void SetCameraListWindow(struct _FIELDSYS_WORK * fsys)
{
	
	DEBUG_WORK_DATA *d_work;
	TCB_PTR	pTcb = NULL;
	d_work = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WORK_DATA));
	d_work->camera_tbl_no = 0;
	
	d_work->fsys = fsys;
	//J
	d_work->camera = GFC_AllocCamera(HEAPID_FIELD);
	{
		GFC_InitCameraTDA(
				Player_VecPosPtrGet(fsys->player),
				TestOrgCamera[0].Distance,		// 
				&TestOrgCamera[0].Angle,		//
				TestOrgCamera[0].PerspWay,		// ˉh̊px
				TestOrgCamera[0].View,
				TRUE,
				d_work->camera);
		GFC_CopyCameraTracePtr(d_work->fsys->camera_ptr, d_work->camera);
	}
	GFC_AttachCamera(d_work->camera);
	//C^XNǉ
	pTcb = TCB_Add(CameraListDispTask,d_work,0);

	GF_BGL_BmpWinAdd( d_work->fsys->bgl,&d_work->win,GF_BGL_FRAME3_M, 0, 0, 14, 12, 1, 1 );
	
	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 16<<1, HEAPID_FIELD );
	//J\
	DrawCameraInfo(d_work->camera,&d_work->win);

	//CxgtbN
	FieldSystemProc_SeqHold();
	return;
}

//JpEBhEZbg
static void SetupCameraInfoWindow(TCB_PTR tcb,void *work)
{
	struct _FIELDSYS_WORK * fsys;
	DEBUG_WINDOW_DATA *wp;
	wp = (DEBUG_WINDOW_DATA *)work;
	fsys = wp->fsys;
	
	//CEBhE
	FreeDebugWindow(tcb,work);
	//CEBhE^XN
	TCB_Delete(tcb);
	//JEBhE\z
	SetCameraInfoWindow(fsys);
}

//JXgpEBhEZbg
static void SetupCameraListWindow(TCB_PTR tcb,void *work)
{
	struct _FIELDSYS_WORK * fsys;
	DEBUG_WINDOW_DATA *wp;
	wp = (DEBUG_WINDOW_DATA *)work;
	fsys = wp->fsys;
	
	//CEBhE
	FreeDebugWindow(tcb,work);
	//CEBhE^XN
	TCB_Delete(tcb);
	//JEBhE\z
	SetCameraListWindow(fsys);
}

static void DrawSwayGrassInfo(struct _FIELDSYS_WORK * fsys, GF_BGL_BMPWIN	*win)
{
	int i;
	GF_BGL_BmpWinDataFill( win, 0x0f );

	for (i=0;i<3;i++){
		SWAY_GRASS_HIST * hist;
		SITUATION *st;
		int chain;
		int monsno;
		st = SaveData_GetSituation(fsys->savedata);
		hist = Situation_GetSwayGrassHist(st);
		chain = hist->SwayGrassRec[i].Chain;
		monsno = hist->SwayGrassRec[i].MonsNo;
		{
			//|P擾̂߁A|P
			STRBUF *name_buf;
			name_buf = MSGDAT_UTIL_GetMonsName( monsno, HEAPID_FIELD );

			GF_STR_PrintSimple( win, FONT_SYSTEM, name_buf, 0, 16*i, MSG_ALLPUT, NULL );
			{
				u16 buff[10];
				PM_NumMsgSet(buff, chain, NUM_MODE_LEFT, 5);
				GF_MSG_Print( win, FONT_SYSTEM, buff, 10*8, 16*i, MSG_ALLPUT, NULL );
			}
			STRBUF_Delete(name_buf);
		}
	}
	
	GF_BGL_BmpWinOn( win );
	
}

//hꑐEBhE\^XN
static void SwayGrassInfoDispTask(TCB_PTR tcb,void* work)
{
	DEBUG_WORK_DATA *d_work = (DEBUG_WORK_DATA *)work;

	if (sys.trg & PAD_BUTTON_B){
		
		GF_BGL_BmpWinOff( &d_work->win );
		GF_BGL_BmpWinDel( &d_work->win );

		sys_FreeMemoryEz((void *)work);
		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
	}
}

//hꑐpEBhE\z
static void SetSwayGrassInfoWindow(struct _FIELDSYS_WORK * fsys)
{
	
	DEBUG_WORK_DATA *d_work = NULL;
	TCB_PTR	pTcb = NULL;
	d_work = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WORK_DATA));
	
	d_work->fsys = fsys;
	//C^XNǉ
	pTcb = TCB_Add(SwayGrassInfoDispTask,d_work,0);

	GF_BGL_BmpWinAdd( d_work->fsys->bgl,&d_work->win,GF_BGL_FRAME3_M, 0, 0, 14, 6, 1, 1 );
	
	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 16<<1, HEAPID_FIELD );
	//hꑐ\
	DrawSwayGrassInfo(fsys, &d_work->win);

	//CxgtbN
	FieldSystemProc_SeqHold();
	return;
}

//hꑐR[h\
static void DispSwayGrassRec(TCB_PTR tcb,void *work)
{
	struct _FIELDSYS_WORK * fsys;
	DEBUG_WINDOW_DATA *wp;
	wp = (DEBUG_WINDOW_DATA *)work;
	fsys = wp->fsys;
	
	//CEBhE
	FreeDebugWindow(tcb,work);
	//CEBhE^XN
	TCB_Delete(tcb);
	//hꑐEBhE\z
	SetSwayGrassInfoWindow(fsys);

}

static void CameraControlTask(TCB_PTR tcb,void *work)
{
	DEBUG_WORK_DATA *d_work = (DEBUG_WORK_DATA *)work;
	(void)CameraInput(d_work->camera);


	if ( (sys.cont & PAD_BUTTON_B) && (sys.trg & PAD_BUTTON_X) ){

		//JZbg
		{
			GFC_InitCameraTDA(
				Player_VecPosPtrGet(d_work->fsys->player),
				TestOrgCamera[0].Distance,		// 
				&TestOrgCamera[0].Angle,		//
				TestOrgCamera[0].PerspWay,		// ˉh̊px
				TestOrgCamera[0].View,
				TRUE,
				d_work->camera);

			GFC_CopyCameraTracePtr(d_work->fsys->camera_ptr, d_work->camera);
		}
	}

	if (sys.cont & PAD_BUTTON_L){
		//Jf
		GFC_CopyCamera(d_work->camera,d_work->fsys->camera_ptr);
		//J폜
		GFC_FreeCamera(d_work->camera);
		//JA^b`
		GFC_AttachCamera(d_work->fsys->camera_ptr);
		//[NJ
		sys_FreeMemoryEz(d_work);
		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
	}
}

static void SetCamera(TCB_PTR tcb,void *work)
{
	DEBUG_WORK_DATA *d_work;
	
	DEBUG_WINDOW_DATA *wp;
	wp = (DEBUG_WINDOW_DATA *)work;

	d_work = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WORK_DATA));
	
	d_work->fsys = wp->fsys;
	//J
	d_work->camera = GFC_AllocCamera(HEAPID_FIELD);
	GFC_CopyCamera(d_work->fsys->camera_ptr, d_work->camera);
	GFC_AttachCamera(d_work->camera);
	
	//CxgtbN
	FieldSystemProc_SeqHold();
	//EBhE
	FreeDebugWindow(tcb,work);
	//CEBhE^XN
	TCB_Delete(tcb);
	//^XNZbg
	TCB_Add(CameraControlTask,d_work,0);

}

#if 0
//WvWݒEBhE^XN
static void BlockjumpDispTask(TCB_PTR tcb,void* work)
{
	u16 buff[4];
	if (sys.trg & PAD_KEY_UP){
		//J[\
		;
	}
	if (sys.trg & PAD_KEY_DOWN){
		//J[\;
	}
	if (sys.trg & PAD_KEY_RIGHT){
		//l
		//
		PM_NumMsgSet(buff, /**/10, NUM_MODE_ZERO, 2);
		MSG_Print( camera_info_win, FONT_SYSTEM, buff, 2*8, 0, MSG_ALLPUT, NULL );
		GF_BGL_BmpOn( camera_info_win );
	}
	if (sys.trg & PAD_KEY_LEFT){
		//l
		//
		PM_NumMsgSet(buff, /**/5, NUM_MODE_ZERO, 2);
		MSG_Print( camera_info_win, FONT_SYSTEM, buff, 2*8, 0, MSG_ALLPUT, NULL );
		GF_BGL_BmpOn( camera_info_win );
	}
	if (sys.trg & PAD_BUTTON_A){
		//XZ̒lf
		;
	}
	if (sys.trg & PAD_BUTTON_B){
		GF_BGL_BmpOff( camera_info_win );
		GF_BGL_BmpDel( camera_info_win );

		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
	}
}
#endif

/**
//WvWݒEBhEZbg
static void SwitchUnderPanel(TCB_PTR tcb,void *work)
{
	DEBUG_WINDOW_DATA *wp = (DEBUG_WINDOW_DATA *)work;
	//InitUnderGroundTP(wp->fsys);
	DebugWindowExit(tcb,work);
}
*/
//-----------------------------------------------------------------------------
//	ANZX֐
//-----------------------------------------------------------------------------
//fobOCEBhE\z֐
void DBGSAI_MapNumDebugListSet(struct _FIELDSYS_WORK * fsys)
{
	BMPLIST_HEADER bmplist_h;
	TCB_PTR	pTcb = NULL;
	DEBUG_WINDOW_DATA *wp = NULL;
	wp = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WINDOW_DATA));
	if(wp == NULL){
		//[NGA擾łȂΉȂ
		OS_Printf("map_num debug menu crate failed\n");
		return;
	}
	memset(wp,0,sizeof(DEBUG_WINDOW_DATA));

	wp->fsys = fsys;

	//fobOj[pϐ
	InitDebugWindow(wp);

	//C^XNǉ
	pTcb = TCB_Add(DebugListControlTask,wp,0);

	wp->ld = BMP_MENULIST_Create( NELEMS(DebugMenuMainList), HEAPID_FIELD );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_debug_saito_dat, HEAPID_FIELD);
		for(i=0; i<NELEMS(DebugMenuMainList); i++)
		{
			BMP_MENULIST_AddArchiveString( wp->ld, msgman,
					DebugMenuMainList[i].str_id, DebugMenuMainList[i].param );
		}
		MSGMAN_Delete(msgman);
	}

	//BITMAPj[ǉ
	GF_BGL_BmpWinAddEx(fsys->bgl,&wp->win,&MainDebugListWindowData);
	//BMPXgݒ
	bmplist_h = MainDebugListHeader;
	bmplist_h.list = wp->ld;
	bmplist_h.win = &wp->win;
	wp->lw = BmpListSet(&bmplist_h,0,0,HEAPID_FIELD);
	//CxgtbN
	FieldSystemProc_SeqHold();
	return;
}

static int DebugPlayerHeightOfs = 0;

//ς
static void HeightChangeTask(TCB_PTR tcb,void* work)
{
	VecFx32 *ofs;
	const VecFx32 *vec;
	
	DEBUG_WORK_DATA *d_work = (DEBUG_WORK_DATA *)work;
	
	ofs = Player_VecDrawOffsPtrGet( d_work->fsys->player );
	vec = Player_VecPosPtrGet(d_work->fsys->player);
//	BLACT_WORK* bl_w;
//	bl_w = BLACT_WorkGet(FldBlActIdx, map3Ddata->actor[0].actorno);
	
	if (sys.trg & PAD_KEY_UP){
		OS_Printf("fobOFUP\n");
		DebugPlayerHeightOfs++;
		ofs->y += (FX32_ONE/4);
//		bl_w->Matrix.y+= (FX32_ONE/4);
	}else if (sys.trg & PAD_KEY_DOWN){
		OS_Printf("fobOFDOWN\n");
		DebugPlayerHeightOfs--;
		ofs->y -= (FX32_ONE/4);
//		bl_w->Matrix.y-= (FX32_ONE/4);
	}

	if (sys.trg & PAD_BUTTON_X){
		//Zbg
		OS_Printf("fobOFZbg\n");
		DebugPlayerHeightOfs = 0;
		ofs->y = vec->y;
		ofs->y += (FX32_ONE*16);

//		bl_w->Matrix.y = map3Ddata->actor[0].global.y;
//		bl_w->Matrix.y+=(FX32_ONE*16);
	}
	
	if (sys.trg & PAD_BUTTON_B){
		sys_FreeMemoryEz(work);
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
	}
}

//ύX^XNZbg
static void SetPlayerHeightChangeTask(TCB_PTR tcb,void *work)
{
	DEBUG_WORK_DATA *d_work;
	
	DEBUG_WINDOW_DATA *wp;
	wp = (DEBUG_WINDOW_DATA *)work;
	d_work = sys_AllocMemory(HEAPID_FIELD,sizeof(DEBUG_WORK_DATA));
	
	d_work->fsys = wp->fsys;	
	//CEBhE
	FreeDebugWindow(tcb,work);
	//CEBhE^XN
	TCB_Delete(tcb);
	//^XNZbg
	TCB_Add(HeightChangeTask,d_work,0);
}

//============================================================================================//
static BOOL Sub_UgFadeIn(GMEVENT_CONTROL * event);
static BOOL Sub_UgFadeOut(GMEVENT_CONTROL * event);

/**
//n؂ւ
static void ChangeUnderGround(TCB_PTR tcb,void *work)
{
	DebugWindowExit(tcb,work);
}
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL Sub_UgFadeOut(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);

	switch (mcw->subseq) {
		case 0:	
		GameSystem_FinishFieldProc(fsys);
		(mcw->subseq) ++;
		break;
	case 1:
		if (!GameSystem_CheckFieldProcExists(fsys)) {
			mcw->subseq = 0;
			return TRUE;
		}
		break;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL Sub_UgFadeIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);

	switch (mcw->subseq) {
	case 0:
		GameSystem_CreateFieldProc(fsys);
		(mcw->subseq) ++;
		break;
	case 1:
		if (FieldEvent_Cmd_WaitMapProcStart(fsys)) {
			mcw->subseq = 0;
			return TRUE;
		}
		break;
	}
	return FALSE;
}

////////////////////////////////////////////////////

typedef struct {
	GF_BGL_BMPWIN	win;//BMP
	u8 cur_pos;
	int grid_val[2];	// 0=xA1=Z
	FIELDSYS_WORK * fsys;
	BMPCURSOR *Cursor;
}JUMP_CONT;

static void DrawJumpCont(JUMP_CONT *work)
{
	u16 buff[10];
	
	GF_BGL_BmpWinDataFill( &work->win, 0x0f );
	
	BMPCURSOR_Print( work->Cursor, &work->win, 0, work->cur_pos*16 );
	
	PM_NumMsgSetUnsigned(buff, work->grid_val[0], NUM_MODE_ZERO, 2);
	GF_MSG_Print( &work->win, FONT_SYSTEM, buff, 2*8, 0, MSG_ALLPUT, NULL );
	PM_NumMsgSetUnsigned(buff, work->grid_val[1], NUM_MODE_ZERO, 2);
	GF_MSG_Print( &work->win, FONT_SYSTEM, buff, 2*8, 16, MSG_ALLPUT, NULL );
	
	GF_BGL_BmpWinOn( &work->win );
}

static BOOL GMEVENT_JumpMap(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
		
	switch (mcw->seq) {
	case 0:
		if(Sub_UgFadeOut(event)){		// vbNChange
			(mcw->seq) ++;
		}
		break;
	case 1:
		EventCmd_MapChange(event, mcw->next_zone_id, mcw->next_door_id,
				mcw->next_x, mcw->next_z, DIR_DOWN);

		(mcw->seq) ++;
		break;
	case 2:
		if(Sub_UgFadeIn(event)){		// vbNChange
			(mcw->seq) ++;
		}
		break;
	case 3:
		///PlaceNameRequest(fsys->place_name_cont,0);//n\
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

static BOOL GMEVENT_JumpMapForUG(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
		
	switch (mcw->seq) {
	case 0:
		UnderGround_RadarEnd(fsys->UnderGroundRadar);
        CommStateJumpUnderGround();   // ړꍇ̒ʐM֘A
		(mcw->seq) ++;
		break;
	case 1:
		if (fsys->UnderGroundRadar == NULL){
			(mcw->seq) ++;
		}
		break;
	case 2:
		if(Sub_UgFadeOut(event)){		// vbNChange
			(mcw->seq) ++;
		}
		break;
	case 3:	
		EventCmd_MapChange(event, mcw->next_zone_id, mcw->next_door_id,
				mcw->next_x, mcw->next_z, DIR_DOWN);

		(mcw->seq) ++;
		break;
	case 4:
		if(Sub_UgFadeIn(event)){		// vbNChange
			(mcw->seq) ++;
		}
		break;
	case 5:
        CommStateJumpEndUnderGround(); // ړIꍇ̒ʐM֘A
		fsys->UnderGroundRadar = UnderGround_RadarInit(fsys);		//Yz[_[ʂnm
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//WvRg[
static void DebugJumpControlTask(TCB_PTR tcb,void* work)
{
	JUMP_CONT	*wp;
	BOOL write;
	
	wp = (JUMP_CONT*)work;

	write = FALSE;
	//L[씻
	if ( (sys.trg & PAD_KEY_DOWN) ||
			(sys.trg & PAD_KEY_UP) ){
		//J[\
		//J[\ړ
		wp->cur_pos = (wp->cur_pos+1)%2;
		//J[\`
		write = TRUE;
	}else if(sys.trg & PAD_KEY_LEFT){
		//l炷
		if (wp->grid_val[wp->cur_pos]-1<0){
			wp->grid_val[wp->cur_pos] = 29;
		}else{
			wp->grid_val[wp->cur_pos]--;
		}
		write = TRUE;
	}else if(sys.trg & PAD_KEY_RIGHT){
		//l𑝂₷
		wp->grid_val[wp->cur_pos] = (wp->grid_val[wp->cur_pos]+1)%30;
		write = TRUE;
	}

	if (write){
		DrawJumpCont(wp);
	}


	if(sys.trg & PAD_BUTTON_A){
		//Wv
		EVENT_UGCHG_WORK * mcw;

		//Cxg
		mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_UGCHG_WORK));
		mcw->seq = 0;
		mcw->subseq = 0;

		{
			int x,z;
			x = wp->grid_val[0];
			z = wp->grid_val[1];
			
			mcw->next_door_id = DOOR_ID_JUMP_CODE;
			mcw->next_x = x*32+16;
			mcw->next_z = z*32+16;
			//mcw->next_dir = DIR_DOWN;
		
			if (wp->fsys->location->zone_id == ZONE_ID_UG){//n
				mcw->next_zone_id = ZONE_ID_UG;
				///FieldEvent_Set(wp->fsys, GMEVENT_JumpMapForUG, mcw);
				JumpUnderGroundDirect(wp->fsys,x,z);
			}else{											//n
				mcw->next_zone_id = GetZoneIDFromMatrixID(	wp->fsys->World,
															MATRIX_ID_SINOU,
															wp->grid_val[0],
															wp->grid_val[1],
															30);
				FieldEvent_Set(wp->fsys, GMEVENT_JumpMap, mcw);
			}
		}
		GF_BGL_BmpWinOff( &wp->win );
		GF_BGL_BmpWinDel( &wp->win );
		//[NJ
		BMPCURSOR_Delete(  wp->Cursor );
		sys_FreeMemoryEz(work);
		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
		return;
	}
	//j[LZ
	if(sys.trg & PAD_BUTTON_B){
		GF_BGL_BmpWinOff( &wp->win );
		GF_BGL_BmpWinDel( &wp->win );
		//[NJ
		BMPCURSOR_Delete(  wp->Cursor );
		sys_FreeMemoryEz(work);
		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
		return;
	}
}

void DBGSAI_JumpMapControl(struct _FIELDSYS_WORK * fsys)
{
	JUMP_CONT *d_work;

	//nȊO͖
	if ( (ZoneData_GetMatrixID(fsys->location->zone_id) != MATRIX_ID_FIELD)&&
			(ZoneData_GetMatrixID(fsys->location->zone_id) != MATRIX_ID_UNDER_GROUND) ){
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
		return;
	}

	d_work = sys_AllocMemory(HEAPID_FIELD,sizeof(JUMP_CONT));
	d_work->fsys = fsys;
	//J[\
	d_work->cur_pos = 0;
	d_work->Cursor = BMPCURSOR_Create(HEAPID_FIELD);
	//݃ubN擾
	d_work->grid_val[0] = Player_NowGPosXGet( fsys->player ) / 32;
	d_work->grid_val[1] = Player_NowGPosZGet( fsys->player ) / 32;
	//C^XNǉ
	TCB_Add(DebugJumpControlTask,d_work,0);

	GF_BGL_BmpWinAdd( fsys->bgl,&d_work->win,GF_BGL_FRAME3_M, 0, 0, 6, 4, 1, 1 );
	
	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 16<<1, HEAPID_FIELD );
	//݃ubNAJ[\\
	DrawJumpCont(d_work);

	return;
}
//////////////////////////////////////////////////////////////////////////////////////////////////
#define ATTR_DISP_W_NUM	(3)
#define ATTR_DISP_H_NUM	(3)
#define ATTR_ONE_DISP_SIZE (5)
typedef struct {
	GF_BGL_BMPWIN	win;//BMP
	GF_BGL_BMPWIN	win2;//BMP
	FIELDSYS_WORK * fsys;
}ATTR_CONT;

//Agr[g\
static void DispAttrInfo(ATTR_CONT *work)
{	
	GF_BGL_BmpWinDataFill( &work->win, 0x0f );
	GF_BGL_BmpWinDataFill( &work->win2, 0x0f );
	
	//@̈ʒũAgr[g\
	{
		int grid_x,grid_z,height;
		int base_x,base_z;
		int x,z;
		u8 i,j;
		u8 disp_ofs_x;
		BOOL rc;
		u8 attr;
		u16 buff[10];
		u16 batu[2] = {X__,EOM_};
		u16 maru[2] = {O__,EOM_};

		//@ObhW擾
		grid_x = Player_NowGPosXGet( work->fsys->player );
		grid_z = Player_NowGPosZGet( work->fsys->player );
		{
			VecFx32 vec;
			Player_VecPosGet( work->fsys->player, &vec );
			height = vec.y/(FX32_ONE*16);
		}

		base_x = grid_x-1;
		base_z = grid_z-1;
		
		for (i=0;i<3;i++){
			z = base_z+i;
			for(j=0;j<3;j++){
				disp_ofs_x = ATTR_ONE_DISP_SIZE*j*8;
				x = base_x+j;
				//Agr[g擾
				rc = GetHitAttr(work->fsys, x, z);
				if (rc){
					GF_MSG_Print( &work->win, FONT_SYSTEM, batu, disp_ofs_x, i*16, MSG_ALLPUT, NULL );
				}else{
					GF_MSG_Print( &work->win, FONT_SYSTEM, maru, disp_ofs_x, i*16, MSG_ALLPUT, NULL );
				}
				attr = GetAttributeLSB(work->fsys, x, z);
				PM_HexNumMsgSet(buff, attr, NUM_MODE_ZERO, 2);
				GF_MSG_Print( &work->win, FONT_SYSTEM, buff, disp_ofs_x+2*8, i*16, MSG_ALLPUT, NULL );
			}
		}
		//@ObhAubNWAubN[JWvZ
		{
			int block_x,block_z;
			u8 local_x,local_z;
			u8 ofs = 6*8;
			u8 item_ofs = 3*8;
			u16 block_str[6] = {B__,L__,O__,C__,K__,EOM_};
			u16 local_str[6] = {L__,O__,C__,A__,L__,EOM_};
			u16 height_str[6] = {H__,E__,I__,G__,T__,EOM_};
			block_x = grid_x/32;
			block_z = grid_z/32;
			local_x = grid_x%32;
			local_z = grid_z%32;
			
			GF_MSG_Print( &work->win2, FONT_SYSTEM, block_str, 0, 0, MSG_ALLPUT, NULL );
			GF_MSG_Print( &work->win2, FONT_SYSTEM, local_str, 0, 16, MSG_ALLPUT, NULL );
			GF_MSG_Print( &work->win2, FONT_SYSTEM, height_str, 0, 32, MSG_ALLPUT, NULL );
			
			PM_NumMsgSet(buff, block_x, NUM_MODE_ZERO, 2);
			GF_MSG_Print( &work->win2, FONT_SYSTEM, buff, ofs+0, 0, MSG_ALLPUT, NULL );
			PM_NumMsgSet(buff, block_z, NUM_MODE_ZERO, 2);
			GF_MSG_Print( &work->win2, FONT_SYSTEM, buff, ofs+item_ofs, 0, MSG_ALLPUT, NULL );
			PM_NumMsgSet(buff, local_x, NUM_MODE_ZERO, 2);
			GF_MSG_Print( &work->win2, FONT_SYSTEM, buff, ofs+0, 16, MSG_ALLPUT, NULL );
			PM_NumMsgSet(buff, local_z, NUM_MODE_ZERO, 2);
			GF_MSG_Print( &work->win2, FONT_SYSTEM, buff, ofs+item_ofs, 16, MSG_ALLPUT, NULL );
			PM_NumMsgSet(buff, height, NUM_MODE_ZERO, 2);
			GF_MSG_Print( &work->win2, FONT_SYSTEM, buff, ofs+0, 32, MSG_ALLPUT, NULL );
		}
		
	}
	
	GF_BGL_BmpWinOn( &work->win );
	GF_BGL_BmpWinOn( &work->win2 );
}

//Agr[gmFRg[
static void DebugCheckAttrControlTask(TCB_PTR tcb,void* work)
{
	ATTR_CONT	*wp;
	wp = (ATTR_CONT*)work;
	//j[LZ
	if(sys.trg & PAD_BUTTON_B){
		GF_BGL_BmpWinOff( &wp->win );
		GF_BGL_BmpWinDel( &wp->win );
		GF_BGL_BmpWinOff( &wp->win2 );
		GF_BGL_BmpWinDel( &wp->win2 );
		//[NJ
		sys_FreeMemoryEz(work);
		//^XN
		TCB_Delete(tcb);
		//OBJ̓~
		FieldSystemProc_SeqHoldEnd();
		return;
	}
}

//Agr[gmF
void DBGSAI_CheckAttribute(struct _FIELDSYS_WORK * fsys)
{
	ATTR_CONT *d_work;
	int size_w,size_h;
	d_work = sys_AllocMemory(HEAPID_FIELD,sizeof(ATTR_CONT));
	d_work->fsys = fsys;
	
	size_w = ATTR_ONE_DISP_SIZE*ATTR_DISP_W_NUM;
	size_h =  2*ATTR_DISP_H_NUM;
	
	GF_BGL_BmpWinAdd( fsys->bgl,&d_work->win,GF_BGL_FRAME3_M, 0, 0,
			size_w,size_h, 1, 1 );

	GF_BGL_BmpWinAdd( fsys->bgl,&d_work->win2,GF_BGL_FRAME3_M, 0, 18,
			6+3*2, 3*2, 1, 1+size_w*size_h );
	
	SystemFontPaletteLoad( PALTYPE_MAIN_BG, 16<<1, HEAPID_FIELD );
	//C^XNǉ
	TCB_Add(DebugCheckAttrControlTask,d_work,0);
	//\
	DispAttrInfo(d_work);
}

extern u8 HC_DebugCheckHeight(const fx32 inX, const fx32 inZ, MHI_CONST_PTR inMap3DInfo, const BOOL inDetail);
static BOOL DebugCheckHeightGridIn(	struct _FIELDSYS_WORK * fsys,
									const int inGridX,
									const int inGridZ,
									const BOOL inRoop,
									const BOOL inDetail)
{
	u8 idx;
	u8 rc;
	int i,j;
	fx32 base_x,x,base_z,z;
	MHI_CONST_PTR  height_info;
	fx32 x_ofs,z_ofs;
	int count;
	BOOL block_result;
	int non_height_count;
	
	//Obhfx32
	base_x = inGridX*16*FX32_ONE;
	base_z = inGridZ*16*FX32_ONE;

	idx = GetNowLocalIndex(fsys->map_cont_dat);
	height_info = GetDivMapHeightInfo(fsys->map_cont_dat,idx);
	
	{
		//ubNItZbgZ
		x_ofs = (((inGridX/32)*BLOCK_GRID_W)+(BLOCK_GRID_W/2))*16*FX32_ONE;
		z_ofs = (((inGridZ/32)*BLOCK_GRID_H)+(BLOCK_GRID_H/2))*16*FX32_ONE;
		base_x -= x_ofs;
		base_z -= z_ofs;
	}

	count = 0;
	block_result = FALSE;
	non_height_count = 0;
	for(i=0;i<16;i++){
		x = base_x+(i*FX32_ONE);
		for(j=0;j<16;j++){
			z = base_z+(j*FX32_ONE);
			rc = HC_DebugCheckHeight(x, z, height_info, inDetail);
			if (rc==1){
				if (inRoop == FALSE){
					//return TRUE;
					block_result = TRUE;
				}else{
					OS_Printf("jbgW%d,%d͕̍Ă܂\n",i,j);
					count++;
				}
			}else if(rc==2){
				if (inRoop == FALSE){
					if (block_result != TRUE){
						//return FALSE;
						block_result = FALSE;
					}
				}else{
					OS_Printf("jbgW%d,%d͓𕡐Ă܂\n",i,j);
				}

			}else if(rc==3){
				non_height_count++;
				if (inRoop == FALSE){
					if (block_result != TRUE){
						//return FALSE;
						block_result = FALSE;
					}
				}else{
					OS_Printf("jbgW%d,%d͍Ă܂\n",i,j);
				}
			}
		}
	}
	if (inRoop == FALSE){
		if (non_height_count!=256){//PObhSčƂȊO
			OS_Printf("Obhɍ̂Ȃꏊ܂\n");
		}
		return block_result;
	}

	if (inDetail){
		OS_Printf("Obhɂ́A̍jbg%dӏ݂܂\n",count);
	}
	
	if (count>0){
		return TRUE;
	}else{
		return FALSE;
	}
}

static void DebugCheckHeightGrid(TCB_PTR tcb,void *work)
{
	DEBUG_WINDOW_DATA *wp = (DEBUG_WINDOW_DATA *)work;
	//fobO
	{
		u8 idx;
		int i,j;
		int grid_x,grid_z;
		VecFx32 base,vec;
		fx32 x_ofs,z_ofs;
		MHI_CONST_PTR  height_info;
		BOOL rc;
		
		Player_VecPosGet(wp->fsys->player, &base);

		//_
		base.x-=(8*FX32_ONE);
		base.z-=(8*FX32_ONE);

		grid_x = Player_NowGPosXGet( wp->fsys->player );
		grid_z = Player_NowGPosZGet( wp->fsys->player );
		{
			int local_x,local_z;
			local_x = grid_x%32;
			local_z = grid_z%32;

			OS_Printf("\n//ubNObhW%d,%d̍`FbN\n",local_x,local_z);
		}

		DebugCheckHeightGridIn(wp->fsys,
				grid_x,
				grid_z,
				TRUE, TRUE);
		
	}
	DebugWindowExit(tcb,work);
}

static void DebugCheckHeightBlock(TCB_PTR tcb,void *work)
{
	DEBUG_WINDOW_DATA *wp = (DEBUG_WINDOW_DATA *)work;
	//fobO
	{
		int i,j;
		int block_x,block_z;
		int base_grid_x,base_grid_z;
		BOOL rc;
		int count;
		block_x = Player_NowGPosXGet( wp->fsys->player )/BLOCK_GRID_W;
		block_z = Player_NowGPosZGet( wp->fsys->player )/BLOCK_GRID_H;

		OS_Printf("\n//ubN%d,%d̍`FbN\n",block_x,block_z);

		count = 0;
		for(i=0;i<32;i++){
			base_grid_x = block_x*32+i;
			for(j=0;j<32;j++){
				base_grid_z = block_z*32+j;
				rc = DebugCheckHeightGridIn(wp->fsys, base_grid_x, base_grid_z, FALSE, FALSE);
				if (rc){
					OS_Printf("Qwȏ̃ObhF%d,%d\n",i,j);
					count++;
				}
			}
		}
		OS_Printf("Qwȏ̍Obh%d\n",count);
	}

	DebugWindowExit(tcb,work);
}

void SetSwayGrass(TCB_PTR tcb,void *work)
{
	DEBUG_WORK_DATA *d_work;
	
	DEBUG_WINDOW_DATA *wp;
	wp = (DEBUG_WINDOW_DATA *)work;

	//hꑐZbg
	SwayGrass_Setup(wp->fsys);
	
	DebugWindowExit(tcb,work);
}
