//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		effect_uground.c
 *@brief	n}bvtF[hGJEg
 *@author	tomoya takahashi 
 *@data		2005.08.03
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define CLACT_OLD_NONE
#include "common.h"
#include "system/lib_pack.h"
#include "system/brightness.h"
#include "field_event.h"
#include "system/palanm.h"
#include "system/mystatus.h"


#include "system/clact_util.h"
#include "system/render_oam.h"

#include "player.h"


#define __EFFECT_UGROUND_H_GLOBAL
#include "effect_uground.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------
#define UNDER_TCB_PRI	(5)


////////////////////////////////////////////////////////////
//
//	`VXep
//
///////////////////////////////////////////////////////////
#define DRAW_2D_RES_NUM		(4)		// Ǘ郊\[X̎
#define DRAW_2D_OBJ_TBL_NUM	(2)		// ǗIuWFe[u


//-------------------------------------
//	
//	֐߂l
//	
//=====================================
enum{
	EFCT_SYSRET_END,		// G[R[h
	EFCT_SYSRET_OK,			// 
	EFCT_SYSRET_FADE,		// tF[hJn
} EFCT_UG_SYSRET;


//-------------------------------------
//	
//	Ŝɋ
//	
//=====================================
#define EFECT_UGCOMMON_OBJ_MAT_X	(112*FX32_ONE)
#define EFECT_UGCOMMON_OBJ_MAT_Y	(69*FX32_ONE)


//-------------------------------------
//	
//	^XNOO
//	n}bvւ̃tF[hP
//	
//=====================================
enum{
	EFCT_UG00_PLAYER_OFF,	// vC[
	EFCT_UG00_START,		// Jn
	EFCT_UG00_OBJ_MOVE,		// IuWFNgړ
	EFCT_UG00_FADE_WAIT,	// ubNtF[h҂
	EFCT_UG00_OAMCLEAN,		// OAMCLEAN
	EFCT_UG00_DELETE,		// j
};
#define EFCT_UG00_SHADOW_COUNT	(15)		// ɂȂI
#define EFCT_UG00_OBJ_JUMP_DIS	(16*FX32_ONE)	// Wv
#define	EFCT_UG00_OBJ_CNNUM		(0x8000/16)	// JE^l
#define EFCT_UG00_OBJ_END		(0x8000)	// JE^I
#define EFCT_UG00_FADE_START	(EFCT_UG00_OBJ_CNNUM*10)	// tF[hJn

//-------------------------------------
//	
//	^XNOP
//	n}bvւ̃tF[hQ
//	
//=====================================
enum{
	EFCT_UG01_START,		// Jn
	EFCT_UG01_OBJ_MOVE,		// IuWFNgړ
	EFCT_UG01_BG_FADE,		// BGtF[hC
	EFCT_UG01_OAMCLEAN,		// OAMCLEAN
	EFCT_UG01_DELETE,		// j
};
#define EFCT_UG01_END	(EFECT_UGCOMMON_OBJ_MAT_Y)			// IuWF̍ɂȂIuWF̈ړI
#define EFCT_UG01_REST	(384*FX32_ONE)			// IuWF̍ɂȂIuWF̈ړI
#define EFCT_UG01_MOVE	(FX32_ONE*8)			// ړXs[h
#define EFCT_UG01_BG	(16)						// BGʂ𓮂Xs[h
#define EFCT_UG01_OBJ_MAT_Y	(192*FX32_ONE)		// IuWFNgJnʒu
#define EFCT_UG01_OBJ_MAT_REST_Y	(-32*FX32_ONE)	// IuWFNgJnʒu

//-------------------------------------
//	
//	^XNOQ
//	n}bvւ̃tF[hR
//	
//=====================================
enum{
	EFCT_UG02_PLAYER_OFF,	// vC[
	EFCT_UG02_START,		// Jn
	EFCT_UG02_BG_FADE,		// BGtF[hC
	EFCT_UG02_OBJ_MOVE,		// IuWFNgړ
	EFCT_UG02_FADE_WAIT,	// tF[hAEg
	EFCT_UG02_OAMCLEAN,		// OAM
	EFCT_UG02_DELETE,		// j
};
#define EFCT_UG02_REST	(-32*FX32_ONE)			// IuWF̍ɂȂIuWF̈ړI
#define EFCT_UG02_END	(192*FX32_ONE)			// IuWF̍ɂȂIuWF̈ړI
#define EFCT_UG02_MOVE	(FX32_ONE*8)			// ړXs[h
#define EFCT_UG02_BG	(32)					// BGʂ𓮂Xs[h
#define EFCT_UG02_FADE_S	(300*FX32_ONE)		// zCgAEg͂߂^C~O
#define EFCT_UG02_ROTA_SA	(FX32_CONST(0.20f))	// ]x
#define EFCT_UG02_ROTA_SE	(2*FX32_ONE)		// ]ő

#define EFCT_UG02_OBJ_MAT_REST_Y (384*FX32_ONE)		// IuWFNgJnʒu

//-------------------------------------
//	
//	^XNOR
//	n}bvւ̃tF[hS
//	
//=====================================
enum{
	EFCT_UG03_START,		// Jn
	EFCT_UG03_FADEIN_M,		// CʃtF[hC
	EFCT_UG03_FADEIN_MW,	// tF[hC҂
	EFCT_UG03_OBJ_MOVE,		// IuWFNg
	EFCT_UG03_FADEIN_S,		// TuʃtF[hC
	EFCT_UG03_FADEIN_SW,	// TuʃtF[hC҂
	EFCT_UG03_OAMCLEAN,		// OAMCLEAN
	EFCT_UG03_DELETE,		// j
};

#define EFCT_UG03_ROTA_S	(2*FX32_ONE)		// ]
#define EFCT_UG03_ROTA_SA	(FX32_CONST(0.40f))	// ]x
#define EFCT_UG03_ROTA_SE	(0)					// ]ő
#define EFCT_UG03_SHADOW_COUNT	(16)		// ɂȂI
#define EFCT_UG03_OBJ_JUMP_DIS	(32*FX32_ONE)	// Wv
#define	EFCT_UG03_OBJ_CNNUM		(0x8000/8)	// JE^l
#define EFCT_UG03_OBJ_END		(0x8000)	// JE^I
#define EFCT_UG03_FADE_START	(EFCT_UG00_OBJ_CNNUM*10)	// tF[hJn
//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	`VXef[^
//	
//=====================================
typedef struct {
	/* QVXef[^  */
	CLACT_SET_PTR			clactSet;						// ZAN^[Zbg
	CLACT_HEADER_TBL_PTR	clactHeader;					// wb_[
	CLACT_U_RES_MANAGER_PTR	resMan[DRAW_2D_RES_NUM];		// \[X}l[W
	CLACT_U_RES_OBJ_TBL*	resObjTbl[DRAW_2D_OBJ_TBL_NUM];	// \[XIuWFe[u
	int						resObjNum[DRAW_2D_RES_NUM];		// ꂼ̃\[XIuWF
	CLACT_U_EASYRENDER_DATA	renddata;						// ȈՃ_[f[^
	

	/* 3dVXef[^i͂Ȃj */

} EFCT_UG_DRAWSYS;

//-------------------------------------
//	
//	n}bvtF[hGtFNg
//	IuWFNg\
//	
//=====================================
typedef struct _EFCT_UG_OBJ{
	void*		data;		// ̃TCYɊef[^
	
	/* f[^쐬֐ */
	void (*init)(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data);

	/* f[^j֐ */
	void (*delete)(struct _EFCT_UG_OBJ* data);
	
	/* ֐ */
	int (*move)(struct _EFCT_UG_OBJ* data);
} EFCT_UG_OBJ;


//-------------------------------------
//	
//	n}bvtF[hGtFNg\
//	
//=====================================
typedef struct _EFCT_UG_DATA{
	/* tB[hVXe[N */
	FIELDSYS_WORK* fsys;

	/* `VXef[^ */
	EFCT_UG_DRAWSYS	drawsys;
	
	/* IuWFNgf[^ */
	EFCT_UG_OBJ	objdata[2];
	int			obj_num;	// IuWFNg
	
	/* V[PXf[^ */
	int			seq;

	/* tF[hȂǂ̏Im̈ */
	int			wait;
	
	BOOL*	end;
} EFCT_UG_DATA;


//-----------------------------------------------------------------------------
//
//		X̃IuWFNgp
//
//=============================================================================
//-------------------------------------
//	
//	lIuWFNg
//	
//=====================================
typedef struct {
	VecFx32			matrix;		// W
	CLACT_WORK_PTR	cl;			// ZAN^[
	int				count;		// JE^
} EFCT_UG_HERO;

typedef struct {
	VecFx32			matrix;		// W
	CLACT_WORK_PTR	cl;			// ZAN^[
	int				seq;		// V[PX
	int				count;		// JE^
} EFCT_UG_HERO_EX;

//-------------------------------------
//	
//	eIuWFNg
//	
//=====================================
typedef struct {
	VecFx32			matrix;		// W
	CLACT_WORK_PTR	cl;			// ZAN^[
	int				count;		// JE^
} EFCT_UG_SHADOW;

//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static void UGround00(TCB_PTR tcb, void* work);		// n}bvtF[h00	nʂɂĂ
static void UGround01(TCB_PTR tcb, void* work);		// n}bvtF[h01	nɍ~
static void UGround02(TCB_PTR tcb, void* work);		// n}bvtF[h02	n
static void UGround03(TCB_PTR tcb, void* work);		// n}bvtF[h03	nɏo

static EFCT_UG_DATA* UGroundAdd(TCB_FUNC func, FIELDSYS_WORK* fsys);
static void UGroundDelete(TCB_PTR tcb, EFCT_UG_DATA* data);
static void initDrawSys(EFCT_UG_DRAWSYS* data, int boy_girl);		// `VXe̍쐬
static void deleteDrawSys(EFCT_UG_DRAWSYS* data);		// `VXe̔j
static void makeObj(EFCT_UG_DATA* data, EFCT_UG_OBJ* obj, int num);	// IuWFNgf[^̍쐬
static CLACT_WORK_PTR addCellAct(EFCT_UG_DRAWSYS* drawsys, int act_no, VecFx32* mat,int pri, int drawarea);
static void deleteObj(EFCT_UG_OBJ* obj);// IuWFNgf[^̔j
static void initBG(GF_BGL_INI* bgl);	// BGʂ̏
static void destBG(GF_BGL_INI* bgl);		// BGʂ̏
static void loadBG(GF_BGL_INI* bgl, const char* p_char, const char* p_pltt,const char* p_screen, int pltt_no, int frame, int charoffs);

//static void maskBGScrollInit(int sc_mask, int other_mask);
//static void maskBGScroll(GF_BGL_INI* bgl,int plane_mask, int h, int v);
//static void maskBGScrollDelete(void);

/////////////////////////////////////////////////////////////////////
//
//		Q\VXep֐S
//
////////////////////////////////////////////////////////////////////
static void init2DDrawSys(EFCT_UG_DRAWSYS* data);	// Q̕`VXe
static void load2DResFile(EFCT_UG_DRAWSYS* data, int boy_girl);	// Q\[Xǂݍ
static int loadOneData(CLACT_U_RES_MANAGER_PTR resMan, CLACT_U_RES_OBJ_TBL** resObjTbl, const char* path);

static void delete2DDrawSys(EFCT_UG_DRAWSYS* data);	// Q̕`VXe
//---------------------------------------------------------
//
//	X̃IuWFNgp
//
//=========================================================
//---------ntF[hWvl
static void initObj00(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data);
static void deleteObj00(struct _EFCT_UG_OBJ* data);
static int  moveObj00(struct _EFCT_UG_OBJ* data);
//---------ntF[hLe
static void initObj01(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data);
static void deleteObj01(struct _EFCT_UG_OBJ* data);
static int  moveObj01(struct _EFCT_UG_OBJ* data);
//---------ntF[hl
static void initObj02(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data);
static void deleteObj02(struct _EFCT_UG_OBJ* data);
static int  moveObj02(struct _EFCT_UG_OBJ* data);
//---------ntF[hl
static void initObj03(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data);
static void deleteObj03(struct _EFCT_UG_OBJ* data);
static int  moveObj03(struct _EFCT_UG_OBJ* data);
//---------ntF[hnɏoĂl
static void initObj04(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data);
static void deleteObj04(struct _EFCT_UG_OBJ* data);
static int  moveObj04(struct _EFCT_UG_OBJ* data);
//---------ntF[hkމe
static void initObj05(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data);
static void deleteObj05(struct _EFCT_UG_OBJ* data);
static int  moveObj05(struct _EFCT_UG_OBJ* data);


// jLN^@CLACT@f[^pX
const static char* BoyGirlCharPathTbl[ 2 ] = {
	"data/uground_char.resdat",
	"data/uground_char2.resdat",
};

const static char* BoyGirlPlttPathTbl[ 2 ] = {
	"data/uground_pltt.resdat",
	"data/uground_pltt2.resdat",
};




//----------------------------------------------------------------------------
/**
 *
 *@brief	n}bvtF[h00
 *
 *@param	tcb		^XNf[^
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void UGround00(TCB_PTR tcb, void* work)
{
	EFCT_UG_DATA* data = (EFCT_UG_DATA*)work;
	int ret[2];		// QIuWFp߂l
	int i;			// [vp
	int last_seq;

	last_seq = data->seq; 

	if(data->drawsys.clactSet){
		// ZAN^[C֐
		CLACT_Draw(data->drawsys.clactSet);
	}

	switch(data->seq){
	case EFCT_UG00_PLAYER_OFF:
		// vC[
		Player_DispON_OFF_Set( data->fsys->player, FALSE );
		data->seq++;
		break;

	case EFCT_UG00_START:
		//
		makeObj(data, &data->objdata[0], 0);		// l쐬
		makeObj(data, &data->objdata[1], 1);		// e쐬
		data->obj_num = 2;
		data->seq++;
		break;

	case EFCT_UG00_OBJ_MOVE:		// IuWFNg𓮍삳
		for(i=0;i<data->obj_num;i++){
			ret[i] = data->objdata[i].move(&data->objdata[i]);
		}
		// ubNtF[hJnm
		if(ret[0] == EFCT_SYSRET_FADE){
			ChangeBrightnessRequest(30,-16,0,PLANEMASK_BG0|PLANEMASK_BG1|PLANEMASK_BG2|PLANEMASK_BG3|PLANEMASK_OBJ|PLANEMASK_BD,MASK_DOUBLE_DISPLAY);
		}

		// Im
		for(i=0;i<data->obj_num;i++){
			if(ret[i] != EFCT_SYSRET_END ){
				break;
			}
		}
		if(i == data->obj_num){
			data->seq++;		// 
		}
		break;

	case EFCT_UG00_FADE_WAIT:	// tF[h҂
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			data->seq++;
		}
		break;

	case EFCT_UG00_OAMCLEAN:
		for(i=0;i<data->obj_num;i++){
			deleteObj(&data->objdata[i]);
		}
		data->seq++;
		break;

	case EFCT_UG00_DELETE:
		*(data->end) = TRUE;
		
		// {VXej
		UGroundDelete(tcb, data);
		break;
	}

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	n}bvtF[h01
 *
 *@param	tcb		^XNf[^
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void UGround01(TCB_PTR tcb, void* work)
{
	EFCT_UG_DATA* data = (EFCT_UG_DATA*)work;
	int ret;
	int last_seq;
	u16 clearPal=0;

	last_seq = data->seq; 

	if(last_seq != EFCT_UG01_DELETE){
		// ZAN^[C֐
		CLACT_Draw(data->drawsys.clactSet);
	}

	switch(data->seq){
	case EFCT_UG01_START:
		//maskBGScrollInit(GX_WND_PLANEMASK_BG2, GX_WND_PLANEMASK_BG3);
//		maskBGScrollInit(GX_WND_PLANEMASK_BG0|GX_WND_PLANEMASK_OBJ, GX_WND_PLANEMASK_BG1|GX_WND_PLANEMASK_OBJ);
//		maskBGScroll(data->fsys->bgl, GF_BGL_FRAME0_S, -255, 0);
		// vC[
		Player_DispON_OFF_Set( data->fsys->player, FALSE );
		
		GF_BGL_PaletteSet( GF_BGL_FRAME0_S, &clearPal, 2, 0 );	// pbgNA
		
		GF_Disp_GXS_VisibleControl(GX_PLANEMASK_BG0, VISIBLE_OFF);		// BG0ʃIt
		GF_Disp_GXS_VisibleControl(GX_PLANEMASK_BG1, VISIBLE_OFF);		// BG1ʃIt
	
		
		// OBĴ݃uCglX	
		makeObj(data, &data->objdata[0], 2);		// l쐬
	
		ChangeBrightnessRequest(32,0,-16,PLANEMASK_BG0|PLANEMASK_BG1|PLANEMASK_BG2|PLANEMASK_BG3|PLANEMASK_OBJ|PLANEMASK_BD,MASK_DOUBLE_DISPLAY);
		
		data->obj_num = 1;
		data->seq++;
		break;
	

	case EFCT_UG01_OBJ_MOVE:		// IuWFNg𓮍삳
		ret = data->objdata[0].move(&data->objdata[0]);

		// Im
		if((ret == EFCT_SYSRET_END) && (IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY))){
			data->seq++;		// 
			data->wait = -255;
		}
		break;
		
	case EFCT_UG01_BG_FADE:
//		maskBGScroll(data->fsys->bgl, GF_BGL_FRAME0_S, data->wait, 0);
		data->wait += EFCT_UG01_BG;
		if(data->wait > 0){
//			maskBGScroll(data->fsys->bgl, GF_BGL_FRAME0_S, 0, 0);
			data->seq++;
			// vC[\
			Player_DispON_OFF_Set( data->fsys->player, TRUE );
		
		}
		break;

	case EFCT_UG01_OAMCLEAN:
		deleteObj(&data->objdata[0]);
		data->seq++;
		break;

	case EFCT_UG01_DELETE:		// IȂ̂Ńf[^j
		*(data->end) = TRUE;
		// {VXej
		UGroundDelete(tcb, data);
//		maskBGScrollDelete();
		break;
	}

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	n}bvtF[h02	nւ̃tF[h
 *
 *@param	tcb		^XNf[^
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void UGround02(TCB_PTR tcb, void* work)
{
	EFCT_UG_DATA* data = (EFCT_UG_DATA*)work;
	int ret;
	int last_seq;

	last_seq = data->seq;

	if(last_seq != EFCT_UG02_DELETE){
		// ZAN^[C֐
		CLACT_Draw(data->drawsys.clactSet);
	}

	switch(data->seq){
	case EFCT_UG02_PLAYER_OFF:
		// vC[
		Player_DispON_OFF_Set( data->fsys->player, FALSE );
		data->seq++;
		break;

	case EFCT_UG02_START:
//		maskBGScrollInit(GX_WND_PLANEMASK_BG0|GX_WND_PLANEMASK_OBJ, GX_WND_PLANEMASK_BG1|GX_WND_PLANEMASK_OBJ);
//		maskBGScroll(data->fsys->bgl, GF_BGL_FRAME0_S, 0, 0);
		
		makeObj(data, &data->objdata[0], 3);		// l쐬
		data->obj_num = 1;
		data->seq++;
		break;

	case EFCT_UG02_BG_FADE:		// BGʃtF[h
//		maskBGScroll(data->fsys->bgl, GF_BGL_FRAME0_S, data->wait, 0);
		data->wait -= EFCT_UG02_BG;
		if(data->wait < -255){
//			maskBGScroll(data->fsys->bgl, GF_BGL_FRAME0_S, 0, 0);
//			maskBGScrollDelete();
			GF_Disp_GXS_VisibleControl(GX_PLANEMASK_BG0, VISIBLE_OFF);

			data->seq++;
		}
		break;

	case EFCT_UG02_OBJ_MOVE:
		ret = data->objdata[0].move(&data->objdata[0]);

		// zCgtF[hJnm
		if(ret == EFCT_SYSRET_FADE){
			data->wait = 0;
			ChangeBrightnessRequest(16,-16,0,PLANEMASK_BG0|PLANEMASK_BG1|PLANEMASK_BG2|PLANEMASK_BG3|PLANEMASK_OBJ|PLANEMASK_BD,MASK_DOUBLE_DISPLAY);
		}
		
		// Im
		if(ret == EFCT_SYSRET_END){
			data->seq++;		// 
		}
		break;

	case EFCT_UG02_FADE_WAIT:		// tF[h҂
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			data->wait = 0;
			data->seq++;
		}
		break;

	case EFCT_UG02_OAMCLEAN:
		deleteObj(&data->objdata[0]);
		data->seq++;
		break;
	
	case EFCT_UG02_DELETE:		// IȂ̂Ńf[^j
		GF_Disp_GXS_VisibleControl(GX_PLANEMASK_BG1, VISIBLE_OFF);

		*(data->end) = TRUE;
		
		// {VXej
		UGroundDelete(tcb, data);
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	n}bvtF[h03
 *
 *@param	tcb		^XNf[^
 *@param	work	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void UGround03(TCB_PTR tcb, void* work)
{
	EFCT_UG_DATA* data = (EFCT_UG_DATA*)work;
	int ret[2];		// QIuWFp߂l
	int i;			// [vp
	int last_seq;

	last_seq = data->seq;

	if(last_seq != EFCT_UG03_DELETE){
		// ZAN^[C֐
		CLACT_Draw(data->drawsys.clactSet);
	}
	
	switch(data->seq){
	case EFCT_UG03_START:
		// vC[
		Player_DispON_OFF_Set( data->fsys->player, FALSE );

		makeObj(data, &data->objdata[0], 4);		// l쐬
		makeObj(data, &data->objdata[1], 5);		// e쐬
		data->obj_num = 2;
		data->seq++;
		break;

	case EFCT_UG03_FADEIN_M:
		ChangeBrightnessRequest(30,0,-16,PLANEMASK_BG0|PLANEMASK_BG1|PLANEMASK_BG2|PLANEMASK_BG3|PLANEMASK_OBJ|PLANEMASK_BD,MASK_DOUBLE_DISPLAY);
		data->seq++;
		break;
		
	case EFCT_UG03_FADEIN_MW:	// TutF[hC҂
		if( IsFinishedBrightnessChg(MASK_DOUBLE_DISPLAY) ){
			data->seq++;
		}
		break;


	case EFCT_UG03_OBJ_MOVE:		// IuWFNg𓮍삳
		for(i=0;i<data->obj_num;i++){
			ret[i] = data->objdata[i].move(&data->objdata[i]);
		}
		// Im
		for(i=0;i<data->obj_num;i++){
			if(ret[i] != EFCT_SYSRET_END ){
				break;
			}
		}
		if(i == data->obj_num){
//			data->seq++;		// 
			data->seq = EFCT_UG03_OAMCLEAN;		// 
			// vC[\
			Player_DispON_OFF_Set( data->fsys->player, TRUE );
		}
		break;

	case EFCT_UG03_FADEIN_S:
		ChangeBrightnessRequest(30,0,-16,PLANEMASK_BG0|PLANEMASK_BG1|PLANEMASK_BG2|PLANEMASK_BG3|PLANEMASK_OBJ|PLANEMASK_BD,MASK_SUB_DISPLAY);
		data->seq++;
		break;
		
	case EFCT_UG03_FADEIN_SW:	// TutF[hC҂
		if( IsFinishedBrightnessChg(MASK_SUB_DISPLAY) ){
			data->seq++;
		}
		break;

	case EFCT_UG03_OAMCLEAN:
		for(i=0;i<data->obj_num;i++){
			deleteObj(&data->objdata[i]);
		}

		data->seq++;
		break;

	case EFCT_UG03_DELETE:		// IȂ̂Ńf[^j
		
		*(data->end) = TRUE;
		// {VXej
		UGroundDelete(tcb, data);
		break;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	n}bvtF[hGtFNg
 *
 *@param	fsys	tB[hVXe[N
 *@param	no		GtFNgio[
 *@param	end		I`FbNtO
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void StartUnderGroundEffect(FIELDSYS_WORK* fsys, int no, BOOL* end)
{
	EFCT_UG_DATA* data;
		
	/* IuWFNg쐬 */
	switch(no){
	case EFCT_UG_DOWN00:
		data = UGroundAdd(UGround00, fsys);
		break;
	case EFCT_UG_DOWN01:
		data = UGroundAdd(UGround01, fsys);
		break;
	case EFCT_UG_UP00:
		data = UGroundAdd(UGround02, fsys);
		break;
	case EFCT_UG_UP01:
		data = UGroundAdd(UGround03, fsys);
		break;
	}

	data->end = end;
	data->fsys = fsys;
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	nGtFNgf[^쐬
 *
 *@param	func	^XN
 *@param	fsys	tB[hVXe
 *
 *@return	EFCT_UG_DATA*	f[^
 *
 *
 */
//-----------------------------------------------------------------------------
EFCT_UG_DATA* UGroundAdd(TCB_FUNC func, FIELDSYS_WORK* fsys)
{
	EFCT_UG_DATA* data;
	TCB_PTR tcb;
	int boy_girl;
	MYSTATUS* status;

		
	/* IuWFNg쐬 */
	tcb = PMDS_taskAdd(func, sizeof(EFCT_UG_DATA), UNDER_TCB_PRI, HEAPID_FIELD);
	data = TCB_GetWork(tcb);

	/* lj擾 */
	status = SaveData_GetMyStatus( fsys->savedata );
	boy_girl = MyStatus_GetMySex( status );
	
	/* `VXe쐬 */
	initDrawSys(&data->drawsys, boy_girl );

	return data;
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	n}bvtF[hf[^j
 *
 *@param	tcb		^XN|C^
 *@param	data	jf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void UGroundDelete(TCB_PTR tcb, EFCT_UG_DATA* data)
{
	// `VXej
	deleteDrawSys(&data->drawsys);

	PMDS_taskDel(tcb);	//^XNI	
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`VXef[^̓ǂݍ
 *
 *@param	data		`VXef[^
 *@param	boy_girl	j
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void initDrawSys(EFCT_UG_DRAWSYS* data, int boy_girl)
{
	// `VXe
	init2DDrawSys(data);

	// \[Xǂݍ
	load2DResFile(data, boy_girl);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	`f[^̔j
 *
 *@param	data		`VXef[^
 *
 *@return	none 
 *
 *
 */
//-----------------------------------------------------------------------------
void deleteDrawSys(EFCT_UG_DRAWSYS* data)
{
	delete2DDrawSys(data);
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	Q`VXe쐬
 *
 *@param	data		`VXef[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void init2DDrawSys(EFCT_UG_DRAWSYS* data)
{
	// ȈՃZAN^[Zbg쐬
	// ō쐬LOAM}l[Wgpă_[쐬A
	// ZAN^[Zbg̍쐬s
	data->clactSet = CLACT_U_SetEasyInit( 2, &data->renddata, HEAPID_FIELD );
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Q\[Xǂݍ
 *
 *@param	data
 *@param	boy_girl	j
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void load2DResFile(EFCT_UG_DRAWSYS* data, int boy_girl)
{
	int i;
	void* buff;
	
	// \[X}l[W쐬
	for(i=0;i<DRAW_2D_RES_NUM;i++){
		data->resMan[i] = CLACT_U_ResManagerInit(2, i, HEAPID_FIELD);
	}

	// \[Xǂݍ
	// LN^
	data->resObjNum[ CLACT_U_CHAR_RES ] = loadOneData(
			data->resMan[ CLACT_U_CHAR_RES ], 
			&data->resObjTbl[ CLACT_U_CHAR_RES ],
			BoyGirlCharPathTbl[ boy_girl ] );
	// pbg
	data->resObjNum[ CLACT_U_PLTT_RES ] = loadOneData(
			data->resMan[ CLACT_U_PLTT_RES ], 
			&data->resObjTbl[ CLACT_U_PLTT_RES ],
			BoyGirlPlttPathTbl[ boy_girl ] );
	// Z
	data->resObjNum[ CLACT_U_CELL_RES ] = loadOneData(
			data->resMan[ CLACT_U_CELL_RES ], 
			NULL,
			"data/uground_cell.resdat");
	// ZAj
	data->resObjNum[ CLACT_U_CELLANM_RES ] = loadOneData(
			data->resMan[ CLACT_U_CELLANM_RES ], 
			NULL,
			"data/uground_cellanm.resdat");

	// ǂݍ݈ʒu
	CharLoadStartAll();
	PlttLoadStartAll();
	
	// LN^}l[Wɓo^
	// Vramɔzu܂B
	CLACT_U_CharManagerSets(data->resObjTbl[0]);

	// pbg}l[Wɓo^
	// Vramɔzu܂B
	CLACT_U_PlttManagerSets(data->resObjTbl[1]);


	// ZAN^[wb_ǂݍ
	buff = sys_LoadFile( HEAPID_FIELD, "data/uground_clact.cldat" );
	data->clactHeader = CLACT_U_MakeHeaderBinary(
			buff, HEAPID_FIELD,
			data->resMan[ CLACT_U_CHAR_RES ], 
			data->resMan[ CLACT_U_PLTT_RES ], 
			data->resMan[ CLACT_U_CELL_RES ],
			data->resMan[ CLACT_U_CELLANM_RES ],
			NULL, NULL);
	sys_FreeMemoryEz( buff );
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X^Cṽ\[Xwb_[f[^ǂݍ
 *
 *@param	resMan		\[X}l[W(쐬ς)
 *@param	resObjTbl	\[XIuWFe[u󂯎
 *@param	path		wb_pX
 *
 *@return	int		e[u
 *
 *
 */
//-----------------------------------------------------------------------------
static int loadOneData(CLACT_U_RES_MANAGER_PTR resMan, CLACT_U_RES_OBJ_TBL** resObjTbl, const char* path)
{
	CLACT_U_RES_HEADER_PTR res_head;		// \[Xwb_
	CLACT_U_RES_OBJ_TBL* work;
	int	tbl_num;							// wb_e[u
	void* buff;
	

	res_head = sys_AllocMemoryLo( HEAPID_FIELD, CLACT_U_ResManagerGetHeaderSize() );

	// wb_ǂݍ
	buff = sys_LoadFile( HEAPID_FIELD, path );
	CLACT_U_ResManagerHeaderLoadBinary(buff, res_head, HEAPID_FIELD);
	sys_FreeMemoryEz( buff );

	// wb_̃\[XIuWFe[u쐬
	if(resObjTbl != NULL){
		tbl_num		= CLACT_U_ResManagerHeaderSetDataNum(res_head);
		*resObjTbl	= CLACT_U_ResManagerResObjTblMake(tbl_num, HEAPID_FIELD);
		work = *resObjTbl;
	}else{
		work = NULL;
	}

	// \[Xǂݍ
	// LN^f[^ǂݍ
	tbl_num = CLACT_U_ResManagerResAddsHd(
				resMan,
				res_head,
				work,
				HEAPID_FIELD);

	// wb_j
	CLACT_U_ResManagerHeaderFree(res_head);

	// wb_Ŋmۂ[Nj
	sys_FreeMemoryEz(res_head);

	return tbl_num;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	QD`VXef[^j
 *
 *@param	data		`VXef[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delete2DDrawSys(EFCT_UG_DRAWSYS* data)
{
	int i;
	
	// Zbg̔j
	CLACT_DestSet(data->clactSet);
	data->clactSet = NULL;
	
	// ZAN^[wb_[j
	CLACT_U_CLACT_HeaderTblDelete(data->clactHeader);
	data->clactHeader = NULL;

	// LN^f[^j
	CLACT_U_CharManagerDeletes( data->resObjTbl[ CLACT_U_CHAR_RES ] );
	
	// pbgf[^j
	CLACT_U_PlttManagerDeletes( data->resObjTbl[ CLACT_U_PLTT_RES ] );

	// LN^ƃpbg̃\[XIuWFe[uj
	for(i=0;i<2;i++){
		CLACT_U_ResManagerResObjTblDelete(data->resObjTbl[i]);
	}

	// \[X}l[Wj
	for(i=0;i< DRAW_2D_RES_NUM;i++){
		CLACT_U_ResManagerDelete(data->resMan[i]);
	}
	
//	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_OFF);
//	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_OFF);
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg̍쐬
 *
 *@param	data	GtFNgf[^
 *@param	obj		f[^͂IuWF
 *@param	num		
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void makeObj(EFCT_UG_DATA* data, EFCT_UG_OBJ* obj, int num)
{
	memset(obj, 0, sizeof(EFCT_UG_OBJ));

	switch(num){
	case 0:
		obj->init	= initObj00;
		obj->delete = deleteObj00;
		obj->move	= moveObj00;
		break;
	case 1:
		obj->init	= initObj01;
		obj->delete = deleteObj01;
		obj->move	= moveObj01;
		break;
	case 2:
		obj->init	= initObj02;
		obj->delete = deleteObj02;
		obj->move	= moveObj02;
		break;
	case 3:
		obj->init	= initObj03;
		obj->delete = deleteObj03;
		obj->move	= moveObj03;
		break;
	case 4:
		obj->init	= initObj04;
		obj->delete = deleteObj04;
		obj->move	= moveObj04;
		break;
	case 5:
		obj->init	= initObj05;
		obj->delete = deleteObj05;
		obj->move	= moveObj05;
		break;
	}

	obj->init(&data->drawsys, obj);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[ɓo^
 *
 *@param	drawsys		`VXe
 *@param	act_no		AN^[io[
 *@param	mat			W
 *@param	pri			\D揇
 *@param	drawarea	`GA(ŏ́j
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_WORK_PTR addCellAct(EFCT_UG_DRAWSYS* drawsys, int act_no, VecFx32* mat, int pri, int drawarea)
{
	CLACT_ADD ca;
	CLACT_WORK_PTR obj;
	VecFx32 sca = {FX32_ONE, FX32_ONE, FX32_ONE};
	
	memset(&ca,0,sizeof(CLACT_ADD));
	ca.ClActSet		= drawsys->clactSet;
	ca.ClActHeader	= &drawsys->clactHeader->tbl[act_no];
	ca.mat			= *mat;
	ca.sca			= sca;
	ca.pri			= pri;
	ca.DrawArea		= drawarea;
	ca.heap			= HEAPID_FIELD;
	
	obj = CLACT_Add(&ca);
	GF_ASSERT(obj&&("ZAN^[o^s\n"));

	return obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg
 *
 *@param	data
 *@param	obj
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
void deleteObj(EFCT_UG_OBJ* obj)
{
	obj->delete( obj);
	memset(obj, 0, sizeof(EFCT_UG_OBJ));
}

//---------------------------------------------------------
//
//	X̃IuWFNgp
//
//=========================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	lIuWFNg̓o^
 *
 *@param	drawsys		`f[^
 *@param	data		IuWFNgf[^o^e[u
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void initObj00(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO* obj_w;
	
	// IuWFNg̍쐬
	data->data = sys_AllocMemory(HEAPID_FIELD, sizeof(EFCT_UG_HERO));
	SDK_ASSERT(data->data);
	memset(data->data, 0, sizeof(EFCT_UG_HERO));
	
	obj_w = (EFCT_UG_HERO*)data->data;
	obj_w->matrix.x = EFECT_UGCOMMON_OBJ_MAT_X;
	obj_w->matrix.y = EFECT_UGCOMMON_OBJ_MAT_Y;
	
	// Z̓o^
	obj_w->cl = addCellAct(drawsys, 0, &obj_w->matrix, 0, 1);
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	lIuWFj
 *
 *@param	data		IuWFf[^
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
void deleteObj00(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO* obj_w = (EFCT_UG_HERO*)data->data;
	
	if(data->data != NULL){
		// ZAN^[폜
		CLACT_Delete(obj_w->cl);

		// IuWFNgj
		sys_FreeMemory(HEAPID_FIELD, data->data);
		data->data = NULL;
	}
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	lIuWFNg̓֐
 *
 *@param	data	lIuWFNg
 *
 *@retval	EFCT_SYSRET_OK		
 *@retval	EFCT_SYSRET_FADE	tF[hJn
 *@retval	EFCT_SYSRET_END		I
 *
 *
 */
//-----------------------------------------------------------------------------
int moveObj00(struct _EFCT_UG_OBJ* data)
{
	VecFx32	mat;	// Z`W
	EFCT_UG_HERO* obj_w = (EFCT_UG_HERO*)data->data;
	
	// Wv
	// t߂ŃtF[hJn
	// nʂɓBI
	if(obj_w->count <= EFCT_UG00_OBJ_END){
		mat = obj_w->matrix;
		mat.y -= FX_Mul(FX_SinIdx(obj_w->count), EFCT_UG00_OBJ_JUMP_DIS);
		CLACT_SetMatrix(obj_w->cl, &mat);		// Wݒ
		obj_w->count += EFCT_UG00_OBJ_CNNUM;
		CLACT_AnmFrameChg(obj_w->cl, FX32_ONE);
	
		if(obj_w->count == EFCT_UG00_FADE_START){	//ŃtF[hJn
			return EFCT_SYSRET_FADE;
		}else{
			return EFCT_SYSRET_OK;
		}
	}
	
	return EFCT_SYSRET_END;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	e쐬
 *
 *@param	drawsys		`f[^
 *@param	data		IuWFf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void initObj01(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_SHADOW* obj_w;
	
	// IuWFNg̍쐬
	data->data = sys_AllocMemory(HEAPID_FIELD, sizeof(EFCT_UG_SHADOW));
	SDK_ASSERT(data->data);
	memset(data->data, 0, sizeof(EFCT_UG_SHADOW));
	
	obj_w = (EFCT_UG_SHADOW*)data->data;
	obj_w->matrix.x = EFECT_UGCOMMON_OBJ_MAT_X;
	obj_w->matrix.y = 96*FX32_ONE;
	
	// Z̓o^
	obj_w->cl = addCellAct(drawsys, 1, &obj_w->matrix,1, 1);
}
void deleteObj01(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_SHADOW* obj_w = (EFCT_UG_SHADOW*)data->data;
	
	if(data->data != NULL){
		// ZAN^[폜
		CLACT_Delete(obj_w->cl);

		// IuWFNgj
		sys_FreeMemory(HEAPID_FIELD, data->data);
		data->data = NULL;
	}
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	e𓮂
 *
 *@param	data
 *
 *@retval	EFCT_SYSRET_OK		
 *@retval	EFCT_SYSRET_FADE	tF[hJn
 *@retval	EFCT_SYSRET_END		I
 *
 *
 */
//-----------------------------------------------------------------------------
int moveObj01(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_SHADOW* obj_w = (EFCT_UG_SHADOW*)data->data;
	
	// e傫āAŌ܂ő傫ȂI
	if(obj_w->count < EFCT_UG00_SHADOW_COUNT){
		CLACT_AnmFrameChg(obj_w->cl, FX32_ONE);
		obj_w->count++;
		return EFCT_SYSRET_OK;	
	}

	return EFCT_SYSRET_END;	
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ĂIuWFNg
 *
 *@param	drawsys		`f[^
 *@param	data		IuWFNgf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void initObj02(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO* obj_w;
	
	// IuWFNg̍쐬
	data->data = sys_AllocMemory(HEAPID_FIELD, sizeof(EFCT_UG_HERO));
	SDK_ASSERT(data->data);
	memset(data->data, 0, sizeof(EFCT_UG_HERO));
	
	obj_w = (EFCT_UG_HERO*)data->data;
	obj_w->matrix.x = EFECT_UGCOMMON_OBJ_MAT_X;
	obj_w->matrix.y = EFCT_UG01_OBJ_MAT_Y;
	
	// Z̓o^
	obj_w->cl = addCellAct(drawsys, 0, &obj_w->matrix, 0, 1);
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFj֐
 *
 *@param	data
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
void deleteObj02(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO* obj_w = (EFCT_UG_HERO*)data->data;
	
	if(data->data != NULL){
		// ZAN^[폜
		CLACT_Delete(obj_w->cl);

		// IuWFNgj
		sys_FreeMemory(HEAPID_FIELD, data->data);
		data->data = NULL;
	}
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg
 *
 *@param	data
 *
 *@retval	EFCT_SYSRET_OK		
 *@retval	EFCT_SYSRET_FADE	tF[hJn
 *@retval	EFCT_SYSRET_END		I
 *
 *
 */
//-----------------------------------------------------------------------------
int  moveObj02(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO* obj_w = (EFCT_UG_HERO*)data->data;
	

	obj_w->matrix.y += EFCT_UG01_MOVE;
	CLACT_SetMatrix(obj_w->cl, &obj_w->matrix);		// Wݒ
	CLACT_AnmFrameChg(obj_w->cl, FX32_ONE);

	if(obj_w->count == 0){
		if(obj_w->matrix.y >= EFCT_UG01_REST){
			obj_w->matrix.y = EFCT_UG01_OBJ_MAT_REST_Y;
			obj_w->count++;
		}
	}else{
		if(obj_w->matrix.y >= EFCT_UG01_END){
			obj_w->matrix.y = EFCT_UG01_END;
			CLACT_SetMatrix(obj_w->cl, &obj_w->matrix);		// Wݒ
			return EFCT_SYSRET_END;
		}
	}
	
	return EFCT_SYSRET_OK;

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg
 *
 *@param	drawsys		`f[^
 *@param	data		IuWFNgf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void initObj03(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO_EX* obj_w;
	
	// IuWFNg̍쐬
	data->data = sys_AllocMemory(HEAPID_FIELD, sizeof(EFCT_UG_HERO_EX));
	SDK_ASSERT(data->data);
	memset(data->data, 0, sizeof(EFCT_UG_HERO_EX));
	
	obj_w = (EFCT_UG_HERO_EX*)data->data;
	obj_w->matrix.x = EFECT_UGCOMMON_OBJ_MAT_X;
	obj_w->matrix.y = EFECT_UGCOMMON_OBJ_MAT_Y;
	
	// Z̓o^
	obj_w->cl = addCellAct(drawsys, 0, &obj_w->matrix, 0, 1);

	//Aj[VSequenceύX
	CLACT_AnmChg(obj_w->cl, 1);
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	j֐
 *
 *@param	data
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void deleteObj03(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO_EX* obj_w = (EFCT_UG_HERO_EX*)data->data;
	
	if(data->data != NULL){
		// ZAN^[폜
		CLACT_Delete(obj_w->cl);

		// IuWFNgj
		sys_FreeMemory(HEAPID_FIELD, data->data);
		data->data = NULL;
	}
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	֐
 *
 *@param	data
 *
 *@retval	EFCT_SYSRET_OK		
 *@retval	EFCT_SYSRET_FADE	tF[hJn
 *@retval	EFCT_SYSRET_END		I
 *
 *
 */
//-----------------------------------------------------------------------------
int  moveObj03(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO_EX* obj_w = (EFCT_UG_HERO_EX*)data->data;
	int	ret	= EFCT_SYSRET_OK;	// ߂l

	switch(obj_w->seq){
	case 0:		// ]𑁂
		obj_w->count += EFCT_UG02_ROTA_SA;
		CLACT_AnmFrameChg(obj_w->cl, obj_w->count);
		
		if(obj_w->count >= EFCT_UG02_ROTA_SE){
			obj_w->seq++;
		}
		break;
	
	case 1:
		if(obj_w->matrix.y > EFCT_UG02_REST){
			obj_w->matrix.y -= EFCT_UG02_MOVE;
			CLACT_SetMatrix(obj_w->cl, &obj_w->matrix);		// Wݒ
			CLACT_AnmFrameChg(obj_w->cl, obj_w->count);
		}else{
			obj_w->matrix.y = EFCT_UG02_OBJ_MAT_REST_Y;
			obj_w->seq++;
		}	
		break;
	
	case 2:
		obj_w->matrix.y -= EFCT_UG02_MOVE;
		CLACT_SetMatrix(obj_w->cl, &obj_w->matrix);		// Wݒ
		CLACT_AnmFrameChg(obj_w->cl, obj_w->count);
		if((obj_w->matrix.y < EFCT_UG02_FADE_S)){
			ret = EFCT_SYSRET_FADE;
			obj_w->seq++;
		}
		break;

	case 3:
		if(obj_w->matrix.y > EFCT_UG02_END){
			obj_w->matrix.y -= EFCT_UG02_MOVE;
			CLACT_SetMatrix(obj_w->cl, &obj_w->matrix);		// Wݒ
			CLACT_AnmFrameChg(obj_w->cl, obj_w->count);
		}else{
			obj_w->seq++;
		}
		break;

	case 4:
		ret = EFCT_SYSRET_END;
		break;
	}
	
	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	lIuWFNg̓o^
 *
 *@param	drawsys		`f[^
 *@param	data		IuWFNgf[^o^e[u
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void initObj04(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO_EX* obj_w;
	
	// IuWFNg̍쐬
	data->data = sys_AllocMemory(HEAPID_FIELD, sizeof(EFCT_UG_HERO_EX));
	SDK_ASSERT(data->data);
	memset(data->data, 0, sizeof(EFCT_UG_HERO_EX));
	
	obj_w = (EFCT_UG_HERO_EX*)data->data;
	obj_w->matrix.x = EFECT_UGCOMMON_OBJ_MAT_X;
	obj_w->matrix.y = EFECT_UGCOMMON_OBJ_MAT_Y;
	
	// Z̓o^
	obj_w->cl = addCellAct(drawsys, 0, &obj_w->matrix, 0, 1);
	
	//Aj[VSequenceύX
	CLACT_AnmChg(obj_w->cl, 1);
	obj_w->count = EFCT_UG03_ROTA_S;

	// `tOIt
	CLACT_SetDrawFlag(obj_w->cl, 0);
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	lIuWFj
 *
 *@param	data		IuWFf[^
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
void deleteObj04(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_HERO_EX* obj_w = (EFCT_UG_HERO_EX*)data->data;
	
	if(data->data != NULL){
		// ZAN^[폜
		CLACT_Delete(obj_w->cl);

		// IuWFNgj
		sys_FreeMemory(HEAPID_FIELD, data->data);
		data->data = NULL;
	}
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	lIuWFNg̓֐
 *
 *@param	data	lIuWFNg
 *
 *@retval	EFCT_SYSRET_OK		
 *@retval	EFCT_SYSRET_FADE	tF[hJn
 *@retval	EFCT_SYSRET_END		I
 *
 *
 */
//-----------------------------------------------------------------------------
int moveObj04(struct _EFCT_UG_OBJ* data)
{
	VecFx32	mat;	// Z`W
	EFCT_UG_HERO_EX* obj_w = (EFCT_UG_HERO_EX*)data->data;
	int	ret	= EFCT_SYSRET_OK;	// ߂l
	
	switch(obj_w->seq){
	case 0:
		// `tOI
		CLACT_SetDrawFlag(obj_w->cl, 1);
		obj_w->seq++;
		break;
	case 1:
		if(obj_w->count <= EFCT_UG03_OBJ_END){
			mat = obj_w->matrix;
			mat.y -= FX_Mul(FX_SinIdx(obj_w->count), EFCT_UG03_OBJ_JUMP_DIS);
			CLACT_SetMatrix(obj_w->cl, &mat);		// Wݒ
			obj_w->count += EFCT_UG03_OBJ_CNNUM;
			CLACT_AnmFrameChg(obj_w->cl, FX32_ONE);
	
		}else{
			obj_w->seq++;
		}
		break;
	case 2:		// ]x
		obj_w->count -= EFCT_UG03_ROTA_SA;
		CLACT_AnmFrameChg(obj_w->cl, obj_w->count);
		
		if(obj_w->count <= EFCT_UG03_ROTA_SE){
			obj_w->seq++;
		}
		break;
	case 3:
		ret = EFCT_SYSRET_END;
		break;
	}
	
	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	e쐬
 *
 *@param	drawsys		`f[^
 *@param	data		IuWFf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void initObj05(EFCT_UG_DRAWSYS* drawsys, struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_SHADOW* obj_w;
	
	// IuWFNg̍쐬
	data->data = sys_AllocMemory(HEAPID_FIELD, sizeof(EFCT_UG_SHADOW));
	SDK_ASSERT(data->data);
	memset(data->data, 0, sizeof(EFCT_UG_SHADOW));
	
	obj_w = (EFCT_UG_SHADOW*)data->data;
	obj_w->matrix.x = EFECT_UGCOMMON_OBJ_MAT_X;
	obj_w->matrix.y = 96*FX32_ONE;
	
	// Z̓o^
	obj_w->cl = addCellAct(drawsys, 1, &obj_w->matrix, 1, 1);

	//Aj[VSequenceύX
	CLACT_AnmChg(obj_w->cl, 1);
}
void deleteObj05(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_SHADOW* obj_w = (EFCT_UG_SHADOW*)data->data;
	
	if(data->data != NULL){
		// ZAN^[폜
		CLACT_Delete(obj_w->cl);

		// IuWFNgj
		sys_FreeMemory(HEAPID_FIELD, data->data);
		data->data = NULL;
	}
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	e𓮂
 *
 *@param	data
 *
 *@retval	EFCT_SYSRET_OK		
 *@retval	EFCT_SYSRET_FADE	tF[hJn
 *@retval	EFCT_SYSRET_END		I
 *
 *
 */
//-----------------------------------------------------------------------------
int moveObj05(struct _EFCT_UG_OBJ* data)
{
	EFCT_UG_SHADOW* obj_w = (EFCT_UG_SHADOW*)data->data;
	
	// e傫āAŌ܂ő傫ȂI
	if(obj_w->count < EFCT_UG03_SHADOW_COUNT){
		CLACT_AnmFrameChg(obj_w->cl, FX32_ONE);
		obj_w->count++;
		return EFCT_SYSRET_OK;	
	}

	return EFCT_SYSRET_END;	
}
