//============================================================================================
/**
 * @file	encount_effect.c
 * @bfief	GJEg
 * @author	GAME FREAK inc.
 */
//============================================================================================
#include "common.h"
#include "system/lib_pack.h"
#include "system/brightness.h"
#include "field_event.h"
#include "motion_bl.h"


#define __ENCOUNT_EFFECT_H_GLOBAL__
#include "encount_effect.h"
#define __ECCOUNT_EFFECT_DEF_H_GLOBAL
#define __ECCOUNT_EFFECT_DEF_H_GLOBAL_VAL
#include "encount_effect_def.h"

#include "ecnt_tomo.h"


#define TCB_TSK_PRI	(5)

//-----------------------------------------------------------------------------
//
// GJEgp֐e[u
//
//=============================================================================
static const TCB_FUNC EncountEffectTask[] ={
	EncountEffectMotionBl00,
	EncountEffectMotionBl01,
//	EncountEffectFog00,		// oOۂ̂Ŗ@12/19 tomoya
};



//-------------------------------------
//
//	ŏ̃sJsJ̃^XN
//
//=====================================
typedef struct{
	int seq;
	int count;
	int plane;		// BGʎw
	int disp;		// ʎw
	BOOL* end;		// Ip
} BR_FLASH_TASK;

// JnGtFNg^XNiŏ̌̂Ȃǂ𐧌j
static void BR_FlashTask(TCB_PTR tcb, void *work);
enum{
	FADE_SUB_EFFECT,
	FADE_EFFECT,
	FADE_WAIT,
	FADE_RET_EFFECT,
	FADE_RET_WAIT,
	END_EFFECT,
};

//-------------------------------------
//
//	HuNp
//
//=====================================
//---------------------------
//
// HBlankpO[oϐ
//
//===========================
ENCOUNT_HBLANK HBlankWork;
static void ENC_HBlankInit(int work_size, INTR_FUNC func);	// HuNݒ
static void ENC_HBlankDelete(void);						// HuNj

//---------------------------
//
// BGɊHBlankp
//
//===========================
typedef struct {
	int x;			// ̈ړʒu
	int speed;		// x
} ENC_HB_BG_CUT;
#define ENC_HB_BG_CUT_ST	(100)		// x
#define ENC_HB_BG_CUT_END_X	(25000)
static void ENC_BG_Cut_HBlank(void * work);




//----------------------------------------------------------------------------
/**
 *
 *@brief	GJEgGtFNgJn
 *
 *@param	No		GJEgGtFNgNO
 *@param	*fsw	tB[hVXe[Ñ|C^
 *@param	end		I`FbNp@TRUEFI 
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void EncountEffectStart(int No, FIELDSYS_WORK *fsw, BOOL* end )
{
	TCB_PTR tcb;
	ENCOUNT_EFFECT_WORK *eew;
	tcb = PMDS_taskAdd(EncountEffectTask[No], sizeof(ENCOUNT_EFFECT_WORK), TCB_TSK_PRI, HEAPID_FIELD);
	eew = TCB_GetWork(tcb);
	eew->fsw = fsw;
	eew->end = end;		// ItOݒ
	if(eew->end != NULL){
		*(eew->end) = FALSE;
	}
}





//-----------------------------------------------------------------------------
//
//	ŏ̃sJsJp^XNJn֐
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	ŏ̃tbV̕\^XNs
 *
 *@param	plane	ʂĂ
 *					PLANEMASK_BG0	BG0
 *					PLANEMASK_BG1	BG1
 *					PLANEMASK_BG2	BG2
 *					PLANEMASK_BG3	BG3
 *					PLANEMASK_OBJ	OBJ
 *					PLANEMASK_BD	obN
 *					
 *@param	disp	Cʂɂ:MASK_MAIN_DISPLAY
 *					Tuʂɂ:MASK_SUB_DISPLAY
 *					ʂɂ:MASK_DOUBLE_DISPLAY
 *
 *@param	end		ITRUEԂtO
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void EncountFlashTask(int plane, int disp, BOOL* end)
{
	TCB_PTR tcb;
	BR_FLASH_TASK *eew;
	tcb = PMDS_taskAdd(BR_FlashTask, sizeof(BR_FLASH_TASK), TCB_TSK_PRI, HEAPID_FIELD);
	eew = TCB_GetWork(tcb);
	eew->end = end;		// ItOݒ
	if(eew->end != NULL){
		*(eew->end) = FALSE;
	}
	eew->plane = plane;
	eew->disp = disp;
}

//------------------------------------------------------------------
/**
 * 
 * GtFNg
 *
 * ŏ̃sJsJ\
 * 
 * @param   tcb		^XN|C^
 * @param   work	[N|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BR_FlashTask(TCB_PTR tcb, void *work)
{
	BR_FLASH_TASK *eew = work;

	switch(eew->seq){
	case FADE_SUB_EFFECT:
		if(eew->disp == MASK_MAIN_DISPLAY){
			//ubNAEg
			ChangeBrightnessRequest(40,-16,0, eew->plane, MASK_SUB_DISPLAY);
		}else{
			if(eew->disp == MASK_SUB_DISPLAY){
				//ubNAEg
				ChangeBrightnessRequest(40,-16,0, eew->plane, MASK_MAIN_DISPLAY);
			}
		}
		eew->seq++;
		break;

	case FADE_EFFECT:
		//zCgAEg
		ChangeBrightnessRequest(4,16,0,eew->plane,eew->disp);
		eew->seq++;
		break;
		
	case FADE_WAIT:
		if( IsFinishedBrightnessChg( eew->disp ) ){
			eew->seq++;
		}
		break;
	case FADE_RET_EFFECT:
		//zCgC
		ChangeBrightnessRequest(4,0,16,eew->plane,eew->disp);
		eew->seq++;
		break;
		
	case FADE_RET_WAIT:
		if( IsFinishedBrightnessChg(eew->disp) ){
			
			eew->count++;
			if(eew->count==4){
				eew->seq = END_EFFECT;
			}else{
				eew->seq = FADE_EFFECT;
			}
		}
		break;
	case END_EFFECT:		// CGtFNgɈړ
		eew->seq = 0;
		eew->count = 0;

		PMDS_taskDel(tcb);	//^XNI
		if(eew->end != NULL){
			*(eew->end) = TRUE;		// ^XNI
		}
		break;
	}
}


//----------------------------------------------------------------------------
//
//
//	GtFNgpHuN֐S
//
//
//============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	HuN֐ݒ
 *
 *@param	work_size	[NTCY
 *@param	func		HuN֐
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ENC_HBlankInit(int work_size, INTR_FUNC func)
{
	u8	result;

	SDK_ASSERTMSG(HBlank.flg == ENCOUNT_HBLANK_NONE, "HuNdݒ\n");
	
	// [NTCYOȂ烏[N쐬Ȃ
	if(work_size == 0){
		HBlankWork.Work = NULL;
	}else{
		HBlankWork.Work = sys_AllocMemory(HEAPID_FIELD, work_size);
		SDK_ASSERT(HBlankWork.Work);
		memset(HBlankWork.Work, 0, work_size);
	}
	result = sys_HBlankIntrSet(func, NULL);		// ֐ݒ
	if(result == TRUE){
		HBlankWork.flg = ENCOUNT_HBLANK_DO;
	}else{
		ENC_HBlankDelete();		// o^s
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	HuNj
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ENC_HBlankDelete(void)
{
	if(HBlankWork.Work != NULL){
		sys_FreeMemory(HEAPID_FIELD, HBlankWork.Work);
		HBlankWork.Work = NULL;
	}
	sys_HBlankIntrStop();		//HBlank荞ݒ~
	HBlankWork.flg = ENCOUNT_HBLANK_NONE;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	BGʂSĉɃJbgX^[g
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ENC_BG_Cut_Start(void)
{
	ENC_HBlankInit(sizeof(ENC_HB_BG_CUT), ENC_BG_Cut_HBlank);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	BGʂSĉɃJbg
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void ENC_BG_Cut_HBlank(void * work)
{
	ENC_HB_BG_CUT* hbw = (ENC_HB_BG_CUT*)HBlankWork.Work;
	int v_count;		// VJEg
	int	x_num;			// BGItZbgɐݒ肷l

	// VJE^擾AO͈̎ړlvZ
	v_count = GX_GetVCount();
	if(v_count == 0){

		if((hbw->x + hbw->speed) <= ENC_HB_BG_CUT_END_X){
			hbw->x += hbw->speed;			// ړ
			hbw->speed += ENC_HB_BG_CUT_ST;	// 
		}else{
			
			ENC_HBlankDelete();
			return ;
		}
	}

	// 96A96ȏEɈړ
	x_num = hbw->x / 100;
	if(v_count >= 96){
		x_num = -x_num;
	}
	G2_SetBG0Offset(x_num, 0);
	G2_SetBG1Offset(x_num, 0);
	G2_SetBG2Offset(x_num, 0);
	G2_SetBG3Offset(x_num, 0);
}
