//============================================================================================
/**
 * @file	encount_set.c
 * @author	saitou
 *
 * 2005.12.18	field_encount.cGJEg蕔ړ
 */
//============================================================================================
#include "encount_set.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "eventdata.h"
#include "honey_tree_enc.h"

#include "field_encount.h"
#include "battle/tokusyu_def.h"

#include "debug_saito.h"

//============================================================================================
//============================================================================================


#define	WALK_COUNT_GLOBAL	( 8 )		// GJEgȂ̊{l
#define	WALK_NEXT_PERCENT	( 5 )		// JEgsŎ̏ɐiފm
#define	ATTR_NEXT_PERCENT	( 60 )		// ÕAgr[gƓŎ̏ɐiފm
#define	ATTR_NEXT_PERCENT	( 60 )		// ÕAgr[gƓŎ̏ɐiފm
#define	CALC_SHIFT			( 8 )		// vZVtgl
#define	DEBUG_ENCOUNT_PER	( 30 )

static BOOL MapEncountCheck( FIELDSYS_WORK * fsys, u16 attr, u32 map_encount );
static u32 EncountAttributeCheck( FIELDSYS_WORK * fsys, u8 attr, u8 *outEncLocation );
static BOOL	EncountWalkCheck( FIELDSYS_WORK * fsys, u32 per );
static BOOL BeforAttributeCheck( FIELDSYS_WORK * fsys, u16 attr );
static BOOL EncountCheckMain( FIELDSYS_WORK * fsys, u32 per );

static u8 CheckFixTypeEcnt(	const POKEPARTY *inMyParty,
							const GROUND_ENC_MONSTER_DAT * inData,
							const u8 type, const u8 tokusei,u8 * outNo);
static int GetEncountProbGround(FIELDSYS_WORK * fsys);
static int GetEncountProbWater(FIELDSYS_WORK * fsys);
static void WildEncSingle(FIELDSYS_WORK * fsys,
							POKEPARTY *party,
							BATTLE_PARAM * param,
							const u8 inEncLocation,
							const BOOL inSwayEnc,
							const BOOL inDeside,
							const int inSwayTbl);
static void WildEncDouble(	FIELDSYS_WORK * fsys,
							POKEPARTY *party,
							BATTLE_PARAM * param );
//============================================================================================
//
//
//					GJEg菈
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * Q΂Q쐶̂Ƃ͗hꑐGJEg͂ȂdlA`FbN͒ʂĂ܂
 */
//-----------------------------------------------------------------------------
BOOL FieldEncount_Check(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM * param;
	int x, z;
	u8	attr;
	u8 enc_location;	//GJEgn`inォォj
	BOOL rc;

	int sway_table;
	BOOL mons_deside;

	BOOL sway_enc;

	POKEPARTY *my_party;
	
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	
	attr = (u8)GetAttributeLSB( fsys, x, z );

	{
		u32	map_encount;
		// GJEgAgr[g`FbN
		map_encount = EncountAttributeCheck( fsys, attr, &enc_location );
		if( map_encount == 0 ){
			return FALSE;		//GJEgAgr[gł͂Ȃ
		}
		
		my_party = SaveData_GetTemotiPokemon(fsys->savedata);
		
		if( MapEncountCheck( fsys, attr, map_encount ) == FALSE ){
			fsys->encount.before_attr = attr;
			//return FALSE;
			rc = FALSE;
		}else{
			rc = TRUE;
		}
	}

	//ꑐGJEg`FbN
	//ꑐɃqbgAO`FbNŁAGJEgȂƂĂGJEg
	if ( !SwayGrass_CheckSpEncount(x, z, fsys, fsys->SwayGrass, &sway_table, &mons_deside) ){
		sway_enc = FALSE;		//ꑐGJEgs
		if (rc == FALSE){
			return FALSE;
		}
	}else{
		sway_enc = TRUE;		//ꑐGJEg
	}

	//}bv؂ւ̍ۂ̓NA
	
	fsys->encount.walk_count = 0;
	fsys->encount.plus_per = 0;
	fsys->encount.before_attr = attr;

	

	//n㐅㕪
	if (enc_location == GROUND_ENCOUNT){
		;
	}else if(enc_location == WATER_ENCOUNT){
		;
	}else{
		GF_ASSERT(0&&"GJEgP[Vs");
		return FALSE;
	}
	
	if (1){	//Ƃ肠22ɂ͒ʂȂł
		//ogp[^̃AP[Vƃ|Pp[eB̏
		param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_YASEI);
		//莝|PȂǃZbg
		BattleParam_SetParamByGameData(param, fsys);
		
		WildEncSingle(	fsys, my_party, param,
						enc_location, sway_enc,
						mons_deside, sway_table	);
	}else{
		//ogp[^̃AP[Vƃ|Pp[eB̏
		param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_2vs2_YASEI);
		//莝|PȂǃZbg
		BattleParam_SetParamByGameData(param, fsys);
		//|PZbg
		{
			MYSTATUS * my = SaveData_GetMyStatus(fsys->savedata);
			POKEPARTY * temoti = SaveData_GetTemotiPokemon(fsys->savedata);
			BattleParam_SetMyStatus(param, my, POKEPARTY_MINE_PAIR);
			BattleParam_SetPokeParty(param, temoti, POKEPARTY_MINE_PAIR);
		}
		WildEncDouble(	fsys, my_party, param );
	}
/**
	{
		//GJEgf[^쐬
		u8 mons_tbl_no;
		int i;
		GROUND_ENC_MONSTER_DAT enc_data[12];
		for(i=0;i<12;i++){
			enc_data[i] = data->NormalEnc[i];
		}
		//ꑐpe[uɏ
		if (sway_table == SWAY_GRASS_ENC_SP){
			enc_data[4].MonsterNo = data->SwayEnc[0];
			enc_data[5].MonsterNo = data->SwayEnc[1];
			enc_data[10].MonsterNo = data->SwayEnc[2];
			enc_data[11].MonsterNo = data->SwayEnc[3];
		}

		//GJEg郂X^[肵Ăꍇ
		if (mons_deside == TRUE){
			//w|P100GJEg
			mons_tbl_no = SwayGrass_GetMonsTblNo( fsys->SwayGrass );
			rc = SetEncountDataDesideMons(	enc_data, enc_location,
											mons_tbl_no, POKEPARTY_ENEMY, param );
			OS_Printf_saitou("local_print encount_mons_tbl_set = %d\n",mons_tbl_no);
			
		}else{
			//GJEgf[^Zbg
			rc = SetEncountData(	my_party, enc_data,
									enc_location, 0, POKEPARTY_ENEMY,
									param, &mons_tbl_no );
			OS_Printf_saitou("local_print encount_mons_tbl_get = %d\n",mons_tbl_no);
			SwayGrass_SetMonsTblNo( fsys->SwayGrass, mons_tbl_no );
		}

		if (rc){
			//ꑐGJEgƂāAGJEgꍇ́AZbg|PL
			if (sway_enc){
				mons_tbl_no = SwayGrass_GetMonsTblNo( fsys->SwayGrass );
				SwayGrass_SetEncMonsNo(fsys->SwayGrass, enc_data[mons_tbl_no].MonsterNo);
			}else{
				//ʏGJEgꍇ́Aꑐ񓙂NA
				SwayGrass_InitSwayGrass(fsys->SwayGrass);
			}

			FieldEncount_Set(fsys, param);
		}
	}
*/	
	return rc;
}

//쐶VOZbgAbv
static void WildEncSingle(FIELDSYS_WORK * fsys,
							POKEPARTY *party,
							BATTLE_PARAM * param,
							const u8 inEncLocation,
							const BOOL inSwayEnc,
							const BOOL inDeside,
							const int inSwayTbl)
{
	u8 mons_tbl_no;
	BOOL rc;
	ENCOUNT_DATA *data;
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);	
	{
		//GJEgf[^쐬
		int i;
		GROUND_ENC_MONSTER_DAT enc_data[12];
		for(i=0;i<12;i++){
			enc_data[i] = data->NormalEnc[i];
		}
		//ꑐpe[uɏ
		if (inSwayTbl == SWAY_GRASS_ENC_SP){
			enc_data[4].MonsterNo = data->SwayEnc[0];
			enc_data[5].MonsterNo = data->SwayEnc[1];
			enc_data[10].MonsterNo = data->SwayEnc[2];
			enc_data[11].MonsterNo = data->SwayEnc[3];
		}

		//GJEg郂X^[肵Ăꍇ
		if (inDeside == TRUE){
			//w|P100GJEg
			mons_tbl_no = SwayGrass_GetMonsTblNo( fsys->SwayGrass );
			rc = SetEncountDataDesideMons(	enc_data, inEncLocation,
											mons_tbl_no, POKEPARTY_ENEMY, param );
			OS_Printf_saitou("local_print encount_mons_tbl_set = %d\n",mons_tbl_no);
			
		}else{
			//GJEgf[^Zbg
			rc = SetEncountData(	party, enc_data,
									inEncLocation, 0, POKEPARTY_ENEMY,
									param, &mons_tbl_no );
			OS_Printf_saitou("local_print encount_mons_tbl_get = %d\n",mons_tbl_no);
			SwayGrass_SetMonsTblNo( fsys->SwayGrass, mons_tbl_no );
		}

		if (rc){
			//ꑐGJEgƂāAGJEgꍇ́AZbg|PL
			if (inSwayEnc){
				mons_tbl_no = SwayGrass_GetMonsTblNo( fsys->SwayGrass );
				SwayGrass_SetEncMonsNo(fsys->SwayGrass, enc_data[mons_tbl_no].MonsterNo);
			}else{
				//ʏGJEgꍇ́Aꑐ񓙂NA
				SwayGrass_InitSwayGrass(fsys->SwayGrass);
			}

			FieldEncount_Set(fsys, param);
		}
	}
}

static void WildEncDouble(	FIELDSYS_WORK * fsys,
							POKEPARTY *party,
							BATTLE_PARAM * param )
{
	u8 mons_tbl_no;
	BOOL rc;
	ENCOUNT_DATA *data;
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
	{
		//GJEgf[^쐬
		int i;
		GROUND_ENC_MONSTER_DAT enc_data[12];
		for(i=0;i<12;i++){
			enc_data[i] = data->NormalEnc[i];
		}
		
		{
			//GJEgf[^Zbg
			rc = SetEncountData(	party, enc_data,
									GROUND_ENCOUNT, 0, POKEPARTY_ENEMY,
									param, &mons_tbl_no );
			OS_Printf_saitou("local_print encount_mons_tbl_get = %d\n",mons_tbl_no);
			rc = SetEncountData(	party, enc_data,
									GROUND_ENCOUNT, 0, POKEPARTY_ENEMY_PAIR,
									param, &mons_tbl_no );
			OS_Printf_saitou("local_print encount_mons_tbl_get = %d\n",mons_tbl_no);
		}

		if (rc){
			//ʏGJEgꍇ́Aꑐ񓙂NA
			SwayGrass_InitSwayGrass(fsys->SwayGrass);
			FieldEncount_Set(fsys, param);
		}
	}
}

static BOOL MapEncountCheck( FIELDSYS_WORK * fsys, const u16 attr, u32 map_encount)
{
	map_encount = map_encount << CALC_SHIFT;

	// GJEg
	if( EncountWalkCheck( fsys, map_encount ) == FALSE ){
		fsys->encount.walk_count++;			// JEg{
		// 20%Ŏ̏
		if( ( gf_rand()%100 ) >= WALK_NEXT_PERCENT ){
			return FALSE;
		}
	}

	// OɂꏊƓAgr[g
	if( BeforAttributeCheck( fsys, attr ) == TRUE ){
		// 60%Ŏ̏
		if( ( gf_rand()%100 ) >= ATTR_NEXT_PERCENT ){
			return FALSE;
		}
	}

	// ]ԂɏĂꍇ̓GJEg80%
	// r[h`FbN
	// ACe`FbN
	// `FbNiBAnAȂj

	// C
	if( EncountCheckMain( fsys, map_encount ) == FALSE ){
		return FALSE;
	}

	// |P
	// Xv[`FbN


	return TRUE;
}

//mԂ
static u32 EncountAttributeCheck( FIELDSYS_WORK * fsys, u8 attr, u8 *outEncLocation  )
{
	//́AMATR_IsBattleoオ\肾AƂ肠ʂɃZbg
	
	// Agr[g`FbN
	if( MATR_IsGrass(attr)  ){
		(*outEncLocation) = GROUND_ENCOUNT;
		return GetEncountProbGround( fsys );
	}
	//
	//A
	if ( MATR_IsDunFloor(attr) ){
		(*outEncLocation) = GROUND_ENCOUNT;
		return GetEncountProbGround( fsys );
	}
	//
	else if(0){
		(*outEncLocation) = WATER_ENCOUNT;
		return GetEncountProbWater( fsys );
	}

	return 0;
}

static BOOL	EncountWalkCheck( FIELDSYS_WORK * fsys, u32 per )
{
	per = WALK_COUNT_GLOBAL - ( (per/10)>>CALC_SHIFT );

	if( fsys->encount.walk_count >= per ){
		return TRUE;
	}
	return FALSE;
}

static BOOL BeforAttributeCheck( FIELDSYS_WORK * fsys, u16 attr )
{
	if( fsys->encount.before_attr == attr ){
		return TRUE;
	}
	return FALSE;
}

static BOOL EncountCheckMain( FIELDSYS_WORK * fsys, u32 per )
{
	u32	encount;
	encount = ( per + ( fsys->encount.plus_per<<CALC_SHIFT ) ) >> CALC_SHIFT;
	if( ( gf_rand()%100 ) >= encount ){
		fsys->encount.plus_per += ( ( per/200 ) >> CALC_SHIFT );
		return FALSE;
	}
	return TRUE;
}



//============================================================================================
//============================================================================================
//====================================================
//	_|PZbg
//====================================================
//----------------------------------------------------
//	ނ /  / A
//	߂l : GJEgf[^̔zԍ
//----------------------------------------------------
static u8 RandamPokeSet(void)
{
	u8	i;

	i = gf_rand() % 100;

	if( i < 20 )			return	0;		// 20%
	if( i >= 20 && i < 40 )	return	1;		// 20%
	if( i >= 40 && i < 50 )	return	2;		// 10%
	if( i >= 50 && i < 60 )	return	3;		// 10%
	if( i >= 60 && i < 70 )	return	4;		// 10%
	if( i >= 70 && i < 80 )	return	5;		// 10%
	if( i >= 80 && i < 85 )	return	6;		//  5%
	if( i >= 85 && i < 90 )	return	7;		//  5%
	if( i >= 90 && i < 94 )	return	8;		//  4%
	if( i >= 94 && i < 98 )	return	9;		//  4%
	if( i == 98 )			return	10;		//  1%
	return	11;								//  1%
}
//----------------------------------------------------
//	
//	߂l : GJEgf[^̔zԍ
//----------------------------------------------------
static u8 RandamPokeSetNoGround(void)
{
	u8	i;

	i = gf_rand() % 100;

	if( i < 60 )			return	0;		// 60%
	if( i >= 60 && i < 90 )	return	1;		// 30%
	if( i >= 90 && i < 95 )	return	2;		//  5%
	if( i >= 95 && i < 99 )	return	3;		//  4%
	return	4;								//  1%
}
//----------------------------------------------------
//	ނ
//	   : u8 no = ފƂ̎
//	߂l : GJEg|Pf[^̔zԍ
//----------------------------------------------------
static u8 RandamPokeSetFish( u8 no )
{
	u8	i;
	u8	p = 0;

	i = gf_rand() % 100;

	switch( no ){
	case 0:		// {̒ފ
		if( i < 70 )	p = 0;	// 70%
		else			p = 1;	// 10%
		break;
	case 1:		// ǂފ
		if( i < 60 )				p = 2;	// 60%
		if( i >= 60 && i < 80 )		p = 3;	// 20%
		if( i >= 80 && i < 100 )	p = 4;	// 20%
		break;
	case 2:		// ފ
		if( i < 40 )				p = 5;	// 40%
		if( i >= 40 && i < 80 )		p = 6;	// 40%
		if( i >= 80 && i < 95 )		p = 7;	// 15%
		if( i >= 95 && i < 99 )		p = 8;	//  4%
		if( i >= 99 && i < 100 )	p = 9;	//  1%
	}

	return	p;
}

//----------------------------------------------------
//	iݒ
//	߂l : iԍ
//----------------------------------------------------
static u8 GetEncountChar(void)
{
	CUBE * cube;
	u8	i, j, k;
	u8	tbl[25];
	u32	type;
	u8 spa;
/**
	// Tt@[h80%̊m(|bNgp͓ɂ鐫iʂ͔Ȃ)
	if ( IsFieldSafariMode() == TRUE && ( pp_rand() % 100 ) < 80 ){
		cube = SafariCubeTableGet2();	// |bNũ|bN擾
		// |bN
		if( cube != NULL ){

			// ie[u
			for( i=0; i<25; i++ )
				tbl[i] = i;

			// 鐫ȉԂ𗐐Ń\[g
			for( i=0; i<24; i++ ){
				for( j=i+1; j<25; j++ ){
					if( ( pp_rand() & 1 ) == 1 ){
						k = tbl[i];
						tbl[i] = tbl[j];
						tbl[j] = k;
					}
				}
			}

			for( i=0; i<25; i++ ){
				// uĂ|bNDȐiȂA̐iɌ
				if( CheckCubeLike( tbl[i], cube ) > 0 )
					return	tbl[i];
			}
		}
	}

	//VN̓ɂGJEg|P̐i𓯂ɂȂ₷
	// 擪̃|P^}SłȂ
	if( PokeParaGet( &PokeParaMine[0], ID_egg_exist_flag ) == 0 ){
		spa = SpecialAbirityNoGet( &PokeParaMine[0] );	// \͎擾
		if( spa == TOKUSYU_SINKURO ){	//VN
			if ( pp_rand()%2 == 0 ){//Kp@m1/2{
				type = (u32)PokeParaGet( &PokeParaMine[0], ID_personal_rnd );
				type = type % 25;
				return (u8)type;
			}
		}
	}	//<<20031001 add
*/	
	return gf_rand() % 25;	// _Ō
	
}

//----------------------------------------------------
//	GJEg|PZbg
//	 : u16 poke = |PID
//		   u8 lv    = GJEgLv
//----------------------------------------------------
static void EncountParamSet( u16 poke, u8 lv, const int inTarget, BATTLE_PARAM *outBattleParam )
{
	u16 monsno;
	u32 rnd;
	u8 sex;
	u8 spa;
	BOOL rc;
	POKEMON_PARAM *poke_param;
	poke_param = PokemonParam_AllocWork(HEAPID_WORLD);
	PokeParaInit(poke_param);

///	u8 valid_flg;			//L`FbNtO
///	PokeParaEnemyInit();	// PokeParaEnemy
/**
	valid_flg = 1;
	switch(PPD[poke].sex){
        case    MONS_MALE:
        case    MONS_FEMALE:
        case    MONS_UNKNOWN:
			valid_flg = 0;
	}
	
	if (valid_flg){//Io|PʂȂÁAŒ̏ꍇ́A`FbNȂ
		//擪|P̓{fB̂Ƃِ͈o₷Ȃ
		// 擪̃|P^}SłȂ
		if( PokeParaGet( &PokeParaMine[0], ID_egg_exist_flag ) == 0 ){
			spa = SpecialAbirityNoGet( &PokeParaMine[0] );	// \͎擾
			if( spa == TOKUSYU_MEROMEROBODHI ){
				// 2/3œ
				if( pp_rand()%3 > 0 ){
					monsno = (u16)PokeParaGet( &PokeParaMine[0], ID_monsno );
					rnd = (u32)PokeParaGet( &PokeParaMine[0], ID_personal_rnd );
					sex = PokeSexGetMonsNo(monsno,rnd);
					//ِ𔭐
					if (sex == MONS_FEMALE) sex = MONS_MALE;
					else sex = MONS_FEMALE;
					PokeParaSetSexChr(&PokeParaEnemy[0],poke,lv,POW_RND,sex,GetEncountChar(),0);
					return;
				}
			}
		}
	}
*/
	
	PokeParaSetChr( poke_param, poke, lv, POW_RND, GetEncountChar() );
	rc = PokeParty_Add(outBattleParam->poke_party[inTarget], poke_param);
	GF_ASSERT(rc&&"|P̒ǉɎs");
	sys_FreeMemoryEz(poke_param);
}


#if 0
//----------------------------------------------------
//	xݒ
//	   : GJEg|P̃f[^
//	߂l : GJEg|P̃x
//----------------------------------------------------
static u8 EncountPokeLvSet( const ENCOUNTPOKE * data )
{
	u8	size;
	u8	plus;
	u8	min, max;
	u8	spa;

	// Max Lv  Min Lv 菬ꍇ̏C
	if( data->MaxLv >= data->MinLv ){
		min = data->MinLv;
		max = data->MaxLv;
	}else{
		min = data->MaxLv;
		max = data->MinLv;
	}

	size = max - min + 1;		// ␳TCY
	plus = pp_rand() % size;	// ␳l

	//u邫vuvbV[vu͂肫v̓`FbNx̍|PƂTŃGJEg
	// 擪̃|P^}SłȂ
	if( PokeParaGet( &PokeParaMine[0], ID_egg_exist_flag ) == 0 ){
		spa = SpecialAbirityNoGet( &PokeParaMine[0] );	// \͎擾
		if( (spa == TOKUSYU_HARIKIRI)||(spa == TOKUSYU_YARUKI)||(spa == TOKUSYU_PURESSYAA) ){
			// 1/2œ
			if( pp_rand()%2 == 0 ){
				return	( max );	//Bxmaxɂ	
			}else{
				if (plus>0){
					plus--;//max̃x͑Ώۂ͂
				}
			}
		}
	}
	return	( min + plus );		// GJEgx
}

//====================================================
//	GJEgf[^Zbg
//====================================================

//----------------------------------------------------
//	m[}
//	   : ENCOUNTDATA * fld = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 sp_check       = `FbN
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
static u8 SetEncountData( const ENCOUNTDATA * fld, u8 id, u8 sp_check )
{
	u8 result;
	u8	no = 0;
	u8	lv = 0;
	
	// GJEg|P
	switch( id ){
	case GROUND_ENCOUNT:	// n		
		//傭ɂA͂˃^CṽGJEǧ
		result = CheckFixTypeEcnt(fld->data,METAL_TYPE,TOKUSYU_ZIRYOKU, &no);
		if (result == FALSE){
			//ł񂫓ɂAł񂫃^CṽGJEǧ
			result = CheckFixTypeEcnt(fld->data,ELECTRIC_TYPE,TOKUSYU_SEIDENKI, &no);
			if (result == FALSE){
				//ɂw^CvƂ̃GJEgɎsBʏ̃GJEg
				no = RandamPokeSet();
			}
		}
		break;
	case WATER_ENCOUNT:		// 
		//傭GJEg
		//ł񂫓ɂAł񂫃^CṽGJEǧ
		result = CheckFixTypeEcnt(fld->data,ELECTRIC_TYPE,TOKUSYU_SEIDENKI, &no);
		if (result == FALSE){
			//ɂw^CvƂ̃GJEgɎsBʏ̃GJEg
			no = RandamPokeSet2();
		}
		break;
	case ROCK_ENCOUNT:		// ӂ
		//傭GJEg
		no = RandamPokeSet2();
	}

	lv = EncountPokeLvSet( &fld->data[no] );	// Lvݒ
	// Xv[`FbN
	if( ( sp_check & SP_CHK_SPRAY ) != 0 ){
		// Xv[Lv̒Ⴂ|P̓GJEgȂ
		if( SprayEncountCheck( lv ) == FALSE ){
			return FALSE;
		}
	}

	//og`[uGJEg̏ꍇ͌Ŕ肷
	if ( NowMap.screen_id != MAPSCRNID_TUBE01_6 ){	//og`[uGJEg
		// `FbN
		if( ( sp_check & SP_CHK_SPA ) != 0 ){
			if( CheckEcntCancelByLv( lv ) == FALSE ){
				return FALSE;
			}
		}
	}
	
	// GJEg|PZbg
	EncountParamSet( fld->data[no].pokeNo, lv );

	return	TRUE;
}

//----------------------------------------------------
//	GJEg|PZbg
//	 : u16 poke = |PID
//		   u8 lv    = GJEgLv
//----------------------------------------------------
static void EncountParamSet( u16 poke, u8 lv )
{
	u16 monsno;
	u32 rnd;
	u8 sex;
	u8 spa;
	u8 valid_flg;			//L`FbNtO
	PokeParaEnemyInit();	// PokeParaEnemy

	valid_flg = 1;
	switch(PPD[poke].sex){
        case    MONS_MALE:
        case    MONS_FEMALE:
        case    MONS_UNKNOWN:
			valid_flg = 0;
	}
	if (valid_flg){//Io|PʂȂÁAŒ̏ꍇ́A`FbNȂ
		//擪|P̓{fB̂Ƃِ͈o₷Ȃ
		// 擪̃|P^}SłȂ
		if( PokeParaGet( &PokeParaMine[0], ID_egg_exist_flag ) == 0 ){
			spa = SpecialAbirityNoGet( &PokeParaMine[0] );	// \͎擾
			if( spa == TOKUSYU_MEROMEROBODHI ){
				// 2/3œ
				if( pp_rand()%3 > 0 ){
					monsno = (u16)PokeParaGet( &PokeParaMine[0], ID_monsno );
					rnd = (u32)PokeParaGet( &PokeParaMine[0], ID_personal_rnd );
					sex = PokeSexGetMonsNo(monsno,rnd);
					//ِ𔭐
					if (sex == MONS_FEMALE) sex = MONS_MALE;
					else sex = MONS_FEMALE;
					PokeParaSetSexChr(&PokeParaEnemy[0],poke,lv,POW_RND,sex,GetEncountChar(),0);
					return;
				}
			}
		}
	}

	PokeParaSetChr( &PokeParaEnemy[0], poke, lv, POW_RND, GetEncountChar() );
	
}
#endif

#if 0
//----------------------------------------------------
//	莝|Pogp[^ɃZbg
//----------------------------------------------------
void SetMyPokemonToBtlParam(FIELDSYS_WORK * fsys, BATTLE_PARAM * outBattleParam)
{
	POKEPARTY * party;
	party = SaveData_GetTemotiPokemon(fsys->savedata);
	PokeParty_Copy(party, outBattleParam->poke_party[POKEPARTY_MINE]);
}

//----------------------------------------------------
//	|Pp[eB\̂莝|P(Z[uf[^)ɃZbg
//----------------------------------------------------
void SetPokePartyToMyPokemon(FIELDSYS_WORK * fsys, const BATTLE_PARAM * inBattleParam)
{
	POKEPARTY * party;
	party = SaveData_GetTemotiPokemon(fsys->savedata);
	PokeParty_Copy(inBattleParam->poke_party[POKEPARTY_MINE], party);
}

//----------------------------------------------------
//	쐶ogp[^Zbg
//----------------------------------------------------
BATTLE_PARAM *AllocWildBattleParam()
{
	BATTLE_PARAM *param;
	param = sys_AllocMemory(HEAPID_WORLD,sizeof(BATTLE_PARAM));
	param->fight_type = FIGHT_TYPE_YASEI;
	param->poke_party[POKEPARTY_MINE] = PokeParty_AllocPartyWork(HEAPID_WORLD);
	param->poke_party[POKEPARTY_ENEMY] = PokeParty_AllocPartyWork(HEAPID_WORLD);

	return param;
}

//----------------------------------------------------
//	֐
//----------------------------------------------------
void DeleteBattleParam(BATTLE_PARAM *outBattleParam, const int inType )
{
	//퓬`ɂ蕪
	if (inType == FIGHT_TYPE_YASEI){
		sys_FreeMemoryEz(outBattleParam->poke_party[POKEPARTY_MINE]);
		sys_FreeMemoryEz(outBattleParam->poke_party[POKEPARTY_ENEMY]);
	}
	sys_FreeMemoryEz(outBattleParam);
}
#endif

//====================================================
//	GJEgf[^Zbg
//====================================================
#if 0
//----------------------------------------------------
//	m[}
//	   : ENCOUNT_DATA * inData = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 sp_check       = `FbN
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
BOOL SetEncountData(	const ENCOUNT_DATA * inData,
						const u8 id,
						const u8 sp_check,
						BATTLE_PARAM *outBattleParam)
{
	u8 result;
	u8	no = 0;
	u8	lv = 0;
	
	// GJEg|P
	switch( id ){
	case GROUND_ENCOUNT:	// n
		no = RandamPokeSet();
		break;
	case WATER_ENCOUNT:		// 
		no = RandamPokeSetNoGround();
		break;
	case ROCK_ENCOUNT:		// ӂ
		no = RandamPokeSetNoGround();
	}

	lv = inData->NormalEnc[no].Level;	// Lvݒ
/**	
	// Xv[`FbN
	if( ( sp_check & SP_CHK_SPRAY ) != 0 ){
		// Xv[Lv̒Ⴂ|P̓GJEgȂ
		if( SprayEncountCheck( lv ) == FALSE ){
			return FALSE;
		}
	}
*/
/**	
	//og`[uGJEg̏ꍇ͌Ŕ肷
	if ( NowMap.screen_id != MAPSCRNID_TUBE01_6 ){	//og`[uGJEg
		// `FbN
		if( ( sp_check & SP_CHK_SPA ) != 0 ){
			if( CheckEcntCancelByLv( lv ) == FALSE ){
				return FALSE;
			}
		}
	}
*/	
	// GJEg|PZbg
	EncountParamSet( inData->NormalEnc[no].MonsterNo, lv, outBattleParam );

	return	TRUE;
}
#else
//----------------------------------------------------
//	m[}
//	   : ENCOUNT_DATA * inData = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 sp_check       = `FbN
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
BOOL SetEncountData(	const POKEPARTY *inMyParty,
						const GROUND_ENC_MONSTER_DAT * inData,
						const u8 id,
						const u8 sp_check,
						const int inTarget,
						BATTLE_PARAM *outBattleParam,
						u8 *outMonsTblNo)
{
	GROUND_ENC_MONSTER_DAT * ground_data;
	NON_GROUND_ENC_MONSTER_DAT *water_data;
	
	u8 result;
	u8	no = 0;
	u8	lv = 0;
	
	// GJEg|P
	switch( id ){
	case GROUND_ENCOUNT:	// n
		ground_data = (GROUND_ENC_MONSTER_DAT *)inData;
		//傭ɂA͂˃^CṽGJEǧ
		result = CheckFixTypeEcnt(inMyParty,inData,METAL_TYPE,TOKUSYU_ZIRYOKU, &no);
		if (result == FALSE){
			//ł񂫓ɂAł񂫃^CṽGJEǧ
			result = CheckFixTypeEcnt(inMyParty,inData,ELECTRIC_TYPE,TOKUSYU_SEIDENKI, &no);
			if (result == FALSE){
				//ɂw^CvƂ̃GJEgɎsBʏ̃GJEg
				no = RandamPokeSet();
			}
		}
		break;
	case WATER_ENCOUNT:		// 
		no = RandamPokeSetNoGround();
		break;
	}

	lv = inData[no].Level;	// Lvݒ
/**	
	// Xv[`FbN
	if( ( sp_check & SP_CHK_SPRAY ) != 0 ){
		// Xv[Lv̒Ⴂ|P̓GJEgȂ
		if( SprayEncountCheck( lv ) == FALSE ){
			return FALSE;
		}
	}
*/
/**	
	//og`[uGJEg̏ꍇ͌Ŕ肷
	if ( NowMap.screen_id != MAPSCRNID_TUBE01_6 ){	//og`[uGJEg
		// `FbN
		if( ( sp_check & SP_CHK_SPA ) != 0 ){
			if( CheckEcntCancelByLv( lv ) == FALSE ){
				return FALSE;
			}
		}
	}
*/	
	// GJEg|PZbg
	EncountParamSet( inData[no].MonsterNo, lv, inTarget, outBattleParam );
	*outMonsTblNo = no;
	return	TRUE;
}
#endif
//----------------------------------------------------
//	m[}
//	   : ENCOUNT_DATA * inData = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 tbl_no       = wGJEg|Pe[uԍ
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
BOOL SetEncountDataDesideMons(	const GROUND_ENC_MONSTER_DAT * inData,
								const u8 id,
								const u8 tbl_no,
								const int inTarget,
								BATTLE_PARAM *outBattleParam)
{
	u8 result;
	u8	lv = 0;
	
	// GJEg|P
	switch( id ){
	case GROUND_ENCOUNT:	// n
		break;
	case WATER_ENCOUNT:		// 
		break;
	}

	lv = inData[tbl_no].Level;	// Lvݒ
	
	// GJEg|PZbg
	EncountParamSet( inData[tbl_no].MonsterNo, lv, inTarget, outBattleParam );

	return	TRUE;
}

//----------------------------------------------------
//	m[}
//	   : ENCOUNT_DATA * inData = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 sp_check       = `FbN
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
void SetHoneyTreeEncountData(FIELDSYS_WORK *fsys, BATTLE_PARAM *outBattleParam)
{
	int monsno;
	monsno = HTE_GetHoneyTreeMonster(fsys);
	EncountParamSet( monsno, 10, POKEPARTY_ENEMY, outBattleParam );
	return;
}

//----------------------------------------------------
//	쐶
//	   : ENCOUNT_DATA * inData = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 sp_check       = `FbN
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
void SetWildEncountData(FIELDSYS_WORK *fsys, u16 monsno, u8 level,BATTLE_PARAM *outBattleParam)
{
	EncountParamSet( monsno, level, POKEPARTY_ENEMY, outBattleParam );
	return;
}

//----------------------------------------------------
//	m[}
//	   : ENCOUNT_DATA * inData = GJEgf[^
//			 u8 id             = GJEgn`
//			 u8 sp_check       = `FbN
//	߂l : TRUE = ENCOUNT@FALSE = NOT ENCOUNT
//----------------------------------------------------
BOOL DebugSetEncountData(	const ENCOUNT_DATA * inData,
							const u8 id,
							const u8 sp_check,
							BATTLE_PARAM *outBattleParam)
{
#if 0	
	u8 result;
	u8	no = 0;
	u8	lv = 0;
	
	// GJEg|P
	switch( id ){
	case GROUND_ENCOUNT:	// n
		no = RandamPokeSet();
		break;
	case WATER_ENCOUNT:		// 
		no = RandamPokeSetNoGround();
		break;
	case ROCK_ENCOUNT:		// ӂ
		no = RandamPokeSetNoGround();
	}

	lv = inData->NormalEnc[no].Level;	// Lvݒ
/**	
	// Xv[`FbN
	if( ( sp_check & SP_CHK_SPRAY ) != 0 ){
		// Xv[Lv̒Ⴂ|P̓GJEgȂ
		if( SprayEncountCheck( lv ) == FALSE ){
			return FALSE;
		}
	}
*/
/**	
	//og`[uGJEg̏ꍇ͌Ŕ肷
	if ( NowMap.screen_id != MAPSCRNID_TUBE01_6 ){	//og`[uGJEg
		// `FbN
		if( ( sp_check & SP_CHK_SPA ) != 0 ){
			if( CheckEcntCancelByLv( lv ) == FALSE ){
				return FALSE;
			}
		}
	}
*/	
	// GJEg|PZbg
	EncountParamSet( inData->NormalEnc[no].MonsterNo, lv, outBattleParam );
#endif
	EncountParamSet( 1, 10, POKEPARTY_ENEMY, outBattleParam );

	return	TRUE;
}

//nGJEgԂ
static int GetEncountProbGround(FIELDSYS_WORK * fsys)
{
	ENCOUNT_DATA *data;
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
	return data->EncProbGround;
}

//̃GJEgԂ
static int GetEncountProbWater(FIELDSYS_WORK * fsys)
{
	ENCOUNT_DATA *data;
	data = (ENCOUNT_DATA*)EventData_GetEncountData(fsys);
	return data->EncProbSea;
}

#include "system/gamedata.h"			//POKE_NUM_MAX
#include "zonedata.h"					//ZoneData_GetEncountFlag
//tB[hp̃|Pio[擾()
int GetEncMonsNumber(FIELDSYS_WORK * fsys)
{
	int i;
#if 0
	//Ƃ肠nGJEĝ
	i = gf_rand()%ENC_MONS_NUM_NORMAL;
	return R201Enc.NormalEnc[i].MonsterNo;
#else
	//dl܂Ȃ̂ŁA_ȃ|Pio[Ԃ

	//GJEg}bv`FbN
	if( ZoneData_GetEncountFlag(fsys->location->zone_id) == FALSE ){
		return 0;
	}

	i = gf_rand()%POKE_NUM_MAX;
	return i;
#endif
}

//----------------------------------------------------
//@w^Cṽ|PƃGJEg
//	TRUE = ENCOUNT : FALSE = NOT ENCOUNT
//----------------------------------------------------
static u8 FixPokeSet(const GROUND_ENC_MONSTER_DAT * inData, const u8 type, u8 * outNo)
{
	u8 same_type[ENC_MONS_NUM_NORMAL];	//w肵^CvƓ^Cṽ|P̃GJEgXg
	u8 cnt;				//Gg[
	u8 i;
	u8 type1,type2;
	//
	for (i=0;i<ENC_MONS_NUM_NORMAL;i++){
		same_type[i] = 0;
	}
	cnt = 0;
	
	//w^CvƃGJEgXg̃|P̃^Cvr
	for (i=0;i<ENC_MONS_NUM_NORMAL;i++){
		type1 = PokePersonalParaGet( inData[i].MonsterNo, ID_PER_type1 );
		type2 = PokePersonalParaGet( inData[i].MonsterNo, ID_PER_type2 );
		if ( (type1 == type)||(type2 == type) ){
			//^CvȂ烊XgɃGg[
			same_type[cnt++] = i; 
		}
	}
	//GJEgXgɎw^CvȂÁAXg͑SĎw^CvȂ畁ʂɃGJEg
	if ( (cnt == 0)||(cnt==ENC_MONS_NUM_NORMAL) ){
		return FALSE;
	}
	*outNo = same_type[gf_rand()%cnt];//w^Cṽ|Po(m)
	return TRUE;
}

//----------------------------------------------------
//@ɂw^Cṽ|PƂ̃GJEg
//	TRUE = ENCOUNT : FALSE = NOT ENCOUNT
//----------------------------------------------------
static u8 CheckFixTypeEcnt(	const POKEPARTY *inMyParty,
							const GROUND_ENC_MONSTER_DAT * inData,
							const u8 type, const u8 tokusei,u8 * outNo)
{
	u8 spa;
	POKEMON_PARAM *param;
	param = PokeParty_GetMemberPointer(inMyParty, 0);	//擪|P擾
	// 擪̃|P^}SłȂ
	if( PokeParaGet( param, ID_PARA_tamago_flag, NULL ) == 0 ){
		spa = PokeSpeAbiNoGet( param );	// \͎擾
		if( spa == tokusei ){
			// 1/2œ
			if( gf_rand()%2 == 0 ){
				return FixPokeSet(inData, type,outNo);
			}
		}
	}
	//Ȃ
	return FALSE;
}

