//******************************************************************************
/**
 * 
 * @file	eoa.c
 * @brief	GtFNgIuWFNgAN^[
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "eoa.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
//	EOAXe[^Xrbg
//--------------------------------------------------------------
#define EOA_STA_BIT_NON (0)									///<
#define EOA_STA_BIT_USE (1<<0)								///<gp

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	EOA\
//--------------------------------------------------------------
typedef struct _TAG_EOA
{
	u32 status_bit;
	int add_param;
	int answer;
	const void *add_ptr;
	TCB_PTR tcb;
	CONST_EOA_SYS_PTR es;
	int x;
	int y;
	int z;
	VecFx32 matrix;
	
	u8 work[EOA_LOCAL_WORK_SIZE];
	
	EOA_PROC_INIT proc_init;
	EOA_PROC_MOVE proc_move;
	EOA_PROC_DRAW proc_draw;
	EOA_PROC_DEL  proc_del;
	EOA_PROC_PUSH proc_push;
	EOA_PROC_POP  proc_pop;
}EOA;

#define EOA_SIZE (sizeof(EOA))	///<EOATCY

//--------------------------------------------------------------
///	EOA_SYS\
//--------------------------------------------------------------
typedef struct _TAG_EOA_SYS
{
	int max;
	int heap_id;
	EOA_PTR eoa;
}EOA_SYS;

#define EOA_SYS_SIZE (sizeof(EOA_SYS))	///<EOA_SYSTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static TCB_PTR eoa_MoveProcTCBAdd( EOA_PTR eoa, int pri );
static void eoa_MoveProcTCB( TCB_PTR tcb, void *wk );

static EOA_SYS_PTR eoa_SysAllocMemory( int heap_id );
static void eoa_SysFreeMemory( EOA_SYS_PTR es );
static EOA_PTR eoa_AllocMemory( int heap_id, int max );
static void eoa_FreeMemory( EOA_SYS_PTR es );
static void eoa_Clear( EOA_PTR eoa );

static int eoa_SysEoaMaxGet( CONST_EOA_SYS_PTR es );
static EOA_PTR eoa_SysEoaGet( CONST_EOA_SYS_PTR es );

static void eoa_StatusBit_UseSet( EOA_PTR eoa );
static void eoa_StatusBit_Set( EOA_PTR eoa, u32 bit );
static void eoa_AddParamSet( EOA_PTR eoa, int prm );
static void eoa_AddPtrSet( EOA_PTR eoa, const void *ptr );
static void eoa_TCBSet( EOA_PTR eoa, TCB_PTR tcb );
static TCB_PTR eoa_TCBGet( EOA_PTR eoa );
static void eoa_EoaSysSet( EOA_PTR eoa, CONST_EOA_SYS_PTR es );

//==============================================================================
//	eoa	VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * EOA
 * @param	heap_id		EOA[NɎgpq[vID
 * @param	max			EOAő吔
 * @retval	EOA_SYS_PTR	ǉꂽEOA_SYS_PTR
 */
//--------------------------------------------------------------
EOA_SYS_PTR EOA_SysInit( int heap_id, int max )
{
	EOA_SYS_PTR es;
	
	es = eoa_SysAllocMemory( heap_id );
	es->eoa = eoa_AllocMemory( heap_id, max );
	
	es->max = max;
	es->heap_id = heap_id;
	
	return( es );
}

//--------------------------------------------------------------
/**
 * EOAVXe폜
 * @param	es		EOA_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_SysDelete( EOA_SYS_PTR es )
{
	eoa_FreeMemory( es );
	eoa_SysFreeMemory( es );
}

//--------------------------------------------------------------
/**
 * EOAS폜&EOAVXe폜
 * @param	es		EOA_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_SysDeleteAll( EOA_SYS_PTR es )
{
	EOA_DeleteAll( es );
	EOA_SysDelete( es );
}

//==============================================================================
//	eoa	ǉ폜
//==============================================================================
//--------------------------------------------------------------
/**
 * EOAǉ
 * @param	es			EOA_SYS_PTR
 * @param	EOA_H		ǉ񂪓Z߂ꂽEOA_H
 * @param	mtx			ʒu
 * @param	prm			ǉEOA֎w肷p^
 * @param	ptr			ǉEOA֎w肷|C^
 * @param	pri			ǉEOA̓vCIeB
 * @retval	EOA_PTR		ǉꂽEOA_PTR NULL=ǉs
 */
//--------------------------------------------------------------
EOA_PTR EOA_Add( EOA_SYS_PTR es, const EOA_H *head,
		const VecFx32 *mtx, int prm, const void *ptr, int pri )
{
	int i,max;
	EOA_PTR eoa;
	
	i = 0;
	max = eoa_SysEoaMaxGet( es );
	eoa = eoa_SysEoaGet( es );
	
	do{
		if( EOA_StatusBit_UseCheck(eoa) == FALSE ){
			break;
		}
		
		i++;
		eoa++;
	}while( i < max );
	
	if( i >= max ){
		return( NULL );
	}
	
	eoa_StatusBit_UseSet( eoa );
	eoa_AddParamSet( eoa, prm );
	eoa_AddPtrSet( eoa, ptr );
	eoa_EoaSysSet( eoa, es );
	EOA_MatrixSet( eoa, mtx );
	EOA_LocalWorkInit( eoa, head->work_size );
	
	EOA_InitProcSet( eoa, head->proc_init );
	EOA_DeleteProcSet( eoa, head->proc_del );
	EOA_MoveProcSet( eoa, head->proc_move );
	EOA_DrawProcSet( eoa, head->proc_draw );
	EOA_PushProcSet( eoa, head->proc_push );
	EOA_PopProcSet( eoa, head->proc_pop );
	
	if( EOA_InitProcCall(eoa) == FALSE ){
		eoa_Clear( eoa );
		return( NULL );
	}
	
	eoa_TCBSet( eoa, eoa_MoveProcTCBAdd(eoa,pri) );
	
	return( eoa );
}

//--------------------------------------------------------------
/**
 * EOAǉ EOA_H_NPP^ ޔAA֐̓_~[֐ɂȂ
 * @param	es			EOA_SYS_PTR
 * @param	EOA_H_NPP	ǉ񂪓Z߂ꂽEOA_H_NPP
 * @param	mtx			ʒu
 * @param	prm			ǉEOA֎w肷p^
 * @param	ptr			ǉEOA֎w肷|C^
 * @param	pri			ǉEOA̓vCIeB
 * @retval	EOA_PTR		ǉꂽEOA_PTR NULL=ǉs
 */
//--------------------------------------------------------------
EOA_PTR EOA_Add_NPP( EOA_SYS_PTR es, const EOA_H_NPP *head,
		const VecFx32 *mtx, int prm, const void *ptr, int pri )
{
	EOA_H eh;
	
	*(EOA_H_NPP *)&eh = *head;
	eh.proc_push = EOA_PushProcDummy;
	eh.proc_pop = EOA_PopProcDummy;
	
	return( EOA_Add(es,&eh,mtx,prm,ptr,pri) );
}

//--------------------------------------------------------------
/**
 * EOA폜
 * @param	eoa			폜EOA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_Delete( EOA_PTR eoa )
{
	GF_ASSERT( eoa != NULL && "EOA_Delete()eoa==NULLn܂" );
	
	EOA_DeleteProcCall( eoa );
	TCB_Delete( eoa_TCBGet(eoa) );
	eoa_Clear( eoa );
}

//--------------------------------------------------------------
/**
 * ĂSĂEOAɍ폜
 * @param	es		EOA_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_DeleteAll( EOA_SYS_PTR es )
{
	int max;
	EOA_PTR eoa;
	
	max = eoa_SysEoaMaxGet( es );
	eoa = eoa_SysEoaGet( es );
	
	do{
		if( EOA_StatusBit_UseCheck(eoa) == TRUE ){
			EOA_Delete( eoa );
		}
		
		eoa++; max--;
	}while( max );
}

//==============================================================================
//	eoa `
//==============================================================================
//--------------------------------------------------------------
/**
 * EOA `֐Ăяo
 * @param	es		EOA_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_SysDraw( EOA_SYS_PTR es )
{
	int max;
	EOA_PTR eoa;
	
	max = eoa_SysEoaMaxGet( es );
	eoa = eoa_SysEoaGet( es );
	
	do{
		if( EOA_StatusBit_UseCheck(eoa) == TRUE ){
			EOA_DrawProcCall( eoa );
		}
		
		eoa++;
		max--;
	}while( max );
}

//==============================================================================
//	eoa	TCB
//==============================================================================
//--------------------------------------------------------------
/**
 * EOA TCB֐Zbg
 * @param	eoa		EOA_PTR
 * @param	pri		TCBvCIeB
 * @retval	nothing
 */
//--------------------------------------------------------------
static TCB_PTR eoa_MoveProcTCBAdd( EOA_PTR eoa, int pri )
{
	TCB_PTR tcb;
	
	tcb = TCB_Add( eoa_MoveProcTCB, eoa, pri );
	GF_ASSERT( tcb != NULL && "eoa_MoveProcTCBAdd TCBt" );
	
	return( tcb );
}

//--------------------------------------------------------------
/**
 * EOA TCB֐
 * @param	tcb	TCB_PTR
 * @param	wk	tcb work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_MoveProcTCB( TCB_PTR tcb, void *wk )
{
	EOA_PTR eoa;
	
	eoa = wk;
	EOA_MoveProcCall( eoa );
}

//==============================================================================
//	eoa	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * EOAVXem
 * @param	heap_id			HEAP ID
 * @retval	EOA_SYS_PTR		mۂEOA_SYS_PTR
 */
//--------------------------------------------------------------
static EOA_SYS_PTR eoa_SysAllocMemory( int heap_id )
{
	EOA_SYS_PTR es;
	
	es = sys_AllocMemory( heap_id, EOA_SYS_SIZE );
	GF_ASSERT( es != NULL && "eoa_SysAllocMemorymۃG[" );
	
	memset( es, 0, EOA_SYS_SIZE );
	return( es );
}

//--------------------------------------------------------------
/**
 * EOAVXeJ
 * @param	es			EOA_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_SysFreeMemory( EOA_SYS_PTR es )
{
	sys_FreeMemory( es->heap_id, es );
}

//--------------------------------------------------------------
/**
 * EOAm
 * @param	heap_id		HEAP ID
 * @param	max			EOAő吔
 * @retval	eoa			mۂEOA_PTR
 */
//--------------------------------------------------------------
static EOA_PTR eoa_AllocMemory( int heap_id, int max )
{
	EOA_PTR eoa;
	
	max *= EOA_SIZE;
	eoa = sys_AllocMemory( heap_id, max );
	GF_ASSERT( eoa != NULL && "eoa_AllocMemorymۃG[" );
	
	memset( eoa, 0, max );
	return( eoa );
}

//--------------------------------------------------------------
/**
 * EOAJ
 * @param	es			EOA_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_FreeMemory( EOA_SYS_PTR es )
{
	sys_FreeMemory( es->heap_id, es->eoa );
}

//--------------------------------------------------------------
/**
 * EOANA
 * @param	eoa			EOA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_Clear( EOA_PTR eoa )
{
	memset( eoa, 0, EOA_SIZE );
}

//==============================================================================
//	EOA_SYSQ
//==============================================================================
//--------------------------------------------------------------
/**
 * EOAő吔擾
 * @param	es		EOA_SYS_PTR
 * @retval	int		ő吔
 */
//--------------------------------------------------------------
static int eoa_SysEoaMaxGet( CONST_EOA_SYS_PTR es )
{
	return( es->max );
}

//--------------------------------------------------------------
/**
 * EOA[N|C^擾
 * @param	es		EOA_SYS_PTR
 * @retval	EOA_PTR	EOA_PTR
 */
//--------------------------------------------------------------
static EOA_PTR eoa_SysEoaGet( CONST_EOA_SYS_PTR es )
{
	return( es->eoa );
}

//==============================================================================
//	eoa	Q
//==============================================================================
//--------------------------------------------------------------
/**
 * eoa gp`FbN
 * @param	eoa		EOA_PTR
 * @retval	int		TRUE=gpBFALSE=gp
 */
//--------------------------------------------------------------
int EOA_StatusBit_UseCheck( CONST_EOA_PTR eoa )
{
	if( (eoa->status_bit & EOA_STA_BIT_USE) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * eoa Xe[^Xrbg@gpZbg
 * @param	eoa		EOA_PTR
 * @retval	int		TRUE=gpBFALSE=gp
 */
//--------------------------------------------------------------
static void eoa_StatusBit_UseSet( EOA_PTR eoa )
{
	eoa->status_bit |= EOA_STA_BIT_USE;
}

//--------------------------------------------------------------
/**
 * eoa Xe[^Xrbg@Zbg
 * @param	eoa		EOA_PTR
 * @param	bit		EOA_STA_BIT_NON
 * @retval	int		TRUE=gpBFALSE=gp
 */
//--------------------------------------------------------------
static void eoa_StatusBit_Set( EOA_PTR eoa, u32 bit )
{
	eoa->status_bit = bit;
}

//--------------------------------------------------------------
/**
 * ֐Zbg
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_INIT
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_InitProcSet( EOA_PTR eoa, EOA_PROC_INIT proc )
{
	eoa->proc_init = proc;
}

//--------------------------------------------------------------
/**
 * ֐Ăяo
 * @param	eoa		EOA_PTR
 * @retval	int		TRUE=평@FALSE=s
 */
//--------------------------------------------------------------
int EOA_InitProcCall( EOA_PTR eoa )
{
	void *work = EOA_LocalWorkGet( eoa );
	return( eoa->proc_init(eoa,work) );
}

//--------------------------------------------------------------
/**
 * ֐Zbg
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_MOVE
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_MoveProcSet( EOA_PTR eoa, EOA_PROC_MOVE proc )
{
	eoa->proc_move = proc;
}

//--------------------------------------------------------------
/**
 * ֐Ăяo
 * @param	eoa		EOA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_MoveProcCall( EOA_PTR eoa )
{
	void *work = EOA_LocalWorkGet( eoa );
	eoa->proc_move( eoa, work );
}

//--------------------------------------------------------------
/**
 * `֐Zbg
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_MOVE
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_DrawProcSet( EOA_PTR eoa, EOA_PROC_DRAW proc )
{
	eoa->proc_draw = proc;
}

//--------------------------------------------------------------
/**
 * `֐Ăяo
 * @param	eoa		EOA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_DrawProcCall( EOA_PTR eoa )
{
	void *work = EOA_LocalWorkGet( eoa );
	eoa->proc_draw( eoa, work );
}

//--------------------------------------------------------------
/**
 * 폜֐Zbg
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_DEL
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_DeleteProcSet( EOA_PTR eoa, EOA_PROC_DEL proc )
{
	eoa->proc_del = proc;
}

//--------------------------------------------------------------
/**
 * 폜֐Ăяo
 * @param	eoa		EOA_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_DeleteProcCall( EOA_PTR eoa )
{
	void *work = EOA_LocalWorkGet( eoa );
	eoa->proc_del( eoa, work );
}

//--------------------------------------------------------------
/**
 * ޔ֐Zbg
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_PUSH
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_PushProcSet( EOA_PTR eoa, EOA_PROC_PUSH proc )
{
	eoa->proc_push = proc;
}

//--------------------------------------------------------------
/**
 * ޔ֐Ăяo
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_PUSH
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_PushProcCall( EOA_PTR eoa )
{
	void *work = EOA_LocalWorkGet( eoa );
	eoa->proc_push( eoa, work );
}

//--------------------------------------------------------------
/**
 * A֐Zbg
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_POP
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_PopProcSet( EOA_PTR eoa, EOA_PROC_POP proc )
{
	eoa->proc_pop = proc;
}

//--------------------------------------------------------------
/**
 * ޔ֐Ăяo
 * @param	eoa		EOA_PTR
 * @param	proc	EOA_PROC_POP
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_PopProcCall( EOA_PTR eoa )
{
	void *work = EOA_LocalWorkGet( eoa );
	eoa->proc_pop( eoa, work );
}

//--------------------------------------------------------------
/**
 * [J[N擾
 * @param	eoa		EOA_PTR
 * @retval	void*	[N*
 */
//--------------------------------------------------------------
void * EOA_LocalWorkGet( EOA_PTR eoa )
{
	return( eoa->work );
}

//--------------------------------------------------------------
/**
 * [J[N
 * @param	eoa		EOA_PTR
 * @param	size	TCY@EOA_LOCAL_WORK_SIZEȏ=ASSERT
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_LocalWorkInit( EOA_PTR eoa, int size )
{
	void *work;
	
	GF_ASSERT( size <= EOA_LOCAL_WORK_SIZE && "EOA [NTCYI[o[" );
	
	work = EOA_LocalWorkGet( eoa );
	memset( work, 0, size );
}

//--------------------------------------------------------------
/**
 * ǉwp^Zbg
 * @param	eoa		EOA_PTR
 * @param	prm		p^
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_AddParamSet( EOA_PTR eoa, int prm )
{
	eoa->add_param = prm;
}

//--------------------------------------------------------------
/**
 * ǉwp^擾 
 * @param	eoa		EOA_PTR
 * @retval	int		EOA_Add()Ɏw肳ꂽp^
 */
//--------------------------------------------------------------
int EOA_AddParamGet( CONST_EOA_PTR eoa )
{
	return( eoa->add_param );
}

//--------------------------------------------------------------
/**
 * ǉw|C^Zbg
 * @param	eoa		EOA_PTR
 * @param	ptr		|C^
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_AddPtrSet( EOA_PTR eoa, const void *ptr )
{
	eoa->add_ptr = ptr;
}

//--------------------------------------------------------------
/**
 * ǉw|C^擾
 * @param	eoa		EOA_PTR
 * @retval	void*	EOA_Add()Ɏw肳ꂽ|C^
 */
//--------------------------------------------------------------
const void * EOA_AddPtrGet( CONST_EOA_PTR eoa )
{
	return( eoa->add_ptr );
}

//--------------------------------------------------------------
/**
 * 񓚃Zbg
 * @param	eoa			EOA_PTR
 * @param	answer		
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_AnswerSet( EOA_PTR eoa, int answer )
{
	eoa->answer = answer;
}

//--------------------------------------------------------------
/**
 * 񓚎擾
 * @param	eoa			EOA_PTR
 * @retval	int			
 */
//--------------------------------------------------------------
int EOA_AnswerGet( CONST_EOA_PTR eoa )
{
	return( eoa->answer );
}

//--------------------------------------------------------------
/**
 * tcb|C^Zbg
 * @param	eoa			EOA_PTR
 * @param	tcb			TCB_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_TCBSet( EOA_PTR eoa, TCB_PTR tcb )
{
	eoa->tcb = tcb;
}

//--------------------------------------------------------------
/**
 * tcb|C^擾
 * @param	eoa			EOA_PTR
 * @retval	tcb			TCB_PTR
 */
//--------------------------------------------------------------
static TCB_PTR eoa_TCBGet( EOA_PTR eoa )
{
	return( eoa->tcb );
}

//--------------------------------------------------------------
/**
 * EOA_SYS_PTRZbg
 * @param	eoa		EOA_PTR
 * @param	es		EOA_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void eoa_EoaSysSet( EOA_PTR eoa, CONST_EOA_SYS_PTR es )
{
	eoa->es = es;
}

//--------------------------------------------------------------
/**
 * EOA_SYS_PTR擾
 * @param	eoa		EOA_PTR
 * @retval	es		EOA_SYS_PTR
 */
//--------------------------------------------------------------
CONST_EOA_SYS_PTR EOA_EoaSysGet( EOA_PTR eoa )
{
	return( eoa->es );
}

//--------------------------------------------------------------
/**
 * XWZbg
 * @param	eoa		EOA_PTR
 * @param	x		W
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_XSet( EOA_PTR eoa, int x )
{
	eoa->x = x;
}

//--------------------------------------------------------------
/**
 * XW擾
 * @param	eoa		EOA_PTR
 * @retval	int		W
 */
//--------------------------------------------------------------
int EOA_XGet( EOA_PTR eoa )
{
	return( eoa->x );
}

//--------------------------------------------------------------
/**
 * YWZbg
 * @param	eoa		EOA_PTR
 * @param	y		W
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_YSet( EOA_PTR eoa, int y )
{
	eoa->y = y;
}

//--------------------------------------------------------------
/**
 * YW擾
 * @param	eoa		EOA_PTR
 * @retval	int		W
 */
//--------------------------------------------------------------
int EOA_YGet( EOA_PTR eoa )
{
	return( eoa->y );
}

//--------------------------------------------------------------
/**
 * ZWZbg
 * @param	eoa		EOA_PTR
 * @param	z		W
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_ZSet( EOA_PTR eoa, int z )
{
	eoa->z = z;
}

//--------------------------------------------------------------
/**
 * ZW擾
 * @param	eoa		EOA_PTR
 * @retval	int		W
 */
//--------------------------------------------------------------
int EOA_ZGet( EOA_PTR eoa )
{
	return( eoa->z );
}

//--------------------------------------------------------------
/**
 * }gNXWZbg
 * @param	eoa		EOA_PTR
 * @param	mtx		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_MatrixSet( EOA_PTR eoa, const VecFx32 *mtx )
{
	eoa->matrix = *mtx;
}

//--------------------------------------------------------------
/**
 * }gNXW擾
 * @param	eoa		EOA_PTR
 * @param	mtx		ZbgW
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_MatrixGet( EOA_PTR eoa, VecFx32 *mtx )
{
	*mtx = eoa->matrix;
}

//==============================================================================
//	_~[֐
//==============================================================================
//--------------------------------------------------------------
/**
 * ֐@_~[
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	int		TRUE
 */
//--------------------------------------------------------------
int EOA_InitProcDummy( EOA_PTR eoa, void *wk )
{
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ֐@_~[
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_MoveProcDummy( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * `֐@_~[
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_DrawProcDummy( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * 폜֐@_~[
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_DeleteProcDummy( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * ޔ֐@_~[
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_PushProcDummy( EOA_PTR eoa, void *wk )
{
}

//--------------------------------------------------------------
/**
 * A֐@_~[
 * @param	eoa		EOA_PTR
 * @param	wk		eoa work *
 * @retval	nothing
 */
//--------------------------------------------------------------
void EOA_PopProcDummy( EOA_PTR eoa, void *wk )
{
}

