//============================================================================================
/**
 * @file	ev_check.c	
 * @bfief	Cxg`FbNVXe
 * @author	Sousuke Tamada
 * @date	01.03.29
 *
 * 05.07.04 Hiroyuki Nakamura
 */
//============================================================================================
#include "common.h"

#include "system/snd_tool.h"
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/clact_tool.h"
#include "fieldsys.h"
#include "field_clact.h"
#include "fld_menu.h"
#include "sxy.h"
#include "script.h"

#define EV_CHECK_H_GLOBAL
#include "ev_check.h"
#include "eventdata.h"		//][̃Cxgf[^QƂ̂

#include "fld_debug.h"

#include "field_event.h"
#include "field_encount.h"

#include "ev_mapchange.h"

#include "script.h"
#include "zonedata.h"
#include "mapdefine.h"

#include "fieldobj.h"

#include "ev_trainer.h"
#include "communication/communication.h"
#include "comm_command_field.h"
#include "underground/ug_manager.h"
#include "honey_tree_enc.h"

#include "map_attr.h"
#include "ev_pokemon.h"		//EvPoke_Enable2vs2Battle

#include "..\fielddata\script\common_scr_def.h"
#include "..\fielddata\script\hiden_def.h"
#include "..\fielddata\script\bg_attr_def.h"
#include "..\fielddata\script\r201_def.h"

#include "field_3d_anime_ev.h"

#include "map_jump_def.h"
#include "map_jump.h"

#include "situation_local.h"

#include "savedata/zukanwork.h"
#include "field/syswork.h"
#include "field/sysflag.h"

#include "gym.h"

#include "battle\wazano_def.h"

//============================================================================================
//	萔`
//============================================================================================
#define	ALL_KEY		( PAD_KEY_UP | PAD_KEY_DOWN | PAD_KEY_LEFT | PAD_KEY_RIGHT )



//============================================================================================
//
//
//
//============================================================================================
static BOOL EvCheck_ExitByPush(FIELDSYS_WORK * fsys, const EV_REQUEST * req);
static  u16 EvCheck_TalkMapAttr(FIELDSYS_WORK * repw, MATR matr);

static BOOL CheckMoveEvent(FIELDSYS_WORK * fsys);// Ƃ̃CxgN`FbN
static BOOL CheckPosEvent(FIELDSYS_WORK * fsys);
static BOOL CheckExit(FIELDSYS_WORK * fsys, const int x, const int z, const u8 inAttr);


//c[֐
static void GetNowPos(const FIELDSYS_WORK * fsys, int *x, int *z);
static void GetFrontPos(const FIELDSYS_WORK * fsys, int * x, int * z);
static void GetMovePos(const FIELDSYS_WORK * fsys, int dir, int * x, int * z);
static u8 GetNowAttr(const FIELDSYS_WORK * fsys);
static u8 GetFrontAttr(const FIELDSYS_WORK * fsys);

static BOOL GetConnectData(const FIELDSYS_WORK * fsys, int x, int z, LOCATION_WORK * next);

//============================================================================================
//============================================================================================
//--------------------------------------------------------------------------------------------
/**
 * Cxg`FbNNGXg̏
 *
 * @param	req		Cxg`FbNNGXg\
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void ClearRequest( EV_REQUEST * req )
{
	req->TalkCheck  = FALSE;
	req->StepCheck  = FALSE;
	req->MenuOpen   = FALSE;
	req->CnvButton  = FALSE;
	req->MatCheck   = FALSE;
	req->PushCheck  = FALSE;
	req->MoveCheck  = FALSE;
	req->FloatCheck = FALSE;

	req->DebugMenu   = FALSE;
	req->DebugBattle = FALSE;

	req->DebugHook = FALSE;
	req->DebugKeyPush = FALSE;
	
	req->Site = DIR_NOT;
	req->PushSite = DIR_NOT;
}

//--------------------------------------------------------------------------------------------
/**
 * Cxg`FbNNGXg̃Zbg
 *
 * @param	req		Cxg`FbNNGXg\
 * @param	trg		L[gK[
 * @param	cont	L[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void SetRequest( EV_REQUEST * req, FIELDSYS_WORK * repw, u16 trg, u16 cont )
{

	int	st;
	int	val;
	int dir;

	ClearRequest(req);

	st  = Player_MoveStateGet( repw->player );		// @̏
	val = Player_MoveValueGet( repw->player );		// @̈ړ
	dir = Player_DirGet( repw->player );			// @̕

	req->trg = trg;
	req->cont = cont;


	if( st == OBJ_MOVE_STATE_END || st == OBJ_MOVE_STATE_OFF ){
//		if( GetHeroMoveSpeed() != HERO_MOVE_SPEED_MAX ){
			if( trg & PAD_BUTTON_START ){
				req->MenuOpen = TRUE;
			}
			if( trg & PAD_BUTTON_SELECT ){
				req->CnvButton = TRUE;
			}
			if( trg & PAD_BUTTON_A ){
				req->TalkCheck = TRUE;
			}
			if( trg & PAD_BUTTON_B ){
				req->FloatCheck = TRUE;
			}
//		}
		if( cont & ALL_KEY ){
			req->MatCheck = TRUE;
		}
		if( cont & ALL_KEY ){
			req->PushCheck = TRUE;
		}
	}

	if( st == OBJ_MOVE_STATE_END && val == OBJ_MOVE_VALUE_WALK ){
		req->MoveCheck = TRUE;
	}

	// ړI^C~OH
	if (st == OBJ_MOVE_STATE_END) {
		req->StepCheck = TRUE;
	}

	if ((dir == DIR_UP && (cont & PAD_KEY_UP))
			|| ((dir == DIR_DOWN) && (cont & PAD_KEY_DOWN))
			|| ((dir == DIR_LEFT) && (cont & PAD_KEY_LEFT))
			|| ((dir == DIR_RIGHT) && (cont & PAD_KEY_RIGHT))
	   ) {
		req->PushSite = dir;
	} else {
		req->PushSite = DIR_NOT;
	}
	
//㉺D̂Ƃ玩@Ǝ̃L[͊֐ɕύX 060317 kaga
#if 0
	// ړ̃NGXg
	if( cont & PAD_KEY_UP ){
		req->Site = DIR_UP;
	}else if( cont & PAD_KEY_DOWN ){
		req->Site = DIR_DOWN;
	}else if( cont & PAD_KEY_LEFT ){
		req->Site = DIR_LEFT;
	}else if( cont & PAD_KEY_RIGHT ){
		req->Site = DIR_RIGHT;
	}
#else
	req->Site = Player_KeyDirGet( repw->player, trg, cont );
#endif
	
	// ȉ̓fobO@\̔`FbN
#ifdef	PM_DEBUG
	if( cont & PAD_BUTTON_R ){
		req->DebugKeyPush = TRUE;
		
		//R{^ĂƂ͊eCxg̔}
		req->MoveCheck = FALSE;
		req->StepCheck = FALSE;
		req->MatCheck = FALSE;
		req->PushCheck = FALSE;

		if( req->MenuOpen ){
			req->MenuOpen = FALSE;
			req->DebugMenu = TRUE;
		}
	}
	
	if( st == OBJ_MOVE_STATE_END || st == OBJ_MOVE_STATE_OFF ){
		if( cont & PAD_BUTTON_R ){
			// fobOog
			if( cont & PAD_BUTTON_X ){ 
				req->DebugBattle = TRUE;
			}
		}
	}
#endif	// PM_DEBUG

}

//--------------------------------------------------------------------------------------------
/**
 * @breif	ނɓȂCxg`FbN
 * @param	req		NGXg\̂ւ̃|C^
 * @param	fsys	Q[䃏[Nւ̃|C^
 * @retval	TRUE	Cxg
 * @retval	FALSE	CxgȂ
 *
 *
 * R201ł̃CxgpBɂȂLq̊֐Ȃ̂
 * Ƃł܂Ƃȏl
 */
//--------------------------------------------------------------------------------------------
static BOOL GrassStepInCheck(const EV_REQUEST * req, FIELDSYS_WORK * fsys)
{
	int st  = Player_MoveStateGet( fsys->player );		// @̏
	if (fsys->location->zone_id != ZONE_ID_R201) {
		return FALSE;
	}
	if (SysFlag_PairCheck(fsys) == FALSE) {
		return FALSE;
	}
	if (st == OBJ_MOVE_STATE_OFF) {
#if 0	//@̏ԂL[͂lɂ 060317 kaga
		if (req->PushSite != DIR_NOT && MATR_IsGrass(GetFrontAttr(fsys))) {
			return TRUE;
		}
#elif 1
		{
			int val = Player_MoveValueGet( fsys->player );	//@Ԃ擾
			
			if( (s8)req->Site != DIR_NOT &&					//L[Ă
				val == OBJ_MOVE_VALUE_WALK ){				//@̏Ԃ͈ړł
				int x,z;
				GetMovePos( fsys, req->Site, &x, &z );		//ړ̃Agr[g擾
				if (MATR_IsGrass(GetAttributeLSB(fsys, x, z))) {
					return TRUE;
				}
			}else{
				if( (s8)req->PushSite != DIR_NOT &&			//@̌ɃL[Ă
					MATR_IsGrass(GetFrontAttr(fsys))) {		//̐̃Agr[g擾
					return TRUE;
				}
			}
		}
#endif
	} else if (st == OBJ_MOVE_STATE_END) {
		int x, z;
		GetMovePos(fsys, req->Site, &x, &z);
		if (MATR_IsGrass(GetAttributeLSB(fsys, x, z))) {
			return TRUE;
		}
	}
	
	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * CxgN`FbN
 *
 * @param	req		Cxg`FbNNGXg
 *
 * @retval	"TRUE = Cxg"
 * @retval	"FALSE = CxgȂ"
 *
 *	NGXgɃ`FbNvOĂяoACxgN
 */
//--------------------------------------------------------------------------------------------
int CheckRequest(const EV_REQUEST * req, FIELDSYS_WORK * repw)
{

	//ړ`FbN
	if (req->MoveCheck) {
		//IncRecord( CNT_WALK );
		if( CheckMoveEvent( repw ) == TRUE ){
			return TRUE;
		}
		//|W`FbN
		if ( GYM_CheckSteelLift(repw) ){
			return TRUE;
		}
	}
	//ނɓȂCxg`FbN
	if (GrassStepInCheck(req, repw)) {
		EventSet_Script( repw, SCRID_POS_R201_STOP, NULL );
		return TRUE;
	}

	//XNvgiV[NXNvgj`FbN
	if (req->DebugKeyPush == FALSE && SpScriptSearch(repw, SP_SCRID_SCENE_CHANGE) == TRUE) {
		return TRUE;
	}
	
	//@Cxg`FbN
	{
		int dir = Player_KeyDirGet( repw->player, req->trg, req->cont );
		if( Player_EventMoveCheck(repw,repw->player,dir,0) == TRUE ){
			return( TRUE );
		}
	}
	
	//g[i[`FbN
	{
		if( req->DebugKeyPush == FALSE ){
			BOOL flag = EvPoke_Enable2vs2Battle(SaveData_GetTemotiPokemon(repw->savedata));
			if( EvTrainerEyeCheck(repw,flag) == TRUE ){
				return TRUE;
			}
		}
	}
	
	//@`FbNiړ 邢 Uj
	if(req->StepCheck ){
		// GJEg
		if( ZoneData_GetEncountFlag(repw->location->zone_id) &&
			FieldEncount_Check( repw ) == TRUE) {
			return TRUE;
		}

		// Ŕ`FbN
//		if( req->PushCheck ){
		{
			int	id;
			
			id = TalkAutoBoardEventCheck(
					repw,
					(void *)EventData_GetNowBgTalkData( repw ),
					EventData_GetNowBgTalkDataSize( repw ) );

			if( id != EVENT_ID_NONE ){
				EventSet_Script( repw, id, NULL );
				return TRUE;
			}
		}
	}

	// b
	if( req->TalkCheck ){

		{	// OBJƂ̉b`FbN
			FIELD_OBJ_PTR obj;
			if( TalkObjEventCheck( repw, &obj ) == TRUE ){
				EVENT_WORK * ev_work;

				if( Player_MoveForceStopCheck( repw->player ) == TRUE ){
					Player_MoveForceStop( repw->player, Player_DirGet(repw->player) );
				}
				EventSet_Script( repw, FieldOBJ_EventIDGet(obj), obj );
				return TRUE;
			}
		}

		{	// BG̘b`FbN
			int	id;
			
			id = TalkBgEventCheck(
					repw,
					(void *)EventData_GetNowBgTalkData( repw ),
					EventData_GetNowBgTalkDataSize( repw ) );

			if( id != EVENT_ID_NONE ){
				EventSet_Script( repw, id, NULL );
				return TRUE;
			}
		}

		{	// h؃`FbN
			int id;
			if (HTE_CheckHoneyTree(repw,&id)){
				EventSet_Script( repw, id, NULL );
				return TRUE;
			}
		}

		{
			int id;
			id = EvCheck_TalkMapAttr(repw, GetFrontAttr(repw));
			if (id != EVENT_ID_NONE) {
				EventSet_Script(repw, id, NULL);
				return TRUE;
			}

		}

	}

	if (req->PushCheck) {
		if (EvCheck_ExitByPush(repw, req) == TRUE) {
			return TRUE;
		}
	}

	// ȉ́Al̈ʒu֌WȃCxg
	//
	//	֗{^Ȃ΃`FbN͂̂
	if( req->MenuOpen ){
		Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
		{
			u32	menu_ev = 0;

			if( ZukanWork_GetZukanGetFlag(SaveData_GetZukanWork(repw->savedata)) == FALSE ){
				menu_ev |= FLD_MENU_VANISH_ZUKAN;
			}
			if( SysWork_FirstPokeNoGet(repw) == 0 ){
				menu_ev |= FLD_MENU_VANISH_PLIST;
			}
			if( SysFlag_BagCheck(repw) == 0 ){
				menu_ev |= FLD_MENU_VANISH_BAG;
			}
			menu_ev |= FLD_MENU_VANISH_CHAT;
	        FieldMenuInit( repw, &menu_ev );
		}
		return TRUE;
	}
#ifdef	PM_DEBUG
	// 퓬eXg
	if( req->DebugBattle ){
		DebugFieldEncount( repw );	//ŃGJEgZbg
		return TRUE;
	}

	if( req->DebugMenu ){
		Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
		FieldDebugListSet( repw );
		return TRUE;
	}
#endif	PM_DEBUG

	return FALSE;
}

//--------------------------------------------------------------------------------------------
/**
 * ʐMԎ̃CxgN`FbN  by k.ohno
 * @param	req		Cxg`FbNNGXg
 * @retval	"TRUE = Cxg"
 * @retval	"FALSE = CxgȂ"
 */
//--------------------------------------------------------------------------------------------

BOOL CheckRequestComm( EV_REQUEST * req, FIELDSYS_WORK * repw )
{
	// b  bɊւĂ̓NCAgŏ\Ȃ̂ŏƓɂȂ
    // CommPlayer͏
	if( req->TalkCheck ){

		{	// OBJƂ̉b`FbN
			FIELD_OBJ_PTR obj;
			if( TalkObjEventCheck( repw, &obj ) == TRUE ){
				EVENT_WORK * ev_work;
                if(MV_PLAYER != FieldOBJ_MoveCodeGet(obj)){ // ̃v[[̏ꍇ
                    if( Player_MoveForceStopCheck( repw->player ) == TRUE ){
                        Player_MoveForceStop( repw->player, Player_DirGet(repw->player) );
                    }
                    EventSet_Script( repw, FieldOBJ_EventIDGet(obj), obj );
                    return TRUE;
                }
			}
		}

		{	// BG̘b`FbN
			int	id;
			
			id = TalkBgEventCheck(
					repw,
					(void *)EventData_GetNowBgTalkData( repw ),
					EventData_GetNowBgTalkDataSize( repw ) );

			if( id != EVENT_ID_NONE ){
				EventSet_Script( repw, id, NULL );
				return TRUE;
			}
		}
	}

    if(UgManagerIsInitialize()){
        if( req->TalkCheck ){    // b--> Yzpj[
            CommSendFixData(CF_CHECK_ABUTTON_ACTION);
            return FALSE;
        }
        if( req->MenuOpen ){	// l̈ʒu֌WȃCxg
            CommSendFixData(CF_CHECK_FIELDMENU_OPEN);
            return FALSE;
        }
    }
	
#ifdef	PM_DEBUG
	if( req->DebugMenu ){
		Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
		FieldDebugListSet( repw );
		return FALSE;
	}
#endif	PM_DEBUG
	return FALSE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief	jI[pCxgN`FbN
 * @param	req		Cxg`FbNNGXg
 * @param	repw	Q[䃏[Nւ̃|C^
 * @retval	"TRUE = Cxg"
 * @retval	"FALSE = CxgȂ"
 */
//--------------------------------------------------------------------------------------------
BOOL CheckRequestUnion(const EV_REQUEST * req, FIELDSYS_WORK * repw)
{
	//b
	//iǉ\j

	//jI[Cxg`FbNFbiNPCցj
	if( req->TalkCheck ){
		// OBJƂ̉b`FbN
		FIELD_OBJ_PTR obj;
		if( TalkObjEventCheck( repw, &obj ) == TRUE ){
			if( Player_MoveForceStopCheck( repw->player ) == TRUE ){
				Player_MoveForceStop( repw->player, Player_DirGet(repw->player) );
			}
			EventSet_Script( repw, FieldOBJ_EventIDGet(obj), obj );
			return TRUE;
		}
	}

	//jI[Cxg`FbNFo
	if (req->PushCheck) {
		//Pɉ}bg̈ʒuŃL[ł邩ǂ̃`FbN
		if (req->PushSite == DIR_DOWN && MATR_IsDownMat(GetNowAttr(repw))) {
			EventSet_UnionRoomMapChange(repw);
			return TRUE;
		}
	}

	//jI[Cxg`FbNFj[ifobO܂ށj
	//	֗{^Ȃ΃`FbN͂̂
	if( req->MenuOpen ){
		u32	menu_ev = FLD_MENU_VANISH_REPORT;
		Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
	    FieldMenuInit( repw, &menu_ev );
		return TRUE;
	}
#ifdef	PM_DEBUG
	if( req->DebugMenu ){
		Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
		FieldDebugListSet( repw );
		return TRUE;
	}
#endif	PM_DEBUG

	return FALSE;
}




//============================================================================================
//============================================================================================

//------------------------------------------------------------------
/**
 * @brief	CxgN`FbNFoi݁j
 * @param	fsys	Q[䃏[Nւ̃|C^
 * @param	req		NGXg\̂ւ̃|C^
 * @retval	TRUE	CxgN
 * @retval	FALSE	CxgNȂ
 */
//------------------------------------------------------------------
static BOOL EvCheck_ExitByPush(FIELDSYS_WORK * fsys, const EV_REQUEST * req)
{
	int door_id;
	int x;
	int z;
	int dir;
	u8	attr;
	LOCATION_WORK cnct;

	//ݑĂȂꍇA`FbNȂ
	if (req->PushSite == DIR_NOT) {
		return FALSE;
	}

	//isOiss\łȂꍇA`FbN͂Ȃ
	GetFrontPos(fsys, &x, &z);
	if (GetHitAttr(fsys, x, z) == 0) {
		return FALSE;
	}

	//isȌo`FbN
	if (GetConnectData(fsys, x, z, &cnct) && req->PushSite != DIR_NOT) {
		attr = GetAttributeLSB(fsys, x, z);
		if (MATR_IsDoor(attr)) {
			MJUMP_ChangeMap(fsys, cnct.zone_id, cnct.door_id,
							0, 0, req->PushSite, M_JUMP_DOOR);
			return TRUE;
		}
#ifdef	PM_DEBUG
		//2006.03.04
		//́AhAȊOłڑ݂ꍇ͂Ƃ肠Ȃł܂B
		//̂ƃAgr[ĝŔp~\
		EventSet_MapChange(fsys, cnct.zone_id, cnct.door_id,
				0,0, Player_DirGet(fsys->player));
		return TRUE;
#endif
	}

	//݂̑ʒȕo`FbN
	GetNowPos(fsys, &x, &z);

	// }bg`FbN
	attr = GetAttributeLSB( fsys, x, z );
	if( MATR_IsRightMat(attr) ){
		if( req->PushSite != DIR_RIGHT ){
			return FALSE;
		}
	}else if( MATR_IsLeftMat(attr) ){
		if( req->PushSite != DIR_LEFT ){
			return FALSE;
		}
	}else if( MATR_IsUpMat(attr) ){
		if( req->PushSite != DIR_UP ){
			return FALSE;
		}
	}else if( MATR_IsDownMat(attr) ){
		if( req->PushSite != DIR_DOWN ){
			return FALSE;
		}
	}else if( MATR_IsRightStairs(attr) ){	//EKi
		if( req->PushSite != DIR_RIGHT ){
			return FALSE;
		}
	}else if( MATR_IsLeftStairs(attr) ){	//Ki
		if( req->PushSite != DIR_LEFT ){
			return FALSE;
		}
	}




	if (GetConnectData(fsys, x, z, &cnct) == FALSE) {
		return FALSE;
	}


	{
		int type;
		if (MATR_IsDoor(attr)){					//hA
			type = M_JUMP_DOOR;
		}else if(MATR_IsRightStairs(attr)){		//Ki
			type = M_JUMP_STAIRS;
		}else if(MATR_IsLeftStairs(attr)){		//Ki
			type = M_JUMP_STAIRS;
		}else{
			type = M_JUMP_MAT;
		}
		MJUMP_ChangeMap(fsys, cnct.zone_id, cnct.door_id,
						0, 0, req->PushSite, type);
	}
	
	return TRUE;
}



//--------------------------------------------------------------------------------------------
/**
 * @brief	}bvAgr[gbCxg`FbN
 * @param	repw	Q[䃏[Nւ̃|C^
 * @param	matr	}bvAgr[g̒l
 * @retval	EVENT_ID_NONE	
 * @retval	ȊO		XNvgIDw
 */
//--------------------------------------------------------------------------------------------
u16 EvCheck_TalkMapAttr(FIELDSYS_WORK * repw, MATR matr)
{
	if (MATR_IsPC(matr)) {
		return SCRID_PC_ON;
	}else if (MATR_IsLittleBookRack01(matr)) {
		return SCRID_LITTLE_RACK1;
	}else if (MATR_IsLittleBookRack02(matr)) {
		return SCRID_LITTLE_RACK2;
	}else if (MATR_IsBookRack01(matr)) {
		return SCRID_RACK1;
	}else if (MATR_IsBookRack02(matr)) {
		return SCRID_RACK2;
	}else if (MATR_IsTrashBox(matr)) {
		return SCRID_TRASH_BOX;
	}else if (MATR_IsShopBookRack01(matr)) {
		return SCRID_SHOP_RACK1;
	}else if (MATR_IsShopBookRack02(matr)) {
		return SCRID_SHOP_RACK2;
	}else if (MATR_IsShopBookRack03(matr)) {
		return SCRID_SHOP_RACK3;


	}else if (MATR_IsPot(matr)) {
		return SCRID_PC_ON;	//XNvgo܂ŉ
	}else if (MATR_IsBluePrint(matr)) {
		return SCRID_PC_ON;	//XNvgo܂ŉ
	}

#if 1
	{
		int dir = Player_DirGet(repw->player);

		if( Player_EventAttrCheck_KabeNobori(matr,dir) ){
			return SCRID_HIDEN_KABENOBORI;
		}

		if( Player_FormGet(repw->player) != HERO_FORM_SWIM ){
			if( Player_EventAttrCheck_Naminori(matr) ){
				if( EvPoke_CheckWaza(SaveData_GetTemotiPokemon(repw->savedata),
							WAZANO_NAMINORI) != 0xff) {
					return SCRID_HIDEN_NAMINORI;
				}
			}
		}
	}
#endif

	return EVENT_ID_NONE;
}

//-------------------------------------------------------------
/**
 * @brief	Ƃ̃CxgN`FbN
 * @param	fsys	Q[䃏[Nւ̃|C^
 * @param
 * 
 * @retval	BOOL		TRUE:	FALSE:Ȃ
 */
//-------------------------------------------------------------
static BOOL CheckMoveEvent(FIELDSYS_WORK * fsys)
{
	u8	attr;
	int x,z;
	
	x = Player_NowGPosXGet(fsys->player);
	z = Player_NowGPosZGet(fsys->player);
	
	attr = GetAttributeLSB( fsys, x, z );
	
	if ( CheckPosEvent(fsys) == TRUE ) return TRUE;		// WCxg`FbN
	if ( CheckExit( fsys, x, z, attr) == TRUE ) return TRUE;	// o`FbN
///	if ( PosAttrCheck(attr) == TRUE ) return TRUE;		// Agr[g`FbN
///	if ( StepCountCheck(attr) == TRUE ) return TRUE;	// JEg֘A`FbN
///	if ( SprayCheck() == TRUE )	return	TRUE;			// Xv[`FbN

	return FALSE;;
}

//-------------------------------------------------------------
/**
 * @brief	POSCxg`FbN
 * @param	fsys	Q[䃏[Nւ̃|C^
 * 
 * @retval	BOOL		TRUE:	FALSE:Ȃ
 */
//-------------------------------------------------------------
static BOOL CheckPosEvent(FIELDSYS_WORK * fsys)
{
	u16	id;
	id = PosEventCheck(
			fsys,
			(void *)EventData_GetNowPosEventData( fsys ),
			EventData_GetNowPosEventDataSize( fsys ) );
	if( id != EVENT_ID_NONE ){
		EventSet_Script( fsys, id, NULL );
		return TRUE;
	}
	return FALSE;
}

//-------------------------------------------------------------
//	 õ`FbNf[^Zbg
//-------------------------------------------------------------
static BOOL CheckExit(FIELDSYS_WORK * fsys, const int x, const int z, const u8 inAttr)
{
	LOCATION_WORK cnct;

	if (GetConnectData(fsys, x, z, &cnct) == FALSE) {
		return FALSE;
	}
	
	//GXJ[^[
	if( MATR_IsEscalator(inAttr) == TRUE ){
		MJUMP_ChangeMap(fsys, cnct.zone_id, cnct.door_id,
						0, 0, DIR_RIGHT, M_JUMP_ESCA);
		return TRUE;
	}
#ifdef	PM_DEBUG
	//2006.03.04
	//Agr[gȂoꍇAƂ肠Ȃ
	//ŏIIɂ͂̏͑SẴAgr[g낦ΕsvƂȂ
	if (
			MATR_IsLeftStairs(inAttr) ||
			MATR_IsRightStairs(inAttr) ||
			MATR_IsDownMat(inAttr) ||
			MATR_IsUpMat(inAttr) ||
			MATR_IsLeftMat(inAttr) ||
			MATR_IsRightMat(inAttr)) {
		//ɂ̂ĉރ^CṽAgr[g̏ꍇ͖
		return FALSE;
	}
	EventSet_MapChange(fsys, cnct.zone_id, cnct.door_id,
			0,0, Player_DirGet(fsys->player));
	return TRUE;
#endif

/**	
	s8 id;

	id = ExitDataCheck( &NowMap, p );

	if (id != -1 && ExitConditionCheck(attr) == TRUE) {
		SetHeroLastStatus();
		ExitDataSet(&NowMap, id, p);
			
		if( ATR_IsEscalatorCheck(attr) == TRUE )
		{
			//GXJ[^[
			AddMapChangeEscalatorTask( attr );
			return TRUE;
		}
			
		if( ATR_IsGayserCheck(attr) == TRUE )
		{
			//
			AddMapChangeGayserTask();
			return TRUE;
		}

		if( ATR_IsHidePitFallCheck(attr) == TRUE )
		{
			//BƂ
			AddMapChangeHidePitFallTask();
			return TRUE;
		}

		if( ATR_IsWarpCheck(attr) == TRUE )
		{
			//[v|Cg
			AddMapChangeWarpTask();
			return TRUE;
		}

		//ԗ΂ڐA(04.06.12)
		if( ATR_IsWarpOutDoorInCheck(attr) == TRUE )
		{
			AddWarpOutDoorInMapChangeTask();
			return TRUE;
		}

		if( ATR_IsPitFallCheck(attr) == TRUE )
		{
			//Ƃ
			StartFieldScript(ev_fall_script);
			return TRUE;
		}

		if( ATR_IsKeepWarpCheck(attr) == TRUE )	//<<20031219 add
		{
			//OBJʒuێ[v|Cg
			AddMapChangeKeepWarpTask();
			return TRUE;
		}




		AddMapChangeTask();
		return TRUE;
	}
*/	

	return FALSE;
}


//============================================================================================
//
//
//		CxgN`FbNpc[֐
//
//
//============================================================================================
//-------------------------------------------------------------
//-------------------------------------------------------------
static void GetNowPos(const FIELDSYS_WORK * fsys, int *x, int *z)
{
	*x = Player_NowGPosXGet(fsys->player);
	*z = Player_NowGPosZGet(fsys->player);
}

//-------------------------------------------------------------
/**
 */
//-------------------------------------------------------------
static void GetFrontPos(const FIELDSYS_WORK * fsys, int * x, int * z)
{
	int dir;
	dir = Player_DirGet(fsys->player);
	GetMovePos(fsys, dir, x, z);
}

//-------------------------------------------------------------
//-------------------------------------------------------------
static void GetMovePos(const FIELDSYS_WORK * fsys, int dir, int * x, int * z)
{
	GetNowPos(fsys, x, z);
	switch (dir) {
	case DIR_UP:
		*z -= 1;
		break;
	case DIR_DOWN:
		*z += 1;
		break;
	case DIR_LEFT:
		*x -= 1;
		break;
	case DIR_RIGHT:
		*x += 1;
		break;
	default:
		GF_ASSERT_MSG("@̕\n",0);
	}
}

//-------------------------------------------------------------
/**
 */
//-------------------------------------------------------------
static u8 GetNowAttr(const FIELDSYS_WORK * fsys)
{
	int x,z;
	GetNowPos(fsys, &x, &z);
	return GetAttributeLSB(fsys, x, z);
}

//-------------------------------------------------------------
/**
 */
//-------------------------------------------------------------
static u8 GetFrontAttr(const FIELDSYS_WORK * fsys)
{
	int x,z;
	GetFrontPos(fsys, &x, &z);
	return GetAttributeLSB(fsys, x, z);
}


//-------------------------------------------------------------
/**
 * @brief	ڑf[^̎擾
 * @param	fsys		tB[hf[^ւ̃|C^
 * @param	x			ڑf[^TXʒuiObhPʁj
 * @param	z			ڑf[^TYʒuiObhPʁj
 * @retval	CONNECT_DATA	ڑf[^̃AhX
 * @retval	NULL			ڑf[^Ȃꍇ
 */
//-------------------------------------------------------------
static BOOL GetConnectData(const FIELDSYS_WORK * fsys, int x, int z,
		LOCATION_WORK * next)
{
	const CONNECT_DATA * connect;
	int door_id;
	door_id = EventData_SearchNowConnectIDByXZ(fsys, x, z);
	if (door_id == -1) {
		return FALSE;
	}
	connect = EventData_GetNowConnectDataByID(fsys, door_id);
	if (connect == NULL) {
		return FALSE;
	}
	if (connect->link_door_id == SPECIAL_SPEXIT01) {
		GF_ASSERT(connect->link_zone_id == ZONE_ID_SPECIAL);
		*next = *(Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata)));
	} else {
		SetLocation(next, connect->link_zone_id, connect->link_door_id,
				connect->x, connect->z, DIR_DOWN);
	}
	{
		//邱ƂɂȂȍoĂ
		LOCATION_WORK * ent = Situation_GetEntranceLocation(SaveData_GetSituation(fsys->savedata));
		SetLocation(ent, fsys->location->zone_id, door_id, x, z, Player_DirGet(fsys->player));
	}
	return TRUE;
}






//============================================================================================
//============================================================================================
//============================================================================================
//	AGB
//============================================================================================
//============================================================================================
#if 0


//=========================================================================
//
// bɂCxg`FbN
//
//=========================================================================


//-------------------------------------------------------------
//	Cxg`FbNFb
//-------------------------------------------------------------

u8 EventTalkCheck(EV_POS * p, u16 attr, u8 site)
{
	const VM_CODE * ret;

	ret = EvTalkCheck(p,attr,site);
	if (ret == NULL) return FALSE;

	//p\R̎SEȂ
	if ( ret != ev_pasokon1_01_p01_t101_r0102 &&
			ret != ev_pasokon1_01_p01_t101_r0202 &&
			ret != mine_base_board_init &&
			ret != other_base_board &&
			ret != base_dool_script &&
			ret != base_cushion_script &&
			ret != paso_script) {
		SePlay(SE_SELECT);
	}

	StartFieldScript(ret);
	return TRUE;
}


//--------------------------------------------------------------
//
//--------------------------------------------------------------
const VM_CODE * EvTalkCheck(EV_POS * p, u8 attr, u8 site)
{
	const VM_CODE * ret;

	if( (ret = EvObjTalkCheck(p, attr, site) ) != NULL ) return ret;
	if( (ret = EvBGTalkCheck(p, attr, site) ) != NULL ) return ret;
	if( (ret = EvAttrTalkCheck(p, attr, site) ) != NULL ) return ret;
	if( (ret = EvHidenAttrTalkCheck(p, attr, site) ) != NULL ) return ret;
	return NULL;
}


//--------------------------------------------------------------
//
//--------------------------------------------------------------
const VM_CODE * EvObjEasyTalkCheck( EV_POS * p, u8 attr, u8 site )
{
	const VM_CODE * event;
	u8	no;
	int i;

	if ( ATR_IsCounterCheck(GetCellAttribute(p->x,p->y)) == FALSE ) {
		no = EvObjHitCheck( p->x, p->y, p->z );
	} else {
		no = EvObjHitCheck( p->x+SiteVector[site].dx, p->y+SiteVector[site].dy, p->z );
	}
	if( no == EV_OBJ_MAX || EvObjId(no) == EV_OBJ_SPID ) return NULL;

	for ( i=0; i<COMM_PLAYER_MAX; i++ ) {
		if ( Player[i].sw == 1 && Player[i].evobjno == no ) {
			return NULL;
		}
	}

	TargetObjNo = no;
	TargetObjID = EvObjId(no);
	TalkSiteWork = site;
	event = EvObjNoEvLabelGet(no);
	return event;
}



const VM_CODE * EvObjTalkCheck(EV_POS * p, u8 attr, u8 site)
{
	const VM_CODE * event;
	u8	no;

	no = EvObjHitCheck( p->x, p->y, p->z );
	if ( no == EV_OBJ_MAX || EvObjId(no) == EV_OBJ_SPID ) {
		if ( ATR_IsCounterCheck(attr) != TRUE ) return NULL;
		no = EvObjHitCheck( p->x + SiteVector[site].dx,
				p->y + SiteVector[site].dy, p->z );
		if(no == EV_OBJ_MAX || EvObjId(no) == EV_OBJ_SPID ) return NULL;
	}

	TargetObjNo = no;
	TargetObjID = EvObjId(no);
	TalkSiteWork = site;

	if (CheckTrainerHillMap()==TRUE){
		event = GetHillLabel();
	}else{
		event = EvObjNoEvLabelGet(no);					//Cxgx擾
	}
	event = ExScriptObjCheck(TargetObjID,event);	//OXNvg`FbN
	return event;
}




//=========================================================================
//
// ړƂ̃Cxg`FbN
//
//=========================================================================

//-------------------------------------------------------------
//	ړɂCxg`FbNFJEg֘A
//-------------------------------------------------------------
extern const VM_CODE ev_sodateya_tamago_huka[];
extern const VM_CODE ev_poison_dead[];

u8 StepCountCheck( u16 attr )
{
	if( UnionRoomCheck() == 1 ){ return FALSE; }

	RevengeStepCountUp();						//Đg[i[`FbN
	FriendlyStepCountUp();						//ȂxAbv`FbN
	MewStepCount();								//ŉʂĂ̌ǓJEg(04.04.28)

	// ړɂ͖鏈
	if(	((MyMoveState.flag & MY_MV_BIT_FORCE) == 0)
	&&	(ATR_IsForceMoveCheck(attr) == FALSE)
	){

		if (PoisonStepCheck() == TRUE) {				//łɂ_[WEm`FbN
			StartFieldScript( ev_poison_dead );
			return TRUE;
		}
		if (PokeSodateya()){							//ĉE^}Sz
			IncRecord( CNT_TAMAGO );
			StartFieldScript( ev_sodateya_tamago_huka );		
			return TRUE;
		}

		if ( LegendPokeStepCountCheck() == TRUE ) {		//O[hEJCI[K`FbN
			StartFieldScript( ev_legend_poke_time_over );
			return TRUE;
		}

		if ( TenjiStepCountCheck() == TRUE ){			//_JEg(04.04.30)
			StartFieldScript( bg_chg_02_cave_d1801 );
			return TRUE;
		}

		if ( TelMitsuruWalkCountCheck() == TRUE ){		//~cĂяoCxgpJEg
			StartFieldScript( ev_mitsuru_navi_event );
			return TRUE;
		}

		if ( TelEnishidaWalkCountCheck() == TRUE ){		//GjV_ĂяoCxgpJEg
			StartFieldScript( ev_enishida_navi_event );
			return TRUE;
		}

		if ( TelEnishidaWalk2CountCheck() == TRUE ){		//GjV_ĂяoCxgpJEg
			StartFieldScript( ev_enishida_navi_02_event );
			return TRUE;
		}

		if ( TelGymLeader1WalkCountCheck() == TRUE ){	//ccWĂяoCxgpJEg
			StartFieldScript( ev_gymleader1_navi_event );
			return TRUE;
		}

		if ( TelSupportWalkCountCheck() == TRUE ){	//T|[gĂяoCxgpJEg
			StartFieldScript( ev_support_navi_event );
			return TRUE;
		}

	}

	if ( SafariStepCheck() == TRUE ) {			// Tt@[hł̕`FbN
		return TRUE;
	}
	if ( ShipStepCountCheck(1) == TRUE ) {		// ANÃfI`FbN
		StartFieldScript( ev_sp_ship_demo_end );
		return TRUE;
	}

	if ( CheckCallEvent() ){
		return TRUE;
	}//<<20031001 add
	return FALSE;
}

//-------------------------------------------------------------
//ꂠ邫ł̂Ȃx㏸`FbN
//-------------------------------------------------------------
//
void FriendlyStepInit(void)
{
	SetEventWorkValue(WK_FRIENDLY_STEP_COUNT, 0);
}

//`FbN
static void FriendlyStepCountUp( void )
{
	u16 * step;
	int i;
	PokemonParam * pp;

	step = GetEventWorkAdrs(WK_FRIENDLY_STEP_COUNT);
	++ *step; 
	*step %= FRIENDLY_STEP_MAX;
	if (*step != 0) return;

	pp = PokeParaMine;
	for ( i=0; i<TEMOTI_POKEMAX; i++ ) {
		FriendCalc( pp, FRIEND_TSUREARUKI );
		pp++;
	}
}

//-------------------------------------------------------------
//	ɂŃ_[W
//-------------------------------------------------------------
//
void PoisonStepInit(void)
{
	SetEventWorkValue(WK_POISON_STEP_COUNT, 0);
}

//`FbN
static u8 PoisonStepCheck( void )
{
	u16 * poison_count;

	//閧nł͓ł̌ʂ͂Ȃ
	if (NowMap.type == MAPTYPE_BASE)
		return FALSE;

	poison_count = GetEventWorkAdrs(WK_POISON_STEP_COUNT);
	++ *poison_count;
	*poison_count %= POISON_STEP_MAX;
	if (*poison_count != 0)
		return FALSE;

	switch ( PoisonDeadCheck() ) {
	case 0:
		return FALSE;
	case 1:
		return FALSE;
	case 2:
		return TRUE;
	default:
		return FALSE;
	}
}


//=========================================================================
//
// o`FbN֘A
//
//=========================================================================

static u8 MatExitConditionCheck(u16 attr, u8 site);
static s8 ExitDataCheck( MapTotalData * Map, EV_POS * p );
static void ExitDataSet( MapTotalData * Map, s8 id, EV_POS * p);


//-------------------------------------------------------------
//	Cxg`FbNF }bgo
//-------------------------------------------------------------

u8 EventMatCheck(EV_POS * p, u16 attr, u8 site)
{
	s8 id;

	id = ExitDataCheck( &NowMap, p );

	if ( MatExitConditionCheck(attr,site) == TRUE && id != -1 ) {
		SetHeroLastStatus();
		ExitDataSet(&NowMap, id, p);
		AddMapChangeTask();
		return TRUE;
	}

	return FALSE;
}

//-------------------------------------------------------------
//	Nof[^Zbg
//-------------------------------------------------------------

void ExitDataSet(MapTotalData * Map, s8 id, EV_POS * p)
{
	const SXY_CONNECT * exit;
	const MapTotalData * next;
	u8 tr_hill_floor;
	u8 max_floor;

	tr_hill_floor = GetTrainerHillFloor();
	if (tr_hill_floor != 0){
		max_floor = GetTrainerHillMaxFloor();
		if (tr_hill_floor == max_floor){	//1ÔƂ
			if (id == 0){	//
				exit = &(NowMap.Sxy->ConnectData[id]);
			}else{			//
				exit = GetTRHillRoofConnect();
			}
		}else if(tr_hill_floor == TRH_FLOOR_ROOF){//̂Ƃ
			exit = GetTRHillFloorConnect(id);
		}else{
			//֘ÃNȊÓAʏ̃RlNgłnj
			exit = &(NowMap.Sxy->ConnectData[id]);
		}
	}else{
		exit = &(NowMap.Sxy->ConnectData[id]);	//ʏ̃RlNg
	}
	if( exit->mapID == SPFIELD_MAP )	/* ڑ̏oɓꍇ */
	{
		NextMapSetBySpID( exit->doorID );
		return;
	};
	NextMapSetByID( exit->divisionID, exit->mapID, exit->doorID );
	NextEscapePosSet(p->x, p->y);		//ȂʂJڐ̐ݒ

	next = GetTotalMapData( exit->divisionID, exit->mapID );
	if( next->Sxy->ConnectData[exit->doorID].mapID == SPFIELD_MAP )
	{
		/* ڑ悪ڑȍꍇAȍo^ */
		SetSpecialMapID(
				next->Sxy->ConnectData[id].doorID,		// ۑR[h
				fld->MapID.div_id,						// hc
				fld->MapID.map_id,						// hc
				id										// ohc
				);
	}

}

//=========================================================================
//=========================================================================
//--------------------------------------------------------------
//	̑Oɂnaĩ`FbN
//	ǂgp̃`FbNȂǂɎg
//	߂l͂̂naĩXNvgAhXij
//	TargetObjNoݒ肳
//--------------------------------------------------------------
const VM_CODE * FrontObjCheck(void)
{
	u8 site;

	u16 attr;
	EV_POS pos;

	site = GetHeroMoveSite();
	GetHeroFrontPosition( &pos );
	attr = GetCellAttribute( pos.x, pos.y );

	return EvObjTalkCheck( &pos, attr, site );
}

//-------------------------------------------------------------
/**
 * }bvJڏ̋Zbg
 *
 * <߂l>
 * _~[0ԂĂ̂ňӖ͂Ȃ
 */
//-------------------------------------------------------------
u8 ForceExitSet( void )
{
	s8 id;
	EV_POS pos;
	u16 attr;
	u8 site;

	site = GetHeroMoveSite();
	GetHeroPosition( &pos );
	attr = GetCellAttribute( pos.x, pos.y );

	id = ExitDataCheck( &NowMap, &pos );
	ExitDataSet(&NowMap, id, &pos);
	return 0;
}

//=========================================================================
//=========================================================================
#endif
