//============================================================================================
/**
 * @file	ev_mapchange.c
 * @brief	tB[h}bvؑւ̃CxgƂ̐`FbN
 * @date	2005.08.01
 * @author	tamada / saito
 */
//============================================================================================

#include "common.h"
#include "fieldsys.h"

#include "field_event.h"

#include "fieldmap.h"
#include "location.h"

#include "ev_mapchange.h"

#include "worldmap.h"

#include "zonedata.h"
#include "mapdefine.h"
#include "eventdata.h"		//][̃Cxgf[^QƂ̂

#include "system/snd_tool.h"
#include "fld_bgm.h"
#include "system/brightness.h"

#include "comm_player.h"  // nڑ̂

#include "map_tool.h"

#include "field_3d_anime_ev.h"
//n
#include "effect_uground.h"
#include "comm_field_state.h"  // nʐMp
//
#include "script.h"

#include "savedata/mystatus.h"	//MyStatus_GetMySex
#include "savedata/gimmickwork.h"
#include "field/situation_local.h"	//Situation_GetTMFootMark
#include "townmap_footmark.h"		//TMFootMark_SetNoDir
#include "mapdata_warp.h"			//WARPDATA_SearchWarpData
#include "field_subscreen.h"
#include "report.h"
#include "mapdata_weather.h"		//WeatherData_Get

static BOOL GMEVENT_MapChange(GMEVENT_CONTROL * event);
///static BOOL GMEVENT_DoorMapChange(GMEVENT_CONTROL * event);
///static BOOL GMEVENT_MatMapChange(GMEVENT_CONTROL * event);
static BOOL GMEVENT_FirstMapIn(GMEVENT_CONTROL * event);
static BOOL GMEVENT_FieldChange_FadeIn(GMEVENT_CONTROL * event);

static void MapChg_SetNewLocation(FIELDSYS_WORK * fsys, const LOCATION_WORK * next);
static void MapChg_UpdateGameData(FIELDSYS_WORK * fsys);
static void MapChg_SetupMapTools(FIELDSYS_WORK * fsys, int type);
static void MapChg_RemoveMapTools(FIELDSYS_WORK * fsys, int type);
static void MapChg_FieldOBJ_Create(FIELDSYS_WORK * fsys);
static void MapChg_FieldOBJ_Delete(FIELDSYS_WORK * fsys);

//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgp䃏[N
 */
//-----------------------------------------------------------------------------
typedef struct {
	int seq;							///<V[PXێ[N
	LOCATION_WORK next;					///<}bvJڐwp[N
	FLD_3D_ANIME_WORK_PTR DoorAnimeWork;
}EVENT_MAPCHG_WORK;

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------



//============================================================================================
//
//
//	c[֐
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	}bvwXV
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	next		̑JڐwLOCATION_WORKւ̃|C^
 */
//-----------------------------------------------------------------------------
static void MapChg_SetNewLocation(FIELDSYS_WORK * fsys, const LOCATION_WORK * next)
{
	SITUATION * sit = SaveData_GetSituation(fsys->savedata);
	LOCATION_WORK * before = Situation_GetBeforeLocation(sit);
	LOCATION_WORK * escape = Situation_GetEscapeLocation(sit);
	//P[VXV
	if (next != NULL) {
		*before = *fsys->location;
		*(fsys->location) = *next;

		//bdlBƐkȎdlɂāuȂʂv̏oꏊo^
		if (ZoneData_IsSinouField(before->zone_id) == TRUE
				&& ZoneData_IsSinouField(next->zone_id) == FALSE) {
			*escape = *before;
		}
	}
	//][ʃf[^̓ǂݍ
	EventData_LoadZoneData(fsys, fsys->location->zone_id);

	if (fsys->location->door_id != DOOR_ID_JUMP_CODE){
		//oڑ̏ꍇ̏
		const CONNECT_DATA* connect;
		connect = EventData_GetNowConnectDataByID(fsys, fsys->location->door_id);
		fsys->location->grid_x = connect->x;
		fsys->location->grid_z = connect->z;
		//ڑɏoꍇ́Aڑێ悤ɂĂ
		if (connect->link_door_id == SPECIAL_SPEXIT01) {
			LOCATION_WORK *sp, *ent;
			sp = Situation_GetSpecialLocation(sit);
			ent = Situation_GetEntranceLocation(sit);
			*sp = *ent;
		}
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڎ̃f[^XV
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void MapChg_UpdateGameData(FIELDSYS_WORK * fsys)
{
	SITUATION * sit = SaveData_GetSituation(fsys->savedata);
	//XNvg̃}bvtO[ÑNA
	LocalEventFlagClear(fsys);
	//}bv̎d|p[ÑNA
	GIMMICKWORK_Init(SaveData_GetGimmickWork(fsys->savedata));
	{
		//VXV
		//Situation_SetWeatherID(sit, ZoneData_GetWeatherID(fsys->location->zone_id));
		Situation_SetWeatherID(sit, WeatherData_Get(fsys, fsys->location->zone_id));
		//JwXV
		Situation_SetCameraID(sit, ZoneData_GetCameraID(fsys->location->zone_id));
	}
	{
		u16 warp_id;
		//[vf[^ɓo^Ă}bvȂ΁A߂Ƃēo^Ă
		warp_id = WARPDATA_SearchWarpData(fsys->location->zone_id);
		if (warp_id != 0) {
			Situation_SetWarpID(sit, warp_id);
		}
	}
	SpScriptSearch(fsys, SP_SCRID_FLAG_CHANGE);
	//-------------------------------------------
	if (ZoneData_IsSinouField(fsys->location->zone_id)) {
		//tB[hȊOł͑Ղ̍XV͂ȂI
		TOWN_MAP_FOOTMARK * footmark;
		footmark = Situation_GetTMFootMark(SaveData_GetSituation(fsys->savedata));
		TMFootMark_SetNoDir(footmark, fsys->location->grid_x, fsys->location->grid_z);
	}
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJñtB[hOBJ֘A
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void MapChg_FieldOBJ_Create(FIELDSYS_WORK * fsys)
{
	int sex;
	SITUATION *situ;
	PLAYER_SAVE_DATA *jikisave;
	
	//tB[hOBJ ,l͓K
	fsys->fldobjsys = FieldOBJSys_Init( fsys, FLDOBJ_ENTRY_MAX, FLDMAP_PRI_OBJSYS );
	
	//@ǉ
	sex = MyStatus_GetMySex(SaveData_GetMyStatus(fsys->savedata));
	situ = SaveData_GetSituation( fsys->savedata );
	jikisave = Situation_GetPlayerSaveData( situ );
	
	fsys->player = Player_Init( fsys->fldobjsys,
			fsys->location->grid_x,
			fsys->location->grid_z,
			fsys->location->dir,
			HERO_FORM_NORMAL, sex, jikisave );
	
	//ŏ̃][StB[hOBJǉ
	EventData_SetFieldOBJ( fsys );

	//tB[hOBJ쏈|[Y
	FieldOBJSys_MoveStopAll( fsys->fldobjsys );
}
//-----------------------------------------------------------------------------
/**
 * @brief	}bvĨtB[hOBJ֘A
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void MapChg_FieldOBJ_Delete(FIELDSYS_WORK * fsys)
{
	Player_Delete( fsys->player );			// @
	FieldOBJ_DeleteAll(fsys->fldobjsys);	// FieldOBJS
	FieldOBJSys_Delete(fsys->fldobjsys);	// FieldOBJVXe
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static void MapChg_FieldOBJ_Continue(FIELDSYS_WORK * fsys)
{
	//tB[hOBJ ,l͓K
	fsys->fldobjsys = FieldOBJSys_Init( fsys, FLDOBJ_ENTRY_MAX, FLDMAP_PRI_OBJSYS );
	

	Field_LoadFieldObj(fsys);
	//@ǉ
	
	{
		SITUATION *situ = SaveData_GetSituation( fsys->savedata );
		PLAYER_SAVE_DATA *jikisave = Situation_GetPlayerSaveData( situ );
		fsys->player = Player_FieldOBJUseRecover(fsys->fldobjsys,jikisave);
	}

	//tB[hOBJ쏈|[Y
	FieldOBJSys_MoveStopAll( fsys->fldobjsys );
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvc[iAAgr[gAetc.j̐ݒ
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	type		c[̃^Cvw
 */
//-----------------------------------------------------------------------------
static void MapChg_SetupMapTools(FIELDSYS_WORK * fsys, int type)
{
	GF_ASSERT(fsys->map_tool_list == NULL);
	GF_ASSERT(fsys->div_func_list == NULL);
	//[hZbgAbv
	SetUpWorldMatrix( fsys->location->zone_id, fsys->World );
	
	if (type == MAP_FLAG_GROUND) {

		//AAgr[g̕@
		SetUpMapToolList(&fsys->map_tool_list,MAP_MODE_GROUND);
///		SetUpDivFuncList(fsys, DIV_MAP_MODE_GROUND);<<20060217move

		//Tuʂ̏@
		if(fsys->location->zone_id != ZONE_ID_UNION){
			// ʏ펞̓|Pb`N
			fsys->subscreen = FIELD_SUBSCRN_POKETCH;
		}else{
			// jI[pʂN
			fsys->subscreen = FIELD_SUBSCRN_UNION;
		}
	} else {
		//AAgr[gA}bv[h̕@
		SetUpMapToolList(&fsys->map_tool_list,MAP_MODE_UNDER);
///		SetUpDivFuncList(fsys, DIV_MAP_MODE_UNDER);<<20060217move
		fsys->subscreen = FIELD_SUBSCRN_UNDER;
	}
	
	if (fsys->MapFlag == MAP_FLAG_UNDER) {
		//Agr[gǂݍ
		SetUpUnderGroundAttr(fsys);
	}
	
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvc[iAAgr[gAetc.j̔p
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	type		c[̃^Cvw
 */
//-----------------------------------------------------------------------------
static void MapChg_RemoveMapTools(FIELDSYS_WORK * fsys, int type)
{
	GF_ASSERT(fsys->map_tool_list != NULL);
	GF_ASSERT(fsys->div_func_list != NULL);
	fsys->map_tool_list = NULL;
	fsys->div_func_list = NULL;
	fsys->subscreen = FIELD_SUBSCRN_MAX;
	if (fsys->MapFlag == MAP_FLAG_GROUND) {
		//nAgr[gj
		FreeUnderGroundAttr(fsys);
	}
}

//============================================================================================
//
//
//							Q[Jn
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	CxgFQ[Jn
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_FirstMapIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int * seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		EventData_Sys_Create(fsys, HEAPID_WORLD);			//Cxgf[^䐶
		fsys->SwayGrass = SwayGrass_AllocSwayGrass(HEAPID_WORLD);	//hꑐ\̃m
		fsys->World = WorldMapInit();
		MapChg_SetNewLocation(fsys, NULL);

		//AAgr[gA}bv[h̕@
		MapChg_SetupMapTools(fsys, MAP_FLAG_GROUND);

		MapChg_UpdateGameData(fsys);

		MapChg_FieldOBJ_Create(fsys);

		SwayGrass_InitSwayGrass(fsys->SwayGrass);	//hꑐ

		GameStartScriptInit(fsys);				//Q[Jn̓XNvg
		(*seq) ++;
		break;
	case 1:
		EventCmd_StartField_FadeIn(event);
		(*seq) ++;
		break;
	case 2:
		return TRUE;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	Q[JnCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	start		JnʒuwLOCATION_WORKւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventSet_FirstMapIn(FIELDSYS_WORK * fsys, const LOCATION_WORK * start)
{
	GMEVENT_CONTROL * event;

	fsys->MapFlag = MAP_FLAG_GROUND;	//n߂͒nォX^[g
	event = FieldEvent_Set(fsys, GMEVENT_FirstMapIn, NULL);
}

//-----------------------------------------------------------------------------
/**
 * @brief	CxgFReBj[
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_ContinueMapIn(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int * seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		EventData_Sys_Create(fsys, HEAPID_WORLD);			//Cxgf[^䐶
		fsys->SwayGrass = SwayGrass_AllocSwayGrass(HEAPID_WORLD);	//hꑐ\̃m
		fsys->World = WorldMapInit();
		MapChg_SetNewLocation(fsys, NULL);

		//AAgr[gA}bv[h̕@
		MapChg_SetupMapTools(fsys, MAP_FLAG_GROUND);

		//MapChg_UpdateGameData(fsys);

		MapChg_FieldOBJ_Continue(fsys);

		SwayGrass_InitSwayGrass(fsys->SwayGrass);	//hꑐ

		(*seq) ++;
		break;
	case 1:
		EventCmd_StartField_FadeIn(event);
		(*seq) ++;
		break;
	case 2:
		return TRUE;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	Q[JnCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventSet_ContinueMapIn(FIELDSYS_WORK * fsys)
{
	GMEVENT_CONTROL * event;

	fsys->MapFlag = MAP_FLAG_GROUND;	//n߂͒nォX^[g
	event = FieldEvent_Set(fsys, GMEVENT_ContinueMapIn, NULL);
}


//============================================================================================
//
//
//							Q[I
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	CxgFQ[I
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_GameEnd(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int * seq = FieldEvent_GetSeqWork(event);
	switch (*seq) {
	case 0:
		EventCmd_FieldFadeOut(event);
		(*seq) ++;
		break;

	case 1:
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;

	case 2:
		MapChg_FieldOBJ_Delete(fsys);
		MapChg_RemoveMapTools(fsys, fsys->MapFlag);
		WorldMapRelease(fsys->World);			// [h}bv\̉
		EventData_Sys_Delete(fsys);				// Cxgf[^

		GameSystem_End(fsys);

		return TRUE;
	}

	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Q[I
 *
 * Q[CIB
 * fobOpŃ[N`FbN̂ߍ쐬B
 * |Pł̓[U[ŃQ[I邱ƂȂ̂ŁAiłł
 * gpȂ͂B
 */
//-----------------------------------------------------------------------------
void EventSet_ReturnToTitle(FIELDSYS_WORK * fsys)
{
	FieldEvent_Set(fsys, GMEVENT_GameEnd, NULL);
}



//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	fobOp}bvJ
 * @param	fsys		tB[h䃏[Nւ̃|C^
 *
 * fobO̊Jnʒuɔ΂
 */
//-----------------------------------------------------------------------------
void DebugMapChangeSet(FIELDSYS_WORK * fsys)
{
	LOCATION_WORK next;
	Debug_SetStartLocation(&next);
	EventSet_MapChange(fsys, next.zone_id, next.door_id,
			next.grid_x, next.grid_z, next.dir );
}

//-----------------------------------------------------------------------------
// @brief	}bvJڃCxg(AjWv)
//-----------------------------------------------------------------------------
static BOOL GMEVENT_MapChange(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_MAPCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);

	switch (mcw->seq) {
	case 0:
		Snd_SePlay( SEQ_SE_DP_KAIDAN2 );

		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			LOCATION_WORK* location = &mcw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}
		
		EventCmd_FadeOut_FinishField(event);	//TuCxgĂяõCxg̓EFCg
		(mcw->seq) ++;
		break;
	case 1:
		//TuCxgĂяõCxg̓EFCg
		EventCmd_MapChangeByLocation(event, &mcw->next);
		(mcw->seq) ++;
		break;
	case 2:
		EventCmd_StartField_FadeIn(event);	//TuCxgĂяõCxg̓EFCg
		(mcw->seq) ++;
		break;
	case 3:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	next		Jڐ}bvw
 */
//-----------------------------------------------------------------------------
void EventSet_MapChangeByLocation(FIELDSYS_WORK * fsys, const LOCATION_WORK * next)
{
	EVENT_MAPCHG_WORK * mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
	mcw->seq = 0;
	mcw->next = *next;
	FieldEvent_Set(fsys, GMEVENT_MapChange, mcw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	}bvJڃCxgZbg
 * @param	fsys		tB[h䃏[Nւ̃|C^
 * @param	zone		Jڐ}bṽ][w
 * @param	door_id		Jڐ}bvł̏oow
 * @param	x			Jڐ}bvłXObhʒu
 * @param	z			Jڐ}bvłYObhʒu
 * @param	dir			Jڐ}bvł̏
 *
 * Jڐ}bv̂ǂɏo邩͎̏̃}bvǂݍނ܂ł͂킩Ȃ͂Ȃ̂
 * {͍Ww͖ʂȂǁAÔ߁B܂GAƃ][̊֌W͍čl̂
 * GAwȂȂ\B
 */
//-----------------------------------------------------------------------------
void EventSet_MapChange(FIELDSYS_WORK * fsys, int zone, int door_id, int x, int z, int dir )
{
	LOCATION_WORK next;
	SetLocation(&next, zone, door_id, x, z, dir);
	EventSet_MapChangeByLocation(fsys, &next);
}


//============================================================================================
//
//
//	Cxg[R}hF}bvJڊ֘A
//
//	TuCxgFieldEvent_CallŌĂяoƂŎgpB
//	݂̃Cxg~āAɃTuCxgтB
//	TuCxgIƌ݂̃CxgĂяoB
//
//	IɂFieldEvent_CallĂяoăTuCxgssĂ邪A
//	Cxg͒PȃR}hĂяoŎsł悤Ȍ`ɐĂ\B
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	[R}hp[N`
 */
//-----------------------------------------------------------------------------
typedef struct {
	int seq;
	LOCATION_WORK next;
}SIMPLE_MAPCHG_WORK;

//-----------------------------------------------------------------------------
/**
 * @brief	TuCxgF}bvJ
 * @param	event	Cxg䃏[Nւ̃|C^
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 *
 * TuCxgFieldEvent_CallŌĂяoƂŎgpB
 * ݂̃Cxg~āAɃTuCxgтB
 * TuCxgIƌ݂̃CxgĂяoB
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_MapChange(GMEVENT_CONTROL * event)
{
	u16 bgm_no;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = FieldEvent_GetSpecialWork(event);

	switch (smw->seq) {
	case 0:
		//--------I--------
		MapChg_FieldOBJ_Delete(fsys);
		MapChg_RemoveMapTools(fsys, fsys->MapFlag);
		WorldMapRelease(fsys->World);			// [h}bv\̉
		(smw->seq) ++;
		break;
		
	case 1:
		//--------Jn--------
		fsys->World = WorldMapInit();
		MapChg_SetNewLocation(fsys, &smw->next);

		//AAgr[gA}bv[h̕@
		MapChg_SetupMapTools(fsys, fsys->MapFlag);

		MapChg_UpdateGameData(fsys);

		SwayGrass_InitSwayGrass(fsys->SwayGrass);	//hꑐ
		(smw->seq) ++;
		break;
		
	case 2:
		MapChg_FieldOBJ_Create(fsys);
		sys_FreeMemoryEz(smw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	next		Jڐw肷LOCATION_WORK^ւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventCmd_MapChangeByLocation(GMEVENT_CONTROL * event, const LOCATION_WORK * next)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(SIMPLE_MAPCHG_WORK));
	if (GameSystem_CheckFieldProcExists(fsys)) {
		GF_ASSERT("mainproĉɃ}bvJڏ\n" && 0);
		return;
	}
	smw->seq = 0;
	smw->next = *next;
	FieldEvent_Call(event, GMEVENT_Sub_MapChange, smw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	zone_id		Jڐ][IDw
 * @param	door_id		Jڐow
 * @param	x			JڐXWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	z			JڐZWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	dir			oł̕w
 *
 */
//-----------------------------------------------------------------------------
void EventCmd_MapChange(GMEVENT_CONTROL * event, int zone_id, int door_id, int x, int z, int dir)
{
	LOCATION_WORK next;
	SetLocation(&next, zone_id, door_id, x, z, dir);
	EventCmd_MapChangeByLocation(event, &next);
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_MapChangeFull(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);

	switch (mcw->seq) {
	case 0:
		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			LOCATION_WORK* location = &mcw->next;
			Snd_MapChangeFadeOutNextPlaySub( fsys, location->zone_id, BGM_FADE_ROOM_MODE );
		}

		EventCmd_FinishFieldMap(event);
		(mcw->seq) ++;
		break;
	case 1:
		EventCmd_MapChangeByLocation(event, &mcw->next);
		(mcw->seq) ++;
		break;
	case 2:
		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;
	case 3:
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvؑ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	zone_id		Jڐ][IDw
 * @param	door_id		Jڐow
 * @param	x			JڐXWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	z			JڐZWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	dir			oł̕w
 *
 * tB[h}bvI}bvؑ֏tB[h}bvĊJ܂ł̏Aōs
 */
//-----------------------------------------------------------------------------
void EventCmd_MapChangeFull(GMEVENT_CONTROL * event,
		int zone_id, int door_id, int x, int z, int dir)
{
	SIMPLE_MAPCHG_WORK * smw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(SIMPLE_MAPCHG_WORK));
	smw->seq = 0;
	SetLocation(&smw->next, zone_id, door_id, x, z, dir);
	FieldEvent_Call(event, GMEVENT_Sub_MapChangeFull, smw);
}






///*************************************************************************************
//
//		
//		ñ}bvړ
//
//
//
//
//		ñ}bvړ
//		
//
///*************************************************************************************


//============================================================================================
//
//
//			nWv
//
//
//============================================================================================
static BOOL GMEVENT_UgChange(GMEVENT_CONTROL * event);	//nぃn
static BOOL GMEVENT_UgJump(GMEVENT_CONTROL * event);	//nn
static BOOL UgChg_SubCall(GMEVENT_CONTROL * event, int no);

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
typedef struct {
	int seq;
	int subseq;
	int next_zone_id;
	int next_door_id;
	int next_x;
	int next_z;
	BOOL brightness;
}EVENT_UGCHG_WORK;

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static EVENT_UGCHG_WORK * MakeUGChangeWork(FIELDSYS_WORK * fsys)
{
	EVENT_UGCHG_WORK * mcw;
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	//Cxg
	mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_UGCHG_WORK));
	mcw->seq = 0;
	mcw->subseq = 0;
	
	if ( fsys->MapFlag == MAP_FLAG_UNDER){	//ݒn̏ꍇ
		//nփWv
		mcw->next_zone_id = sp->zone_id;
		mcw->next_door_id = DOOR_ID_JUMP_CODE;
		mcw->next_x = sp->grid_x;
		mcw->next_z = sp->grid_z;
#if 0
		mcw->next_zone_id = fsys->field_zone_id;
		mcw->next_door_id = DOOR_ID_JUMP_CODE;
		mcw->next_x = fsys->field_x;
		mcw->next_z = fsys->field_z;
#endif
        // ʐMI
        CommFieldStateExitUnderGround();  // ʐMXe[gnIɕύX
	}else{
		SetLocation(sp, fsys->location->zone_id, DOOR_ID_JUMP_CODE,
				Player_NowGPosXGet(fsys->player), Player_NowGPosZGet(fsys->player), DIR_DOWN);
		mcw->next_zone_id = ZONE_ID_UG;
		mcw->next_door_id = DOOR_ID_JUMP_CODE;
		//ubN̐^񒆂ɃWv悤ɂ(YzTCY͒n1/4)
		mcw->next_x = ((sp->grid_x/32)/2)*32+16;
		mcw->next_z = ((sp->grid_z/32)/2)*32+16;
#if 0
		if (/*GetWorldMatrixID(fsys->World)==MATRIX_ID_FIELD*/1){//Wv\ɁB
			fsys->field_x = Player_NowGPosXGet( fsys->player );
			fsys->field_z = Player_NowGPosZGet( fsys->player );
			fsys->field_zone_id = fsys->location->zone_id;
			//nփWv
			mcw->next_zone_id = ZONE_ID_UG;
			mcw->next_door_id = DOOR_ID_JUMP_CODE;
			//ubN̐^񒆂ɃWv悤ɂ(YzTCY͒n1/4)
			mcw->next_x = ((fsys->field_x/32)/2)*32+16;
			mcw->next_z = ((fsys->field_z/32)/2)*32+16;
		}else{
			sys_FreeMemoryEz(mcw);
			return NULL;
		}
#endif
	}
	return mcw;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ChangeUnderGroundDirect(struct _FIELDSYS_WORK * fsys)
{
	EVENT_UGCHG_WORK * mcw = MakeUGChangeWork(fsys);
	if (mcw == NULL) {
		return;
	}
	FieldEvent_Set(fsys, GMEVENT_UgChange, mcw);
}

//-----------------------------------------------------------------------------
// Ńj[Ă 2005/12/07 by nakahiro
//-----------------------------------------------------------------------------
void D_ChangeUnderGroundDirect(FIELDSYS_WORK * fsys)
{
	EVENT_UGCHG_WORK * mcw = MakeUGChangeWork(fsys);
	if (mcw == NULL) {
		return;
	}
	FieldEvent_Change(fsys->event, GMEVENT_UgChange, mcw);
}

#if PM_DEBUG
//-----------------------------------------------------------------------------
//  nɔCӂ̈ʒuɍ~ׂɍ쐬 fobOp 2006.02.08
//-----------------------------------------------------------------------------
void Debug_ChangeUnderGroundDirect(struct _FIELDSYS_WORK * fsys, int x, int z)
{
	EVENT_UGCHG_WORK * mcw = MakeUGChangeWork(fsys);
	if (mcw == NULL) {
		return;
	}
    mcw->next_x = x;
    mcw->next_z = z;
	FieldEvent_Set(fsys, GMEVENT_UgChange, mcw);
}
#endif //PM_DEBUG
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL GMEVENT_UgChange(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	int end_flg = 0;
		
	
	switch (mcw->seq) {
	case 0:
		//n̎̓[_[ɉ
		if(fsys->MapFlag == MAP_FLAG_UNDER){		// n̂Ƃ
			UnderGround_RadarEnd(fsys->UnderGroundRadar);
			mcw->seq++;
		}else{
			mcw->seq=2;
		}
		break;

	case 1:
		if(fsys->UnderGroundRadar==NULL){
			mcw->seq++;
		}
		break;
	case 2:
		//"}bvJڐp"tF[hAEg  BGMĐ
		{
			Snd_MapChangeFadeOutNextPlaySub( fsys, mcw->next_zone_id, BGM_FADE_ROOM_MODE );
		}

		if(fsys->MapFlag == MAP_FLAG_GROUND){		// n̂Ƃ
			if (UgChg_SubCall(event, EFCT_UG_DOWN00)) {
				end_flg = 1;
			}
		}else{									// n̂Ƃ
			if (UgChg_SubCall(event, EFCT_UG_UP00)) {
				end_flg = 1;
			}
		}
		if(end_flg == 1){
			(mcw->seq) ++;
		}
		break;
	case 3:
		EventCmd_FinishFieldMap(event);
		(mcw->seq) ++;
		break;
	case 4:
		
		if (fsys->MapFlag == MAP_FLAG_GROUND){			//n
			sys.disp3DSW = DISP_3D_TO_SUB;
			fsys->MapFlag = MAP_FLAG_UNDER;
            // ʐMJn
            CommFieldStateEnterUnderGround(fsys); // ʐMXe[gnJnɕύX
		}else{											//n
			sys.disp3DSW = DISP_3D_TO_MAIN;
			fsys->MapFlag = MAP_FLAG_GROUND;
		}
		EventCmd_MapChange(	event,
								mcw->next_zone_id,
								DOOR_ID_JUMP_CODE,
								mcw->next_x,
								mcw->next_z,
								DIR_DOWN);

		(mcw->seq) ++;
		break;
	case 5:
		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;
	case 6:
		if(fsys->MapFlag == MAP_FLAG_UNDER){		// n̂Ƃ
			if (UgChg_SubCall(event, EFCT_UG_DOWN01)) {
                CommFieldStateArrivalUnderGround(); // nɓ
				fsys->UnderGroundRadar = UnderGround_RadarInit(fsys);		//Yz[_[ʂnm
				end_flg = 1;
			}
		}else{									// n̂Ƃ
			if (UgChg_SubCall(event, EFCT_UG_UP01)) {
				end_flg = 1;
			}
		}
		if(end_flg == 1){
			sys_FreeMemoryEz(mcw);
			return TRUE;
		}
		break;
	
	}
	return FALSE;
}


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL UgChg_SubCall(GMEVENT_CONTROL * event, int no)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	BOOL	ret = FALSE;

	switch(mcw->subseq){
	case 0:		// X^[g
		mcw->brightness = 0;
		StartUnderGroundEffect(fsys, no, &mcw->brightness);
		mcw->subseq++;
		break;
	case 1:		// I҂
		if(mcw->brightness){
			mcw->subseq = 0;
			ret = TRUE;
		}
		break;
	}
	return ret;
}


//============================================================================================
//
//
//			CxgR}hFn`ñ}bvړ
//
//
//============================================================================================
static void EventCmd_UgJump(GMEVENT_CONTROL * event, int zone_id, int door_id, int x, int z, int dir);
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL GMEVENT_UgJump(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
	int end_flg = 0;
		
	
	switch (mcw->seq) {
	case 0:
		//[_[ɉ
		UnderGround_RadarEnd(fsys->UnderGroundRadar);
		CommStateJumpUnderGround();   // ړꍇ̒ʐM֘A
		mcw->seq++;
		break;

	case 1:
		if(fsys->UnderGroundRadar==NULL){
			mcw->seq++;
		}
		break;
	case 2:
/**		
		if(fsys->MapFlag == MAP_FLAG_GROUND){		// n̂Ƃ
			if (UgChg_SubCall(event, EFCT_UG_DOWN00)) {
				end_flg = 1;
			}
		}else{									// n̂Ƃ
			if (UgChg_SubCall(event, EFCT_UG_UP00)) {
				end_flg = 1;
			}
		}
		if(end_flg == 1){
			(mcw->seq) ++;
		}
*/		
		(mcw->seq) ++;
		break;
	case 3:
		EventCmd_FinishFieldMap(event);
		(mcw->seq) ++;
		break;
	case 4:
		
		EventCmd_UgJump(event,
						mcw->next_zone_id,
						DOOR_ID_JUMP_CODE,
						mcw->next_x,
						mcw->next_z,
						DIR_DOWN);

		(mcw->seq) ++;
		break;
	case 5:
		EventCmd_StartFieldMap(event);
		(mcw->seq) ++;
		break;
	case 6:
		CommStateJumpEndUnderGround(); // ړIꍇ̒ʐM֘A
		fsys->UnderGroundRadar = UnderGround_RadarInit(fsys);		//Yz[_[ʂnm
		sys_FreeMemoryEz(mcw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void JumpUnderGroundDirect(struct _FIELDSYS_WORK * fsys, const int inX, const int inZ)
{
	EVENT_UGCHG_WORK * mcw;
	
	//Cxg
	mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_UGCHG_WORK));
	mcw->seq = 0;
	mcw->subseq = 0;
	mcw->next_zone_id = ZONE_ID_UG;
	mcw->next_door_id = DOOR_ID_JUMP_CODE;
	//ŁAWv肵܂
	mcw->next_x = inX;
	mcw->next_z  = inZ;
	
	FieldEvent_Set(fsys, GMEVENT_UgJump, mcw);
	return;
}


//-----------------------------------------------------------------------------
/**
 * @brief	TuCxgF}bvJ(n`n)
 * @param	event	Cxg䃏[Nւ̃|C^
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 *
 * TuCxgFieldEvent_CallŌĂяoƂŎgpB
 * ݂̃Cxg~āAɃTuCxgтB
 * TuCxgIƌ݂̃CxgĂяoB
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_UgJump(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = FieldEvent_GetSpecialWork(event);

	switch (smw->seq) {
	case 0:
		//--------I--------
		MapChg_FieldOBJ_Delete(fsys);
		(smw->seq) ++;
		break;
		
	case 1:
		//--------Jn--------
		MapChg_SetNewLocation(fsys, &smw->next);
		(smw->seq) ++;
		break;
		
	case 2:
		MapChg_FieldOBJ_Create(fsys);
		sys_FreeMemoryEz(smw);
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ(n`n)
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	next		Jڐw肷LOCATION_WORK^ւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventCmd_UgJumpByLocation(GMEVENT_CONTROL * event, const LOCATION_WORK * next)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	SIMPLE_MAPCHG_WORK * smw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(SIMPLE_MAPCHG_WORK));
	if (GameSystem_CheckFieldProcExists(fsys)) {
		GF_ASSERT("mainproĉɃ}bvJڏ\n" && 0);
		return;
	}
	smw->seq = 0;
	smw->next = *next;
	FieldEvent_Call(event, GMEVENT_Sub_UgJump, smw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF}bvJ(n`n)
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	zone_id		Jڐ][IDw
 * @param	door_id		Jڐow
 * @param	x			JڐXWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	z			JڐZWwidoor_id == DOOR_ID_JUMP_CODÊƂ̂ݗLj
 * @param	dir			oł̕w
 *
 */
//-----------------------------------------------------------------------------
static void EventCmd_UgJump(GMEVENT_CONTROL * event, int zone_id, int door_id, int x, int z, int dir)
{
	LOCATION_WORK next;
	SetLocation(&next, zone_id, door_id, x, z, dir);
	EventCmd_UgJumpByLocation(event, &next);
}



//============================================================================================
//
//
//			jI[p}bvړ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void EventSet_UnionRoomMapChange(FIELDSYS_WORK * fsys)
{
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));

	if(fsys->location->zone_id == ZONE_ID_UNION){
		// 
		
		// jI[ʐM
		Comm_UnionFinalize(fsys);

		// jI[\p[N
		Comm_UnionRoomViewEnd(fsys->union_view);

#if 0
		EventSet_MapChange(fsys,
			fsys->field_zone_id, DOOR_ID_JUMP_CODE,fsys->field_x,fsys->field_z, DIR_DOWN);
#endif
		EventSet_MapChangeByLocation(fsys, sp);
        fsys->union_work = NULL;
	}else{
		// 
		SetLocation(sp, fsys->location->zone_id, DOOR_ID_JUMP_CODE,
				Player_NowGPosXGet(fsys->player), Player_NowGPosZGet(fsys->player), DIR_DOWN);
		//fsys->field_x = Player_NowGPosXGet( fsys->player );
		//fsys->field_z = Player_NowGPosZGet( fsys->player );
		//fsys->field_zone_id = fsys->location->zone_id;

		// jI[ʐMJn
		fsys->union_work = Comm_UnionRoomInit(fsys);

		// jI[OBJ^XNN
		fsys->union_view = Comm_UnionRoomViewInit(fsys->union_work);
		EventSet_MapChange(fsys,
			ZONE_ID_UNION, DOOR_ID_JUMP_CODE, 9, 12, DIR_DOWN);
	}
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void EventCmd_UnionRoomMapChange(FIELDSYS_WORK * fsys)
{
	LOCATION_WORK * sp = Situation_GetSpecialLocation(SaveData_GetSituation(fsys->savedata));
	EVENT_MAPCHG_WORK * mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_MAPCHG_WORK));
	mcw->seq = 0;

	if(fsys->location->zone_id == ZONE_ID_UNION){
		// 
		
		// jI[ʐM
		Comm_UnionFinalize(fsys);

		// jI[\p[N
		Comm_UnionRoomViewEnd(fsys->union_view);

		mcw->next = *sp;
		//SetLocation(&(mcw->next), fsys->field_zone_id, DOOR_ID_JUMP_CODE,
		//		fsys->field_x, fsys->field_z, DIR_DOWN);
		FieldEvent_Call(fsys->event, GMEVENT_MapChange, mcw);
        fsys->union_work = NULL;
	}else{
		// 
		SetLocation(sp, fsys->location->zone_id, DOOR_ID_JUMP_CODE,
				Player_NowGPosXGet(fsys->player), Player_NowGPosZGet(fsys->player), DIR_DOWN);
		//fsys->field_x = Player_NowGPosXGet( fsys->player );
		//fsys->field_z = Player_NowGPosZGet( fsys->player );
		//fsys->field_zone_id = fsys->location->zone_id;

		// jI[ʐMJn
		fsys->union_work = Comm_UnionRoomInit(fsys);

		// jI[OBJ^XNN
		fsys->union_view = Comm_UnionRoomViewInit(fsys->union_work);
		SetLocation(&(mcw->next), ZONE_ID_UNION, DOOR_ID_JUMP_CODE, 8, 14, DIR_UP);
		FieldEvent_Call(fsys->event, GMEVENT_MapChange, mcw);
	}
}













