//============================================================================================
/**
 * @file	ev_mapchange.h
 * @brief	
 * @date	2005.08.01
 */
//============================================================================================

#ifndef	__EVENT_MAPCHANGE_H__
#define	__EVENT_MAPCHANGE_H__

#include "field_event.h"

#define DOOR_ID_JUMP_CODE	(-1)

//-----------------------------------------------------------------------------
//	CxgJn
//-----------------------------------------------------------------------------
extern void EventSet_FirstMapIn(FIELDSYS_WORK * fsys, const LOCATION_WORK * start);
extern void EventSet_ContinueMapIn(FIELDSYS_WORK * fsys);
extern void EventSet_MapChange(FIELDSYS_WORK * fsys,int zone, int door_id, int x, int z, int dir );
///extern void EventSet_MapChangeIO(FIELDSYS_WORK * fsys,int zone, int door_id, int x, int z, int dir, BOOL is_in );
extern void DebugMapChangeSet(FIELDSYS_WORK * fsys);

extern void EventSet_ReturnToTitle(FIELDSYS_WORK * fsys);

//쐬FŒ
extern void EventSet_UnionRoomMapChange(FIELDSYS_WORK * fsys);
extern void EventCmd_UnionRoomMapChange(FIELDSYS_WORK * fsys);

//-----------------------------------------------------------------------------
//	Cxg[R}h
//-----------------------------------------------------------------------------
extern void EventCmd_FinishFieldMap(GMEVENT_CONTROL * event);
extern void EventCmd_StartFieldMap(GMEVENT_CONTROL * event);
extern void EventCmd_FieldFadeIn(GMEVENT_CONTROL * event);
extern void EventCmd_FieldFadeOut(GMEVENT_CONTROL * event);
extern void EventCmd_FadeOut_FinishField(GMEVENT_CONTROL * event);
extern void EventCmd_StartField_FadeIn(GMEVENT_CONTROL * event);
extern void EventCmd_MapChange(GMEVENT_CONTROL * event,
		int zone_id, int door_id, int x, int z, int dir);
extern void EventCmd_MapChangeByLocation(GMEVENT_CONTROL * event, const LOCATION_WORK * next);
extern void EventCmd_UgJumpByLocation(GMEVENT_CONTROL * event, const LOCATION_WORK * next);
extern void EventCmd_MapChangeFull(GMEVENT_CONTROL * event,
		int zone_id, int door_id, int x, int z, int dir);

//Oꂳꂽ܂B
inline void GMEVENT_Call_MapChangeScript(GMEVENT_CONTROL * event,
		int zone_id, int door_id, int x, int z, int dir)
{
	EventCmd_MapChangeFull(event, zone_id, door_id, x, z, dir);
}

extern void ChangeUnderGroundDirect(struct _FIELDSYS_WORK * fsys);
#if PM_DEBUG
void Debug_ChangeUnderGroundDirect(struct _FIELDSYS_WORK * fsys, int x, int z);
#endif //PM_DEBUG
extern void JumpUnderGroundDirect(struct _FIELDSYS_WORK * fsys, const int inX, const int inZ);
#endif	/* __EVENT_MAPCHANGE_H__ */
