//===========================================================================
/**
 * @file	ev_pokemon.c
 * @brief	Cxg\[XF|P֘A
 * @author	tamada GAME FREAK Inc.
 * @date	2005.12.18
 */
//===========================================================================
#include "common.h"

#include "fieldsys.h"
#include "poketool/pokeparty.h"
#include "poketool/poke_tool.h"

#include "ev_pokemon.h"

//------------------------------------------------------------------
/**
 * @brief
 * @param	heapID
 * @param	party
 * @param	monsno
 * @param	level
 * @param	itemno
 */
//------------------------------------------------------------------
BOOL EvPoke_Add(int heapID, POKEPARTY * party, u16 monsno, u8 level, u16 itemno)
{
	BOOL result;
	POKEMON_PARAM *poke_param;
	u32 buf;

	poke_param = PokemonParam_AllocWork(heapID);
	PokeParaInit(poke_param);
	PokeParaSet(poke_param, monsno, level, POW_RND, RND_NO_SET, 0, ID_NO_SET, 0);
	//buf = 2;
	//PokeParaPut(poke_param, ID_PARA_hp, &buf);
	buf = itemno;
	PokeParaPut(poke_param, ID_PARA_item, &buf);
	result = PokeParty_Add(party, poke_param);
	sys_FreeMemoryEz(poke_param);

	return result;
}

//------------------------------------------------------------------
/**
 * @brief	|Pɂ킴Zbg
 * @param	party		POKEPARTY\̂ւ̃|C^
 * @param	poke_pos	|P̈ʒuiO`Uj
 * @param	waza_pos	킴ZbgꏊiO`Rj
 * @param	waza_no		킴̎
 */
//------------------------------------------------------------------
void EvPoke_ChangeWaza(POKEPARTY * party, int poke_pos, int waza_pos, u16 waza_no)
{
	PokeWazaSetPos(PokeParty_GetMemberPointer(party, poke_pos), waza_no, waza_pos);
}

//------------------------------------------------------------------
/**
 * @brief	莝|P̂킴`FbN
 * @param	party		POKEPARTY\̂ւ̃|C^
 * @param	waza_no		킴̎
 * @retval	0-5			Ă|P̈ʒu
 * @retval	0xff		Ă|PȂ
 *
 * 莝|PɎw肵킴Ă̂邩ǂԂB
 */
//------------------------------------------------------------------
int EvPoke_CheckWaza(POKEPARTY * party, u16 waza_no)
{
	int i, max;
	POKEMON_PARAM * poke;

	max = PokeParty_GetPokeCount(party);

	for (i = 0; i<max; i++){
		poke = PokeParty_GetMemberPointer(party, i);

		//܂`FbN
		if( PokeParaGet( poke, ID_PARA_tamago_flag, NULL ) != 0 ){
			continue;
		}
		//UXg`FbN
		if( (PokeParaGet( poke, ID_PARA_waza1, NULL ) == waza_no)
				||(PokeParaGet( poke, ID_PARA_waza2, NULL ) == waza_no)
				||(PokeParaGet( poke, ID_PARA_waza3, NULL ) == waza_no)
				||(PokeParaGet( poke, ID_PARA_waza4, NULL ) == waza_no)
			){
			return i;		//Ă|P̃Xg̕тԂ
			break;
		}
	}
	return 0xff;
}

//------------------------------------------------------------------
/**
 * @brief	킦|P̐𐔂
 * @param	party	POKEPARTYւ̃|C^
 * @return	int		킦|P̐
 */
//------------------------------------------------------------------
int EvPoke_CountLivingPokemon(const POKEPARTY * party)
{
	int i, max, count;
	POKEMON_PARAM * pp;
	
	max = PokeParty_GetPokeCount(party);
	count = 0;
	for (i = 0; i < max; i++) {
		pp = PokeParty_GetMemberPointer(party, i);
		if (PokeParaGet(pp, ID_PARA_hp, NULL) == 0) {
			continue;
		}
		if (PokeParaGet(pp, ID_PARA_tamago_flag, NULL)) {
			continue;
		}
		count ++;
	}
	return count;
}
//------------------------------------------------------------------
/**
 * @brief	2vs2ΐ킪\ǂ`FbN
 * @param	party	POKEPARTYւ̃|C^
 * @return	BOOL	TRUÊƂA2vs2ΐł
 */
//------------------------------------------------------------------
BOOL EvPoke_Enable2vs2Battle(const POKEPARTY * party)
{
	if (EvPoke_CountLivingPokemon(party) >= 2) {
		return TRUE;
	} else {
		return FALSE;
	}
}

