//============================================================================================
/**
 * @file	ev_time.c
 * @brief	Q[Ԑ֘A
 * @author	tamada
 * @date	2006.02.03
 */
//============================================================================================

#include "common.h"

#include "system/pm_rtc.h"

#include "fieldsys.h"

#include "savedata/seedbed.h"
#include "savedata/undergrounddata.h"  // UnderGroundDataDayUpdate

#include "situation_local.h"


#include "ev_time.h"

#include "evtime_local.h"

#include "system/timezone.h"

#include "seedsys.h"

#include "honey_tree_enc.h"

#include "script.h"

//============================================================================================
//============================================================================================

//============================================================================================
//============================================================================================
static void UpdateDayEvent(FIELDSYS_WORK * fsys, s32 diff_days);
static void UpdateMinuteEvent(FIELDSYS_WORK * fsys, s32 diff_minute);


//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------
void EVTIME_Init(EVTIME * tm)
{
	//EVTIME * tm = Situation_GetEvTime(SaveData_GetSituation(fsys->savedata));
	tm->use_flag = TRUE;
	GF_RTC_GetDateTime(&tm->sv_date, &tm->sv_time);
}

//------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------
void EVTIME_Update(FIELDSYS_WORK * fsys)
{
	RTCDate now_date;
	RTCTime now_time;
	EVTIME * tm = Situation_GetEvTime(SaveData_GetSituation(fsys->savedata));

	if (tm->use_flag == FALSE) {
		return;
	}

	GF_RTC_GetDateTime(&now_date, &now_time);

	//o߂
	{
		s32 now, sv;
		now = RTC_ConvertDateToDay(&now_date);
		sv = RTC_ConvertDateToDay(&tm->sv_date);

		if (now < sv) {
			//݁@@ߋ@c肦Ȃ͂
			return;
		}
		if (now > sv) {
			UpdateDayEvent(fsys, now - sv);
		}
	}

	//bo߂
	{
		s64 now, sv;
		s32 diff_minute;
		now = RTC_ConvertDateTimeToSecond(&now_date, &now_time);
		sv = RTC_ConvertDateTimeToSecond(&tm->sv_date, &tm->sv_time);
		if (now < sv) {
			//݁@@ߋ@c肦Ȃ͂
			return;
		}
		diff_minute = (now - sv) / 60;
		if (diff_minute > 0) {
#ifdef	dDEBUG_ONLY_FOR_tamada
			OS_Printf("%04d/%02d/%02d %02d:%02d(%d)\n",
					now_date.year, now_date.month, now_date.day,
					now_time.hour, now_time.minute, diff_minute);
#endif
			UpdateMinuteEvent(fsys, diff_minute);

			tm->sv_date = now_date;
			tm->sv_time = now_time;
		}
	}
}

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------
static void UpdateDayEvent(FIELDSYS_WORK * fsys, s32 diff_days)
{
	
	//L̂悤ȊŎԊ֘ACxgXVǉ
	//
	//TVData_Update(fsys, diff_days);
	//ZukanHyouka_Update
	//c

    // n̓o߂Ɋ֘A
    UnderGroundDataDayUpdate(GameSystem_GetSaveData(fsys), diff_days);

	//1ɃNAtO
	TimeEventFlagClear(fsys);
}

//------------------------------------------------------------------
/**
 */
//------------------------------------------------------------------
static void UpdateMinuteEvent(FIELDSYS_WORK * fsys, s32 diff_minute)
{
#if 0
	SEEDBED * sbed;
	sbed = SaveData_GetSeedBed(fsys->savedata);
	SEEDBED_Growth(sbed, diff_minute);
#endif
	SeedSys_Growth(fsys, diff_minute);
	HTE_UpdateHoneyTreeTime(fsys, diff_minute);
}




//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	ԑт̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	int		ԑсifield/timezone.hQƁj
 */
//------------------------------------------------------------------
int EVTIME_GetTimeZone(FIELDSYS_WORK * fsys)
{
	EVTIME * tm = Situation_GetEvTime(SaveData_GetSituation(fsys->savedata));
	return GF_RTC_ConvertHourToTimeZone(tm->sv_time.hour);

}

