//******************************************************************************
/**
 *
 * @file	ev_trainer.c
 * @brief	g[i[Cxg
 * @author	kagaya
 * @data	05.10.03
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_event.h"
#include "fieldobj.h"
#include "player.h"
#include "ev_trainer.h"
#include "field_encount.h"
#include "field_effect.h"
														//add nohara
#include "script.h"										//StartFieldScript
#include "..\fielddata\script\trainer_def.h"			//SCRID_TRAINER_MOVE_BATTLE

//==============================================================================
//	define
//==============================================================================
#define EYE_CHECK_NOHIT (-1)							///<͈̓`FbN߂l@qbgȂ
#define EYE_MEET_MOVE_TCB_PRI (0xff)					///<ړTCBvCIeB@K
#define EYE_MEET_GYOE_END_WAIT (30)						///<!}[No̊ԁ@t[P
#define EYE_MEET_MOVE_END_WAIT (8)						///<ړ̊ԁ@t[P

//--------------------------------------------------------------
///	ړԍ
//--------------------------------------------------------------
enum
{
	SEQNO_TRMOVE_OBJMOVE_WAIT = 0,						///<~҂
	SEQNO_TRMOVE_GYOE_SET,								///<!Zbg
	SEQNO_TRMOVE_GYOE_WAIT,								///<!҂
	SEQNO_TRMOVE_GYOE_END_WAIT,							///<!I҂
	SEQNO_TRMOVE_MOVE_RANGE_CHECK,						///<ړ`FbN
	SEQNO_TRMOVE_MOVE_START,							///<ړJn
	SEQNO_TRMOVE_MOVE,									///<ړ
	SEQNO_TRMOVE_MOVE_END_WAIT,							///<ړI҂
	SEQNO_TRMOVE_JIKI_TURN_SET,							///<@UZbg
	SEQNO_TRMOVE_JIKI_TURN,								///<@U
	SEQNO_TRMOVE_ACMD_END,								///<AjI
	SEQNO_TRMOVE_END,									///<I
};

//--------------------------------------------------------------
//	fobO
//--------------------------------------------------------------

//==============================================================================
//	typedef strcut
//==============================================================================
//--------------------------------------------------------------
///	qbgi[
//--------------------------------------------------------------
typedef struct
{
	int range;
	int dir;
	int scr_id;
	int tr_id;
	int tr_type;
	FIELD_OBJ_PTR fldobj;
}EYE_MEET_HITDATA;

//--------------------------------------------------------------
//	Cxg[N
//--------------------------------------------------------------
typedef struct
{
	int seq_no;											///<ԍ
	FIELDSYS_WORK *fsys;								///<FIELDSYS_WORK *
	FIELD_OBJ_PTR fldobj;								///<FIELD_OBJ_PTR
	TCB_PTR tcb_eye_meet;								///<TCB_PTR
}EYE_MEET_EVENT_WORK;

#define EYE_MEET_EVENT_WORK_SIZE (sizeof(EYE_MEET_EVENT_WORK)) ///<EYE_MEET_EVENT_WORKTCY

//--------------------------------------------------------------
//	qbgړp[N
//--------------------------------------------------------------
typedef struct
{
	int seq_no;											///<ԍ
	int end_flag;										///<ItO
	int dir;											///<ړ
	int range;											///<ړ
	int count;											///<ړJEg
	EOA_PTR gyoe;										///<MG[EOA_PTR
	FIELD_OBJ_PTR fldobj;								///<ړsFIELD_OBJ_PTR
	PLAYER_STATE_PTR jiki;								///<@PLAYER_STATE_PTR
}EYE_MEET_MOVE_WORK;

#define EYE_MEET_MOVE_WORK_SIZE (sizeof(EYE_MEET_MOVE_WORK)) ///<EYE_MEET_MOVE_WORKTCY

//==============================================================================
//	static
//==============================================================================
static int TrainerEyeCheck( FIELDSYS_WORK *fsys, FIELD_OBJ_SYS_PTR fos,
		PLAYER_STATE_PTR jiki, EYE_MEET_HITDATA *hit );
static void TrainerEyeHitDataSet(
		EYE_MEET_HITDATA *hit, FIELD_OBJ_PTR fldobj, int range, int dir );
static int TrainerEventTypeGet( CONST_FIELD_OBJ_PTR fldobj );

static int TrEyeLangeCheck( CONST_FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki, int *hit_dir );
static int TrEyeLineCheckParam( CONST_FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki );
static int TrEyeLineCheck(CONST_FIELD_OBJ_PTR fldobj,int dir, int range, int x, int z, int y );
int (* const TrEyeLineCheckTbl[])(CONST_FIELD_OBJ_PTR,int range,int x,int z,int y);

static int TrEyeLineMoveHitCheck( CONST_FIELD_OBJ_PTR fldobj, int dir, int range );
static int FldOBJTrainerIDGet( FIELD_OBJ_PTR fldobj );
static FIELD_OBJ_PTR TrainerPairCheck(
		FIELDSYS_WORK *fsys, FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_PTR tr_obj, int tr_id );

static TCB_PTR TrEyeMeetMoveAddTcb(
		FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki, int dir, int range );
static int TrEyeMeetMoveEndCheck( TCB_PTR tcb );
static void TrEyeMeetMoveEnd( TCB_PTR tcb );
static void TrEyeMeetMoveTCB( TCB_PTR tcb, void *wk );
int (* const DATA_EyeMeetMoveTbl[])( EYE_MEET_MOVE_WORK *work );

//==============================================================================
//	g[i[
//==============================================================================
//--------------------------------------------------------------
/**
 * g[i[Cxg`FbN
 * @param	fsys	FIELDSYS_WORK *
 * @param	vs2		_uog\ TRUE=\ FALSE=s
 * @retval	int		TRUE=g[i[Cxg
 */
//--------------------------------------------------------------
int EvTrainerEyeCheck( FIELDSYS_WORK *fsys, BOOL vs2 )
{
	EYE_MEET_HITDATA hit0;
	
	if( TrainerEyeCheck(fsys,fsys->fldobjsys,fsys->player,&hit0) == FALSE ){
		return( FALSE );
	}
	
	if( hit0.tr_type == SCR_EYE_TR_TYPE_SINGLE ){						//VO
		EventSet_Script( fsys, SCRID_TRAINER_MOVE_BATTLE, hit0.fldobj );//XNvgN
		
		EventSet_TrainerEyeData( fsys, hit0.fldobj,
			hit0.range, hit0.dir, hit0.scr_id, hit0.tr_id,
			SCR_EYE_TR_TYPE_SINGLE, SCR_EYE_TR_0 );
		
		OS_Printf( "g[i[VOqbg\n" );
		return( TRUE );
	}
	
	if( hit0.tr_type == SCR_EYE_TR_TYPE_DOUBLE ){						//_u
		FIELD_OBJ_PTR fldobj;
		EYE_MEET_HITDATA hit1;
		
		if( vs2 == FALSE ){												//_us
			return( FALSE );
		}
		
		fldobj = TrainerPairCheck( fsys, fsys->fldobjsys, hit0.fldobj, hit0.tr_id );
		TrainerEyeHitDataSet( &hit1, fldobj, hit0.range, hit0.dir );
		
		EventSet_Script( fsys, SCRID_TRAINER_MOVE_BATTLE, hit0.fldobj );//XNvgN
		
		EventSet_TrainerEyeData( fsys, hit0.fldobj,
				hit0.range, hit0.dir, hit0.scr_id, hit0.tr_id,
				SCR_EYE_TR_TYPE_DOUBLE, SCR_EYE_TR_0 );
		EventSet_TrainerEyeData( fsys, hit1.fldobj,
				hit1.range, hit1.dir, hit1.scr_id, hit1.tr_id,
				SCR_EYE_TR_TYPE_DOUBLE, SCR_EYE_TR_1 );
		
		OS_Printf( "g[i[_uqbg\n" );
		return( TRUE );
	}
	
	if( hit0.tr_type == SCR_EYE_TR_TYPE_TAG ){							//^bO
		int range,dir;
		FIELD_OBJ_PTR fldobj;
		EYE_MEET_HITDATA hit1;
		
		fldobj = TrainerPairCheck( fsys, fsys->fldobjsys, hit0.fldobj, hit0.tr_id );
		range = TrEyeLangeCheck( fldobj, fsys->player, &dir );			//`FbN
		
		if( range == EYE_CHECK_NOHIT ||											//qbgȂ
			CheckEventFlagTrainer(fsys,FldOBJTrainerIDGet(fldobj)) == TRUE ){	//퓬ς
			EventSet_Script( fsys, SCRID_TRAINER_MOVE_BATTLE, hit0.fldobj );//XNvgN
			
			EventSet_TrainerEyeData( fsys, hit0.fldobj,					//VÔ
				hit0.range, hit0.dir, hit0.scr_id, hit0.tr_id,
				SCR_EYE_TR_TYPE_SINGLE, SCR_EYE_TR_0 );
			
			OS_Printf( "g[i[^bOqbg@VÔ\n" );
			return( TRUE );
		}
		
		if( vs2 == FALSE ){
			return( FALSE );											//_uogs
		}
		
		TrainerEyeHitDataSet( &hit1, fldobj, range, dir );
		
		EventSet_Script( fsys, SCRID_TRAINER_MOVE_BATTLE, hit0.fldobj );//XNvgN
		
		EventSet_TrainerEyeData( fsys, hit0.fldobj,
			hit0.range, hit0.dir, hit0.scr_id, hit0.tr_id,
				SCR_EYE_TR_TYPE_TAG, SCR_EYE_TR_0 );
		EventSet_TrainerEyeData( fsys, hit1.fldobj,
			hit1.range, hit1.dir, hit1.scr_id, hit1.tr_id,
				SCR_EYE_TR_TYPE_TAG, SCR_EYE_TR_1 );
		
		OS_Printf( "g[i[^bOqbg@_u\n" );
		return( TRUE );
	}
	
	GF_ASSERT( 0 && "EvTrainerEyeCheck() ^Cvs\n" );
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * g[i[`FbN
 * @param	fsys	FIELDSYS_WORK *
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	jiki	PLAYER_STATE_PTR
 * @param	hit		EYE_MEET_HITDATA *
 * @retval	int		TRUE=g[i[qbg
 */
//--------------------------------------------------------------
static int TrainerEyeCheck( FIELDSYS_WORK *fsys, FIELD_OBJ_SYS_PTR fos,
		PLAYER_STATE_PTR jiki, EYE_MEET_HITDATA *hit )
{
	int i,range,dir;
	FIELD_OBJ_PTR fldobj;
	
	i = 0;
	fldobj = NULL;
	range = EYE_CHECK_NOHIT;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&i,FLDOBJ_STA_BIT_USE) ){
		range = TrEyeLangeCheck( fldobj, jiki, &dir );
		
		if( range != EYE_CHECK_NOHIT ){
			if( CheckEventFlagTrainer(fsys,FldOBJTrainerIDGet(fldobj)) == FALSE ){
				TrainerEyeHitDataSet( hit, fldobj, range, dir );		//퓬
				return( TRUE );
			}
		}
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * qbgi[
 * @param	hit		EYE_MEET_HITDATA
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	range	
 * @param	dir		ړ
 * @retval	nothing
 */
//--------------------------------------------------------------
static void TrainerEyeHitDataSet(
		EYE_MEET_HITDATA *hit, FIELD_OBJ_PTR fldobj, int range, int dir )
{
	hit->range = range;
	hit->dir = dir;
	hit->scr_id = FieldOBJ_EventIDGet( fldobj );
	hit->tr_id = GetTrainerIdByScriptId( hit->scr_id );
	hit->tr_type = CheckTrainer2vs2Type( hit->tr_id );
	hit->fldobj = fldobj;
}

//--------------------------------------------------------------
/**
 * Cxg^Cv擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		EV_TYPE_TRAINER
 */
//--------------------------------------------------------------
static int TrainerEventTypeGet( CONST_FIELD_OBJ_PTR fldobj )
{
	int type = FieldOBJ_EventTypeGet( fldobj );
	
	switch( type ){
	case EV_TYPE_TRAINER_KYORO:
	case EV_TYPE_TRAINER_SPIN_STOP_L:
	case EV_TYPE_TRAINER_SPIN_STOP_R:
	case EV_TYPE_TRAINER_SPIN_MOVE_L:
	case EV_TYPE_TRAINER_SPIN_MOVE_R:
		type = EV_TYPE_TRAINER;
		break;
	}
	
	return( type );
}

//==============================================================================
//	`FbN
//==============================================================================
//--------------------------------------------------------------
/**
 * g[i[͈̓`FbN
 * @param	fldobj		FIELD_OBJ_PTR
 * @param	jiki		PLAYER_STATE_PTR
 * @param	hit_dir		qbg̈ړBDIR_UP
 * @retval	int			qbg̎@܂ł̃ObhBEYE_CHECK_NOHIT=G[
 */
//--------------------------------------------------------------
static int TrEyeLangeCheck( CONST_FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki, int *hit_dir )
{
	int type,range,dir,jx,jz,ret;
	
	type = TrainerEventTypeGet( fldobj );
	
	if( type == EV_TYPE_TRAINER ){
		jx = Player_NowGPosXGet( jiki );
		jz = Player_NowGPosZGet( jiki );
		dir = FieldOBJ_DirDispGet( fldobj );
		range = FieldOBJ_ParamGet( fldobj, FLDOBJ_PARAM_0 );
		
		ret = TrEyeLineCheck( fldobj, dir, range, jx, jz, 0 );
		
		if( ret != EYE_CHECK_NOHIT ){
			if( TrEyeLineMoveHitCheck(fldobj,dir,ret) == FALSE ){
				*hit_dir = dir;
				return( ret );
			}
		}
		
		return( EYE_CHECK_NOHIT );
	}
	
	if( type == EV_TYPE_TRAINER_EYEALL ){						//4
		jx = Player_NowGPosXGet( jiki );
		jz = Player_NowGPosZGet( jiki );
		range = FieldOBJ_ParamGet( fldobj, FLDOBJ_PARAM_0 );
		
		dir = DIR_UP;
		
		do{
			ret = TrEyeLineCheck( fldobj, dir, range, jx, jz, 0 );
			
			if( ret != EYE_CHECK_NOHIT ){
				if( TrEyeLineMoveHitCheck(fldobj,dir,ret) == FALSE ){
					*hit_dir = dir;
					return( ret );
				}
			}
			
			dir++;
		}while( dir <= DIR_4_MAX );
		
		return( EYE_CHECK_NOHIT );
	}
	
	return( EYE_CHECK_NOHIT );
}

//--------------------------------------------------------------
/**
 * g[i[`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	dir		@DIR_UP
 * @param	range	
 * @param	x		@ObhX
 * @param	z		@Obhz
 * @param	y		@
 * @retval	int		@ւ̃Obh@EYE_CHECK_NOHIT=qbgȂ
 */
//--------------------------------------------------------------
static int TrEyeLineCheck( CONST_FIELD_OBJ_PTR fldobj, int dir, int range, int x, int z, int y )
{
	return( TrEyeLineCheckTbl[dir](fldobj,range,x,z,y) );
}

//--------------------------------------------------------------
/**
 * g[i[`FbN@
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	range	
 * @param	jx		@ObhX
 * @param	jz		@Obhz
 * @param	jy		@
 * @retval	int		@ւ̋@0=qbgȂ
 */
//--------------------------------------------------------------
static int TrEyeLineCheck_Up( CONST_FIELD_OBJ_PTR fldobj, int range, int jx, int jz, int jy )
{
	int x,z;
	
	x = FieldOBJ_NowPosGX_Get( fldobj );
	
	if( x == jx ){
		z = FieldOBJ_NowPosGZ_Get( fldobj );
		
		if( jz < z && jz >= (z-range) ){
			return( z - jz );
		}
	}
	
	return( EYE_CHECK_NOHIT );
}

//--------------------------------------------------------------
/**
 * g[i[`FbN@
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	range	
 * @param	jx		@ObhX
 * @param	jz		@Obhz
 * @param	jy		@
 * @retval	int		@ւ̋@0=qbgȂ
 */
//--------------------------------------------------------------
static int TrEyeLineCheck_Down( CONST_FIELD_OBJ_PTR fldobj, int range, int jx, int jz, int jy )
{
	int x,z;
	
	x = FieldOBJ_NowPosGX_Get( fldobj );
	
	if( x == jx ){
		z = FieldOBJ_NowPosGZ_Get( fldobj );
		
		if( jz > z && jz <= (z+range) ){
			return( jz - z );
		}
	}
	
	return( EYE_CHECK_NOHIT );
}

//--------------------------------------------------------------
/**
 * g[i[`FbN@
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	range	
 * @param	jx		@ObhX
 * @param	jz		@Obhz
 * @param	jy		@
 * @retval	int		@ւ̋@0=qbgȂ
 */
//--------------------------------------------------------------
static int TrEyeLineCheck_Left( CONST_FIELD_OBJ_PTR fldobj, int range, int jx, int jz, int jy )
{
	int x,z;
	
	z = FieldOBJ_NowPosGZ_Get( fldobj );
	
	if( z == jz ){
		x = FieldOBJ_NowPosGX_Get( fldobj );
		
		if( jx < x && jx >= (x-range) ){
			return( x - jx );
		}
	}
	
	return( EYE_CHECK_NOHIT );
}

//--------------------------------------------------------------
/**
 * g[i[`FbN@E
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	range	
 * @param	jx		@ObhX
 * @param	jz		@Obhz
 * @param	jy		@
 * @retval	int		@ւ̋@0=qbgȂ
 */
//--------------------------------------------------------------
static int TrEyeLineCheck_Right( CONST_FIELD_OBJ_PTR fldobj, int range, int jx, int jz, int jy )
{
	int x,z;
	
	z = FieldOBJ_NowPosGZ_Get( fldobj );
	
	if( z == jz ){
		x = FieldOBJ_NowPosGX_Get( fldobj );
		
		if( jx > x && jx <= (x+range) ){
			return( jx - x );
		}
	}
	
	return( EYE_CHECK_NOHIT );
}

//--------------------------------------------------------------
///	`FbNe[u
//--------------------------------------------------------------
static int (* const TrEyeLineCheckTbl[])(CONST_FIELD_OBJ_PTR,int range,int jx,int jz,int jy) =
{
	TrEyeLineCheck_Up,
	TrEyeLineCheck_Down,
	TrEyeLineCheck_Left,
	TrEyeLineCheck_Right,
};

//==============================================================================
//	@p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * ͈͈ړ
 * @param	fldobj		`FbNΏFIELD_OBJ_PTR
 * @param	dir			ړ
 * @param	range		ړ
 * @retval	int			TRUE=ړs
 */
//--------------------------------------------------------------
static int TrEyeLineMoveHitCheck( CONST_FIELD_OBJ_PTR fldobj, int dir, int range )
{
	int i,x,z,y;
	u32 ret;
	
	if( range == 0 ){
		return( TRUE );
	}
	
	x = FieldOBJ_NowPosGX_Get( fldobj );
	z = FieldOBJ_NowPosGZ_Get( fldobj );
	y = FieldOBJ_NowPosGY_Get( fldobj );
	
	x += FieldOBJ_DirAddValueGX( dir );
	z += FieldOBJ_DirAddValueGZ( dir );
	
	for( i = 0; i < (range-1); i++ ){
		ret = FieldOBJ_MoveHitCheckNow( fldobj, x, y, z );
		ret &= ~FLDOBJ_MOVE_HIT_BIT_LIM;						//ړ𖳎
		
		if( ret ){
			return( TRUE );										//ړȊOŃqbg
		}
		
		x += FieldOBJ_DirAddValueGX( dir );
		z += FieldOBJ_DirAddValueGZ( dir );
	}
	
	ret = FieldOBJ_MoveHitCheckNow( fldobj, x, y, z );
	ret &= ~FLDOBJ_MOVE_HIT_BIT_LIM;							//ړ𖳎
	
	if( ret == FLDOBJ_MOVE_HIT_BIT_OBJ ){						//OBJՓ(@)̂
		return( FALSE );
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJg[i[ID擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		g[i[ID
 */
//--------------------------------------------------------------
static int FldOBJTrainerIDGet( FIELD_OBJ_PTR fldobj )
{
	int scr_id;
	
	scr_id = FieldOBJ_EventIDGet( fldobj );
	return( GetTrainerIdByScriptId(scr_id) );
}

//--------------------------------------------------------------
/**
 * ̃g[i[IDT
 * @param	fsys	FIELDSYS_WORK
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	tr_obj	TĂFIELD_OBJ_PTR
 * @param	tr_id	g[i[ID
 * @retval	fldobj	FIELD_OBJ_PTR
 */
//--------------------------------------------------------------
static FIELD_OBJ_PTR TrainerPairCheck(
		FIELDSYS_WORK *fsys, FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_PTR tr_obj, int tr_id )
{
	int i;
	FIELD_OBJ_PTR fldobj;
	
	i = 0;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&i,FLDOBJ_STA_BIT_USE) ){
		if( fldobj != tr_obj ){
			int type = TrainerEventTypeGet( fldobj );
			
			if( type == EV_TYPE_TRAINER || type == EV_TYPE_TRAINER_EYEALL ){
				if( tr_id == FldOBJTrainerIDGet(fldobj) ){
					return( fldobj );
				}
			}
		}
	}
	
	GF_ASSERT( 0 && "TrainerPairCheck() yAs݁c\n" );
	return( NULL );
}

//==============================================================================
//	qbgɂړ
//==============================================================================
//--------------------------------------------------------------
/**
 * ړǉ
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		ړ
 * @param	range	ړ
 * @param	gyoe	!}[N
 * @retval	tcb		ړTCB_PTR
 */
//--------------------------------------------------------------
TCB_PTR EvTrainerEyeMoveSet(
		FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki, int dir, int range, int gyoe )
{
	return( TrEyeMeetMoveAddTcb(fldobj,jiki,dir,range) );
}

//--------------------------------------------------------------
/**
 * ړI`FbN
 * @param	tcb		EvTrainerEyeMoveSet()̖߂l
 * @retval	int 	TRUE=I@FALSE=܂
 */
//--------------------------------------------------------------
int EvTrainerEyeMoveEndCheck( TCB_PTR tcb )
{
	return( TrEyeMeetMoveEndCheck(tcb) );
}

//--------------------------------------------------------------
/**
 * ړI
 * @param	tcb		EvTrainerEyeMoveSet()̖߂l
 * @retval	nothing
 */
//--------------------------------------------------------------
void EvTrainerEyeMoveEnd( TCB_PTR tcb )
{
	TrEyeMeetMoveEnd( tcb );
}

//--------------------------------------------------------------
/**
 * ړǉ
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	jiki	PLAYER_STATE_PTR
 * @param	dir		ړ
 * @param	range	ړ
 * @retval	TCB_PTR	ړsTCB_PTR
 */
//--------------------------------------------------------------
static TCB_PTR TrEyeMeetMoveAddTcb(
		FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki, int dir, int range )
{
	TCB_PTR tcb;
	EYE_MEET_MOVE_WORK *work;
	
	work = sys_AllocMemoryLo( HEAPID_FIELD, EYE_MEET_MOVE_WORK_SIZE );
	GF_ASSERT( work != NULL && "TrEyeMeetMoveAddTcb()[Nmێs" );
	
	memset( work, 0, EYE_MEET_MOVE_WORK_SIZE );
	
	work->dir = dir;
	work->range = range;
	work->fldobj = fldobj;
	work->jiki = jiki;
	
	tcb = TCB_Add( TrEyeMeetMoveTCB, work, EYE_MEET_MOVE_TCB_PRI );
	GF_ASSERT( tcb != NULL && "TrEyeMeetMoveAddTcb()TCBǉs" );
	
	return( tcb );
}

//--------------------------------------------------------------
/**
 * ړI`FbN
 * @param	tcb		TrEyeMeetMoveAddTcb()̖߂lTCB_PTR
 * @retval	int		TRUE=I
 */
//--------------------------------------------------------------
static int TrEyeMeetMoveEndCheck( TCB_PTR tcb )
{
	EYE_MEET_MOVE_WORK *work;
	
	work = TCB_GetWork( tcb );
	return( work->end_flag );
}

//--------------------------------------------------------------
/**
 * ړI
 * @param	tcb		TrEyeMeetMoveAddTcb()̖߂lTCB_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void TrEyeMeetMoveEnd( TCB_PTR tcb )
{
	EYE_MEET_MOVE_WORK *work;
	
	work = TCB_GetWork( tcb );
	sys_FreeMemory( HEAPID_FIELD, work );
	TCB_Delete( tcb );
}

//--------------------------------------------------------------
/**
 * ړ@TCB
 * @param	tcb		TCB_PTR
 * @param	wk		TCB work
 * @retval	nothing
 */
//--------------------------------------------------------------
static void TrEyeMeetMoveTCB( TCB_PTR tcb, void *wk )
{
	EYE_MEET_MOVE_WORK *work;
	
	work = wk;
	
	while( DATA_EyeMeetMoveTbl[work->seq_no](work) == TRUE ){};
}

//--------------------------------------------------------------
/**
 * ړ@OBJI҂
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_OBJMoveWait( EYE_MEET_MOVE_WORK *work )
{
	FIELD_OBJ_PTR fldobj = work->fldobj;
	
	if( FieldOBJ_StatusBitCheck_Move(fldobj) == TRUE ){
		return( FALSE );
	}
	
	FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_PAUSE_MOVE );
	work->seq_no = SEQNO_TRMOVE_GYOE_SET;
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ړ@т}[No
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_GyoeSet( EYE_MEET_MOVE_WORK *work )
{
	work->gyoe = FE_FldOBJGyoe_Add( work->fldobj );
	work->seq_no = SEQNO_TRMOVE_GYOE_WAIT;
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ړ@т}[N\I҂
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_GyoeWait( EYE_MEET_MOVE_WORK *work )
{
	if( FE_FldOBJGyoe_EndCheck(work->gyoe) == TRUE ){
		EOA_Delete( work->gyoe );
		work->seq_no = SEQNO_TRMOVE_GYOE_END_WAIT;
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ړ@т}[N\I̊
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_GyoeEndWait( EYE_MEET_MOVE_WORK *work )
{
	work->count++;
	
	if( work->count >= EYE_MEET_GYOE_END_WAIT ){
		work->count = 0;
		work->seq_no = SEQNO_TRMOVE_MOVE_RANGE_CHECK;
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ړ@ړ`FbN
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_MoveRangeCheck( EYE_MEET_MOVE_WORK *work )
{
	if( work->range <= 1 ){									//@ڂ̑O ړKvȂ
		work->seq_no = SEQNO_TRMOVE_MOVE_END_WAIT;
		return( TRUE );	
	}

	work->seq_no = SEQNO_TRMOVE_MOVE_START;
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ړ@ړJn
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_MoveStart( EYE_MEET_MOVE_WORK *work )
{
	int code;

	if( FieldOBJ_AcmdSetCheck(work->fldobj) == TRUE ){
		code = FieldOBJ_AcmdCodeDirChange( work->dir, AC_WALK_U_8F );
		FieldOBJ_AcmdSet( work->fldobj, code );
		work->seq_no = SEQNO_TRMOVE_MOVE;
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ړ@ړ
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_Move( EYE_MEET_MOVE_WORK *work )
{
	if( FieldOBJ_AcmdEndCheck(work->fldobj) == FALSE ){
		return( FALSE );
	}
	
	work->range--;											//炷
	work->seq_no = SEQNO_TRMOVE_MOVE_RANGE_CHECK;
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ړ@ړI̊
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_MoveEndWait( EYE_MEET_MOVE_WORK *work )
{
	work->count++;
	
	if( work->count < EYE_MEET_MOVE_END_WAIT ){
		return( FALSE );
	}
	
	work->count = 0;
	work->seq_no = SEQNO_TRMOVE_JIKI_TURN_SET;
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ړ@@U
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_JikiTurnSet( EYE_MEET_MOVE_WORK *work )
{
	int turn_dir;
	FIELD_OBJ_PTR fldobj;
	
	fldobj = Player_FieldOBJGet( work->jiki );
	
	turn_dir = FieldOBJTool_DirRange(
			FieldOBJ_NowPosGX_Get(fldobj), FieldOBJ_NowPosGZ_Get(fldobj),
			FieldOBJ_NowPosGX_Get(work->fldobj), FieldOBJ_NowPosGZ_Get(work->fldobj) );
	
	if( Player_DirGet(work->jiki) != turn_dir ){
		if( FieldOBJ_AcmdSetCheck(fldobj) == TRUE ){
			int code = FieldOBJ_AcmdCodeDirChange( turn_dir, AC_DIR_U );
			FieldOBJ_AcmdSet( fldobj, code );
		
			work->seq_no = SEQNO_TRMOVE_JIKI_TURN;
		}
	}else{
		work->seq_no = SEQNO_TRMOVE_ACMD_END;
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * ړ@@UI҂
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_JikiTurn( EYE_MEET_MOVE_WORK *work )
{
	FIELD_OBJ_PTR fldobj;
	
	fldobj = Player_FieldOBJGet( work->jiki );
	
	if( FieldOBJ_AcmdEndCheck(fldobj) == FALSE ){
		return( FALSE );
	}
	
	FieldOBJ_AcmdEnd( fldobj );
	work->seq_no = SEQNO_TRMOVE_ACMD_END;
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ړ@AjI
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_AcmdEnd( EYE_MEET_MOVE_WORK *work )
{
	FieldOBJ_AcmdEnd( work->fldobj );
//	FieldOBJ_StatusBit_OFF( work->fldobj, FLDOBJ_STA_BIT_PAUSE_MOVE );	//|[Y
	work->seq_no = SEQNO_TRMOVE_END;
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * ړ@I
 * @param	work	EYE_MEET_MOVE_WORK
 * @retval	int		TRUE=ċA
 */
//--------------------------------------------------------------
static int EyeMeetMove_End( EYE_MEET_MOVE_WORK *work )
{
	work->end_flag = TRUE;
	return( FALSE );
}

//--------------------------------------------------------------
///	ړe[u
//--------------------------------------------------------------
static int (* const DATA_EyeMeetMoveTbl[])( EYE_MEET_MOVE_WORK *work ) =
{
	EyeMeetMove_OBJMoveWait,
	EyeMeetMove_GyoeSet,
	EyeMeetMove_GyoeWait,
	EyeMeetMove_GyoeEndWait,
	EyeMeetMove_MoveRangeCheck,
	EyeMeetMove_MoveStart,
	EyeMeetMove_Move,
	EyeMeetMove_MoveEndWait,
	EyeMeetMove_JikiTurnSet,
	EyeMeetMove_JikiTurn,
	EyeMeetMove_AcmdEnd,
	EyeMeetMove_End,
};

//==============================================================================
//	XNvgR}h
//	add nohara
//==============================================================================
#if 0
//--------------------------------------------------------------
/**
 * CxgN 
 * @param	fsys		FIELDSYS_WORK
 * @param	fldobj		ΏۃtB[hOBJ
 * @param	tcb			ړTCB_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void TrEyeMeetEventStart( FIELDSYS_WORK *fsys, FIELD_OBJ_PTR fldobj, TCB_PTR tcb )
{
	EYE_MEET_EVENT_WORK *work;
	
	work = sys_AllocMemoryLo( HEAPID_FIELD, EYE_MEET_EVENT_WORK_SIZE );
	GF_ASSERT( work != NULL && "TrEyeMeetEventStart()[Nmێs" );
	
	memset( work, 0, EYE_MEET_EVENT_WORK_SIZE );
	
	work->fsys = fsys;
	work->fldobj = fldobj;
	work->tcb_eye_meet = tcb;
	
	FieldEvent_Set( fsys, TrEyeMeetEvent, work );
}

//--------------------------------------------------------------
/**
 * CxgI
 * @param	work		EYE_MEET_EVENT_WORK
 * @retval	nothing
 */
//--------------------------------------------------------------
static void TrEyeMeetEventEnd( EYE_MEET_EVENT_WORK *work )
{
	sys_FreeMemory( HEAPID_FIELD, work );
}

//--------------------------------------------------------------
/**
 * Cxg
 * @param	ev		GMEVENT_CONTROL	*
 * @retval	BOOL	TRUE=CxgI
 */
//--------------------------------------------------------------
static BOOL TrEyeMeetEvent( GMEVENT_CONTROL *ev )
{
	EYE_MEET_EVENT_WORK *work;
	
	work = FieldEvent_GetSpecialWork( ev );
	
	switch( work->seq_no ){
	case 0:
		if( TrEyeMeetMoveEndCheck(work->tcb_eye_meet) == TRUE ){
			work->seq_no++;
		}
		
		break;
	case 1:
		work->seq_no++;
		break;
	case 2:
		TrEyeMeetMoveEnd( work->tcb_eye_meet );
		TrEyeMeetEventEnd( work );
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * g[i[ړTCBǉ
 * @param	fldobj	ΏۂFIELD_OBJ_PTR
 * @param	jiki	PLAYER_STATE
 * @param	dir		ړ
 * @param	range	ړ
 * @retval	TCB_PTR	ړTCB_PTR
 */
//--------------------------------------------------------------
TCB_PTR EvCall_TrEyeMeetMoveAddTcb(
		FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki, int dir, int range )
{
	return( TrEyeMeetMoveAddTcb(fldobj,jiki,dir,range) );
}

//--------------------------------------------------------------
/**
 * g[i[擾
 * @param	fldobj	ΏFIELD_OBJ_PTR
 * @param	jiki	PLAYER_STATE_PTR
 * @retval	int		BqbgȂ=-1
 */
//--------------------------------------------------------------
int EvCall_TrEyeRangeCheck( CONST_FIELD_OBJ_PTR fldobj, PLAYER_STATE_PTR jiki )
{
	int dir;
	return( TrEyeLangeCheck(fldobj,jiki,&dir) );
}

//--------------------------------------------------------------
/**
 * CxgN 
 * @param	fsys		FIELDSYS_WORK
 * @param	fldobj		ΏۃtB[hOBJ
 * @param	tcb			ړTCB_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void GMEVENT_Call_TrEyeMeetEventStart(
		FIELDSYS_WORK *fsys, GMEVENT_CONTROL * event, FIELD_OBJ_PTR fldobj, TCB_PTR tcb )
{
	EYE_MEET_EVENT_WORK *work;
	
	work = sys_AllocMemoryLo( HEAPID_FIELD, EYE_MEET_EVENT_WORK_SIZE );
	GF_ASSERT( work != NULL && "TrEyeMeetEventStart()[Nmێs" );
	
	memset( work, 0, EYE_MEET_EVENT_WORK_SIZE );
	
	work->fsys = fsys;
	work->fldobj = fldobj;
	work->tcb_eye_meet = tcb;
	
	FieldEvent_Call( event, TrEyeMeetEvent, work );
}
#endif
