//============================================================================================
/**
 * @file	eventdata.c
 * @brief	][ɓǂݍރCxgf[^̏
 * @author	tamada	GAME FREAK Inc.
 * @date	2005.10.17
 */
//============================================================================================

#include "common.h"
#include "mapdefine.h"

#include "fieldsys.h"

#include "zonedata.h"

#include "fieldobj.h"

#include "system/arc_tool.h"

#include "eventdata.h"

#include "encount_dat.h"

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	][̃Cxgf[^\
 *
 * ][ɐđgݍ܂Cxgf[^oCi
 * ͂Ă̍\̂ɒlB
 */
//------------------------------------------------------------------
struct EVENT_DATA{
	u32 bg_count;
	u32 npc_count;
	u32 connect_count;
	u32 posevent_count;
	const BG_TALK_DATA * bg_data;
	const struct _TAG_FIELD_OBJ_H * npc_data;
	const CONNECT_DATA * connect_data;
	const POS_EVENT_DATA * posevent_data;
	u32 buffer[0x800 / sizeof(u32)];
	u32 sp_scr[0x100 / sizeof(u32)];
	ENCOUNT_DATA enc_work;
};


//------------------------------------------------------------------
//------------------------------------------------------------------

static void LoadEventData(EVENT_DATA * eventdata, int zone_id);
static void MakeEventData(EVENT_DATA * event_data);
static void LoadEncountData(EVENT_DATA * event_data, int zone_id);
static void LoadSpecialScriptData(EVENT_DATA * eventdata, int zone_id);
//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	Cxgf[^F
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void EventData_Sys_Create(FIELDSYS_WORK * fsys, int heapID)
{
	EVENT_DATA * eventdata;
	GF_ASSERT(fsys->eventdata == NULL);
	fsys->eventdata = sys_AllocMemory(heapID, sizeof(EVENT_DATA));
}

//------------------------------------------------------------------
/**
 * @brief	Cxgf[^F
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void EventData_Sys_Delete(FIELDSYS_WORK * fsys)
{
	GF_ASSERT(fsys->eventdata != NULL);
	sys_FreeMemoryEz(fsys->eventdata);
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	][Ƃ̃Cxgf[^ǂݍ
 * @param	zone_id		][ID̎w
 *
 * ][Ƃ̃Cxgf[^oCiǂݍŃCxgf[^\̂
 * 
 */
//------------------------------------------------------------------
void EventData_LoadZoneData(FIELDSYS_WORK * fsys, int zone_id)
{
	GF_ASSERT(fsys->eventdata != NULL);
	LoadEventData(fsys->eventdata, zone_id);
	MakeEventData(fsys->eventdata);
	LoadEncountData(fsys->eventdata, zone_id);
	LoadSpecialScriptData(fsys->eventdata, zone_id);
}

//------------------------------------------------------------------
//------------------------------------------------------------------
static void LoadEventData(EVENT_DATA * eventdata, int zone_id)
{
	int index;
	index = ZoneData_GetEventID(zone_id);
	GF_ASSERT(ArchiveDataSizeGet(ARC_EVENTDATA, index) < sizeof(eventdata->buffer));
	ArchiveDataLoad(eventdata->buffer, ARC_EVENTDATA, index);
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[hNPC̃Zbg
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
void EventData_SetFieldOBJ(FIELDSYS_WORK * fsys)
{
	int num = fsys->eventdata->npc_count;
	GF_ASSERT(fsys->eventdata != NULL);
	if (num != 0) {
		FieldOBJ_AddBin(fsys->fldobjsys, fsys->location->zone_id, num, fsys->eventdata->npc_data);
	}
}

//------------------------------------------------------------------
/**
 * @brief	BGbCxgf[^̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	f[^擪ւ̃|C^
 */
//------------------------------------------------------------------
const BG_TALK_DATA * EventData_GetNowBgTalkData(const FIELDSYS_WORK * fsys)
{
	return fsys->eventdata->bg_data;
}
//------------------------------------------------------------------
/**
 * @brief	BGbCxgf[^̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	f[^
 */
//------------------------------------------------------------------
int EventData_GetNowBgTalkDataSize(const FIELDSYS_WORK * fsys)
{
	return fsys->eventdata->bg_count;
}

//------------------------------------------------------------------
/**
 * @brief	}bvڑf[^̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	f[^
 */
//------------------------------------------------------------------
int EventData_GetNowConnectDataSize(const FIELDSYS_WORK * fsys)
{
	return fsys->eventdata->connect_count;
}
//------------------------------------------------------------------
/**
 * @brief	}bvڑf[^̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	id		oID
 * @retval	NULLȊO	w肵f[^ւ̃|C^
 * @retval	NULL		f[^݂Ȃ
 */
//------------------------------------------------------------------
const CONNECT_DATA * EventData_GetNowConnectDataByID(const FIELDSYS_WORK * fsys, int door_id)
{
	if (door_id >= fsys->eventdata->connect_count) {
		OS_Printf("door_id error\n");
		return NULL;
	}
	return &fsys->eventdata->connect_data[door_id];
}
//------------------------------------------------------------------
/**
 * @brief	}bvڑf[^ID̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	x		TXʒuiObhPʁj
 * @param	z		TZʒuiObhPʁj
 * @return	int	oID
 * @return	-1	o݂Ȃꍇ
 */
//------------------------------------------------------------------
int EventData_SearchNowConnectIDByXZ(const FIELDSYS_WORK * fsys, int x, int z)
{
	int door_id;

	for (door_id = 0; door_id < fsys->eventdata->connect_count; door_id ++) {
		if (fsys->eventdata->connect_data[door_id].x == x &&
			fsys->eventdata->connect_data[door_id].z == z) {
			return door_id;
		}
	}
	return -1;
}

//------------------------------------------------------------------
/**
 * @brief	POSCxg̃f[^擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	POSCxg̃f[^
 */
//------------------------------------------------------------------
int EventData_GetNowPosEventDataSize(const FIELDSYS_WORK * fsys)
{
	return fsys->eventdata->posevent_count;
}
//------------------------------------------------------------------
/**
 * @brief	POSCxg̃f[^擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	f[^擪ւ̃|C^
 */
//------------------------------------------------------------------
const POS_EVENT_DATA * EventData_GetNowPosEventData(const FIELDSYS_WORK * fsys)
{
	return fsys->eventdata->posevent_data;
}

//------------------------------------------------------------------
/**
 * @brief	npc_count擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	"npc_count"
 */
//------------------------------------------------------------------
u32 EventData_GetNpcCount(const FIELDSYS_WORK * fsys)
{
	return fsys->eventdata->npc_count;
}

//------------------------------------------------------------------
/**
 * @brief	npc_data擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	"npc_data"
 */
//------------------------------------------------------------------
const FIELD_OBJ_H* EventData_GetNpcData(const FIELDSYS_WORK * fsys)
{
	return fsys->eventdata->npc_data;
}

//------------------------------------------------------------------
/**
 * @brief	npc_data̍W
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	id		ID
 * @param	gx		ObhX
 * @param	gz		ObhZ
 * @return	"TRUE=AFALSE=s"
 */
//------------------------------------------------------------------
BOOL EventData_NpcDataPosChange(FIELDSYS_WORK * fsys, int id, u16 gx, u16 gz )
{
	int i;
	FIELD_OBJ_H* p	= (FIELD_OBJ_H*)fsys->eventdata->npc_data;
	u32 max			= fsys->eventdata->npc_count;

	for( i=0; i < max ;i++ ){
		if( p[i].id == id ){		//ID
			p[i].gx = gx;
			p[i].gz = gz;
			return TRUE;
		}
	}

	GF_ASSERT( (0) && "ID܂łI" );
	return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	npc_data̕
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	id		ID
 * @param	dir		
 * @return	"TRUE=AFALSE=s"
 */
//------------------------------------------------------------------
BOOL EventData_NpcDataDirChange(FIELDSYS_WORK * fsys, int id, int dir );
BOOL EventData_NpcDataDirChange(FIELDSYS_WORK * fsys, int id, int dir )
{
	int i;
	FIELD_OBJ_H* p	= (FIELD_OBJ_H*)fsys->eventdata->npc_data;
	u32 max			= fsys->eventdata->npc_count;

	for( i=0; i < max ;i++ ){
		if( p[i].id == id ){		//ID
			p[i].dir = dir;
			return TRUE;
		}
	}

	GF_ASSERT( (0) && "ID܂łI" );
	return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	npc_data̓R[h
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	id		ID
 * @param	mv		R[h
 * @return	"TRUE=AFALSE=s"
 */
//------------------------------------------------------------------
BOOL EventData_NpcDataMoveCodeChange(FIELDSYS_WORK * fsys, int id, int mv );
BOOL EventData_NpcDataMoveCodeChange(FIELDSYS_WORK * fsys, int id, int mv )
{
	int i;
	FIELD_OBJ_H* p	= (FIELD_OBJ_H*)fsys->eventdata->npc_data;
	u32 max			= fsys->eventdata->npc_count;

	for( i=0; i < max ;i++ ){
		if( p[i].id == id ){		//ID
			p[i].move_code =mv;
			return TRUE;
		}
	}

	GF_ASSERT( (0) && "ID܂łI" );
	return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	Cxgf[^
 * @param	event_data	EVENT_DATA\̂ւ̃|C^
 *
 * EVENT_DATA::bufferɓǂݍ܂ĂoCif[^
 * ͂EVENT_DATA\̂̂ق̃o[𐶐B
 */
//------------------------------------------------------------------
static void MakeEventData(EVENT_DATA * event_data)
{
	const u8 * buffer = (const u8 *)event_data->buffer;

	//BGbCxgf[^ǂݍ
	event_data->bg_count = *(u32 *)buffer;
	buffer += sizeof(u32);
	if (event_data->bg_count != 0) {
		event_data->bg_data = (const BG_TALK_DATA *)buffer;
	} else {
		event_data->bg_data = NULL;
	}
	buffer += sizeof(BG_TALK_DATA) * event_data->bg_count;

	//NPCzuf[^ǂݍ
	event_data->npc_count = *(u32 *)buffer;
	buffer += sizeof(u32);
	if (event_data->npc_count != 0) {
		event_data->npc_data = (const struct _TAG_FIELD_OBJ_H *)buffer;
	} else {
		event_data->npc_data = NULL;
	}
	buffer += sizeof(struct _TAG_FIELD_OBJ_H) * event_data->npc_count;

	//}bvڑf[^ǂݍ
	event_data->connect_count = *(u32 *)buffer;
	buffer += sizeof(u32);
	if (event_data->connect_count != 0) {
		event_data->connect_data = (const CONNECT_DATA *)buffer;
	} else {
		event_data->connect_data = NULL;
	}
	buffer += sizeof(CONNECT_DATA) * event_data->connect_count;

	//POSCxgf[^ǂݍ
	event_data->posevent_count = *(u32 *)buffer;
	buffer += sizeof(u32);
	if (event_data->posevent_count != 0) {
		event_data->posevent_data = (const POS_EVENT_DATA *)buffer;
	} else {
		event_data->posevent_data = NULL;
	}
	buffer += sizeof(POS_EVENT_DATA) * event_data->posevent_count;
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	][̃GJEgf[^̓ǂݍ
 * @param	zone_id		][ID̎w
 * @param	event_data	EVENT_DATA\̂ւ̃|C^
 */
//------------------------------------------------------------------
static void LoadEncountData(EVENT_DATA * event_data, int zone_id)
{
	memset(&event_data->enc_work, 0, sizeof(ENCOUNT_DATA));
	if (ZoneData_GetEncountFlag(zone_id)) {
		ArchiveDataLoad(&event_data->enc_work, ARC_ENCOUNT,
				ZoneData_GetEncountArchiveID(zone_id));
	}
}

//------------------------------------------------------------------
/**
 * @brief	GJEgf[^̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	void * GJEgf[^̐擪AhX
 *
 * {Iɂ͂const ENCOUNT_DATA^ԂׂJꂷȂ̂
 * bIvoid *ŕԂĂBŏC\
 */
//------------------------------------------------------------------
void * EventData_GetEncountData(const FIELDSYS_WORK * fsys)
{
	return &fsys->eventdata->enc_work;
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	][̓XNvgf[^̓ǂݍ
 * @param	zone_id		][ID̎w
 * @param	event_data	EVENT_DATA\̂ւ̃|C^
 */
//------------------------------------------------------------------
static void LoadSpecialScriptData(EVENT_DATA * eventdata, int zone_id)
{
	int index;
	index = ZoneData_GetSpScriptArchiveID(zone_id);
	MI_CpuClearFast(eventdata->sp_scr, sizeof(eventdata->sp_scr));
	GF_ASSERT(ArchiveDataSizeGet(ARC_SCRIPT, index) < sizeof(eventdata->sp_scr));
	ArchiveDataLoad(eventdata->sp_scr, ARC_SCRIPT, index);
}

//------------------------------------------------------------------
/**
 * @brief	XNvgf[^̎擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	void * XNvgf[^̐擪AhX
 *
 */
//------------------------------------------------------------------
void * EventData_GetSpecialScript(const FIELDSYS_WORK * fsys)
{
	GF_ASSERT(fsys->eventdata != NULL);
	return &fsys->eventdata->sp_scr;
}


