//============================================================================================
/**
 * @file	eventdata.h
 * @brief	CxgN`FbNpf[^`wb_
 * @date	2005.10.14
 *
 * 2005.10.18	check_data.h-->eventdata.hɃl[
 */
//============================================================================================
#ifndef	__EVENTDATA_H__
#define	__EVENTDATA_H__

#include "check_data.h"

extern void EventData_Sys_Create(FIELDSYS_WORK * fsys, int heapID);
extern void EventData_Sys_Delete(FIELDSYS_WORK * fsys);

extern const BG_TALK_DATA * EventData_GetNowBgTalkData(const FIELDSYS_WORK * fsys);
extern int EventData_GetNowBgTalkDataSize(const FIELDSYS_WORK * fsys);
extern int EventData_GetNowConnectDataSize(const FIELDSYS_WORK * fsys);
extern int EventData_SearchNowConnectIDByXZ(const FIELDSYS_WORK * fsys, int x, int z);
extern const CONNECT_DATA * EventData_GetNowConnectDataByID(const FIELDSYS_WORK * fsys, int door_id);
extern int EventData_GetNowPosEventDataSize(const FIELDSYS_WORK * fsys);
extern const POS_EVENT_DATA * EventData_GetNowPosEventData(const FIELDSYS_WORK * fsys);

//------------------------------------------------------------------
/**
 * @brief	npc_count擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	"npc_count"
 */
//------------------------------------------------------------------
extern u32 EventData_GetNpcCount(const FIELDSYS_WORK * fsys);

//------------------------------------------------------------------
/**
 * @brief	npc_data擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	"npc_data"
 */
//------------------------------------------------------------------
extern const FIELD_OBJ_H* EventData_GetNpcData(const FIELDSYS_WORK * fsys);

//------------------------------------------------------------------
/**
 * @brief	npc_data̍W
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	id		ID
 * @param	gx		ObhX
 * @param	gz		ObhZ
 * @return	"TRUE=AFALSE=s"
 */
//------------------------------------------------------------------
extern BOOL EventData_NpcDataPosChange(FIELDSYS_WORK * fsys, int id, u16 gx, u16 gz );

//------------------------------------------------------------------
/**
 * @brief	npc_data̕
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	id		ID
 * @param	dir		
 * @return	"TRUE=AFALSE=s"
 */
//------------------------------------------------------------------
extern BOOL EventData_NpcDataDirChange(FIELDSYS_WORK * fsys, int id, int dir );

//------------------------------------------------------------------
/**
 * @brief	npc_data̓R[h
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	id		ID
 * @param	mv		R[h
 * @return	"TRUE=AFALSE=s"
 */
//------------------------------------------------------------------
extern BOOL EventData_NpcDataMoveCodeChange(FIELDSYS_WORK * fsys, int id, int mv );

extern void EventData_LoadZoneData(FIELDSYS_WORK * fsys, int zone_id);
extern void EventData_SetFieldOBJ(FIELDSYS_WORK * fsys);

extern void * EventData_GetEncountData(const FIELDSYS_WORK * fsys);
extern void * EventData_GetSpecialScript(const FIELDSYS_WORK * fsys);

#endif	/*	__EVENTDATA_H__ */
