//============================================================================================
/**
 * @file	eventflag.c
 * @bfief	Z[utOA[N
 * @author	Tamada
 * @author	Satoshi Nohara
 * @date	05.10.22
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"

#include "system/gamedata.h"
#include "system/savedata.h"		//SaveData_Get & GMDATA_ID_EVENT_WORK

#include "field/eventflag.h"		//EVENTWORK
#include "script.h"
#include "field/evwkdef.h"


//=============================================================================
//=============================================================================
//------------------------------------------------------------------
/**
 * @brief	Cxg[N\̂̒`
 */
//------------------------------------------------------------------
struct _EVENTWORK {
	u16 work[EVENT_WORK_AREA_MAX];	//[N
	u8	flag[EVENT_FLAG_AREA_MAX];	//tO
};

//Z[uȂtO
static u8 EventCtrlFlag[CTRLFLAG_AREA_MAX] = {};


//=============================================================================
//=============================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
int EventWork_GetWorkSize(void)
{
	return sizeof(EVENTWORK);
}

//------------------------------------------------------------------
/**
 * @brief	Cxg[N𐶐
 *
 * @param	heapID		q[vID
 *
 * @return	EVENTWORKւ̃|C^
 */
//------------------------------------------------------------------
EVENTWORK * EventWork_AllocWork(int heapID)
{
	EVENTWORK * event;
	event = sys_AllocMemory(heapID, sizeof(EVENTWORK));

	EventWork_Init(event);

	return event;
}

//------------------------------------------------------------------
/**
 * @brief	Cxg[N̏
 * @param	evwk	EVENTWORKւ̃|C^
 */
//------------------------------------------------------------------
void EventWork_Init(EVENTWORK * evwk)
{
	//sȒlĂ̂ŃNA
	memset( evwk, 0, sizeof(EVENTWORK) );
}

//------------------------------------------------------------------
/**
 * @brief	Z[uf[^Cxg[Nւ̃|C^擾
 *
 * @param	sv	Z[uf[^ւ̃|C^
 *
 * @return	Z[uf[^EVENTWORKւ̃|C^
 */
//------------------------------------------------------------------
EVENTWORK * SaveData_GetEventWork(SAVEDATA * sv)
{
	EVENTWORK * event;
	event = (EVENTWORK *)SaveData_Get(sv, GMDATA_ID_EVENT_WORK);
	return event;
}

//------------------------------------------------------------------
/**
 * @brief	CxgtO`FbN
 *
 * @param	ev			Cxg[Nւ̃|C^
 * @param	flag_no		tOio[
 *
 * @retval	"1 = tOON"
 * @retval	"0 = tOOFF"
 */
//------------------------------------------------------------------
BOOL EventWork_CheckEventFlag( EVENTWORK * ev, u16 flag_no)
{
	u8 * p = EventWork_GetEventFlagAdrs( ev, flag_no );
	if( p != NULL ){
		if( *p & ( 1 << (flag_no % 8) ) ){ return 1; }
	}
	return 0;
}


//------------------------------------------------------------------
/**
 * @brief	CxgtOZbg
 *
 * @param	ev			Cxg[Nւ̃|C^
 * @param	flag_no		tOio[
 *
 * @return	none
 */
//------------------------------------------------------------------
void EventWork_SetEventFlag( EVENTWORK * ev, u16 flag_no)
{
	u8 * p = EventWork_GetEventFlagAdrs( ev, flag_no );
	if( p == NULL ){ return; }
	*p |= 1 << ( flag_no % 8 );
	return;
}


//------------------------------------------------------------------
/**
 * @brief	CxgtOZbg
 *
 * @param	ev			Cxg[Nւ̃|C^
 * @param	flag_no		tOio[
 *
 * @return	none
 */
//------------------------------------------------------------------
void EventWork_ResetEventFlag( EVENTWORK * ev, u16 flag_no)
{
	u8 * p = EventWork_GetEventFlagAdrs( ev, flag_no );
	if( p == NULL ){ return; }
	*p &= ( 0xff ^ ( 1 << (flag_no % 8) ) );
	return;
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	CxgtÕAhX擾
 *
 * @param	flag_no		tOio[
 *
 * @retval	"NULL != tOAhX"
 * @retval	"NULL = `"
 */
//--------------------------------------------------------------------------------------------
u8 * EventWork_GetEventFlagAdrs( EVENTWORK * ev, u16 flag_no )
{
	if( flag_no == 0 ){
		return NULL;
	}else if( flag_no < SCFLG_START ){
		return &ev->flag[flag_no/8];
	}else{
		return &( EventCtrlFlag[ (flag_no - SCFLG_START) / 8 ] );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * @brief	Cxg[NAhX擾
 *
 * @param	ev			Cxg[Nւ̃|C^
 * @param	fsys		FIELDSYS_WORKւ̃|C^
 * @param	work_no		[Nio[
 *
 * @return	"[ÑAhX"
 *
 * @li	work_no < 0x8000	ʏ̃Z[u[N
 * @li	work_no >= 0x8000	XNvg䃏[N̒ɊmۂĂ郏[N
 */
//--------------------------------------------------------------------------------------------
u16 * EventWork_GetEventWorkAdrs( EVENTWORK * ev, u16 work_no )
{
	return &ev->work[ work_no - SVWK_START ];
}


