//============================================================================================
/**
 * @file	fd_shop.c
 * @brief	thBVbv
 * @author	Hiroyuki Nakamura
 * @date	2004.12.15
 */
//============================================================================================
#include "common.h"
#include "system/procsys.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/window.h"
#include "system/fontproc.h"
#include "system/msgdata.h"
#include "system/wordset.h"
#include "system/buflen.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"
#include "system/snd_tool.h"
#include "itemtool/item.h"
#include "itemtool/myitem.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_shop.h"
#include "application/app_tool.h"
#include "application/bag.h"

#include "system/clact_util.h"
#include "system/clact_tool.h"
#include "system/render_oam.h"
//#include "gflib/display.h"
//#include "gflib/char_manager.h"
//#include "gflib/pltt_manager.h"


#include "fieldsys.h"
#include "fieldmap.h"
#include "field_clact.h"
#include "fld_bmp.h"
#include "talk_msg.h"

#define	FD_SHOP_H_GLOBAL
#include "fd_shop.h"
#include "fd_shop_snd_def.h"
#include "shop_gra.naix"


//============================================================================================
//	萔`
//============================================================================================
enum {
	SHOP_SEQ_INIT = 0,
	SHOP_SEQ_MENU,

	SHOP_SEQ_BUY_INIT,		// wʏ
	SHOP_SEQ_BUY_SCROLL,	// wʒuփXN[
	SHOP_SEQ_BUY_SELECT,	// ACeI
	SHOP_SEQ_BUYSEL_WAIT,	// u`v\EFCg
	SHOP_SEQ_BUYNUM_SEL,	// I
	SHOP_SEQ_BUYNUM_WAIT,	// uv`Ȃ܂v\EFCg
	SHOP_SEQ_BUY_YESNO,		// ͂EI
	SHOP_SEQ_BUY_CMP,		// w
	SHOP_SEQ_BUYCMP_WAIT,	// ACeI
	SHOP_SEQ_BUY_END,		// wʏI

	SHOP_SEQ_MENU_RET,		// j[I֖߂҂

	SHOP_SEQ_SALE_INIT,		// uv
	SHOP_SEQ_SALE_CALL,		// uvĂяo
	SHOP_SEQ_SALE_WAIT,		// uvI҂
	SHOP_SEQ_SALE_RET,		// uvI -> tF[hC
	SHOP_SEQ_SALE_MENU_RET,	// tF[hC -> j[

	SHOP_SEQ_EXIT,
	SHOP_SEQ_END
};

enum {
	WIN_IDX_NENU = 0,	// j[
	WIN_IDX_FLDTALK,	// tB[hb

	WIN_IDX_LIST = 0,	// ACeXg
	WIN_IDX_INFO,		// ACe
	WIN_IDX_GOLD,		// 
	WIN_IDX_NUM,		// I
	WIN_IDX_MINE,		// Ă鐔
	WIN_IDX_TALK,		// b
//	WIN_IDX_YESNO,		// ͂E

	WIN_IDX_MAX
};

enum {
	SHOP_CLA_ARROW_U = 0,
	SHOP_CLA_ARROW_D,
	SHOP_CLA_CURSOR,
	SHOP_CLA_ITEMICON,
	SHOP_CLA_MAX
};

typedef struct {
	GF_BGL_INI * bgl;		// BGLf[^

	void * bag_wk;			// obÕ[N

	GF_BGL_BMPWIN	win[WIN_IDX_MAX];	// BMPEBhE
	GF_BGL_BMPWIN	yn_win;				// BMPEBhEi͂Ej

	BMPLIST_WORK * lw;		// BMPj[[N
	BMP_MENULIST_DATA * ld;	// BMPXgf[^

	BMPMENU_WORK * mw;		// BMPj[[N
	BMP_MENULIST_DATA * md;	// BMPj[f[^

	MSGDATA_MANAGER * mman;	// bZ[Wf[^}l[W
	WORDSET * wset;			// PZbg

	GF_CAMERA_PTR	camera;


/*
	CLACT_SET_PTR	cas;
	CLACT_U_EASYRENDER_DATA	renddata;	// ȈՃ_[f[^
	CLACT_HEADER_TBL_PTR	clh;		// wb_[
	CLACT_U_RES_MANAGER_PTR	resMan[4];	// \[X}l[W
	CLACT_U_RES_OBJ_TBL * resObjTbl[4];	// \[XIuWFe[u
	int resObjNum[4];					// ꂼ̃\[XIuWF
*/
	FIELD_CLACT	fcat;
	CLACT_WORK_PTR	cwp[SHOP_CLA_MAX];
	u16	scr_draw[2];

	MYSTATUS * my;
	MYITEM * myitem;

	u16 * item;
	u8	max;
	u8	pos;
	u8	scr;
	u8	seq;

	STRBUF * msgb;	// b̈
	u8	pri[4];
	int	disp;
	u8	midx;		// bZ[WCfbNX
	u8	cm_cnt;		// JړJE^
	u8	cm_max;		// JړJEg

	u16	sel_item;
	s16	sel_num;
	u16	sel_max;
	u32	sel_price;

}SHOP_WORK;


#define	SHOP_FRM_3D			( FLD_MBGFRM_MAP )
#define	SHOP_FRM_BG			( FLD_MBGFRM_EFFECT1 )
#define	SHOP_FRM_LIST		( FLD_MBGFRM_EFFECT2 )
#define	SHOP_FRM_WINDOW		( FLD_MBGFRM_FONT )
#define	SHOP_BG_PAL			( 0 )

//#define	SHOP_TALK_WIN_CGX	( 1024 - TALK_WIN_CGX_SIZ )
//#define	SHOP_MENU_WIN_CGX	( SHOP_TALK_WIN_CGX - MENU_WIN_CGX_SIZ )
#define	SHOP_TALK_WIN_CGX	( 1 )
#define	SHOP_MENU_WIN_CGX	( SHOP_TALK_WIN_CGX + TALK_WIN_CGX_SIZ )

// BMPEBhE`
// Vbvj[itB[ḧ̗ɒӁIj
#define	WIN_SHOP_MENU_PX	( 1 )
#define	WIN_SHOP_MENU_PY	( 1 )
#define	WIN_SHOP_MENU_SX	( 13 )
#define	WIN_SHOP_MENU_SY	( 6 )
#define	WIN_SHOP_MENU_PAL	( FLD_SYSFONT_PAL )
#define	WIN_SHOP_MENU_CGX	( FLD_MSG_WIN_CGX - ( WIN_SHOP_MENU_SX * WIN_SHOP_MENU_SY ) )

// ACeXg
#define	WIN_SHOP_LIST_PX	( 13 )
#define	WIN_SHOP_LIST_PY	( 2 )
#define	WIN_SHOP_LIST_SX	( 18 )
#define	WIN_SHOP_LIST_SY	( 14 )
#define	WIN_SHOP_LIST_FRM	( SHOP_FRM_LIST )
#define	WIN_SHOP_LIST_PAL	( FLD_SYSFONT_PAL )
//#define	WIN_SHOP_LIST_CGX	( SHOP_MENU_WIN_CGX - ( WIN_SHOP_LIST_SX * WIN_SHOP_LIST_SY ) )
#define	WIN_SHOP_LIST_CGX	( 1 )
// ACe
#define	WIN_SHOP_INFO_PX	( 5 )
#define	WIN_SHOP_INFO_PY	( 18 )
#define	WIN_SHOP_INFO_SX	( 27 )
#define	WIN_SHOP_INFO_SY	( 6 )
#define	WIN_SHOP_INFO_FRM	( SHOP_FRM_LIST )
#define	WIN_SHOP_INFO_PAL	( FLD_SYSFONT_PAL )
//#define	WIN_SHOP_INFO_CGX	( WIN_SHOP_LIST_CGX - ( WIN_SHOP_INFO_SX * WIN_SHOP_INFO_SY ) )
#define	WIN_SHOP_INFO_CGX	( WIN_SHOP_LIST_CGX + ( WIN_SHOP_LIST_SX * WIN_SHOP_LIST_SY ) )

// 
#define	WIN_SHOP_GOLD_PX	( 1 )
#define	WIN_SHOP_GOLD_PY	( 1 )
#define	WIN_SHOP_GOLD_SX	( 10 )
#define	WIN_SHOP_GOLD_SY	( 4 )
#define	WIN_SHOP_GOLD_FRM	( SHOP_FRM_WINDOW )
#define	WIN_SHOP_GOLD_PAL	( FLD_SYSFONT_PAL )
//#define	WIN_SHOP_GOLD_CGX	( WIN_SHOP_INFO_CGX - ( WIN_SHOP_GOLD_SX * WIN_SHOP_GOLD_SY ) )
#define	WIN_SHOP_GOLD_CGX	( SHOP_MENU_WIN_CGX + MENU_WIN_CGX_SIZ )
// I
#define	WIN_SHOP_NUM_PX		( 19 )
#define	WIN_SHOP_NUM_PY		( 13 )
#define	WIN_SHOP_NUM_SX		( 12 )
#define	WIN_SHOP_NUM_SY		( 4 )
#define	WIN_SHOP_NUM_FRM	( SHOP_FRM_WINDOW )
#define	WIN_SHOP_NUM_PAL	( FLD_SYSFONT_PAL )
//#define	WIN_SHOP_NUM_CGX	( WIN_SHOP_GOLD_CGX - ( WIN_SHOP_NUM_SX * WIN_SHOP_NUM_SY ) )
#define	WIN_SHOP_NUM_CGX	( WIN_SHOP_GOLD_CGX + ( WIN_SHOP_GOLD_SX * WIN_SHOP_GOLD_SY ) )
// Ă鐔
#define	WIN_SHOP_MINE_PX	( 1 )
#define	WIN_SHOP_MINE_PY	( 15 )
#define	WIN_SHOP_MINE_SX	( 14 )
#define	WIN_SHOP_MINE_SY	( 2 )
#define	WIN_SHOP_MINE_FRM	( SHOP_FRM_WINDOW )
#define	WIN_SHOP_MINE_PAL	( FLD_SYSFONT_PAL )
//#define	WIN_SHOP_MINE_CGX	( WIN_SHOP_NUM_CGX - ( WIN_SHOP_MINE_SX * WIN_SHOP_MINE_SY ) )
#define	WIN_SHOP_MINE_CGX	( WIN_SHOP_NUM_CGX + ( WIN_SHOP_NUM_SX * WIN_SHOP_NUM_SY ) )
// b
#define	WIN_SHOP_TALK_PX	( 2 )
#define	WIN_SHOP_TALK_PY	( 19 )
#define	WIN_SHOP_TALK_SX	( 27 )
#define	WIN_SHOP_TALK_SY	( 4 )
#define	WIN_SHOP_TALK_FRM	( SHOP_FRM_WINDOW )
#define	WIN_SHOP_TALK_PAL	( FLD_MESFONT_PAL )
//#define	WIN_SHOP_TALK_CGX	( WIN_SHOP_MINE_CGX - ( WIN_SHOP_TALK_SX * WIN_SHOP_TALK_SY ) )
#define	WIN_SHOP_TALK_CGX	( WIN_SHOP_MINE_CGX + ( WIN_SHOP_MINE_SX * WIN_SHOP_MINE_SY ) )
// ͂E
#define	WIN_SHOP_YESNO_PX	( 23 )
#define	WIN_SHOP_YESNO_PY	( 13 )
#define	WIN_SHOP_YESNO_SX	( 7 )
#define	WIN_SHOP_YESNO_SY	( 4 )
#define	WIN_SHOP_YESNO_FRM	( SHOP_FRM_WINDOW )
#define	WIN_SHOP_YESNO_PAL	( FLD_SYSFONT_PAL )
//#define	WIN_SHOP_YESNO_CGX	( WIN_SHOP_TALK_CGX - ( WIN_SHOP_YESNO_SX * WIN_SHOP_YESNO_SY ) )
#define	WIN_SHOP_YESNO_CGX	( WIN_SHOP_TALK_CGX + ( WIN_SHOP_TALK_SX * WIN_SHOP_TALK_SY ) )

#define	SHOPCOL_N_BLACK	( GF_PRINTCOLOR_MAKE( 1, 2, 0 ) )		// tHgJ[F
#define	SHOPCOL_N_WHITE	( GF_PRINTCOLOR_MAKE( 15, 14, 0 ) )		// tHgJ[F
#define	SHOPCOL_N_BLUE	( GF_PRINTCOLOR_MAKE( 3, 4, 0 ) )		// tHgJ[F
#define	SHOPCOL_N_RED	( GF_PRINTCOLOR_MAKE( 5, 6, 0 ) )		// tHgJ[F

#define	MSG_BUFLEN		( 24*2*2 )


#define	CURSOR_ACT_PX	( 177 )
#define	CURSOR_ACT_PY	( 24 )


//============================================================================================
//	vg^Cv錾
//============================================================================================
static u8 CameraMoveCntGet( FIELDSYS_WORK * fsys );
static BOOL GMEVENT_Shop( GMEVENT_CONTROL * event );
static u8 ShopEndSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );
static void ShopInitSeq( SHOP_WORK * wk );
static void ShopMsgCreate( SHOP_WORK * wk );
static void ShopMenuSet( SHOP_WORK * wk );
static u8 ShopMenuSelect( SHOP_WORK * wk );
static void ShopMenuExit( SHOP_WORK * wk );
static void ShopBuyInitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );
static void ShopBuyWinAdd( SHOP_WORK * wk );
static void ShopBuyGraphicSet( SHOP_WORK * wk );
static u8 ShopBuyScrollSeq( SHOP_WORK * wk );
static u8 ShopBuySelectSeq( SHOP_WORK * wk );
static u8 ShopBuyEndSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );
static void ShopBuyItemListMake( SHOP_WORK * wk );
static void CB_ItemListMove( BMPLIST_WORK * work, u32 param, u8 mode );
static void CB_ItemListWrite( BMPLIST_WORK * work, u32 param, u8 y );
static void ShopBuyGoldWinPut( SHOP_WORK * wk, u8 flg );
static u8 ShopBuySelWaitSeq( SHOP_WORK * wk );
static u8 ShopBuyNumSelSeq( SHOP_WORK * wk );
static void NumSelWinPut( SHOP_WORK * wk, u8 flg );
static void MyItemWinPut( SHOP_WORK * wk );
static u8 ShopBuyCmpWaitSeq( SHOP_WORK * wk );
static u8 ShopBuyNumWaitSeq( SHOP_WORK * wk );
static u8 ShopBuyYesNoSeq( SHOP_WORK * wk );
static u8 ShopBuyCmpSeq( SHOP_WORK * wk );
static u8 ShopBuyMenuRetSeq( SHOP_WORK * wk );
static void ShopExitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );
static void ShopSaleInitSeq( SHOP_WORK * wk );
static u8 ShopSaleCallSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );
static u8 ShopSaleWaitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );
static u8 ShopSaleRetSeq( FIELDSYS_WORK * fsys );
static u8 ShopSaleMenuRetSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk );

static void ShopBuyActSet( SHOP_WORK * wk );
static void ShopBuyActExit( SHOP_WORK * wk );
static void load2DResFile( SHOP_WORK * wk );
static int loadOneData(
			CLACT_U_RES_MANAGER_PTR resMan, CLACT_U_RES_OBJ_TBL** resObjTbl, const char* path );

static void ShopBuyScrCurPosChg( SHOP_WORK * wk, u8 flg );

static void ShopBuyItemIconChg( SHOP_WORK * wk, u16 item );


//============================================================================================
//	O[oϐ
//============================================================================================
static const BMPWIN_DAT ShopBuyBmpWin[] =
{
	{	// ACeXg
		WIN_SHOP_LIST_FRM, WIN_SHOP_LIST_PX, WIN_SHOP_LIST_PY,
		WIN_SHOP_LIST_SX, WIN_SHOP_LIST_SY, WIN_SHOP_LIST_PAL, WIN_SHOP_LIST_CGX
	},
	{	// ACe
		WIN_SHOP_INFO_FRM, WIN_SHOP_INFO_PX, WIN_SHOP_INFO_PY,
		WIN_SHOP_INFO_SX, WIN_SHOP_INFO_SY, WIN_SHOP_INFO_PAL, WIN_SHOP_INFO_CGX
	},
	{	// 
		WIN_SHOP_GOLD_FRM, WIN_SHOP_GOLD_PX, WIN_SHOP_GOLD_PY,
		WIN_SHOP_GOLD_SX, WIN_SHOP_GOLD_SY, WIN_SHOP_GOLD_PAL, WIN_SHOP_GOLD_CGX
	},
	{	// I
		WIN_SHOP_NUM_FRM, WIN_SHOP_NUM_PX, WIN_SHOP_NUM_PY,
		WIN_SHOP_NUM_SX, WIN_SHOP_NUM_SY, WIN_SHOP_NUM_PAL, WIN_SHOP_NUM_CGX
	},
	{	// Ă鐔
		WIN_SHOP_MINE_FRM, WIN_SHOP_MINE_PX, WIN_SHOP_MINE_PY,
		WIN_SHOP_MINE_SX, WIN_SHOP_MINE_SY, WIN_SHOP_MINE_PAL, WIN_SHOP_MINE_CGX
	},
	{	// b
		WIN_SHOP_TALK_FRM, WIN_SHOP_TALK_PX, WIN_SHOP_TALK_PY,
		WIN_SHOP_TALK_SX, WIN_SHOP_TALK_SY, WIN_SHOP_TALK_PAL, WIN_SHOP_TALK_CGX
	},
};

// ͂E
static const BMPWIN_DAT ShopBuyYesNoBmpWin = {
	WIN_SHOP_YESNO_FRM, WIN_SHOP_YESNO_PX, WIN_SHOP_YESNO_PY,
	WIN_SHOP_YESNO_SX, WIN_SHOP_YESNO_SY, WIN_SHOP_YESNO_PAL, WIN_SHOP_YESNO_CGX
};




static void ShopItemSet( SHOP_WORK * wk, u16 * item )
{
	u16	i;

	for( i=0; i<256; i++ ){
		if( item[i] == 0xffff ){ break; }
	}
	wk->max = i;
	wk->item = sys_AllocMemory( HEAPID_WORLD, wk->max*2 );
	for( i=0; i<wk->max; i++ ){
		wk->item[i] = item[i];
	}
}


static SHOP_WORK * ShopWorkAlloc(void)
{
	SHOP_WORK * wk = sys_AllocMemory( HEAPID_WORLD, sizeof(SHOP_WORK) );
	memset( wk, 0, sizeof(SHOP_WORK) );
	return wk;
}



void ShopInit2( GMEVENT_CONTROL * event, FIELDSYS_WORK * repw, u16 * item )
{
	SHOP_WORK * wk = ShopWorkAlloc();

	wk->bgl    = repw->bgl;
	wk->msgb   = STRBUF_Create( MSG_BUFLEN, HEAPID_WORLD );
	wk->my     = SaveData_GetMyStatus( repw->savedata );
	wk->myitem = SaveData_GetMyItem( repw->savedata );
	wk->cm_max = CameraMoveCntGet( repw );

//	DummyShopDataSet( wk );
	ShopItemSet( wk, item );

	//FieldEvent_Set( repw, GMEVENT_Shop, wk );
	FieldEvent_Call( event, GMEVENT_Shop, wk );
}

void ShopInit( FIELDSYS_WORK * repw, u16 * item )
{
	SHOP_WORK * wk = ShopWorkAlloc();

	wk->bgl    = repw->bgl;
	wk->msgb   = STRBUF_Create( MSG_BUFLEN, HEAPID_WORLD );
	wk->my     = SaveData_GetMyStatus( repw->savedata );
	wk->myitem = SaveData_GetMyItem( repw->savedata );
	wk->cm_max = CameraMoveCntGet( repw );

//	DummyShopDataSet( wk );
	ShopItemSet( wk, item );

	FieldEvent_Set( repw, GMEVENT_Shop, wk );
	//FieldEvent_Call( event, GMEVENT_Shop, wk );
}

void ShopEvChg( FIELDSYS_WORK * repw, u16 * item )
{
	SHOP_WORK * wk = ShopWorkAlloc();
	
	wk->bgl    = repw->bgl;
	wk->msgb   = STRBUF_Create( MSG_BUFLEN, HEAPID_WORLD );
	wk->my     = SaveData_GetMyStatus( repw->savedata );
	wk->myitem = SaveData_GetMyItem( repw->savedata );
	wk->cm_max = CameraMoveCntGet( repw );

//	DummyShopDataSet( wk );
	ShopItemSet( wk, item );

	FieldEvent_Change( repw->event, GMEVENT_Shop, wk );
}


static u8 CameraMoveCntGet( FIELDSYS_WORK * fsys )
{
	int	dir = Player_DirGet( fsys->player );

	if( dir == DIR_UP || dir == DIR_DOWN || DIR_RIGHT ){
		return 10;
	}
	return 8;
}


//--------------------------------------------------------------------------------------------
/**
 * @brief	tB[hCxgFj[
 * @param	event	tB[hCxgpp[^
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 */
//--------------------------------------------------------------------------------------------
static BOOL GMEVENT_Shop( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	SHOP_WORK * wk;

	fsys = FieldEvent_GetFieldSysWork(event);
	wk = FieldEvent_GetSpecialWork(event);

	switch( wk->seq ){
	case SHOP_SEQ_INIT:
		fsys->stop_debug_print = 1;
		ShopInitSeq( wk );
		wk->seq = SHOP_SEQ_MENU;
		break;

	case SHOP_SEQ_MENU:
		wk->seq = ShopMenuSelect( wk );
		break;


	case SHOP_SEQ_BUY_INIT:		// wʏ
		ShopBuyInitSeq( fsys, wk );
		wk->seq = SHOP_SEQ_BUY_SCROLL;
		break;
	case SHOP_SEQ_BUY_SCROLL:	// wʒuփXN[
		wk->seq = ShopBuyScrollSeq( wk );
		break;
	case SHOP_SEQ_BUY_SELECT:	// ACeI
		wk->seq = ShopBuySelectSeq( wk );
		break;

	case SHOP_SEQ_BUYSEL_WAIT:	// u`v\EFCg
		wk->seq = ShopBuySelWaitSeq( wk );
		break;

	case SHOP_SEQ_BUYNUM_SEL:	// I
		wk->seq = ShopBuyNumSelSeq( wk );
		break;

	case SHOP_SEQ_BUYNUM_WAIT:	// uv`Ȃ܂v\EFCg
		wk->seq = ShopBuyNumWaitSeq( wk );
		break;

	case SHOP_SEQ_BUY_YESNO:	// ͂EI
		wk->seq = ShopBuyYesNoSeq( wk );
		break;

	case SHOP_SEQ_BUY_CMP:		// w
		wk->seq = ShopBuyCmpSeq( wk );
		break;

	case SHOP_SEQ_BUYCMP_WAIT:	// ACeI
		wk->seq = ShopBuyCmpWaitSeq( wk );
		break;

	case SHOP_SEQ_BUY_END:		// wʏI
		wk->seq = ShopBuyEndSeq( fsys, wk );
		break;

	case SHOP_SEQ_MENU_RET:		// j[I֖߂҂
		wk->seq = ShopBuyMenuRetSeq( wk );
		break;

	case SHOP_SEQ_SALE_INIT:		// uv
		ShopSaleInitSeq( wk );
		break;

	case SHOP_SEQ_SALE_CALL:		// uvĂяo
		wk->seq = ShopSaleCallSeq( fsys, wk );
		break;

	case SHOP_SEQ_SALE_WAIT:		// uvI҂
		wk->seq = ShopSaleWaitSeq( fsys, wk );
		break;

	case SHOP_SEQ_SALE_RET:			// uvI -> tF[hC
		wk->seq = ShopSaleRetSeq( fsys );
		break;

	case SHOP_SEQ_SALE_MENU_RET:	// tF[hC -> j[
		wk->seq = ShopSaleMenuRetSeq( fsys, wk );
		break;

	case SHOP_SEQ_EXIT:
		ShopExitSeq( fsys, wk );
		wk->seq = SHOP_SEQ_END;
		break;

	case SHOP_SEQ_END:
		return ShopEndSeq( fsys, wk );
	}


	if( wk->seq >= SHOP_SEQ_BUY_SELECT && wk->seq <= SHOP_SEQ_BUYCMP_WAIT ){
		CLACT_AnmFrameChg( wk->cwp[0], FX32_ONE );
		CLACT_AnmFrameChg( wk->cwp[1], FX32_ONE );
		CLACT_Draw( wk->fcat.cas );
	}


	return FALSE;
}


//--------------------------------------------------------------------------------------------
/**
 * 
 */
//--------------------------------------------------------------------------------------------
static void ShopInitSeq( SHOP_WORK * wk )
{
	ShopMsgCreate( wk );
	ShopMenuSet( wk );
}

static void ShopMsgCreate( SHOP_WORK * wk )
{
	wk->mman = MSGMAN_Create( MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_shop_dat, HEAPID_WORLD );
	wk->wset = WORDSET_Create( HEAPID_WORLD );
}

static void ShopMenuSet( SHOP_WORK * wk )
{
	BMPMENU_HEADER	hed;

	wk->md = BMP_MENULIST_Create( 3, HEAPID_WORLD );
	BMP_MENULIST_AddArchiveString( wk->md, wk->mman, mes_shop_04_01, SHOP_SEQ_BUY_INIT );
	BMP_MENULIST_AddArchiveString( wk->md, wk->mman, mes_shop_04_02, SHOP_SEQ_SALE_INIT );
	BMP_MENULIST_AddArchiveString( wk->md, wk->mman, mes_shop_04_03, BMPMENU_CANCEL );

	GF_BGL_BmpWinAdd(
		wk->bgl, &wk->win[WIN_IDX_NENU], FLD_MBGFRM_FONT,
		WIN_SHOP_MENU_PX, WIN_SHOP_MENU_PY, WIN_SHOP_MENU_SX,
		WIN_SHOP_MENU_SY, WIN_SHOP_MENU_PAL, WIN_SHOP_MENU_CGX );

	hed.menu     = wk->md;
	hed.win      = &wk->win[WIN_IDX_NENU];
	hed.font     = FONT_SYSTEM;
	hed.x_max    = 1;
	hed.y_max    = 3;
	hed.line_spc = 0;
	hed.c_disp_f = 0;
	hed.loop_f   = 0;

	MenuWinGraphicSet(
		wk->bgl, FLD_MBGFRM_FONT, MENU_WIN_CGX_NUM, MENU_WIN_PAL, 0, HEAPID_WORLD );
	BmpMenuWinWrite( &wk->win[WIN_IDX_NENU], WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	wk->mw = BmpMenuAddEx( &hed, 8, 0, 0, HEAPID_WORLD, PAD_BUTTON_CANCEL );
}


//--------------------------------------------------------------------------------------------
/**
 * j[I
 */
//--------------------------------------------------------------------------------------------
static u8 ShopMenuSelect( SHOP_WORK * wk )
{
	u32	ret = BmpMenuMain( wk->mw );

	switch( ret ){
	case BMPMENU_NULL:
		break;
	case BMPMENU_CANCEL:
		ShopMenuExit( wk );
		return SHOP_SEQ_EXIT;
	default:
		return (u8)ret;
	}
	return SHOP_SEQ_MENU;
}


static void ShopMenuExit( SHOP_WORK * wk )
{
	BmpMenuWinClear( &wk->win[WIN_IDX_NENU], WINDOW_TRANS_OFF );
	GF_BGL_BmpWinOff( &wk->win[WIN_IDX_NENU] );

	BmpMenuExit( wk->mw, NULL );
	BMP_MENULIST_Delete( wk->md );

	GF_BGL_BmpWinDel( &wk->win[WIN_IDX_NENU] );
}



//--------------------------------------------------------------------------------------------
/**
 * I
 */
//--------------------------------------------------------------------------------------------
static u8 ShopEndSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
	if( FldTalkMsgEndCheck( wk->midx ) == 0 ){
		return FALSE;
	}
	if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) ){
		BmpTalkWinClear( &wk->win[WIN_IDX_FLDTALK], WINDOW_TRANS_ON );
		GF_BGL_BmpWinDel( &wk->win[WIN_IDX_FLDTALK] );

		MSGMAN_Delete( wk->mman );
		WORDSET_Delete( wk->wset );

		STRBUF_Delete( wk->msgb );

		sys_FreeMemoryEz( wk->item );
		sys_FreeMemoryEz( wk );

		fsys->stop_debug_print = 0;

		return TRUE;
	}
	return FALSE;
}



//=============================================================================================
//	
//=============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * 
 */
//--------------------------------------------------------------------------------------------
static void ShopBuyInitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
//	BmpTalkWinClear( &wk->win[WIN_IDX_FLDTALK], WINDOW_TRANS_ON );
	GF_BGL_ScrFill(
		wk->bgl, FLD_MBGFRM_FONT, 0, 
		FLD_MSG_WIN_PX-2,FLD_MSG_WIN_PY-1,FLD_MSG_WIN_SX+5,FLD_MSG_WIN_SY+2, 0 );
//	GF_BGL_LoadScreenReq( win->ini, frm );

	ShopMenuExit( wk );
	ShopBuyWinAdd( wk );
//	ShopBuyGraphicSet( wk );

	wk->camera = GFC_AllocCamera( HEAPID_WORLD );
	GFC_CopyCamera( fsys->camera_ptr, wk->camera );
	GFC_AttachCamera( wk->camera );
	wk->cm_cnt = 0;
}

static void ShopBuyWinAdd( SHOP_WORK * wk )
{
	u32	i;

	for( i=0; i<WIN_IDX_MAX; i++ ){
		GF_BGL_BmpWinAddEx( wk->bgl, &wk->win[i], &ShopBuyBmpWin[i] );
	}
}

static void ShopBuyWinDel( SHOP_WORK * wk )
{
	u32	i;

	BmpMenuWinClear( &wk->win[WIN_IDX_GOLD], WINDOW_TRANS_OFF );

	for( i=0; i<WIN_IDX_MAX; i++ ){
		GF_BGL_BmpWinOff( &wk->win[i] );
		GF_BGL_BmpWinDel( &wk->win[i] );
	}
}

static void ShopBuyGraphicSet( SHOP_WORK * wk )
{
	ArcUtil_BgCharSet(
		ARC_SHOP_GRA, NARC_shop_gra_shop_bg_NCGR,
		wk->bgl, SHOP_FRM_BG, 0, 0, 0, HEAPID_WORLD );
	ArcUtil_ScrnSet(
		ARC_SHOP_GRA, NARC_shop_gra_shop_bg1_NSCR,
		wk->bgl, SHOP_FRM_BG, 0, 0, 0, HEAPID_WORLD );
	ArcUtil_PalSet(
		ARC_SHOP_GRA, NARC_shop_gra_shop_bg_NCLR, PALTYPE_MAIN_BG, 0, 32, HEAPID_WORLD );

	// j[EBhEZbg
	MenuWinGraphicSet(
		wk->bgl, SHOP_FRM_WINDOW, SHOP_MENU_WIN_CGX, MENU_WIN_PAL, 0, HEAPID_WORLD );
	// bEBhEZbg
	TalkWinGraphicSet(
		wk->bgl, SHOP_FRM_WINDOW, SHOP_TALK_WIN_CGX, TALK_WIN_PAL, 0, HEAPID_WORLD );
}

static void ShopBgPriorityChg( SHOP_WORK * wk )
{
	wk->disp = GF_Disp_MainVisibleGet();

	wk->pri[0] = GF_BGL_PriorityGet( wk->bgl, SHOP_FRM_3D );
	wk->pri[1] = GF_BGL_PriorityGet( wk->bgl, SHOP_FRM_BG );
	wk->pri[2] = GF_BGL_PriorityGet( wk->bgl, SHOP_FRM_LIST );
	wk->pri[3] = GF_BGL_PriorityGet( wk->bgl, SHOP_FRM_WINDOW );

	GF_BGL_PrioritySet( SHOP_FRM_3D, 3 );
	GF_BGL_PrioritySet( SHOP_FRM_BG, 2 );
	GF_BGL_PrioritySet( SHOP_FRM_LIST, 1 );
	GF_BGL_PrioritySet( SHOP_FRM_WINDOW, 0 );

	GF_Disp_GX_VisibleControl( SHOP_FRM_3D, VISIBLE_ON );
	GF_Disp_GX_VisibleControl( SHOP_FRM_BG, VISIBLE_ON );
	GF_Disp_GX_VisibleControl( SHOP_FRM_LIST, VISIBLE_ON );
	GF_Disp_GX_VisibleControl( SHOP_FRM_WINDOW, VISIBLE_ON );
}

static void ShopBgPriorityReset( SHOP_WORK * wk )
{
	GF_BGL_PrioritySet( SHOP_FRM_3D, wk->pri[0] );
	GF_BGL_PrioritySet( SHOP_FRM_BG, wk->pri[1] );
	GF_BGL_PrioritySet( SHOP_FRM_LIST, wk->pri[2] );
	GF_BGL_PrioritySet( SHOP_FRM_WINDOW, wk->pri[3] );

	GF_Disp_GX_VisibleControlDirect( wk->disp );
}

//--------------------------------------------------------------------------------------------
/**
 * JnXN[
 */
//--------------------------------------------------------------------------------------------
static u8 ShopBuyScrollSeq( SHOP_WORK * wk )
{
	if( wk->cm_cnt != wk->cm_max ){
		VecFx32 move = {8*FX32_ONE,0,0};
		GFC_ShiftCamera( &move, wk->camera );
		wk->cm_cnt++;
		return SHOP_SEQ_BUY_SCROLL;
	}
/*
		if( sys.trg & PAD_KEY_UP ){
			move.z = FX32_ONE;
			GFC_ShiftCamera( &move, wk->camera );
		}else if( sys.trg & PAD_KEY_DOWN ){
			move.z = FX32_ONE;
			GFC_ShiftCamera( &move, wk->camera );
		}else if( sys.trg & PAD_KEY_LEFT ){
			move.x = FX32_ONE;
			GFC_ShiftCamera( &move, wk->camera );
		}else if( sys.trg & PAD_KEY_RIGHT ){
			move.x = FX32_ONE;
			GFC_ShiftCamera( &move, wk->camera );
		}
*/

	wk->cm_cnt = 0;
	ShopBuyActSet( wk );
	ShopBuyGraphicSet( wk );
	ShopBgPriorityChg( wk );
	ShopBuyItemListMake( wk );
	ShopBuyGoldWinPut( wk, 0 );
	return SHOP_SEQ_BUY_SELECT;
}

// ACeXgf[^iBMPXgj
static const BMPLIST_HEADER ShopItemList = {
	NULL, CB_ItemListMove, CB_ItemListWrite, NULL,
	0, 7, 0,
	0, 0,			// X, J[\X
	0,				// \Y
	FBMP_COL_BLACK, FBMP_COL_NULL, FBMP_COL_BLK_SDW,
	0, 16,						// Ԋux
	BMPLIST_NO_SKIP, FONT_SYSTEM, 1,
	NULL,
};

static void ShopBuyItemListMake( SHOP_WORK * wk )
{
	STRBUF * buf;
	BMPLIST_HEADER	lh;
	u32	i;

	wk->ld = BMP_MENULIST_Create( wk->max+1, HEAPID_WORLD );
	for( i=0; i<wk->max; i++ ){
		buf = STRBUF_Create( BUFLEN_ITEM_NAME, HEAPID_WORLD );
		GetItemName( buf, wk->item[i], HEAPID_WORLD );
		BMP_MENULIST_AddString( wk->ld, buf, wk->item[i] );
		STRBUF_Delete( buf );
	}
	BMP_MENULIST_AddArchiveString( wk->ld, wk->mman, mes_shop_02_06, BMPLIST_CANCEL );

	lh = ShopItemList;
	lh.list  = wk->ld;
	lh.win   = &wk->win[WIN_IDX_LIST];
	lh.count = wk->max+1;
	lh.work  = (void *)wk;
	wk->lw = BmpListSet( &lh, 0, 0, HEAPID_WORLD );
}

//--------------------------------------------------------------------------------------------
/**
 * ACeXgR[obN֐iJ[\ړƁj
 *
 * @param	work	BMPXgŐݒ肵[N
 * @param	param	BMPXg̃p[^
 * @param	mode	 = 1
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void CB_ItemListMove( BMPLIST_WORK * work, u32 param, u8 mode )
{
	SHOP_WORK * wk = (SHOP_WORK *)BmpListParamGet( work, BMPLIST_ID_WORK );

	if( mode != 1 ){
		Snd_SePlay( FD_SHOP_SE_CURSOR_MOVE );
	}
	
	GF_BGL_BmpWinDataFill( &wk->win[WIN_IDX_INFO], 0 );

	if( param != BMPLIST_CANCEL ){
		STRBUF * buf = STRBUF_Create( BUFLEN_ITEM_INFO, HEAPID_WORLD );
		ItemInfoGet( buf, (u16)param, HEAPID_WORLD );
		GF_STR_PrintColor(
			&wk->win[WIN_IDX_INFO], FONT_SYSTEM, buf, 0, 0, MSG_NO_PUT, SHOPCOL_N_WHITE, NULL );
		STRBUF_Delete( buf );
//		BagItemIconChange( wk, pocket->item[param].id );
		ShopBuyItemIconChg( wk, (u16)param );

	}else{
//		BagItemIconChange( wk, ITEM_RETURN_ID );
		ShopBuyItemIconChg( wk, ITEM_RETURN_ID );
	}
	GF_BGL_BmpWinOn( &wk->win[WIN_IDX_INFO] );

	{
		u32	max;
		u16	scr, cur;

		BmpListPosGet( work, &scr, &cur );
		if( scr == 0 ){
			CLACT_SetDrawFlag( wk->cwp[0], 0 );
		}else{
			CLACT_SetDrawFlag( wk->cwp[0], 1 );
		}

		max = BmpListParamGet( work, BMPLIST_ID_COUNT );
		if( max > 7 && max > scr + 7 ){
			CLACT_SetDrawFlag( wk->cwp[1], 1 );
		}else{
			CLACT_SetDrawFlag( wk->cwp[1], 0 );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ACeXgR[obN֐i\Ɓj
 *
 * @param	work	BMPXgŐݒ肵[N
 * @param	index	BMPXggpĂEBhECfbNX
 * @param	param	BMPXg̃p[^
 * @param	y		YW
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
#define	LIST_PRICE_BUFLEN	( 12 )
#define	LIST_PRICE_EX		( WIN_SHOP_LIST_SX * 8 )

static void CB_ItemListWrite( BMPLIST_WORK * work, u32 param, u8 y )
{
	SHOP_WORK * wk = (SHOP_WORK *)BmpListParamGet( work, BMPLIST_ID_WORK );

	if( param != BMPLIST_CANCEL ){
		STRBUF * expb;
		STRBUF * strb;
		u32	price;
		u32	siz;
		
		price = ItemParamGet( (u16)param, ITEM_PRM_PRICE, HEAPID_WORLD );
		expb  = STRBUF_Create( LIST_PRICE_BUFLEN, HEAPID_WORLD );
		strb  = MSGMAN_AllocString( wk->mman, mes_shop_02_07 );
		WORDSET_RegisterNumber(
			wk->wset, 0, price, 4, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
		WORDSET_ExpandStr( wk->wset, expb, strb );
		siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, expb, 0 );
		GF_STR_PrintColor(
			&wk->win[WIN_IDX_LIST], FONT_SYSTEM, expb,
			LIST_PRICE_EX-siz, y, MSG_NO_PUT, SHOPCOL_N_BLACK, NULL );
		STRBUF_Delete( strb );
		STRBUF_Delete( expb );
	}
}

#define	GOLD_BUFLEN		( 16 )
#define	GOLD_EX			( WIN_SHOP_GOLD_SX * 8 )

static void ShopBuyGoldWinPut( SHOP_WORK * wk, u8 flg )
{
	STRBUF * expb;
	STRBUF * strb;
	u32	gold;
	u32	siz;

	if( flg == 0 ){
		GF_BGL_BmpWinDataFill( &wk->win[WIN_IDX_GOLD], 15 );
		BmpMenuWinWrite(
			&wk->win[WIN_IDX_GOLD], WINDOW_TRANS_OFF, SHOP_MENU_WIN_CGX, MENU_WIN_PAL );
		strb = MSGMAN_AllocString( wk->mman, mes_shop_05_01 );
		GF_STR_PrintSimple( &wk->win[WIN_IDX_GOLD], FONT_SYSTEM, strb, 0, 0, MSG_NO_PUT, NULL );
		STRBUF_Delete( strb );
	}else{
		GF_BGL_BmpWinFill( &wk->win[WIN_IDX_GOLD], 15, 0, 16, GOLD_EX, 16 );
	}

	expb = STRBUF_Create( GOLD_BUFLEN, HEAPID_WORLD );
	strb = MSGMAN_AllocString( wk->mman, mes_shop_05_02 );
	gold = MyStatus_GetGold( wk->my );
	WORDSET_RegisterNumber(
		wk->wset, 0, gold, 6, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, expb, strb );
	siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, expb, 0 );
	GF_STR_PrintSimple(
		&wk->win[WIN_IDX_GOLD], FONT_SYSTEM, expb, GOLD_EX-siz, 16, MSG_ALLPUT, NULL );
	STRBUF_Delete( strb );
	STRBUF_Delete( expb );
}


//--------------------------------------------------------------------------------------------
/**
 * ACeI
 */
//--------------------------------------------------------------------------------------------
static u8 ShopBuySelectSeq( SHOP_WORK * wk )
{
	u32	ret;
	u16	cur1, cur2;

	BmpListPosGet( wk->lw, NULL, &cur1 );
	ret = BmpListMain( wk->lw );
	BmpListPosGet( wk->lw, NULL, &cur2 );

	if( cur1 != cur2 ){
		CATS_ObjectPosSet( wk->cwp[2], CURSOR_ACT_PX, CURSOR_ACT_PY + cur2 * 16 );
	}

	switch( ret ){
	case BMPLIST_NULL:
		break;
	case BMPLIST_CANCEL:
		BmpListExit( wk->lw, NULL, NULL );
		BMP_MENULIST_Delete( wk->ld );
		ShopBuyWinDel( wk );
		ShopBgPriorityReset( wk );
		GF_BGL_ScrClear( wk->bgl, SHOP_FRM_BG );
		Snd_SePlay( FD_SHOP_SE_CANCEL );
		return SHOP_SEQ_BUY_END;

	default:
		{
			STRBUF * str;
			u32	gold;

			wk->scr_draw[0] = (u16)CLACT_GetDrawFlag( wk->cwp[0] );
			wk->scr_draw[1] = (u16)CLACT_GetDrawFlag( wk->cwp[1] );

			CLACT_SetDrawFlag( wk->cwp[0], 0 );
			CLACT_SetDrawFlag( wk->cwp[1], 0 );

			GF_BGL_BmpWinDataFill( &wk->win[WIN_IDX_TALK], 15 );
			BmpTalkWinWrite(
				&wk->win[WIN_IDX_TALK], WINDOW_TRANS_ON, SHOP_TALK_WIN_CGX, TALK_WIN_PAL );

			wk->sel_item  = (u16)ret;
			wk->sel_num   = 1;
			wk->sel_price = ItemParamGet( wk->sel_item, ITEM_PRM_PRICE, HEAPID_WORLD );
			gold = MyStatus_GetGold( wk->my );

			if( gold < wk->sel_price ){
				str = MSGMAN_AllocString( wk->mman, mes_shop_02_01 );
				WORDSET_ExpandStr( wk->wset, wk->msgb, str );
				STRBUF_Delete( str );
				wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_TALK], wk->msgb, 1 );
				return SHOP_SEQ_BUYCMP_WAIT;
			}

			wk->sel_max = gold / wk->sel_price;
			if( wk->sel_max > 99 ){ wk->sel_max = 99; }

			WORDSET_RegisterItemName( wk->wset, 0, wk->sel_item );

			str = MSGMAN_AllocString( wk->mman, mes_shop_02_02 );
			WORDSET_ExpandStr( wk->wset, wk->msgb, str );
			STRBUF_Delete( str );
			wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_TALK], wk->msgb, 1 );

			ShopBuyScrCurPosChg( wk, 1 );

			Snd_SePlay( FD_SHOP_SE_DECIDE );
			return SHOP_SEQ_BUYSEL_WAIT;
		}
	}
	return SHOP_SEQ_BUY_SELECT;
}

static u8 ShopBuySelWaitSeq( SHOP_WORK * wk )
{
	if( FldTalkMsgEndCheck( wk->midx ) == 0 ){
		return SHOP_SEQ_BUYSEL_WAIT;
	}
	MyItemWinPut( wk );
	NumSelWinPut( wk, 0 );
	CLACT_SetDrawFlag( wk->cwp[0], 1 );
	CLACT_SetDrawFlag( wk->cwp[1], 1 );
	return SHOP_SEQ_BUYNUM_SEL;
}

#define	MYITEM_BUFLEN	( 12*2 )

static void MyItemWinPut( SHOP_WORK * wk )
{
	STRBUF * expb;
	STRBUF * strb;
	u16	num;

	num = MyItem_GetItemNum( wk->myitem, wk->sel_item, HEAPID_WORLD );

	GF_BGL_BmpWinDataFill( &wk->win[WIN_IDX_MINE], 15 );
	BmpMenuWinWrite(
		&wk->win[WIN_IDX_MINE], WINDOW_TRANS_OFF, SHOP_MENU_WIN_CGX, MENU_WIN_PAL );

	expb = STRBUF_Create( MYITEM_BUFLEN, HEAPID_WORLD );
	strb = MSGMAN_AllocString( wk->mman, mes_shop_06_01 );
	WORDSET_RegisterNumber(
		wk->wset, 0, num, 3, NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, expb, strb );
	GF_STR_PrintSimple( &wk->win[WIN_IDX_MINE], FONT_SYSTEM, expb, 0, 0, MSG_ALLPUT, NULL );
	STRBUF_Delete( strb );
	STRBUF_Delete( expb );
}


static u8 ShopBuyNumSelSeq( SHOP_WORK * wk )
{
	if( NumSelectCheck( &wk->sel_num, wk->sel_max ) == TRUE ){
		Snd_SePlay( FD_SHOP_SE_CURSOR_MOVE );
		NumSelWinPut( wk, 1 );
		return SHOP_SEQ_BUYNUM_SEL;
	}

	if( sys.trg & PAD_BUTTON_DECIDE ){
		STRBUF * str;
		CLACT_SetDrawFlag( wk->cwp[0], 0 );
		CLACT_SetDrawFlag( wk->cwp[1], 0 );
		BmpMenuWinClear( &wk->win[WIN_IDX_MINE], WINDOW_TRANS_OFF );
		BmpMenuWinClear( &wk->win[WIN_IDX_NUM],  WINDOW_TRANS_OFF );
		GF_BGL_BmpWinDataFill( &wk->win[WIN_IDX_TALK], 15 );
		Snd_SePlay( FD_SHOP_SE_DECIDE );
		if( MyItem_AddCheck( wk->myitem, wk->sel_item, wk->sel_num, HEAPID_WORLD ) == FALSE ){
			str = MSGMAN_AllocString( wk->mman, mes_shop_02_05 );
			WORDSET_ExpandStr( wk->wset, wk->msgb, str );
			STRBUF_Delete( str );
			wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_TALK], wk->msgb, 1 );
			return SHOP_SEQ_BUYCMP_WAIT;
		}

		WORDSET_RegisterItemName( wk->wset, 0, wk->sel_item );
		WORDSET_RegisterNumber(
			wk->wset, 1, wk->sel_num, 2, NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		WORDSET_RegisterNumber(
			wk->wset, 2, wk->sel_price*wk->sel_num, 6,
			NUMBER_DISPTYPE_LEFT, NUMBER_CODETYPE_DEFAULT );
		str = MSGMAN_AllocString( wk->mman, mes_shop_02_03 );
		WORDSET_ExpandStr( wk->wset, wk->msgb, str );
		STRBUF_Delete( str );
		wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_TALK], wk->msgb, 1 );
		return SHOP_SEQ_BUYNUM_WAIT;
	}

	if( sys.trg & PAD_BUTTON_CANCEL ){
		BmpMenuWinClear( &wk->win[WIN_IDX_MINE], WINDOW_TRANS_OFF );
		BmpMenuWinClear( &wk->win[WIN_IDX_NUM],  WINDOW_TRANS_OFF );
		BmpTalkWinClear( &wk->win[WIN_IDX_TALK], WINDOW_TRANS_ON );

		ShopBuyScrCurPosChg( wk, 0 );
		CLACT_SetDrawFlag( wk->cwp[0], wk->scr_draw[0] );
		CLACT_SetDrawFlag( wk->cwp[1], wk->scr_draw[1] );

		Snd_SePlay( FD_SHOP_SE_CANCEL );
		return SHOP_SEQ_BUY_SELECT;
	}
	return SHOP_SEQ_BUYNUM_SEL;
}

#define	NUMSEL_BUFLEN	( 24 )
#define	NUMSEL_EX		( WIN_SHOP_NUM_SX * 8 )

static void NumSelWinPut( SHOP_WORK * wk, u8 flg )
{
	STRBUF * expb;
	STRBUF * strb;
	u32	siz;

	GF_BGL_BmpWinDataFill( &wk->win[WIN_IDX_NUM], 15 );

	if( flg == 0 ){
		BmpMenuWinWrite(
			&wk->win[WIN_IDX_NUM], WINDOW_TRANS_OFF, SHOP_MENU_WIN_CGX, MENU_WIN_PAL );
	}

	expb = STRBUF_Create( NUMSEL_BUFLEN, HEAPID_WORLD );
	strb = MSGMAN_AllocString( wk->mman, mes_shop_07_01 );
	WORDSET_RegisterNumber(
		wk->wset, 0, wk->sel_num, 2, NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, expb, strb );
	GF_STR_PrintSimple(
		&wk->win[WIN_IDX_NUM], FONT_SYSTEM, expb, 0, 8, MSG_NO_PUT, NULL );
	STRBUF_Delete( strb );

	strb = MSGMAN_AllocString( wk->mman, mes_shop_07_02 );
	WORDSET_RegisterNumber(
		wk->wset, 0, wk->sel_price*wk->sel_num, 6,
		NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT );
	WORDSET_ExpandStr( wk->wset, expb, strb );
	siz = FontProc_GetPrintStrWidth( FONT_SYSTEM, expb, 0 );
	GF_STR_PrintSimple(
		&wk->win[WIN_IDX_NUM], FONT_SYSTEM, expb, NUMSEL_EX-siz, 8, MSG_ALLPUT, NULL );
	STRBUF_Delete( strb );
	STRBUF_Delete( expb );
}





static u8 ShopBuyNumWaitSeq( SHOP_WORK * wk )
{
	if( FldTalkMsgEndCheck( wk->midx ) == 0 ){
		return SHOP_SEQ_BUYNUM_WAIT;
	}
	wk->mw = BmpYesNoSelectInit(
				wk->bgl, &ShopBuyYesNoBmpWin, SHOP_MENU_WIN_CGX, MENU_WIN_PAL, HEAPID_WORLD );
	return SHOP_SEQ_BUY_YESNO;
}

static u8 ShopBuyYesNoSeq( SHOP_WORK * wk )
{
	switch( BmpYesNoSelectMain( wk->mw, HEAPID_WORLD ) ){
	case 0:
		{
			STRBUF * str = MSGMAN_AllocString( wk->mman, mes_shop_02_04 );
			WORDSET_ExpandStr( wk->wset, wk->msgb, str );
			STRBUF_Delete( str );
		}
		GF_BGL_BmpWinDataFill( &wk->win[WIN_IDX_TALK], 15 );
		wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_TALK], wk->msgb, 1 );
		return SHOP_SEQ_BUY_CMP;

	case BMPMENU_CANCEL:
		BmpTalkWinClear( &wk->win[WIN_IDX_TALK], WINDOW_TRANS_ON );
		ShopBuyScrCurPosChg( wk, 0 );
		CLACT_SetDrawFlag( wk->cwp[0], wk->scr_draw[0] );
		CLACT_SetDrawFlag( wk->cwp[1], wk->scr_draw[1] );
		return SHOP_SEQ_BUY_SELECT;
	}
	return SHOP_SEQ_BUY_YESNO;
}


static u8 ShopBuyCmpSeq( SHOP_WORK * wk )
{
	if( FldTalkMsgEndCheck( wk->midx ) == 0 ){
		return SHOP_SEQ_BUY_CMP;
	}
	MyItem_AddItem( wk->myitem, wk->sel_item, wk->sel_num, HEAPID_WORLD );
	Mystatus_SubGold( wk->my, wk->sel_price*wk->sel_num );
	ShopBuyGoldWinPut( wk, 1 );
	return SHOP_SEQ_BUYCMP_WAIT;
}










static u8 ShopBuyCmpWaitSeq( SHOP_WORK * wk )
{
	if( FldTalkMsgEndCheck( wk->midx ) == 0 ){
		return SHOP_SEQ_BUYCMP_WAIT;
	}
	if( sys.trg & (PAD_BUTTON_A|PAD_BUTTON_B) ){
		BmpTalkWinClear( &wk->win[WIN_IDX_TALK], WINDOW_TRANS_ON );

		ShopBuyScrCurPosChg( wk, 0 );
		CLACT_SetDrawFlag( wk->cwp[0], wk->scr_draw[0] );
		CLACT_SetDrawFlag( wk->cwp[1], wk->scr_draw[1] );

		return SHOP_SEQ_BUY_SELECT;
	}
	return SHOP_SEQ_BUYCMP_WAIT;
}


//--------------------------------------------------------------------------------------------
/**
 * IXN[
 */
//--------------------------------------------------------------------------------------------
static u8 ShopBuyEndSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
	if( wk->cm_cnt != wk->cm_max ){
		VecFx32 move = {-8*FX32_ONE,0,0};
		GFC_ShiftCamera( &move, wk->camera );
		wk->cm_cnt++;
		return SHOP_SEQ_BUY_END;
	}
	wk->cm_cnt = 0;
	GFC_CopyCamera( wk->camera, fsys->camera_ptr );		// Jf
	GFC_FreeCamera( wk->camera);						// J폜
	GFC_AttachCamera( fsys->camera_ptr );				// JA^b`
//	ShopMenuSet( wk );

	ShopBuyActExit( wk );

	FldTalkBmpAdd( fsys->bgl, &wk->win[WIN_IDX_FLDTALK], FLD_MBGFRM_FONT );
	FldTalkWinPut( &wk->win[WIN_IDX_FLDTALK] );
	{
		STRBUF * str = MSGMAN_AllocString( wk->mman, mes_shop_01_03 );
		WORDSET_ExpandStr( wk->wset, wk->msgb, str );
		STRBUF_Delete( str );
	}
	wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_FLDTALK], wk->msgb, 1 );

	return SHOP_SEQ_MENU_RET;
}


static u8 ShopBuyMenuRetSeq( SHOP_WORK * wk )
{
	if( FldTalkMsgEndCheck( wk->midx ) == 0 ){
		return SHOP_SEQ_MENU_RET;
	}
	GF_BGL_BmpWinDel( &wk->win[WIN_IDX_FLDTALK] );
	ShopMenuSet( wk );
	return SHOP_SEQ_MENU;
}






static void ShopExitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
	STRBUF * str = MSGMAN_AllocString( wk->mman, mes_shop_01_02 );
	WORDSET_ExpandStr( wk->wset, wk->msgb, str );
	STRBUF_Delete( str );
	FldTalkBmpAdd( fsys->bgl, &wk->win[WIN_IDX_FLDTALK], FLD_MBGFRM_FONT );
	FldTalkWinPut( &wk->win[WIN_IDX_FLDTALK] );
	wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_FLDTALK], wk->msgb, 1 );
}







enum {
	CLA_ID_ARROW = 0,
	CLA_ID_CURSOR,
	CLA_ID_ITEMICON,
};

#define	LIST_SCR_PX		( 177 )
#define	LIST_SCR_U_PY	( 8 )
#define	LIST_SCR_D_PY	( 132 )

#define	NUM_SCR_PX		( 162 )
#define	NUM_SCR_U_PY	( 108 )
#define	NUM_SCR_D_PY	( 132 )

#define	SHOP_ITEMICON_PX	( 22 )
#define	SHOP_ITEMICON_PY	( 172 )


static const TCATS_RESOURCE_FILE_LIST CatsFileList = {
	"data/shop_chr.resdat",		// LN^
	"data/shop_pal.resdat",		// pbg
	"data/shop_cell.resdat",	// Z
	"data/shop_canm.resdat",	// ZAj
	NULL,						// }`Z
	NULL,						// }`ZAj
	"data/shop_h.cldat"			// wb_[

};

static const TCATS_OBJECT_ADD_PARAM	ActAddParam[] =
{
	{	// J[\
		CLA_ID_ARROW,
		LIST_SCR_PX, LIST_SCR_U_PY, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// J[\
		CLA_ID_ARROW,
		LIST_SCR_PX, LIST_SCR_D_PY, 0,
		1, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// J[\
		CLA_ID_CURSOR,
		CURSOR_ACT_PX, CURSOR_ACT_PY, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
	{	// ACeACR
		CLA_ID_ITEMICON,
		SHOP_ITEMICON_PX, SHOP_ITEMICON_PY, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		0, 0, 0, 0
	},
};


static void ShopBuyActSet( SHOP_WORK * wk )
{
	u32	i;

	FieldCellActSet( &wk->fcat, &CatsFileList, SHOP_CLA_MAX, HEAPID_WORLD );

	for( i=0; i<SHOP_CLA_MAX; i++ ){
		wk->cwp[i] = FieldCellActAdd( &wk->fcat, &ActAddParam[i] );
	}

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
}

static void ShopBuyActExit( SHOP_WORK * wk )
{
	u32	i;

	for( i=0; i<SHOP_CLA_MAX; i++ ){
		CLACT_Delete( wk->cwp[i] );
	}
	FieldCellActDelete( &wk->fcat );
}


static void ShopBuyScrCurPosChg( SHOP_WORK * wk, u8 flg )
{
	if( flg == 0 ){
		CATS_ObjectPosSet( wk->cwp[SHOP_CLA_ARROW_U], LIST_SCR_PX, LIST_SCR_U_PY );
		CATS_ObjectPosSet( wk->cwp[SHOP_CLA_ARROW_D], LIST_SCR_PX, LIST_SCR_D_PY );
	}else{
		CATS_ObjectPosSet( wk->cwp[SHOP_CLA_ARROW_U], NUM_SCR_PX, NUM_SCR_U_PY );
		CATS_ObjectPosSet( wk->cwp[SHOP_CLA_ARROW_D], NUM_SCR_PX, NUM_SCR_D_PY );
	}
}


static void ShopBuyItemIconChg( SHOP_WORK * wk, u16 item )
{
	CLACT_U_RES_OBJ_PTR	obj;

	// L
	obj = CLACT_U_ResManagerGetIDResObjPtr( wk->fcat.resMan[0], 2 );
	CLACT_U_ResManagerResChgArcChar(
		wk->fcat.resMan[0], obj,
		ARC_ITEMICON, GetItemIndex(item,ITEM_GET_ICON_CGX), 0, HEAPID_WORLD );
	CLACT_U_CharManagerReTrans( obj );

	// pbg
	obj = CLACT_U_ResManagerGetIDResObjPtr( wk->fcat.resMan[1], 1 );
	CLACT_U_ResManagerResChgArcPltt(
		wk->fcat.resMan[1], obj,
		ARC_ITEMICON, GetItemIndex(item,ITEM_GET_ICON_PAL), 0, HEAPID_WORLD );
	CLACT_U_PlttManagerReTrans( obj );
}






//============================================================================================
//	
//============================================================================================
static const u8 BagList[] = {
	BAG_POKE_EVENT, BAG_POKE_NORMAL, BAG_POKE_NUTS, BAG_POKE_DRUG,
	BAG_POKE_BALL, BAG_POKE_BATTLE, BAG_POKE_SEAL, BAG_POKE_WAZA, 0xff
};

static void ShopSaleInitSeq( SHOP_WORK * wk )
{
	FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );
	wk->seq = SHOP_SEQ_SALE_CALL;
}

static u8 ShopSaleCallSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return SHOP_SEQ_SALE_CALL;
	}

	ShopMenuExit( wk );

	{
		MYITEM * myitem;

		myitem = SaveData_GetMyItem( fsys->savedata );
		wk->bag_wk = MyItem_MakeBagData( myitem, BagList, HEAPID_WORLD );
		BagSystemDataSet( wk->bag_wk, 0, BAG_MODE_ITEMSALE, wk->my );
		GameSystem_StartSubProc( fsys, &BagProcData, wk->bag_wk );
	}

	return SHOP_SEQ_SALE_WAIT;
}



static u8 ShopSaleWaitSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
	// TuvZXI҂
	if( FieldEvent_Cmd_WaitSubProcEnd( fsys ) ) {
		return SHOP_SEQ_SALE_WAIT;
	}

	sys_FreeMemoryEz( wk->bag_wk );

	FieldEvent_Cmd_SetMapProc( fsys );

	return SHOP_SEQ_SALE_RET;
}

static u8 ShopSaleRetSeq( FIELDSYS_WORK * fsys )
{
	// tB[h}bvvZXJn҂
	if( FieldEvent_Cmd_WaitMapProcStart(fsys) ){
//		FieldOBJSys_MoveStopAll( fsys->fldobjsys );
		FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
		return SHOP_SEQ_SALE_MENU_RET;
	}
	return SHOP_SEQ_SALE_RET;
}

static u8 ShopSaleMenuRetSeq( FIELDSYS_WORK * fsys, SHOP_WORK * wk )
{
	if( IsFinishedBrightnessChg( MASK_DOUBLE_DISPLAY ) == FALSE ){
		return SHOP_SEQ_SALE_MENU_RET;
	}

	FldTalkBmpAdd( fsys->bgl, &wk->win[WIN_IDX_FLDTALK], FLD_MBGFRM_FONT );
	FldTalkWinPut( &wk->win[WIN_IDX_FLDTALK] );
	{
		STRBUF * str = MSGMAN_AllocString( wk->mman, mes_shop_01_03 );
		WORDSET_ExpandStr( wk->wset, wk->msgb, str );
		STRBUF_Delete( str );
	}
	wk->midx = FldTalkMsgStart( &wk->win[WIN_IDX_FLDTALK], wk->msgb, 1 );
	return SHOP_SEQ_MENU_RET;
}
