//=============================================================================
/**
 * @file	field_3d_anime.c
 * @bfief	tB[h3DAj[V֘A
 * @author	Nozomu Saito
 *
 */
//=============================================================================

#include "common.h"

#include "field_3d_anime.h"
#include "fieldsys.h"
#include "field_event.h"

#include "map_tool.h"
#include "system/snd_tool.h"	//for SE

#include "field_3d_anime_def.h"

#define ONE_MODEL_ANM_NUM_MAX	(4)	//P̃fɑ΂čőS܂ŃAjĂƂ
#define ANIME_NO_MAX		(NELEMS(AnimePath))	//Aj̎
#define ANIME_MODEL_MAX		(NELEMS(AnimeTable))	//Aj郂fOf[^̐
#define NO_ANIME		(0)
#define NO_ENTRY		(0)
#define ANIME_CONT_MAX	(10)	//Ƃ肠PO܂œǗ

#define SUICIDE_ANIME_MAX	(2)	//EAjǗő吔

//VKAjǉƂ́A
//@AnimePathAAnimeTableAGetAnimePathAF3DA_GetFld3DAnimeCodeAGetFld3DAnimationType
//@mF邱

typedef enum{
	STATE_END,	//I
	STATE_MOVE,	//ғ
}ANIME_STATE;

typedef enum{
	DATA_INVALID,
	DATA_VALID,
}DATA_VAL_STATE;

//EAjǗ\
typedef struct SUICIDE_ANIME_DATA_tag
{
	BOOL Valid;						//f[^LtO
	NNSG3dRenderObj *RenderObj;		//AjKp郌_[OBJ
	FLD_3D_ANM_DAT_PTR AnimePtr;	//ΏۃAj|C^
//	int ObjID;						//OBJID
	int AnimeCode;					//ΏۃAjR[h
}SUICIDE_ANIME_DATA;

typedef struct FLD_3D_ANIME_DATA_tag{
	NNSG3dAnmObj* pAnmObj;
	DATA_VAL_STATE Valid;
	int LoopCount;
//	BOOL OneFrameEnd;
//	BOOL *EndFlg;
	int AnimeCode;
	BOOL StopFlg;
	void *pFile;
	int LoopMax;
	ANIME_STATE State;	//
	BOOL Reverse;
	int ControlCode;
}FLD_3D_ANIME_DATA;

typedef struct FLD_3D_ANIME_MANAGER_tag{
	NNSFndAllocator AnimeAllocator;
	FLD_3D_ANIME_DATA Fld3DAnimeData[FLD_3D_ANIME_MAX];
	SUICIDE_ANIME_DATA SuicideData[SUICIDE_ANIME_MAX];
}FLD_3D_ANIME_MANAGER;

typedef struct ANIME_DATA_LIST_tag{
	FLD_3D_ANM_DAT_PTR Data[ONE_MODEL_ANM_NUM_MAX];	//Aj[Vf[^Xg|C^
	int AnimeNum;						//Aj[Vf[^̐;
}ANIME_DATA_LIST;

typedef struct ANIME_CONT_tag
{
	ANIME_DATA_LIST	AnimeList;			//Aj[Vf[^Xg
	NNSG3dRenderObj *RenderObj;			//AjKp郌_[OBJ
	FLD_3D_ANM_DAT_PTR BindAnime;			//oChĂAj
	int ObjID;							//OBJID
	u8 EntryID;							//o^ID
}ANIME_CONT;

typedef struct ANIME_CONT_MNG_tag
{
	ANIME_CONT AnimeCont[ANIME_CONT_MAX];
}ANIME_CONT_MNG;

typedef struct ANIME_TABLE_tag
{
	int AnimeCode[ONE_MODEL_ANM_NUM_MAX];
}ANIME_TABLE;


#ifdef PM_DEBUG
static const char * AnimePath[]={
	{"data/funsui.nsbta"},			//AnimeCode1
	{"data/treeeff.nsbca"},			//AnimeCode2
	{"data/machine_l02.nsbta"},		//AnimeCode3
	{"data/pc_door_op.nsbca"},		//AnimeCode4
	{"data/pc_door_cl.nsbca"},		//AnimeCode5
	{"data/door_op.nsbca"},			//AnimeCode6
	{"data/door_cl.nsbca"},			//AnimeCode7
	{"data/r04_b1.nsbtp"},			//AnimeCode8
	{"data/r04_b2.nsbtp"},			//AnimeCode9
	{"data/r04_b3.nsbtp"},			//AnimeCode10
	{"data/r04_w.nsbta"},			//AnimeCode11
	{"data/stair_pc_u01d.nsbtp"},	//AnimeCode12
	{"data/stair_pc_u01u.nsbtp"},	//AnimeCode13
	{"data/gym05_o4.nsbtp"},		//AnimeCode14
	{"data/door_op_out.nsbca"},		//AnimeCode15
	{"data/door_cl_out.nsbca"},		//AnimeCode16
	{"data/treeeff01.nsbca"},		//AnimeCode17
	{"data/treeeff02.nsbca"},		//AnimeCode18
	{"data/treeeff03.nsbca"},		//AnimeCode19
	{"data/wfall.nsbta"},			//AnimeCode20
	{"data/l_lake.nsbta"},			//AnimeCode21
	{"data/cy_slope_botm.nsbta"},	//AnimeCode22
	{"data/cy_slope_top.nsbta"},	//AnimeCode23
	{"data/machine_l03.nsbta"},		//AnimeCode24
};
#endif

static const ANIME_TABLE AnimeTable[]={
	{1,NO_ANIME,NO_ANIME,NO_ANIME},			//0		:
	{17,18,19,NO_ANIME},					//1		:
	{3,NO_ANIME,NO_ANIME,NO_ANIME},			//2		:m̋@B
	{4,5,NO_ANIME,NO_ANIME},				//3		:hA
	{6,7,15,16},							//4		:hA1
	{6,7,15,16},							//5		:hA2
	{6,7,15,16},							//6		:hA3
	{6,7,15,16},							//7		:hA4
	{8,NO_ANIME,NO_ANIME,NO_ANIME},			//8		:W{^1
	{9,NO_ANIME,NO_ANIME,NO_ANIME},			//9		:W{^2
	{10,NO_ANIME,NO_ANIME,NO_ANIME},		//10	:W{^3
	{11,NO_ANIME,NO_ANIME,NO_ANIME},		//11	:W
	{12,NO_ANIME,NO_ANIME,NO_ANIME},		//12	:GXJ
	{13,NO_ANIME,NO_ANIME,NO_ANIME},		//13	:GXJ
	{6,7,15,16},							//14	:S[XgWhA
	{14,NO_ANIME,NO_ANIME,NO_ANIME},		//15	:S[XgW
	{20,NO_ANIME,NO_ANIME,NO_ANIME},		//16	:1
	{20,NO_ANIME,NO_ANIME,NO_ANIME},		//17	:2
	{20,NO_ANIME,NO_ANIME,NO_ANIME},		//18	:3
	{20,NO_ANIME,NO_ANIME,NO_ANIME},		//19	:4
	{20,NO_ANIME,NO_ANIME,NO_ANIME},		//20	:5
	{20,NO_ANIME,NO_ANIME,NO_ANIME},		//21	:6
	{21,NO_ANIME,NO_ANIME,NO_ANIME},		//22	:Ζ
	{22,23,NO_ANIME,NO_ANIME},				//23	:
	{24,NO_ANIME,NO_ANIME,NO_ANIME},		//24	:d}V
};

static const BOOL AnimeSuicideFlg[] = {
	FALSE,		//0:_~[
	FALSE,		//1:
	FALSE,		//2:h
	FALSE,		//3:m̋@B
	FALSE,		//4:hAI[v
	FALSE,		//5:hAN[Y
	FALSE,		//6:hAI[vC
	FALSE,		//7:hAN[YC
	FALSE,		//8:W{^1
	FALSE,		//9:W{^2
	FALSE,		//10:W{^3
	FALSE,		//11:W
	FALSE,		//12:GXJ
	FALSE,		//13:GXJ
	FALSE,		//14:S[XgW
	FALSE,		//15:hAI[vAEg
	FALSE,		//16:hAN[YAEg
	FALSE,		//17:h
	FALSE,		//18:h
	FALSE,		//19:h
	FALSE,		//20:
	FALSE,		//21:Ζ
	TRUE,		//22:
	TRUE,		//23:
	FALSE,		//24:d}V
};

//==============================================================================
/**
 * AjpX擾
 *
 * @param	inCode					AjR[h
 *
 * @return	char*						pX
 */
//==============================================================================
static const char* GetAnimePath(const int inCode)
{
	if (inCode == 1){		//
		return AnimePath[0];
	}else if(inCode == 2){	//
		return AnimePath[1];
	}else if(inCode == 3){	//m̋@B
		return AnimePath[2];
	}else if(inCode == 4){
		return AnimePath[3];//hAI[v
	}else if(inCode == 5){
		return AnimePath[4];//hAN[Y
	}else if(inCode == 6){
		return AnimePath[5];//hAI[v
	}else if(inCode == 7){
		return AnimePath[6];//hAN[Y
	}else if(inCode == 8){
		return AnimePath[7];//W{^1
	}else if(inCode == 9){
		return AnimePath[8];//W{^2
	}else if(inCode == 10){
		return AnimePath[9];//W{^3
	}else if(inCode == 11){
		return AnimePath[10];//W
	}else if(inCode == 12){
		return AnimePath[11];//GXJ
	}else if(inCode == 13){
		return AnimePath[12];//GXJ
	}else if(inCode == 14){
		return AnimePath[13];//W
	}else if(inCode == 15){
		return AnimePath[14];//hAI[viOoj
	}else if(inCode == 16){
		return AnimePath[15];//hAN[YiOoj
	}else if(inCode == 17){
		return AnimePath[16];//h؁iʁj
	}else if(inCode == 18){
		return AnimePath[17];//h؁ij
	}else if(inCode == 19){
		return AnimePath[18];//h؁ij
	}else if(inCode == 20){
		return AnimePath[19];//
	}else if(inCode == 21){
		return AnimePath[20];//Ζ
	}else if(inCode == 22){
		return AnimePath[21];//
	}else if(inCode == 23){
		return AnimePath[22];//
	}else if(inCode == 24){
		return AnimePath[23];//d}V
	}else{
		GF_ASSERT(0&&"Ajw~X");
	}
	return NULL;
}

//==============================================================================
/**
 * AjEtO擾
 *
 * @param	inAnimeCode					AjR[h
 *
 * @return	BOOL			TRUE:EAj@FALSE:񎩎EAj
 */
//==============================================================================
static BOOL GetAnimeSuicideFlg(const int inAnimeCode)
{
	return AnimeSuicideFlg[inAnimeCode];
}

//==============================================================================
/**
 * EAjGg[
 *
 * @param	*ioSuicideData				EAjǗ\̂ւ̃|C^
 * @param	*objectdata					Ώۃ_[OBJ
 * @param	anime						Aj|C^
 * @param	inAnimeCode					ΏۃAjR[h
 *
 * @return	BOOL	TRUE:Eς݂œo^	FALSE:܂Ă
 */
//==============================================================================
static BOOL EntrySuicideAnime(	SUICIDE_ANIME_DATA *ioSuicideData,
								NNSG3dRenderObj *objectdata,
								FLD_3D_ANM_DAT_PTR	anime,
								const int inAnimeCode	)
{
	int i;

	//ΏۃAj͎EAj`FbN
	if ( !GetAnimeSuicideFlg(inAnimeCode) ){
		return TRUE;	//EAjł͂Ȃ̂Ń^[
	}

	GF_ASSERT(anime->LoopMax!=LOOP_INFINIT&&"[v񐔂ɐ̂́AΏۊOł");
	
	//Gg[
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		if (ioSuicideData[i].Valid){
			if ( (ioSuicideData[i].AnimeCode == inAnimeCode)&&
					(ioSuicideData[i].RenderObj == objectdata) ){
				OS_Printf("̂łɃGgĂ\n");
				return FALSE;
			}
		}
	}
	//Gg[
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		if (!ioSuicideData[i].Valid){
			ioSuicideData[i].Valid = TRUE;
			ioSuicideData[i].AnimeCode = inAnimeCode;
			ioSuicideData[i].AnimePtr = anime;
			ioSuicideData[i].RenderObj = objectdata;
			break;
		}
	}
	return TRUE;
}

//==============================================================================
/**
 * Aj[h
 *
 * @param	path				pX
 * @param	pModel				f\[X
 * @param	pAnmObj				AjOBJ
 * @param	pTex				eNX`
 * @param	allocator			AP[^
 *
 * @return	void*				Aj|C^
 */
//==============================================================================
static void *Field3DAnimeLoad(	const char* path,
								NNSG3dResMdl* pModel,
								NNSG3dAnmObj** pAnmObj,
								NNSG3dResTex	*pTex,
								NNSFndAllocator *allocator)
{
	void* pFile;
    void* pAnmRes;
	
	if(path!=NULL){
	    pFile = sys_LoadFile(HEAPID_FIELD,path);
	    //SDK_ASSERTMSG( pFile, "anm load failed" );
		GF_ASSERT( (pFile != NULL) && "anm load failed" );
	}else{
		GF_ASSERT( (0) && "nothing path" );
	}

    {
        pAnmRes = NNS_G3dGetAnmByIdx(pFile, 0);
        SDK_NULL_ASSERT(pAnmRes);

        // Kvʂ̃AP[gBCjVCY͕ʓrKvɂȂB
        *pAnmObj = NNS_G3dAllocAnmObj(allocator, // gpAP[^w
                                     pAnmRes,    // Aj[V\[Xw
                                     pModel);    // f\[Xw
        SDK_NULL_ASSERT(pAnmObj);

        //
        // AnmObj BWCgAj[VȊOl
        //
        NNS_G3dAnmObjInit(*pAnmObj, // Aj[VIuWFNgւ̃|C^
                          pAnmRes, // Aj\[Xւ̃|C^
                          pModel,  // NNSG3dResMdlւ̃|C^
                          pTex );  // NNSG3dResTexւ̃|C^(eNX`p^[AjȊOȂNULLł悢)
		return pFile;
    }
}

//==============================================================================
/**
 * Aj[u
 *
 * @param	inRenderObj				_[OBJ
 * @param	inAnmObj				AjOBJ
 *
 * @return	BOOL				TRUE:[u	FALSE:[uȂ		
 */
//==============================================================================
static const BOOL RemoveAnime(NNSG3dRenderObj *inRenderObj, NNSG3dAnmObj *inAnmObj)
{
	if (inAnmObj == NULL){
		return FALSE;
	}

	//sł́A[uΏۂĂ̊֐ʂ(̏ꍇAł̓[uɖ߂)
	NNS_G3dRenderObjRemoveAnmObj( inRenderObj, inAnmObj );
	return TRUE;
}

//==============================================================================
/**
 * EAjĎ
 *
 * @param	*ioSuicideData				EAjǗ\̂ւ̃|C^
 * @param	*objectdata					Ώۃ_[OBJ
 * @param	inAnimeCode					ΏۃAjR[h
 *
 * @return	none
 */
//==============================================================================
static void SuicideAnimeMain(SUICIDE_ANIME_DATA *ioSuicideData)
{
	int i;
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		if (ioSuicideData[i].Valid){
			//AjI`FbN
			if (F3DA_IsAnimeEnd(ioSuicideData[i].AnimePtr)){
				//IĂAjp[W
				RemoveAnime(ioSuicideData[i].RenderObj, ioSuicideData[i].AnimePtr->pAnmObj);
				ioSuicideData[i].Valid = FALSE;
				ioSuicideData[i].AnimeCode = 0;
				ioSuicideData[i].AnimePtr = NULL;
				ioSuicideData[i].RenderObj = NULL;
			}
		}
	}
}

//==============================================================================
/**
 * 3DAj}l[W̃AP[V
 *
 * @return	FLD_3D_ANM_MNG_PTR				AjǗ\̂ւ̃|C^
 */
//==============================================================================
FLD_3D_ANM_MNG_PTR F3DA_Field3DAnimeInit(void)
{
	int i;
	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr;
	field_3d_anime_ptr = sys_AllocMemory( HEAPID_FIELD, sizeof(FLD_3D_ANIME_MANAGER) );
	//󂢂ĂAjz
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_INVALID;
		field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = FALSE;
		field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
		field_3d_anime_ptr->Fld3DAnimeData[i].LoopCount = 0;
//		field_3d_anime_ptr->Fld3DAnimeData[i].EndFlg = NULL;
		field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode = 0;
		field_3d_anime_ptr->Fld3DAnimeData[i].pFile = NULL;
		field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = LOOP_INFINIT;
		field_3d_anime_ptr->Fld3DAnimeData[i].State = STATE_END;
		field_3d_anime_ptr->Fld3DAnimeData[i].Reverse = FALSE;
		field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = 0;
	}
	for(i=0;i<SUICIDE_ANIME_MAX;i++){
		field_3d_anime_ptr->SuicideData[i].Valid = FALSE;
		field_3d_anime_ptr->SuicideData[i].RenderObj = NULL;
		field_3d_anime_ptr->SuicideData[i].AnimePtr = NULL;
		field_3d_anime_ptr->SuicideData[i].AnimeCode = 0;
	}
	//AjAP[^
	sys_InitAllocator(&field_3d_anime_ptr->AnimeAllocator,HEAPID_FIELD,4);
//	field_3d_anime_ptr->EndFlg = FALSE;
	return field_3d_anime_ptr;
}


//==============================================================================
/**
 * AjOBJ擾
 * @param	inFld3DAnmDat			Ajf[^|C^
 *
 * @return	NNSG3dAnmObj			AjOBJ
 */
//==============================================================================
static NNSG3dAnmObj *GetAnmObj(FLD_3D_ANM_DAT_PTR inFld3DAnmDat)
{
	if (inFld3DAnmDat == NULL){
		return NULL;
	}
	return inFld3DAnmDat->pAnmObj;
}

//==============================================================================
/**
 * Aj^Cv擾
 * @param	inFld3DObjCode			OBJID
 *
 * @return	int						Aj^Cv
 */
//==============================================================================
static int GetFld3DAnimationType(const int inFld3DObjCode)
{
	if ( inFld3DObjCode == FUNSUI_CODE ){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == TREEEFF_CODE ){
		return FLD_3D_ANIME_SET_COND;
	}else if( inFld3DObjCode == DOCTOR_MACHINE_CODE){
		return FLD_3D_ANIME_STATION;
	}else if (inFld3DObjCode == P_DOOR_TYPE1_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if (inFld3DObjCode == DOOR_TYPE1_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if (inFld3DObjCode == DOOR_TYPE2_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if (inFld3DObjCode == DOOR_TYPE3_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if (inFld3DObjCode == DOOR_TYPE4_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if( inFld3DObjCode == GYM_BUTN1_CODE){
		return FLD_3D_ANIME_STATION;//FLD_3D_ANIME_ALL_COND;
	}else if( inFld3DObjCode == GYM_BUTN2_CODE){
		return FLD_3D_ANIME_STATION;//FLD_3D_ANIME_ALL_COND;
	}else if( inFld3DObjCode == GYM_BUTN3_CODE){
		return FLD_3D_ANIME_STATION;//FLD_3D_ANIME_ALL_COND;
	}else if( inFld3DObjCode == GYM_WATER_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == ESCA_DOWN_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if( inFld3DObjCode == ESCA_UP_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if( inFld3DObjCode == GHOST_GYM_DOOR_CODE){
		return FLD_3D_ANIME_ALL_COND;
	}else if( inFld3DObjCode == GHOST_GYM_LIGHT_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == FALL1_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == FALL2_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == FALL3_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == FALL4_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == FALL5_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == FALL6_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == LAKE_CODE){
		return FLD_3D_ANIME_STATION;
	}else if( inFld3DObjCode == CY_SLOPE_CODE){
		return FLD_3D_ANIME_SET_COND;
	}else if( inFld3DObjCode == ELE_MACHINE_CODE){
		return FLD_3D_ANIME_STATION;
	}

	OS_Printf("%d:AjȂOBJł\n");
	GF_ASSERT(0);
	return 0;
}

//==============================================================================
/**
 * ǉɏ邩ǂ`FbN
 * @param	inObjID			OBJID
 *
 * @return	BOOL			TRUE:	FALSE:Ȃ
 */
//==============================================================================
static BOOL CheckAddConditional(const int inObjID)
{
	int anime_type;
	//OBJ̃Aj^Cv擾
	anime_type = GetFld3DAnimationType(inObjID);
	if ( (anime_type&0x01) == 0x01 ){
		return TRUE;		//
	}else{
		return FALSE;		//
	}
}

//==============================================================================
/**
 * Zbgɏ邩ǂ`FbN
 * @param	inObjID			OBJID
 *
 * @return	BOOL			TRUE:	FALSE:Ȃ
 */
//==============================================================================
static BOOL CheckSetConditional(const int inObjID)
{
	int anime_type;
	//OBJ̃Aj^Cv擾
	anime_type = GetFld3DAnimationType(inObjID);
	if ( ((anime_type>>1)&0x01) == 0x01){
		return TRUE;		//
	}else{
		return FALSE;		//
	}
}

//==============================================================================
/**
 * AjXe[g̎擾
 *
 * @param	inAnimeData				Ajf[^|C^
 *
 * @return	int						AjXe[g
 */
//==============================================================================
static int GetAnimeState(const FLD_3D_ANM_DAT_PTR inAnimeData)
{
	GF_ASSERT((inAnimeData->Valid == DATA_VALID)&&"f[^͖ł");
	return inAnimeData->State;
}

//==============================================================================
/**
 * Aj[VR[h̎擾
 *
 * @param	inFld3DObjCode			OBJID
 * @param	inAnimeNo				ĐAjio[
 *
 * @return	int						AjR[h
 */
//==============================================================================
int F3DA_GetFld3DAnimeCode(const int inFld3DObjCode, const int inAnimeNo/*, const struct list*/)
{
	if (inFld3DObjCode == FUNSUI_CODE){
		return AnimeTable[0].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == TREEEFF_CODE){
		return AnimeTable[1].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == DOCTOR_MACHINE_CODE){
		return AnimeTable[2].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == P_DOOR_TYPE1_CODE){
		return AnimeTable[3].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == DOOR_TYPE1_CODE){
		return AnimeTable[4].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == DOOR_TYPE2_CODE){
		return AnimeTable[5].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == DOOR_TYPE3_CODE){
		return AnimeTable[6].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == DOOR_TYPE4_CODE){
		return AnimeTable[7].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == GYM_BUTN1_CODE){
		return AnimeTable[8].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == GYM_BUTN2_CODE){
		return AnimeTable[9].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == GYM_BUTN3_CODE){
		return AnimeTable[10].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == GYM_WATER_CODE){
		return AnimeTable[11].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == ESCA_DOWN_CODE){
		return AnimeTable[12].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == ESCA_UP_CODE){
		return AnimeTable[13].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == GHOST_GYM_DOOR_CODE){
		return AnimeTable[14].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == GHOST_GYM_LIGHT_CODE){
		return AnimeTable[15].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == FALL1_CODE){
		return AnimeTable[16].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == FALL2_CODE){
		return AnimeTable[17].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == FALL3_CODE){
		return AnimeTable[18].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == FALL4_CODE){
		return AnimeTable[19].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == FALL5_CODE){
		return AnimeTable[20].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == FALL6_CODE){
		return AnimeTable[21].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == LAKE_CODE){
		return AnimeTable[22].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == CY_SLOPE_CODE){
		return AnimeTable[23].AnimeCode[inAnimeNo];
	}else if (inFld3DObjCode == ELE_MACHINE_CODE){
		return AnimeTable[24].AnimeCode[inAnimeNo];
	}else{
		return /*ANIME_MODEL_MAX*/0;
	}
}

//==============================================================================
/**
 * Aj[Vǉ
 *
 * @param	inObjCode				OBJID
 * @param	inAnimeNo				ĐAjio[
 * @param	inLoopCount				JԂ
 * @param	inCode					R[h
 * @param	inReverse				tĐtO
 * @param	inStopFlg				~tO
 * @param	inAnimeType				ǉAj^Cv
 * @param	objectmodel				\[Xf
 * @oaram	pTex					eNX`\[XieNX`p^[Ajpj
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	ANIME_CONT_PTR	Ajf[^|C^
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_AddField3DAnime(const int inObjCode,
										const int inAnimeNo,
										const int inLoopCount,
										const int inCode,
										const BOOL inReverse,
										const BOOL inStopFlg,
										const BOOL inConditional,
										NNSG3dResMdl *objectmodel,
										NNSG3dResTex	*pTex,
										FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	int i;
	int anime_code;
	
	anime_code = F3DA_GetFld3DAnimeCode(inObjCode, inAnimeNo);
	if (anime_code == 0){
		return FALSE;
	}

	if ( CheckAddConditional(inObjCode) != inConditional){
		OS_Printf("ĂȂ:%d\n",anime_code);
		return FALSE;
	}
	
	//R[hd`FbN
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if ((inCode != 0)&&
				(field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode == inCode)){
			OS_Printf("%d:do^ł\n",inCode);
			GF_ASSERT(0);
		}
	}

	OS_Printf("animecode%d\n",anime_code);
	
	//󂢂ĂAjz
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_INVALID){
			const char* name;
			name = GetAnimePath(anime_code);
			field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_VALID;
			field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = inStopFlg;
			field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
			field_3d_anime_ptr->Fld3DAnimeData[i].LoopCount = 0;
			//field_3d_anime_ptr->Fld3DAnimeData[i].EndFlg = NULL;
			field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode = anime_code;
			field_3d_anime_ptr->Fld3DAnimeData[i].Reverse = inReverse;
			field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = inCode;

			field_3d_anime_ptr->Fld3DAnimeData[i].pFile =
									Field3DAnimeLoad(	name,
														objectmodel,
														&field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj,
														pTex,
														&field_3d_anime_ptr->AnimeAllocator);
			field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = inLoopCount;
			field_3d_anime_ptr->Fld3DAnimeData[i].State = STATE_MOVE;
			data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
			//ĐāAJnt[Zbg
			F3DA_SetStartFrame(&field_3d_anime_ptr->Fld3DAnimeData[i]);
			return data;
		}
	}
	//ǉłȂꍇ
	GF_ASSERT(0&&"3DAjǉł܂ł");
	return NULL;
}

//==============================================================================
/**
 * Aj[Vǉ(ڍׂȐݒ͍sȂA풓Ajp)
 *
 * @param	inObjCode				OBJID
 * @param	objectmodel				\[Xf
 * @oaram	pTex					eNX`\[XieNX`p^[Ajpj
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_AddField3DAnimeEasy(	const int inObjCode,
								NNSG3dResMdl *objectmodel,
								NNSG3dResTex	*pTex,
								FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int anime_code;
	int n;
	int i;
	for(n=0;n<ONE_MODEL_ANM_NUM_MAX;n++){
		anime_code = F3DA_GetFld3DAnimeCode(inObjCode, n);
		if (anime_code == 0){
			return;//𔲂
		}
		if ( CheckAddConditional(inObjCode) != FALSE){
				OS_Printf("ĂȂ:%d\n",anime_code);
				return;
		}
	
		//󂢂ĂAjz
		for(i=0;i<FLD_3D_ANIME_MAX;i++){
			if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_INVALID){
				const char* name;
				name = GetAnimePath(anime_code);
				field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_VALID;
				field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = FALSE;
				field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
				field_3d_anime_ptr->Fld3DAnimeData[i].LoopCount = 0;
				//field_3d_anime_ptr->Fld3DAnimeData[i].EndFlg = NULL;
				field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode = anime_code;
				field_3d_anime_ptr->Fld3DAnimeData[i].Reverse = FALSE;
				field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = 0;

				field_3d_anime_ptr->Fld3DAnimeData[i].pFile =
										Field3DAnimeLoad(	name,
															objectmodel,
															&field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj,
															pTex,
															&field_3d_anime_ptr->AnimeAllocator);
				field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = LOOP_INFINIT;
				field_3d_anime_ptr->Fld3DAnimeData[i].State = STATE_MOVE;
				//ĐāAJnt[Zbg
				F3DA_SetStartFrame(&field_3d_anime_ptr->Fld3DAnimeData[i]);
				
				if (inObjCode == 303){	// Ƃ肠@܂ Ajo^~Ƃ
					field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = TRUE;
					field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = 1;
				}
				break;//̓o^
			}
		}//end for(i)
		
		//ǉłȂꍇ
		GF_ASSERT((i!=FLD_3D_ANIME_MAX)&&"3DAjǉł܂ł");
	}// end for(n)
}

#if 0
u8 Field3DAnimeAddEx(	const char* inName,
						const u8 inAnimeType,
						const int inAnimeCode,
						NNSG3dRenderObj* object_p,
						NNSG3dResMdl *objectmodel,
						FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int i;
	//󂢂ĂAjz
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_INVALID){
			field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_VALID;
			field_3d_anime_ptr->Fld3DAnimeData[i].StopFlg = FALSE;
			field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
			field_3d_anime_ptr->Fld3DAnimeData[i].LoopCount = 0;
			//field_3d_anime_ptr->Fld3DAnimeData[i].EndFlg;
			field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode = inAnimeCode;
			
			field_3d_anime_ptr->Fld3DAnimeData[i].pFile =
								Field3DAnimeLoad(	inName,
													objectmodel,
													&field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj,
													&field_3d_anime_ptr->AnimeAllocator);
			field_3d_anime_ptr->Fld3DAnimeData[i].LoopMax = 1;
			field_3d_anime_ptr->Fld3DAnimeData[i].State = STATE_MOVE;
			break;
		}
	}
	if (i != FLD_3D_ANIME_MAX){
		//
        // RenderObj  AnmObj ǉBWCgAj[VȊOl
        //
        NNS_G3dRenderObjAddAnmObj( object_p, field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj );
		return i;
	}
	//ǉłȂꍇ
	OS_Printf("3DAjǉł܂ł\n");
	return FLD_3D_ANIME_MAX;
	
}

void SetField3DAnmEndFlg(const u8 inIdx, FLD_3D_ANM_MNG_PTR field_3d_anime_ptr, BOOL *ioEndFlg)
{
	*ioEndFlg = FALSE;
	field_3d_anime_ptr->Fld3DAnimeData[inIdx].EndFlg = ioEndFlg;
}
#endif
//==============================================================================
/**
 * Aj[VZbg
 *
 * @param	inObjCode				OBJID
 * @param	inAnimeNo				ĐAjio[
 * @param	objectdata				_[OBJ
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	BOOL	TRUE:Zbgł	FALSE:ZbgłȂ
 */
//==============================================================================
BOOL F3DA_SetFld3DAnime(const int inObjCode,
						const int inAnimeNo,
						const BOOL inConditional,
						NNSG3dRenderObj *objectdata,
						FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int i;
	int anime_code;
	BOOL rc;
	if (field_3d_anime_ptr==NULL){
		GF_ASSERT(0&&"Aj}l[WNULLł");
	}

	anime_code = F3DA_GetFld3DAnimeCode(inObjCode, inAnimeNo);
	if (anime_code == 0){
		return FALSE;
	}

	if ( CheckSetConditional(inObjCode) != inConditional){
		OS_Printf("𖞂ĂȂ:%d\n",anime_code);
		return FALSE;
	}

	//wAjOBJɃZbg
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if(anime_code == field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode){
			//EAj[VGg[
			rc = EntrySuicideAnime(	field_3d_anime_ptr->SuicideData,
									objectdata,
									&field_3d_anime_ptr->Fld3DAnimeData[i],
									anime_code	);
			if (rc){
				NNS_G3dRenderObjAddAnmObj( objectdata, field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj );
			}
#if 0			
			type = GetFld3DAnimationType(inObjCode);
			if (type == inAnimeType/*(type == FLD_3D_ANIME_STATION) || (type == FLD_3D_ANIME_STATION_SUB)*/){
				NNS_G3dRenderObjAddAnmObj( objectdata, field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj );
			}
#endif			
			return TRUE;
		}
	}
	//AjȂꍇ
	OS_Printf("ObjID=%d:3DAj܂\n",inObjCode);
	return FALSE;
}

//==============================================================================
/**
 * Aj[VS
 *
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void RereaseFld3DAnimeAll(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int i;
	if (field_3d_anime_ptr==NULL) return;
	
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid != DATA_INVALID){
			if (field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_VALID){
				NNS_G3dFreeAnmObj(&field_3d_anime_ptr->AnimeAllocator,field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj);
				field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj = NULL;
				sys_FreeMemoryEz(field_3d_anime_ptr->Fld3DAnimeData[i].pFile);
			}
			field_3d_anime_ptr->Fld3DAnimeData[i].Valid = DATA_INVALID;
			field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode = 0;
		}
	}
}

//==============================================================================
/**
 * CfbNXɂAj[V
 *
 * @param	inIdx				CfbNX
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void RereaseFld3DAnimeByIdx(const u8 inIdx, FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	if (field_3d_anime_ptr==NULL) return;
	
	if (field_3d_anime_ptr->Fld3DAnimeData[inIdx].Valid != DATA_INVALID){
		if (field_3d_anime_ptr->Fld3DAnimeData[inIdx].Valid == DATA_VALID){
			NNS_G3dFreeAnmObj(	&field_3d_anime_ptr->AnimeAllocator,
								field_3d_anime_ptr->Fld3DAnimeData[inIdx].pAnmObj);
			field_3d_anime_ptr->Fld3DAnimeData[inIdx].pAnmObj = NULL;
			sys_FreeMemoryEz(field_3d_anime_ptr->Fld3DAnimeData[inIdx].pFile);
		}
		field_3d_anime_ptr->Fld3DAnimeData[inIdx].Valid = DATA_INVALID;
		field_3d_anime_ptr->Fld3DAnimeData[inIdx].ControlCode = 0;
	}
}

//==============================================================================
/**
 * Aj[V
 *
 * @param	outAnimePtr				Ajf[^|C^
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_RereaseFld3DAnime(FLD_3D_ANM_DAT_PTR outAnimePtr, FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	if (field_3d_anime_ptr==NULL) return;
	
	GF_ASSERT(outAnimePtr!=NULL&&"NULL悤ƂĂ܂");
	
	if (outAnimePtr->Valid != DATA_INVALID){
		if (outAnimePtr->Valid == DATA_VALID){
			NNS_G3dFreeAnmObj(	&field_3d_anime_ptr->AnimeAllocator,
								outAnimePtr->pAnmObj);
			outAnimePtr->pAnmObj = NULL;
			sys_FreeMemoryEz(outAnimePtr->pFile);
		}
		outAnimePtr->Valid = DATA_INVALID;
		outAnimePtr->ControlCode = 0;
	}
}

//==============================================================================
/**
 * Aj[V[u
 *
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * @param	inRenderObj				_[OBJ
 * @param	inObjCode				OBJID
 * @param	inAnimeNo				[uAjio[
 * 
 * @return	none
 */
//==============================================================================
void F3DA_RemoveFld3DAnime(	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
							NNSG3dRenderObj *inRenderObj,
							const int inObjCode,
							const int inAnimeNo	)
{
	u8 i;
	int anime_code = F3DA_GetFld3DAnimeCode(inObjCode,inAnimeNo);
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if ( field_3d_anime_ptr->Fld3DAnimeData[i].Valid == DATA_VALID ){
			if(field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode == anime_code){
				RemoveAnime(inRenderObj, field_3d_anime_ptr->Fld3DAnimeData[i].pAnmObj);
				return;
			}
		}
	}
}

//==============================================================================
/**
 * Aj[V}l[W
 *
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
void FreeFld3DAnimeManager(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	if (field_3d_anime_ptr==NULL) return;
	sys_FreeMemoryEz( field_3d_anime_ptr );
	field_3d_anime_ptr = NULL;
}
#if 0
void FreeEvent3DAnimeWork(ANIME_3D_WORK_PTR anime_3d_work_ptr)
{
	sys_FreeMemoryEz(anime_3d_work_ptr);
}
#endif
//==============================================================================
/**
 * }l[WǗCfbNXŃAjf[^擾
 *
 * @param	inIndex					CfbNX
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtrByIdx(const int inIndex,
											FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	data = &(field_3d_anime_ptr->Fld3DAnimeData[inIndex]);

	GF_ASSERT(data->Valid!=DATA_INVALID&&"wf[^͖Ԃł");
	
	return data;
}

//==============================================================================
/**
 * R[hŃAjf[^擾
 *
 * @param	inCode					R[h
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtrByCode(	const int inCode,
												FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	int i;
	GF_ASSERT(inCode!=0&&"R[hӂĂȂAj͎擾ΏۊOł");
	data = NULL;
	//
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].ControlCode == inCode){
			data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
			GF_ASSERT(data->Valid!=DATA_INVALID&&"wf[^͖Ԃł");
			break;
		}
	}
	GF_ASSERT(data!=NULL&&"Aj܂ł");
	return data;
}

//==============================================================================
/**
 * AjR[hŃAjf[^擾
 *
 * @param	inCode					AjR[h
 * @param	field_3d_anime_ptr		Aj}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtrByAnimeCode(	const int inAnimeCode,
													FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	FLD_3D_ANM_DAT_PTR data;
	int i;
	data = NULL;
	//
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		if (field_3d_anime_ptr->Fld3DAnimeData[i].AnimeCode == inAnimeCode){
			data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
			GF_ASSERT(data->Valid!=DATA_INVALID&&"wf[^͖Ԃł");
			break;
		}
	}
	GF_ASSERT(data!=NULL&&"Aj܂ł");
	return data;
}

//==============================================================================
/**
 * CfbNXɂXgbvtO̐؂ւ
 *
 * @param	inIdx					CfbNX
 * @param	inFlg					XgbvtO
 * @param	field_3d_anime_ptr		Aj[V}l[Wւ̃|C^
 * 
 * @return	none
 */
//==============================================================================
void F3DA_SetStopFlgByIdx(const u8 inIdx, const BOOL inFlg, FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	field_3d_anime_ptr->Fld3DAnimeData[inIdx].StopFlg = inFlg;
}

//==============================================================================
/**
 * XgbvtO̐؂ւ
 *
 * @param	inAnimePtr				Ajf[^|C^
 * @param	inFlg					XgbvtO
 * 
 * @return	none
 */
//==============================================================================
void F3DA_SetStopFlg(FLD_3D_ANM_DAT_PTR inAnimePtr, const BOOL inFlg)
{
	inAnimePtr->StopFlg = inFlg;
}

//==============================================================================
/**
 * Aj[VXe[g𓮍쒆ɂ
 *
 * @param	inAnimePtr				Ajf[^|C^
 * 
 * @return	none
 */
//==============================================================================
void F3DA_MoveAnime(FLD_3D_ANM_DAT_PTR inAnimePtr)
{
	inAnimePtr->State = STATE_MOVE;
}

//==============================================================================
/**
 * Aj[VŏIt[Ԃ
 *
 * @param	inAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	BOOL TRUE:ŏIt[	FALSE:ŏIt[ȊO
 */
//==============================================================================
BOOL F3DA_IsLastFrame(FLD_3D_ANM_DAT_PTR	inAnimeData)
{
	BOOL rc;
	if (!inAnimeData->Reverse){	//ʏ܂킵
		if (inAnimeData->pAnmObj->frame >= 
				NNS_G3dAnmObjGetNumFrame(inAnimeData->pAnmObj)-(FX32_ONE)){
			rc = TRUE;
		}else{
			rc = FALSE;
		}
	}else{						//t܂킵
		if (inAnimeData->pAnmObj->frame == 0){
			rc = TRUE;
		}else{
			rc = FALSE;
		}
	}
	return rc;
}

//==============================================================================
/**
 * JnAj[Vt[Zbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetStartFrame(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	if (!outAnimeData->Reverse){	//ʏ܂킵
		outAnimeData->pAnmObj->frame = 0;
	}else{						//t܂킵
		outAnimeData->pAnmObj->frame = NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)-(FX32_ONE);
	}
}

//==============================================================================
/**
 * JnAj[Vt[Zbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetLastFrame(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	if (!outAnimeData->Reverse){	//ʏ܂킵
		outAnimeData->pAnmObj->frame = NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)-(FX32_ONE);
	}else{						//t܂킵
		outAnimeData->pAnmObj->frame = 0;
	}
}

//==============================================================================
/**
 * JnAj[Vt[ύX
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_ChangeFrame(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	if (!outAnimeData->Reverse){	//ʏ܂킵
		outAnimeData->pAnmObj->frame += (FX32_ONE);
		if (outAnimeData->pAnmObj->frame == NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)){
			outAnimeData->pAnmObj->frame = 0;
		}

	}else{						//t܂킵
		if (outAnimeData->pAnmObj->frame <= 0){
			outAnimeData->pAnmObj->frame =
				NNS_G3dAnmObjGetNumFrame(outAnimeData->pAnmObj)-(FX32_ONE);
		}else{
			outAnimeData->pAnmObj->frame -= (FX32_ONE);
		}
	}
}

//==============================================================================
/**
 * wAj[V̍Đtɂ
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetAnimeReverse(FLD_3D_ANM_DAT_PTR	outAnimeData)
{
	//񐔎wAj̏ꍇ̓AT[g𔭍s
	///GF_ASSERT(outAnimeData->LoopMax != LOOP_INFINIT && "񐔎wAj[V̋t񂵂̓T|[gĂ܂");
	if (outAnimeData->Reverse){
		outAnimeData->Reverse = FALSE;
	}else{
		outAnimeData->Reverse = TRUE;
	}
}

//==============================================================================
/**
 * wAj[V̍Đtɂ(ڎw)
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetAnimeReverseDirect(FLD_3D_ANM_DAT_PTR	outAnimeData, const BOOL inReverse)
{
	//񐔎wAj̏ꍇ̓AT[g𔭍s
	///GF_ASSERT(outAnimeData->LoopMax != LOOP_INFINIT && "񐔎wAj[V̋t񂵂̓T|[gĂ܂");
	outAnimeData->Reverse = inReverse;
}

//==============================================================================
/**
 * wAj[V̍ő僋[vZbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 * @param	inLoopMax		[v
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetAnimeLoopMax(FLD_3D_ANM_DAT_PTR	outAnimeData, const int inLoopMax)
{
	outAnimeData->LoopMax = inLoopMax;
}

//==============================================================================
/**
 * wAj[V̐R[hZbg
 *
 * @param	outAnimeData	Aj[Vf[^ւ̃|C^
 * @param	inControlCode	R[h
 *
 * @return	none
 */
//==============================================================================
void F3DA_SetControlCode(FLD_3D_ANM_DAT_PTR	outAnimeData, const int inControlCode)
{
	outAnimeData->ControlCode = inControlCode;
}

//==============================================================================
/**
 * Aj[VC֐
 *
 * @param	field_3d_anime_ptr	3DAj[V}l[Wւ̃|C^
 *
 * @return	none
 */
//==============================================================================
void F3DA_Main(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr)
{
	int i;
	FLD_3D_ANM_DAT_PTR	anime_data;
	if (field_3d_anime_ptr==NULL) return;
	for(i=0;i<FLD_3D_ANIME_MAX;i++){
		anime_data = &(field_3d_anime_ptr->Fld3DAnimeData[i]);
		//Aj͗Lǂ
		if (anime_data->Valid == DATA_VALID){
			//Aj[V~ĂA̓AjIĂꍇ͏΂
			if ((anime_data->StopFlg == TRUE)||(anime_data->State == STATE_END)){
				continue;
			}

			F3DA_ChangeFrame(anime_data);	//t[؂ւ
			
			if ( anime_data->LoopMax != LOOP_INFINIT ){	//[vw񐔂
				if (F3DA_IsLastFrame(anime_data)){			//ŏIt[H
					if (anime_data->LoopCount+1 >= anime_data->LoopMax){//ŏIw胋[v񐔖ڂH
						//AjI
						anime_data->State = STATE_END;
					}else{
						anime_data->LoopCount++;	//[vCNg
					}
				}
			}
		}
	}// end for
	//EĎ
	SuicideAnimeMain(field_3d_anime_ptr->SuicideData);

}

//==============================================================================
/**
 * Aj[VIĂ邩Ԃ
 * @param	inAnimeData	Ajf[^ւ̃|C^
 *
 * @return	BOOL	TRUE:I@FALSE:NO p
 */
//==============================================================================
BOOL F3DA_IsAnimeEnd(const FLD_3D_ANM_DAT_PTR inAnimeData)
{
	int state;
	state = GetAnimeState(inAnimeData);
	if (state == STATE_END){
		return TRUE;
	}else{
		return FALSE;
	}
}
#if 0
//==============================================================================
/**
 * ̗ĂꏊɃhA邩
 *
 * @param	inObjPtr	3DIuWFNgf[^
 * @param	inX1		`XWij
 * @param	inZ1		`ZWij
 * @param	inX2		`XWiEj
 * @param	inZ2		`ZWiOj
 * @param	inTrans		ItZbg
 *
 * @return	BOOL	TRUE:HIT@FALSE:NO HIT
 */
//==============================================================================
BOOL F3DA_CheckDoor( FIELDSYS_WORK * fsys )
{
	int x,z;
	TARGET_RECT rect;
	BOOL rc;
	int list[] = {DOOR_TYPE1_CODE,DOOR_TYPE2_CODE,DOOR_TYPE3_CODE,DOOR_TYPE4_CODE,
		P_DOOR_TYPE1_CODE,BMID_GYM_DOOR01};
	
	//̈ʒu擾
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );

	//`쐬
	MPTL_MakeTargetRect( x, z, -1, -1, 3, 2, &rect);

	rc = MPTL_CheckPluralMap3DObjInRect(	fsys,
											list,
											6,
											&rect,
											NULL, NULL);

	return rc;
}
#endif
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//==============================================================================
/**
 * Aj[VGg[
 *
 * @param	inAnimeContMng	Aj[VǗ}l[Wւ̃|C^
 * @param	inEntryID		o^ID
 *
 * @return	ANIME_CONT_PTR	AjǗf[^|C^
 */
//==============================================================================
static ANIME_CONT_PTR EntryAnimeCont(ANIME_CONT_MNG_PTR inAnimeContMng, const u8 inEntryID)
{	
	u8 i;
	u8 idx;
	ANIME_CONT_PTR	data;
	
	data = NULL;
	
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	idx = ANIME_CONT_MAX;
	//󂢂ĂƂA\IDłɂ邩T
	for(i=0;i<ANIME_CONT_MAX;i++){
#ifdef PM_DEBUG		
		if (inAnimeContMng->AnimeCont[i].EntryID == inEntryID ){
			OS_Printf("ID=%d:w肳ꂽID͓o^ς݂ł\n",inEntryID);
			GF_ASSERT(0);
		}
#endif		
		if (idx == ANIME_CONT_MAX){
			idx = i;
		}
	}

	if (idx != ANIME_CONT_MAX){
		inAnimeContMng->AnimeCont[idx].EntryID = inEntryID;
	}
	return &(inAnimeContMng->AnimeCont[idx]);
}

//Gg[NA
static void EntryClearAnimeCont(ANIME_CONT_PTR outData)
{
	outData->EntryID = NO_ENTRY;
	outData->ObjID = 0;
	outData->RenderObj = NULL;
	outData->BindAnime = NULL;
}

//o^IDŃAjǗf[^擾
static ANIME_CONT_PTR GetAnmContPtrFromEntryID(	ANIME_CONT_MNG_PTR inAnimeContMng,
												const int inEntryID)
{
	int i;
	ANIME_CONT_PTR data;
	data = NULL;
	//\񂳂Ăꏊ
	for(i=0;i<ANIME_CONT_MAX;i++){
		if (inAnimeContMng->AnimeCont[i].EntryID == inEntryID){
			data = &(inAnimeContMng->AnimeCont[i]);
			break;
		}
	}
#ifdef PM_DEBUG
	if (i==ANIME_CONT_MAX){
		OS_Printf("%d:w肳ꂽo^IDAj[V擾ł܂ł",inEntryID);
		GF_ASSERT(0);
	}
#endif
	return data;
}
/**
static void FreeAnimeList(ANIME_DATA_LIST *outList)
{
	sys_FreeMemoryEz(outList);
}
*/
/**
ANIME_CONT_PTR F3DASub_SetAnimeContByID(ANIME_CONT_MNG_PTR inAnimeContMng,
										NNSG3dRenderObj *pRenderObj,
										const int inNum,
										const u8 inEntryID)
{
	ANIME_CONT_PTR data;
	data = F3DASub_GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	data->RenderObj = pRenderObj;
	data->AnimeList.Data = sys_AllocMemory(HEAPID_FIELD,sizeof(FLD_3D_ANM_DAT_PTR)*inNum);
	data->AnimeList.AnimeNum = inNum;
	return data;
}
*/
static void SetAnimeCont(	NNSG3dRenderObj *pRenderObj,
							const int inNum,
							ANIME_CONT_PTR	outData	)
{
	GF_ASSERT(inNum<=ONE_MODEL_ANM_NUM_MAX&&"1̃fĂAjI[o[Ă܂");
	outData->RenderObj = pRenderObj;
	outData->AnimeList.AnimeNum = inNum;
}

static void SetAnimePtr(ANIME_CONT_PTR inAnimeContPtr,
						const int inIndex,
						FLD_3D_ANM_DAT_PTR inAnimePtr)
{
	GF_ASSERT(inIndex<inAnimeContPtr->AnimeList.AnimeNum&&"CfbNXI[o[Ă܂");
	inAnimeContPtr->AnimeList.Data[inIndex] = inAnimePtr;
}

static FLD_3D_ANM_DAT_PTR GetAnimePtr(ANIME_CONT_PTR inAnimeContPtr, const int inIndex)
{
	GF_ASSERT(inIndex<inAnimeContPtr->AnimeList.AnimeNum&&"CfbNXI[o[Ă܂");
	return inAnimeContPtr->AnimeList.Data[inIndex];
}

static FLD_3D_ANM_DAT_PTR BindAnimation(ANIME_CONT_PTR ioAnimeContPtr, const int inIndex)
{
	FLD_3D_ANM_DAT_PTR anime;
	NNSG3dAnmObj *anm_obj;
	GF_ASSERT(inIndex<ioAnimeContPtr->AnimeList.AnimeNum&&"CfbNXI[o[Ă܂");
	anime = ioAnimeContPtr->AnimeList.Data[inIndex];
	anm_obj = GetAnmObj(anime);
	{
		NNSG3dAnmObj *bind_anmobj;
		bind_anmobj = GetAnmObj(ioAnimeContPtr->BindAnime);
		//łɃAjĂꍇ̓[u
		RemoveAnime(ioAnimeContPtr->RenderObj, bind_anmobj);
	}
	// RenderObj  AnmObj ǉBWCgAj[VȊOl
	NNS_G3dRenderObjAddAnmObj(ioAnimeContPtr->RenderObj, anm_obj );
	ioAnimeContPtr->BindAnime = anime;
	return anime;
}

//풓AĵݑΉ
static void AddField3DAnime(const int inObjID,
							NNSG3dResMdl 	*inObjectModel,
							NNSG3dResTex *inTex,
							const int inAnimeNum,
							const int inLoopCount,
							const BOOL	inReverse,
							FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
							ANIME_CONT_PTR outData)
{
	FLD_3D_ANM_DAT_PTR	anm_data;
	int i;
	for(i=0;i<inAnimeNum;i++){
		anm_data = F3DA_AddField3DAnime(inObjID,
										i,
										inLoopCount,
										0,		//O䂵Ȃ
										inReverse,	//
										TRUE,	//n߂͒~
										TRUE,	//t
										inObjectModel,
										inTex,
										field_3d_anime_ptr);
		GF_ASSERT(anm_data!=NULL&&"o^s");

		//AjǗXgɓo^Aj|C^擾Ă
		SetAnimePtr( outData, i, anm_data);	//Ajo^
	}
}

static void RereaseField3DAnime(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
								ANIME_CONT_PTR outData)
{
	int i;
	NNSG3dAnmObj *anmobj;
	anmobj = GetAnmObj(outData->BindAnime);
	//łɃAjĂꍇ̓[u
	RemoveAnime(outData->RenderObj, anmobj);
	for (i=0;i<outData->AnimeList.AnimeNum;i++){
		{		
			FLD_3D_ANM_DAT_PTR anime;
			anime = outData->AnimeList.Data[i];	
			F3DA_RereaseFld3DAnime(anime, field_3d_anime_ptr);
		}
		outData->AnimeList.Data[i] = NULL;
	}
}

//3DAj}l[W̃AP[V
ANIME_CONT_MNG_PTR F3DASub_InitField3DAnimeCont(void)
{
	int i;
	int size;
	ANIME_CONT_MNG_PTR anime_cont_mng;

	size = sizeof(ANIME_CONT_MNG);

	anime_cont_mng = sys_AllocMemory( HEAPID_FIELD, size );

	MI_CpuClearFast(anime_cont_mng,size);

	return anime_cont_mng;
}

//3DAj}l[W̉
void F3DASub_FreeAnimeContManager(ANIME_CONT_MNG_PTR *outAnimeContMng)
{
	if ((*outAnimeContMng)==NULL) return;

#ifdef	PM_DEBUG
	{
		int i;
		for(i=0;i<ANIME_CONT_MAX;i++){
			if ((*outAnimeContMng)->AnimeCont[i].EntryID != NO_ENTRY ){
				OS_Printf("EntryID:%d o^̉Ȃ܂܉悤ƂĂ܂\n",
						(*outAnimeContMng)->AnimeCont[i].EntryID);
				GF_ASSERT(0);
			}
		}
	}
#endif
	
	sys_FreeMemoryEz( (*outAnimeContMng) );
	(*outAnimeContMng) = NULL;
}


//Aj[VZbgAbv
void F3DASub_SetUpAnimation(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
							const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inObjID,
							NNSG3dRenderObj *inRenderObj,
							NNSG3dResMdl 	*inObjectModel,
							NNSG3dResTex *inTex,
							const int inAnimeNum,
							const BOOL inReverse)
{
	int i;
	ANIME_CONT_PTR		cont_data;
	//AjGg[
	cont_data = EntryAnimeCont(inAnimeContMng, inEntryID);

	//gpAjǗpAj|C^Xgm
	SetAnimeCont(inRenderObj, inAnimeNum, cont_data);
	//Aj[V̒ǉ
	AddField3DAnime(inObjID, inObjectModel, inTex, inAnimeNum, /*inLoopCount*/1, inReverse,
					field_3d_anime_ptr, cont_data);
	//OBJIDL(قڃTEhp)
	cont_data->ObjID = inObjID;
}

//AjJn
void F3DASub_StartAnimation(const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh
	//Aj[VX^[g
	F3DA_SetStopFlg(anime, FALSE);
}

//AjJn()
void F3DASub_StartAnimeSnd(const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo,
							const int inSound)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh

	Snd_SePlay(inSound);
#if 0
	if (cont_ptr->ObjID == P_DOOR_TYPE1_CODE){
		//SEZbg
		//Snd_SePlay( SEQ_SE_DP_DOOR );	//hA
		
		if( inAnimeNo == 0 ){
			Snd_SePlay( SEQ_SE_DP_DOOR_OPEN );	//hAJ
		}else{
			Snd_SePlay( SEQ_SE_DP_DOOR_CLOSE );	//hA
		}

	}else{
		//SEZbg
		//Snd_SePlay( SEQ_SE_DP_DOOR );	//hA

		if( inAnimeNo == 0 ){
			Snd_SePlay( SEQ_SE_DP_DOOR_OPEN );	//hAJ
		}else{
			Snd_SePlay( SEQ_SE_DP_DOOR_CLOSE );	//hA
		}
	}
#endif
	//Aj[VX^[g
	F3DA_SetStopFlg(anime, FALSE);
}

//AjoCh
void F3DASub_BindAnimation( const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh
}

//AjXgbvtOIIt
void F3DASub_SetStopFlg( const ANIME_CONT_MNG_PTR inAnimeContMng,
							const int inEntryID,
							const int inAnimeNo,
							const BOOL inFlg)
{
	ANIME_CONT_PTR cont_ptr;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);

	anime = BindAnimation(cont_ptr, inAnimeNo);	//AjoCh
	//Aj[VX^[g
	F3DA_SetStopFlg(anime, inFlg);
}

//
void F3DASub_RereaseAnimation(	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
								ANIME_CONT_MNG_PTR inAnimeContMng,
								const int inEntryID)
{
	ANIME_CONT_PTR data;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	data = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	//Aj[V̉
	RereaseField3DAnime(field_3d_anime_ptr, data);
	//Gg[NA
	EntryClearAnimeCont(data);
}

//Aj擾
FLD_3D_ANM_DAT_PTR F3DASub_GetFld3DAnmPtr(	const ANIME_CONT_MNG_PTR inAnimeContMng,
											const int inEntryID,
											const int inAnimeNo	)
{
	ANIME_CONT_PTR cont_data;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_data =  GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	anime = GetAnimePtr(cont_data, inAnimeNo);
	return anime;
}

//݃oChĂAj擾
FLD_3D_ANM_DAT_PTR F3DASub_GetFld3DBindAnmPtr(	const ANIME_CONT_MNG_PTR inAnimeContMng,
												const int inEntryID	)
{
	ANIME_CONT_PTR cont_data;
	FLD_3D_ANM_DAT_PTR anime;
	GF_ASSERT(inEntryID!=NO_ENTRY&&"ID=0͎wł܂");
	cont_data =  GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	anime = cont_data->BindAnime;
	return anime;
}

//Aj[VI҂
const BOOL F3DASub_WaitAnimation(	const ANIME_CONT_MNG_PTR inAnimeContMng,
									const int inEntryID	)
{
	FLD_3D_ANM_DAT_PTR data;
	data = F3DASub_GetFld3DBindAnmPtr(inAnimeContMng, inEntryID);

	GF_ASSERT(data!=NULL&&"AjoChĂȂ");
	
	if ( F3DA_IsAnimeEnd(data) ){
		return TRUE;
	}else{
		return FALSE;
	}
}

const int F3DASub_GetObjIDFromEntryID(	const ANIME_CONT_MNG_PTR inAnimeContMng,
										const int inEntryID)
{
	ANIME_CONT_PTR cont_ptr;
	cont_ptr = GetAnmContPtrFromEntryID(inAnimeContMng, inEntryID);
	return cont_ptr->ObjID;
}
