//============================================================================================
/**
 * @file	field_3d_anime.h
 * @brief   tB[h3DAj[V֘A
 * @author	nozomu saito
 * @date	2006.02.13
 */
//============================================================================================
#ifndef _FIELD_3D_ANIME_H_
#define _FIELD_3D_ANIME_H_

#include "field_common.h"


#define FLD_3D_ANIME_MAX	(8)		//tB[hœɓAj̐

#define LOOP_INFINIT		(-1)
/**
enum{
	FLD_3D_ANIME_NON = 0,		//AjȂ
	FLD_3D_ANIME_STATION,		//풓Aj
	FLD_3D_ANIME_NO_STATION,	//풓Aj
	FLD_3D_ANIME_STATION_SUB,	//풓Aj
};
*/
#define F3DA_CONDITIONAL			(1)
#define F3DA_NO_CONDITIONAL			(0)

#define F3DA_ADD_CONDITIONAL	(0x01)	//ǉ
#define F3DA_SET_CONDITIONAL	(0x02)	//Zbg

//풓AjiADDASETɏ͂Ȃj
#define FLD_3D_ANIME_STATION	(0)
//AjiADDASETɏj
#define FLD_3D_ANIME_ALL_COND	(F3DA_ADD_CONDITIONAL|F3DA_SET_CONDITIONAL)
//SET̂ݏAj(ADD͏)
#define FLD_3D_ANIME_SET_COND	(F3DA_SET_CONDITIONAL)

typedef struct FLD_3D_ANIME_MANAGER_tag*	FLD_3D_ANM_MNG_PTR;
typedef struct FLD_3D_ANIME_DATA_tag*	FLD_3D_ANM_DAT_PTR;
typedef struct FLD_3D_ANIME_DATA_tag const *	FLD_3D_ANM_DAT_CONST_PTR;
///typedef struct ANIME_3D_WORK_tag*	ANIME_3D_WORK_PTR;

typedef struct ANIME_CONT_MNG_tag*	ANIME_CONT_MNG_PTR;
typedef struct ANIME_CONT_tag*	ANIME_CONT_PTR;

extern int F3DA_GetFld3DAnimeCode(	const int inFld3DObjCode,
									const int inAnimeNo/*, const struct list*/);

extern FLD_3D_ANM_MNG_PTR F3DA_Field3DAnimeInit(void);
extern FLD_3D_ANM_DAT_PTR	F3DA_AddField3DAnime(	const int inObjCode,
													const int inAnimeNo,
													const int inLoopCount,
													const int inCode,
													const BOOL inReverse,
													const BOOL inStopFlg,
													const BOOL inConditional,
													NNSG3dResMdl *objectmodel,
													NNSG3dResTex	*pTex,
													FLD_3D_ANM_MNG_PTR field_3d_anime_ptr	);
extern void F3DA_AddField3DAnimeEasy(	const int inObjCode,
										NNSG3dResMdl *objectmodel,
										NNSG3dResTex	*pTex,
										FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
extern BOOL F3DA_SetFld3DAnime(	const int inObjID,
								const int inAnimeNo,
								const BOOL inConditional,
								NNSG3dRenderObj *objectdata,
								FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
extern void RereaseFld3DAnimeAll(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
extern void F3DA_RemoveFld3DAnime(	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
									NNSG3dRenderObj *inRenderObj,
									const int inObjCode,
									const int inAnimeNo	);
extern void FreeFld3DAnimeManager(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
//extern int GetFld3DAnimationType(const int inFld3DObjCode/*, const struct list*/);
//extern void Field3DAnimeMain(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
extern void F3DA_Main(FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
///extern BOOL F3DA_CheckDoor( FIELDSYS_WORK * fsys );

extern FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtrByCode(const int inCode,
													FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
extern FLD_3D_ANM_DAT_PTR F3DA_GetFld3DAnmPtrByAnimeCode(	const int inAnimeCode,
															FLD_3D_ANM_MNG_PTR field_3d_anime_ptr);
extern void F3DA_SetStopFlg(FLD_3D_ANM_DAT_PTR inAnimePtr, const BOOL inFlg);
extern void F3DA_MoveAnime(FLD_3D_ANM_DAT_PTR inAnimePtr);
extern BOOL F3DA_IsAnimeEnd(const FLD_3D_ANM_DAT_PTR inAnimeData);

extern void F3DA_SetAnimeReverse(FLD_3D_ANM_DAT_PTR	outAnimeData);
extern void F3DA_SetAnimeReverseDirect(FLD_3D_ANM_DAT_PTR	outAnimeData, const BOOL inReverse);
extern void F3DA_SetAnimeLoopMax(FLD_3D_ANM_DAT_PTR	outAnimeData, const int inLoopMax);
extern void F3DA_SetControlCode(FLD_3D_ANM_DAT_PTR	outAnimeData, const int inControlCode);
extern void F3DA_SetStartFrame(FLD_3D_ANM_DAT_PTR	outAnimeData);
extern void F3DA_SetLastFrame(FLD_3D_ANM_DAT_PTR	outAnimeData);

extern ANIME_CONT_MNG_PTR F3DASub_InitField3DAnimeCont(void);
extern void F3DASub_FreeAnimeContManager(ANIME_CONT_MNG_PTR *outAnimeContMng);

extern void F3DASub_SetUpAnimation(	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
									const ANIME_CONT_MNG_PTR inAnimeContMng,
									const int inEntryID,
									const int inObjID,
									NNSG3dRenderObj *inRenderObj,
									NNSG3dResMdl 	*inObjectModel,
									NNSG3dResTex *inTex,
									const int inAnimeNum,
									const BOOL inReverse);

extern void F3DASub_StartAnimation(	const ANIME_CONT_MNG_PTR inAnimeContMng,
									const int inEntryID,
									const int inAnimeNo);

extern void F3DASub_StartAnimeSnd(	const ANIME_CONT_MNG_PTR inAnimeContMng,
									const int inEntryID,
									const int inAnimeNo,
									const int inSound);

extern void F3DASub_RereaseAnimation(	FLD_3D_ANM_MNG_PTR field_3d_anime_ptr,
										ANIME_CONT_MNG_PTR inAnimeContMng,
										const int inEntryID	);

extern FLD_3D_ANM_DAT_PTR F3DASub_GetFld3DAnmPtr(	const ANIME_CONT_MNG_PTR inAnimeContMng,
													const int inEntryID,
													const int inAnimeNo	);

extern const BOOL F3DASub_WaitAnimation(const ANIME_CONT_MNG_PTR inAnimeContMng,
										const int inEntryID);
extern const int F3DASub_GetObjIDFromEntryID(	const ANIME_CONT_MNG_PTR inAnimeContMng,
												const int inEntryID);
#endif //_FIELD_3D_ANIME_H_


