//============================================================================================
/**
 * @file	field_3d_anime_ev.c
 * @brief	Cxgp3DAj֘At@C
 * @author	Nozomu Saito
 * @date	2006.01.26
 */
//============================================================================================
#include "common.h"

#include "field_3d_anime.h"
#include "fieldsys.h"
#include "field_event.h"

#include "map_tool.h"
#include "system/snd_tool.h"	//for SE

#include "field_3d_anime_ev.h"
#include "field_3d_anime_def.h"

#include "mapresource.h"		//for texture

#include "fieldmap.h"		//for FieldFadeWipeSet

#define DOOR_ANIME_ENTRY_ID	(1)
#define ESCA_ANIME_ENTRY_ID	(2)

#define ANM_CAM_ZOOM	(12)
#define ANM_CAM_ZOOM_OUT	(16)

#define	ZOOM_VAL	(96)

typedef struct FLD_3D_ANIME_WORK_tag{
	int seq;
	TARGET_RECT TargetRect;
	int GridX;
	int GridZ;
	u8 EntryID;
	u8 CameraZoomCount;
	BOOL CameraZoomStartFlg;
	u16 PerspWayWork;
}FLD_3D_ANIME_WORK;

static void AnimeCameraZoomIn(GF_CAMERA_PTR camera_ptr, u8 *ioCount);
static void AnimeCameraZoomOut(GF_CAMERA_PTR camera_ptr,  u8 *ioCount);
//==============================================================================
/**
 * Cxgp3DAj\̃AP[V
 * 
 * @param	none
 *
 * @retval  FLD_3D_ANIME_WORK_PTR	CxgAj[V[N|C^
 */
//==============================================================================
FLD_3D_ANIME_WORK_PTR	Fld3DAnm_AllocEvent3DAnimeWork(void)
{
	FLD_3D_ANIME_WORK_PTR anime_3d_work_ptr;
	anime_3d_work_ptr = sys_AllocMemoryLo( HEAPID_FIELD, sizeof(FLD_3D_ANIME_WORK) );
	anime_3d_work_ptr->seq = 0;
	return anime_3d_work_ptr;
}

//==============================================================================
/**
 * Cxgp3DAj\̉
 * 
 * @param	outAnime3DWorkPtr	CxgAj[V[N|C^
 *
 * @retval  none
 */
//==============================================================================
void Fld3DAnm_FreeEvent3DAnimeWork(FLD_3D_ANIME_WORK_PTR outAnime3DWorkPtr)
{
	sys_FreeMemoryEz(outAnime3DWorkPtr);
}

//==============================================================================
/**
 * Cxgp3DAjΏۍWZbg
 * 
 * @param	inGridX				[hObhXW
 * @param	inGridZ				[hObhZW
 * @param	outAnime3DWorkPtr	CxgAj[V[N|C^
 *
 * @retval  none
 */
//==============================================================================
void Fld3DAnm_EventSetGrid(	const int inGridX, const int inGridZ,
							FLD_3D_ANIME_WORK_PTR outAnime3DWorkPtr)
{
	outAnime3DWorkPtr->GridX = inGridX;
	outAnime3DWorkPtr->GridZ = inGridZ;
}

//==============================================================================
/**
 * hAAjCxg()
 * 
 * @param	fsys	tB[hVXe|C^
 * @param	work	CxgAj[V[N|C^
 *
 * @retval  BOOL	TRUE:CxgI@FALSEFCxgp
 */
//==============================================================================
BOOL Fld3DAnm_EventDoorInAnime(FIELDSYS_WORK * fsys, FLD_3D_ANIME_WORK_PTR work)
{
	FIELD_OBJ_PTR fop;

	switch (work->seq) {
	case 0:
		{
			BOOL rc;
			M3DO_PTR obj_ptr;
			TARGET_RECT rect;
			int obj_id;
			int list[] = {BMID_DOOR01,BMID_T1_DOOR1,BMID_T2_DOOR1,BMID_T2_DOOR2,
							BMID_P_DOOR, BMID_GYM_DOOR01};
			
			OS_Printf("Aj\n");
			
			//JY[
			work->CameraZoomStartFlg = FALSE;
			work->CameraZoomCount = 0;
		
			MPTL_MakeTargetRect( work->GridX, work->GridZ, -1, -1, 3, 1, &rect );

			//o^R[hݒ
			work->EntryID = DOOR_ANIME_ENTRY_ID;
			
			rc = MPTL_CheckPluralMap3DObjInRect(fsys,
												list,
												/*NELEMS(list)*/6,//<<`߂łƂ܂̂ŒlĂ
												&rect,
												&obj_ptr,
												&obj_id);

			if (rc){
				u8 no;
				u8 anime_num;
				NNSG3dResTex *tex;

				if (obj_id == BMID_P_DOOR){	//hÂƂ
					anime_num = 2;			//ZbgAjQiJAj
				}else{						//ȊO
					anime_num = 4;			//ZbgAjSiJAAOoJAOoj
				}
				tex = GetMapResourceBmTexturePTR(fsys->MapResource);

				F3DASub_SetUpAnimation(	fsys->field_3d_anime,
										fsys->AnimeContMng,
										DOOR_ANIME_ENTRY_ID,
										obj_id,
										M3DO_GetRenderObj(obj_ptr),
										M3DO_GetObjModel(obj_ptr),
										tex,anime_num,
										FALSE);
			}else{
				OS_Printf("hAȂł\n");
				return TRUE;	//hAȂ
			}//end if
			(work->seq) ++;
		}
		
		break;
	
	case 1:
		//JY[Jn
		work->CameraZoomStartFlg = TRUE;
		{
			int obj_id;
			int sound;
			int anime_no;
			obj_id = F3DASub_GetObjIDFromEntryID(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
			if (obj_id == P_DOOR_TYPE1_CODE){
				//SEZbg
				sound = SE_JIDO_DOOR_OPEN;	//hAJ
				anime_no = ANIME_NO_DOOR_AUTO_OPEN;
			}else{
				//SEZbg
				sound = SE_DOOR_OPEN;		//hAJ
				anime_no = ANIME_NO_DOOR_OPEN_IN;
			}
			F3DASub_StartAnimeSnd(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID, anime_no, sound);	//hAJAj
		}
		(work->seq) ++;
		break;
	case 2:
		{
			BOOL wait;
			wait = F3DASub_WaitAnimation(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
			//JAjI҂
			if (wait) {
				OS_Printf("JAjXgbv\n");
				(work->seq) ++;
			}
		}
		break;
	case 3:
		fop = Player_FieldOBJGet( fsys->player );
#if 0		
		if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
			FieldOBJ_AcmdSet(fop,AC_WALK_U_32F);	//oBCӂ̃AjZbg
		}else{
			GF_ASSERT(0&&"Ajo^łȂ");
		}
#else
		//hAAj̏ꍇɌAjo^`FbNsȂĂ悢ihA͕ǂɂȂĂāAObh̃YȂ߁j
		FieldOBJ_AcmdSet(fop,AC_WALK_U_8F);	//AjZbg	
#endif
		(work->seq) ++;
		break;
	case 4:
		fop = Player_FieldOBJGet( fsys->player );
		
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI

			//@
			FieldOBJ_StatusBitSet_Vanish( fop, TRUE );
			{
				int obj_id;
				int sound;
				int anime_no;
				obj_id = F3DASub_GetObjIDFromEntryID(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
				if (obj_id == P_DOOR_TYPE1_CODE){
					//SEZbg
					sound = SE_JIDO_DOOR_CLOSE;	//hA
					anime_no = ANIME_NO_DOOR_AUTO_CLOSE;
				}else{
					//SEZbg
					sound = SE_DOOR_CLOSE;		//hA
					anime_no = ANIME_NO_DOOR_CLOSE_IN;
				}
				F3DASub_StartAnimeSnd(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID, anime_no, sound);	//hAAj
			}
			(work->seq) ++;
		}
		break;
	case 5:
		{
			BOOL wait;
			wait = F3DASub_WaitAnimation(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
			//AjI҂
			if (wait) {
				F3DASub_RereaseAnimation(	fsys->field_3d_anime,
											fsys->AnimeContMng,
											DOOR_ANIME_ENTRY_ID	);
				OS_Printf("AjI\n");
				return TRUE;
			}
		}
		break;
	}
	if (work->CameraZoomStartFlg){
		//JY[C
		AnimeCameraZoomIn(fsys->camera_ptr, &work->CameraZoomCount);
	}
	return FALSE;	
}

//==============================================================================
/**
 * hAAjCxg(o)
 * 
 * @param	fsys	tB[hVXe|C^
 * @param	work	CxgAj[V[N|C^
 *
 * @retval  BOOL	TRUE:CxgI@FALSEFCxgp
 */
//==============================================================================
BOOL Fld3DAnm_EventDoorOutAnime(FIELDSYS_WORK * fsys, FLD_3D_ANIME_WORK_PTR work)
{
	FIELD_OBJ_PTR fop;

	switch (work->seq) {
	case 0:
		{
			BOOL rc;
			M3DO_PTR obj_ptr;
			TARGET_RECT rect;
			int obj_id;
			int list[] = {BMID_DOOR01,BMID_T1_DOOR1,BMID_T2_DOOR1,BMID_T2_DOOR2,
				BMID_P_DOOR, BMID_GYM_DOOR01};
			OS_Printf("Aj\n");

			//JY[
			work->CameraZoomStartFlg = FALSE;
			work->CameraZoomCount = 0;	
			
			MPTL_MakeTargetRect( work->GridX, work->GridZ, -1, 0, 3, 1, &rect );
			//o^R[hݒ
			work->EntryID = DOOR_ANIME_ENTRY_ID;
			
			rc = MPTL_CheckPluralMap3DObjInRect(fsys,
												list,
												/*NELEMS(list)*/6,//<<`߂łƂ܂̂ŒlĂ
												&rect,
												&obj_ptr,
												&obj_id);

			if (rc){
				u8 no;
				u8 anime_num;
				NNSG3dResTex *tex;
				if (obj_id == BMID_P_DOOR){	//hÂƂ
					anime_num = 2;			//ZbgAjQiJAj
				}else{						//ȊO
					anime_num = 4;			//ZbgAjSiJAAOoJAOoj
				}
				tex = GetMapResourceBmTexturePTR(fsys->MapResource);
				F3DASub_SetUpAnimation(	fsys->field_3d_anime,
										fsys->AnimeContMng,
										DOOR_ANIME_ENTRY_ID,
										obj_id,
										M3DO_GetRenderObj(obj_ptr),
										M3DO_GetObjModel(obj_ptr),
										tex,anime_num,
										FALSE);
			}else{
				//Ă쌴ς񂾂AAT[VXgbv
				OS_Printf("hAȂł\n");
				//GF_ASSERT(0&&"hAȂł");
				//tF[hCJn
				///FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
				FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKIN, fsys);
				(work->seq)  = 6;
				return FALSE;
			}//end if
			
			//J̃Y[ZbgȂ
			{
				//p[X̕ۑ
				work->PerspWayWork = GFC_GetCameraPerspWay(fsys->camera_ptr);
				//p[X
				GFC_AddCameraPerspWay(-(ZOOM_VAL),fsys->camera_ptr);	
			}
			(work->seq) ++;
		}
		break;
	case 1:
		//tF[hCJn
		///FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
		FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKIN, fsys);
		work->CameraZoomStartFlg = TRUE;	//Y[Jn
		
		{
			int obj_id;
			int sound;
			int anime_no;
			obj_id = F3DASub_GetObjIDFromEntryID(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
			if (obj_id == P_DOOR_TYPE1_CODE){
				//SEZbg
				sound = SE_JIDO_DOOR_OPEN;	//hAJ
				anime_no = ANIME_NO_DOOR_AUTO_OPEN;
			}else{
				//SEZbg
				sound = SE_DOOR_OPEN;		//hAJiOoj
				anime_no = ANIME_NO_DOOR_OPEN_OUT;
			}
			F3DASub_StartAnimeSnd(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID, anime_no, sound);	//hAJAj
		}
		
		(work->seq) ++;
		break;
	case 2:
		{
			BOOL wait;
			wait = F3DASub_WaitAnimation(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
			//JAjI҂
			if (wait) {
				OS_Printf("JAjXgbv\n");
				fop = Player_FieldOBJGet( fsys->player );
				//@\
				FieldOBJ_StatusBitSet_Vanish( fop, FALSE );
				(work->seq) ++;
			}
		}
		break;
	case 3:
		fop = Player_FieldOBJGet( fsys->player );
#if 0			
		if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
			FieldOBJ_AcmdSet(fop,AC_WALK_D_32F);	//oBCӂ̃AjZbg
		}else{
			GF_ASSERT(0&&"Ajo^łȂ");
		}
#else
		//hAAj̏ꍇɌAjo^`FbNsȂĂ悢ihA͕ǂɂȂĂāAObh̃YȂ߁j
		FieldOBJ_AcmdSet(fop,AC_WALK_D_8F);	//AjZbg	
#endif
		(work->seq) ++;
		break;
	case 4:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI
			{
				int obj_id;
				int sound;
				int anime_no;
				obj_id = F3DASub_GetObjIDFromEntryID(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
				if (obj_id == P_DOOR_TYPE1_CODE){
					//SEZbg
					sound = SE_JIDO_DOOR_CLOSE;	//hA
					anime_no = ANIME_NO_DOOR_AUTO_CLOSE;
				}else{
					//SEZbg
					sound = SE_DOOR_CLOSE;		//hA(Oo)
					anime_no = ANIME_NO_DOOR_CLOSE_OUT;
				}
				F3DASub_StartAnimeSnd(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID, anime_no, sound);	//hAAj
			}
			(work->seq) ++;
		}
		break;
	case 5:
		{
			BOOL wait;
			wait = F3DASub_WaitAnimation(fsys->AnimeContMng, DOOR_ANIME_ENTRY_ID);
			//AjIAubNAEgIAY[I҂
			if (wait&&IsFinishedFieldFadeWipe(fsys)&&
					(work->PerspWayWork == GFC_GetCameraPerspWay(fsys->camera_ptr))) {
				
				F3DASub_RereaseAnimation(	fsys->field_3d_anime,
											fsys->AnimeContMng,
											DOOR_ANIME_ENTRY_ID	);
				OS_Printf("AjI\n");
				return TRUE;
			}
		}
		break;
	case 6:	//hAȂƂpV[PX
		if (IsFinishedFieldFadeWipe(fsys)){
			return TRUE;
		}
		break;
	}
	if (work->CameraZoomStartFlg){
		AnimeCameraZoomOut(fsys->camera_ptr, &work->CameraZoomCount);		//Y[AEg
	}
	return FALSE;
}

//==============================================================================
/**
 * hAAjƘAJ(Y[C)
 * 
 * @param	camera_ptr		J|C^
 * @param	ioCoint			JY[JE^
 *
 * @retval  none
 */
//==============================================================================
static void AnimeCameraZoomIn(GF_CAMERA_PTR camera_ptr, u8 *ioCount)
{
	u8 sp;
	u16 zoom;
	if ( (*ioCount)*ANM_CAM_ZOOM>= ZOOM_VAL ){
		return;
	}
	zoom = (*ioCount)*ANM_CAM_ZOOM;
	if (zoom>ZOOM_VAL){
		sp = zoom-ZOOM_VAL;
	}else{
		sp = ANM_CAM_ZOOM;
	}
	
	{
		u16 persp_way;
		persp_way = GFC_GetCameraPerspWay(camera_ptr);
		if ((u16)(persp_way-sp)>0x0000){
			GFC_AddCameraPerspWay(-sp,camera_ptr);
		}
		(*ioCount)++;
	}
}

//==============================================================================
/**
 * hAAjƘAJ(Y[AEg)
 * 
 * @param	camera_ptr		J|C^
 * @param	ioCoint			JY[JE^
 *
 * @retval  none
 */
//==============================================================================
static void AnimeCameraZoomOut(GF_CAMERA_PTR camera_ptr, u8 *ioCount)
{
	u8 sp;
	u16 zoom;
	if ( (*ioCount)*ANM_CAM_ZOOM_OUT>= ZOOM_VAL ){
		return;
	}
	zoom = (*ioCount)*ANM_CAM_ZOOM_OUT;
	if (zoom>ZOOM_VAL){
		sp = zoom-ZOOM_VAL;
	}else{
		sp = ANM_CAM_ZOOM_OUT;
	}

	{
		u16 persp_way;
		persp_way = GFC_GetCameraPerspWay(camera_ptr);
		if ((u16)(persp_way+sp)>0x0000){
			GFC_AddCameraPerspWay(sp,camera_ptr);
		}
		(*ioCount)++;
	}
}

//==============================================================================
/**
 * GXJ[^[̂ڂ1
 * 
 * @param	fsys	tB[hVXe|C^
 * @param	work	CxgAj[V[N|C^
 *
 * @retval  BOOL	TRUE:CxgI@FALSEFCxgp
 */
//==============================================================================
FLD_3D_ANIME_WORK	EscaWork;
void DebugInitEsca(void)
{
	EscaWork.seq = 0;
}

BOOL Fld3DAnm_EventEscalatorAnime(FIELDSYS_WORK * fsys, FLD_3D_ANIME_WORK_PTR work)
{
	FIELD_OBJ_PTR fop;
	switch (work->seq) {
	case 0:
		{
			BOOL rc;
			M3DO_PTR obj_ptr;
			TARGET_RECT rect;
			int obj_id;
			int list[] = {BMID_STAIR_PC_D01,BMID_STAIR_PC_U01};
			
			OS_Printf("GXJ[^[Aj\n");
			MPTL_MakeTargetRect(work->GridX,work->GridZ,-1, 0, 2, 1, &rect );

			//o^R[hݒ
			work->EntryID = ESCA_ANIME_ENTRY_ID;
			
			rc = MPTL_CheckPluralMap3DObjInRect(fsys,
												list,
												/*NELEMS(list)*/2,//<<`߂łƂ܂̂ŒlĂ
												&rect,
												&obj_ptr,
												&obj_id);

			if (rc){
				u8 no;
				NNSG3dResTex *tex;
				tex = GetMapResourceBmTexturePTR(fsys->MapResource);
				F3DASub_SetUpAnimation(	fsys->field_3d_anime,
										fsys->AnimeContMng,
										ESCA_ANIME_ENTRY_ID,
										obj_id,
										M3DO_GetRenderObj(obj_ptr),
										M3DO_GetObjModel(obj_ptr),
										tex, 1,	//ZbgAjP
										FALSE);
			}else{
				GF_ASSERT(0&&"GXJ[^[Ȃ");
			}//end if
			
			fop = Player_FieldOBJGet( fsys->player );
			if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
				FieldOBJ_AcmdSet(fop,AC_ANM_PAUSE_ON);	//oB|[Y
			}else{
				GF_ASSERT(0&&"Ajo^łȂ");
			}
			(work->seq) ++;
		}
		break;
	case 1:
		F3DASub_StartAnimeSnd(fsys->AnimeContMng, ESCA_ANIME_ENTRY_ID, ANIME_NO_ESCA, SEQ_SE_DP_ESUKA);	//GXJ[^[Aj
		fop = Player_FieldOBJGet( fsys->player );
		
		if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
			FieldOBJ_AcmdSet(fop,AC_WALK_L_16F);	//oBCӂ̃AjZbg
		}else{
			GF_ASSERT(0&&"Ajo^łȂ");
		}
		(work->seq) ++;
		break;
	case 2:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
			FieldOBJ_AcmdSet(fop,AC_ANM_PAUSE_OFF);	//oB|[Y
			//tF[hAEgJn
			///FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKOUT );
			FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKOUT, fsys);
			(work->seq) ++;
		}
		break;
	case 3:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI	
			(work->seq) ++;
		}
		break;
	case 4:
		{
			BOOL wait;
			wait = F3DASub_WaitAnimation(fsys->AnimeContMng, ESCA_ANIME_ENTRY_ID);
			//GXJ[^[AjIAubNAEgI҂
			if (wait&&IsFinishedFieldFadeWipe(fsys)) {
				F3DASub_RereaseAnimation(	fsys->field_3d_anime,
											fsys->AnimeContMng,
											ESCA_ANIME_ENTRY_ID	);
				OS_Printf("GXJ[^[AjI\n");
				return TRUE;
			}
		}
		break;
	}
	return FALSE;
}

//==============================================================================
/**
 * GXJ[^[(㉺֌WA@Eֈړ)
 * 
 * @param	fsys	tB[hVXe|C^
 * @param	work	CxgAj[V[N|C^
 *
 * @retval  BOOL	TRUE:CxgI@FALSEFCxgp
 */
//==============================================================================
BOOL Fld3DAnm_EventEscalatorAnimeR(FIELDSYS_WORK * fsys, FLD_3D_ANIME_WORK_PTR work)
{
	FIELD_OBJ_PTR fop;
	switch (work->seq) {
	case 0:
		{
			BOOL rc;
			M3DO_PTR obj_ptr;
			TARGET_RECT rect;
			int obj_id;
			int list[] = {BMID_STAIR_PC_D01,BMID_STAIR_PC_U01};
			
			OS_Printf("GXJ[^[Aj\n");
			MPTL_MakeTargetRect(work->GridX,work->GridZ,0, 0, 2, 1, &rect );

			//o^R[hݒ
			work->EntryID = ESCA_ANIME_ENTRY_ID;
			
			rc = MPTL_CheckPluralMap3DObjInRect(fsys,
												list,
												/*NELEMS(list)*/2,//<<`߂łƂ܂̂ŒlĂ
												&rect,
												&obj_ptr,
												&obj_id);

			if (rc){
				u8 no;
				NNSG3dResTex *tex;
				tex = GetMapResourceBmTexturePTR(fsys->MapResource);
				F3DASub_SetUpAnimation(	fsys->field_3d_anime,
										fsys->AnimeContMng,
										ESCA_ANIME_ENTRY_ID,
										obj_id,
										M3DO_GetRenderObj(obj_ptr),
										M3DO_GetObjModel(obj_ptr),
										tex, 1, //ZbgAjP
										TRUE);	//t
			}else{
				GF_ASSERT(0&&"GXJ[^[Ȃ");
			}//end if
			
			fop = Player_FieldOBJGet( fsys->player );
			if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
				FieldOBJ_AcmdSet(fop,AC_ANM_PAUSE_ON);	//oB|[Y
			}else{
				GF_ASSERT(0&&"Ajo^łȂ");
			}
			(work->seq) ++;
		}
		break;
	case 1:
		//tF[hCJn
		///FieldBrightnessFadeSet( FLD_DISP_BRIGHT_BLACKIN );
		FieldFadeWipeSet(FLD_DISP_BRIGHT_BLACKIN, fsys);
		
		F3DASub_StartAnimeSnd(fsys->AnimeContMng, ESCA_ANIME_ENTRY_ID, ANIME_NO_ESCA, SEQ_SE_DP_ESUKA);	//GXJ[^[Aj
		fop = Player_FieldOBJGet( fsys->player );
		
		if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
			FieldOBJ_AcmdSet(fop,AC_WALK_R_16F);	//oBCӂ̃AjZbg
		}else{
			GF_ASSERT(0&&"Ajo^łȂ");
		}
		(work->seq) ++;
		break;
	case 2:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
			FieldOBJ_AcmdSet(fop,AC_ANM_PAUSE_OFF);	//oB|[Y
			(work->seq) ++;
		}
		break;
	case 3:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdSetCheck(fop) == TRUE ){	//AjZbgł邩?
			FieldOBJ_AcmdSet(fop,AC_WALK_R_16F);	//oBPEɕ
			(work->seq) ++;
		}
		break;
	case 4:
		fop = Player_FieldOBJGet( fsys->player );
		if( FieldOBJ_AcmdEndCheck(fop) == TRUE ){	//AjI`FbN
			FieldOBJ_AcmdEnd(fop); //AjI	
			(work->seq) ++;
		}
		break;
	case 5:
		{
			BOOL wait;
			wait = F3DASub_WaitAnimation(fsys->AnimeContMng, ESCA_ANIME_ENTRY_ID);
			//GXJ[^[AjIAubNCI҂
			if (wait&&IsFinishedFieldFadeWipe(fsys)) {
				F3DASub_RereaseAnimation(	fsys->field_3d_anime,
											fsys->AnimeContMng,
											ESCA_ANIME_ENTRY_ID	);
				OS_Printf("GXJ[^[AjI\n");
				return TRUE;
			}
		}
		break;
	}
	return FALSE;
}


//==============================================================================
//
//	XNvgp֐Q
//
//==============================================================================


//==============================================================================
/**
 * Aj҂
 * 
 * @param	event	Cxg|C^
 *
 * @retval  BOOL	TRUE:CxgI@FALSEFCxgp
 */
//==============================================================================
static BOOL WaitAnime(GMEVENT_CONTROL * event)
{
	BOOL wait;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	u8 *entry  = FieldEvent_GetSpecialWork(event);
	wait = F3DASub_WaitAnimation(fsys->AnimeContMng, *entry);
	//JAjI҂
	if (wait) {
		sys_FreeMemoryEz(entry);
		return TRUE;
	}
	return FALSE;
}

//==============================================================================
/**
 * hAAj[ṼZbgAbv
 * 
 * @param	fsys		tB[hVXe|C^
 * @param	inGridX		ObhXW
 * @param	inGridZ		ObhZW
 * @param	inEntryID	o^ID
 *
 * @retval  none
 */
//==============================================================================
void FLD_SCR_ANM_DOOR_Setup(FIELDSYS_WORK * fsys,
						const int inGridX, const int inGridZ, const u8 inEntryID)
{
	BOOL rc;
	M3DO_PTR obj_ptr;
	TARGET_RECT rect;
	int obj_id;
	int list[] = {BMID_DOOR01,BMID_T1_DOOR1,BMID_T2_DOOR1,BMID_T2_DOOR2,
		BMID_P_DOOR, BMID_GYM_DOOR01};
			
	MPTL_MakeTargetRect( inGridX, inGridZ, -1, 0, 3, 1, &rect );

	rc = MPTL_CheckPluralMap3DObjInRect(fsys,
										list,
										/*NELEMS(list)*/6,//<<`߂łƂ܂̂ŒlĂ
										&rect,
										&obj_ptr,
										&obj_id);

	if (rc){
		u8 no;
		u8 anime_num;
		NNSG3dResTex *tex;
		if (obj_id == BMID_P_DOOR){	//hÂƂ
			anime_num = 2;			//ZbgAjQiJAj
		}else{						//ȊO
			anime_num = 4;			//ZbgAjSiJAAOoJAOoj
		}
		tex = GetMapResourceBmTexturePTR(fsys->MapResource);
		F3DASub_SetUpAnimation(	fsys->field_3d_anime,
								fsys->AnimeContMng,
								inEntryID,
								obj_id,
								M3DO_GetRenderObj(obj_ptr),
								M3DO_GetObjModel(obj_ptr),
								tex,anime_num,	
								FALSE);
	}else{
		OS_Printf("%d,%d\n",inGridX,inGridZ);
		GF_ASSERT(0&&"hA܂");
	}
}

//==============================================================================
/**
 * hAAj[V(I[v)
 * 
 * @param	fsys		tB[hVXe|C^
 * @param	inEntryID	o^ID
 *
 * @retval  none
 */
//==============================================================================
void FLD_SCR_ANM_DOOR_StartOpenDoorAnm(	FIELDSYS_WORK * fsys, const u8 inEntryID	)
{
	int obj_id;
	int sound;
	int anime_no;
	obj_id = F3DASub_GetObjIDFromEntryID(fsys->AnimeContMng, inEntryID);
	if (obj_id == P_DOOR_TYPE1_CODE){
		//SEZbg
		sound = SE_JIDO_DOOR_OPEN;	//hAJ
		anime_no = ANIME_NO_DOOR_AUTO_OPEN;
	}else{
		//SEZbg
		sound = SE_DOOR_OPEN;		//hAJ
		anime_no = ANIME_NO_DOOR_OPEN_IN;
	}
	F3DASub_StartAnimeSnd(fsys->AnimeContMng, inEntryID, anime_no, sound);	//hAJAj
}

//==============================================================================
/**
 * hAAj[V(N[Y)
 * 
 * @param	fsys		tB[hVXe|C^
 * @param	inEntryID	o^ID
 *
 * @retval  none
 */
//==============================================================================
void FLD_SCR_ANM_DOOR_StartCloseDoorAnm(	FIELDSYS_WORK * fsys, const u8 inEntryID	)
{
	int obj_id;
	int sound;
	int anime_no;
	obj_id = F3DASub_GetObjIDFromEntryID(fsys->AnimeContMng, inEntryID);
	if (obj_id == P_DOOR_TYPE1_CODE){
		//SEZbg
		sound = SE_JIDO_DOOR_CLOSE;	//hA
		anime_no = ANIME_NO_DOOR_AUTO_CLOSE;
	}else{
		//SEZbg
		sound = SE_DOOR_CLOSE;		//hA
		anime_no = ANIME_NO_DOOR_CLOSE_IN;
	}
	F3DASub_StartAnimeSnd(fsys->AnimeContMng, inEntryID, anime_no, SE_DOOR_CLOSE);	//hAAj
}

//==============================================================================
/**
 * Aj[V҂
 * 
 * @param	fsys		tB[hVXe|C^
 * @param	inEntryID	o^ID
 *
 * @retval  none
 */
//==============================================================================
void FLD_SCR_ANM_DOOR_WaitAnime(FIELDSYS_WORK * fsys, const u8 inEntryID)
{
	u8 *entry = sys_AllocMemoryLo(HEAPID_FIELD, sizeof(u8));
	*entry = inEntryID;
	FieldEvent_Call(fsys->event, WaitAnime, entry);
}

//==============================================================================
/**
 * hAAj[V
 * 
 * @param	fsys		tB[hVXe|C^
 * @param	inEntryID	o^ID
 *
 * @retval  none
 */
//==============================================================================
void FLD_SCR_ANM_DOOR_FreeDoor(FIELDSYS_WORK * fsys, const u8 inEntryID)
{
	F3DASub_RereaseAnimation(	fsys->field_3d_anime,
								fsys->AnimeContMng,
								inEntryID	);
}

//==============================================================================
/**
 * Aj[ṼX^[g
 * 
 * @param	inGridX		ObhXW
 * @param	inGridZ		ObhZW
 * @param	inAnmNo		Ajio[	0F@1F
 * @param	fsys		tB[hVXe|C^
 *
 * @retval  none
 */
//==============================================================================
void Fld3DAnm_StartQuickSandAnime(	const int inGridX,
									const int inGridZ,
									const int inAnmNo,
									FIELDSYS_WORK * fsys)
{

	BOOL rc;
	M3DO_PTR obj_ptr;
	TARGET_RECT rect;
	int obj_id;
	int list[] = {BMID_CY_SLOPE, BMID_CY_SLOPE_DUN};
		
	//͈͍쐬
	MPTL_MakeTargetRect( inGridX, inGridZ, 0, -1, 1, 3, &rect );
	//OBJ擾
/**
	rc = MPTL_CheckMap3DObjInRect(	fsys,
									BMID_CY_SLOPE,
									&rect,
									&obj_ptr);
*/									
	rc = MPTL_CheckPluralMap3DObjInRect(fsys,
										list,
										NELEMS(list),
										&rect,
										&obj_ptr,
										&obj_id);
	GF_ASSERT(rc&&"Ȃ");
	
	//AjZbg
	{
		NNSG3dRenderObj *render_obj;
		render_obj = M3DO_GetRenderObj(obj_ptr);
		rc =	F3DA_SetFld3DAnime(	obj_id, inAnmNo, TRUE,
									render_obj,
									fsys->field_3d_anime );
		GF_ASSERT(rc&&"Zbgs");
	}
	{
		FLD_3D_ANM_DAT_PTR anime;
		int anime_code;
		//AjR[h擾
		anime_code = F3DA_GetFld3DAnimeCode(obj_id, inAnmNo);
		anime = F3DA_GetFld3DAnmPtrByAnimeCode(	anime_code,
												fsys->field_3d_anime);
		//AjJn
		F3DA_SetStartFrame(anime);
		F3DA_SetStopFlg(anime, FALSE);
		F3DA_MoveAnime(anime);
	}
}

BOOL GMEVENT_DebugEscaMapChange(GMEVENT_CONTROL * event)
{
	BOOL rc;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	int * seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		DebugInitEsca();
		(*seq) ++;
		break;
	case 1:
		rc = Fld3DAnm_EventEscalatorAnime(fsys,NULL);
		if (rc){
			(*seq) ++;
		}
		break;
	case 2:
		return TRUE;
	}
	return FALSE;
}


