//=============================================================================
/**
 * @file	field_anime.c
 * @bfief	tB[hAjiɓ]Aj)
 * @author	mori GAME FREAK inc.
 *
 *
 */
//=============================================================================

#include "common.h"
#include "calctool.h"
#include "str_tool.h"
#include "system/lib_pack.h"
#include "field_anime.h"



//==============================================================================
// `
//==============================================================================
#define FIELD_ANIME_MAX		( 10 )	// n`p]Aj̓

#define FIELD_VRAM_ANIME_MAX	(9)	//tB[hVRAMAj

typedef struct{						// Ajpf[^iROMǂݍ݂܂)
	char name[32];					// eNX`t@C
	u16	 AnmTbl[10][2];				// Ajpe[u[0]:p^[ԍ  [1]:wait
}FIELD_ANIME;

struct _FIELD_ANIME_WORK{
	u8  			*texadr;		// ɓ]ĂeNX`AhX
	int 			texsize;		// ]eNX`TCY
	NNSG3dResTex 	*animetex;		// ]eNX`\[X̃|C^
	void			*texfile;		// eNX`t@C̎
	FIELD_ANIME		*animetbl;		// Aj[V`e[ũ|C^
	u16				point,wait;		// ݂̕\|C^,EFCg
}FIELD_ANIME_WORK;

static const char *FieldVRAMAnime[FIELD_VRAM_ANIME_MAX] = {
	"sea",
	"rhana",
	"asasea",
	"hamabe",
	"asahamabe",
	"t3_fl_b.1",
	"t3_fl_p.1",
	"t3_fl_r.1",
	"t3_fl_y.1",
};

//==============================================================================
// [N
//==============================================================================

//FIELD_ANIME_WORK	FieldAnimeWork[FIELD_ANIME_MAX];


//==============================================================================
// ֐
//==============================================================================

//==============================================================================
/**
 * 
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
FIELD_ANIME_PTR InitFieldAnime(void)
{
	int i;
	FIELD_ANIME_PTR faw=NULL;
	
	faw = sys_AllocMemory(HEAPID_FIELD,sizeof(FIELD_ANIME_WORK)*FIELD_ANIME_MAX);
	
	if(faw!=NULL){
		for(i=0;i<FIELD_ANIME_MAX;i++){
			faw[i].point = 0;
			faw[i].wait  = 0;
			faw[i].texadr  = NULL;
			faw[i].animetex  = NULL;
			faw[i].animetbl  = NULL;
			faw[i].texfile = NULL;
		}
	}
	return faw;
}


//114 892
// 34%


//------------------------------------------------------------------
/**
 * tB[h]Ajo^
 *
 * @param   tex			VRAMɓ]ς݂̃eNX`Ǘ|C^
 * @param   Tindex		̃eNX`̎windex
 * @param   AnimeNo		]seNX`Ajԍiꂪt@CɂȂ)
 *
 * @retval  int 		o^ł0-9 łȂ-1
 */
//------------------------------------------------------------------
int FieldAnimeSets(FIELD_ANIME_PTR faw, NNSG3dResTex *tex)
{
	int i,result=0;
	for (i=0;i<FIELD_VRAM_ANIME_MAX;i++){
		if(FieldAnimeSet(faw, tex, FieldVRAMAnime[i], i)>=0){
			result++;
		}
	}
	return result;
}


//------------------------------------------------------------------
/**
 * tB[h]Ajo^
 *
 * @param   tex			VRAMɓ]ς݂̃eNX`Ǘ|C^
 * @param   Tindex		̃eNX`̎windex
 * @param   AnimeNo		]seNX`Ajԍiꂪt@CɂȂ)
 *
 * @retval  int 		o^ł0-9 łȂ-1
 */
//------------------------------------------------------------------
int 	FieldAnimeSet(FIELD_ANIME_PTR faw, NNSG3dResTex *tex, const char *name, int AnimeNo)
{
	int  no,i;
	char filename[40];
	
	if(faw==NULL){								//mۂĂȂ̂ɌĂ΂Ă邩Ȃ̂
		return -1;
	}

	for(no=0;no<FIELD_ANIME_MAX;no++){				//gpĂȂ[N
		if(faw[no].texfile==NULL){
			break;
		}
	}
	if(no==FIELD_ANIME_MAX || tex==NULL){			//o^MAX ͒n`eNX`NULLo^~
		return -1;
	}


	faw[no].texadr   = GetTexStartVRAMAdrByName(tex,name);	//]ςݒn`eNX`]ΏۂƂȂꏊ擾
	if (faw[no].texadr == NULL){
		return -1;			//eNX`Ȃo^~
	}

	faw[no].texsize  = GetTexByteSizeByName(tex,name);
	
	sprintf(filename,"data/fld_anime%d.bin",AnimeNo);				
	faw[no].animetbl = sys_LoadFile(HEAPID_FIELD,filename);
	
	OS_Printf("field_anime animetbl=%08x\n",faw[no].animetbl);
	
//	OS_Printf("texname=%s\n",FieldAnimeWork[no].animetbl->name);
//	for(i=0;i<10;i++){
//		if(FieldAnimeWork[no].animetbl->AnmTbl[i][0]!=0xffff){
//			OS_Printf("anime[i] = %d, wait = %d\n",FieldAnimeWork[no].animetbl->AnmTbl[i][0],FieldAnimeWork[no].animetbl->AnmTbl[i][1]);
//		}else{
//			break;
//		}
//	}
	
	//]AjeNX`ǂݍ
	faw[no].texfile   = sys_LoadGraphFile(faw[no].animetbl->name,HEAPID_FIELD);
	faw[no].animetex  = NNS_G3dGetTex((NNSG3dResFileHeader*) faw[no].texfile );

	return no;
}



//==============================================================================
/**
 * tB[hpeNX`]Aj풓֐
 *
 * @param   none		
 *
 * @retval  none		
 */
//==============================================================================
void FieldAnimeMain(FIELD_ANIME_PTR faw)
{
	int i;
	
	if(faw==NULL){								//mۂĂȂ̂ɌĂ΂Ă邩Ȃ̂
		return;
	}
	
	for(i=0;i<FIELD_ANIME_MAX;i++){				//gpĂȂ[N
		if(faw[i].texfile==NULL){
			continue;							//ZbgĂȂꍇ̓X[
		}

		//>>add
		if (faw[i].animetbl == NULL){
			continue;
		}
		//<<
		
		if(faw[i].animetbl->AnmTbl[faw[i].point][1] <= faw[i].wait){	//AjXV^C~O̎
			faw[i].wait = 0;						//EFCgNA
			faw[i].point++;						//|Cg{{
			if(faw[i].animetbl->AnmTbl[faw[i].point][0]==0xffff){					//Aj`[܂łĂꍇ̓[v
				faw[i].point = 0;
			}
			AddVramTransferManager(
					NNS_GFD_DST_3D_TEX_VRAM,		//]Zbg
					(u32)faw[i].texadr,
					GetTexStartAdr(faw[i].animetex,faw[i].animetbl->AnmTbl[faw[i].point][0]),
					faw[i].texsize);	
//			OS_Printf("i=%d, point=%d pat=%04x\n",i,faw[i].point,faw[i].animetbl->AnmTbl[faw[i].point][0]);
		}else{
			faw[i].wait++;			//EFCgXV
		}
	}
}



//==============================================================================
/**
 * ʂɃeNX`]Aj
 *
 * @param   no		faw[]̓Y
 *
 * @retval  none	
 */
//==============================================================================
void FieldAnimeRelease(FIELD_ANIME_PTR faw, int no )
{
	// eNX`t@C̉̓LbVɐς܂Ă̂ōsȂ
	

	if(faw==NULL){								//mۂĂȂ̂ɌĂ΂Ă邩Ȃ̂
		return;
	}

	// Aj[V`e[ủ
	if(faw[no].animetbl!=NULL){
//		NNS_FndCheckExpHeap((void*)faw[no].animetbl,NNS_FND_HEAP_ERROR_PRINT);
		sys_FreeMemoryEz(faw[no].animetbl);
		faw[no].animetbl = NULL;
	}
	faw[no].point = 0;	//Ajp[N̏
	faw[no].wait  = 0;
}

//==============================================================================
/**
 * eNX`Aj]VXeI
 *
 * @param   none
 *
 * @retval  none
 */
//==============================================================================
void FieldAnimeAllRelease(FIELD_ANIME_PTR faw)
{
	int i;
	
	if(faw==NULL){								//mۂĂȂ̂ɌĂ΂Ă邩Ȃ̂
		return;
	}	
	
	for(i=0;i<FIELD_ANIME_MAX;i++){
		FieldAnimeRelease( faw, i );
	}
}

//==============================================================================
/**
 * tB[h]AjVXe
 *
 * @param   faw		
 *
 * @retval  none		
 */
//==============================================================================
void ReleaseFieldAnime(FIELD_ANIME_PTR faw)
{
	if(faw!=NULL){
		sys_FreeMemoryEz(faw);
		faw = NULL;
	}
}
