//============================================================================================
/**
 * @file	field_battle.c
 * @brief	tB[h퓬p[^Ȃ
 * @date	2005.12.18
 * @author	tamada	
 *
 * ėpIƎv̂ŁAbattle/battle_param.cɈڍsB
 */
//============================================================================================

#include "common.h"
#include "fieldsys.h"
#include "field_event.h"

#include "field_encount.h"
#include "encount_set.h"

#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"
#include "system/mystatus.h"
#include "itemtool/myitem.h"
#include "system/zukanwork.h"

#include "zonedata.h"			//ZoneData_GetBattleBGID
#include "battle/attr_def.h"

#include "map_attr.h"

static void BattleParam_SetBgGroundID(BATTLE_PARAM * bp, const FIELDSYS_WORK * fsys);
//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	퓬p[^̐
 * @param	heapID			gpq[v̎w
 * @param	fight_type		퓬^Cv̎wibattle/battle_param.hQƁj
 * @return	BATTLE_PARAM	퓬p[^ւ̃|C^
 */
//-----------------------------------------------------------------------------
BATTLE_PARAM * BattleParam_Create(int heapID, u32 fight_type)
{
	int i;
	BATTLE_PARAM *bp;

	bp = sys_AllocMemory(heapID, sizeof(BATTLE_PARAM));

	bp->fight_type = fight_type;
	bp->battle_status_flag = 0;
	bp->win_lose_flag = 0;
	bp->bg_id = BG_ID_BASIC;		//{wiw
	bp->ground_id = GROUND_ID_ALL;	//{nʎw
	for (i = 0; i < CLIENT_MAX; i++) {
		bp->poke_party[i] = PokeParty_AllocPartyWork(heapID);
	}
	for (i = 0; i < CLIENT_MAX; i++) {
		bp->my_status[i] = MyStatus_AllocWork(heapID);
	}
	bp->my_item = MyItem_AllocWork(heapID);

	bp->zw = ZukanWork_AllocWork(heapID);
	return bp;
}

//-----------------------------------------------------------------------------
/**
 * @brief	퓬p[^̍폜
 * @param	bp		퓬p[^ւ̃|C^
 */
//-----------------------------------------------------------------------------
void BattleParam_Delete(BATTLE_PARAM * bp)
{
	int i;
	for (i = 0; i < CLIENT_MAX; i++) {
		GF_ASSERT(bp->poke_party[i] != NULL);
		sys_FreeMemoryEz(bp->poke_party[i]);
	}
	for (i = 0; i < CLIENT_MAX; i++) {
		GF_ASSERT(bp->my_status[i] != NULL);
		sys_FreeMemoryEz(bp->my_status[i]);
	}
	sys_FreeMemoryEz(bp->my_item);
	sys_FreeMemoryEz(bp->zw);

	sys_FreeMemoryEz(bp);
}


//-----------------------------------------------------------------------------
/**
 * @brief	퓬p[^ZbgF|P
 * @param	bp			퓬p[^ւ̃|C^
 * @param	pp			POKEMON_PARAMւ̃|C^
 * @param	client_no	NCAgwiAȂǁj
 */
//-----------------------------------------------------------------------------
void BattleParam_AddPokemon(BATTLE_PARAM * bp, POKEMON_PARAM * pp, int client_no)
{
	int result;
	GF_ASSERT(client_no < CLIENT_MAX);
	result = PokeParty_Add(bp->poke_party[client_no], pp);
	GF_ASSERT_MSG(result, "battle_param[%d] is full\n", client_no);
}

//-----------------------------------------------------------------------------
/**
 * @brief	퓬p[^ZbgFPOKEPARTỸZbg
 * @param	bp			퓬p[^ւ̃|C^
 * @param	my			MYSTATUSւ̃|C^
 * @param	client_no	NCAgwiAȂǁj
 */
//-----------------------------------------------------------------------------
void BattleParam_SetPokeParty(BATTLE_PARAM * bp, const POKEPARTY * party, int client_no)
{
	GF_ASSERT(client_no < CLIENT_MAX);
	PokeParty_Copy(party, bp->poke_party[client_no]);
}

//-----------------------------------------------------------------------------
/**
 * @brief	퓬p[^ZbgFMYSTATUS̃Zbg
 * @param	bp			퓬p[^ւ̃|C^
 * @param	my			MYSTATUSւ̃|C^
 * @param	client_no	NCAgwiAȂǁj
 */
//-----------------------------------------------------------------------------
void BattleParam_SetMyStatus(BATTLE_PARAM * bp, const MYSTATUS * my, int client_no)
{
	GF_ASSERT(client_no < CLIENT_MAX);
	MyStatus_Copy(my, bp->my_status[client_no]);
}

//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	퓬p[^̃ZbgitB[hj
 * @param	bp		퓬p[^ւ̃|C^
 * @param	fsys	Q[䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void BattleParam_SetParamByGameData(BATTLE_PARAM * bp, const FIELDSYS_WORK * fsys)
{
	MYSTATUS * my = SaveData_GetMyStatus(fsys->savedata);
	POKEPARTY * temoti = SaveData_GetTemotiPokemon(fsys->savedata);
	MYITEM * item = SaveData_GetMyItem(fsys->savedata);
	ZUKAN_WORK * zw = SaveData_GetZukanWork(fsys->savedata);

	BattleParam_SetBgGroundID(bp, fsys);
	BattleParam_SetMyStatus(bp, my, POKEPARTY_MINE);
	BattleParam_SetPokeParty(bp, temoti, POKEPARTY_MINE);
	MyItem_Copy(item, bp->my_item);
	ZukanWork_Copy(zw, bp->zw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	퓬p[^Q[f[^ɔf
 * @param	bp		퓬p[^ւ̃|C^
 * @param	fsys	Q[䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void BattleParam_UpdateGameData(const BATTLE_PARAM * bp, FIELDSYS_WORK * fsys)
{
	MYSTATUS * my = SaveData_GetMyStatus(fsys->savedata);
	POKEPARTY * temoti = SaveData_GetTemotiPokemon(fsys->savedata);
	MYITEM * item = SaveData_GetMyItem(fsys->savedata);
	ZUKAN_WORK * zw = SaveData_GetZukanWork(fsys->savedata);

	MyStatus_Copy(bp->my_status[POKEPARTY_MINE], my);
	PokeParty_Copy(bp->poke_party[POKEPARTY_MINE], temoti);
	MyItem_Copy(bp->my_item, item);
	ZukanWork_Copy(bp->zw, zw);
}


//============================================================================================
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	퓬n`ID擾
 * @param	fsys	Q[䃏[Nւ̃|C^
 * @param	bg_id	퓬wiID
 */
//-----------------------------------------------------------------------------
static int GetGroundID(const FIELDSYS_WORK * fsys, int bg_id)
{
	MATR matr = GetAttributeLSB(fsys, fsys->location->grid_x, fsys->location->grid_z);
	static const BasicGroundTable[] = {
		GROUND_ID_GRAVEL,
		GROUND_ID_LAWN,
		GROUND_ID_ROCK,
		GROUND_ID_SNOW,
		GROUND_ID_FLOOR,
		GROUND_ID_FLOOR,
		GROUND_ID_FLOOR,
		GROUND_ID_CAVE,
		GROUND_ID_CAVE,
		GROUND_ID_CAVE,
	};

	if (MATR_IsIce(matr)) {
		return GROUND_ID_ICE;
	} else if (MATR_IsGrass(matr)) {
		return GROUND_ID_LAWN;
	} else if (MATR_IsSand(matr)) {
		return GROUND_ID_SANDS;
	} else if (MATR_IsSnow(matr)) {
		return GROUND_ID_SNOW;
	} else if (MATR_IsSwamp(matr) || MATR_IsSwampGrass(matr)) {
		return GROUND_ID_BOG;
	}

	if (MATR_IsWater(matr)) {
		//LɓĂ͂܂炸Ałΐn`ƂĕԂ
		return GROUND_ID_WATER;
	}
	if (bg_id < NELEMS(BasicGroundTable)) {
		//ǂ̃Agr[gɂĂ͂܂Ȃꍇ͔wiƂ̃ftHgn`Ԃ
		return BasicGroundTable[bg_id];
	}
	//Ƃ肠AlԂĂBG[H
	return GROUND_ID_ALL;
}

//-----------------------------------------------------------------------------
/**
 * @brief	퓬win`̃Zbg
 * @param	bp		퓬p[^ւ̃|C^
 * @param	fsys	Q[䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void BattleParam_SetBgGroundID(BATTLE_PARAM * bp, const FIELDSYS_WORK * fsys)
{
	bp->bg_id = ZoneData_GetBattleBGID(fsys->location->zone_id);
	bp->ground_id = GetGroundID(fsys, bp->bg_id);
}

