//============================================================================================
/**
 * @file	field_camera.c
 * @bfief	tB[hJ
 * @author	GAME FREAK inc.
 */
//============================================================================================
#include "common.h"
#include "camera.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "worldmap.h"
#include "fieldsys.h"

#include "field_camera.h"

#define FIELD_CAMERA_DELAY	(6)
#define FIELD_CAMERA_TRACE_BUFF	(FIELD_CAMERA_DELAY+1)

//------------------------------------------------------
//
//
//JieXgpjGA\[Xǂݍݎ܂ŉǉ 
//
//
//------------------------------------------------------

static const GF_CAMERA_PARAM FieldCameraData[] = {
	{							//	0	ʏ
		0x29aec1,
		{
			-0x29fe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x05c1,
		0	//dummy
	},
	{							//	1	W
		0x29aec1,
		{
			-0x309e,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x05c1,
		0	//dummy
	},
	{							//	2	ŏ̌
		0x20374c,
		{
			-0x26de,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x770,
		0	//dummy
	},
	{							//	3	|W
		0x29aec1,
		{
			-0x29fe,0,0
		},
		GF_CAMERA_PERSPECTIV,
		0x05c1,
		0	//dummy
	},
};



//==============================================================================
/**
 * tB[hōsJݒ
 *
 * @param   Hero			ɃGA؂ւɑΉJݒ肳
 * @param	repw			tB[hVXe|C^
 * @param   AreaCamera		ɃGA؂ւɑΉJݒ肳
 *
 * @retval  none		
 */
//==============================================================================
void FieldCameraInit(const VecFx32 *inTarget, FIELDSYS_WORK * repw, int AreaCamera)
{

	//JZbg
	const VecFx32 *target = inTarget;

	GF_ASSERT(AreaCamera < NELEMS(FieldCameraData));

	repw->camera_ptr = GFC_AllocCamera(HEAPID_FIELD);//tB[hJm
	
	//JZbg
	GFC_InitCameraTDA( target,
				FieldCameraData[AreaCamera].Distance,	// 
				&FieldCameraData[AreaCamera].Angle,		//
				FieldCameraData[AreaCamera].PerspWay,	// ˉe̊px
				FieldCameraData[AreaCamera].View,
				TRUE,
				repw->camera_ptr
				);
	//J̗L
	GFC_AttachCamera(repw->camera_ptr);
	//Jg[Xf[^ZbgAbv
	GFC_AllocTraceData(	FIELD_CAMERA_TRACE_BUFF, FIELD_CAMERA_DELAY,
						CAM_TRACE_MASK_Y, HEAPID_FIELD, repw->camera_ptr);
}

//==============================================================================
/**
 * tB[hJ̉
 *
 * @param   repw		tB[hVXe|C^
 *
 * @retval  none		
 */
//==============================================================================
void FieldCameraEnd(FIELDSYS_WORK * repw)
{
	GFC_PurgeCamera();						//J̐؂藣ij
		
	GFC_FreeTraceData(repw->camera_ptr);	//Jg[Xf[^
	GFC_FreeCamera(repw->camera_ptr);		//tB[hJ
}
