//******************************************************************************
/**
 * 
 * @file	field_effect.c
 * @brief	tB[hGtFNg
 * @author	kagaya
 * @data	05.07.13
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "field_effect.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
//	debug
//--------------------------------------------------------------
#define FE_VINTR_PRI (0xff)									///<VuN]TCBvCIeB

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
//	\̃|C^`
//--------------------------------------------------------------
typedef struct _TAG_FE_BLACT * FE_BLACT_PTR; ///<FE_BLACT|C^
typedef struct _TAG_FE_BLACT_HEADER_ID * FE_BLACT_HEADER_ID_PTR; ///<FE_BLACT_HEADER_ID|C^
typedef struct _TAG_FE_VINTR_WORK * FE_VINTR_WORK_PTR;	///<FE_VINTR_WORK|C^

//--------------------------------------------------------------
///	FE_SYS\
//--------------------------------------------------------------
typedef struct _TAG_FE_SYS
{
	int heap_id;						///<q[vID
	int eoa_max;						///<EOAő吔
	int blact_max;						///<r{[hAN^[ő吔
	FIELDSYS_WORK *fsys;				///<FIELDSYS_WORK *
	EOA_SYS_PTR es;						///<EOA_SYS_PTR
	FE_BLACT_PTR fba;					///<FE_BLACT_PTR
	FE_VINTR_WORK_PTR vintr;			///<FE_VINTR_WORK_PTR
	
	FE_SHADOW_PTR shadow;				///<FE_SHADOW_PTR
	FE_GRASS_PTR grass;					///<FE_GRASS_PTR
	FE_GYOE_PTR gyoe;					///<FE_GYOE_PTR
	FE_REFLECT_PTR ref;					///<FE_REFLECT_PTR
	FE_TRAP_PTR trap;					///<FE_TRAP_PTR
	FE_HOLE_PTR hole;					///<FE_HOLE_PTR
	FE_DIRTRAP_PTR dirtrap;				///<FE_DIRTRAP_PTR
	FE_FLAG_PTR flag;					///<FE_FLAG_PTR
	FE_EXCLAMATION_PTR exclamation;		///<FE_EXCLAMATION_PTR
	FE_OK_PTR ok;                    	///<FE_OK_PTR
	FE_DBGORNAMENT_PTR dbgornament;     ///<FE_DBGORNAMENT_PTR
	FE_ELIGHT_PTR elight;				///<FE_ELIGHT_PTR
	FE_FOOTMARK_PTR footmark;			///<FE_FOOTMARK_PTR
	FE_SPLASH_PTR splash;				///<FE_SPLASH_PTR
	FE_BOARD_PTR board;					///<FE_BOARD_PTR
	FE_SEEDGROUND_PTR seedground;		///<FE_SEEDGROUND_PTR
	FE_SNOWBALL_PTR snowball;			///<FE_SNOWBALL_PTR
	FE_REDFRAME_PTR redframe;			///<FE_REDFRAME_PTR
	FE_ARROW_PTR arrow;					///<FE_ARROW_PTR
	FE_NAMIPOKE_PTR namipoke;			///<FE_NAMIPOKE_PTR
	FE_ROCKRIDE_PTR rockride;			///<FE_ROCKRIDE_PTR
	FE_RIPPLE_PTR ripple;				///<FE_RIPPLE_PTR
}FE_SYS;

#define FE_SYS_SIZE (sizeof(FE_SYS))	///<FE_SYSTCY

//--------------------------------------------------------------
///	FE_BLACT\
//--------------------------------------------------------------
typedef struct _TAG_FE_BLACT
{
	int heap_id;
	int max;
	BLACT_SET_PTR set_ptr;
	RES_MANAGER_PTR resm_mdl;
	RES_MANAGER_PTR resm_anm;
	TEXRES_MANAGER_PTR resm_tex;
	FE_BLACT_HEADER_ID_PTR head_manage;
	BLACT_HEADER *head_tbl;
}FE_BLACT;

#define FE_BLACT_SIZE (sizeof(FE_BLACT))	///<FE_BLACTTCY

//--------------------------------------------------------------
///	FE_BLACT_HEADER_ID\
//--------------------------------------------------------------
typedef struct _TAG_FE_BLACT_HEADER_ID
{
	u32 id;														///<o^ID
	BLACT_HEADER *head;											///<wb_[*
}FE_BLACT_HEADER_ID;

#define FE_BLACT_HEADER_ID_SIZE (sizeof(FE_BLACT_HEADER_ID))	///<FE_BLACT_HEADER_IDTCY

//--------------------------------------------------------------
///	FE_VINTR_WORK\
//--------------------------------------------------------------
typedef struct _TAG_FE_VINTR_WORK
{
	vu32 access_flag;
	int heap_id;
	int max;
	TCB_PTR tcb;
	
	int *resm_tex_id_tbl;
	TEXRES_MANAGER_PTR *resm_tex_tbl;
}FE_VINTR_WORK;

#define FE_VINTR_WORK_SIZE (sizeof(FE_VINTR_WORK))				///<FE_VINTR_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static FE_SYS_PTR fe_SysAllocMemory( int heap_id );
static void fe_SysFreeMemory( FE_SYS_PTR fes );
static void fe_EoaInit( FE_SYS_PTR fes );
static void fe_EoaDelete( FE_SYS_PTR fes );
static void fe_EoaDraw( FE_SYS_PTR fes );

static void fe_BlActInit( FE_SYS_PTR fes );
static void fe_BlActDelete( FE_SYS_PTR fba );

static FE_BLACT_PTR fe_BlActAllocMemory( int heap_id );
static void fe_BlActFreeMemory( FE_BLACT_PTR fba );

static void fe_BlActHeaderManageInit( FE_BLACT_PTR fba );
static void fe_BlActHeaderManageDelete( FE_BLACT_PTR fba );
static BLACT_HEADER * fe_BlActHeaderManageAdd(
	FE_BLACT_PTR fba, int id, void *mdl, TEXANM_DATATBL *anm, void *tex, TEXRES_OBJ_PTR tex_key,
	const BLACT_ANIME_TBL *anm_tbl );
static BLACT_HEADER * fe_BlActHeaderManageGet( FE_BLACT_PTR fba, int id );
static void fe_BlActHeaderManageFree( FE_BLACT_PTR cont, int id );
static void fe_BlActHeaderManageFreeForce( FE_BLACT_PTR fba );

static void fe_BlActResmInit( FE_BLACT_PTR fba );
static void fe_BlActResmDelete( FE_BLACT_PTR fba );
static RES_OBJ_PTR rfe_ResmAddRes(RES_MANAGER_PTR resm,int id,const char * path,int heap_id);
static RES_OBJ_PTR rfe_ResmAddResNormal( RES_MANAGER_PTR resm,
		int id, const char * path, int heap_id );
static TEXRES_OBJ_PTR rfe_ResmAddTexRes( FE_SYS_PTR fes,
		TEXRES_MANAGER_PTR resm,int id,const char * path,int heap_id);
static int rfe_ResmDeleteRes( RES_MANAGER_PTR resm, int id );
static int rfe_ResmDeleteTexRes( TEXRES_MANAGER_PTR resm, int id );
static RES_OBJ_PTR fe_BlActResmMdlAddRes( FE_BLACT_PTR fba, int id, const char *path );
static RES_OBJ_PTR fe_BlActResmMdlSearch( FE_BLACT_PTR fba, int id );
static int fe_BlActResmMdlDelID( FE_BLACT_PTR fba, int id );
static RES_OBJ_PTR fe_BlActResmAnmAddRes( FE_BLACT_PTR fba, int id, const char *path );
static RES_OBJ_PTR fe_BlActResmAnmSearch( FE_BLACT_PTR fba, int id );
static int fe_BlActResmAnmDelID( FE_BLACT_PTR fba, int id );
static TEXRES_OBJ_PTR fe_BlActResmTexAddRes(
		FE_SYS_PTR fes, FE_BLACT_PTR fba, int id, const char *path );
static TEXRES_OBJ_PTR fe_BlActResmTexSearch( FE_BLACT_PTR fba, int id );
static int fe_BlActResmTexDelID( FE_BLACT_PTR fba, int id );

static FE_VINTR_WORK_PTR fe_VIntrInit( int heap_id, int pri, int max );
static void fe_VIntrDelete( FE_VINTR_WORK_PTR work );
static void fe_VIntrTcb( TCB_PTR tcb, void *wk );
static void fe_VIntrTexLoadAdd( FE_VINTR_WORK_PTR work, int id, TEXRES_MANAGER_PTR resm );

static void fe_ExternProcInit( FE_SYS_PTR fes );
static void fe_ExternProcDelete( FE_SYS_PTR fes );

//==============================================================================
//	tB[hGtFNg@VXe
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hGtFNgVXe
 * @param	fsys		FIELDSYS_WORK *
 * @param	heap_id		[NɎgpq[vID
 * @param	eoa_max		GtFNgŎgpEOAő吔
 * @param	blact_max	GtFNgŎgpr{[hAN^[ő吔
 * @retval	FE_SYS_PTR	FE_SYS_PTR
 */
//--------------------------------------------------------------
FE_SYS_PTR FE_Init( FIELDSYS_WORK *fsys, int heap_id, int eoa_max, int blact_max )
{
	FE_SYS_PTR fes;
	
	fes = fe_SysAllocMemory( heap_id );
	fes->heap_id = heap_id;
	fes->eoa_max = eoa_max;
	fes->blact_max = blact_max;
	fes->fsys = fsys;
	
	fe_EoaInit( fes );
	fe_BlActInit( fes );
	
	fes->vintr = fe_VIntrInit( heap_id, FE_VINTR_PRI, blact_max );
	fe_ExternProcInit( fes );		//FE_SYS𗘗pvZX
	
	return( fes );
}

//--------------------------------------------------------------
/**
 * tB[hGtFNgVXe폜
 * @param	fes			FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Delete( FE_SYS_PTR fes )
{
	fe_SysFreeMemory( fes );
}

//--------------------------------------------------------------
/**
 * tB[hGtFNgVXeS폜
 * @param	fes			FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_DeleteAll( FE_SYS_PTR fes )
{
	fe_ExternProcDelete( fes );
	fe_EoaDelete( fes );
	fe_BlActDelete( fes );
	fe_VIntrDelete( fes->vintr );
	FE_Delete( fes );
}

//==============================================================================
//	tB[hGtFNg@`
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hGtFNg`
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_Draw( FE_SYS_PTR fes )
{
	fe_EoaDraw( fes );
}

//==============================================================================
//	tB[hGtFNg@[Jp[c
//==============================================================================
//--------------------------------------------------------------
/**
 * FE_SYSm
 * @param	heap_id		HEAP ID
 * @retval	FE_SYS_PTR	mۂFE_SYS_PTR
 */
//--------------------------------------------------------------
static FE_SYS_PTR fe_SysAllocMemory( int heap_id )
{
	FE_SYS_PTR fes;
	
	fes = sys_AllocMemory( heap_id, FE_SYS_SIZE );
	GF_ASSERT( fes != NULL && "fe_SysAllocMemory()mۃG[" );
	
	memset( fes, 0, FE_SYS_SIZE );
	return( fes );
}

//--------------------------------------------------------------
/**
 * FE_SYSJ
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_SysFreeMemory( FE_SYS_PTR fes )
{
	sys_FreeMemory( fes->heap_id, fes );
}

//--------------------------------------------------------------
/**
 * EOAm
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_EoaInit( FE_SYS_PTR fes )
{
	fes->es = EOA_SysInit( fes->heap_id, fes->eoa_max );
}

//--------------------------------------------------------------
/**
 * EOA폜
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_EoaDelete( FE_SYS_PTR fes )
{
	EOA_SysDeleteAll( fes->es );
}

//--------------------------------------------------------------
/**
 * EOA`
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_EoaDraw( FE_SYS_PTR fes )
{
	EOA_SysDraw( fes->es );
}

//==============================================================================
//	FE_SYS_PTRQ
//==============================================================================
//--------------------------------------------------------------
/**
 * q[vID擾
 * @param	fes		FE_SYS_PTR
 * @retval	int		q[vID
 */
//--------------------------------------------------------------
int FE_HeapIDGet( CONST_FE_SYS_PTR fes )
{
	return( fes->heap_id );
}

//--------------------------------------------------------------
/**
 * FIELDSYS_WORK擾
 * @param	fes		FE_SYS_PTR
 * @retval	FIELDSYS_WORK	FIELDSYS_WORK *
 */
//--------------------------------------------------------------
FIELDSYS_WORK * FE_FieldSysWorkGet( CONST_FE_SYS_PTR fes )
{
	return( fes->fsys );
}

//--------------------------------------------------------------
/**
 * EOA_SYS_PTR擾
 * @param	fes		FE_SYS_PTR
 * @retval	FIELDSYS_WORK	FIELDSYS_WORK *
 */
//--------------------------------------------------------------
EOA_SYS_PTR FE_EoaSysGet( CONST_FE_SYS_PTR fes )
{
	return( fes->es );
}

//==============================================================================
//	tB[hGtFNg@Qƃp[c
//==============================================================================
//--------------------------------------------------------------
/**
 * FIELDSYS_WORKFE_SYS_PTR擾
 * @param	fsys	FIELDSYS_WORK *
 * @retval	FE_SYS_PTR	FE_SYS_PTR
 */
//--------------------------------------------------------------
FE_SYS_PTR FE_FieldSysWork_FE_SYS_PTR_Get( FIELDSYS_WORK *fsys )
{
	return( fsys->fes );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_PTRFE_SYS_PTR擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	FE_SYS_PTR	FE_SYS_PTR
 */
//--------------------------------------------------------------
FE_SYS_PTR FE_FieldOBJ_FE_SYS_PTR_Get( FIELD_OBJ_PTR fldobj )
{
	FIELDSYS_WORK *fsys;
	
	fsys = FieldOBJ_FieldSysWorkGet( fldobj );
	return( FE_FieldSysWork_FE_SYS_PTR_Get(fsys) );
}

//==============================================================================
//	tB[hGtFNgpr{[hAN^[
//==============================================================================
//--------------------------------------------------------------
/**
 * r{[hAN^[
 * @param	fes				FE_SYS_PTR
 * @param	heap_id			q[vID
 * @param	max				r{[hAN^[ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActInit( FE_SYS_PTR fes )
{
	int max,heap_id;
	FE_BLACT_PTR fba;
	BLACT_SETDATA set;
	
	heap_id = fes->heap_id;
	max = fes->blact_max;
	
	fba = fe_BlActAllocMemory( heap_id );
	fba->heap_id = heap_id;
	fba->max = max;
	
	fe_BlActResmInit( fba );
	fe_BlActHeaderManageInit( fba );
	
	set.WorkNum = max;
	set.heap = heap_id;
	fba->set_ptr = BLACT_InitSet( &set );
	
	fes->fba = fba;
}

//--------------------------------------------------------------
/**
 * r{[hAN^[폜
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActDelete( FE_SYS_PTR fes )
{
	FE_BLACT_PTR fba;
	
	fba = fes->fba;
	BLACT_DestSet( fba->set_ptr );
	fe_BlActHeaderManageDelete( fba );
	fe_BlActResmDelete( fba );
	fe_BlActFreeMemory( fba );
}

//==============================================================================
//	r{[hAN^[
//==============================================================================
//--------------------------------------------------------------
/**
 * r{[hAN^[ǉ@̂BLACT_Add()
 * @param	fes			FE_SYS_PTR
 * @param	head		BLACT_HEADER *
 * @param	vec			W
 * @retval	BLACT_WORK	BLACT_WORK_PTR s=I
 */
//--------------------------------------------------------------
BLACT_WORK_PTR FE_BlActAdd( FE_SYS_PTR fes, 
		const BLACT_HEADER *head, const VecFx32 *vec )
{
	int no;
	BLACT_ADD add;
	BLACT_WORK_PTR act;
	BLACT_SET_PTR set;
	VecFx32 scale = { FX32_ONE,FX32_ONE,FX32_ONE };
	
	set = fes->fba->set_ptr;
	
	add.blact_s = set;
	add.pHeader = head;
	add.matrix	= *vec;
	add.scale	= scale;
	
	act = BLACT_Add( &add );
	
	GF_ASSERT( act != NULL && "FE_BlActAdd() r{[hAN^[es?" );
	
	if( act != NULL ){
		NNS_G3dMdlSetMdlFogEnableFlagAll( BLACT_MdlResGet(act), TRUE );
		SetGlbLightMdl( BLACT_MdlResGet(act) );
	}
	
	return( act );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[ǉ@̂BLACT_Add()B
 * wb_[wFE_BlActHeaderManageAdd()Ŏw肵IDB
 * @param	fes			FE_SYS_PTR
 * @param	id			wb_[o^ID
 * @param	vec			W
 * @retval	BLACT_WORK	BLACT_WORK_PTR s=I
 */
//--------------------------------------------------------------
BLACT_WORK_PTR FE_BlActAddID( FE_SYS_PTR fes, int id, const VecFx32 *vec )
{
	int no;
	BLACT_HEADER *head;
	
	head = fe_BlActHeaderManageGet( fes->fba, id );
	GF_ASSERT( head != NULL && "FE_BlActAddID(id)wb_[o^ID" );
	
	return( FE_BlActAdd(fes,head,vec) );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[o^ new
 * @param	fes			FE_SYS_PTR
 * @param	id			o^ID
 * @param	mdl				f\[Xւ*
 * @param	anm				Aj\[Xւ*
 * @param	tex				eNX`\[Xւ*
 * @param	tex_key			풓^̏ꍇ̓L[擾pTEXRES_OBJ_PTRwBNULL=]^ŃZbg
 * @param	anm_tbl			r{[hAj const BLACT_ANIME_TBL *
 * @retval	BLACT_HEADER o^ꂽBLACT_HEADER * ǉς݂̏ꍇ̗͂̈Ԃ ǉs=ASSERT
 */
//--------------------------------------------------------------
BLACT_HEADER * FE_BlActHeaderManageAdd(
	FE_SYS_PTR fes, int id, void *mdl, TEXANM_DATATBL *anm, void *tex, TEXRES_OBJ_PTR tex_key,
	const BLACT_ANIME_TBL *anm_tbl )
{
	BLACT_HEADER *head;
	
	head = fe_BlActHeaderManageAdd( fes->fba, id, mdl, anm, tex, tex_key, anm_tbl );
	GF_ASSERT( head != NULL && "FE_BlActHeaderManageAdd()o^I[o[ɂǉs" );
	
	return( head );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[o^ \[X}l[W[p
 * @param	fes			FE_SYS_PTR
 * @param	id			o^ID
 * @param	mdl_id		FE_BlActResmAdd_Mdl()œo^ID
 * @param	anm_id		FE_BlActResmAdd_Anm()œo^ID
 * @param	tex_id		FE_BlActResmAdd_Tex()œo^ID
 * @param	tex_flag	FE_BLACT_TEX_VRAM
 * @param	anm_tbl			r{[hAj const BLACT_ANIME_TBL *
 * @retval	BLACT_HEADER o^ꂽBLACT_HEADER * ǉς݂̏ꍇ̗͂̈Ԃ ǉs=ASSERT
 */
//--------------------------------------------------------------
BLACT_HEADER * FE_BlActHeaderManageAddResmID(
		FE_SYS_PTR fes, int id, int mdl_id, int anm_id, int tex_id, int tex_flag,
		const BLACT_ANIME_TBL *anm_tbl )
{
	void *mdl,*tex,*anm;
	TEXANM_DATATBL anmdata;
	TEXRES_OBJ_PTR tex_key;
	BLACT_HEADER *head;
	
	mdl = FE_BlActResmSearch_Mdl( fes, mdl_id );
	GF_ASSERT( mdl != NULL && "FE_BlActHeaderManageAddResmID() fo^IDw" );
	
	anm = FE_BlActResmSearch_Anm( fes, anm_id );
	GF_ASSERT( anm != NULL && "FE_BlActHeaderManageAddResmID() Ajo^IDw" );
	TEXANM_UnPackLoadFile( anm, &anmdata );
	
	tex = FE_BlActResmSearch_Tex( fes, tex_id );
	GF_ASSERT( tex != NULL && "FE_BlActHeaderManageAddResmID() eNX`o^IDw" );
	
	tex_key = NULL;
	
	if( tex_flag == FE_BLACT_TEX_VRAM ){
		tex_key = FE_BlActResmSearch_TexOBJPtr( fes, tex_id );
		GF_ASSERT( tex != NULL && "FE_BlActHeaderManageAddResmID() eNX`o^IDw" );
	}
	
	head = fe_BlActHeaderManageAdd( fes->fba, id, mdl, &anmdata, tex, tex_key, anm_tbl );
	GF_ASSERT( head != NULL && "FE_BlActHeaderManageAdd()o^I[o[ɂǉs" );
	
	return( head );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[擾
 * @param	fes			FE_SYS_PTR
 * @param	id			o^ID
 * @retval	BLACT_HEADER BLACT_HEADER *BNULL=o^
 */
//--------------------------------------------------------------
BLACT_HEADER * FE_BlActHeaderManageGet( FE_SYS_PTR fes, int id )
{
	BLACT_HEADER *head;
	
	head = fe_BlActHeaderManageGet( fes->fba, id );
	
	return( head );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[J
 * @param	fes			FE_SYS_PTR
 * @param	id			JIDBo^̏ꍇ͉ȂB
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_BlActHeaderManageFree( FE_SYS_PTR fes, int id )
{
	fe_BlActHeaderManageFree( fes->fba, id );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@fo^B
 * sGF_ASSERT()
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_BlActResmAdd_Mdl( FE_SYS_PTR fes, int id, const char *path )
{
	RES_OBJ_PTR res;
	
	res = fe_BlActResmMdlAddRes( fes->fba, id, path );
	GF_ASSERT( res != NULL && "FE_BlActResmAdd_Mdl()fo^s" );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@f\[X
 * @param	fes		FE_SYS_PTR
 * @param	id		o^ID
 * @retval	void*	fzu\[X* NULL=o^ĂȂ
 */
//--------------------------------------------------------------
void * FE_BlActResmSearch_Mdl( FE_SYS_PTR fes, int id )
{
	RES_OBJ_PTR reso;
	
	reso = fe_BlActResmMdlSearch( fes->fba, id );
	
	if( reso == NULL ){
		return( NULL );
	}
	
	return( RESM_GetRes(reso) );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@fj
 * @param	fes		FE_SYS_PTR
 * @param	id		jID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_BlActResmDelete_Mdl( FE_SYS_PTR fes, int id )
{
	fe_BlActResmMdlDelID( fes->fba, id );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@Ajo^
 * sGF_ASSERT()
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_BlActResmAdd_Anm( FE_SYS_PTR fes, int id, const char *path )
{
	RES_OBJ_PTR res;
	
	res = fe_BlActResmAnmAddRes( fes->fba, id, path );
	GF_ASSERT( res != NULL && "FE_BlActResmAdd_Anm()fo^s" );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@Aj\[X
 * @param	fes		FE_SYS_PTR
 * @param	id		o^ID
 * @retval	void*	Ajzu\[X* NULL=o^ĂȂ
 */
//--------------------------------------------------------------
void * FE_BlActResmSearch_Anm( FE_SYS_PTR fes, int id )
{
	RES_OBJ_PTR reso;
	
	reso = fe_BlActResmAnmSearch( fes->fba, id );
	
	if( reso == NULL ){
		return( NULL );
	}
	
	return( RESM_GetRes(reso) );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@Ajj
 * @param	fes		FE_SYS_PTR
 * @param	id		jID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_BlActResmDelete_Anm( FE_SYS_PTR fes, int id )
{
	fe_BlActResmAnmDelID( fes->fba, id );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@eNX`o^
 * @sGF_ASSERT()
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_BlActResmAdd_Tex( FE_SYS_PTR fes, int id, const char *path )
{
	TEXRES_OBJ_PTR res;
	
	res = fe_BlActResmTexAddRes( fes, fes->fba, id, path );
	GF_ASSERT( res != NULL && "FE_BlActResmAdd_Tex()eNX`o^s" );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@eNX`\[X
 * @param	fes		FE_SYS_PTR
 * @param	id		o^ID
 * @retval	void*	eNX`zu\[X* NULL=o^ĂȂ
 */
//--------------------------------------------------------------
void * FE_BlActResmSearch_Tex( FE_SYS_PTR fes, int id )
{
	TEXRES_OBJ_PTR reso;
	
	reso = fe_BlActResmTexSearch( fes->fba, id );
	
	if( reso == NULL ){
		return( NULL );
	}
	
	return( TEXRESM_GetResPTR(reso) );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@eNX`\[X}l[WOBJ_PTR擾
 * @param	fes		FE_SYS_PTR
 * @param	id		o^ID
 * @retval	TEXRES_OBJ_PTR	TEXRES_OBJ_PTR NULL=o^ĂȂ
 */
//--------------------------------------------------------------
TEXRES_OBJ_PTR FE_BlActResmSearch_TexOBJPtr( FE_SYS_PTR fes, int id )
{
	TEXRES_OBJ_PTR reso;
	
	reso = fe_BlActResmTexSearch( fes->fba, id );
	
	if( reso == NULL ){
		return( NULL );
	}
	
	return( reso );
}

//--------------------------------------------------------------
/**
 * \[X}l[W@eNX`j
 * @param	fes		FE_SYS_PTR
 * @param	id		jID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_BlActResmDelete_Tex( FE_SYS_PTR fes, int id )
{
	fe_BlActResmTexDelID( fes->fba, id );
}

//==============================================================================
//	tB[hGtFNgpr{[hAN^[@p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * r{[hAN^[VXëm
 * @param	heap_id			q[vID
 * @retval	FE_BLACT_PTR	FE_BLACT_PTR
 */
//--------------------------------------------------------------
static FE_BLACT_PTR fe_BlActAllocMemory( int heap_id )
{
	FE_BLACT_PTR fba;
	
	fba = sys_AllocMemory( heap_id, FE_BLACT_SIZE );
	GF_ASSERT( fba != NULL && "fe_BlActAllocMemory()mۃG[" );
	
	memset( fba, 0, FE_BLACT_SIZE );
	return( fba );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[VXëJ
 * @param	fba	FE_BLACT_PTR
 * @retval	FE_BLACT_PTR	FE_BLACT_PTR
 */
//--------------------------------------------------------------
static void fe_BlActFreeMemory( FE_BLACT_PTR fba )
{
	sys_FreeMemory( fba->heap_id, fba );
}

//==============================================================================
//	tB[hGtFNgpr{[hAN^[@wb_[}l[W
//==============================================================================
//--------------------------------------------------------------
/**
 * wb_[̈m
 * @param	fba		FE_BLACT
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActHeaderManageInit( FE_BLACT_PTR fba )
{
	int max,size,h_size,heap_id;
	BLACT_HEADER *head;
	FE_BLACT_HEADER_ID *man;
	
	max = fba->max;
	heap_id = fba->heap_id;
	
	h_size = sizeof( BLACT_HEADER );
	size = h_size * max;
	head = sys_AllocMemory( heap_id, size );
	fba->head_tbl = head;
	
	GF_ASSERT( head != NULL && "fe_BlActHeaderManageInit()mێs" );
	
	size = FE_BLACT_HEADER_ID_SIZE * max;
	man = sys_AllocMemory( heap_id, size );
	fba->head_manage = man;
		
	GF_ASSERT( man != NULL && "fe_BlActHeaderManageInit()mێs" );
	
	do{
		man->id = FE_BLACT_H_ID_NOT;
		man->head = head;
		man++;
		(u8*)head += h_size; 
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * wb_[Ǘ̈J
 * @param	fba		FE_BLACT
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActHeaderManageDelete( FE_BLACT_PTR fba )
{
	int heap_id;
	
	fe_BlActHeaderManageFreeForce( fba );
	
	heap_id = fba->heap_id;
	sys_FreeMemory( heap_id, fba->head_tbl );
	sys_FreeMemory( heap_id, fba->head_manage );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈փwb_[ǉ
 * @param	fba				FE_BLACT_PTR
 * @param	id				o^ID
 * @param	mdl				f\[Xւ*
 * @param	anm				Aj\[Xւ*
 * @param	tex				eNX`\[Xւ*
 * @param	tex_key			풓^̏ꍇ̓L[擾pTEXRES_OBJ_PTRwBNULL=]^ŃZbg
 * @param	anm_tbl			r{[hAj BLACT_ANIME_TBL *
 * @retval	BLACT_HEADER	wb_[̈ւ*BNULL=s
 */
//--------------------------------------------------------------
static BLACT_HEADER * fe_BlActHeaderManageAdd(
	FE_BLACT_PTR fba, int id, void *mdl, TEXANM_DATATBL *anm, void *tex, TEXRES_OBJ_PTR tex_key,
	const BLACT_ANIME_TBL *anm_tbl )
{
	BLACT_HEADER *head;
	
	head = NULL;
	
	{
		int max = fba->max;
		FE_BLACT_HEADER_ID *ma = fba->head_manage;
		
		do{ if(ma->id==id){ return(ma->head); }					//o^ς
			ma++; max--;
		}while( max );
		
		ma = fba->head_manage;
		max = fba->max;
		
		do{ if(ma->id==FE_BLACT_H_ID_NOT){ ma->id=id; head=ma->head; break; }
			ma++; max--;
		}while( max );
	}
	
	GF_ASSERT( head != NULL && "fe_BlActHeaderManageAdd() r{[hwb_[t"  );
	
	memset( head, 0, sizeof(BLACT_HEADER) );
	
	head->ImdRes = mdl;
	head->texanm = *anm;
	head->ItxRes = tex;
	
	if( tex_key != NULL ){
		head->texKey = TEXRESM_GetTexKeyPTR( tex_key );
		head->tex4x4Key = TEXRESM_GetTex4x4KeyPTR( tex_key );
		head->plttKey = TEXRESM_GetPlttKeyPTR( tex_key );
	}
	
	head->anm = anm_tbl;
	
	return( head );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈wb_[擾
 * @param	cont			FIELD_OBJ_BLACT_CONT
 * @param	id				o^ID
 * @retal	BLACT_HEADER	wb_[̈ւ*BNULL=o^ĂȂ
 */
//--------------------------------------------------------------
static BLACT_HEADER * fe_BlActHeaderManageGet( FE_BLACT_PTR fba, int id )
{
	int max;
	FE_BLACT_HEADER_ID *ma;
	
	ma = fba->head_manage;
	max = fba->max;
	
	do{
		if( ma->id == id ){
			return( ma->head );
		}
		
		ma++;
		max--;
	}while( max );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈J
 * @param	fba			FE_BLACT
 * @param	id			JID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActHeaderManageFree( FE_BLACT_PTR fba, int id )
{
	int max;
	FE_BLACT_HEADER_ID *ma;
	
	ma = fba->head_manage;
	max = fba->max;
	
	do{
		if( ma->id == id ){
			ma->id = FE_BLACT_H_ID_NOT;
//			BLACT_HeaderFree( ma->head );	//p~
			return;
		}
		
		ma++;
		max--;
	}while( max );	
}

//--------------------------------------------------------------
/**
 * AN^[wb_[Ǘ̈拭J
 * @param	fba		FE_BLACT
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActHeaderManageFreeForce( FE_BLACT_PTR fba )
{
	int max;
	FE_BLACT_HEADER_ID *ma;
	
	ma = fba->head_manage;
	max = fba->max;
	
	do{
		if( ma->id != FE_BLACT_H_ID_NOT ){
			ma->id = FE_BLACT_H_ID_NOT;
//			BLACT_HeaderFree( ma->head );	//p~
		}
		
		ma++;
		max--;
	}while( max );
}

//==============================================================================
//	tB[hGtFNgpr{[hAN^[@\[X}l[W
//==============================================================================
//--------------------------------------------------------------
/**
 * \[Xm
 * @param	fba		FE_BLACT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActResmInit( FE_BLACT_PTR fba )
{
	int max,heap_id;
	
	max = fba->max;
	heap_id = fba->heap_id;
	
	fba->resm_mdl = RESM_Init( max, heap_id );
	fba->resm_anm = RESM_Init( max, heap_id );
	fba->resm_tex = TEXRESM_Init( max, heap_id );
}

//--------------------------------------------------------------
/**
 * \[X폜
 * @param	fba		FE_BLACT_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_BlActResmDelete( FE_BLACT_PTR fba )
{
	RESM_Delete( fba->resm_mdl );
	RESM_Delete( fba->resm_anm );
	TEXRESM_Delete( fba->resm_tex );
}

//--------------------------------------------------------------
/**
 * \[Xo^
 * @param	resm	RES_MANAGER_PTR
 * @param	id		o^ID
 * @param	path	o^pX
 * @param	heap_id	q[vID
 * @retval	RES_OBJ_PTR	NULL=s
 */
//--------------------------------------------------------------
static RES_OBJ_PTR rfe_ResmAddRes( RES_MANAGER_PTR resm,
		int id, const char * path, int heap_id )
{
	RES_OBJ_PTR res;
	
	res = RESM_GetResObj( resm, id );
	
	if( res == NULL ){
		res = RESM_AddRes( resm, path, id, heap_id );
	}
	
	return( res );
}

//--------------------------------------------------------------
/**
 * \[Xo^ m[}
 * @param	resm	RES_MANAGER_PTR
 * @param	id		o^ID
 * @param	path	o^pX
 * @param	heap_id	q[vID
 * @retval	RES_OBJ_PTR	NULL=s
 */
//--------------------------------------------------------------
static RES_OBJ_PTR rfe_ResmAddResNormal( RES_MANAGER_PTR resm,
		int id, const char * path, int heap_id )
{
	void *file_ram;
	RES_OBJ_PTR res;
	
	res = RESM_GetResObj( resm, id );
	
	if( res == NULL ){
		file_ram = sys_LoadFile( heap_id, path );
		res = RESM_AddResNormal( resm, file_ram, id );
	}
	
	return( res );
}

//--------------------------------------------------------------
/**
 * \[Xo^@eNX`
 * @param	fes		FE_SYS_PTR
 * @param	resm	TEXRES_MANAGER_PTR
 * @param	id		o^ID
 * @param	path	o^pX
 * @param	heap_id	q[vID
 * @retval	TEXRES_OBJ_PTR	NULL=s
 */
//--------------------------------------------------------------
static TEXRES_OBJ_PTR rfe_ResmAddTexRes( FE_SYS_PTR fes, TEXRES_MANAGER_PTR resm,
		int id, const char * path, int heap_id )
{
	TEXRES_OBJ_PTR res;
	
	res = TEXRESM_GetResObj( resm, id );
	
	if( res == NULL ){
		res = TEXRESM_AddAndAllocVramKeyRes( resm, path, id, heap_id );
		GF_ASSERT( res != NULL && "rfe_ResmAddTexRes()eNX`o^s" );

//		TEXRESM_TexLoadAndCutTexID( resm, id );
		FE_VIntrTexLoadAdd( fes, id, resm );
	}
	
	return( res );
}

//--------------------------------------------------------------
/**
 * \[X폜
 * @param	resm	RES_MANAGER_PTR
 * @param	id		폜ID
 * @retval	int			TRUE=폜@FALSE=o^Ė
 */
//--------------------------------------------------------------
static int rfe_ResmDeleteRes( RES_MANAGER_PTR resm, int id )
{
	RES_OBJ_PTR res;
	
	if( RESM_CheckID(resm,id) == TRUE ){
		return( FALSE );
	}
	
	RESM_DeleteResID( resm, id );
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * \[X폜	Ă
 * @param	resm	TEXRES_MANAGER_PTR
 * @param	id		폜ID
 * @retval	int			TRUE=폜@FALSE=o^Ė
 */
//--------------------------------------------------------------
static int rfe_ResmDeleteTexRes( TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR res;
	
	if( TEXRESM_CheckID(resm,id) == TRUE ){
		return( FALSE );
	}
	
	TEXRESM_DeleteResID( resm, id );
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * f\[Xo^
 * @param	fba			FE_BLACT_PTR
 * @param	id			o^ID
 * @param	path		f[^pX
 * @retval	RES_OBJ_PTR	NULL=s
 */
//--------------------------------------------------------------
static RES_OBJ_PTR fe_BlActResmMdlAddRes( FE_BLACT_PTR fba, int id, const char *path )
{
	return( rfe_ResmAddRes(fba->resm_mdl,id,path,fba->heap_id) );
}

//--------------------------------------------------------------
/**
 * f\[X
 * @param	fba			FE_BLACT_PTR
 * @param	id			o^ID
 * @retval	RES_OBJ_PTR	NULL=o^ĂȂ
 */
//--------------------------------------------------------------
static RES_OBJ_PTR fe_BlActResmMdlSearch( FE_BLACT_PTR fba, int id )
{
	RES_OBJ_PTR reso;
	
	reso = RESM_GetResObj( fba->resm_mdl, id );
	return( reso );
}

//--------------------------------------------------------------
/**
 * f\[Xj
 * @param	fba			FE_BLACT_PTR
 * @param	id			jID
 * @retval	int			TRUE=폜@FALSE=o^Ė
 */
//--------------------------------------------------------------
static int fe_BlActResmMdlDelID( FE_BLACT_PTR fba, int id )
{
	return( rfe_ResmDeleteRes(fba->resm_mdl,id) );
}

//--------------------------------------------------------------
/**
 * Aj\[Xo^
 * @param	fba			FE_BLACT_PTR
 * @param	id			o^ID
 * @param	path		f[^pX
 * @retval	RES_OBJ_PTR	NULL=s
 */
//--------------------------------------------------------------
static RES_OBJ_PTR fe_BlActResmAnmAddRes( FE_BLACT_PTR fba, int id, const char *path )
{
	return( rfe_ResmAddResNormal(fba->resm_anm,id,path,fba->heap_id) );
}

//--------------------------------------------------------------
/**
 * Aj\[X
 * @param	fba			FE_BLACT_PTR
 * @param	id			o^ID
 * @retval	RES_OBJ_PTR	NULL=o^ĂȂ
 */
//--------------------------------------------------------------
static RES_OBJ_PTR fe_BlActResmAnmSearch( FE_BLACT_PTR fba, int id )
{
	RES_OBJ_PTR reso;
	
	reso = RESM_GetResObj( fba->resm_anm, id );
	return( reso );
}

//--------------------------------------------------------------
/**
 * Aj\[Xj
 * @param	fba			FE_BLACT_PTR
 * @param	id			jID
 * @retval	int			TRUE=폜@FALSE=o^Ė
 */
//--------------------------------------------------------------
static int fe_BlActResmAnmDelID( FE_BLACT_PTR fba, int id )
{
	return( rfe_ResmDeleteRes(fba->resm_anm,id) );
}

//--------------------------------------------------------------
/**
 * eNX`\[Xo^
 * @param	fba			FE_BLACT_PTR
 * @param	id			o^ID
 * @param	path		f[^pX
 * @retval	RES_OBJ_PTR	NULL=s
 */
//--------------------------------------------------------------
static TEXRES_OBJ_PTR fe_BlActResmTexAddRes(
		FE_SYS_PTR fes, FE_BLACT_PTR fba, int id, const char *path )
{
	return( rfe_ResmAddTexRes(fes,fba->resm_tex,id,path,fba->heap_id) );
}

//--------------------------------------------------------------
/**
 * eNX`\[X
 * @param	fba			FE_BLACT_PTR
 * @param	id			o^ID
 * @retval	TEXRES_OBJ_PTR	NULL=o^ĂȂ
 */
//--------------------------------------------------------------
static TEXRES_OBJ_PTR fe_BlActResmTexSearch( FE_BLACT_PTR fba, int id )
{
	TEXRES_OBJ_PTR reso;
	
	reso = TEXRESM_GetResObj( fba->resm_tex, id );
	return( reso );
}

//--------------------------------------------------------------
/**
 * eNX`\[Xj
 * @param	fba			FE_BLACT_PTR
 * @param	id			jID
 * @retval	int			TRUE=폜@FALSE=o^Ė
 */
//--------------------------------------------------------------
static int fe_BlActResmTexDelID( FE_BLACT_PTR fba, int id )
{
	return( rfe_ResmDeleteTexRes(fba->resm_tex,id) );
}

//==============================================================================
//	VuN]
//==============================================================================
//--------------------------------------------------------------
/**
 * VuN]
 * @param	heap_id		q[vID
 * @param	pri			vCIeB
 * @param	max			]ő吔
 * @retval	FE_VINTR_WORK_PTR FE_VINTR_WORK_PTR
 */
//--------------------------------------------------------------
static FE_VINTR_WORK_PTR fe_VIntrInit( int heap_id, int pri, int max )
{
	FE_VINTR_WORK_PTR work;
	
	work = sys_AllocMemory( heap_id, FE_VINTR_WORK_SIZE );
	GF_ASSERT( work != NULL && "fe_VIntrTcbAdd()mێs" );
	memset( work, 0, FE_VINTR_WORK_SIZE );
	
	{
		int size = sizeof( TEXRES_MANAGER_PTR ) * max;
		work->resm_tex_tbl = sys_AllocMemory( heap_id, size );
		GF_ASSERT( work->resm_tex_tbl != NULL && "fe_VIntrTcbAdd()[Ns" );
		memset( work->resm_tex_tbl, NULL, size );
		
		size = sizeof( int ) * max;
		work->resm_tex_id_tbl = sys_AllocMemory( heap_id, size );
		GF_ASSERT( work->resm_tex_id_tbl != NULL && "fe_VIntrTcbAdd()[Ns" );
		memset( work->resm_tex_id_tbl, 0, size );
	}
	
	work->heap_id = heap_id;
	work->max = max;
	
	work->tcb = VIntrTCB_Add( fe_VIntrTcb, work, pri );
	GF_ASSERT( work->tcb != NULL && "fe_VIntrTcbAdd()TCBǉs" );
	
	return( work );
}

//--------------------------------------------------------------
/**
 * VIntr 폜
 * @param	work	FE_VINTR_WORK_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_VIntrDelete( FE_VINTR_WORK_PTR work )
{
	TCB_Delete( work->tcb );
	sys_FreeMemory( work->heap_id, work->resm_tex_id_tbl );
	sys_FreeMemory( work->heap_id, work->resm_tex_tbl );
	sys_FreeMemory( work->heap_id, work );
}

//--------------------------------------------------------------
/**
 * VIntr VuN tcb
 * @param	tcb		TCB_PTR
 * @param	wk		tcb work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_VIntrTcb( TCB_PTR tcb, void *wk )
{
	int i;
	FE_VINTR_WORK_PTR work;
	
	GF_ASSERT( wk != NULL && "fe_VIntrTcb()ُ" );
	
	work = wk;
	
	if( work->access_flag == TRUE ){
		OS_Printf( "fe_VIntrTcb()ANZXɊ荞ݏ܂\n" );
		return;
	}
	
	i = 0;
	
	do{
		GF_ASSERT( work != NULL && "fe_VIntrTcb()[NNULLɕω" );
		
		if( work->resm_tex_tbl[i] != NULL ){
			GF_ASSERT( work->resm_tex_id_tbl[i] < FE_RESMID_TEX_MAX && "fe_VIntrTcb()IDُ" );
			TEXRESM_TexLoadAndCutTexID( work->resm_tex_tbl[i], work->resm_tex_id_tbl[i] );
			GF_ASSERT( work != NULL && "fe_VIntrTcb()[N@o^NULLω" );
			work->resm_tex_tbl[i] = NULL;
		}
		
		i++;
	}while( i < work->max );
}

//--------------------------------------------------------------
/**
 * VIntr TEXRESM_TexLoad() VuN֓o^
 * @param	work	FE_VINTR_WORK_PTR
 * @param	id		]eNX`o^ID
 * @param	resm	TEXRES_MANAGER_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_VIntrTexLoadAdd( FE_VINTR_WORK_PTR work, int id, TEXRES_MANAGER_PTR resm )
{
	int i;
	
	i = 0;
	
	work->access_flag = TRUE;
	
	do{
		if( work->resm_tex_tbl[i] == NULL ){
			work->resm_tex_tbl[i] = resm;
			work->resm_tex_id_tbl[i] = id;
			break;
		}
		
		i++;
	}while( i < work->max );
	
	GF_ASSERT( i < work->max && "fe_VIntrTexLoadAdd()eNX`]ő吔z" );
	work->access_flag = FALSE;
}

//--------------------------------------------------------------
/**
 * VIntr TEXRESM_TexLoad() VuN֓o^
 * @param	fes		FE_SYS_PTR
 * @param	id		]eNX`o^ID
 * @param	resm	TEXRES_MANAGER_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_VIntrTexLoadAdd( FE_SYS_PTR fes, int id, TEXRES_MANAGER_PTR resm )
{
	fe_VIntrTexLoadAdd( fes->vintr, id, resm );
}

//==============================================================================
//	eoa
//==============================================================================
//--------------------------------------------------------------
/**
 * EOAǉ@̂EOA_Add_NPP()
 * @param	fes		FE_SYS_PTR
 * @param	EOA_H_NPP	ǉ񂪓Z߂ꂽEOA_H_NPP
 * @param	mtx			ʒu
 * @param	prm			ǉEOA֎w肷p^
 * @param	ptr			ǉEOA֎w肷|C^
 * @param	pri			ǉEOA̓vCIeB
 * @retval	EOA_PTR		ǉꂽEOA_PTR ǉs@I
 */
//--------------------------------------------------------------
EOA_PTR FE_EoaAddNpp( FE_SYS_PTR fes, const EOA_H_NPP *head,
		const VecFx32 *mtx, int prm, const void *ptr, int pri )
{
	EOA_PTR eoa;
	EOA_SYS_PTR es;
	
	es = fes->es;
	eoa = EOA_Add_NPP( es, head, mtx, prm, ptr, pri );
	
	GF_ASSERT( eoa != NULL && "FE_EoaAddNpp() EOA̒ǉɎsc" );
	
	return( eoa );
}

//==============================================================================
//	p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * FIELD_OBJ_PTRTCBX^_[hvCIeB𒲐Ď擾
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	offset	X^_[hvCIeBɉZl
 * @retval	int		߂ꂽvCIeB
 */
//--------------------------------------------------------------
int FE_FldOBJ_TCBPriGet( CONST_FIELD_OBJ_PTR fldobj, int offset )
{
	int pri;
	
	pri = FieldOBJ_TCBStandardPriorityGet( fldobj );
	pri += offset;
	
	return( pri );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ̓`FbNB
 * SAւ肪Ă邩`FbNB
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	obj_id	Ƃ݂ȂOBJ ID
 * @param	zone_id	Ƃ݂ȂZONE ID
 * @retval	int		TRUE=BFALSE=ł͂Ȃ
 */
//--------------------------------------------------------------
int FE_FldOBJ_CheckSameID( CONST_FIELD_OBJ_PTR fldobj, int obj_id, int zone_id )
{
	if( FieldOBJ_StatusBit_CheckEasy(fldobj,FLDOBJ_STA_BIT_USE) == FALSE ){
		return( FALSE );
	}
	
	if( FieldOBJ_OBJIDGet(fldobj) != obj_id ){
		return( FALSE );
	}
	
	if( FieldOBJ_ZoneIDGet(fldobj) != zone_id ){
		return( FALSE );
	}
	
	return( TRUE );
}

//==============================================================================
//	tB[hGtFNg𗘗pOvZX
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hGtFNg𗘗pOvZX@B
 * OvZX̏͂ł܂Ƃ߂B 
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_ExternProcInit( FE_SYS_PTR fes )
{
	fes->shadow = FE_Shadow_Init( fes, fes->heap_id );			//e
	fes->grass = FE_Grass_Init( fes, fes->heap_id );			//
	fes->ref = FE_Reflect_Init( fes, fes->heap_id );			//f肱ݏ
	fes->trap = FE_Trap_Init( fes, fes->heap_id );				//㩏
	fes->hole = FE_Hole_Init( fes, fes->heap_id );				//㩏
	fes->dirtrap = FE_DirTrap_Init( fes, fes->heap_id );		//㩏
	fes->flag = FE_Flag_Init( fes, fes->heap_id );				//
	fes->exclamation = FE_Exclamation_Init( fes, fes->heap_id ); //т}[N
	fes->ok = FE_Ok_Init( fes, fes->heap_id );                   //OK}[N
	fes->dbgornament = FE_DbgOrnament_Init( fes, fes->heap_id );//nzu폜
	fes->elight = FE_ELight_Init( fes, fes->heap_id );			//d
	fes->footmark = FE_FootMark_Init( fes, fes->heap_id );		//Տ
	fes->board = FE_Board_Init( fes, fes->heap_id );			//Ŕ
	fes->seedground = FE_SeedGround_Init( fes, fes->heap_id );	//؂̎y
	fes->snowball = FE_SnowBall_Init( fes, fes->heap_id );		//ʏ
	fes->arrow = FE_Arrow_Init( fes, fes->heap_id );			//󏉊
	fes->namipoke = FE_NamiPoke_Init( fes, fes->heap_id );		//g|P
	fes->rockride = FE_RockRide_Init( fes, fes->heap_id );		//Ǐ|P
	fes->ripple = FE_Ripple_Init( fes, fes->heap_id );			//g䏉
	
	fes->gyoe = FE_Gyoe_Init( fes, fes->heap_id );				//MG[
	fes->splash = FE_Splash_Init( fes, fes->heap_id );			//򖗏
	fes->redframe = FE_RedFrame_Init( fes, fes->heap_id );		//Ԙg
}

//--------------------------------------------------------------
/**
 * tB[hGtFNg𗘗pOvZX@폜B
 * OvZX̍폜͂ł܂Ƃ߂B
 * @param	fes		FE_SYS_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void fe_ExternProcDelete( FE_SYS_PTR fes )
{
	FE_Shadow_Delete( fes->shadow );							//e폜
	FE_Grass_Delete( fes->grass );								//폜
	FE_Reflect_Delete( fes->ref );								//f肱ݍ폜
	FE_Trap_Delete( fes->trap );								//㩍폜
	FE_Hole_Delete( fes->hole );								//㩍폜
	FE_DirTrap_Delete( fes->dirtrap );							//㩍폜
	FE_Flag_Delete( fes->flag );								//폜
	FE_Exclamation_Delete( fes->exclamation );			   		//!}[N폜
	FE_Ok_Delete( fes->ok );			                 		//OK}[N폜
	FE_DbgOrnament_Delete( fes->dbgornament );					//nzu폜
	FE_ELight_Delete( fes->elight );							//d폜
	FE_FootMark_Delete( fes->footmark );						//Ս폜
	FE_Board_Delete( fes->board );								//Ŕ폜
	FE_SeedGround_Delete( fes->seedground );					//؂̎y폜
	FE_SnowBall_Delete( fes->snowball );						//ʍ폜
	FE_Arrow_Delete( fes->arrow );								//폜
	FE_NamiPoke_Delete( fes->namipoke );						//g|P폜
	FE_RockRide_Delete( fes->rockride );						//Ǐ|P폜
	FE_Ripple_Delete( fes->ripple );							//g폜
	
	FE_Gyoe_Delete( fes->gyoe );								//MG[폜
	FE_Splash_Delete( fes->splash );							//򖗍폜
	FE_RedFrame_Delete( fes->redframe );						//Ԙg폜
}

//==============================================================================
//	FE_SYS_PTRփNOvZXn̎QƊ֐
//==============================================================================
//--------------------------------------------------------------
/**
 * FE_SHADOW_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_SHADOW_PTR	FE_SHADOW_PTR
 */
//--------------------------------------------------------------
FE_SHADOW_PTR FE_ShadowPtrGet( FE_SYS_PTR fes )
{
	return( fes->shadow );
}

//--------------------------------------------------------------
/**
 * FE_GRASS_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_SHADOW_PTR	FE_SHADOW_PTR
 */
//--------------------------------------------------------------
FE_GRASS_PTR FE_GrassPtrGet( FE_SYS_PTR fes )
{
	return( fes->grass );
}

//--------------------------------------------------------------
/**
 * FE_GYOE_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_GYOE_PTR FE_GYOE_PTR
 */
//--------------------------------------------------------------
FE_GYOE_PTR FE_GyoePtrGet( FE_SYS_PTR fes )
{
	return( fes->gyoe );
}

//--------------------------------------------------------------
/**
 * FE_REFLECT_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_REFLECT_PTR FE_REFLECT_PTR
 */
//--------------------------------------------------------------
FE_REFLECT_PTR FE_ReflectPtrGet( FE_SYS_PTR fes )
{
	return( fes->ref );
}

//--------------------------------------------------------------
/**
 * FE_TRAP_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_TRAP_PTR	FE_TRAP_PTR
 */
//--------------------------------------------------------------
FE_TRAP_PTR FE_TrapPtrGet( FE_SYS_PTR fes )
{
	return( fes->trap );
}

//--------------------------------------------------------------
/**
 * FE_HOLE_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_HOLE_PTR	FE_HOLE_PTR
 */
//--------------------------------------------------------------
FE_HOLE_PTR FE_HolePtrGet( FE_SYS_PTR fes )
{
	return( fes->hole );
}

//--------------------------------------------------------------
/**
 * FE_DIRTRAP_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_DIRTRAP_PTR	FE_DIRTRAP_PTR
 */
//--------------------------------------------------------------
FE_DIRTRAP_PTR FE_DirTrapPtrGet( FE_SYS_PTR fes )
{
	return( fes->dirtrap );
}

//--------------------------------------------------------------
/**
 * FE_FLAG_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_FLAG_PTR FE_FLAG_PTR
 */
//--------------------------------------------------------------
FE_FLAG_PTR FE_FlagPtrGet( FE_SYS_PTR fes )
{
	return( fes->flag );
}

//--------------------------------------------------------------
/**
 * FE_EXCLAMATION_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_EXCLAMATION_PTR FE_EXCLAMATION_PTR
 */
//--------------------------------------------------------------
FE_EXCLAMATION_PTR FE_ExclamationPtrGet( FE_SYS_PTR fes )
{
	return( fes->exclamation );
}

//--------------------------------------------------------------
/**
 * FE_OK_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_OK_PTR FE_OK_PTR
 */
//--------------------------------------------------------------
FE_OK_PTR FE_OkPtrGet( FE_SYS_PTR fes )
{
	return( fes->ok );
}

//--------------------------------------------------------------
/**
 * FE_DBGORNAMENT_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_DBGORNAMENT_PTR FE_DBGORNAMENT_PTR
 */
//--------------------------------------------------------------
FE_DBGORNAMENT_PTR FE_DbgOrnamentPtrGet( FE_SYS_PTR fes )
{
	return( fes->dbgornament );
}

//--------------------------------------------------------------
/**
 * FE_ELIGHT_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_ELIGHT_PTR FE_ELIGHT_PTR
 */
//--------------------------------------------------------------
FE_ELIGHT_PTR FE_ELightPtrGet( FE_SYS_PTR fes )
{
	return( fes->elight );
}

//--------------------------------------------------------------
/**
 * FE_FOOTMARK_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_FOOTMARK_PTR FE_FOOTMARK_PTR
 */
//--------------------------------------------------------------
FE_FOOTMARK_PTR FE_FootMarkPtrGet( FE_SYS_PTR fes )
{
	return( fes->footmark );
}

//--------------------------------------------------------------
/**
 * FE_SPLASH_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_SPLASH_PTR FE_SPLASH_PTR
 */
//--------------------------------------------------------------
FE_SPLASH_PTR FE_SplashPtrGet( FE_SYS_PTR fes )
{
	return( fes->splash );
}

//--------------------------------------------------------------
/**
 * FE_BOARD_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_BOARD_PTR FE_BOARD_PTR
 */
//--------------------------------------------------------------
FE_BOARD_PTR FE_BoardPtrGet( FE_SYS_PTR fes )
{
	return( fes->board );
}

//--------------------------------------------------------------
/**
 * FE_SEEDGROUND_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_SEEDGROUND_PTR FE_SEEDGROUND_PTR
 */
//--------------------------------------------------------------
FE_SEEDGROUND_PTR FE_SeedGroundPtrGet( FE_SYS_PTR fes )
{
	return( fes->seedground );
}

//--------------------------------------------------------------
/**
 * FE_SNOWBALL_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_SNOWBALL_PTR FE_SNOWBALL_PTR
 */
//--------------------------------------------------------------
FE_SNOWBALL_PTR FE_SnowBallPtrGet( FE_SYS_PTR fes )
{
	return( fes->snowball );
}

//--------------------------------------------------------------
/**
 * FE_REDFRAME_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_REDFRAME_PTR FE_SEEDGROUND_PTR
 */
//--------------------------------------------------------------
FE_REDFRAME_PTR FE_RedFramePtrGet( FE_SYS_PTR fes )
{
	return( fes->redframe );
}

//--------------------------------------------------------------
/**
 * FE_ARROW_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_ARROW_PTR FE_ARROW_PTR
 */
//--------------------------------------------------------------
FE_ARROW_PTR FE_ArrowPtrGet( FE_SYS_PTR fes )
{
	return( fes->arrow );
}

//--------------------------------------------------------------
/**
 * FE_NAMIPOKE_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_NAMIPOKE_PTR FE_NAMIPOKE_PTR
 */
//--------------------------------------------------------------
FE_NAMIPOKE_PTR FE_NamiPokePtrGet( FE_SYS_PTR fes )
{
	return( fes->namipoke );
}

//--------------------------------------------------------------
/**
 * FE_ROCKRIDE_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_ROCKRIDE_PTR FE_ROCKRIDE_PTR
 */
//--------------------------------------------------------------
FE_ROCKRIDE_PTR FE_RockRidePtrGet( FE_SYS_PTR fes )
{
	return( fes->rockride );
}

//--------------------------------------------------------------
/**
 * FE_RIPPLE_PTR擾
 * @param	fes	FE_SYS_PTR
 * @retval	FE_RIPPLE_PTR FE_RIPPLE_PTR
 */
//--------------------------------------------------------------
FE_RIPPLE_PTR FE_RipplePtrGet( FE_SYS_PTR fes )
{
	return( fes->ripple );
}

//==============================================================================
//	3dAj
//==============================================================================
//--------------------------------------------------------------
/**
 * Ajt@Cǂݍ
 * @param
 * @retval
 */
//--------------------------------------------------------------
void * FE_3DAnime_FileLoad( u32 heap_id,
							const char *path,
							NNSG3dResMdl *pModel,
							NNSG3dAnmObj **pAnmObj,
							NNSG3dResTex *pTex,
							NNSFndAllocator *allocator )
{
	void *pFile;
    void *pAnmRes;
	
	GF_ASSERT( path != NULL && "FE_3DAnime_FileLoad()pathُ" );
	
	pFile = sys_LoadFile( heap_id,path );
	GF_ASSERT( pFile != NULL && "FE_3DAnime_FileLoad()pathُ" );
	
	pAnmRes = NNS_G3dGetAnmByIdx( pFile, 0 );	//CfbNX0 Aj\[X擾
	GF_ASSERT( pAnmRes != NULL && "FE_3DAnime_FileLoad()Res擾s" );
		
	*pAnmObj = NNS_G3dAllocAnmObj(allocator, pAnmRes, pModel );
	GF_ASSERT( pAnmObj != NULL && "FE_3DAnime_FileLoad()AP[gs" );
	
	NNS_G3dAnmObjInit( *pAnmObj, pAnmRes, pModel, pTex );
	
	return( pFile );
}

//--------------------------------------------------------------
/**
 * AP[^[
 * @param	alloc	NNSFndAllocator 
 * @param	heap_id	q[vID
 * @param	alignment		mۂ郁ubNɓKpACg
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_3DAnime_AllocatorInit( NNSFndAllocator *alloc, u32 heap_id, int alignment )
{
	sys_InitAllocator( alloc, heap_id, alignment );
}

//--------------------------------------------------------------
/**
 * Ajt[擾
 * @param	pAnmObj		NNSG3dAnmObj 
 * @retval	fx32		Ajt[ FX32_ONEP
 */
//--------------------------------------------------------------
fx32 FE_3DAnime_FrameGet( NNSG3dAnmObj *pAnmObj )
{
	return( NNS_G3dAnmObjGetNumFrame(pAnmObj) );
}

//--------------------------------------------------------------
/**
 * AjJ
 * @param	pAnmObj		NNSG3dAnmObj 
 * @oaram	alloc		NNSFndAllocator
 * @oaram	pFile		[ht@C@*
 * @oaram	heap_id		t@C[hɎgpq[vID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FE_3DAnime_Free( NNSG3dAnmObj *pAnmObj, NNSFndAllocator *alloc, void *pFile, u32 heap_id )
{
	NNS_G3dFreeAnmObj( alloc, pAnmObj );
	sys_FreeMemory( heap_id, pFile );
}

#if 0
//--------------------------------------------------------------
/**
 * eNX`f[^ǂݍ
 * @param	pTex		NNSG3dResTex 
 * @param	path		eNX`t@CpX
 * @param	heap_id		t@C[hɎgpq[vID
 * @retval	void*		[ht@C *
 */
//--------------------------------------------------------------
void * FE_3DAnime_TexGet( NNSG3dResTex **pTex, const char *path, u32 heap_id )
{
	void *pFile = sys_LoadFile( heap_id, path );
	*pTex = NNS_G3dGetTex( pFile );
	return( pFile );
}
#endif

