//==============================================================================
/**
 * @file	field_effect.h
 * @brief	tB[hGtFNg
 * @author	kagaya
 * @data	05.07.13
 */
//==============================================================================
#ifndef FIELD_EFFECT_H_FILE
#define FIELD_EFFECT_H_FILE

#include "field_effect_code.h"

#include "eoa.h"
#include "field_common.h"
#include "fieldobj.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
///	fobO
//--------------------------------------------------------------
#define DEBUG_NEW_BLACT_HOOK	//Vr{[hAN^[ɂ~

//--------------------------------------------------------------
///	r{[h@풓@]
//--------------------------------------------------------------
enum
{
	FE_BLACT_TEX_VRAM = 0,									///<eNX`VRAM풓
	FE_BLACT_TEX_TRANS,										///<eNX`]
};

//==============================================================================
//	typedef struct 
//==============================================================================
//--------------------------------------------------------------
// \*錾
//--------------------------------------------------------------
typedef struct _TAG_FE_SYS * FE_SYS_PTR;						///<FE_SYS_PTR
typedef struct _TAG_FE_SYS const * CONST_FE_SYS_PTR;			///<const FE_SYS_PTR
typedef struct _TAG_FE_BLACT * FE_BLACT_PTR;					///<FE_BLACT_PTR
typedef struct _TAG_FE_BLACT const * CONST_FE_BLACT_PTR;		///<const FE_BLACT_PTR

//==============================================================================
//	OQ
//==============================================================================
extern FE_SYS_PTR FE_Init( FIELDSYS_WORK *fsys, int heap_id, int eoa_max, int blact_max );
extern void FE_Delete( FE_SYS_PTR fes );
extern void FE_DeleteAll( FE_SYS_PTR fes );

extern void FE_Draw( FE_SYS_PTR fes );

extern int FE_HeapIDGet( CONST_FE_SYS_PTR fes );
extern FIELDSYS_WORK * FE_FieldSysWorkGet( CONST_FE_SYS_PTR fes );
extern EOA_SYS_PTR FE_EoaSysGet( CONST_FE_SYS_PTR fes );

extern FE_SYS_PTR FE_FieldSysWork_FE_SYS_PTR_Get( FIELDSYS_WORK *fsys );
extern FE_SYS_PTR FE_FieldOBJ_FE_SYS_PTR_Get( FIELD_OBJ_PTR fldobj );

extern BLACT_WORK_PTR FE_BlActAdd( FE_SYS_PTR fes, 
		const BLACT_HEADER *head, const VecFx32 *vec );
extern BLACT_WORK_PTR FE_BlActAddID( FE_SYS_PTR fes, int id, const VecFx32 *vec );
extern BLACT_HEADER * FE_BlActHeaderManageAdd(
	FE_SYS_PTR fes, int id, void *mdl, TEXANM_DATATBL *anm, void *tex, TEXRES_OBJ_PTR tex_key,
	const BLACT_ANIME_TBL *anm_tbl );
extern BLACT_HEADER * FE_BlActHeaderManageAddResmID(
		FE_SYS_PTR fes, int id, int mdl_id, int anm_id, int tex_id, int tex_flag,
		const BLACT_ANIME_TBL *anm_tbl );
extern BLACT_HEADER * FE_BlActHeaderManageGet( FE_SYS_PTR fes, int id );
extern void FE_BlActHeaderManageFree( FE_SYS_PTR fes, int id );

extern void FE_BlActResmAdd_Mdl( FE_SYS_PTR fes, int id, const char *path );
extern void * FE_BlActResmSearch_Mdl( FE_SYS_PTR fes, int id );
extern void FE_BlActResmDelete_Mdl( FE_SYS_PTR fes, int id );
extern void FE_BlActResmAdd_Anm( FE_SYS_PTR fes, int id, const char *path );
extern void * FE_BlActResmSearch_Anm( FE_SYS_PTR fes, int id );
extern void FE_BlActResmDelete_Anm( FE_SYS_PTR fes, int id );
extern void FE_BlActResmAdd_Tex( FE_SYS_PTR fes, int id, const char *path );
extern void * FE_BlActResmSearch_Tex( FE_SYS_PTR fes, int id );
extern TEXRES_OBJ_PTR FE_BlActResmSearch_TexOBJPtr( FE_SYS_PTR fes, int id );
extern void FE_BlActResmDelete_Tex( FE_SYS_PTR fes, int id );

extern void FE_VIntrTexLoadAdd( FE_SYS_PTR fes, int id, TEXRES_MANAGER_PTR resm );

extern EOA_PTR FE_EoaAddNpp( FE_SYS_PTR fes, const EOA_H_NPP *head,
		const VecFx32 *mtx, int prm, const void *ptr, int pri );

extern int FE_FldOBJ_TCBPriGet( CONST_FIELD_OBJ_PTR fldobj, int offset );
extern int FE_FldOBJ_CheckSameID( CONST_FIELD_OBJ_PTR fldobj, int obj_id, int zone_id );

extern void * FE_3DAnime_FileLoad( u32 heap_id,
							const char *path,
							NNSG3dResMdl *pModel,
							NNSG3dAnmObj **pAnmObj,
							NNSG3dResTex *pTex,
							NNSFndAllocator *allocator );

extern void FE_3DAnime_AllocatorInit( NNSFndAllocator *alloc, u32 heap_id, int alignment );
extern fx32 FE_3DAnime_FrameGet( NNSG3dAnmObj *pAnmObj );
extern void FE_3DAnime_Free(
		NNSG3dAnmObj *pAnmObj, NNSFndAllocator *alloc, void *pFile, u32 heap_id );

//==============================================================================
//	field_effect.h𗘗p֐include
//==============================================================================
#include "fldeff_shadow.h"
#include "fldeff_grass.h"
#include "fldeff_gyoe.h"
#include "fldeff_reflect.h"
#include "fldeff_trap.h"
#include "fldeff_hole.h"
#include "fldeff_dirtrap.h"
#include "fldeff_flag.h"
#include "fldeff_exclamation.h"
#include "fldeff_ok.h"
#include "fldeff_dbgornament.h"
#include "fldeff_elight.h"
#include "fldeff_footmark.h"
#include "fldeff_splash.h"
#include "fldeff_board.h"
#include "fldeff_seed.h"
#include "fldeff_snowball.h"
#include "fldeff_redframe.h"
#include "fldeff_arrow.h"
#include "fldeff_namipoke.h"
#include "fldeff_rockride.h"
#include "fldeff_ripple.h"

//==============================================================================
//	FE_SYS_PTRփNOvZXn̎QƊ֐
//==============================================================================
extern FE_SHADOW_PTR FE_ShadowPtrGet( FE_SYS_PTR fes );
extern FE_GRASS_PTR FE_GrassPtrGet( FE_SYS_PTR fes );
extern FE_GYOE_PTR FE_GyoePtrGet( FE_SYS_PTR fes );
extern FE_REFLECT_PTR FE_ReflectPtrGet( FE_SYS_PTR fes );
extern FE_TRAP_PTR FE_TrapPtrGet( FE_SYS_PTR fes );
extern FE_HOLE_PTR FE_HolePtrGet( FE_SYS_PTR fes );
extern FE_DIRTRAP_PTR FE_DirTrapPtrGet( FE_SYS_PTR fes );
extern FE_FLAG_PTR FE_FlagPtrGet( FE_SYS_PTR fes );
extern FE_EXCLAMATION_PTR FE_ExclamationPtrGet( FE_SYS_PTR fes );
extern FE_OK_PTR FE_OkPtrGet( FE_SYS_PTR fes );
extern FE_DBGORNAMENT_PTR FE_DbgOrnamentPtrGet( FE_SYS_PTR fes );
extern FE_ELIGHT_PTR FE_ELightPtrGet( FE_SYS_PTR fes );
extern FE_FOOTMARK_PTR FE_FootMarkPtrGet( FE_SYS_PTR fes );
extern FE_SPLASH_PTR FE_SplashPtrGet( FE_SYS_PTR fes );
extern FE_BOARD_PTR FE_BoardPtrGet( FE_SYS_PTR fes );
extern FE_SEEDGROUND_PTR FE_SeedGroundPtrGet( FE_SYS_PTR fes );
extern FE_SNOWBALL_PTR FE_SnowBallPtrGet( FE_SYS_PTR fes );
extern FE_REDFRAME_PTR FE_RedFramePtrGet( FE_SYS_PTR fes );
extern FE_ARROW_PTR FE_ArrowPtrGet( FE_SYS_PTR fes );
extern FE_NAMIPOKE_PTR FE_NamiPokePtrGet( FE_SYS_PTR fes );
extern FE_ROCKRIDE_PTR FE_RockRidePtrGet( FE_SYS_PTR fes );
extern FE_RIPPLE_PTR FE_RipplePtrGet( FE_SYS_PTR fes );

#endif //FIELD_EFFECT_H_FILE
