//============================================================================================
/**
 * @file	field_encount.c
 * @brief	tB[hGJEg`FbNN
 * @date	2005.07.28
 * @author	tamada		plĂ
 *
 * 2005.12.18	GJEg`FbN폜Aencount_set.cɈړ
 */
//============================================================================================

#include "common.h"
#include "fieldsys.h"
#include "field_event.h"

#include "field_encount.h"
#include "encount_effect.h"
#include "encount_set.h"

#include "ev_mapchange.h"

#include "system/snd_tool.h"
#include "fld_bgm.h"

//#include "system/brightness.h"
//#include "fieldmap.h"
//#include "map_tool.h"
//#include "mapdefine.h"
//#include "poketool/monsno.h"
//#include "eventdata.h"
#include "sway_grass_enc.h"
//#include "map_attr.h"

#include "poketool/tr_tool.h"

#include "mapdata_warp.h"			//WARPDATA_GetRevivalLocation
#include "situation_local.h"		//Situation_Get`
#include "system/brightness.h"
#include "script.h"
#include "scr_tool.h"
#include "mapdefine.h"
#include "..\fielddata\script\common_scr_def.h"		//SCRID_GAME_OVER_RECOVER_PC

#ifdef PM_DEBUG
static int debug_12rom_sway_flg;		//12/22p
#endif
//============================================================================================
//============================================================================================





//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static inline int DmyEffNo(void)
{
	return gf_mtRand() % ENCOUNT_NUM;
}

//============================================================================================
//
//
//	Cxg[R}hF퓬
//
//
//============================================================================================
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL GMEVENT_Sub_BattleProc(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	BATTLE_PARAM * battle_param = FieldEvent_GetSpecialWork(event);
	int *seq = FieldEvent_GetSeqWork(event);
	switch (*seq) {
	case 0:
		//퓬vZXo^
		FieldBattle_SetProc(fsys, battle_param);
		(*seq) ++;
		break;
	case 1:
		//TuvZXi퓬jI҂
		if (FieldEvent_Cmd_WaitSubProcEnd(fsys)) {
			break;
		}
		return TRUE;
	}
	return FALSE;
}

//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF퓬Ăяo
 * @param	event			Cxg䃏[Nւ̃|C^
 * @param	battle_param	퓬pp[^ւ̃|C^
 * 
 * ƂĎ󂯎BATTLE_PARAM͉܂B
 * ĂяoŊǗĂB
 */
//-----------------------------------------------------------------------------
void EventCmd_BattleProc(GMEVENT_CONTROL * event, BATTLE_PARAM * battle_param)
{
	FieldEvent_Call(event, GMEVENT_Sub_BattleProc, battle_param);
}


//============================================================================================
//
//
//	CxgR}hF|PGJEgĂяo
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
typedef struct {
	BOOL * win_flag;
	BOOL lose_blanch_flag;
	int effect_no;
	int bgm_no;
	BATTLE_PARAM	*battle_param;
}EV_BATTLE_WORK;

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
static EV_BATTLE_WORK * EBW_Create(BATTLE_PARAM * param, int effect_no, int bgm_no,
		BOOL * win_flag, BOOL lose_blanch_flag)
{
	EV_BATTLE_WORK * ebw;
	ebw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_BATTLE_WORK));
	ebw->win_flag = win_flag;
	if (win_flag) {
		*(ebw->win_flag) = FALSE;
	}
	ebw->lose_blanch_flag = lose_blanch_flag;
	ebw->effect_no = effect_no;
	ebw->bgm_no = bgm_no;
	ebw->battle_param = param;
	return ebw;
}

//-----------------------------------------------------------------------------
/**
 * @brief
 * @param	ebw			퓬V[PX[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static BOOL EBW_CheckResult(EV_BATTLE_WORK * ebw)
{
	BOOL win_flag;

	switch (ebw->battle_param->win_lose_flag) {
	case FIGHT_LOSE:
	case FIGHT_DRAW:
		win_flag = FALSE; //Ƃ̏
		break;
	default:
		win_flag = TRUE;	 //Ƃ̏
		break;
	}

	if (ebw->win_flag != NULL) {
		*(ebw->win_flag) = win_flag;
	}
#ifdef PM_DEBUG
	//12/22p
	debug_12rom_sway_flg = ebw->battle_param->win_lose_flag;
#endif
	return win_flag;
}

//-----------------------------------------------------------------------------
/**
 * @brief	og̃p[^f
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	ebw			퓬V[PX[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
static void UpdateBattleResult(GMEVENT_CONTROL * event, EV_BATTLE_WORK * ebw)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);

	if (ebw->battle_param->fight_type & FIGHT_TYPE_DEBUG) {
		//fobOΐł͎莝̏Ȃ
		return;
	}
	if (ebw->win_flag) {
		//ꍇ
		BattleParam_UpdateGameData(ebw->battle_param, fsys);
		//SetPokePartyToMyPokemon(fsys, ebw->battle_param);
	} else {
		//skꍇ
	}

}

//-----------------------------------------------------------------------------
/**
 * @brief	ʏ퓬FSŃV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_NormalGameOver(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	int * seq;
	fsys = FieldEvent_GetFieldSysWork(event);
	seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		//[vIDŎw肳ꂽ߂
		{
			LOCATION_WORK next;
			u16 warp_id = Situation_GetWarpID(SaveData_GetSituation(fsys->savedata));
			WARPDATA_GetRevivalLocation(warp_id, &next);
			EventCmd_MapChangeByLocation(event, &next);
		}
		(*seq) ++;
		break;

	case 1:
		//BGMtF[hAEg
		Snd_BgmFadeOut( 0, 20 );
		(*seq) ++;
		break;

	case 2:
		//BGMtF[hAEg҂
		if( Snd_FadeCheck() == 0 ){

			//CxgR}hFtB[h}bvvZXA
			EventCmd_StartFieldMap(event);

			//TEhQ[I[o[
			Snd_GameOverSet();
		
			//PxubN
			SetBrightness( BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY);

			(*seq) ++;
		}
		break;

	case 3:
		//Q[I[o[x
		GameOverCall( fsys, event );
		(*seq) ++;
		break;

	case 4:
		//CĂ˃XNvg
		
		//bΏۂOBJ擾鏈KvɂȂ
		OS_Printf( "field_encount zone_id = %d\n", fsys->location->zone_id );
		if( fsys->location->zone_id == ZONE_ID_T01R0101 ){
			EventCall_Script( event, SCRID_GAME_OVER_RECOVER_MYHOME, NULL, NULL );
		}else{
			EventCall_Script( event, SCRID_GAME_OVER_RECOVER_PC, NULL, NULL );
		}
		(*seq) ++;
		break;

	case 5:
		//TEhX^[g
		Snd_RestartSet( fsys );

		return TRUE;
	}
	return FALSE;
}


//-----------------------------------------------------------------------------
/**
 * @brief	ʏ퓬CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * GJEgGtFNg퓬tB[hAsB
 * Q[I[o[ւ̕i\j
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_NormalBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_BATTLE_WORK * ebw;
	int * seq;
	fsys = FieldEvent_GetFieldSysWork(event);
	ebw = FieldEvent_GetSpecialWork(event);
	seq = FieldEvent_GetSeqWork(event);

	switch (*seq) {
	case 0:
		// CxgR}hFGJEgGtFNgĂяo
		EventCmd_EncountEffect(event, ebw->effect_no, ebw->bgm_no);
		(*seq) ++;
		break;
	case 1:
		//CxgR}hFtB[h}bvvZXI
		EventCmd_FinishFieldMap(event);
		(*seq) ++;
		break;
	case 2:
		//CxgR}hF퓬vZX
		EventCmd_BattleProc(event, ebw->battle_param);
		(*seq) ++;
		break;

	case 3:
		//퓬Ȉ
		if (ebw->lose_blanch_flag && EBW_CheckResult(ebw) == FALSE) {

			//ogp[^j
			BattleParam_Delete(ebw->battle_param);

			//Sł̏ꍇ͂ŏI
			sys_FreeMemoryEz(ebw);
			return TRUE;
		}
		UpdateBattleResult(event, ebw);

		//ogp[^j
		BattleParam_Delete(ebw->battle_param);
		
		//CxgR}hFtB[h}bvvZXA
		EventCmd_StartFieldMap(event);
		(*seq) ++;
		break;
	case 4:
		//CxgR}hFtF[hC
		EventCmd_FieldFadeIn(event);
		(*seq) ++;
		break;
	case 5:
		sys_FreeMemoryEz(ebw);
		return TRUE;
		break;
	}
	return FALSE;
}


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static void EventCmd_NormalBattle(GMEVENT_CONTROL * event,
		BATTLE_PARAM * param, int effect_no, int bgm_no, BOOL * win_flag)
{
	EV_BATTLE_WORK * ebw;
	ebw = EBW_Create(param, effect_no, bgm_no, win_flag, TRUE);
	FieldEvent_Call(event, GMEVENT_NormalBattle, ebw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	CxgR}hFʏSŏ
 * @param	event		Cxg䃏[Nւ̃|C^
 */
//-----------------------------------------------------------------------------
void EventCmd_NormalLose(GMEVENT_CONTROL * event)
{
	FieldEvent_Call(event, GMEVENT_NormalGameOver, NULL);
}
























//============================================================================================
//
//
//				쐶GJEg
//
//
//============================================================================================
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
typedef struct {
	int seq;
	BOOL win_flag;
	BATTLE_PARAM	*battle_param;
}EV_WILD_BATTLE_WORK;


static BOOL GMEVENT_NormalWildBattle(GMEVENT_CONTROL * event);

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
void FieldEncount_Set(FIELDSYS_WORK * fsys, BATTLE_PARAM *ioBattleParam)
{
	EV_WILD_BATTLE_WORK *ewbw;
	
	ewbw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_WILD_BATTLE_WORK));
	ewbw->battle_param = ioBattleParam;
	ewbw->seq = 0;
	
	FieldEvent_Set(fsys, GMEVENT_NormalWildBattle,ewbw);
}

//-----------------------------------------------------------------------------
/**
 * @brief	ʏ쐶CxgV[PX
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		CxgI
 * @retval	FALSE		Cxgp
 *
 * TuCxgƂāAʏ퓬CxgV[PXR[
 * 
 */
//-----------------------------------------------------------------------------
static BOOL GMEVENT_NormalWildBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys;
	EV_WILD_BATTLE_WORK *ewbw;
	fsys = FieldEvent_GetFieldSysWork(event);
	ewbw = FieldEvent_GetSpecialWork(event);

	switch (ewbw->seq) {
	case 0:
		EventCmd_NormalBattle(event, ewbw->battle_param,
				DmyEffNo(), Snd_BattleBgmGet(ewbw->battle_param->fight_type), &ewbw->win_flag);
		ewbw->seq++;
		break;
	case 1:
		//sk
		if (ewbw->win_flag == FALSE) {
			//ʏskɃCxgؑ
			sys_FreeMemoryEz(ewbw);
			FieldEvent_Change(event, GMEVENT_NormalGameOver, NULL);
			return FALSE;
		}
		//ꑐ
		//퓬Ĩ^Cv𒲂ׂāAߊlȂAꑐZbg
		if ( (!(debug_12rom_sway_flg==FIGHT_WIN)) && 
				(!(debug_12rom_sway_flg==FIGHT_POKE_GET)) ){
			//hꑐZbg
			SwayGrass_InitSwayGrass(fsys->SwayGrass);
			ewbw->seq++;
			break;
		}
		if (SwayGrass_IsSwayEncRetern(fsys->SwayGrass)){
			int x,z;
			x = Player_NowGPosXGet(fsys->player);
			z = Player_NowGPosZGet(fsys->player);
			//GJEgꏊ{
			SwayGrass_SearchSwayGrass(fsys, x, z, debug_12rom_sway_flg, fsys->SwayGrass);
			//Zbg
			SwayGrass_SetSwayGrassAnime(fsys, fsys->SwayGrass);
		}
		ewbw->seq++;
		break;
	case 2:
		if (SwayGrass_CheckSwayGrassAnimeEnd(fsys->SwayGrass)){
			sys_FreeMemoryEz(ewbw);
			return TRUE;
		}

/**		
		if (FE_EncGrass_AnimeCheck( ewbw->Grass[0] )){
			EOA_Delete( ewbw->Grass[0] );
			sys_FreeMemoryEz(ewbw);
			return TRUE;
		}
*/		
		break;
	}
	return FALSE;
}

//============================================================================================
//
//
//				hGJEg
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFhGJEg
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	win_flag	퓬ʂ󂯎tO
 */
//-----------------------------------------------------------------------------
void EventCmd_HoneyTreeBattle(GMEVENT_CONTROL * event, BOOL * win_flag)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *param;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_YASEI);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);
	//hGJEgf[^Zbg
	SetHoneyTreeEncountData(fsys, param);

	EventCmd_NormalBattle(event, param, DmyEffNo(), Snd_BattleBgmGet(FIGHT_TYPE_YASEI), win_flag);
}


//============================================================================================
//
//
//				|Pio[ƃxw肵Ė쐶(XNvgŎgp)
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hF|Pio[ƃxw肵Ė쐶
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	monsno		|Pio[
 * @param	level		x
 * @param	win_flag	퓬ʂ󂯎tO
 */
//-----------------------------------------------------------------------------
void EventCmd_WildBattle(GMEVENT_CONTROL * event, u16 monsno, u8 level, BOOL * win_flag)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *param;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_YASEI);

	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	//GJEgf[^Zbg
	SetWildEncountData(fsys, monsno, level, param);

	/*
	//@battle_status_flag
	//	ɃZbg悤ɂI
	*/

	/*
		ACe̎w肪KvH
	*/

	EventCmd_NormalBattle(event, param, DmyEffNo(), Snd_BattleBgmGet(FIGHT_TYPE_YASEI), win_flag);
}


//============================================================================================
//
//
//						ŏ̃Cxg(XNvgŎgp)
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFŏ̃Cxg
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	monsno		|Pio[
 * @param	level		x
 * @param	win_flag	퓬ʂ󂯎tO
 */
//-----------------------------------------------------------------------------
void EventCmd_FirstBattle(GMEVENT_CONTROL * event, u16 monsno, u8 level, BOOL * win_flag)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *param;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_YASEI);

	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	//GJEgf[^Zbg
	SetWildEncountData(fsys, monsno, level, param);

	//퓬ptO
	param->battle_status_flag = BATTLE_STATUS_FLAG_FIRST_BATTLE;

	/*
		ACe̎w肪KvH
	*/

	//EventCmd_NormalBattle(event, param, DmyEffNo(), Snd_BattleBgmGet(FIGHT_TYPE_YASEI), win_flag);
	{
		EV_BATTLE_WORK * ebw;
		ebw = EBW_Create(param, DmyEffNo(), Snd_BattleBgmGet(FIGHT_TYPE_YASEI), win_flag, FALSE);
		FieldEvent_Call(event, GMEVENT_NormalBattle, ebw);
	}
}


//============================================================================================
//
//
//				g[i[ΐ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFg[i[ΐ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	trainer_id	g[i[wf[^
 * @param	fight_type	퓬
 * @param	heapID		q[vID
 * @param	win_flag	퓬ʂ󂯎tO
 */
//-----------------------------------------------------------------------------
void EventCmd_TrainerBattle(GMEVENT_CONTROL * event, int tr_id_0, int tr_id_1, u32 fight_type,
		int heapID, BOOL * win_flag)
{
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *param;
	FIELDSYS_WORK * fsys;

	fsys = FieldEvent_GetFieldSysWork(event);

	/* Ƃ肠̃g[i[Ȃ̂Ŗ쐶̃p[^ŐFX㏑ */

	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_WORLD, fight_type);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	param->trainer_id[0] = tr_id_0;
	param->trainer_id[1] = tr_id_1;
	//g[i[f[^
	TT_EncountTrainerDataMake( param, heapID );

	EventCmd_NormalBattle(event, param, DmyEffNo(), Snd_BattleBgmGet(fight_type), win_flag);
}

//============================================================================================
//
//
//				ʐMΐ
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 * @brief	ʐMΐCxgZbg
 * @param	event
 */
//-----------------------------------------------------------------------------
void EventCmd_CommBattle(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_BATTLE_WORK * ebw;
	BATTLE_PARAM *param;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_SIO);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	ebw = EBW_Create(param, 1, Snd_BattleBgmGet(FIGHT_TYPE_1vs1_SIO), NULL, FALSE);
	FieldEvent_Call(event, GMEVENT_NormalBattle, ebw);
}

//============================================================================================
//
//
//			fobOp
//
//
//============================================================================================
//-----------------------------------------------------------------------------
/**
 *	fobOp
 */
//-----------------------------------------------------------------------------
BOOL DebugFieldEncount(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM *param;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_EVENT, FIGHT_TYPE_DEBUG|FIGHT_TYPE_1vs1);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	//Ƃ肠ɒnGJEgf[^Zbg
	DebugSetEncountData( NULL, GROUND_ENCOUNT, 0, param );
	
	FieldEncount_Set(fsys, param);

	return TRUE;
}
//-----------------------------------------------------------------------------
/**
 *	fobOp
 */
//-----------------------------------------------------------------------------
BOOL DebugFieldEncount2vs2(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM *param;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_EVENT, FIGHT_TYPE_2vs2_TRAINER|FIGHT_TYPE_DEBUG);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	param->trainer_id[0]=gf_rand()%16+1;
	//g[i[f[^
	TT_EncountTrainerDataMake(param,HEAPID_WORLD);

	FieldEncount_Set(fsys, param);

	return TRUE;
}
//-----------------------------------------------------------------------------
/**
 *	fobOp
 */
//-----------------------------------------------------------------------------
BOOL DebugFieldTrainerEncount(FIELDSYS_WORK * fsys)
{
	BATTLE_PARAM *param;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_TRAINER|FIGHT_TYPE_DEBUG);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	param->trainer_id[0]=gf_rand()%247+1;
	//g[i[f[^
	TT_EncountTrainerDataMake(param,HEAPID_WORLD);

	FieldEncount_Set(fsys, param);

	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 */
//-----------------------------------------------------------------------------
void SioEncount_Set(FIELDSYS_WORK * fsys, BATTLE_PARAM *ioBattleParam)
{
	EV_WILD_BATTLE_WORK *ewbw;
	
	ewbw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EV_WILD_BATTLE_WORK));
	ewbw->battle_param = ioBattleParam;
	ewbw->seq = 0;
	
	FieldEvent_Call(fsys->event, GMEVENT_NormalWildBattle,ewbw);
}

//-----------------------------------------------------------------------------
/**
 *	fobOp
 */
//-----------------------------------------------------------------------------
BOOL DebugSioEncount(FIELDSYS_WORK * fsys)
{
	EventCmd_CommBattle(fsys->event);
#if 0
	BATTLE_PARAM *param;
	//ogp[^̃AP[Vƃ|Pp[eB̏
	param = BattleParam_Create(HEAPID_WORLD, FIGHT_TYPE_1vs1_SIO);
	//莝|PȂǃZbg
	BattleParam_SetParamByGameData(param, fsys);

	//Ƃ肠ɒnGJEgf[^Zbg
	DebugSetEncountData( NULL, GROUND_ENCOUNT, 0, param );
	
	SioEncount_Set(fsys, param);
#endif

	return TRUE;
}

