//============================================================================================
/**
 * @file	field_encount.h
 * @brief
 * @date	2005.07.28
 */
//============================================================================================

#ifndef	__FIELD_ENCOUNT_H__
#define __FIELD_ENCOUNT_H__

#include "battle/battle_common.h"
#include "field_event.h"

extern void FieldEncount_Set(FIELDSYS_WORK * fsys, BATTLE_PARAM * param);
extern BOOL FieldEncount_Check(FIELDSYS_WORK * fsys);
extern void FieldBattle_SetProc(FIELDSYS_WORK * fsys, BATTLE_PARAM * param);

extern void EventCmd_NormalLose(GMEVENT_CONTROL * event);
extern void EventCmd_EncountEffect(GMEVENT_CONTROL * event, int effect_no, int bgm_no);
extern void EventCmd_BattleProc(GMEVENT_CONTROL * event, BATTLE_PARAM * battle_param);
extern void EventCmd_TrainerBattle(GMEVENT_CONTROL * event, int tr_id_0, int tr_id_1,
		u32 fight_type, int heapID, BOOL * win_flag);
extern void EventCmd_HoneyTreeBattle(GMEVENT_CONTROL * event, BOOL * win_flag);
extern void EventCmd_WildBattle(GMEVENT_CONTROL * event, u16 monsno, u8 level, BOOL * win_flag);
extern void EventCmd_FirstBattle(GMEVENT_CONTROL * event, u16 monsno, u8 level, BOOL * win_flag);

extern void EventCmd_CommBattle(GMEVENT_CONTROL * event);

#ifdef	PM_DEBUG
extern BOOL DebugFieldEncount(FIELDSYS_WORK * fsys);
extern BOOL DebugFieldEncount2vs2(FIELDSYS_WORK * fsys);
extern BOOL DebugFieldTrainerEncount(FIELDSYS_WORK * fsys);
extern BOOL DebugSioEncount(FIELDSYS_WORK * fsys);
#endif
#endif	/* __FIELD_ENCOUNT_H__ */

