//=============================================================================
/**
 * @file	field_event.c
 * @brief	tB[hCxg
 * @author	tamada
 * @date	2005.07.22
 */
//=============================================================================

#include "common.h"
#include "fieldsys.h"

#include "field_event.h"

//=============================================================================
//=============================================================================
enum {
	HEAPID_LOCAL = HEAPID_EVENT,
};
//-----------------------------------------------------------------------------
/**
 * Q[CxgRg[p[N`
 */
//-----------------------------------------------------------------------------
typedef struct _GMEVENT_CONTROL{
	GMEVENT_CONTROL * parent;
	GMEVENT_FUNC	func;	///<֐ւ̃|C^
	int seq;				///<V[PX[N
	void * work;			///<֐ɌŗL[Nւ̃|C^
	int lwk_size;
	void * lwk;
	FIELDSYS_WORK * repw;	///<tB[hS̐䃏[Nւ̃|C^iȂׂQƂȂj
	EVENT_WORK * event_work;	///<CxgŎgp郏[N
};

//=============================================================================
//=============================================================================
//------------------------------------------------------------------
/**
 * @brief	Cxg
 * @param	repw
 * @param	event_func	Cxg֐ւ̃|C^
 * @param	work		Cxg֐̎gp郏[Nւ̃|C^
 * @return	GMEVENT_CONTROL	Cxgւ̃|C^
 *
 */
//------------------------------------------------------------------
static GMEVENT_CONTROL * Event_Create(FIELDSYS_WORK * repw, GMEVENT_FUNC event_func, void * work)
{
	GMEVENT_CONTROL * event;
	event = sys_AllocMemoryLo(HEAPID_LOCAL, sizeof(GMEVENT_CONTROL));
	event->parent = NULL;
	event->func = event_func;
	event->seq = 0;
	event->work = work;
	event->lwk_size = 0;
	event->lwk = NULL;
	event->repw = repw;
	event->event_work = sys_AllocMemoryLo(HEAPID_LOCAL, sizeof(EVENT_WORK));
	return event;
}

//------------------------------------------------------------------
/**
 * @brief	Cxgݒ
 * @param	repw
 * @param	event_func	Cxg֐ւ̃|C^
 * @param	work		Cxg֐̎gp郏[Nւ̃|C^
 * @return	GMEVENT_CONTROL	Cxg
 */
//------------------------------------------------------------------
GMEVENT_CONTROL * FieldEvent_Set(FIELDSYS_WORK * repw, GMEVENT_FUNC event_func, void * work)
{
	GMEVENT_CONTROL * event;
	GF_ASSERT(repw->event == NULL);
	GF_ASSERT((sys_GetHeapState(HEAPID_LOCAL) >> 32) == 0);
	event = Event_Create(repw, event_func, work);
	repw->event = event;
	return event;
}
//------------------------------------------------------------------
/**
 * @brief	Cxgؑ
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	next_func	̃Cxg֐ւ̃|C^
 * @param	work		̃Cxg֐̎gp郏[Nւ̃|C^
 */
//------------------------------------------------------------------
void FieldEvent_Change(GMEVENT_CONTROL * event, GMEVENT_FUNC next_func, void * work)
{
	event->func = next_func;
	event->seq = 0;
	event->work = work;
	if (event->lwk != 0 || event->lwk != NULL) {
		sys_FreeMemoryEz(event->lwk);
		event->lwk_size = 0;
		event->lwk = NULL;
	}
}
//------------------------------------------------------------------
/**
 * @brief	TuCxgĂяo
 * @param	parent		eCxgւ̃|C^
 * @param	event_func	Cxg֐ւ̃|C^
 * @param	work		Cxg֐̎gp郏[Nւ̃|C^
 * @return	GMEVENT_CONTROL	Cxg
 *
 * CxgTuCxg̃R[Ăяo
 */
//------------------------------------------------------------------
GMEVENT_CONTROL * FieldEvent_Call(GMEVENT_CONTROL * parent, GMEVENT_FUNC sub_func, void * work)
{
	GMEVENT_CONTROL * event;
	event = Event_Create(parent->repw, sub_func, work);
	event->parent = parent;
	parent->repw->event = event;
	return event;
}

//=============================================================================
//=============================================================================
//------------------------------------------------------------------
/**
 * @brief	Cxg
 * @param	repw
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 */
//------------------------------------------------------------------
BOOL FieldEvent_Control(FIELDSYS_WORK * fsys)
{
	if (fsys->event == NULL) {
		return FALSE;
	}
	while (fsys->event->func(fsys->event) == TRUE) {
		GMEVENT_CONTROL * parent;
		parent = fsys->event->parent;
		if (fsys->event->lwk) {
			sys_FreeMemoryEz(fsys->event->lwk);
		}
		sys_FreeMemoryEz(fsys->event->event_work);
		sys_FreeMemoryEz(fsys->event);
		fsys->event = parent;
		if (parent == NULL) {
			GF_ASSERT((sys_GetHeapState(HEAPID_LOCAL) >> 32) == 0);
			return TRUE;
		}
	}
	return FALSE;
}

//------------------------------------------------------------------
/**
 * @brief	CxgN`FbN
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	CxgN
 * @retval	FALSE	CxgȂ
 */
//------------------------------------------------------------------
BOOL FieldEvent_Check(FIELDSYS_WORK * fsys)
{
	return (fsys->event != NULL);
}

//=============================================================================
//
//	CxgR}h
//
//=============================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------

//------------------------------------------------------------------
/**
 * @brief	TuvZXI҂
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @retval	TRUE	TuvZX쒆
 * @retval	FALSE	TuvZXI
 */
//------------------------------------------------------------------
BOOL FieldEvent_Cmd_WaitSubProcEnd(FIELDSYS_WORK * fsys)
{
	if (GameSystem_CheckFieldProcExists(fsys) || GameSystem_CheckSubProcExists(fsys)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//------------------------------------------------------------------
//------------------------------------------------------------------
void FieldEvent_Cmd_SetMapProc(FIELDSYS_WORK * fsys)
{
	GameSystem_CreateFieldProc(fsys);
}

//------------------------------------------------------------------
//------------------------------------------------------------------
BOOL FieldEvent_Cmd_WaitMapProcStart(FIELDSYS_WORK * fsys)
{
	if (GameSystem_CheckFieldMain(fsys)) {
		return TRUE;
	} else {
		return FALSE;
	}
}

//=============================================================================
//
//=============================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
typedef struct {
	int seq;
	const PROC_DATA * proc_data;
	void * param;
}EV_SUBPROC_WORK;
//------------------------------------------------------------------
/**
 * @brief	TuCxgFTuvZXĂяo
 * @param	event		Cxg䃏[Nւ̃|C^
 * @retval	TRUE		TuCxgI
 * @retval	FALSE		TuCxgp
 */
//------------------------------------------------------------------
static BOOL GMEVENT_Sub_CallSubProc(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	EV_SUBPROC_WORK * esw = FieldEvent_GetSpecialWork(event);
	switch (esw->seq) {
	case 0:
		GameSystem_StartSubProc(fsys, esw->proc_data, esw->param);
		esw->seq ++;
		break;
	case 1:
		if (FieldEvent_Cmd_WaitSubProcEnd(fsys)) {
			break;
		}
		sys_FreeMemoryEz(esw);
		return TRUE;
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFTuvZXĂяo
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	proc_data	vZX`f[^ւ̃|C^
 * @param	param		p[^ւ̃|C^
 *
 * TuvZXĂяoďI҂
 */
//------------------------------------------------------------------
void EventCmd_CallSubProc(GMEVENT_CONTROL * event, const PROC_DATA * proc_data, void * param)
{
	EV_SUBPROC_WORK * esw = sys_AllocMemoryLo(HEAPID_LOCAL, sizeof(EV_SUBPROC_WORK));
	esw->seq = 0;
	esw->proc_data = proc_data;
	esw->param = param;
	FieldEvent_Call(event, GMEVENT_Sub_CallSubProc, esw);
}

//=============================================================================
//
//
//
//=============================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[h䃏[Nւ̃|C^擾
 * @param	event		Cxg䃏[Nւ̃|C^
 * @return	FIELDSYS_WORK	tB[h䃏[Nւ̃|C^
 *
 * tB[h䃏[N̓tB[hł͍ŏʂ̃[NGAƂȂB
 * ̗̈ɒڎQƂ邱Ƃ́utB[hł̃O[oϐւ̃ANZXv
 * BO[oϐւ̃ANZX͂ȂׂׂȂ̂ŁÅ֐
 * ȂׂgpȂ悤ɂB
 *
 * ܂̓vO\TOIɐ؂蕪邱ƂD悷邽߁A
 * {IɕKvȕϐȂǂւ̃ANZX͊֐oRɂB
 * ̏ŕsvȂ͍̂폜ĂAxIȖ肪ꍇ̓|C^ڎQƂ
 * lB
 *
 */
//------------------------------------------------------------------
FIELDSYS_WORK * FieldEvent_GetFieldSysWork(GMEVENT_CONTROL * event)
{
	return event->repw;
}

//------------------------------------------------------------------
/**
 * @brief	tB[hCxgʂ̃[Nւ̃|C^
 * @param	event		Cxg䃏[Nւ̃|C^
 * @return	eCxgp[N
 */
//------------------------------------------------------------------
void * FieldEvent_GetSpecialWork(GMEVENT_CONTROL * event)
{
	return event->work;
}

//------------------------------------------------------------------
/**
 * @brief	V[PX[N̎擾
 * @param	event		Cxg䃏[Nւ̃|C^
 * @return	V[PX[Nւ̃|C^
 */
//------------------------------------------------------------------
int * FieldEvent_GetSeqWork(GMEVENT_CONTROL * event)
{
	return &event->seq;
}
//------------------------------------------------------------------
/**
 * @brief	[J[N̎擾
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	size		[J[ÑTCYw	
 * @return	void*		[J[Nւ̃|C^
 *
 * ̃Cxg甲ƂɎ郏[N擾łB
 * CxgIAуCxgؑցiFieldEvent_Changej̃^C~O
 * B
 */
//------------------------------------------------------------------
void * FieldEvent_GetLocalWork(GMEVENT_CONTROL * event, int size)
{
	if (event->lwk == NULL && event->lwk_size == 0) {
		event->lwk_size = size;
		event->lwk = sys_AllocMemoryLo(HEAPID_LOCAL, size);
		MI_CpuClear8(event->lwk, size);
	} else {
		GF_ASSERT(event->lwk_size == size);
	}
	return event->lwk;
}

//------------------------------------------------------------------
/**
 * @brief	CxgŎgp郏[N擾
 * @param	fsys	tB[VXe
 * @return	Cxgp[N
 */
//------------------------------------------------------------------
EVENT_WORK * Event_GetEventWork(FIELDSYS_WORK * fsys)
{
	return fsys->event->event_work;
}


//------------------------------------------------------------------
/**
 * @brief	bOBJ擾
 * @param	event		Cxg䃏[Nւ̃|C^
 * @return	bOBJ
 */
//------------------------------------------------------------------
#if 0
FIELD_OBJ_PTR Event_GetTargetObj( GMEVENT_CONTROL * event )
{
	return event->event_work->targetobj;
}
#endif

//------------------------------------------------------------------
/**
 * @brief	bBG擾
 * @param	event		Cxg䃏[Nւ̃|C^
 * @return	bBG
 */
//------------------------------------------------------------------
u32 Event_GetTargetBg( GMEVENT_CONTROL * event )
{
	return event->event_work->targetbg;
}

