//============================================================================================
/**
 * @file	field_gimmick.c
 * @brief	}bvŗL̎d|𔭓邩ǂ𔻒肷\[X
 * @author	saito
 * @date	2006.02.09
 *
 */
//============================================================================================

#include "include/savedata/gimmickwork.h"
#include "field_gimmick_def.h"
#include "field_gimmick.h"
#include "gym.h"
#include "fieldsys.h"		//for	GameSystem_GetSaveData

const static FLD_GMK_SETUP_FUNC FldGimmickSetupFunc[FLD_GIMMICK_MAX] = {
	NULL,					//0:
	GYM_SetupWaterGym,		//1:W
	GYM_SetupGhostGym,		//2:S[XgW
	GYM_SetupSteelGym,		//3:|W
};

const static FLD_GMK_END_FUNC FldGimmickEndFunc[FLD_GIMMICK_MAX] = {
	NULL,					//0:
	NULL,					//1:W
	NULL,					//2:S[XgW
	GYM_EndSteelGym,		//3:|W	
};

const static FLD_GMK_HIT_CHECK FldGimmickHitCheck[FLD_GIMMICK_MAX] = {
	NULL,					//0:
	NULL,					//1:W
	NULL,					//2:S[XgW
	GYM_HitCheckSteelGym,	//3:|W
};

//---------------------------------------------------------------------------
/**
 * @brief	M~bÑZbgAbv֐
 * 
 * @param	fsys	tB[hVXe|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void FLDGMK_SetUpFieldGimmick(FIELDSYS_WORK *fsys)
{
	int id;
	GIMMICKWORK *work;
	//M~bN[N擾
	work = SaveData_GetGimmickWork(GameSystem_GetSaveData(fsys));
	//M~bNR[h擾
	id = GIMMICKWORK_GetAssignID(work);
	
	if (id == FLD_GIMMICK_NONE){
		return;					//M~bN
	}
	//M~bNZbgAbv
	FldGimmickSetupFunc[id](fsys);
}

//---------------------------------------------------------------------------
/**
 * @brief	M~bN̏I֐
 * 
 * @param	fsys	tB[hVXe|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void FLDGMK_EndFieldGimmick(FIELDSYS_WORK *fsys)
{
	int id;
	GIMMICKWORK *work;
	//M~bN[N擾
	work = SaveData_GetGimmickWork(GameSystem_GetSaveData(fsys));
	//M~bNR[h擾
	id = GIMMICKWORK_GetAssignID(work);
	
	if (id == FLD_GIMMICK_NONE){
		return;					//M~bN
	}
	//M~bNI
	if (FldGimmickEndFunc[id] != NULL){
		FldGimmickEndFunc[id](fsys);
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	M~bNpꓖ蔻菈
 * 
 * @param	fsys	tB[hVXe|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
BOOL FLDGMK_FieldGimmickHitCheck(	FIELDSYS_WORK *fsys,
									const int inGridX, const int inGridZ,
									const fx32 inHeight,
									BOOL *outHit)
{
	int id;
	GIMMICKWORK *work;
	//M~bN[N擾
	work = SaveData_GetGimmickWork(GameSystem_GetSaveData(fsys));
	//M~bNR[h擾
	id = GIMMICKWORK_GetAssignID(work);
	
	if (id == FLD_GIMMICK_NONE){
		return FALSE;					//M~bN
	}
	//M~bNI
	if (FldGimmickHitCheck[id] != NULL){
		(*outHit) = FldGimmickHitCheck[id](fsys, inGridX, inGridZ, inHeight);
		return TRUE;
	}
	
	return FALSE;						//
}
