//============================================================================================
/**
 * @file	field_skill.c
 * @brief	tB[hZi`ZȂǁj
 * @author	Hiroyuki Nakamura
 * @date	2005.12.01
 */
//============================================================================================
#include "common.h"

#include "system/window.h"
#include "system/msgdata.h"
#include "msgdata/msg.naix"
#include "msgdata/msg_debug_nakahiro.h"

#include "fieldsys.h"
#include "fieldmap.h"
#include "field_event.h"
#include "talk_msg.h"

#define	FIELD_SKILL_H_GLOBAL
#include "field_skill.h"


//============================================================================================
//	萔`
//============================================================================================
typedef struct {
	GF_BGL_BMPWIN win;	// EBhEf[^
	u16	msg_idx;		// bZ[WCfbNX
	u16	waza;			// gpZCfbNX
	u16	poke;			// |Pʒu
	u16	seq;			// V[PX
}FLD_SKILL_WORK;

enum {
	SEQ_MSG_START = 0,
	SEQ_MSG_WAIT,
	SEQ_KEY_WAIT,
	SEQ_END,
};


//============================================================================================
//	vg^Cv錾
//============================================================================================
static FLD_SKILL_WORK * SkillWorkAllocSet( u16 poke, u16 waza );
static BOOL GMEVENT_FieldSkill( GMEVENT_CONTROL * event );


//--------------------------------------------------------------------------------------------
/**
 * [N쐬
 *
 * @param	poke	gp|P̈ʒu
 * @param	waza	gpZ
 *
 * @return	쐬[Ñ|C^
 */
//--------------------------------------------------------------------------------------------
static FLD_SKILL_WORK * SkillWorkAllocSet( u16 poke, u16 waza )
{
	FLD_SKILL_WORK * wk;

	wk = sys_AllocMemory( HEAPID_WORLD, sizeof(FLD_SKILL_WORK) );
	wk->poke = (u8)poke;
	wk->waza = waza;
	wk->seq  = 0;

	return wk;
}

//--------------------------------------------------------------------------------------------
/**
 * ZgpCxg֐؂ւ
 *
 * @param	repw	tB[h[N
 * @param	poke	gp|P̈ʒu
 * @param	waza	gpZ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FieldSkill_EvChange( FIELDSYS_WORK * repw, u16 poke, u16 waza )
{
	FLD_SKILL_WORK * wk;

	// ̃[N
	sys_FreeMemoryEz( FieldEvent_GetSpecialWork(repw->event) );
	// Z[N쐬
	wk = SkillWorkAllocSet( poke, waza );
	FieldEvent_Change( repw->event, GMEVENT_FieldSkill, wk );
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hCxgFZgp
 *
 * @param	event	tB[hCxgpp[^
 *
 * @retval	TRUE	CxgI
 * @retval	FALSE	Cxgp
 */
//--------------------------------------------------------------------------------------------
static BOOL GMEVENT_FieldSkill( GMEVENT_CONTROL * event )
{
	FIELDSYS_WORK * fsys;
	FLD_SKILL_WORK * wk;

	fsys = FieldEvent_GetFieldSysWork( event );
	wk   = FieldEvent_GetSpecialWork( event );

	switch( wk->seq ){
	case SEQ_MSG_START:
		FldTalkBmpAdd( fsys->bgl, &wk->win, FLD_MBGFRM_FONT );
		FldTalkWinPut( &wk->win );

		{	// bZ[W\idebug_nakahiro.gmmj
			MSGDATA_MANAGER * mman = MSGMAN_Create(
				MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_debug_nakahiro_dat, HEAPID_WORLD );
			STRBUF * str = MSGMAN_AllocString( mman, msg_waza_test );
			wk->msg_idx = FldTalkMsgStart( &wk->win, str, 1 );
			STRBUF_Delete( str );
			MSGMAN_Delete( mman );
		}

		wk->seq = SEQ_MSG_WAIT;
		break;

	case SEQ_MSG_WAIT:
		if( FldTalkMsgEndCheck( wk->msg_idx ) == 1 ){
			wk->seq = SEQ_KEY_WAIT;
		}
		break;

	case SEQ_KEY_WAIT:
		if( sys.trg & ( PAD_BUTTON_A|PAD_BUTTON_B|PAD_BUTTON_X|PAD_BUTTON_Y ) ){
			BmpTalkWinClear( &wk->win, WINDOW_TRANS_ON );
			GF_BGL_BmpWinDel( &wk->win );
			wk->seq = SEQ_END;
		}
		break;

	case SEQ_END:
		sys_FreeMemoryEz( wk );
		return TRUE;
	}

	return FALSE;
}
