//===========================================================================
/**
 * @file	field_subproc.c
 * @brief	tB[hł̃TuvZXĂяo֘A
 * @author	GAME FREAK Inc.
 * @date	2005.10.21
 * 
 * fieldsys.c؂藣č쐬
 *
 */
//===========================================================================
#include "common.h"

#define __FIELDSYS_H_GLOBAL__
#include "fieldsys.h"

#include "field_subproc.h"
#include "field/field.h"
#include "field/townmap_footmark.h"
#include "field/situation_local.h"

#include "fieldmap.h"

#include "battle/fight.h"		//BattleSystemProc

#include "field_encount.h"		//FieldBattle_SetProc
#include "zonedata.h"
#include "savedata/config.h"

#include "system/gamedata.h"
#include "application/bag.h"
#include "application/pokelist.h"
#include "application/p_status.h"
#include "application/worldmap/townmap.h"
#include "application/namein.h"
#include "application/tradelist.h"
#include "application/oekaki.h"
#include "application/trainer_card.h"
#include "application\box.h"
#include "application/imageClip/imc_sys.h"
#include "application/zukanlist/zkn_sys.h"
#include "application/nuts_tag.h"
#include "application/config_tool.h"
#include "application/mailtool.h"
#include "application/pms_input.h"
#include "application/f_note.h"
#include "poketool/poke_tool.h"
#include "poketool/pokeparty.h"

#include "itemtool/myitem.h"

#include "communication/communication.h"  // ʐM̂


#include "ev_mapchange.h"
#include "system/pm_str.h"
#include "system/mystatus.h"

//#include "demo/opening/opening_sys.h"


//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	vZX֐FF퓬ieXgj
 */
//------------------------------------------------------------------
static PROC_RESULT TestBattleProc_Init(PROC * proc, int * seq)
{
	return PROC_RES_FINISH;
}
//------------------------------------------------------------------
/**
 * @brief	vZX֐FCF퓬ieXgj
 */
//------------------------------------------------------------------
static PROC_RESULT TestBattleProc_Main(PROC * proc, int * seq)
{
	if (BattleSystemProc(proc,seq)) {
		return PROC_RES_FINISH;
	} else {
		return PROC_RES_CONTINUE;
	}
}
//------------------------------------------------------------------
/**
 * @brief	vZX֐FIF퓬ieXgj
 */
//------------------------------------------------------------------
static PROC_RESULT TestBattleProc_End(PROC * proc, int * seq)
{
	return PROC_RES_FINISH;
}

//------------------------------------------------------------------
/**
 * @brief	vZX`f[^F퓬ieXgj
 */
//------------------------------------------------------------------

//------------------------------------------------------------------
//------------------------------------------------------------------
void FieldBattle_SetProc(FIELDSYS_WORK * fsys, BATTLE_PARAM *param )
{
	FS_EXTERN_OVERLAY(battle);

static const PROC_DATA TestBattleProcData = {
	TestBattleProc_Init,
	TestBattleProc_Main,
	TestBattleProc_End,
	FS_OVERLAY_ID(battle),
};

	GameSystem_StartSubProc(fsys, &TestBattleProcData, param);
}


//===========================================================================
//===========================================================================
static const u8 FieldMenuBagList[] = {
	BAG_POKE_EVENT, BAG_POKE_NORMAL, BAG_POKE_NUTS, BAG_POKE_DRUG,
	BAG_POKE_BALL, BAG_POKE_BATTLE, BAG_POKE_SEAL, BAG_POKE_WAZA, 0xff
};
//------------------------------------------------------------------
//	obO
//------------------------------------------------------------------
void * FieldBag_SetProc( FIELDSYS_WORK * fsys )
{
	MYITEM * myitem;
	void * buf;

	myitem = SaveData_GetMyItem( fsys->savedata );
	buf = MyItem_MakeBagData( myitem, FieldMenuBagList, HEAPID_WORLD );

	BagSystemDataSet( buf, 0, BAG_MODE_FIELD, SaveData_GetMyStatus(fsys->savedata) );

	if( Player_FormGet( fsys->player ) == HERO_FORM_CYCLE ){
		BagCycleFlagSet( buf );
	}

	if( !(ZoneData_IsSinouField(fsys->location->zone_id)) ){
		BagUnderCheckFlagSet( buf );
	}

	GameSystem_StartSubProc( fsys, &BagProcData, buf );

	return buf;
}

//------------------------------------------------------------------
/**
 * CxgobOʂĂяo
 * @param	fsys
 * @param	mode	obO̎wiEVBAG_MODE̒`QƁj
 * @return	void *	obOʃp[^ւ̃|C^
 */
//------------------------------------------------------------------
void * FieldBagEvent_SetProc( FIELDSYS_WORK * fsys, EVBAG_MODE mode )
{
	void * buf;
	static const u8 * baglist;
	static const u8 kinomi_bag[] = {BAG_POKE_NUTS, 0xff};
	static const u8 dougu_bag[] = {BAG_POKE_NORMAL, 0xff};
	MYITEM * myitem = SaveData_GetMyItem(fsys->savedata);
	switch (mode) {
	case EVBAG_MODE_NORMAL_ONLY:
		baglist = dougu_bag;
		break;
	case EVBAG_MODE_KINOMI_ONLY:
		baglist = kinomi_bag;
		break;
	default:
		GF_ASSERT(0);
	}
	buf = MyItem_MakeBagData(myitem, baglist, HEAPID_EVENT);
	BagSystemDataSet(buf, 0, BAG_MODE_KINOMI, SaveData_GetMyStatus(fsys->savedata));

	GameSystem_StartSubProc( fsys, &BagProcData, buf );
	return buf;
}

//------------------------------------------------------------------
/**
 * obOʂőIǂ󂯎
 * @param	void *	obOʃp[^ւ̃|C^
 * @return	u16		Iǂ̃io[iÔƂALZj
 */
//------------------------------------------------------------------
u16 FieldBagEvent_GetSelectedItem(void * param)
{
	u16 item;
	item = BagSysReturnItemGet(param);
	if (item != 0 && BagSysReturnModeGet(param) == BAG_RET_CANCEL) {
		GF_ASSERT(0);
	}
	return item;
}


//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//	؂̎^O
//------------------------------------------------------------------
void FieldNutsTag_SetProc( FIELDSYS_WORK * fsys, void * buf )
{
	GameSystem_StartSubProc( fsys, &NutsTagProcData, buf );
}


//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//	`m[g
//------------------------------------------------------------------
void FieldFantasyNote_SetProc( FIELDSYS_WORK * fsys, void * buf )
{
	GameSystem_StartSubProc( fsys, &FantasyNoteProcData, buf );
}


//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//	|PXg
//------------------------------------------------------------------
void * FieldPokeList_SetProc( FIELDSYS_WORK * fsys, u8 pos )
{
	PLIST_DATA * pld = sys_AllocMemory( HEAPID_WORLD, sizeof(PLIST_DATA) );

	memset( pld, 0, sizeof(PLIST_DATA) );
	pld->pp = SaveData_GetTemotiPokemon(fsys->savedata);
	pld->myitem = SaveData_GetMyItem( fsys->savedata );
	pld->mailblock = SaveData_GetMailBlock( fsys->savedata );
	pld->ret_sel = pos;
	pld->type = PL_TYPE_SINGLE;
	pld->mode = PL_MODE_FIELD;
	GameSystem_StartSubProc( fsys, &PokeListProcData, pld );

	return pld;
}

//------------------------------------------------------------------
//------------------------------------------------------------------
void FieldPokeStatus_SetProc( FIELDSYS_WORK * fsys, void * psd )
{
	GameSystem_StartSubProc( fsys, &PokeStatusProcData, psd );
}

//------------------------------------------------------------------
/**
 * @brief	Cxg̃|PXgĂяo
 * @param	heap	gpq[v̎w
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	void *	|PXgpp[^̃|C^
 */
//------------------------------------------------------------------
void * FieldPokeListEvent_SetProc(int heap, FIELDSYS_WORK * fsys)
{
	PLIST_DATA * pld = sys_AllocMemory( heap, sizeof(PLIST_DATA) );

	memset( pld, 0, sizeof(PLIST_DATA) );
	pld->pp = SaveData_GetTemotiPokemon(fsys->savedata);
	pld->myitem = SaveData_GetMyItem( fsys->savedata );
//	PokeParty_Copy( const, buf );
	pld->type = PL_TYPE_SINGLE;
	pld->mode = PL_MODE_SET;
	GameSystem_StartSubProc( fsys, &PokeListProcData, pld );

	return pld;
}

//------------------------------------------------------------------
/**
 * @brief	|PXgIʂ̎擾
 * @param	wk		|PXgpp[^̃|C^
 * @return	int		I
 */
//------------------------------------------------------------------
int FieldPokeListEvent_GetSelect(void * wk)
{
	PLIST_DATA * pld = wk;
	return pld->ret_sel;
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
// {bNX֘A
//------------------------------------------------------------------
void FieldBox_SetProc( FIELDSYS_WORK * fsys, BOX_PROC_PARAM* param )
{
	// I[o[CID錾
	FS_EXTERN_OVERLAY(overlay_box);

	// vZX`f[^
	static const PROC_DATA BoxProcData = {
		BoxProc_Init,
		BoxProc_Main,
		BoxProc_End,
	///	NO_OVERLAY_ID,
		FS_OVERLAY_ID(overlay_box),
	};


	GameSystem_StartSubProc(fsys,  &BoxProcData, param );
}


//------------------------------------------------------------------
// ȈՉb
//------------------------------------------------------------------

void FieldProc_SetPmsInput( FIELDSYS_WORK* fsys, PMSI_PARAM* param )
{
	// I[o[CID錾
	FS_EXTERN_OVERLAY(overlay_pmsi);

	// vZX`f[^
	static const PROC_DATA proc_data = {
		PMSInput_Init,
		PMSInput_Main,
		PMSInput_Quit,
		FS_OVERLAY_ID(overlay_pmsi),
	};


	GameSystem_StartSubProc(fsys, &proc_data, param );
}


//-------------------------------------------------------------------
// ^E}bv֘A
//-------------------------------------------------------------------
extern const PROC_DATA TMapProcData;
#define  OSP_TMAP_HEAP_SIZE 0

/**
 *	@brief	tB[h [h}bvW[Ăяo
 *
 *	@param	fsys FIELDSYS_WORK *
 *	@param	mode	u8:Ăяo[h(enum TMAP_MODE)
 *	@param	work	void*:[N̈p
 *
 *	@retval	0:
 *	@retval else	s
 */
void FieldTMap_SetProc(FIELDSYS_WORK *fsys, TOWNMAP_PARAM * tp)
{
	TMAP_IO_DAT* wk;

	// I[o[CID錾
	FS_EXTERN_OVERLAY(townmap);

	///I[o[CvZX`f[^
	const PROC_DATA TMapProcData = {
		TMapProc_Init,
		TMapProc_Main,
		TMapProc_End,
		FS_OVERLAY_ID(townmap)
	};

	GameSystem_StartSubProc(fsys, &TMapProcData,tp);
}

/**
 *	@brief	tB[h ^E}bvW[f[^Zbg
 *
 *	@param	fsys FIELDSYS_WORK *
 *	@param	tp	TOWNMAP_PARAM*:f[^i[\̌^ւ̃|C^
 *	@param	mode	u8:Ăяo[h(enum TMAP_MODE)
 */
void FieldTMap_CallDataSet(FIELDSYS_WORK* fsys,TOWNMAP_PARAM *tp,int mode)
{
    MYSTATUS* pMyStatus;
	int i = 0,pos = 0,ret = 0;
	int x,z,zoneID;
	TOWN_MAP_FOOTMARK * fmark;

	SITUATION * sit = SaveData_GetSituation(fsys->savedata);
	LOCATION_WORK * escape = Situation_GetEscapeLocation(sit);

	memset(tp,0,sizeof(TOWNMAP_PARAM));

	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	zoneID = World_GetZoneIDFromMatrixXZ(fsys->World,x/BLOCK_GRID_W,z/BLOCK_GRID_W);
	if(ZoneData_IsSinouField(zoneID)){
		tp->player_x = x;
		tp->player_z = z;
	}else{
		tp->player_x = escape->grid_x;
		tp->player_z = escape->grid_z;
	}
//	tp->zone_id = GetNowZoneID(fsys);

	//@̐
    pMyStatus = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
	tp->player_sex = MyStatus_GetMySex(pMyStatus); 

	//@̈ړO擾
	fmark= Situation_GetTMFootMark(SaveData_GetSituation(fsys->savedata));
	
	pos = (fmark->NowPoint-2+FOOTMARK_NUM)%FOOTMARK_NUM;
	for(i = 0;i < TMAP_FVIEW_MAX;i++){
		tp->foot[i].x = fmark->Param[pos].BlockX;
		tp->foot[i].z = fmark->Param[pos].BlockZ;
		tp->foot[i].valid = fmark->Param[pos].Valied;
		if(fmark->Param[pos].Dir > 3){
			tp->foot[i].dir = DIR_RIGHT+1;
		}else{
			tp->foot[i].dir = fmark->Param[pos].Dir;
		}
		pos = (pos-1+FOOTMARK_NUM)%FOOTMARK_NUM;

		if(tp->foot[i].valid){
			ret++;
		}
	}
#if 0
	ret = 1;
	if(ret == 0){
		for(i = 0;i < TMAP_FVIEW_MAX;i++){
			tp->foot[i].x = 10+i;
			tp->foot[i].z = 10+i;
			tp->foot[i].dir = i;
			tp->foot[i].valid = 1;
		}
	}
#endif	
	tp->mode = mode;
}

// errorôőΏ
void * FieldMenuTMap_SetProc( FIELDSYS_WORK * fsys )
{
	TOWNMAP_PARAM * tp;
    MYSTATUS* pMyStatus;
	int i = 0,pos = 0;
	TOWN_MAP_FOOTMARK * fmark
		= Situation_GetTMFootMark(SaveData_GetSituation(fsys->savedata));
	
	tp = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(TOWNMAP_PARAM));

	//f[^Zbg
	FieldTMap_CallDataSet(fsys,tp,TMAP_MNORMAL);
	FieldTMap_SetProc( fsys, tp );
	return tp;
}


/**
 *	@brief	RtBOʌĂяo(tB[h)
 *
 *	@param	fsys FIELDSYS_WORK *
 *	@param	CONFIG*	:RtBOZ[uf[^nhւ̃|C^
 */
void ConfigTool_SetProc(FIELDSYS_WORK* fsys,CONFIG* sp)
{
	//I[o[CID`
	FS_EXTERN_OVERLAY(config);

	//I[o[CvZX`f[^
	static const PROC_DATA ConfigProcData = {
		ConfigProc_Init,
		ConfigProc_Main,
		ConfigProc_End,
//		NO_OVERLAY_ID,
		FS_OVERLAY_ID(config),
	};
	GameSystem_StartSubProc(fsys, &ConfigProcData,sp);
}

/**
 *	@brief	RtBOʃtB[hj[Ăяo
 *	
 *	@param	fsys FIELDSYS_WORK *
 *
 *	@retval	CONFIG_PARAM* :mۂp[^[Nւ̃|C^
 *						@@ĂяoIɉKv
 */
void * FieldConfig_SetProc( FIELDSYS_WORK * fsys )
{
	CONFIG_PARAM* cp;
	CONFIG*	sp;

	cp = sys_AllocMemoryLo(HEAPID_WORLD,sizeof(CONFIG_PARAM));

	//RtBOZ[uf[^擾
	sp = SaveData_GetConfig(GameSystem_GetSaveData(fsys));
	ConfigTool_SetProc(fsys,sp);

	return cp;
}

/**
 *	@brief	[쐬Ăяo(tB[h)
 *
 *	@param	fsys FIELDSYS_WORK *
 *	@param	MAIL_PARAM*	:[p[^ւ̃|C^
 */
extern const PROC_DATA MailSysProcData;
void MailSys_SetProc(FIELDSYS_WORK* fsys,MAIL_PARAM* mp)
{
	GameSystem_StartSubProc(fsys, &MailSysProcData,mp);
}

/**
 *	@brief	[쐬ʃtB[hj[Ăяo
 *	
 *	@param	fsys FIELDSYS_WORK *
 *
 *	@retval	MAIL_PARAM* :mۂp[^[Nւ̃|C^
 *						@@ĂяoIɉKv
 *
 *					TRUEȂ烁[쐬AFALSE͖̎쐬
 */
MAIL_PARAM * FieldMailCreate_InitCall( FIELDSYS_WORK * fsys ,
		MAILBLOCK_ID blockID,u8 poke_pos,u8 design,int heapID)
{
	MAIL_PARAM*	pRet;

	pRet = MailSys_GetWorkCreate(GameSystem_GetSaveData(fsys),
			blockID,poke_pos,design,HEAPID_WORLD);

	if(pRet == NULL){
		return NULL;	//쐬󂫗̈悪Ȃ
	}
	MailSys_SetProc(fsys,pRet);
	return pRet;
}

/**
 *	@brief	[`ʃtB[hj[Ăяo
 *	
 *	@param	fsys FIELDSYS_WORK *
 *
 *	@retval	MAIL_PARAM* :mۂp[^[Nւ̃|C^
 *						@@ĂяoIɉKv
 *
 *	󃁁[\ꍇɂ
 *		MAILBLOCK_ID MAILBLOCK_NULL
 *		dataID  fUCNo@
 *	@nČĂяo܂
 */
MAIL_PARAM * FieldMailView_InitCall( FIELDSYS_WORK * fsys,
		MAILBLOCK_ID blockID,u8 dataID,int heapID)
{
	MAIL_PARAM*	pRet;

	if(blockID == MAILBLOCK_NULL){
		//Ĝ݂̃vr[
		pRet = MailSys_GetWorkViewPrev(GameSystem_GetSaveData(fsys),dataID,heapID);
	}else{
		pRet = MailSys_GetWorkView(GameSystem_GetSaveData(fsys),
				blockID,dataID,heapID);
	}

	MailSys_SetProc(fsys,pRet);

	return pRet;
}

/**
 *	@brief	[`ʃtB[hj[Ăяo(|P[)
 *	
 *	@param	fsys FIELDSYS_WORK *
 *
 *	@retval	MAIL_PARAM* :mۂp[^[Nւ̃|C^
 *						@@ĂяoIɉKv
 *
 */
MAIL_PARAM * FieldMailViewPoke_InitCall( FIELDSYS_WORK * fsys,
		POKEMON_PARAM* poke,int heapID)
{
	MAIL_PARAM*	pRet;

	pRet = MailSys_GetWorkViewPoke(GameSystem_GetSaveData(fsys),poke,heapID);

	MailSys_SetProc(fsys,pRet);

	return pRet;
}

/**
 *	@brief	|gP[XTuvZXo^
 */
static void PorutoSys_SetProc(FIELDSYS_WORK* fsys,PORUTO_PARAM* pp)
{
	GameSystem_StartSubProc(fsys, &PorutoSysProcData,pp);
}

/**
 *	@brief	|gP[XĂяo
 */
PORUTO_PARAM* FieldPorutoCase_InitCall(FIELDSYS_WORK* fsys,int heapID)
{
	PORUTO_PARAM* pp;
	
	pp = PorutoSys_CreateCallWork(GameSystem_GetSaveData(fsys),heapID);	
	PorutoSys_SetProc(fsys,pp);
	
	return pp;
}

//-----------------------------------------------------------------------------
/**
*	C[WNbv֘A
*/
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *
 *	@brief	C[WNbvvbNZbg
 *
 *	@param	fsys		tB[h[N
 *	@param	buff		f[^obt@	iNULLj
 *
 *	@retval		TRUE	
 *	@retval		FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL FieldImageClip_SetProc( FIELDSYS_WORK * fsys, void* buff )
{
	// I[o[CID錾
	FS_EXTERN_OVERLAY(ol_imageclip);
	
	// vbNf[^
	static PROC_DATA IMC_SYS_Proc = {
		IMC_ProcInit,
		IMC_ProcMain,
		IMC_ProcEnd,
		FS_OVERLAY_ID(ol_imageclip),
	};

	GameSystem_StartSubProc(fsys,  &IMC_SYS_Proc, buff );
	return TRUE;
}


//-----------------------------------------------------------------------------
/**
*	O(lE|PE{bNX)
*
* @param param(enamein.hQƁj
*
*/
//-----------------------------------------------------------------------------
BOOL NameInput_SetProc( FIELDSYS_WORK * fsys, void *param)
{

	GameSystem_StartSubProc(fsys,  &NameInProcData, param );

}

//==============================================================================
//
//
//				ʐMXgʌĂяo
//
//
//==============================================================================
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 * ʐMXgʌĂяo
 *
 * @param   fsys	
 *
 * @retval  void * ʐMXgpp[^ւ̃|C^	
 */
//-----------------------------------------------------------------------------
void * TradeList_SetProc( FIELDSYS_WORK * fsys )
{
	TRADELIST_PARAM * param;
	param = sys_AllocMemory(HEAPID_EVENT, sizeof(TRADELIST_PARAM));
	param->mystatus   = SaveData_GetMyStatus(fsys->savedata);
	param->myparty    = SaveData_GetTemotiPokemon(fsys->savedata);
	param->friendlist = SaveData_Get(fsys->savedata, GMDATA_ID_FRIEND);
	GameSystem_StartSubProc(fsys,  &TradeListProcData, param );
	return param;
}


FS_EXTERN_OVERLAY(oekaki_board);

//============================================================================================
//	O[oϐ
//============================================================================================
// vZX`f[^
const PROC_DATA OekakiProcData = {
	OekakiProc_Init,
	OekakiProc_Main,
	OekakiProc_End,
	FS_OVERLAY_ID(oekaki_board),
};

//==============================================================================
/**
 * $brief   G{[hĂяo
 *
 * @param   fsys		
 *
 * @retval  BOOL		
 */
//==============================================================================
BOOL OekakiBoard_SetProc( FIELDSYS_WORK *fsys )
{
	GameSystem_StartSubProc(fsys,  &OekakiProcData, fsys->union_view );
}

//===========================================================================
//===========================================================================
typedef struct{
	int seq;
	int pos;
	u16* ret_work;
	NAMEIN_PARAM * namein;
}NAMEIN_EVENT_WORK;

static void namein_str_set(GMEVENT_CONTROL * event);

//------------------------------------------------------------------
//------------------------------------------------------------------
BOOL GMEVENT_Sub_NameIn(GMEVENT_CONTROL * event)
{
	int len;
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	NAMEIN_EVENT_WORK * new = FieldEvent_GetSpecialWork(event);

	switch (new->seq) {
	case 0:
		EventCmd_FinishFieldMap(event);
		new->seq ++;
		break;
	case 1:
		EventCmd_CallSubProc(event, &NameInProcData, new->namein);
		new->seq ++;
		break;
	case 2:
		EventCmd_StartFieldMap(event);
		new->seq ++;
		break;
	case 3:
		if (new->namein->cancel == 0 ) {
			namein_str_set(event);						//͂ŏ㏑
		}

		if( new->ret_work != NULL ){
			*new->ret_work = new->namein->cancel;		//ʂ[Nɑ
		}

		NameIn_ParamDelete(new->namein);				// O̓[N
		sys_FreeMemoryEz(new);
		return TRUE;
	}
	return FALSE;
}

static void namein_str_set(GMEVENT_CONTROL * event)
{
	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
	NAMEIN_EVENT_WORK * new = FieldEvent_GetSpecialWork(event);

	switch( new->namein->mode ){

	case NAMEIN_MYNAME:
		{
			MYSTATUS * my = SaveData_GetMyStatus(fsys->savedata);
			MyStatus_SetMyName(my, new->namein->str);
		}
		break;
	case NAMEIN_POKEMON:
		{
			POKEMON_PARAM * poke;
			poke = PokeParty_GetMemberPointer( SaveData_GetTemotiPokemon(fsys->savedata), new->pos);
			PokeParaPut( poke, ID_PARA_nickname, (u8 *)&new->namein->str );
		}
		break;
	case NAMEIN_BOX:
		//Ή
		break;
	};

	return;
}

//------------------------------------------------------------------
/**
 * @brief	Cxg[R}hFO͌Ăяo
 * @param	event		Cxg䃏[Nւ̃|C^
 * @param	mode		̓[h(application/namein.hQ)
 * @param	info		jEA|P̊JNOȂ
 * @param	wordmax		͕ő吔
 * @param	pos			莝̉Ԗڂ(KvȂƂ0)
 * @param	str			O͉ʂŕ\镶(\ȂNULL)
 * @param	ret_work	͕OB͍ŏƓꍇ̃tO擾郏[N(NULL)
 *
 * tB[hvZXIÓtB[hvZXĊJsB
 *
 * [hNAMEIN_POKEMON(|P)ANAMEIN_BOX({bNX)ɂ́A
 * ͂ꂽŏ㏑鏈́A쐬łB(namein_str_set)
 */
//------------------------------------------------------------------
void EventCmd_NameIn(GMEVENT_CONTROL * event, int mode, int info, int wordmax, int pos, const u16* str, u16* ret_work)
{
	NAMEIN_EVENT_WORK * new = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(NAMEIN_EVENT_WORK));

	new->seq = 0;
	new->pos = pos;
	new->ret_work = ret_work;
	new->namein = NameIn_ParamAllocMake(HEAPID_WORLD, mode, info, wordmax);

	if( str != NULL ){
		PM_strcpy(new->namein->str, str);
	}

	FieldEvent_Call(event, GMEVENT_Sub_NameIn, new);
}

//------------------------------------------------------------------
//	g[i[J[h֘A
//------------------------------------------------------------------
void FieldTrCard_SetProc( FIELDSYS_WORK * fsys, TR_CARD_DATA *tcd )
{
	// I[o[CID錾
	FS_EXTERN_OVERLAY(trainer_card);

	// vZX`f[^
	static const PROC_DATA TrCardProcData = {
		TrCardProc_Init,
		TrCardProc_Main,
		TrCardProc_End,
		FS_OVERLAY_ID(trainer_card),
	};
	
	GameSystem_StartSubProc( fsys, &TrCardProcData, tcd );
}

//------------------------------------------------------------------
//	eXgFI[vjOĂяo
//------------------------------------------------------------------
BOOL FieldOpening_SetProc( FIELDSYS_WORK * fsys, void* buff )
{
#if 0
	GameSystem_StartSubProc( fsys,  &OpeningProcData, NULL );
#endif
	return TRUE;
}


//----------------------------------------------------------------------------
/**
 *	@brief	}ӃvbNZbg
 *
 *	@param	fsys		tB[h[N
 *	@param	p_rearent	}ӂɕKvȃf[^	(ZKN_PEARENT_DATA)
 *
 *	@retval		TRUE	
 *	@retval		FALSE	s
 */
//-----------------------------------------------------------------------------
BOOL FieldZukan_SetProc( FIELDSYS_WORK * fsys, void* p_pearent )
{

	// I[o[CID錾
	FS_EXTERN_OVERLAY(ol_zukan);

	// }ӃvbNf[^
	static const PROC_DATA ZKN_SYS_Proc = {	
		ZKN_ProcInit,
		ZKN_ProcMain,
		ZKN_ProcEnd,
		FS_OVERLAY_ID(ol_zukan),
	};



	GameSystem_StartSubProc(fsys,  &ZKN_SYS_Proc, p_pearent );
	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Jn|PIvbNZbg
 *
 *	@param	fsys		tB[h[N
 *	@param	p_rearent	Jn|PIɕKvȃf[^
 *
 *	@retval		TRUE	
 *	@retval		FALSE	s
 */
//-----------------------------------------------------------------------------
void Field_EVPokeSelect_SetProc( FIELDSYS_WORK * fsys, EV_POKESELECT_PEARENT_DATA* p_pearent )
{

	// I[o[CID錾
	FS_EXTERN_OVERLAY(ev_pokeselect);

	// }ӃvbNf[^
	static const PROC_DATA EV_PokeSelect_Proc = {	
		EV_PokeSelect_ProcInit,
		EV_PokeSelect_ProcMain,
		EV_PokeSelect_ProcEnd,
		FS_OVERLAY_ID(ev_pokeselect)
	};

	GameSystem_StartSubProc(fsys,  &EV_PokeSelect_Proc, p_pearent );
}
