//=============================================================================
/**
 * @file	field_subproc.h	
 * @brief	tB[h΂TuvZX
 * @author	GAME FREAK inc.
 */
//=============================================================================
#ifndef	__FIELD_SUBPROC_H__
#define	__FIELD_SUBPROC_H__

#include "field_common.h"
#include "system/procsys.h"
#include "field_event.h"
#include "application/trainer_card.h"
#include "application/poru_tool.h"
#include "application/box.h"

//==============================================================================
//	include
//==============================================================================


typedef enum {
	EVBAG_MODE_NORMAL_ONLY = 0,
	EVBAG_MODE_KINOMI_ONLY,
}EVBAG_MODE;

//==============================================================================
//==============================================================================


extern void * FieldBag_SetProc( FIELDSYS_WORK * fsys );
extern void * FieldPokeList_SetProc( FIELDSYS_WORK * fsys, u8 pos );
extern void FieldPokeStatus_SetProc( FIELDSYS_WORK * fsys, void * psd );
extern void FieldTrCard_SetProc( FIELDSYS_WORK * fsys, TR_CARD_DATA *tcd );
extern void FieldNutsTag_SetProc( FIELDSYS_WORK * fsys, void * buf );
extern void FieldFantasyNote_SetProc( FIELDSYS_WORK * fsys, void * buf );
extern void * FieldConfig_SetProc( FIELDSYS_WORK * fsys );

extern void * DebugFieldBox_SetProc( FIELDSYS_WORK * fsys );
extern void FieldBox_SetProc( FIELDSYS_WORK * fsys, BOX_PROC_PARAM* param );

extern BOOL FieldImageClip_SetProc( FIELDSYS_WORK * fsys, void* buff );
extern BOOL FieldZukan_SetProc( FIELDSYS_WORK * fsys, void* p_pearent );
extern BOOL NameInput_SetProc( FIELDSYS_WORK * fsys, void *param );
extern void * TradeList_SetProc( FIELDSYS_WORK * fsys );
extern BOOL OekakiBoard_SetProc( FIELDSYS_WORK *fsys );

extern void EventCmd_NameIn(GMEVENT_CONTROL * event, int mode, int info, int wordmax, int pos, const u16* str, u16* ret_work);


extern void * FieldBagEvent_SetProc( FIELDSYS_WORK * fsys, EVBAG_MODE mode );
extern u16 FieldBagEvent_GetSelectedItem(void * param);

//|PIďo
extern void * FieldPokeListEvent_SetProc(int heap, FIELDSYS_WORK * fsys);
extern int FieldPokeListEvent_GetSelect(void * wk);

//[Ăяo
#include "savedata/mail_def.h"
#include "application/mail/mail_param.h"
/**
 *	@brief	[쐬ʃtB[hj[Ăяo
 *	
 *	@param	fsys FIELDSYS_WORK *
 *
 *	@retval	MAIL_PARAM* :mۂp[^[Nւ̃|C^
 *						@@ĂяoIɉKv
 */
extern MAIL_PARAM * FieldMailCreate_InitCall( FIELDSYS_WORK * fsys ,
		MAILBLOCK_ID blockID,u8 poke_pos,u8 design,int heapID);

/**
 *	@brief	[`ʃtB[hj[Ăяo
 *	
 *	@param	fsys FIELDSYS_WORK *
 *
 *	@retval	MAIL_PARAM* :mۂp[^[Nւ̃|C^
 *						@@ĂяoIɉKv
 */
extern MAIL_PARAM * FieldMailView_InitCall( FIELDSYS_WORK * fsys,
		MAILBLOCK_ID blockID,u8 dataID,int heapID);
/**
 *	@brief	[`ʃtB[hj[Ăяo(|P[)
 *	
 *	@param	fsys FIELDSYS_WORK *
 *
 *	@retval	MAIL_PARAM* :mۂp[^[Nւ̃|C^
 *						@@ĂяoIɉKv
 *
 */
extern MAIL_PARAM * FieldMailViewPoke_InitCall( FIELDSYS_WORK * fsys,
		POKEMON_PARAM* poke,int heapID);

/**
 *	@brief	|gP[XĂяo
 */
extern PORUTO_PARAM* FieldPorutoCase_InitCall(FIELDSYS_WORK* fsys,int heapID);

//==============================================================================
// ȈՉb͉
//==============================================================================
#include "application\pms_input.h"
extern void FieldProc_SetPmsInput( FIELDSYS_WORK* fsys, PMSI_PARAM* param );


//==============================================================================
// Jn|PIʉ
//==============================================================================
#include "demo/ev_poke_select.h"
extern void Field_EVPokeSelect_SetProc( FIELDSYS_WORK * fsys, EV_POKESELECT_PEARENT_DATA* p_pearent );

#endif	//__FIELD_SUBPROC_H__
