//============================================================================================
/**
 * @file	field_subscreen.c
 * @brief
 * @author	tamada
 * @date	2006.02.03
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"

#include "field_subscreen.h"

#include "union_board.h"
#include "underground/ug_manager.h"



//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	Tuʏc[̂܂Ƃ
 */
//------------------------------------------------------------------
typedef struct SUBSCRN_FUNCLIST{
	void (*set_init)(FIELDSYS_WORK *);		///<TuʏNGXg֐
	BOOL (*wait_init)(FIELDSYS_WORK *);		///<Tuʏ҂֐
	void (*set_quit)(FIELDSYS_WORK *);		///<TuʏINGXg֐
	BOOL (*wait_quit)(FIELDSYS_WORK *);		///<TuʏI҂֐
}SUBSCRN_FUNCLIST;



//============================================================================================
//============================================================================================
static void FieldSubScreen_Init_Normal(FIELDSYS_WORK * fsys);
static void FieldSubScreen_Init_Under(FIELDSYS_WORK * fsys);
static void FieldSubScreen_Init_Union(FIELDSYS_WORK * fsys);
static void FieldSubScreen_Quit_Normal(FIELDSYS_WORK * fsys);
static void FieldSubScreen_Quit_Under(FIELDSYS_WORK * fsys);
static void FieldSubScreen_Quit_Union(FIELDSYS_WORK * fsys);
static BOOL FieldSubScreen_WaitQuit_Normal(FIELDSYS_WORK * fsys);
static BOOL FieldSubScreen_WaitQuit_Under(FIELDSYS_WORK * fsys);

//------------------------------------------------------------------
/**
 * @brief	Tuʐp֐S
 *
 * TuʂɊւ鏉I܂Ƃ߂́B
 * ɂ܂Ƃ߂邱ƂŃtB[h}bv{̂ڍ׏
 * ĂB
 */
//------------------------------------------------------------------
static const SUBSCRN_FUNCLIST SubScreenFuncList[] = {
	{	///ʏtB[hp`
		FieldSubScreen_Init_Normal,			// 
		NULL,								// I҂
		FieldSubScreen_Quit_Normal,			// INGXg
		FieldSubScreen_WaitQuit_Normal,		// I҂
	},
	{	///Yzp`
		FieldSubScreen_Init_Under,
		NULL,
		FieldSubScreen_Quit_Under,
		FieldSubScreen_WaitQuit_Under,
	},

	{	/// jI[p`
		FieldSubScreen_Init_Union,			// 
		NULL,								// I҂
		FieldSubScreen_Quit_Union,			// INGXg
		FieldSubScreen_WaitQuit_Normal,		// I҂
	},
};

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
static int GetType(FIELDSYS_WORK * fsys)
{
	FIELD_SUBSCRN_TYPE type = fsys->subscreen;
	GF_ASSERT(type != 0);
	GF_ASSERT(type < FIELD_SUBSCRN_MAX);
	return type - 1;
}

//============================================================================================
//
//
//		tB[h}bvĂ΂Tuʏ֐
//
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	TuʏFNGXg
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
void FieldSubScreen_Init(FIELDSYS_WORK * fsys)
{
	SubScreenFuncList[GetType(fsys)].set_init(fsys);
}

//------------------------------------------------------------------
/**
 * @brief	TuʏF҂
 * @param	fsys	Q[VXeւ̃|C^
 * @return	BOOL	TRUÊƂAI
 */
//------------------------------------------------------------------
BOOL FieldSubScreen_WaitInit(FIELDSYS_WORK * fsys)
{
	BOOL (*func)(FIELDSYS_WORK *);
	func = SubScreenFuncList[GetType(fsys)].wait_init;
	if (func == NULL) {
		return TRUE;
	}
	return func(fsys);
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFINGXg
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
void FieldSubScreen_Quit(FIELDSYS_WORK * fsys)
{
	SubScreenFuncList[GetType(fsys)].set_quit(fsys);
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFI҂
 * @param	fsys	Q[VXeւ̃|C^
 * @return	BOOL	TRUÊƂAI
 */
//------------------------------------------------------------------
BOOL FieldSubScreen_WaitQuit(FIELDSYS_WORK * fsys)
{
	return SubScreenFuncList[GetType(fsys)].wait_quit(fsys);
}


//============================================================================================
//
//
//		TuʂƂ̌ʊ֐
//
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	TuʏFNGXgFʏtB[hp
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
static void FieldSubScreen_Init_Normal(FIELDSYS_WORK * fsys)
{
	FieldPoketch_Init(fsys);
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFNGXgFYzp
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
static void FieldSubScreen_Init_Under(FIELDSYS_WORK * fsys)
{
	CommUnderOptionReboot();  // npʐM̃IvV𕜋A
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFNGXgFjI[pp
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
static void FieldSubScreen_Init_Union(FIELDSYS_WORK * fsys)
{
	fsys->union_board = UnionRoom_BoardInit( fsys );
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFINGXgFʏtB[hp
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
static void FieldSubScreen_Quit_Normal(FIELDSYS_WORK * fsys)
{
	FieldPoketch_QuitReq( fsys );
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFINGXgFYBp
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
static void FieldSubScreen_Quit_Under(FIELDSYS_WORK * fsys)
{
	CommUnderOptionReset();  // npʐM̃IvVj
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFINGXgFYBp
 * @param	fsys	Q[VXeւ̃|C^
 */
//------------------------------------------------------------------
static void FieldSubScreen_Quit_Union(FIELDSYS_WORK * fsys)
{
	UnionRoom_BoardEnd( fsys->union_board );
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFI҂FʏtB[hp
 * @param	fsys	Q[VXeւ̃|C^
 * @return	BOOL	TRUÊƂAI
 */
//------------------------------------------------------------------
static BOOL FieldSubScreen_WaitQuit_Normal(FIELDSYS_WORK * fsys)
{
	return FieldPoketch_QuitWait( fsys );
}

//------------------------------------------------------------------
/**
 * @brief	TuʏFI҂FYzp
 * @param	fsys	Q[VXeւ̃|C^
 * @return	BOOL	TRUÊƂAI
 */
//------------------------------------------------------------------
static BOOL FieldSubScreen_WaitQuit_Under(FIELDSYS_WORK * fsys)
{
	//IATRUEԂ
	return TRUE;
}

