//============================================================================================
/**
 * @file	fieldmap.c
 * @bfief	tB[h}bv
 * @author	GAME FREAK inc.
 */
//============================================================================================

#include "common.h"
#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/palanm.h"
#include "talk_msg.h"
#include "vram_transfer_manager.h"
#include "vram_transfer_anm.h"
#include "fieldsys.h"
#include "fieldmap_work.h"
#include "sxy.h"
#include "fld_debug.h"
#include "worldmap.h"
#include "mapresource.h"
#include "system/snd_tool.h"
#include "fld_bgm.h"
#include "div_map.h"

#include "camera_move_test.h"
#include "field_light.h"
#include "field_anime.h"
#include "field_glb_state.h"
#include "field_event.h"
#include "fieldobj.h"
#include "weather_sys.h"

#include "player.h"
#include "field_anime.h"
#include "effect_uground.h"

#include "system/render_oam.h"
#include "system/arc_util.h"

#include "debug_saito.h"

#include "fieldmap.h"

#include "mapdefine.h"
#include "zonedata.h"
#include "eventdata.h"

#include "field_3d_anime.h"
#include "place_name.h"	//n\

#include "field_effect.h"

#include "script.h"

#include "field_subscreen.h"

#include "situation_local.h"	//Situation_GetTMFootMark
#include "townmap_footmark.h"	//TMFootMark_Update
#include "honey_tree_enc.h"		//HTE_SetHoneyTreeAnimeCallBack

#include "field_camera.h"
#include "ev_time.h"

#include "fieldmap_func.h"
#include "field_gimmick.h"
#include "field_poketch.h"

#include "system/wipe.h"		//for wipe

#include "ug_base_layout.h"
#include "mapdata_weather.h"

#include "quick_sand.h"

//============================================================================================
//	萔`
//============================================================================================

#define	BG_CLEAR_COLOR		( 0x0000 )

#define	SET_FIELD_ANIME		( 1 )
#define	SET_DIVMAP_LOAD		( 2 )
#define	SET_MAP3D_WRITE		( 4 )
#define	SET_FIELD_3D_ANIME	( 8 )

#define	SET_FUNC_CHECK(p,flg)	( p & flg )

//** Vram]}l[W[^XN **//
#define VRAM_TRANFER_TASK_NUM	(128)

//** CharManager PlttManagerp **//
#define FLD_CHAR_CONT_NUM				(20)
#define FLD_CHAR_VRAMTRANS_MAIN_SIZE	(/*2048*/0x2000)
#define FLD_CHAR_VRAMTRANS_SUB_SIZE		(2048)
#define FLD_PLTT_CONT_NUM				(20)

//}bvf[^̒n`pƍf[^p̃TCY`
#define GROUND_MEM_SIZE			(0xf000)
#define HEIGHT_MEM_SIZE			(0x9000)
#define UNDER_GROUND_MEM_SIZE	(0xa800)
#define UNDER_HEIGHT_MEM_SIZE	(0x0)

//vWFNV}gNX𑀍삷ۂ̂yItZbg
#define	PRO_MAT_Z_OFS	(4)

//ǧ
#define EX_HEIGHT_NUM	(8)

//============================================================================================
//	vg^Cv錾
//============================================================================================
static void bg_set( GF_BGL_INI * ini );
static void bg_exit( GF_BGL_INI * ini );
static void join_clact_oam_init(void);				// ZAN^[pLOAM}l[W̏
static void clact_delete(void);		// ZAN^[̔j

static void field_glb_state_init(GLST_DATA_PTR glb);		// ftHg̃O[oXe[g̐ݒ

static void	Map3Dwrite(FIELDSYS_WORK * repw);



static void vram_bank_set(void);
static void debug_vram_bank_set(void);
static void char_pltt_manager_init(void);		// LN^Epbg}l[W[̏
static void char_pltt_manager_delete(void);		// LN^Epbg}l[W[̔j


static void FieldMapLoadSeq( FIELDSYS_WORK * repw );
static BOOL FieldMapLoadSeqMapResource( FIELDSYS_WORK * repw );
static void FieldMapLoadSeqDivMap( FIELDSYS_WORK * repw );
static void FieldMapLoadSeqFeMoveObj( FIELDSYS_WORK * repw );
static void FieldMapLoadSeqRest( FIELDSYS_WORK * repw );

static PROC_RESULT FieldMapProc_Init(PROC * proc, int * seq);
static PROC_RESULT FieldMapProc_Main(PROC * proc, int * seq);
static PROC_RESULT FieldMapProc_End(PROC * proc, int * seq);

static BOOL FieldMap_ZoneChange(FIELDSYS_WORK * fsys);
static void FieldMap_Update(FIELDSYS_WORK * fsys, u8 flag);
static BOOL WatchPlayerPosition(FIELDSYS_WORK * fsys);

static void vBlankFunc(void * work);
static void UpdateFootMark(FIELDSYS_WORK * fsys);


extern void DebugTownMapEndReq( FIELDSYS_WORK * fsys );		// fobO}bvJNGXg

//#define	OSP_HEAP_SIZE

//extern GF_MAP3D_DATA*		map3Ddata;		//tB[hAN^܂ŉǉ
#ifdef PM_DEBUG
void DebugDispTexBank(const u8 inNo);
#endif
extern void GYM_SetupSteelGym(FIELDSYS_WORK *fsys);
extern void GYM_EndSteelGym(FIELDSYS_WORK *fsys);

//------------------------------------------------------------------
//	샂fXg֘A
//------------------------------------------------------------------
static MMDL_WORK * MMDL_Create(int heapID, int area_id);
static const int * MMDL_GetList(const MMDL_WORK * mmdl);
static const int MMDL_GetListSize(const MMDL_WORK * mmdl);
static void MMDL_Delete(MMDL_WORK * mmdl);

//============================================================================================
//	O[oϐ
//============================================================================================


//============================================================================================
//
//
//				֐
//
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[hpVBLANK֐
 * @param	work
 */
//------------------------------------------------------------------
static void vBlankFunc(void * work)
{
	GF_BGL_INI * bgl = work;

	// BG
	GF_BGL_VBlankFunc( bgl );

	// Vram]}l[W[s
	DoVramTransferManager();

	// _LOAM}l[WVram]
	REND_OAMTrans();	
}

//============================================================================================
//
//
//		vZX֐
//
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	vZX֐FFtB[h}bv
 */
//------------------------------------------------------------------
static PROC_RESULT FieldMapProc_Init(PROC * proc, int * seq)
{
	u16 bgm_no;
	FIELDSYS_WORK * fsys;
	PROC_RESULT pr = PROC_RES_CONTINUE;
	
	fsys = PROC_GetParentWork(proc);

	switch (*seq) {
	case 0:
		//tB[hq[v쐬
		sys_CreateHeap( HEAPID_BASE_APP, HEAPID_FIELD, 0x100000 );
		GF_ASSERT(fsys->fldmap == NULL);
		fsys->fldmap = sys_AllocMemory(HEAPID_FIELD, sizeof(FIELDMAP_WORK));
		MI_CpuClear8(fsys->fldmap, sizeof(FIELDMAP_WORK));
		fsys->fldmap->fmapfunc_sys = FLDMAPFUNC_Sys_Create(fsys, HEAPID_FIELD, 8);

		vram_bank_set();				// uq`loNݒ
		initVramTransferManagerHeap( VRAM_TRANFER_TASK_NUM, HEAPID_FIELD );// uq`l]}l[W[
		BLACT_InitSys(FIELDSYS_BLACTSET_NUM, HEAPID_FIELD);	// r{[hAN^[VXe
		simple_3DBGInit(HEAPID_FIELD);
		char_pltt_manager_init();		// LN^Epbg}l[W[̏
		join_clact_oam_init();// tB[hpZAN^[

		GF_Disp_DispSelect();

		fsys->bgl = GF_BGL_BglIniAlloc( HEAPID_FIELD );
		bg_set( fsys->bgl );			// afݒ 
		FieldMsgPrintInit( PALTYPE_MAIN_BG, MSG_PRINT_INIT_ON );

		SpScriptSearch(fsys, SP_SCRID_INIT_CHANGE);

		DEBUG_ENTRY_STRESSPRINT_TASK(fsys);
		break;


	case 1:
		FieldMapLoadSeq( fsys );
		SetupMapResourceQuick(fsys->MapResource);
		
		//gzuf
		fsys->Map3DObjExp = M3DO_AllocMap3DObjList(HEAPID_FIELD);

		//n閧nObYzu(nɂƂ̓X[܂)
		BaseLayout_SetupUGBaseGoodsObj(fsys);	
		
		FieldMapLoadSeqDivMap( fsys );
		FieldMapLoadSeqFeMoveObj( fsys );
		FieldMapLoadSeqRest( fsys );
		{
			u16 weather = Situation_GetWeatherID(SaveData_GetSituation(fsys->savedata));
			WEATHER_Set(fsys->fldmap->weather_data, weather);
		}

		//TEhf[^Zbg(V[ύXȂ͉Ȃ)
		bgm_no = Snd_PcBgmNoGet( fsys, Snd_FieldBgmNoGet(fsys,fsys->location->zone_id) );
		Snd_LightNightFlagSet( GetLightNight() );					//邩tOZbg
		Snd_TrackFadeDataSet( Snd_TrackFadeDataSearch(bgm_no) );	//gbNtF[hf[^Zbg
		Snd_DataSetByScene( SND_SCENE_FIELD, bgm_no, 1 );
		//XNvgɂOBJ
		SpScriptSearch(fsys, SP_SCRID_OBJ_CHANGE);
		break;


	case 2:
		FieldSubScreen_Init(fsys);					//TuʊJnNGXg
		break;


	case 3:
		if (FieldSubScreen_WaitInit(fsys)) {		//TuʊJn҂
			fsys->main_mode_flag = TRUE;
			pr = PROC_RES_FINISH;
		}
		break;
	}

	(*seq)++;
	return pr;
}

//------------------------------------------------------------------
/**
 * @brief	vZX֐FCFtB[h}bv
 */
//------------------------------------------------------------------
static PROC_RESULT FieldMapProc_Main(PROC * proc, int * seq)
{
	FIELDSYS_WORK * fsys;
	fsys = PROC_GetParentWork(proc);
	//͎̕@̓ԂłȂJړȂǂƓWŐ\ɂB
	//i̓][ؑւ@ɈˑĂ邽߁j
	//if ( Player_MoveStateGet(fsys->player) == OBJ_MOVE_STATE_START ) {
	//
	//cƂƂŎ@W`FbNɈڍsĂ݂B2005.12.22	tamada
	if ( WatchPlayerPosition(fsys)) {
		SeedSys_CheckInScreen(fsys);
		UpdateFootMark(fsys);
		Field_SendPoketchInfo(fsys, POKETCH_SEND_MOVE_PLAYER, TRUE);
		if (FieldMap_ZoneChange(fsys)) {
			PlaceNameRequest(fsys->fldmap->place_name_cont,fsys->location->zone_id);//n\
		}
	}

	FieldMap_Update(fsys, SET_FIELD_3D_ANIME | SET_FIELD_ANIME | SET_DIVMAP_LOAD | SET_MAP3D_WRITE );

	if (fsys->main_mode_flag) {
		return PROC_RES_CONTINUE;
	} else {
		return PROC_RES_FINISH;
	}
}


//------------------------------------------------------------------
/**
 * @brief	vZX֐FIFtB[h}bv
 */
//------------------------------------------------------------------
static PROC_RESULT FieldMapProc_End(PROC * proc, int * seq)
{
	FIELDSYS_WORK * fsys;

	fsys = PROC_GetParentWork(proc);
	DivMapLoadMain(fsys, fsys->map_cont_dat);				//}bv[hC֐
	switch(*seq){
	case 0:
		//M~bNI
		FLDGMK_EndFieldGimmick(fsys);
		//oChΏۂ͂
		DivMapPurgeTarget(fsys->map_cont_dat);
		//@ݍW̑ޔ
		fsys->location->grid_x = Player_NowGPosXGet( fsys->player );
		fsys->location->grid_z = Player_NowGPosZGet( fsys->player );
		fsys->location->dir = Player_DirGet( fsys->player );
		//gf[^̈
		EXH_FreeExHeightList(fsys->ExHeightList);
		
		{
			GF_ASSERT(fsys->field_3d_anime!=0);
			DivMapLoad_FreeMap(fsys->map_cont_dat);
		}
		
		RereaseFld3DAnimeAll(fsys->field_3d_anime);
		FreeFld3DAnimeManager(fsys->field_3d_anime);
		F3DASub_FreeAnimeContManager(&fsys->AnimeContMng);

		FieldAnimeAllRelease(fsys->fldmap->field_trans_anime);
		ReleaseFieldAnime(fsys->fldmap->field_trans_anime);
		fsys->fldmap->field_trans_anime = NULL;

		FieldOBJ_DrawProcPushAll( fsys->fldobjsys );			//`揈ޔ
		FieldOBJSys_DrawDelete( fsys->fldobjsys );				//`揈폜
		FieldOBJSys_MoveStopAll( fsys->fldobjsys );
		FE_DeleteAll( fsys->fes );	//tB[hGtFNg폜
		
		MMDL_Delete(fsys->mmdl);					// 샂fXg
		fsys->mmdl = NULL;

		M3DO_FreeResFile();
		M3DO_FreeMap3DObjList(fsys->Map3DObjExp);

		DebugTownMapEndReq( fsys );		// fobO}bvJNGXg

		(*seq)++;
		break;
	case 1:
		if(WaitMapFree(fsys->map_cont_dat) == TRUE){
			ReleaseMapResource(&fsys->MapResource);		// }bv\[X
			FreeDivMapCont(fsys->map_cont_dat);

			FieldCameraEnd(fsys);					//tB[hJI
			
			DellLightCont(&fsys->light_cont_data);	// Cgj
			BoardWorkDelete( fsys->board );			// Ŕ[N
			FreePlaceNameCont(fsys->fldmap->place_name_cont);	//n\\̉
			WEATHER_Delete(fsys->fldmap->weather_data);	// VCj
			SeedSys_Finish(fsys->fldmap->seedsys);
			FogSys_Delete(&fsys->fog_data);			// tHOf[^
			GLST_Delete(&fsys->glst_data);			// O[oXe[gf[^ 
			
			clact_delete();							// ZAN^[f[^
			
//			FieldMessageWinDel(fsys->bgl);		// bZ[WEBhEJ
			bg_exit(fsys->bgl);					// BGLJ

			FieldSubScreen_Quit(fsys);			//TuʏINGXg
			(*seq) ++;
		}
		break;

	case 2:
		if (FieldSubScreen_WaitQuit(fsys)) {	//TuʏI҂
			char_pltt_manager_delete();	// LN^Epbg}l[W[̔j
			BLACT_DestSys();		// r{[hAN^[VXej
			DellVramTransferManager();
			simple_3DBGExit();
			FLDMAPFUNC_Sys_Delete(fsys->fldmap->fmapfunc_sys);
			sys_VBlankFuncChange(NULL, NULL);
			sys_FreeMemoryEz( fsys->bgl );
			sys_FreeMemoryEz( fsys->fldmap );
			fsys->fldmap = NULL;
			//tB[hq[v
			sys_DeleteHeap( HEAPID_FIELD );
			return PROC_RES_FINISH;
		}
		break;

	}
	return PROC_RES_CONTINUE;
}


//------------------------------------------------------------------
/**
 * @brief	vZX`f[^FtB[hibj
 */
//------------------------------------------------------------------
const PROC_DATA FieldProcData = {
	FieldMapProc_Init,
	FieldMapProc_Main,
	FieldMapProc_End,
	NO_OVERLAY_ID,
};



//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	@WXV̊Ď
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
static BOOL WatchPlayerPosition(FIELDSYS_WORK * fsys)
{
	int x,z;
	x = Player_NowGPosXGet( fsys->player );
	z = Player_NowGPosZGet( fsys->player );
	if (x != fsys->location->grid_x || z != fsys->location->grid_z) {
		fsys->location->grid_x = x;
		fsys->location->grid_z = z;
		return TRUE;
	} else {
		return FALSE;
	}
}



//------------------------------------------------------------------
/**
 * @brief	tB[hł̃][ؑ
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	BOOL	TRUÊƂA][؂ւ
 */
//------------------------------------------------------------------
static BOOL FieldMap_ZoneChange(FIELDSYS_WORK * fsys)
{
	u32 new_zone_id;
	u32 old_zone_id;
	int x,z;
	u16 weather;
	SITUATION * sit;

	x = Player_NowGPosXGet( fsys->player ) / BLOCK_GRID_W;
	z = Player_NowGPosZGet( fsys->player ) / BLOCK_GRID_W;
	new_zone_id = World_GetZoneIDFromMatrixXZ(fsys->World, x, z);
	old_zone_id = fsys->location->zone_id;
	//Õ][Ǝ̃][ꍇ͉Ȃ
	if (new_zone_id == old_zone_id) {
		return FALSE;
	}

	//++++++++++++++	][f[^폜	++++++++++++
	{
		//OBJf[g
		FieldOBJSys_DeleteZoneOld( fsys->fldobjsys, old_zone_id );
	}


	//++++++++++++++	][XV			++++++++++++
	{
		sit = SaveData_GetSituation(fsys->savedata);
		//P[VXVin̕ψڂ̂߁A][hĉ݂̍XVƂȂBj
		fsys->location->zone_id = new_zone_id;
		//][ʃf[^̓ǂݍ
		EventData_LoadZoneData(fsys, new_zone_id);

		//-------------------------------------
		//SẴg[i[tOZbgI
		LocalEventFlagClear(fsys);
		weather = WeatherData_Get(fsys, new_zone_id);
		//weather = ZoneData_GetWeatherID(new_zone_id);
		Situation_SetWeatherID(sit, weather);
		{
			GF_ASSERT_MSG(
					Situation_GetCameraID(sit) == ZoneData_GetCameraID(new_zone_id),
					"tB[hŃJ؂ւĂ܂II\n");
		}
		SpScriptSearch(fsys, SP_SCRID_FLAG_CHANGE);
		//-------------------------------------------
//		UpdateFootMark(fsys);

	}


	//++++++++++++++	V][f[^ǉ	++++++++++++
	{
		//tF[hAEg  ǉg`ǂݍ  BGMĐ
		Snd_FadeOutNextPlayCall( fsys, Snd_FieldBgmNoGet(fsys,fsys->location->zone_id), 
									BGM_FADE_FIELD_MODE );

		;//OBJo^
		EventData_SetFieldOBJ(fsys);

		//V󃊃NGXg
		WEATHER_ChengeReq(fsys->fldmap->weather_data, weather);
	}

	return TRUE;
}


//------------------------------------------------------------------
/**
 * @brief	tB[h}bvXV
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
static void FieldMap_Update(FIELDSYS_WORK * fsys, u8 flag)
{

	if (FieldEvent_Check(fsys) == FALSE) {
		EVTIME_Update(fsys);
	}

	MainLightCont(fsys->light_cont_data);		// CgC

	//`ltF[hVXe(ƖŋȂ̃`l)
	Snd_TrackFadeCall( fsys,Snd_FieldBgmNoGet(fsys,fsys->location->zone_id) );


	BoardMain( fsys );		// Ŕ

	DEBUG_INIT_TICK();
	DEBUG_STORE_TICK(0);
	if( SET_FUNC_CHECK( flag, SET_FIELD_ANIME ) != 0 ){
		FieldAnimeMain(fsys->fldmap->field_trans_anime);	// tB[h]Aj
	}
	if( SET_FUNC_CHECK( flag, SET_FIELD_3D_ANIME ) != 0 ){	//tB[h3cAj
		F3DA_Main(fsys->field_3d_anime);
	}
	DEBUG_STORE_TICK(1);
	if( SET_FUNC_CHECK( flag, SET_DIVMAP_LOAD ) != 0 ){
		DivMapLoadMain(fsys, fsys->map_cont_dat);				//}bv[hC֐
	}
	DEBUG_STORE_TICK(2);
	if( SET_FUNC_CHECK( flag, SET_MAP3D_WRITE ) != 0 ){
		Map3Dwrite( fsys );						// `GW
	}
	DEBUG_STORE_TICK(3);

	if (sys.trg & PAD_BUTTON_X){
		DEBUG_CLEAR_TICK();
	}

}


//------------------------------------------------------------------
/**
 * @brief	^E}bvՏ̃Abvf[g
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * 
 * townmap_footmark.cɈړ邩ȂB
 */
//------------------------------------------------------------------
static void UpdateFootMark(FIELDSYS_WORK * fsys)
{
	TOWN_MAP_FOOTMARK * footmark;
	int x, z, dir;

	if (ZoneData_IsSinouField(fsys->location->zone_id) == FALSE) {
		//tB[hȊOł͑Ղ̍XV͂ȂI
		return;
	}
	footmark = Situation_GetTMFootMark(SaveData_GetSituation(fsys->savedata));
	x = Player_NowGPosXGet(fsys->player) / BLOCK_GRID_W;
	z = Player_NowGPosZGet(fsys->player) / BLOCK_GRID_H;
	dir = Player_DirGet(fsys->player);
	TMFootMark_Update(footmark, x, z, dir);
}


//============================================================================================
//============================================================================================
//===========================================================================
/**
 * 
 * uq`loNݒ
 *
 */
//===========================================================================
static void vram_bank_set(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_01_AB,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

static void debug_vram_bank_set(void)
{
	GF_BGL_DISPVRAM vramSetTable = {
		GX_VRAM_BG_128_C,				// C2DGWBG
		GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
		GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
		GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
		GX_VRAM_OBJ_16_F,				// C2DGWOBJ
		GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
		GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
		GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
		GX_VRAM_TEX_NONE,				// eNX`C[WXbg
		GX_VRAM_TEXPLTT_0123_E			// eNX`pbgXbg
	};
	GF_Disp_SetBank( &vramSetTable );
}

//===========================================================================
/**
 * 
 * afݒ 
 *
 */
//===========================================================================
static void bg_set( GF_BGL_INI * ini )
{
	{
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS,GX_BGMODE_0,GX_BGMODE_0, GX_BG0_AS_3D
		};
		GF_BGL_InitBG(&BGsys_data);
	}

	{	// MAIN DISPiGtFNgPj
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, FLD_MBGFRM_EFFECT1, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_EFFECT1, 32, 0, HEAPID_FIELD );
		GF_BGL_ScrClear( ini, FLD_MBGFRM_EFFECT1 );
	}

	{	// MAIN DISPiGtFNgQj
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_23,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, FLD_MBGFRM_EFFECT2, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_EFFECT2, 32, 0, HEAPID_FIELD );
		GF_BGL_ScrClear( ini, FLD_MBGFRM_EFFECT2 );
	}
	{	// MAIN DISPibZ[Wj
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_23,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, FLD_MBGFRM_FONT, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_FONT, 32, 0, HEAPID_FIELD );
		GF_BGL_ScrClear( ini, FLD_MBGFRM_FONT );
	}

//	OS_Printf(
//		"BGL_Alloc!! 1st appHeap = %ld\n", sys_GetHeapFreeSize(HEAPID_FIELD) );

	{
		u16	pal = BG_CLEAR_COLOR;
		DC_FlushRange( (void*)pal, 2 );
		GX_LoadBGPltt( &pal, 0, 2 );
	}

}


// BGLJ
static void bg_exit( GF_BGL_INI * ini )
{
	GF_Disp_GX_VisibleControl(
		GX_PLANEMASK_BG0 | GX_PLANEMASK_BG1 | GX_PLANEMASK_BG2 | GX_PLANEMASK_BG3, VISIBLE_OFF );

	GF_BGL_BGControlExit( ini, FLD_MBGFRM_EFFECT1 );
	GF_BGL_BGControlExit( ini, FLD_MBGFRM_EFFECT2 );
	GF_BGL_BGControlExit( ini, FLD_MBGFRM_FONT );
}
// ZAN^[pLOAM}l[W̏
static void join_clact_oam_init(void)
{
	// OAM}l[W[̏
	NNS_G2dInitOamManagerModule();

	// LOAM}l[W쐬
	// _pOAM}l[W쐬
	// ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			0, 124,		// COAMǗ̈
			0, 31,		// CʃAtBǗ̈
			0, 124,		// TuOAMǗ̈
			0, 31,		// TuʃAtBǗ̈
			HEAPID_FIELD);
	
}

// ZAN^[
static void clact_delete(void)
{
	// _[LOAM}l[Wj
	REND_OAM_Delete();
}


// ftHg̃O[oXe[g̏Ԃݒ
static void field_glb_state_init(GLST_DATA_PTR glb)
{
	GLST_MdlPolyMode(glb, GX_POLYGONMODE_MODULATE, FALSE);
	GLST_MdlCullMode(glb, GX_CULL_BACK, FALSE);
	GLST_MdlAlpha(glb, 31, FALSE);
	GLST_MdlMisc(glb, GX_POLYGON_ATTR_MISC_FOG, TRUE, FALSE);

	GLST_Reflect(glb, GLST_ALL);		// ݒ
}

//-------------------------------------
//
//	LN^}l[W[
//	pbg}l[W[̏
//
//=====================================
void char_pltt_manager_init(void)
{
	// LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			FLD_CHAR_CONT_NUM,
			FLD_CHAR_VRAMTRANS_MAIN_SIZE,
			FLD_CHAR_VRAMTRANS_MAIN_SIZE,
			HEAPID_FIELD
		};
		
		InitCharManagerReg(&cm, GX_OBJVRAMMODE_CHAR_1D_32K, GX_OBJVRAMMODE_CHAR_1D_32K );
	}
	// pbg}l[W[
	InitPlttManager(FLD_PLTT_CONT_NUM, HEAPID_FIELD);

	// ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();
}

//-------------------------------------
//
//	LN^}l[W[
//	pbg}l[W[̔j
//
//=====================================
void char_pltt_manager_delete(void)
{
	// LN^f[^j
	DeleteCharManager();
	// pbgf[^j
	DeletePlttManager();
}

extern void UGBASE_DrawPanel();
//===========================================================================
/**
 * 
 * `
 *
 */
//===========================================================================
static void Map3Dwrite(FIELDSYS_WORK * repw)
{
	MtxFx44 org_pm,pm;
	//Rc`Jn
	GF_G3X_Reset();

	GFC_CameraLookAt();

	//hꑐ͈͊O`FbNij
	SwayGrass_CheckIO(repw);
	
	DrawAroundBlock(repw->map_cont_dat,repw->glst_data);
		
	M3DO_DrawMap3DObjExp(repw->Map3DObjExp);
	//vWFNV}gNX̕ϊ
	{
		const MtxFx44 *m;
		m = NNS_G3dGlbGetProjectionMtx();
/**		
		OS_Printf("%x,%x,%x,%x\n%x,%x,%x,%x\n%x,%x,%x,%x\n%x,%x,%x,%x\n",
				m->_00,m->_01,m->_02,m->_03,
				m->_10,m->_11,m->_12,m->_13,
				m->_20,m->_21,m->_22,m->_23,
				m->_30,m->_31,m->_32,m->_33);
*/				
		org_pm = *m;
		pm = org_pm;
		pm._32 += FX_Mul(pm._22,PRO_MAT_Z_OFS*FX32_ONE);
		NNS_G3dGlbSetProjectionMtx(&pm);
		NNS_G3dGlbFlush();		//@WIgR}h]
	}

	//tB[hGtFNg`
	FE_Draw( repw->fes );
	
	// r{[hAN^[VXe`
	BLACT_DrawSys();
	//vWFNV}gNXɖ߂
	{
		NNS_G3dGlbSetProjectionMtx(&org_pm);
		NNS_G3dGlbFlush();		//@WIgR}h]
	}
//	BLACT_AfterDrawSys();	// r{[hAN^[`㏈


	//閧npl`ibj
	UGBASE_DrawPanel();
	
	/* WIg_OGW֘ÃXbv */
	GF_G3_RequestSwapBuffers(GX_SORTMODE_AUTO, SwapBuffMode);
#ifdef DEBUG_3DDRAW_COUNT	
	simple_3DDrawPolygonCountUp();
#endif
}


//===========================================================================
/**
 *
 * Px
 *
 */
//===========================================================================
void FieldBrightnessFadeSet( u8 flg )
{
	if( flg == FLD_DISP_BRIGHT_BLACKOUT ){		// AEg
		ChangeBrightnessRequest(
			COMM_BRIGHTNESS_SYNC, BRIGHTNESS_BLACK,
			BRIGHTNESS_NORMAL, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
	}else if (flg == FLD_DISP_BRIGHT_BLACKIN){	// C
		ChangeBrightnessRequest(
			COMM_BRIGHTNESS_SYNC, BRIGHTNESS_NORMAL,
			BRIGHTNESS_BLACK, PLANEMASK_ALL, MASK_DOUBLE_DISPLAY );
	}
}

//===========================================================================
/**
 *
 * tB[hpCvVXegpPxtF[h
 *
 */
//===========================================================================
void FieldFadeWipeSet(const u8 flg, FIELDSYS_WORK *fsys)
{
	if( flg == FLD_DISP_BRIGHT_BLACKIN ){
		WIPE_Start(
			WIPE_PATTERN_WMS, WIPE_TYPE_FADEIN,
			WIPE_TYPE_FADEIN, WIPE_FADE_BLACK, COMM_BRIGHTNESS_SYNC, 1, HEAPID_FIELD, &fsys->fldmap->FadeFlg );
	}else if (flg == FLD_DISP_BRIGHT_BLACKOUT){
		WIPE_Start(
			WIPE_PATTERN_WMS, WIPE_TYPE_FADEOUT,
			WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK, COMM_BRIGHTNESS_SYNC, 1, HEAPID_FIELD, &fsys->fldmap->FadeFlg );
	}else{
		GF_ASSERT(0&&"tF[hw~X");
	}
}

//===========================================================================
/**
 *
 * PxtF[hIo֐
 *
 */
//===========================================================================
BOOL IsFinishedFieldFadeWipe(FIELDSYS_WORK *fsys)
{
	return fsys->fldmap->FadeFlg;
}


static void FieldMapLoadSeq( FIELDSYS_WORK * repw )
{
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );	// BG0\

	// WIg_OGW֘ÃXbv
	// \f[^SɏāA[ĥh܂B
	G3_SwapBuffers( GX_SORTMODE_AUTO, SwapBuffMode );

	//P[V񂩂ǂݍރ}bv
	//
	repw->field_3d_anime = F3DA_Field3DAnimeInit();	//tB[h3cAjm
	repw->AnimeContMng = F3DASub_InitField3DAnimeCont();

//SetUpWorldMatrix( repw->location->zone_id, repw->World ); <<20060116 move
	{
		u16 area_id;
		area_id = ZoneData_GetAreaID(repw->location->zone_id);
		repw->MapResource = AllocMapResource(	area_id,
												repw->field_3d_anime	);
		
		GF_ASSERT(repw->mmdl == NULL);
		repw->mmdl = MMDL_Create(HEAPID_FIELD, area_id);
		
	}
}

static BOOL FieldMapLoadSeqMapResource( FIELDSYS_WORK * repw )
{
	BOOL rc;
	rc = SetupMapResource(repw->MapResource);
	return rc;
}

static void FieldMapLoadSeqDivMap(FIELDSYS_WORK * repw)
{
	int ground_mem_size;
	int height_mem_size;
	//Ƃ肠ŕB̕͏Ȃ̂H
	if (repw->MapFlag == MAP_FLAG_UNDER){
		ground_mem_size = UNDER_GROUND_MEM_SIZE;
		height_mem_size = UNDER_HEIGHT_MEM_SIZE;
		//}bv[h̕@
		SetUpDivFuncList(repw, DIV_MAP_MODE_UNDER);//<<20060217add
	}else if (repw->MapFlag == MAP_FLAG_GROUND){
		ground_mem_size = GROUND_MEM_SIZE;
		height_mem_size = HEIGHT_MEM_SIZE;
		//}bv[h̕@
		SetUpDivFuncList(repw, DIV_MAP_MODE_GROUND);//<<20060217add
	}else{
		GF_ASSERT(0&&"ERROR:}bvłȂ");
	}
	repw->map_cont_dat = InitDivMap(repw->World,
									repw->MapResource,
									repw->field_3d_anime,
									repw->div_func_list,
									ground_mem_size,
									height_mem_size);		// }bvǗf[^m
	
	//gf[^̈m
	repw->ExHeightList = EXH_AllocExHeightList(EX_HEIGHT_NUM, HEAPID_FIELD);

	if (repw->MapFlag == MAP_FLAG_GROUND){
		//DIVɖhp̃R[obNݒ
		DIVM_SetLoadCallBack( repw->map_cont_dat, HTE_SetHoneyTreeAnimeCallBack, repw );
	}

	LoadDivMap( repw->map_cont_dat,
				repw->location->grid_x,
				repw->location->grid_z);
/**
	//tB[hM~bNZbgAbv
	FLDGMK_SetUpFieldGimmick(repw);
	//|eXg
	if (ZONE_ID_C02GYM0101 == repw->location->zone_id){
		GYM_SetupSteelGym(repw);
	}
*/	
}

static void FieldMapLoadSeqFeMoveObj(FIELDSYS_WORK * repw)
{
	//tB[hGtFNg
	repw->fes = FE_Init(repw,HEAPID_FIELD,FIELD_EFFECT_ACTOR_MAX,FIELD_EFFECT_BLACT_MAX);
	//nł΃tB[hOBJɉetȂ
	if( repw->MapFlag == MAP_FLAG_UNDER ){
		FieldOBJSys_ShadowJoinSet( repw->fldobjsys, FALSE );
	}
	
	//tB[hOBJ`揈
	FieldOBJSys_DrawInit( repw->fldobjsys,
			FLDOBJ_RESM_MAX_TEX,		//o^ő吔
			MMDL_GetListSize(repw->mmdl) + FLDOBJ_RESM_REG_ALWAYS_NUM,	//풓o^ő吔iVXepSj
			//FLDOBJ_RESM_REG_MAX_TEX,	//풓o^ő吔AƂ肠Œl
			MMDL_GetList(repw->mmdl) );
	Player_DrawInit( repw->player );	//@`揉
	FieldOBJ_DrawProcPopAll( repw->fldobjsys );			//ĂSOBJ̕`揈A
	FieldOBJSys_MoveStopAllClear( repw->fldobjsys );
	DivMapBindTarget(
			Player_VecPosPtrGet(repw->player), repw->map_cont_dat);//n`oCh
}

static void FieldMapLoadSeqRest(FIELDSYS_WORK * repw)
{
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );	// BG0\

	GF_Disp_DispOn();		// fBXvCI

	repw->glst_data = GLST_Init();			// CgE}eAE|Sݒ̏ԂۑVXe쐬
	field_glb_state_init(repw->glst_data);	// ftHg̏Ԃۑ

	repw->fog_data = FogSys_Init();			// tHȌԂۑVXe쐬
	
	//J̐ݒ
	{
		int camera_id = Situation_GetCameraID(SaveData_GetSituation(repw->savedata));
		FieldCameraInit( Player_VecPosPtrGet(repw->player), repw, camera_id);
	}
	
	repw->light_cont_data = InitLightCont(repw->glst_data,
											MAPRES_GetLightIndex(repw->MapResource));
	
	repw->fldmap->seedsys = SeedSys_Init(repw, HEAPID_FIELD);
	repw->fldmap->weather_data = WEATHER_Init(repw);	// VCVXe

	repw->fldmap->place_name_cont = AllocPlaceNameCont(repw->bgl);//n\\̊m

	repw->board = BoardWorkAlloc( HEAPID_FIELD );		// Ŕ[Nm
	
	// tB[h]Aj
	repw->fldmap->field_trans_anime = InitFieldAnime();
	FieldAnimeSets(repw->fldmap->field_trans_anime, GetMapResourceTexturePTR(repw->MapResource));

	//tB[hM~bNZbgAbv
	FLDGMK_SetUpFieldGimmick(repw);

	//`FbN^XNǉ
	QuickSand_CheckTask(repw);
	
	//VuN֐Zbg
	sys_VBlankFuncChange(vBlankFunc, repw->bgl);
}





//============================================================================================
//
//
//				GAʓ샂fXg֘A
//
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	샂fXg̏
 */
//------------------------------------------------------------------
#define	MMDL_MAX	(FLDOBJ_RESM_REG_MAX_TEX)

//------------------------------------------------------------------
/**
 * @brief	샂fXg䃏[N`
 */
//------------------------------------------------------------------
struct MMDL_WORK{
	u16 count;				///<샂fXg̒`
	int id[MMDL_MAX];		///<샂fXg
};
//------------------------------------------------------------------
/**
 * @brief	샂fXgF
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @param	area_id	ZbgGA̎w
 */
//------------------------------------------------------------------
static MMDL_WORK * MMDL_Create(int heapID, int area_id)
{
	int i;
	u16 * arc;
	MMDL_WORK * mmdl;

	mmdl = sys_AllocMemory(heapID, sizeof(MMDL_WORK));
	arc = ArchiveDataLoadMallocLo(ARC_MMDL, area_id, heapID);
	for (i = 0; i < MMDL_MAX; i++) {
		mmdl->id[i] = OBJCODEMAX;
	}
	for (i = 0; i < MMDL_MAX; i++) {
		mmdl->id[i] = arc[i];
		if (arc[i] == OBJCODEMAX) {
			break;
		}
	}
	mmdl->count = i;
	sys_FreeMemoryEz(arc);
	return mmdl;
}

//------------------------------------------------------------------
/**
 * @brief	샂fXgFXg擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	u16		샂fXgւ̃|C^
 */
//------------------------------------------------------------------
static const int * MMDL_GetList(const MMDL_WORK * mmdl)
{
	return mmdl->id;
}
//------------------------------------------------------------------
/**
 * @brief	샂fXgFXg̒`擾
 * @param	fsys	tB[h䃏[Nւ̃|C^
 * @return	u16		샂fXg̒`
 */
//------------------------------------------------------------------
static const int MMDL_GetListSize(const MMDL_WORK * mmdl)
{
	return mmdl->count;
}

//------------------------------------------------------------------
/**
 * @brief	샂fXgFI
 * @param	fsys	tB[h䃏[Nւ̃|C^
 */
//------------------------------------------------------------------
static void MMDL_Delete(MMDL_WORK * mmdl)
{
	sys_FreeMemoryEz(mmdl);
}

#ifdef PM_DEBUG
void DebugDispTexBank(const u8 inNo)
{
	GXVRamTex tex_bank;
	tex_bank = GX_GetBankForTex();
	if (tex_bank==0){
		OS_Printf("%d:disp_tex_bank=%d\n",inNo,tex_bank);
	}
	GF_ASSERT(tex_bank!=0&&"eNX`oNj󔭐");
/*	
	if (tex_bank==0){
		OS_Printf("eNX`oNj󔭐");
	}
*/	
}
#endif

