//============================================================================================
/**
 * @file	fieldmap_func.c
 * @brief	tB[h}bvœ삷鐧^XNVXe
 * @author	tamada GAME FREAK inc.
 * @date	2006.03.15
 *
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"
#include "fieldmap_work.h"

#include "fieldmap_func_def.h"
#include "fieldmap_func.h"

//============================================================================================
//============================================================================================
typedef struct {
	u32 dmy[8];			///<Ƃ肠̃[N
}FREE_WORK;

//------------------------------------------------------------------
/**
 * @brief	tB[h}bvp^XNVXẽVXe[N`
 */
//------------------------------------------------------------------
struct FLDMAPFUNC_SYS{
	FIELDSYS_WORK * fsys;		///<tB[hVXeւ̃|C^
	int heapID;					///<gpq[vID
	int max;					///<FLDMAPFUNC̍ő吔
	FLDMAPFUNC_WORK * array;	///<FLDMAPFUNCp[N̔zւ̃|C^
};

//------------------------------------------------------------------
/**
 * @brief	tB[h}bvp^XN̐䃏[N`
 */
//------------------------------------------------------------------
struct FLDMAPFUNC_WORK{
	FLDMAPFUNC_SYS * sys;			///<VXeւ̃|C^
	TCB_PTR tcb;					///<ێĂTCBւ̃|C^
	const FLDMAPFUNC_DATA * data;	///<`f[^ւ̃|C^
	void * free_work;				///<ꂼŎgp郏[Nւ̃|C^
};

#define	DEFAULT_FREEWORK_SIZE	(sizeof(FREE_WORK))

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[h}bv^XNFVXeA
 * @param	fsys			tB[h䃏[Nւ̃|C^
 * @param	heapID			gpq[v̎w
 * @param	max
 * @return	FLDMAPFUNC_SYS	tB[h}bv^XNVXẽVXe[Nւ̃|C^
 */
//------------------------------------------------------------------
FLDMAPFUNC_SYS * FLDMAPFUNC_Sys_Create(FIELDSYS_WORK * fsys, int heapID, int max)
{
	FLDMAPFUNC_SYS * sys;
	sys = sys_AllocMemory(heapID, sizeof(FLDMAPFUNC_SYS));
	sys->fsys = fsys;
	sys->heapID = heapID;
	sys->max = max;
	sys->array = sys_AllocMemory(heapID, sizeof(FLDMAPFUNC_WORK) * max);
	MI_CpuClear32(sys->array, sizeof(FLDMAPFUNC_WORK) * max);
	return sys;
}

//------------------------------------------------------------------
/**
 * @brief	tB[h}bv^XNFVXeIA
 * @return	sys		tB[h}bv^XNVXẽVXe[Nւ̃|C^
 */
//------------------------------------------------------------------
void FLDMAPFUNC_Sys_Delete(FLDMAPFUNC_SYS * sys)
{
	int i;
	for (i = 0; i < sys->max; i++) {
		FLDMAPFUNC_Delete(&sys->array[i]);
	}
	sys_FreeMemoryEz(sys->array);
	sys_FreeMemoryEz(sys);
}

//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[h}bv^XŇĂяo
 * @param	tcb		gpTCBւ̃|C^
 * @param	work	gp郏[Nւ̃|C^ȉꍇAKFLDMAPFUNC_WORKւ̃|C^j
 */
//------------------------------------------------------------------
static void FLDMAPFUNC_Tcb(TCB_PTR tcb, void * work)
{
	FLDMAPFUNC_WORK * fwk = work;
	//tB[hC삵ĂԂ삷
	if (GameSystem_CheckFieldMain(fwk->sys->fsys)) {
		fwk->data->update_func(fwk, fwk->sys->fsys, fwk->free_work);
	}
}

//------------------------------------------------------------------
/**
 * @brief	tB[h}bv^XNF
 * @param	sys		tB[h}bv^XNVXẽVXe[Nւ̃|C^
 * @param	data	悤ƂĂ鐧^XN̒`f[^
 * @return	FLDMAPFUNC_WORK	^XÑ[Nւ̃|C^
 */
//------------------------------------------------------------------
FLDMAPFUNC_WORK * FLDMAPFUNC_Create(FLDMAPFUNC_SYS * sys, const FLDMAPFUNC_DATA * data)
{
	int i;
	FLDMAPFUNC_WORK * fwk;
	for (fwk = sys->array, i = 0; i < sys->max; fwk ++, i++) {
		if (fwk->tcb == NULL) {
			fwk->tcb = TCB_Add(FLDMAPFUNC_Tcb, fwk, data->pri);
			fwk->sys = sys;
			fwk->data = data;
			GF_ASSERT(fwk->tcb != NULL);
			if (data->work_size != 0) {
				fwk->free_work = sys_AllocMemory(sys->heapID, data->work_size);
			}
			data->create_func(fwk, sys->fsys, fwk->free_work);
			return fwk;
		}
	}
	GF_ASSERT_MSG(0, "FLDMAPFUNC:VKǉɎs܂\n");
	return NULL;
}

//------------------------------------------------------------------
/**
 * @brief	tB[h}bv^XNF
 * @param	fwk		FLDMAPFUNC_WORKւ̃|C^
 */
//------------------------------------------------------------------
void FLDMAPFUNC_Delete(FLDMAPFUNC_WORK * fwk)
{
	if (fwk->tcb == NULL) {
		return;
	}
	//ʏĂяo
	fwk->data->delete_func(fwk, fwk->sys->fsys, fwk->free_work);
	if (fwk->data->work_size != 0) {
		sys_FreeMemoryEz(fwk->free_work);
	}
	TCB_Delete(fwk->tcb);
	MI_CpuClear32(fwk, sizeof(FLDMAPFUNC_WORK));
}


//============================================================================================
//============================================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------


//------------------------------------------------------------------
//------------------------------------------------------------------
