//******************************************************************************
/**
 *
 * @file	fieldobj_blact.c
 * @brief	tB[hOBJ r{[hAN^[֘A
 * @author	kagaya
 * @data	05.07.25
 *
 */
//******************************************************************************
#include "common.h"
#include "fieldsys.h"
#include "fieldobj.h"

//==============================================================================
//	define
//==============================================================================
//--------------------------------------------------------------
///	FldOBJ_BlActResm_AddResTbl()̖߂l
//--------------------------------------------------------------
enum
{
	ADDRES_FALSE= 0,										///<o^ς
	ADDRES_TRUE,											///<o^
	ADDRES_NOTBLACT,										///<r{[hł͂Ȃ
};

//==============================================================================
//	typedef struct
//==============================================================================
//--------------------------------------------------------------
///	GUEST_BLACT_ADD_WORK\
//--------------------------------------------------------------
typedef struct
{
	int code;												///<\OBJR[h
	FIELD_OBJ_PTR	fldobj;									///<ǉΏۂFIELD_OBJ_PTR
	BLACT_WORK_PTR	*act;									///<ǉꂽr{[h *i[
}GUEST_BLACT_ADD_WORK;

///GUEST_BLACT_ADD_WORKTCY
#define GUEST_BLACT_ADD_WORK_SIZE (sizeof(GUEST_BLACT_ADD_WORK))
///BLACT_ADD_TBLTCY
#define GUEST_BLACT_ADD_WORK_ALL_SIZE (GUEST_BLACT_ADD_WORK_SIZE*FLDOBJ_RESM_MAX_TEX)

//--------------------------------------------------------------
///	VINTR_WORK\
//--------------------------------------------------------------
typedef struct
{
	vu32 access_flag;										///<ANZXtO
	int max;
	FIELD_OBJ_BLACT_CONT *cont;								///<FIELD_OBJ_BLACT_CONT *
	TEXRES_MANAGER_PTR *resm_tex_tbl;						///<]eNX`e[u
	int *resm_tex_id_tbl;									///<]IDe[u
}VINTR_WORK;

#define VINTR_WORK_SIZE (sizeof(VINTR_WORK))				///<VINTR_WORKTCY

//==============================================================================
//	vg^Cv
//==============================================================================
static void FldOBJ_BlActGuestAddTcbAdd( FIELD_OBJ_BLACT_CONT *cont, int pri );
static void FldOBJ_BlActGuestAddTcbDelete( FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_GuestBlActAddTcb( TCB_PTR tcb, void *wk );

static void FldOBJ_BlActVIntrTcbAdd( FIELD_OBJ_BLACT_CONT *cont, int max, int pri );
static void FldOBJ_BlActVIntrTcbDelete( FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_VIntrTcb( TCB_PTR tcb, void *wk );
static void FldOBJ_VIntrTcb_TexLoadAdd(
		FIELD_OBJ_BLACT_CONT *cont, TEXRES_MANAGER_PTR resm, int id );
static void FldOBJ_VIntrTcb_TexLoadCancel( FIELD_OBJ_BLACT_CONT *cont, int id );

static void FldOBJ_BlActHeaderManageInit( FIELD_OBJ_BLACT_CONT *cont, int max );
static void FldOBJ_BlActHeaderManageDelete( FIELD_OBJ_BLACT_CONT *cont );
static BLACT_HEADER * FldOBJ_BlActHeaderManageGet( FIELD_OBJ_BLACT_CONT *cont, u32 code );
static void FldOBJ_BlActHeaderManageFree( FIELD_OBJ_BLACT_CONT *cont, u32 code );
static void FldOBJ_BlActHeaderManageFreeForce( FIELD_OBJ_BLACT_CONT *cont );
static int FldOBJ_OBJCodeUseSearch(
		CONST_FIELD_OBJ_SYS_PTR sys, CONST_FIELD_OBJ_PTR fldobj, int code );

static void FldOBJ_BlActResManageInit( FIELD_OBJ_BLACT_CONT *cont,
		int mdl_max, int mdl_reg_max,
		int anm_max, int anm_reg_max,
		int tex_max, int tex_reg_max );
static void FldOBJ_BlActResManageDelete( FIELD_OBJ_BLACT_CONT *cont );
static const FIELD_OBJ_RESMH * FldOBJ_BlActResmH_Search( int id, const FIELD_OBJ_RESMH *tbl );
static const FIELD_OBJ_RESMNARC * FldOBJ_BlActResmNArc_Search(
					int id, int max_id, const FIELD_OBJ_RESMNARC *tbl );
static int FldOBJ_BlActResmNArc_AddResTbl(
		RES_MANAGER_PTR resm, int id, int max, const FIELD_OBJ_RESMNARC *tbl );
static int FldOBJ_BlActResm_AddResTbl(
	RES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMH *tbl );
static int FldOBJ_BlActResm_AddResNormalTbl(
		RES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMH *tbl );
static int FldOBJ_BlActTexResm_AddResTbl( FIELD_OBJ_BLACT_CONT *cont,
		TEXRES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMH *tbl );
static int FldOBJ_BlActTexResmNArc_AddResTbl( FIELD_OBJ_BLACT_CONT *cont,
		TEXRES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMNARC *tbl );
static void FldOBJ_BlActResm_RegularAdd_Tex( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_GuestAdd_Tex( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_RegularAddTbl_Tex( FIELD_OBJ_BLACT_CONT *cont, const int *tbl );
static void FldOBJ_BlActResm_RegularAdd_Mdl( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_GuestAdd_Mdl( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_RegularAddTbl_Mdl( FIELD_OBJ_BLACT_CONT *cont, const int *tbl );
static void FldOBJ_BlActResm_RegularAdd_Anm( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_GuestAdd_Anm( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_RegularAddTbl_Anm( FIELD_OBJ_BLACT_CONT *cont, const int *tbl );
static void FldOBJ_BlActResm_RegularAdd_All(
	FIELD_OBJ_BLACT_CONT *cont, const int *tex_tbl, const int *mdl_tbl, const int *anm_tbl );
static void FldOBJ_BlActResm_IDTblInit( int *tbl, int init_id, int max );
static int FldOBJ_BlActResm_IDTblReg( int *tbl, int reg_id, int spc_id, int max );
static int FldOBJ_BlActResm_IDTblSearch( int *tbl, int chk_id, int max );
static int FldOBJ_BlActResm_IDTblDel( int *tbl, int del_id, int spc_id, int max );
static void FldOBJ_BlActResm_MdlIDInit( FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActResm_MdlIDReg_Regular( FIELD_OBJ_BLACT_CONT *cont, int id );
static int FldOBJ_BlActResm_MdlIDSearch_Regular( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_MdlIDReg_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static int FldOBJ_BlActResm_MdlIDSearch_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_MdlIDDelete_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_MdlIDDelete_GuestAll(
		FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActResm_AnmIDInit( FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActResm_AnmIDReg_Regular( FIELD_OBJ_BLACT_CONT *cont, int id );
static int FldOBJ_BlActResm_AnmIDSearch_Regular( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_AnmIDReg_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_AnmIDDelete_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_AnmIDDelete_GuestAll(
		FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActResm_TexIDInit( FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActResm_TexIDReg_Regular( FIELD_OBJ_BLACT_CONT *cont, int id );
static int FldOBJ_BlActResm_TexIDSearch_Regular( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_TexIDReg_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_TexIDDelete_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResm_TexIDDelete_GuestAll(
		FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_BLACT_CONT *cont );
static int FldOBJ_BlActResm_TexIDSearch_Guest( FIELD_OBJ_BLACT_CONT *cont, int id );
static int FldOBJ_BlActResManage_OBJCodeRegistCheck( FIELD_OBJ_BLACT_CONT *cont, int code );
static int FldOBJ_BlActResManage_MdlIDRegistCheck( FIELD_OBJ_BLACT_CONT *cont, int id );
static int FldOBJ_BlActResManage_AnmIDRegistCheck( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResManage_OBJCodeRegist( FIELD_OBJ_BLACT_CONT *cont, int code );
static void FldOBJ_BlActResManage_MdlIDRegist( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResManage_AnmIDRegist( FIELD_OBJ_BLACT_CONT *cont, int id );
static void FldOBJ_BlActResManage_AllIDRegist( FIELD_OBJ_BLACT_CONT *cont, int code );
static int FldOBJ_BlActCont_FldOBJSearch_OBJCode( FIELD_OBJ_SYS_PTR fos, int code );
static int FldOBJ_BlActCont_FldOBJSearch_MdlID( FIELD_OBJ_SYS_PTR fos, int mdl_id );
static int FldOBJ_BlActCont_FldOBJSearch_AnmID( FIELD_OBJ_SYS_PTR fos, int anm_id );

static int * FldOBJ_BlActCont_ResmTexIDTblGet( FIELD_OBJ_BLACT_CONT *cont );
static int * FldOBJ_BlActCont_ResmMdlIDTblGet( FIELD_OBJ_BLACT_CONT *cont );
static int * FldOBJ_BlActCont_ResmAnmIDTblGet( FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActCont_RegularMdlMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max );
static int FldOBJ_BlActCont_RegularMdlMaxGet( const FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActCont_GuestMdlMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max );
static int FldOBJ_BlActCont_GuestMdlMaxGet( const FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActCont_RegularAnmMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max );
static int FldOBJ_BlActCont_RegularAnmMaxGet( const FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActCont_GuestAnmMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max );
static int FldOBJ_BlActCont_GuestAnmMaxGet( const FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActCont_RegularTexMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max );
static int FldOBJ_BlActCont_RegularTexMaxGet( const FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActCont_GuestTexMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max );
static int FldOBJ_BlActCont_GuestTexMaxGet( const FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActGuestAddTcbPtrSet( FIELD_OBJ_BLACT_CONT *cont, TCB_PTR tcb );
static TCB_PTR FldOBJ_BlActGuestAddTcbPtrGet( FIELD_OBJ_BLACT_CONT *cont );
static void FldOBJ_BlActContVIntrTcbPtrSet( FIELD_OBJ_BLACT_CONT *cont, TCB_PTR tcb );
static TCB_PTR FldOBJ_BlActContVIntrTcbPtrGet( FIELD_OBJ_BLACT_CONT *cont );

static const FIELD_OBJ_BLACT_HEADER_ID * FldOBJ_BlActHeaderPathIDTblGet( int code );
static int FldOBJ_BlActH_OBJCode_MdlID( int code );
static int FldOBJ_BlActH_OBJCode_AnmID( int code );
static const BLACT_ANIME_TBL * FldOBJ_BlActH_OBJCode_AnmTbl( int code );

static void FldOBJ_BlActInit( FIELD_OBJ_BLACT_CONT *cont, int max );
static void FldOBJ_BlActDestSet( BLACT_SET_PTR set );
static BLACT_WORK_PTR FldOBJ_BlActAdd(
		BLACT_SET_PTR set, const BLACT_HEADER *head, const VecFx32 *vec );
static void FldOBJ_BlActHeaderLoad( FIELD_OBJ_BLACT_CONT * cont, u32 code, BLACT_HEADER *head );
static const FIELD_OBJ_BLACT_CONT * FldOBJ_BlActContGet( CONST_FIELD_OBJ_PTR fldobj );
static FIELD_OBJ_BLACT_CONT * FldOBJ_BlActContGetLocal( CONST_FIELD_OBJ_PTR fldobj );

//==============================================================================
//	r{[hAN^[֘A
//==============================================================================
//--------------------------------------------------------------
/**
 * r{[hAN^[Rg[
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	max		AN^[ő吔
 * @param	pri		QXgr{[hAN^[ǉǗTCBvCIeB
 * @param	tex_max		eNX`ő吔
 * @param	reg_tex_max	M[eNX`o^ő吔
 * @param	rg_tex_tbl	M[eNX`e[u
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_Init( FIELD_OBJ_BLACT_CONT *cont, int max, int pri,
		int tex_max, int reg_tex_max, const int *rg_tex_tbl )
{
	FldOBJ_BlActInit( cont, max );
	
	FldOBJ_BlActGuestAddTcbAdd( cont, pri );
	FldOBJ_BlActVIntrTcbAdd( cont, max, 0 );	//pri
	
	FldOBJ_BlActResManageInit( cont,
			FLDOBJ_RESM_MAX_MDL, FLDOBJ_RESM_REG_MAX_MDL,
			FLDOBJ_RESM_MAX_ANM, FLDOBJ_RESM_REG_MAX_ANM,
			tex_max, reg_tex_max );
	
	FldOBJ_BlActHeaderManageInit( cont, max );
	
	FldOBJ_BlActResm_RegularAdd_All(
			cont,
			rg_tex_tbl,
			DATA_FieldOBJ_Regular_Mdl,
			DATA_FieldOBJ_Regular_Anm );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[Rg[폜
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_Delete( FIELD_OBJ_BLACT_CONT *cont )
{
	FldOBJ_BlActGuestAddTcbDelete( cont );
	FldOBJ_BlActVIntrTcbDelete( cont );
	FldOBJ_BlActHeaderManageDelete( cont );
	FldOBJ_BlActDestSet( FieldOBJ_BlActCont_SetPtrGet(cont) );
	FldOBJ_BlActResManageDelete( cont );
}

//--------------------------------------------------------------
/**
 * tB[hOBJr{[hAN^[ǉB
 * fldobjɊi[Ă\R[hAWAN^[ǉB
 * M[AQXg`FbNsAQXg̏ꍇ̓QXgǉe[u֒ǉ\B
 * ̊֐Ă񂾍ہAactNULLŏB
 * ǉꎟAact֒ǉꂽBLACT_WORK_PTRi[B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	act			BLACT_WORK_PTRi[
 * @param	code		\R[hBHERO
 * @retval	int			REGULARBNOT_REGULAR_GUEST=M[ƂQXgƂo^Bǉe[u֗\B 
 */
//--------------------------------------------------------------
int FieldOBJ_BlActAddRegularGuestCode( FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR *act, int code )
{
	int ret;
	FIELD_OBJ_BLACT_CONT *cont;
	
	*act = NULL;
	cont = FldOBJ_BlActContGetLocal( fldobj );
	ret = FldOBJ_BlActResManage_OBJCodeRegistCheck( cont, code );
	
	if( ret == NOT_REGULAR_GUEST ){
		FieldOBJ_BlActAdd_Guest( fldobj, act, code );
	}else{
		*act = FieldOBJ_BlActAddCode( fldobj, code );
	}
	
	return( ret );
}

//--------------------------------------------------------------
/**
 * tB[hOBJr{[hAN^[ǉB
 * fldobjɊi[Ă\R[hAWAN^[ǉB
 * OBJR[h̓tB[hOBJ擾B
 * M[AQXg`FbNsAQXg̏ꍇ̓QXgǉe[u֒ǉ\B
 * ̊֐Ă񂾍ہAactNULLŏB
 * ǉꎟAact֒ǉꂽBLACT_WORK_PTRi[B
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	act			BLACT_WORK_PTRi[
 * @retval	int			REGULARBNOT_REGULAR_GUEST=M[ƂQXgƂo^Bǉe[u֗\B 
 */
//--------------------------------------------------------------
int FieldOBJ_BlActAddRegularGuest( FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR *act )
{
	int code = FieldOBJ_OBJCodeGet( fldobj );
	int ret = FieldOBJ_BlActAddRegularGuestCode( fldobj, act, code );
	
	return( ret );
}

//--------------------------------------------------------------
/**
 * tB[hOBJr{[hAN^[ǉB\R[hwB
 * fldobjɊi[Ă\R[hAWAN^[ǉ
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	code		\R[hBHERO
 * @retval	BLACT_WORK 	NULL=ǉs
 */
//--------------------------------------------------------------
BLACT_WORK_PTR FieldOBJ_BlActAddCode( FIELD_OBJ_PTR fldobj, int code )
{
	VecFx32 vec;
	BLACT_SET_PTR set;
	BLACT_WORK_PTR work;
	BLACT_HEADER *head;
	FIELD_OBJ_BLACT_CONT *cont;
	
	cont = FldOBJ_BlActContGetLocal( fldobj );
	set = FieldOBJ_BlActCont_SetPtrGet( cont );
	
	FldOBJ_BlActResManage_AllIDRegist( cont, code );
	head = FldOBJ_BlActHeaderManageGet( cont, code );
	
	FieldOBJ_VecPosGet( fldobj, &vec );
	
	work = FldOBJ_BlActAdd( set, head, &vec );
	GF_ASSERT( work != NULL && "fldobj blact add error" );
	
	return( work );
}

#if 0	//̏AgȂ
//--------------------------------------------------------------
/**
 * tB[hOBJr{[hAN^[ǉB\R[hfldobj擾
 * fldobjɊi[Ă\R[hAWAN^[ǉ
 * @param	fldobj		FIELD_OBJ_PTR 
 * @retval	BLACT_WORK 	NULL=ǉs
 */
//--------------------------------------------------------------
BLACT_WORK_PTR FieldOBJ_BlActAdd( FIELD_OBJ_PTR fldobj )
{
	return( FieldOBJ_BlActAddCode(fldobj,FieldOBJ_OBJCodeGet(fldobj)) );
}
#endif

//--------------------------------------------------------------
/**
 * r{[hAN^[폜
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_HEADER
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActDeleteCode( CONST_FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act, int code )
{
	int ret;
	
	BLACT_Delete( act );
	
	ret = FldOBJ_OBJCodeUseSearch( FieldOBJ_FieldOBJSysGet(fldobj), fldobj, code );
	
	if( ret == FALSE ){
		FldOBJ_BlActHeaderManageFree( FldOBJ_BlActContGetLocal(fldobj), code );
	}
}

//--------------------------------------------------------------
/**
 * r{[hAN^[폜
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		BLACT_HEADER
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActDelete( CONST_FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act )
{
	int code = FieldOBJ_OBJCodeGet( fldobj );
	
	if( FieldOBJ_OBJCodeSeedCheck(code) == TRUE ){
		code = FieldOBJ_OBJCodeSeedGet( fldobj );
	}
	
	FieldOBJ_BlActDeleteCode( fldobj, act, code );
}	

//--------------------------------------------------------------
/**
 * r{[hAN^[AjޔB
 * Aj[VA\A\XCb`̑ޔs
 * @param	act		BLACT_WORK_PTR 
 * @param	push	FIELD_OBJ_BLACTANM_PUSH *
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActAnmPush( BLACT_WORK_PTR act, FIELD_OBJ_BLACTANM_PUSH *push )
{
	push->vanish = BLACT_ObjDrawFlagGet( act );
	push->anm_offs = BLACT_AnmOffsGet( act );
	push->frame = BLACT_AnmFrameGet( act );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[AjAB
 * FieldOBJ_BlActAnmPush()őޔAN^[ɔf
 * @param	act		BLACT_WORK_PTR 
 * @param	push	FIELD_OBJ_BLACTANM_PUSH *
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActAnmPop( BLACT_WORK_PTR act, FIELD_OBJ_BLACTANM_PUSH *push )
{
	BLACT_ObjDrawFlagSet( act, push->vanish );
	BLACT_AnmOffsChg( act, push->anm_offs );
	BLACT_AnmFrameSet( act, push->frame );
}

//==============================================================================
//	r{[hAN^[@QXgǉ
//==============================================================================
//--------------------------------------------------------------
/**
 * QXgr{[hAN^[ǉǗTCBǉ
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	pri		ǉǗTCBvCIeB
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActGuestAddTcbAdd( FIELD_OBJ_BLACT_CONT *cont, int pri )
{
	TCB_PTR tcb;
	GUEST_BLACT_ADD_WORK *work;
	
	work = sys_AllocMemory( HEAPID_FIELD, GUEST_BLACT_ADD_WORK_ALL_SIZE );
	GF_ASSERT( work != NULL && "FldOBJ_BlActGuestAddTcbAdd alloc memory Error" );
	memset( work, NULL, GUEST_BLACT_ADD_WORK_ALL_SIZE );
	
	tcb = TCB_Add( FldOBJ_GuestBlActAddTcb, work, pri );
	GF_ASSERT( tcb != NULL && "FldOBJ_BlActGuestAddTcbAdd TCB_Add Error" );
	
	FldOBJ_BlActGuestAddTcbPtrSet( cont, tcb );
}

//--------------------------------------------------------------
/**
 * QXgr{[hAN^[ǉǗTCB폜
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActGuestAddTcbDelete( FIELD_OBJ_BLACT_CONT *cont )
{
	TCB_PTR tcb;
	GUEST_BLACT_ADD_WORK *work;
	
	tcb = FldOBJ_BlActGuestAddTcbPtrGet( cont );
	
	if( tcb == NULL ){
		return;
	}
	
	work = TCB_GetWork( tcb );
	sys_FreeMemory( HEAPID_FIELD, work );
	
	TCB_Delete( tcb );
	
	FldOBJ_BlActGuestAddTcbPtrSet( cont, NULL );
}

//--------------------------------------------------------------
/**
 * TCB QXgr{[hAN^[ǉǗ
 * @param	tcb		TCB_PTR
 * @param	wk		work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_GuestBlActAddTcb( TCB_PTR tcb, void *wk )
{
	int i,count;
	GUEST_BLACT_ADD_WORK *work;
	
	work = wk;
	i = 0;
	count = 0;
	
	do{
		if( work->fldobj != NULL ){
			*(work->act) = FieldOBJ_BlActAddCode( work->fldobj, work->code );
			GF_ASSERT(*(work->act)!=NULL&&"FldOBJ_GuestBlActAddTcb()Error");
			FieldOBJ_BlActAddPracFlagSet( work->fldobj, FALSE );
			
			if( FieldOBJ_StatusBit_CheckEasy(work->fldobj,FLDOBJ_STA_BIT_DRAW_PUSH) == TRUE ){
				FieldOBJ_DrawPopProcCall( work->fldobj );
			}
			
			{										//ǉOBJR[hƓ̂̂𒼌ɒǉ
				int i2 = i + 1;
				int code = work->code;
				GUEST_BLACT_ADD_WORK *work2 = &work[1];
				
				while( i2 < FLDOBJ_RESM_MAX_TEX ){
					if( work2->fldobj != NULL ){
						if( code == work2->code ){
							*(work2->act) = FieldOBJ_BlActAddCode( work2->fldobj, work2->code );
							GF_ASSERT(*(work2->act)!=NULL&&"FldOBJ_GuestBlActAddTcb()Error");
							FieldOBJ_BlActAddPracFlagSet( work2->fldobj, FALSE );
							
							if( FieldOBJ_StatusBit_CheckEasy(
									work2->fldobj,FLDOBJ_STA_BIT_DRAW_PUSH) == TRUE ){
								FieldOBJ_DrawPopProcCall( work2->fldobj );
							}
							
							work2->fldobj = NULL;
							work2->act = NULL;
						}
					}
					work2++; i2++;
				}
			}
			
			work->fldobj = NULL;
			work->act = NULL;
			count++;
			
			if( count >= FLDOBJ_GUEST_BLACT_ADD_ONE_FRAME_MAX ){
				return;
			}
		}
		
		work++;
		i++;
	}while( i < FLDOBJ_RESM_MAX_TEX );
}

//--------------------------------------------------------------
/**
 * QXgr{[hAN^[ǉǗ֗\B
 * Ă񂾍ہAactNULLŏB
 * ǗŃr{[hAN^[ǉƂ̃AhXi[B
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	act		ǉꂽAN^[i[
 * @param	code	\OBJR[h HERO
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActAdd_Guest( FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR *act, int code )
{
	int i;
	TCB_PTR tcb;
	FIELD_OBJ_BLACT_CONT *cont;
	GUEST_BLACT_ADD_WORK *work;
	
	cont = FldOBJ_BlActContGetLocal( fldobj );
	tcb = FldOBJ_BlActGuestAddTcbPtrGet( cont );
	work = TCB_GetWork( tcb );
	
	i = 0;
	
	do{
		if( work->fldobj == NULL ){
			work->fldobj = fldobj;
			work->act = act;
			work->code = code;
			*(work->act) = NULL;
			FieldOBJ_BlActAddPracFlagSet( fldobj, TRUE );
			return;
		}
		
		work++;
		i++;
	}while( i < FLDOBJ_RESM_MAX_TEX );
	
	OS_Printf( "FieldOBJ_BlActAdd_Guest() MAX ERROR QXglOBJǉ\񎸔s\n" );
	OS_Printf( "lOBJ̐@zǔ\n" );
	GF_ASSERT( 0 );
}

//==============================================================================
//	r{[hAN^[wb_[Ǘ
//==============================================================================
//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈m
 * @param	cont		FIELD_OBJ_BLACT_CONT*
 * @param	max			wb_[ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActHeaderManageInit( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	int i,head_size;
	BLACT_HEADER *head;
	FIELD_OBJ_BLACT_HEADER *manage;
	
	i = sizeof(BLACT_HEADER) * max;
	head = sys_AllocMemory( HEAPID_FIELD, i );
	cont->blact_head_tbl = head;
	GF_ASSERT( head != NULL && "fldobj blact header alloc memory error" );
	
	i = FIELD_OBJ_BLACT_HEADER_SIZE * max;
	manage = sys_AllocMemory( HEAPID_FIELD, i );
	cont->head_manage = manage;
	GF_ASSERT( manage != NULL && "fldobj blact header alloc memory error" );
	
	head_size = sizeof(BLACT_HEADER);
	
	do{
		manage->obj_code = OBJCODEMAX;
		manage->head = head;
		manage++;
		(u8 *)head += head_size;
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈폜
 * @param	cont		FIELD_OBJ_BLACT_CONT*
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActHeaderManageDelete( FIELD_OBJ_BLACT_CONT *cont )
{
	FldOBJ_BlActHeaderManageFreeForce( cont );
	
	sys_FreeMemory( HEAPID_FIELD, cont->blact_head_tbl );
	sys_FreeMemory( HEAPID_FIELD, cont->head_manage );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈擾
 * @param	cont			FIELD_OBJ_BLACT_CONT
 * @param	code			擾OBJR[hBHERO
 * @retval	BLACT_HEADER	wb_[̈ւ*BNULL=s
 */
//--------------------------------------------------------------
static BLACT_HEADER * FldOBJ_BlActHeaderManageGet( FIELD_OBJ_BLACT_CONT *cont, u32 code )
{
	int max;
	FIELD_OBJ_BLACT_HEADER *ma;
	
	ma = cont->head_manage;
	max = cont->max;
	
	do{
		if( ma->obj_code == code ){
			return( ma->head );
		}
		
		ma++;
		max--;
	}while( max );
	
	ma = cont->head_manage;
	max = cont->max;
	
	do{
		if( ma->obj_code == OBJCODEMAX ){
			ma->obj_code = code;
			FldOBJ_BlActHeaderLoad( cont, code, ma->head );
			return( ma->head );
		}
		
		ma++;
		max--;
	}while( max );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈擾BO[o
 * @param	cont			FIELD_OBJ_BLACT_CONT
 * @param	code			擾OBJR[hBHERO
 * @param	head			wb_[i[
 * @retval	int				TRUE=i[BFALSE=o^ĂȂ
 */
//--------------------------------------------------------------
int FieldOBJ_BlActHeaderGetOBJCode( CONST_FIELD_OBJ_SYS_PTR fos, u32 code, BLACT_HEADER *head )
{
	int max;
	const FIELD_OBJ_BLACT_CONT *cont;
	FIELD_OBJ_BLACT_HEADER *ma;
	
	cont = FieldOBJSys_BlActContGet( fos );
	ma = cont->head_manage;
	max = cont->max;
	
	do{
		if( ma->obj_code == code ){
			*head = *(ma->head);
			return( TRUE );
		}
		
		ma++;
		max--;
	}while( max );
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈J
 * @param	cont			FIELD_OBJ_BLACT_CONT
 * @param	code			JOBJR[hBHERO
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActHeaderManageFree( FIELD_OBJ_BLACT_CONT *cont, u32 code )
{
	int max;
	FIELD_OBJ_BLACT_HEADER *ma;
	
	ma = cont->head_manage;
	max = cont->max;
	
	do{
		if( ma->obj_code == code ){
			ma->obj_code = OBJCODEMAX;
//			BLACT_HeaderFree( ma->head );					//DEBUG_FLDOBJ_NEW_BLACT_HOOK
			return;
		}
		
		ma++;
		max--;
	}while( max );	
}

//--------------------------------------------------------------
/**
 * r{[hAN^[wb_[Ǘ̈拭J
 * @param	cont			FIELD_OBJ_BLACT_CONT
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActHeaderManageFreeForce( FIELD_OBJ_BLACT_CONT *cont )
{
	int max;
	FIELD_OBJ_BLACT_HEADER *ma;
	
	ma = cont->head_manage;
	max = cont->max;
	
	do{
		if( ma->obj_code != OBJCODEMAX ){
			ma->obj_code = OBJCODEMAX;
//			BLACT_HeaderFree( ma->head );						//DEBUG_FLDOBJ_NEW_BLACT_HOOK
		}
		
		ma++;
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * ݔĂtB[hOBJOBJR[hQ
 * @param	sys			FIELD_OBJ_SYS_PTR 
 * @param	fldobj		FIELD_OBJ_PTR 
 * @param	code		`FbNR[hBHERO
 * @retval	int			TRUE=fldobjȊOɂcodeĂz
 */
//--------------------------------------------------------------
static int FldOBJ_OBJCodeUseSearch(
		CONST_FIELD_OBJ_SYS_PTR sys, CONST_FIELD_OBJ_PTR fldobj, int code )
{
	int i,check_code;
	CONST_FIELD_OBJ_PTR fieldobj;
	
	i = FieldOBJSys_OBJMaxGet( sys );
	fieldobj = FieldOBJSys_FieldOBJWorkGet( sys );
	
	do{
		if( fieldobj != fldobj ){
			if( FieldOBJ_StatusBitCheck_Use(fieldobj) == TRUE ){
				check_code = FieldOBJ_OBJCodeGet( fieldobj );
					
				if( FieldOBJ_OBJCodeSeedCheck(check_code) == TRUE ){
					check_code = FieldOBJ_OBJCodeSeedGet( fieldobj );
				}
				
				if( check_code != OBJCODEMAX && check_code == code ){
					return( TRUE );
				}
			}
		}
		
		FieldOBJSys_FieldOBJWorkInc( &fieldobj );
		i--;
	}while( i );
	
	return( FALSE );
}

//==============================================================================
//	\[X}l[Wݒ
//==============================================================================
//--------------------------------------------------------------
/**
 * \[X}l[W
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	mdl_max		fǗő吔
 * @param	mdl_reg_max	fǗM[ő吔
 * @param	anm_max		AjǗő吔
 * @param	anm_reg_max	AjǗM[ő吔
 * @param	tex_max		eNX`Ǘő吔
 * @param	tex_reg_max	eNX`M[Ǘő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResManageInit( FIELD_OBJ_BLACT_CONT *cont,
		int mdl_max, int mdl_reg_max,
		int anm_max, int anm_reg_max,
		int tex_max, int tex_reg_max )
{
	{
		RES_MANAGER_PTR res;
	
		res = RESM_Init( mdl_max, HEAPID_FIELD );
		FieldOBJ_BlActCont_MdlResManageSet( cont, res );
		FldOBJ_BlActResm_MdlIDInit( cont );
		FldOBJ_BlActCont_RegularMdlMaxSet( cont, mdl_reg_max );
		FldOBJ_BlActCont_GuestMdlMaxSet( cont, mdl_max - mdl_reg_max );
	
		res = RESM_Init( anm_max, HEAPID_FIELD );
		FieldOBJ_BlActCont_AnmResManageSet( cont, res );
		FldOBJ_BlActResm_AnmIDInit( cont );
		FldOBJ_BlActCont_RegularAnmMaxSet( cont, anm_reg_max );
		FldOBJ_BlActCont_GuestAnmMaxSet( cont, anm_max - anm_reg_max );
	}
	
	{
		TEXRES_MANAGER_PTR res;
			
		res = TEXRESM_Init( tex_max, HEAPID_FIELD );
		
		FieldOBJ_BlActCont_TexResManageSet( cont, res );
		FldOBJ_BlActResm_TexIDInit( cont );
		FldOBJ_BlActCont_RegularTexMaxSet( cont, tex_reg_max );
		FldOBJ_BlActCont_GuestTexMaxSet( cont, tex_max - tex_reg_max );
	}
}

//--------------------------------------------------------------
/**
 * \[X}l[WS폜
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	mdl_max	fǗő吔
 * @param	anm_max	AjǗő吔
 * @param	tex_max	eNX`Ǘő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResManageDelete( FIELD_OBJ_BLACT_CONT *cont )
{
	RESM_Delete( FieldOBJ_BlActCont_MdlResManageGet(cont) );
	RESM_Delete( FieldOBJ_BlActCont_AnmResManageGet(cont) );
	TEXRESM_Delete( FieldOBJ_BlActCont_TexResManageGet(cont) );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_RESMH
 * @param	id				ID
 * @param	tbl				e[u
 * @retval	FIELD_OBJ_RESMH	vf[^BNULL=v
 */
//--------------------------------------------------------------
static const FIELD_OBJ_RESMH * FldOBJ_BlActResmH_Search( int id, const FIELD_OBJ_RESMH *tbl )
{
	do{
		if( tbl->id == id ){
			return( tbl );
		}
		
		tbl++;
	}while( tbl->path != NULL );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJ_RESMNARC
 * @param	id				ID
 * @param	max_id			I[ID
 * @param	tbl				e[u
 * @retval	FIELD_OBJ_RESMNARC	vf[^BNULL=v
 */
//--------------------------------------------------------------
static const FIELD_OBJ_RESMNARC * FldOBJ_BlActResmNArc_Search(
					int id, int max_id, const FIELD_OBJ_RESMNARC *tbl )
{
	do{
		if( tbl->id == id ){
			return( tbl );
		}
		
		tbl++;
	}while( tbl->id != max_id );
	
	return( NULL );
}

//--------------------------------------------------------------
/**
 * w肳ꂽRES_MANAGER_PTRAIDAFIELD_OBJ_RESMNARCo^
 * @param	resm	RES_MANAGER_PTR
 * @param	id		o^ID
 * @param	max		tblI[ID
 * @param	tbl		FIELD_OBJ_RESMH
 * @retval	int		TRUE=o^BFALSE=o^ς
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResmNArc_AddResTbl(
		RES_MANAGER_PTR resm, int id, int max, const FIELD_OBJ_RESMNARC *tbl )
{
	RES_OBJ_PTR res;
	const FIELD_OBJ_RESMNARC *head;
	
	if( RESM_CheckID(resm,id) == FALSE ){
		return( FALSE );
	}
	
	head = FldOBJ_BlActResmNArc_Search( id, max, tbl );
	GF_ASSERT( head != NULL && "fldobj resm add res search error" );
	
	{
		void *arc_ptr = ArchiveDataLoadMallocLo( ARC_MMODEL, head->narc_id, HEAPID_FIELD );
		res = RESM_AddResNormal( resm, arc_ptr, id );
		GF_ASSERT( res != NULL && "fldobj resm add error" );
	}
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * w肳ꂽRES_MANAGER_PTRAIDAFIELD_OBJ_RESMHo^
 * @param	resm	RES_MANAGER_PTR
 * @param	id		o^ID
 * @param	tbl		FIELD_OBJ_RESMH
 * @retval	int		TRUE=o^BFALSE=o^ς
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_AddResTbl(
		RES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMH *tbl )
{
	RES_OBJ_PTR res;
	const FIELD_OBJ_RESMH *head;
	
	if( RESM_CheckID(resm,id) == FALSE ){
		return( FALSE );
	}
	
	head = FldOBJ_BlActResmH_Search( id, tbl );
	GF_ASSERT( head != NULL && "fldobj resm add res search error" );
	
	res = RESM_AddRes( resm, head->path, id, HEAPID_FIELD );
	GF_ASSERT( res != NULL && "fldobj resm add error" );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * w肳ꂽRES_MANAGER_PTRAIDAFIELD_OBJ_RESMHo^ Noraml
 * @param	resm	RES_MANAGER_PTR
 * @param	id		o^ID
 * @param	tbl		FIELD_OBJ_RESMH
 * @retval	int		TRUE=o^BFALSE=o^ς
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_AddResNormalTbl(
		RES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMH *tbl )
{
	void *file_ram;
	RES_OBJ_PTR res;
	const FIELD_OBJ_RESMH *head;
	
	if( RESM_CheckID(resm,id) == FALSE ){
		return( FALSE );
	}
	
	head = FldOBJ_BlActResmH_Search( id, tbl );
	GF_ASSERT( head != NULL && "fldobj resm add res search error" );
	
	file_ram = sys_LoadFile( HEAPID_FIELD, head->path );
	res = RESM_AddResNormal( resm, file_ram, id );
	GF_ASSERT( res != NULL && "fldobj resm add error" );
	
	return( TRUE );
}

//--------------------------------------------------------------
/**
 * w肳ꂽTEXRES_MANAGER_PTRAIDAFIELD_OBJ_RESMHo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	resm	TEXRES_MANAGER_PTR
 * @param	id		o^ID
 * @param	tbl		FIELD_OBJ_RESMH
 * @retval	int		ADDRES_FALSE
 */
//--------------------------------------------------------------
static int FldOBJ_BlActTexResm_AddResTbl( FIELD_OBJ_BLACT_CONT *cont,
		TEXRES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMH *tbl )
{
	TEXRES_OBJ_PTR res;
	const FIELD_OBJ_RESMH *head;
	
	if( TEXRESM_CheckID(resm,id) == FALSE ){
		return( ADDRES_FALSE );
	}
	
	head = FldOBJ_BlActResmH_Search( id, tbl );
	
	if( head == NULL ){
		return( ADDRES_NOTBLACT );
	}
	
	res = TEXRESM_AddAndAllocVramKeyRes( resm, head->path, id, HEAPID_FIELD );
	GF_ASSERT( res != NULL && "fldobj tex resm add error" );
	
	FldOBJ_VIntrTcb_TexLoadAdd( cont, resm, id );
	
	return( ADDRES_TRUE );
}

//--------------------------------------------------------------
/**
 * w肳ꂽTEXRES_MANAGER_PTRAIDAFIELD_OBJ_RESMNARCo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	resm	TEXRES_MANAGER_PTR
 * @param	id		o^ID
 * @param	tbl		FIELD_OBJ_RESMNARC
 * @retval	int		ADDRES_FALSE
 */
//--------------------------------------------------------------
static int FldOBJ_BlActTexResmNArc_AddResTbl( FIELD_OBJ_BLACT_CONT *cont,
		TEXRES_MANAGER_PTR resm, int id, const FIELD_OBJ_RESMNARC *tbl )
{
	TEXRES_OBJ_PTR res;
	const FIELD_OBJ_RESMNARC *head;
	
	if( TEXRESM_CheckID(resm,id) == FALSE ){
		return( ADDRES_FALSE );
	}
	
	head = FldOBJ_BlActResmNArc_Search( id, OBJCODEMAX, tbl );
	
	if( head == NULL ){
		return( ADDRES_NOTBLACT );
	}
	
	{
		void *arc_ptr = ArchiveDataLoadMallocLo( ARC_MMODEL, head->narc_id, HEAPID_FIELD );
		res = TEXRESM_AddAndAllocVramKeyResNormal( resm, arc_ptr, id );
		GF_ASSERT( res != NULL && "fldobj tex resm add error" );
	}
	
	FldOBJ_VIntrTcb_TexLoadAdd( cont, resm, id );
	
	return( ADDRES_TRUE );
}

//--------------------------------------------------------------
/**
 * M[eNX`o^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_RegularAdd_Tex( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int ret;
	TEXRES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_TexResManageGet( cont );
//	ret = FldOBJ_BlActTexResm_AddResTbl( cont, resm, id, DATA_FieldOBJ_ResmH_Tex );
	ret = FldOBJ_BlActTexResmNArc_AddResTbl( cont, resm, id, DATA_FieldOBJ_ResmNArcTbl_Tex );
	
	if( ret != ADDRES_NOTBLACT ){
		FldOBJ_BlActResm_TexIDReg_Regular( cont, id );
	}
}

//--------------------------------------------------------------
/**
 * M[eNX`o^@O[o
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	id		o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActResmRegularAdd_Tex( CONST_FIELD_OBJ_SYS_PTR fos, int id )
{
	RES_MANAGER_PTR resm;
	FIELD_OBJ_BLACT_CONT *cont;
	
	cont = (FIELD_OBJ_BLACT_CONT *)FieldOBJSys_BlActContGet( fos );
	
	if( FldOBJ_BlActResm_TexIDSearch_Regular(cont,id) == FALSE ){
		FldOBJ_BlActResm_RegularAdd_Tex( cont, id );
	}else{
		OS_Printf( "FieldOBJ_BlActResmRegularAdd_Tex()o^ς݂ł\n" );
	}
}

//--------------------------------------------------------------
/**
 * M[eNX`폜
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	id		폜ID
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActResmRegularDelete_Tex( CONST_FIELD_OBJ_SYS_PTR fos, int id )
{
	int max;
	int *tbl;
	FIELD_OBJ_BLACT_CONT *cont;
	
	cont = (FIELD_OBJ_BLACT_CONT *)FieldOBJSys_BlActContGet( fos );
	TEXRESM_DeleteResID( FieldOBJ_BlActCont_TexResManageGet(cont), id );
	
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	max = FldOBJ_BlActCont_RegularTexMaxGet( cont );
	FldOBJ_BlActResm_IDTblDel( tbl, id, OBJCODEMAX, max );
}

//--------------------------------------------------------------
/**
 * QXgeNX`o^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_GuestAdd_Tex( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int ret;
	TEXRES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_TexResManageGet( cont );
	
//	ret = FldOBJ_BlActTexResm_AddResTbl( cont, resm, id, DATA_FieldOBJ_ResmH_Tex );
	ret = FldOBJ_BlActTexResmNArc_AddResTbl( cont, resm, id, DATA_FieldOBJ_ResmNArcTbl_Tex );
	
	if( ret != ADDRES_NOTBLACT ){
		FldOBJ_BlActResm_TexIDReg_Guest( cont, id );
	}
}

//--------------------------------------------------------------
/**
 * M[eNX`o^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	tbl		o^IDZ߂ꂽe[u
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_RegularAddTbl_Tex( FIELD_OBJ_BLACT_CONT *cont, const int *tbl )
{
	while( (*tbl) != OBJCODEMAX ){
		FldOBJ_BlActResm_RegularAdd_Tex( cont, (*tbl) );
		tbl++;
	}
}

//--------------------------------------------------------------
/**
 * w肳ꂽOBJR[hTEXRES_OBJ_PTR擾
 * @param	fsys	FIELD_OBJ_SYS
 * @param	code	OBJR[h HERO
 * @retval	TEXRES_OBJ_PTR	NULL=o^ĂȂ
 */
//--------------------------------------------------------------
TEXRES_OBJ_PTR FieldOBJ_BlActResm_TexResOBJPTRGet( CONST_FIELD_OBJ_SYS_PTR fos, int code )
{
	TEXRES_MANAGER_PTR resm;
	TEXRES_OBJ_PTR reso;
	FIELD_OBJ_BLACT_CONT *cont;
	
	cont = (FIELD_OBJ_BLACT_CONT *)FieldOBJSys_BlActContGet( fos );
	
	resm = FieldOBJ_BlActCont_TexResManageGet( cont );
	reso = TEXRESM_GetResObj( resm, code );
	
	return( reso );
}

//--------------------------------------------------------------
/**
 * M[fo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_RegularAdd_Mdl( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	RES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_MdlResManageGet( cont );
//	FldOBJ_BlActResm_AddResTbl( resm, id, DATA_FieldOBJ_ResmH_Mdl );
	FldOBJ_BlActResmNArc_AddResTbl( resm, id, BLACT_MDLID_MAX, DATA_FieldOBJ_ResmNArcTbl_Mdl );
	FldOBJ_BlActResm_MdlIDReg_Regular( cont, id );
}

//--------------------------------------------------------------
/**
 * QXgfo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_GuestAdd_Mdl( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	RES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_MdlResManageGet( cont );
//	FldOBJ_BlActResm_AddResTbl( resm, id, DATA_FieldOBJ_ResmH_Mdl );
	FldOBJ_BlActResmNArc_AddResTbl( resm, id, BLACT_MDLID_MAX, DATA_FieldOBJ_ResmNArcTbl_Mdl );
	FldOBJ_BlActResm_MdlIDReg_Guest( cont, id );
}

//--------------------------------------------------------------
/**
 * M[fo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	tbl		o^IDZ߂ꂽe[u
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_RegularAddTbl_Mdl( FIELD_OBJ_BLACT_CONT *cont, const int *tbl )
{
	while( (*tbl) != BLACT_MDLID_MAX ){
		FldOBJ_BlActResm_RegularAdd_Mdl( cont, (*tbl) );
		tbl++;
	}
}

//--------------------------------------------------------------
/**
 * M[Ajo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_RegularAdd_Anm( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	RES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_AnmResManageGet( cont );
	FldOBJ_BlActResm_AddResNormalTbl( resm, id, DATA_FieldOBJ_ResmH_Anm );
	FldOBJ_BlActResm_AnmIDReg_Regular( cont, id );
}

//--------------------------------------------------------------
/**
 * QXgAjo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_GuestAdd_Anm( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	RES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_AnmResManageGet( cont );
	FldOBJ_BlActResm_AddResNormalTbl( resm, id, DATA_FieldOBJ_ResmH_Anm );
	FldOBJ_BlActResm_AnmIDReg_Guest( cont, id );
}

//--------------------------------------------------------------
/**
 * M[Ajo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	tbl		o^IDZ߂ꂽe[u
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_RegularAddTbl_Anm( FIELD_OBJ_BLACT_CONT *cont, const int *tbl )
{
	while( (*tbl) != BLACT_ANMID_MAX ){
		FldOBJ_BlActResm_RegularAdd_Anm( cont, (*tbl) );
		tbl++;
	}
}

//--------------------------------------------------------------
/**
 * M[ēo^
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	tex_tbl	M[eNX`
 * @param	mdl_tbl	M[eNX`
 * @param	anm_tbl	M[eNX`
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_RegularAdd_All(
	FIELD_OBJ_BLACT_CONT *cont, const int *tex_tbl, const int *mdl_tbl, const int *anm_tbl )
{
	FldOBJ_BlActResm_RegularAddTbl_Tex( cont, tex_tbl );
	FldOBJ_BlActResm_RegularAddTbl_Mdl( cont, mdl_tbl );
	FldOBJ_BlActResm_RegularAddTbl_Anm( cont, anm_tbl );
}

//--------------------------------------------------------------
/**
 * \[XIDǗ@
 * @param	tbl		IDe[u@*
 * @param	init_id	ID
 * @param	max		
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_IDTblInit( int *tbl, int init_id, int max )
{
	do{
		*tbl = init_id;
		tbl++;
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * \[XIDǗ@o^
 * @param	tbl		IDe[u@*
 * @param	reg_id	o^ID
 * @param	spc_id@ID
 * @param	max		
 * @retval	int		TRUE=o^@FALSE=󂫖
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_IDTblReg( int *tbl, int reg_id, int spc_id, int max )
{
	do{
		if( (*tbl) == spc_id ){
			*tbl = reg_id;
			return( TRUE );
		}
		
		tbl++;
		max--;
	}while( max );
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * \[XIDǗ@
 * @param	tbl		IDe[u@*
 * @param	chk_id	ID
 * @param	max		
 * @retval	int		TRUE=o^A@FALSE=o^iV
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_IDTblSearch( int *tbl, int chk_id, int max )
{
	do{
		if( (*tbl) == chk_id ){
			return( TRUE );
		}
		
		tbl++;
		max--;
	}while( max );
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * \[XIDǗ@폜
 * @param	tbl		IDe[u@*
 * @param	del_id		폜ID
 * @param	spc_id	폜̋ID
 * @param	max		
 * @retval	int		TRUE=폜@FALSE=o^iV
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_IDTblDel( int *tbl, int del_id, int spc_id, int max )
{
	do{
		if( (*tbl) == del_id ){
			*tbl = spc_id;
			return( TRUE );
		}
		
		tbl++;
		max--;
	}while( max );
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * f\[XIDǗ@e[u
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_MdlIDInit( FIELD_OBJ_BLACT_CONT *cont )
{
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmMdlIDTblGet( cont );
	FldOBJ_BlActResm_IDTblInit( tbl, BLACT_MDLID_MAX, FLDOBJ_RESM_MAX_MDL );
}

//--------------------------------------------------------------
/**
 * f\[XIDǗ@M[o^B
 * 󂫂ꍇGF_ASSERT()
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_MdlIDReg_Regular( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max,ret;
	int *tbl;
	
	max = FldOBJ_BlActCont_RegularMdlMaxGet( cont );
	tbl = FldOBJ_BlActCont_ResmMdlIDTblGet( cont );
	
	ret = FldOBJ_BlActResm_IDTblReg( tbl, id, BLACT_MDLID_MAX, max );
	GF_ASSERT( ret != FALSE && "fldobj FldOBJ_BlActResm_RegRegID MAX" );
}

//--------------------------------------------------------------
/**
 * f\[XIDǗ@M[
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			ID
 * @retval	int			TRUE=o^ςID FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_MdlIDSearch_Regular( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	max = FldOBJ_BlActCont_RegularMdlMaxGet( cont );
	tbl = FldOBJ_BlActCont_ResmMdlIDTblGet( cont );
	return( FldOBJ_BlActResm_IDTblSearch(tbl,id,max) );
}

//--------------------------------------------------------------
/**
 * f\[XIDǗ@QXgo^B
 * 󂫂ꍇGF_ASSERT()
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_MdlIDReg_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int ret,max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmMdlIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularMdlMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestMdlMaxGet( cont );
	ret = FldOBJ_BlActResm_IDTblReg( tbl, id, BLACT_MDLID_MAX, max );
	
	GF_ASSERT( ret != FALSE && "fldobj FldOBJ_BlActResm_RegIDGuest MAX" );
}

//--------------------------------------------------------------
/**
 * f\[XIDǗ@QXg
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			ID
 * @retval	int			TRUE=o^ςID FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_MdlIDSearch_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmMdlIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularMdlMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestMdlMaxGet( cont );
	
	return( FldOBJ_BlActResm_IDTblSearch(tbl,id,max) );
}

//--------------------------------------------------------------
/**
 * f\[XIDǗ@QXg폜
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			폜ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_MdlIDDelete_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmMdlIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularMdlMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestMdlMaxGet( cont );
	
	FldOBJ_BlActResm_IDTblDel( tbl, id, BLACT_MDLID_MAX, max );
}

//--------------------------------------------------------------
/**
 * f\[XIDǗ@SQXg폜BOBJŎgpĂꍇ͍폜
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_MdlIDDelete_GuestAll(
		FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_BLACT_CONT *cont )
{
	int max;
	int *tbl;
	RES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_MdlResManageGet( cont );
	tbl = FldOBJ_BlActCont_ResmMdlIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularMdlMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestMdlMaxGet( cont );
	
	do{
		if( (*tbl) != BLACT_MDLID_MAX ){
			if( FldOBJ_BlActCont_FldOBJSearch_MdlID(fos,(*tbl)) == FALSE ){
				OS_Printf( "QXgf폜܂ ID=%x\n", *tbl );
				RESM_DeleteResID( resm, *tbl );
			}
		}
		
		*tbl = BLACT_MDLID_MAX;
		tbl++;
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * Aj\[XIDǗ@e[u
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_AnmIDInit( FIELD_OBJ_BLACT_CONT *cont )
{
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmAnmIDTblGet( cont );
	FldOBJ_BlActResm_IDTblInit( tbl, BLACT_ANMID_MAX, FLDOBJ_RESM_MAX_ANM );
}

//--------------------------------------------------------------
/**
 * Aj\[XIDǗ@M[o^B
 * 󂫂ꍇGF_ASSERT()
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_AnmIDReg_Regular( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max,ret;
	int *tbl;
	
	max = FldOBJ_BlActCont_RegularAnmMaxGet( cont );
	tbl = FldOBJ_BlActCont_ResmAnmIDTblGet( cont );
	
	ret = FldOBJ_BlActResm_IDTblReg( tbl, id, BLACT_ANMID_MAX, max );
	GF_ASSERT( ret != FALSE && "fldobj FldOBJ_BlActResm_RegRegID MAX" );
}

//--------------------------------------------------------------
/**
 * Aj\[XIDǗ@M[
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			ID
 * @retval	int			TRUE=o^ςID FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_AnmIDSearch_Regular( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	max = FldOBJ_BlActCont_RegularAnmMaxGet( cont );
	tbl = FldOBJ_BlActCont_ResmAnmIDTblGet( cont );
	return( FldOBJ_BlActResm_IDTblSearch(tbl,id,max) );
}

//--------------------------------------------------------------
/**
 * Aj\[XIDǗ@QXgo^B
 * 󂫂ꍇGF_ASSERT()
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_AnmIDReg_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int ret,max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmAnmIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularAnmMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestAnmMaxGet( cont );
	ret = FldOBJ_BlActResm_IDTblReg( tbl, id, BLACT_ANMID_MAX, max );
	
	GF_ASSERT( ret != FALSE && "fldobj FldOBJ_BlActResm_RegIDGuest MAX" );
}

//--------------------------------------------------------------
/**
 * Aj\[XIDǗ@QXg
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			ID
 * @retval	int			TRUE=o^ςID FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_AnmIDSearch_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmAnmIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularAnmMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestAnmMaxGet( cont );
	return( FldOBJ_BlActResm_IDTblSearch(tbl,id,max) );
}

//--------------------------------------------------------------
/**
 * Aj\[XIDǗ@QXg폜
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			폜ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_AnmIDDelete_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmAnmIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularAnmMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestAnmMaxGet( cont );
	
	FldOBJ_BlActResm_IDTblDel( tbl, id, BLACT_ANMID_MAX, max );
}

//--------------------------------------------------------------
/**
 * Aj\[XIDǗ@SQXg폜@OBJŎgpĂꍇ͍폜Ȃ
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_AnmIDDelete_GuestAll(
		FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_BLACT_CONT *cont )
{
	int max;
	int *tbl;
	RES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_AnmResManageGet( cont );
	tbl = FldOBJ_BlActCont_ResmAnmIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularAnmMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestAnmMaxGet( cont );
	
	do{
		if( (*tbl) != BLACT_ANMID_MAX ){
			if( FldOBJ_BlActCont_FldOBJSearch_AnmID(fos,(*tbl)) == FALSE ){
				OS_Printf( "QXgAj폜܂ ID=%x\n", *tbl );
				RESM_DeleteResID( resm, *tbl );
			}
		}
		
		*tbl = BLACT_ANMID_MAX;
		tbl++;
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * eNX`\[XIDǗ@e[u
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_TexIDInit( FIELD_OBJ_BLACT_CONT *cont )
{
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	FldOBJ_BlActResm_IDTblInit( tbl, OBJCODEMAX, FLDOBJ_RESM_MAX_TEX );
}

//--------------------------------------------------------------
/**
 * eNX`\[XIDǗ@M[o^B
 * 󂫂ꍇGF_ASSERT()
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_TexIDReg_Regular( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max,ret;
	int *tbl;
	
	max = FldOBJ_BlActCont_RegularTexMaxGet( cont );
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	
	ret = FldOBJ_BlActResm_IDTblReg( tbl, id, OBJCODEMAX, max );
	GF_ASSERT( ret != FALSE && "fldobj FldOBJ_BlActResm_RegRegID MAX" );
}

//--------------------------------------------------------------
/**
 * eNX`\[X\[XIDǗ@M[
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			ID
 * @retval	int			TRUE=o^ςID FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_TexIDSearch_Regular( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	max = FldOBJ_BlActCont_RegularTexMaxGet( cont );
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	return( FldOBJ_BlActResm_IDTblSearch(tbl,id,max) );
}

//--------------------------------------------------------------
/**
 * eNX`\[XIDǗ@QXgo^B
 * 󂫂ꍇGF_ASSERT()
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			o^ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_TexIDReg_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int ret,max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularTexMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestTexMaxGet( cont );
	ret = FldOBJ_BlActResm_IDTblReg( tbl, id, OBJCODEMAX, max );
	
	GF_ASSERT( ret != FALSE && "fldobj FldOBJ_BlActResm_RegIDGuest MAX" );
}

//--------------------------------------------------------------
/**
 * eNX`\[XIDǗ@QXg폜
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			폜ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_TexIDDelete_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularTexMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestTexMaxGet( cont );
	
	FldOBJ_BlActResm_IDTblDel( tbl, id, OBJCODEMAX, max );
}

//--------------------------------------------------------------
/**
 * eNX`\[XIDǗ@SQXg폜BĂOBJŎgpĂꍇ͍폜Ȃ
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResm_TexIDDelete_GuestAll(
		FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_BLACT_CONT *cont )
{
	int max;
	int *tbl;
	TEXRES_MANAGER_PTR resm;
	
	resm = FieldOBJ_BlActCont_TexResManageGet( cont );
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularTexMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestTexMaxGet( cont );
	
	do{
		if( (*tbl) != OBJCODEMAX ){
			if( FldOBJ_BlActCont_FldOBJSearch_OBJCode(fos,(*tbl)) == FALSE ){
				OS_Printf( "QXgeNX`폜܂ ID=%x\n", *tbl );
				TEXRESM_DeleteResID( resm, *tbl );
			}
		}
		
		*tbl = OBJCODEMAX;
		tbl++;
		max--;
	}while( max );
}

//--------------------------------------------------------------
/**
 * eNX`\[X\[XIDǗ@QXg
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	id			ID
 * @retval	int			TRUE=o^ςID FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResm_TexIDSearch_Guest( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int max;
	int *tbl;
	
	tbl = FldOBJ_BlActCont_ResmTexIDTblGet( cont );
	tbl = &tbl[FldOBJ_BlActCont_RegularTexMaxGet(cont)];
	max = FldOBJ_BlActCont_GuestTexMaxGet( cont );
	
	return( FldOBJ_BlActResm_IDTblSearch(tbl,id,max) );
}

//--------------------------------------------------------------
/**
 * w肳ꂽOBJR[h̃M[AQXgo^ς݃`FbN
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	code	OBJR[hBHERO
 * @retval	int		REGULAR
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResManage_OBJCodeRegistCheck( FIELD_OBJ_BLACT_CONT *cont, int code )
{
	if( FldOBJ_BlActResm_TexIDSearch_Regular(cont,code) == TRUE ){
		return( REGULAR );
	}
	
	if( FldOBJ_BlActResm_TexIDSearch_Guest(cont,code) == TRUE ){
		return( GUEST );
	}
	
	return( NOT_REGULAR_GUEST );
}

//--------------------------------------------------------------
/**
 * w肳ꂽfID̃M[AQXgo^ς݃`FbN
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		BLACT_MDLID_32x32
 * @retval	int		REGULAR
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResManage_MdlIDRegistCheck( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	if( FldOBJ_BlActResm_MdlIDSearch_Regular(cont,id) == TRUE ){
		return( REGULAR );
	}
	
	if( FldOBJ_BlActResm_MdlIDSearch_Guest(cont,id) == TRUE ){
		return( GUEST );
	}
	
	return( NOT_REGULAR_GUEST );
}

//--------------------------------------------------------------
/**
 * w肳ꂽAjID̃M[AQXgo^ς݃`FbN
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		BLACT_ANMID_32x32
 * @retval	int		REGULAR
 */
//--------------------------------------------------------------
static int FldOBJ_BlActResManage_AnmIDRegistCheck( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	if( FldOBJ_BlActResm_AnmIDSearch_Regular(cont,id) == TRUE ){
		return( REGULAR );
	}
	
	if( FldOBJ_BlActResm_AnmIDSearch_Guest(cont,id) == TRUE ){
		return( GUEST );
	}
	
	return( NOT_REGULAR_GUEST );
}

//--------------------------------------------------------------
/**
 * w肳ꂽOBJR[h̓o^B
 * M[AQXg`FbNsAM[Ŗꍇ̓QXgƂēo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	code	OBJR[hBHERO
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResManage_OBJCodeRegist( FIELD_OBJ_BLACT_CONT *cont, int code )
{
	if( FldOBJ_BlActResManage_OBJCodeRegistCheck(cont,code) == NOT_REGULAR_GUEST ){
		OS_Printf( "QXgeNX`o^\n" );
		FldOBJ_BlActResm_GuestAdd_Tex( cont, code );
	}
}

//--------------------------------------------------------------
/**
 * w肳ꂽfID̓o^B
 * M[AQXg`FbNsAM[Ŗꍇ̓QXgƂēo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		BLACT_MDLID_32x32
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResManage_MdlIDRegist( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	if( FldOBJ_BlActResManage_MdlIDRegistCheck(cont,id) == NOT_REGULAR_GUEST ){
		OS_Printf( "QXgfo^\n" );
		FldOBJ_BlActResm_GuestAdd_Mdl( cont, id );
	}
}

//--------------------------------------------------------------
/**
 * w肳ꂽAjID̓o^B
 * M[AQXg`FbNsAM[Ŗꍇ̓QXgƂēo^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		BLACT_ANMID_NORMAL_0
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResManage_AnmIDRegist( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	if( FldOBJ_BlActResManage_AnmIDRegistCheck(cont,id) == NOT_REGULAR_GUEST ){
		OS_Printf( "QXgAjo^\n" );
		FldOBJ_BlActResm_GuestAdd_Anm( cont, id );
	}
}

//--------------------------------------------------------------
/**
 * OBJR[hAfAeNX`AAj̃M[AQXg`FbNB
 * o^ĂȂӏ΃QXgƂēo^B
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	code	OBJR[hBHERO
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActResManage_AllIDRegist( FIELD_OBJ_BLACT_CONT *cont, int code )
{
	int ret;
	
	ret = FldOBJ_BlActH_OBJCode_MdlID( code );
	FldOBJ_BlActResManage_MdlIDRegist( cont, ret );
	
	ret = FldOBJ_BlActH_OBJCode_AnmID( code );
	FldOBJ_BlActResManage_AnmIDRegist( cont, ret );
	
	FldOBJ_BlActResManage_OBJCodeRegist( cont, code );
}

//--------------------------------------------------------------
/**
 * QXgeNX`AfAAjSč폜
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_ResmGuestDeleteAll( FIELD_OBJ_SYS_PTR fos, FIELD_OBJ_BLACT_CONT *cont )
{
	FldOBJ_BlActResm_MdlIDDelete_GuestAll( fos, cont );
	FldOBJ_BlActResm_AnmIDDelete_GuestAll( fos, cont );
	FldOBJ_BlActResm_TexIDDelete_GuestAll( fos, cont );
}

//--------------------------------------------------------------
/**
 * tB[hOBJOBJR[h
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	code	OBJR[h
 * @retval	int		TRUE=vA FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_FldOBJSearch_OBJCode( FIELD_OBJ_SYS_PTR fos, int code )
{
	int no = 0;
	FIELD_OBJ_PTR fldobj = NULL;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&no,FLDOBJ_STA_BIT_USE) == TRUE ){
		int check_code = FieldOBJ_OBJCodeGet( fldobj );
		
		if( FieldOBJ_OBJCodeSeedCheck(check_code) == TRUE ){
			check_code = FieldOBJ_OBJCodeSeedGet( fldobj );
		}
		
		if( check_code == code ){
			return( TRUE );
		}
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ̃fID
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	mdl_id	f ID
 * @retval	int		TRUE=vA FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_FldOBJSearch_MdlID( FIELD_OBJ_SYS_PTR fos, int mdl_id )
{
	int no = 0;
	FIELD_OBJ_PTR fldobj = NULL;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&no,FLDOBJ_STA_BIT_USE) == TRUE ){
		int code = FieldOBJ_OBJCodeGet( fldobj );
		
		if( FieldOBJ_OBJCodeSeedCheck(code) == TRUE ){
			code = FieldOBJ_OBJCodeSeedGet( fldobj );
		}
		
		if( FldOBJ_BlActH_OBJCode_MdlID(code) == mdl_id ){
			return( TRUE );
		}
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * tB[hOBJ̃AjID
 * @param	fos		FIELD_OBJ_SYS_PTR
 * @param	anm_id	Aj ID
 * @retval	int		TRUE=vA FALSE=v
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_FldOBJSearch_AnmID( FIELD_OBJ_SYS_PTR fos, int anm_id )
{
	int no = 0;
	FIELD_OBJ_PTR fldobj = NULL;
	
	while( FieldOBJSys_FieldOBJSearch(fos,&fldobj,&no,FLDOBJ_STA_BIT_USE) == TRUE ){
		int code = FieldOBJ_OBJCodeGet( fldobj );
		
		if( FieldOBJ_OBJCodeSeedCheck(code) == TRUE ){
			code = FieldOBJ_OBJCodeSeedGet( fldobj );
		}
		
		if( FldOBJ_BlActH_OBJCode_AnmID(code) == anm_id ){
			return( TRUE );
		}
	}
	
	return( FALSE );
}

//==============================================================================
//	VIntr^XN
//==============================================================================
//--------------------------------------------------------------
/**
 * VIntr TCBǉ
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		VuN荞ݒɓ]o񐔍ő
 * @param	pri		VIntrTCBvCIeB
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActVIntrTcbAdd( FIELD_OBJ_BLACT_CONT *cont, int max, int pri )
{
	int size;
	TCB_PTR tcb;
	VINTR_WORK *work;
	
	{
		TCB_PTR check_tcb = FldOBJ_BlActContVIntrTcbPtrGet( cont );
		GF_ASSERT( check_tcb == NULL &&						//NULL̂͂
			"FldOBJ_BlActVIntrTcbAdd() `폜ςłȂ̂ tB[hOBJ`揉?\n" );
	}
	
	work = sys_AllocMemory( HEAPID_FIELD, VINTR_WORK_SIZE );
	GF_ASSERT( work != NULL && "FldOBJ_BlActVIntrTcbAdd()mێs" );
	memset( work, 0, VINTR_WORK_SIZE );
	
	work->max = max;
	work->cont = cont;
	
	size = sizeof( TEXRES_MANAGER_PTR ) * max;
	work->resm_tex_tbl = sys_AllocMemory( HEAPID_FIELD, size );
	GF_ASSERT( work->resm_tex_tbl != NULL && "FldOBJ_BlActVIntrTcbAdd()TEXe[umێs" );
	memset( work->resm_tex_tbl, NULL, size );
	
	size = sizeof( int ) * max;
	work->resm_tex_id_tbl = sys_AllocMemory( HEAPID_FIELD, size );
	GF_ASSERT( work->resm_tex_id_tbl != NULL && "FldOBJ_BlActVIntrTcbAdd()IDe[umێs" );
	memset( work->resm_tex_id_tbl, 0, size );
	
	tcb = VIntrTCB_Add( FldOBJ_VIntrTcb, work, pri );
	GF_ASSERT( tcb != NULL && "FldOBJ_BlActVIntrTcbAdd()TCBǉs" );
	
	FldOBJ_BlActContVIntrTcbPtrSet( cont, tcb );
}

//--------------------------------------------------------------
/**
 * VIntr TCB폜
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActVIntrTcbDelete( FIELD_OBJ_BLACT_CONT *cont )
{
	TCB_PTR tcb;
	VINTR_WORK *work;
	
	tcb = FldOBJ_BlActContVIntrTcbPtrGet( cont );
	
	if( tcb == NULL ){
		return;
	}
	
	work = TCB_GetWork( tcb );
	TCB_Delete( tcb );
	
	sys_FreeMemory( HEAPID_FIELD, work->resm_tex_id_tbl );
	sys_FreeMemory( HEAPID_FIELD, work->resm_tex_tbl );
	sys_FreeMemory( HEAPID_FIELD, work );
	
	FldOBJ_BlActContVIntrTcbPtrSet( cont, NULL );
}

//--------------------------------------------------------------
/**
 * TCB VuN
 * @param	tcb		TCB_PTR
 * @param	work	tcb work *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_VIntrTcb( TCB_PTR tcb, void *wk )
{
	int i,count;
	VINTR_WORK *work;
	
	work = wk;
	GF_ASSERT( work != NULL && "FldOBJ_VIntrTcb()[Nُ" );
	
	if( work->access_flag == TRUE ){
		OS_Printf( "FldOBJ_VIntrTcb()ANZXɊ荞ݏ܂\n" );
		return;
	}
	
	i = 0;
	count = 0;
	
	do{
		GF_ASSERT( work != NULL && "FldOBJ_VIntrTcb()[NNULL" );
			
		if( work->resm_tex_tbl[i] != NULL ){
			TEXRESM_TexLoadAndCutTexID( work->resm_tex_tbl[i], work->resm_tex_id_tbl[i] );
			GF_ASSERT( work != NULL && "FldOBJ_VIntrTcb()[Nɕω" );
			
			work->resm_tex_tbl[i] = NULL;						//
			count++;
			
			if( count >= FLDOBJ_BLACT_VINTR_TEX_LOAD_MAX ){		//1sync]ʍő
				OS_Printf( "tB[hOBJ eNX`[]ő𒴂Ă܂\n" );
				break;
			}
		}
		
		i++;
	}while( i < work->max );
}

//--------------------------------------------------------------
/**
 * TEXRESM_TexLoad() VuN֓o^
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	resm	TEXRES_MANAGER_PTR
 * @param	id		]eNX`ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_VIntrTcb_TexLoadAdd(
		FIELD_OBJ_BLACT_CONT *cont, TEXRES_MANAGER_PTR resm, int id )
{
	int i;
	TCB_PTR tcb;
	VINTR_WORK *work;
	
	tcb = FldOBJ_BlActContVIntrTcbPtrGet( cont );
	
	GF_ASSERT( tcb != NULL && "FldOBJ_VIntrTcb_TexLoadAdd()TCBǉŎs" );
	
	work = TCB_GetWork( tcb );
	
	work->access_flag = TRUE;
	
	i = 0;
	
	do{
		if( work->resm_tex_tbl[i] == NULL ){
			work->resm_tex_tbl[i] = resm;
			work->resm_tex_id_tbl[i] = id;
			break;
		}
		
		i++;
	}while( i < work->max );
	
	GF_ASSERT( i < work->max && "FldOBJ_VIntrTcb_TexLoadAdd()eNX`]ő吔z" );
	work->access_flag = FALSE;
}

//--------------------------------------------------------------
/**
 * TEXRESM_TexLoad() VuN֓o^ĂmLZ
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	id		o^eNX`ID
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_VIntrTcb_TexLoadCancel( FIELD_OBJ_BLACT_CONT *cont, int id )
{
	int i;
	TCB_PTR tcb;
	VINTR_WORK *work;
	
	OS_Printf( "LZ`FbN\n" );
	tcb = FldOBJ_BlActContVIntrTcbPtrGet( cont );
	
	GF_ASSERT( tcb != NULL && "FldOBJ_VIntrTcb_TexLoadCancel()TCBǉŎs" );
	
	work = TCB_GetWork( tcb );
	work->access_flag = TRUE;
	
	i = 0;
	
	do{
		if( work->resm_tex_tbl[i] != NULL ){
			if( work->resm_tex_id_tbl[i] == id ){
				OS_Printf( "LZ\n" );
				TEXRESM_Delete( work->resm_tex_tbl[i] );
				work->resm_tex_tbl[i] = NULL;
				break;
			}
		}
		
		i++;
	}while( i < work->max );
	
	work->access_flag = FALSE;
}

//==============================================================================
//	FIELD_OBJ_BLACT_CONTQ
//==============================================================================
//--------------------------------------------------------------
/**
 * BLACT_SET_PTRZbg
 * @param	cont		FIELD_OBJ_BLACT_CONT
 * @param	set			BLACT_SET_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_SetPtrSet( FIELD_OBJ_BLACT_CONT *cont, BLACT_SET_PTR set )
{
	cont->blact_setptr = set;
}

//--------------------------------------------------------------
/**
 * BLACT_SET_PTR擾
 * @param	cont		FIELD_OBJ_BLACT_CONT
 * @retval	BLACT_SET_PTR	BLACT_SET_PTR
 */
//--------------------------------------------------------------
BLACT_SET_PTR FieldOBJ_BlActCont_SetPtrGet( FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->blact_setptr );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[ő吔Zbg
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_MaxSet( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	cont->max = max;
}

//--------------------------------------------------------------
/**
 * r{[hAN^[ő吔擾
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	int		CfbNX
 */
//--------------------------------------------------------------
int FieldOBJ_BlActCont_MaxGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->max );
}

//--------------------------------------------------------------
/**
 * f\[X}l[Wݒ
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	mdl		RES_MANAGER_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_MdlResManageSet( FIELD_OBJ_BLACT_CONT *cont, RES_MANAGER_PTR mdl )
{
	cont->mdl_res_manage = mdl;
}

//--------------------------------------------------------------
/**
 * f\[X}l[W擾
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	RES_MANAGER_PTR	RES_MANAGER_PTR
 */
//--------------------------------------------------------------
RES_MANAGER_PTR FieldOBJ_BlActCont_MdlResManageGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->mdl_res_manage );
}

//--------------------------------------------------------------
/**
 * Aj\[X}l[Wݒ
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	anm		RES_MANAGER_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_AnmResManageSet( FIELD_OBJ_BLACT_CONT *cont, RES_MANAGER_PTR anm )
{
	cont->anm_res_manage = anm;
}

//--------------------------------------------------------------
/**
 * Aj\[X}l[W擾
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	RES_MANAGER_PTR	RES_MANAGER_PTR
 */
//--------------------------------------------------------------
RES_MANAGER_PTR FieldOBJ_BlActCont_AnmResManageGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->anm_res_manage );
}

//--------------------------------------------------------------
/**
 * eNX`\[X}l[Wݒ
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	anm		RES_MANAGER_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActCont_TexResManageSet( FIELD_OBJ_BLACT_CONT *cont, TEXRES_MANAGER_PTR tex )
{
	cont->tex_res_manage = tex;
}

//--------------------------------------------------------------
/**
 * eNX`\[X}l[W擾
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	RES_MANAGER_PTR	RES_MANAGER_PTR
 */
//--------------------------------------------------------------
TEXRES_MANAGER_PTR FieldOBJ_BlActCont_TexResManageGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->tex_res_manage );
}

//--------------------------------------------------------------
/**
 * \[XID eNX`ւ*擾
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	int		IDe[u int TCYFLDOBJ_RESM_MAX_TEX
 */
//--------------------------------------------------------------
static int * FldOBJ_BlActCont_ResmTexIDTblGet( FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_tbl_tex );
}

//--------------------------------------------------------------
/**
 * \[XID fւ*擾
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	int		IDe[u int TCYFLDOBJ_RESM_MAX_TEX
 */
//--------------------------------------------------------------
static int * FldOBJ_BlActCont_ResmMdlIDTblGet( FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_tbl_mdl );
}

//--------------------------------------------------------------
/**
 * M[ID Ajւ*擾
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	int		IDe[u int TCYFLDOBJ_RESM_MAX_TEX
 */
//--------------------------------------------------------------
static int * FldOBJ_BlActCont_ResmAnmIDTblGet( FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_tbl_anm );
}

//--------------------------------------------------------------
/**
 * M[ID őǗݒ@f
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActCont_RegularMdlMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	cont->resm_id_reg_max_mdl = max;
}

//--------------------------------------------------------------
/**
 * M[ID őǗ擾@f
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	max		ő吔
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_RegularMdlMaxGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_reg_max_mdl );
}

//--------------------------------------------------------------
/**
 * QXgID őǗݒ@f
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActCont_GuestMdlMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	cont->resm_id_gst_max_mdl = max;
}

//--------------------------------------------------------------
/**
 * QXgID őǗ擾@f
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	int		ő吔
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_GuestMdlMaxGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_gst_max_mdl );
}

//--------------------------------------------------------------
/**
 * M[ID őǗݒ@Aj
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActCont_RegularAnmMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	cont->resm_id_reg_max_anm = max;
}

//--------------------------------------------------------------
/**
 * M[ID őǗ擾@Aj
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	max		ő吔
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_RegularAnmMaxGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_reg_max_anm );
}

//--------------------------------------------------------------
/**
 * QXgID őǗݒ@Aj
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActCont_GuestAnmMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	cont->resm_id_gst_max_anm = max;
}

//--------------------------------------------------------------
/**
 * QXgID őǗ擾@Aj
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	int		ő吔
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_GuestAnmMaxGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_gst_max_anm );
}

//--------------------------------------------------------------
/**
 * M[ID őǗݒ@eNX`
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActCont_RegularTexMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	cont->resm_id_reg_max_tex = max;
}

//--------------------------------------------------------------
/**
 * M[ID őǗ擾@eNX`
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	max		ő吔
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_RegularTexMaxGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_reg_max_tex );
}

//--------------------------------------------------------------
/**
 * QXgID őǗݒ@eNX`
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @param	max		ő吔
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActCont_GuestTexMaxSet( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	cont->resm_id_gst_max_tex = max;
}

//--------------------------------------------------------------
/**
 * QXgID őǗ擾@eNX`
 * @param	cont	FIELD_OBJ_BLACT_CONT
 * @retval	int		ő吔
 */
//--------------------------------------------------------------
static int FldOBJ_BlActCont_GuestTexMaxGet( const FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->resm_id_gst_max_tex );
}

//--------------------------------------------------------------
/**
 * QXgǉǗTCB_PTRZbg
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	tcb		TCB_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActGuestAddTcbPtrSet( FIELD_OBJ_BLACT_CONT *cont, TCB_PTR tcb )
{
	cont->tcb_ptr_blact_add = tcb;
}

//--------------------------------------------------------------
/**
 * QXgǉǗTCB_PTR擾
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @retval	TCB_PTR	TCB_PTR
 */
//--------------------------------------------------------------
static TCB_PTR FldOBJ_BlActGuestAddTcbPtrGet( FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->tcb_ptr_blact_add );
}

//--------------------------------------------------------------
/**
 * VuN荞TCB_PTRZbg
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @param	tcb		TCB_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActContVIntrTcbPtrSet( FIELD_OBJ_BLACT_CONT *cont, TCB_PTR tcb )
{
	cont->tcb_ptr_vintr = tcb;
}

//--------------------------------------------------------------
/**
 * VuN荞TCB_PTR擾
 * @param	cont	FIELD_OBJ_BLACT_CONT *
 * @retval	TCB_PTR	TCB_PTR
 */
//--------------------------------------------------------------
static TCB_PTR FldOBJ_BlActContVIntrTcbPtrGet( FIELD_OBJ_BLACT_CONT *cont )
{
	return( cont->tcb_ptr_vintr );
}

//==============================================================================
//	DATA_FieldOBJ_BlActHeaderPathIDTblQ
//==============================================================================
//--------------------------------------------------------------
/**
 * DATA_FieldOBJ_BlActHeaderPathIDTbl擾
 * @param	code	OBJR[hBHERO
 * @retval	FIELD_OBJ_BLACT_HEADER_ID* DATA_FieldOBJ_BlActHeaderPathIDTbl *
 */
//--------------------------------------------------------------
static const FIELD_OBJ_BLACT_HEADER_ID * FldOBJ_BlActHeaderPathIDTblGet( int code )
{
	const FIELD_OBJ_BLACT_HEADER_ID *head = DATA_FieldOBJ_BlActHeaderPathIDTbl;
	do{ if(head->tex_id == code){return(head);} head++; }while( head->tex_id != OBJCODEMAX );
//	GF_ASSERT( code != OBJCODEMAX && "FldOBJ_BlActHeaderPathIDTblGet() OBJCODEMAX" );
	GF_ASSERT( 0 && "FldOBJ_BlActHeaderPathIDTblGet() OBJCODEMAX" );
	return( NULL );
}

//--------------------------------------------------------------
/**
 * OBJR[h烂fID擾
 * @param	code	HERO
 * @retval	int		BLACT_MDLID_32x32
 */
//--------------------------------------------------------------
static int FldOBJ_BlActH_OBJCode_MdlID( int code )
{
	const FIELD_OBJ_BLACT_HEADER_ID *tbl;
	
	tbl = FldOBJ_BlActHeaderPathIDTblGet( code );
	return( tbl->mdl_id );
};

//--------------------------------------------------------------
/**
 * OBJR[hAjID擾
 * @param	code	HERO
 * @retval	int		BLACT_ANMID_32x32
 */
//--------------------------------------------------------------
static int FldOBJ_BlActH_OBJCode_AnmID( int code )
{
	const FIELD_OBJ_BLACT_HEADER_ID *tbl;
	
	tbl = FldOBJ_BlActHeaderPathIDTblGet( code );
	return( tbl->anm_id );
};

//--------------------------------------------------------------
/**
 * OBJR[hAje[u擾
 * @param	code	HERO
 * @retval	char*	wb_[t@CpX
 */
//--------------------------------------------------------------
static const BLACT_ANIME_TBL * FldOBJ_BlActH_OBJCode_AnmTbl( int code )
{
	const FIELD_OBJ_BLACT_HEADER_ID *tbl;
	
	tbl = FldOBJ_BlActHeaderPathIDTblGet( code );
	return( tbl->anm_tbl );
};

//==============================================================================
//	r{[hAN^[p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * r{[hAN^[ǉtOZbg
 * @param	fldobj	FIELD_OBJ_PTR
 * @param	flag	TRUE=ǉ FALSE=ǉ
 * @retval	nothing
 */
//--------------------------------------------------------------
void FieldOBJ_BlActAddPracFlagSet( FIELD_OBJ_PTR fldobj, int flag )
{
	if( flag == TRUE ){
		FieldOBJ_StatusBit_ON( fldobj, FLDOBJ_STA_BIT_BLACT_ADD_PRAC );
	}else{
		FieldOBJ_StatusBit_OFF( fldobj, FLDOBJ_STA_BIT_BLACT_ADD_PRAC );
	}
}

//--------------------------------------------------------------
/**
 * r{[hAN^[ǉtÕ`FbN
 * @param	fldobj	FIELD_OBJ_PTR
 * @retval	int		TRUE=ǉ FALSE=ǉς
 */
//--------------------------------------------------------------
int FieldOBJ_BlActAddPracFlagCheck( FIELD_OBJ_PTR fldobj )
{
	if( FieldOBJ_StatusBit_Check(fldobj,FLDOBJ_STA_BIT_BLACT_ADD_PRAC) ){
		return( TRUE );
	}
	
	return( FALSE );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[
 * @param	cont			FIELD_OBJ_BLACT_CONT *
 * @param	max				AN^[ő吔
 * @retval	BLACT_SET_PTR	AN^[Zbg|C^
 */
//--------------------------------------------------------------
static void FldOBJ_BlActInit( FIELD_OBJ_BLACT_CONT *cont, int max )
{
	BLACT_SETDATA set;
	BLACT_SET_PTR setptr;
	
	set.WorkNum = max;
	set.heap	= HEAPID_FIELD;
	
	setptr = BLACT_InitSet( &set );
	FieldOBJ_BlActCont_SetPtrSet( cont, setptr );
	FieldOBJ_BlActCont_MaxSet( cont, max );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[@CfbNX폜
 * @param	set		BLACT_SET_PTR
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActDestSet( BLACT_SET_PTR set )
{
	BLACT_DestSet( set );
}

//--------------------------------------------------------------
/**
 * r{[hAN^[̒ǉ
 * @param	set			BLACT_SET_PTR
 * @param	head		BLACT_HEADER *
 * @param	vec			W
 * @retval	BLACT_WORK	BLACT_WORK_PTR , NULL=ǉs
 */
//--------------------------------------------------------------
static BLACT_WORK_PTR FldOBJ_BlActAdd(
		BLACT_SET_PTR set, const BLACT_HEADER *head, const VecFx32 *vec )
{
	int no;
	BLACT_ADD add;
	BLACT_WORK_PTR act;
	VecFx32 scale = { FX32_ONE, FX32_ONE, FX32_ONE };
	
	add.blact_s = set;
	add.pHeader = head;
	add.matrix	= *vec;
	add.scale	= scale;
	
	act = BLACT_Add( &add );
	
	if( act != NULL ){
		BLACT_AnmOffsChg( act, 0 );
		BLACT_AnmFrameSetOffs( act, 0 );
		NNS_G3dMdlSetMdlFogEnableFlagAll( BLACT_MdlResGet(act), TRUE );
		SetGlbLightMdl( BLACT_MdlResGet(act) );
	}
	
	return( act );
}

//--------------------------------------------------------------
/**
 * wb_[e[uwb_[ǂݍ
 * @param	cont		FIELD_OBJ_BLACT_CONT *
 * @param	code		HERO
 * @param	head		ǂݍݐBLACT_HEADER *
 * @retval	nothing
 */
//--------------------------------------------------------------
static void FldOBJ_BlActHeaderLoad(
		FIELD_OBJ_BLACT_CONT *cont, u32 code, BLACT_HEADER *head )
{
	{
		int id = FldOBJ_BlActH_OBJCode_MdlID( code );
		RES_MANAGER_PTR resm = FieldOBJ_BlActCont_MdlResManageGet( cont );
		RES_OBJ_PTR reso = RESM_GetResObj( resm, id );
		GF_ASSERT( reso != NULL && "FldOBJ_BlActHeaderLoad() o^ĂȂf" );
		
		head->ImdRes = RESM_GetRes( reso );
	}
	
	{
		int id = FldOBJ_BlActH_OBJCode_AnmID( code );
		RES_MANAGER_PTR resm = FieldOBJ_BlActCont_AnmResManageGet( cont );
		RES_OBJ_PTR reso = RESM_GetResObj( resm, id );
		GF_ASSERT( reso != NULL && "FldOBJ_BlActHeaderLoad() o^ĂȂAj" );
		
//		head->ItpRes = RESM_GetRes( reso );	//Aj
		TEXANM_UnPackLoadFile( RESM_GetRes(reso), &head->texanm );
	}
	
	{
		TEXRES_MANAGER_PTR resm = FieldOBJ_BlActCont_TexResManageGet( cont );
		TEXRES_OBJ_PTR reso = TEXRESM_GetResObj( resm, code );
		GF_ASSERT( reso != NULL && "FldOBJ_BlActHeaderLoad() o^ĂȂeNX`" );
		
		head->ItxRes = TEXRESM_GetResPTR( reso );
		
		{	//ݏ풓̂	]^̏ꍇNULL
			head->texKey = TEXRESM_GetTexKeyPTR( reso );
			head->tex4x4Key = TEXRESM_GetTex4x4KeyPTR( reso );
			head->plttKey = TEXRESM_GetPlttKeyPTR( reso );
		}
	}
	
	{
		head->anm = FldOBJ_BlActH_OBJCode_AnmTbl( code );
	}
}

//--------------------------------------------------------------
/**
 * FIELD_OBJFIELD_OBJ_BLACT_CONT擾
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	FIELD_OBJ_BLACT_CONT	FIELD_OBJ_BLACT_CONT *
 */
//--------------------------------------------------------------
static const FIELD_OBJ_BLACT_CONT * FldOBJ_BlActContGet( CONST_FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR sys;
	
	sys = FieldOBJ_FieldOBJSysGet( fldobj );
	return( FieldOBJSys_BlActContGet(sys) );
}

//--------------------------------------------------------------
/**
 * FIELD_OBJFIELD_OBJ_BLACT_CONT擾@[J
 * @param	fldobj	FIELD_OBJ_PTR 
 * @retval	FIELD_OBJ_BLACT_CONT	FIELD_OBJ_BLACT_CONT *
 */
//--------------------------------------------------------------
static FIELD_OBJ_BLACT_CONT * FldOBJ_BlActContGetLocal( CONST_FIELD_OBJ_PTR fldobj )
{
	CONST_FIELD_OBJ_SYS_PTR sys;
	
	sys = FieldOBJ_FieldOBJSysGet( fldobj );
	return( (FIELD_OBJ_BLACT_CONT *)FieldOBJSys_BlActContGet(sys) );
}

//==============================================================================
//	AN^[@p[c
//==============================================================================
//--------------------------------------------------------------
/**
 * tB[hOBJɊi[Ă3DWAN^[ɔfB
 * @param	dir		DIR_UP
 * @retval	BOOL	FALSE=擾s
 */
//--------------------------------------------------------------
BOOL FieldOBJ_BlActPosSet( FIELD_OBJ_PTR fldobj, BLACT_WORK_PTR act )
{
	BOOL ret;
	VecFx32 vec_pos,vec_offs,vec_out;
	
	FieldOBJ_VecPosGet( fldobj, &vec_pos );
	FieldOBJ_VecDrawOffsGet( fldobj, &vec_offs );
	FieldOBJ_VecDrawOffsOutSideGet( fldobj, &vec_out );
	
	vec_pos.x += vec_offs.x + vec_out.x + FLDOBJ_BLACT_X_GROUND_OFFS_FX32;
	vec_pos.y += vec_offs.y + vec_out.y + FLDOBJ_BLACT_Y_GROUND_OFFS_FX32;
	vec_pos.z += vec_offs.z + vec_out.z + FLDOBJ_BLACT_Z_GROUND_OFFS_FX32;
	
	BLACT_MatrixSet( act, &vec_pos );
	
	return( FALSE );
}

//==============================================================================
//	Aj[Vio[@p[c
//==============================================================================
//--------------------------------------------------------------
//	@㉺Ee[u	
//--------------------------------------------------------------
static const int DATA_BlActAnmOffsNo_WalkTbl[] =
{ 0, 1, 2, 3 };

//--------------------------------------------------------------
/**
 * AjItZbgԍ擾
 * @param	dir		DIR_UP
 * @retval	int		AjItZbgԍ
 */
//--------------------------------------------------------------
int FieldOBJ_BlActAnmOffsNo_DirWalkGet( int dir )
{
	return( DATA_BlActAnmOffsNo_WalkTbl[dir] );
}

//--------------------------------------------------------------
//	_bV@㉺Ee[u	
//--------------------------------------------------------------
static const int DATA_BlActAnmOffsNo_DashTbl[] =
{ 4, 5, 6, 7 };

//--------------------------------------------------------------
/**
 * _bVAjItZbgԍ擾
 * @param	dir		DIR_UP
 * @retval	int		AjItZbgԍ
 */
//--------------------------------------------------------------
int FieldOBJ_BlActAnmOffsNo_DirDashGet( int dir )
{
	return( DATA_BlActAnmOffsNo_DashTbl[dir] );
}

//--------------------------------------------------------------
//	Wv@㉺Ee[u	
//--------------------------------------------------------------
static const int DATA_BlActAnmOffsNo_TakeOFFTbl[] =
{ 4, 5, 4, 5 };

//--------------------------------------------------------------
/**
 * WvAjItZbgԍ擾
 * @param	dir		DIR_UP
 * @retval	int		AjItZbgԍ
 */
//--------------------------------------------------------------
int FieldOBJ_BlActAnmOffsNo_DirTakeOFFGet( int dir )
{
	return( DATA_BlActAnmOffsNo_TakeOFFTbl[dir] );
}

